(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12747,        463]
NotebookOptionsPosition[      9480,        355]
NotebookOutlinePosition[     10917,        394]
CellTagsIndexPosition[     10832,        389]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Short" :> Documentation`HelpLookup["paclet:ref/Short"], 
         "StringSkeleton" :> 
         Documentation`HelpLookup["paclet:ref/StringSkeleton"], "Shallow" :> 
         Documentation`HelpLookup["paclet:ref/Shallow"], "TotalWidth" :> 
         Documentation`HelpLookup["paclet:ref/TotalWidth"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"Short\"\>", 
      2->"\<\"StringSkeleton\"\>", 3->"\<\"Shallow\"\>", 
      4->"\<\"TotalWidth\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Skeleton", "ObjectName",
 CellID->1556],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Skeleton",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Skeleton"], "[", 
       StyleBox["n", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a sequence of ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " omitted elements in an expression printed with ",
     Cell[BoxData[
      ButtonBox["Short",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Short"]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      ButtonBox["Shallow",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Shallow"]], "InlineFormula"],
     ". The standard print form for ",
     Cell[BoxData[
      ButtonBox["Skeleton",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Skeleton"]], "InlineFormula"],
     " is ",
     Cell[BoxData[
      RowBox[{"\[LeftSkeleton]", 
       StyleBox["n", "TI"], "\[RightSkeleton]"}]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->5636]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Skeleton",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Skeleton"]], "InlineFormula"],
 " is by default printed using ",
 Cell[TextData[ButtonBox["\\[LeftSkeleton]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/LeftSkeleton"]], "InlineCharacterName"],
 " and ",
 Cell[TextData[ButtonBox["\[RightGuillemet]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RightSkeleton"]], "InlineCharacterName"],
 " characters. "
}], "Notes",
 CellID->26892],

Cell[TextData[{
 "You can reset the print form of ",
 Cell[BoxData[
  ButtonBox["Skeleton",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Skeleton"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->32347],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"\[LeftSkeleton]", 
   StyleBox["n", "TI"], "\[RightSkeleton]"}]], "InlineFormula"],
 " indicates the presence of missing information, and so generates an error \
if you try to interpret it as ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel input. "
}], "Notes",
 CellID->3695]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->28994432],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->422169156],

Cell["A skeleton object:", "ExampleText",
 CellID->636895861],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Skeleton", "[", "10", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5063800],

Cell[BoxData[
 RowBox[{"\[LeftSkeleton]", "10", "\[RightSkeleton]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->583039352]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->103986231],

Cell["An output containing a skeleton object:", "ExampleText",
 CellID->122178501],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Shallow", "[", 
  RowBox[{"Range", "[", "100", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11013200],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8", 
   ",", "9", ",", "10", ",", 
   RowBox[{"\[LeftSkeleton]", "90", "\[RightSkeleton]"}]}], "}"}]], "Output",
 ImageSize->{249, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Shallow=",
 CellID->7347010]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2528],

Cell[TextData[{
 "Shortened ",
 Cell[BoxData[
  ButtonBox["Short",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Short"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Shallow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Shallow"]], "InlineFormula"],
 " outputs contain skeleton objects:"
}], "ExampleText",
 CellID->92603155],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Short", "[", 
  RowBox[{"Range", "[", "100", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->33117029],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
   "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8", 
    ",", "9", ",", "10", ",", "11", ",", "12", ",", "13", ",", 
    RowBox[{"\[LeftSkeleton]", "75", "\[RightSkeleton]"}], ",", "89", ",", 
    "90", ",", "91", ",", "92", ",", "93", ",", "94", ",", "95", ",", "96", 
    ",", "97", ",", "98", ",", "99", ",", "100"}], "}"}],
  Short]], "Output",
 ImageSize->{370, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->38603395]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Shallow", "[", 
  RowBox[{"Range", "[", "100", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->253926417],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8", 
   ",", "9", ",", "10", ",", 
   RowBox[{"\[LeftSkeleton]", "90", "\[RightSkeleton]"}]}], "}"}]], "Output",
 ImageSize->{249, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//Shallow=",
 CellID->570231760]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24697],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Short",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Short"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringSkeleton",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringSkeleton"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Shallow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Shallow"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TotalWidth",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TotalWidth"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19865]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Skeleton - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 21, 10.9645904}", "context" -> "System`", 
    "keywords" -> {
     "abbreviation", "short output", "shortened expression", "LeftSkeleton", 
      "omitted", "RightSkeleton", "shallow form", "short form"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Skeleton[n] represents a sequence of n omitted elements in an expression \
printed with Short or Shallow. The standard print form for Skeleton is <<n>>. \
", "synonyms" -> {"<<", ">>", "<< >>"}, "title" -> "Skeleton", "type" -> 
    "Symbol", "uri" -> "ref/Skeleton"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4476, 156, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->28994432]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10690, 382}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 872, 19, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1495, 46, 45, 1, 70, "ObjectName",
 CellID->1556],
Cell[1543, 49, 1183, 37, 70, "Usage",
 CellID->5636]
}, Open  ]],
Cell[CellGroupData[{
Cell[2763, 91, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3241, 108, 654, 21, 70, "Notes",
 CellID->26892],
Cell[3898, 131, 206, 8, 70, "Notes",
 CellID->32347],
Cell[4107, 141, 332, 10, 70, "Notes",
 CellID->3695]
}, Closed]],
Cell[CellGroupData[{
Cell[4476, 156, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->28994432],
Cell[CellGroupData[{
Cell[4860, 170, 148, 5, 70, "ExampleSection",
 CellID->422169156],
Cell[5011, 177, 61, 1, 70, "ExampleText",
 CellID->636895861],
Cell[CellGroupData[{
Cell[5097, 182, 103, 3, 28, "Input",
 CellID->5063800],
Cell[5203, 187, 210, 6, 36, "Output",
 CellID->583039352]
}, Open  ]],
Cell[5428, 196, 125, 3, 70, "ExampleDelimiter",
 CellID->103986231],
Cell[5556, 201, 82, 1, 70, "ExampleText",
 CellID->122178501],
Cell[CellGroupData[{
Cell[5663, 206, 136, 4, 70, "Input",
 CellID->11013200],
Cell[5802, 212, 363, 10, 50, "Output",
 CellID->7347010]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6214, 228, 232, 7, 70, "ExampleSection",
 CellID->2528],
Cell[6449, 237, 346, 13, 70, "ExampleText",
 CellID->92603155],
Cell[CellGroupData[{
Cell[6820, 254, 134, 4, 70, "Input",
 CellID->33117029],
Cell[6957, 260, 562, 14, 54, "Output",
 CellID->38603395]
}, Open  ]],
Cell[CellGroupData[{
Cell[7556, 279, 137, 4, 70, "Input",
 CellID->253926417],
Cell[7696, 285, 365, 10, 50, "Output",
 CellID->570231760]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8122, 302, 311, 9, 70, "SeeAlsoSection",
 CellID->24697],
Cell[8436, 313, 949, 35, 70, "SeeAlso",
 CellID->19865]
}, Open  ]],
Cell[9400, 351, 50, 0, 70, "History"],
Cell[9453, 353, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

