(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     81520,       2971]
NotebookOptionsPosition[     67498,       2491]
NotebookOutlinePosition[     69224,       2533]
CellTagsIndexPosition[     69138,       2528]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Introduction to Dynamic" :> 
          Documentation`HelpLookup["paclet:tutorial/IntroductionToDynamic"], 
          "Generalized Input" :> 
          Documentation`HelpLookup["paclet:tutorial/GeneralizedInput"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Introduction to Dynamic\"\>",
        2->"\<\"Generalized Input\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"VerticalSlider" :> 
          Documentation`HelpLookup["paclet:ref/VerticalSlider"], 
          "Manipulator" :> Documentation`HelpLookup["paclet:ref/Manipulator"],
           "ProgressIndicator" :> 
          Documentation`HelpLookup["paclet:ref/ProgressIndicator"], "Locator" :> 
          Documentation`HelpLookup["paclet:ref/Locator"], "Animator" :> 
          Documentation`HelpLookup["paclet:ref/Animator"], "Slider2D" :> 
          Documentation`HelpLookup["paclet:ref/Slider2D"], "ColorSlider" :> 
          Documentation`HelpLookup["paclet:ref/ColorSlider"], "LocatorPane" :> 
          Documentation`HelpLookup["paclet:ref/LocatorPane"], 
          "ControlsRendering" :> 
          Documentation`HelpLookup["paclet:ref/ControlsRendering"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"VerticalSlider\"\>", 
       2->"\<\"Manipulator\"\>", 3->"\<\"ProgressIndicator\"\>", 
       4->"\<\"Locator\"\>", 5->"\<\"Animator\"\>", 6->"\<\"Slider2D\"\>", 
       7->"\<\"ColorSlider\"\>", 8->"\<\"LocatorPane\"\>", 
       9->"\<\"ControlsRendering\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Control Objects" :> 
          Documentation`HelpLookup["paclet:guide/ControlObjects"], 
          "Creating Inspectors" :> 
          Documentation`HelpLookup["paclet:guide/CreatingInspectors"], 
          "Dynamic Interactivity Language" :> 
          Documentation`HelpLookup[
           "paclet:guide/DynamicInteractivityLanguage"], 
          "Dynamic Visualization" :> 
          Documentation`HelpLookup["paclet:guide/DynamicVisualization"], 
          "Interactive Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/InteractiveManipulation"], 
          "Options & Styling for Interactive Manipulation" :> 
          Documentation`HelpLookup[
           "paclet:guide/OptionsAndStylingForInteractiveManipulation"], 
          "New in 6.0: Dynamic Interactivity" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DynamicInteractivity"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Control Objects\"\>", 
       2->"\<\"Creating Inspectors\"\>", 
       3->"\<\"Dynamic Interactivity Language\"\>", 
       4->"\<\"Dynamic Visualization\"\>", 
       5->"\<\"Interactive Manipulation\"\>", 
       6->"\<\"Options & Styling for Interactive Manipulation\"\>", 
       7->"\<\"New in 6.0: Dynamic Interactivity\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Slider", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Slider",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Slider"], "[", 
       StyleBox["x", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a slider with setting ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " in the range 0 to 1. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Slider",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Slider"], "[", 
       RowBox[{
        ButtonBox["Dynamic",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Dynamic"], "[", 
        StyleBox["x", "TI"], "]"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]takes the setting to be the dynamically updated current \
value of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", with the value of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " being reset if the slider is moved. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Slider",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Slider"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a slider with range ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Slider",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Slider"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["max", "TI"]], ",", 
          StyleBox["dx", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a slider that jumps in steps ",
     Cell[BoxData[
      StyleBox["dx", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Slider",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Slider"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["e", "TI"], 
            StyleBox["1", "TR"]], ",", 
           SubscriptBox[
            StyleBox["e", "TI"], 
            StyleBox["2", "TR"]], ",", 
           StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]represents a slider in which equally spaced intervals \
correspond to successive settings ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Slider",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Slider"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             SubscriptBox[
              StyleBox["e", "TI"], 
              StyleBox["1", "TR"]], ",", 
             SubscriptBox[
              StyleBox["w", "TI"], 
              StyleBox["1", "TR"]]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             SubscriptBox[
              StyleBox["e", "TI"], 
              StyleBox["2", "TR"]], ",", 
             SubscriptBox[
              StyleBox["w", "TI"], 
              StyleBox["2", "TR"]]}], "}"}], ",", 
           StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]uses intervals of relative widths ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["w", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " for the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->27122]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Slider",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Slider"], "[", 
   StyleBox["\[Ellipsis]", "TR"], "]"}]], "InlineFormula"],
 " displays in a notebook as a horizontal slider that can be manipulated \
interactively. "
}], "Notes",
 CellID->20757],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Slider",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Slider"], "[", 
   RowBox[{
    ButtonBox["Dynamic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Dynamic"], "[", 
    StyleBox["x", "TI"], "]"}], "]"}]], "InlineFormula"],
 " will reset the value of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " when the slider is moved; ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Slider",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Slider"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " will not. "
}], "Notes",
 CellID->12597],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Slider",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Slider"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["min", "TI"]], ",", 
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["max", "TI"]], ",", 
      StyleBox["dn", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
 " jumps to integer positions if ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["n", "TI"], 
   StyleBox["min", "TI"]]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["dn", "TI"]], "InlineFormula"],
 " are integers. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->313272786]
}], "Notes",
 CellID->12713],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Slider",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Slider"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["min", "TI"]], ",", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["max", "TI"]], ",", 
      StyleBox["dx", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
 " in general jumps to positions given by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Range",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Range"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["min", "TI"]], ",", 
    SubscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["max", "TI"]], ",", 
    StyleBox["dx", "TI"]}], "]"}]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->127649809]
}], "Notes",
 CellID->27013],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Slider",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Slider"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " represents a slider running from left to right. "
}], "Notes",
 CellID->829],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Slider",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Slider"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["max", "TI"]], ",", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["min", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
 " with ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["max", "TI"]]], "InlineFormula"],
 " > ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["min", "TI"]]], "InlineFormula"],
 " represents a slider running from right to left. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->120461931]
}], "Notes",
 CellID->27486],

Cell["\<\
If the value of the slider is outside the range given, it will be displayed \
at one of the ends. \
\>", "Notes",
 CellID->26510],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Slider",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Slider"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", 
      StyleBox["dx", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
 " displays at position ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ", even if this is not a multiple of ",
 Cell[BoxData[
  StyleBox["dx", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->6138],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Slider",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Slider"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["e", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["e", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 ", the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["e", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " can be any expressions, not just numbers. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->223367795]
}], "Notes",
 CellID->4013],

Cell["The following options can be given: ", "Notes",
 CellID->26075],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Appearance",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Appearance"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the overall appearance of the slider ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["AutoAction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AutoAction"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether to move the slider automatically when the mouse is over it \
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BaselinePosition",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaselinePosition"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "alignment relative to surrounding text", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BaseStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaseStyle"], 
    RowBox[{"{", "}"}], Cell[
    "base style specifications for the slider", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ContinuousAction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ContinuousAction"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to update continuously when the slider is moved", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Enabled",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Enabled"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether the slider is enabled, or grayed out ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Exclusions",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Exclusions"], 
    RowBox[{"{", "}"}], Cell["specific values to be excluded", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageMargins",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageMargins"], "0", Cell[
    "margins around the image of the displayed slider ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the overall image size of the displayed slider ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True, True}}}},
 CellID->25324],

Cell[TextData[{
 "Possible settings for ",
 Cell[BoxData[
  ButtonBox["Appearance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Appearance"]], "InlineFormula"],
 " include ",
 Cell[BoxData[
  ButtonBox["Tiny",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tiny"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Small",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Small"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Medium",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Medium"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Large",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Large"]], "InlineFormula"],
 ", as well as typically some other settings such as ",
 Cell[BoxData["\"\<UpArrow\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<DownArrow\>\""], "InlineFormula"],
 ". "
}], "Notes",
 CellID->1689],

Cell[TextData[{
 "The settings for ",
 Cell[BoxData[
  ButtonBox["BaseStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaseStyle"]], "InlineFormula"],
 " are appended to the default style typically given by the ",
 Cell[BoxData["\"\<Slider\>\""], "InlineFormula"],
 " style in the current stylesheet. "
}], "Notes",
 CellID->708313727],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Slider",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Slider"], "[", "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Slider",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Slider"], "[", "0.5", "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->15841]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->747621363],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->626198783],

Cell[TextData[{
 "A slider set at ",
 Cell[BoxData[
  FormBox["0.8`", TraditionalForm]], "InlineMath"],
 " in the default range ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->258827707],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Slider", "[", "0.8", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->348675845],

Cell[BoxData[
 SliderBox[0.8]], "Output",
 ImageSize->{204, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->169222830]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->297788944],

Cell["A slider with its value updated dynamically:", "ExampleText",
 CellID->186407634],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Slider", "[", 
    RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->156176220],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[Dynamic[$CellContext`x]], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{14., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{244, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->65816724]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->144900709],

Cell[TextData[{
 "A slider with integer values in the range ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox["100", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->10336265],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Slider", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "n", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "100", ",", "1"}], "}"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "n", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->129400021],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[Dynamic[$CellContext`n], {0, 100, 1}], ",", 
   DynamicBox[ToBoxes[$CellContext`n, StandardForm],
    ImageSizeCache->{7., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{237, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->539078251]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5056],

Cell[TextData[{
 "Use the range ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "1"}], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineMath"],
 ", increasing when going from left to right:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->120461931],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "0"}], ";", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Slider", "[", 
     RowBox[{
      RowBox[{"Dynamic", "[", "x", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}], ",", 
    RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->61980051],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[Dynamic[$CellContext`x], {-1, 1}], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{21.6875, {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{251, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19596566]
}, Open  ]],

Cell[TextData[{
 "A slider with range ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "1"}], TraditionalForm]], "InlineMath"],
 ", increasing when going from right to left:"
}], "ExampleText",
 CellID->211277733],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"y", "=", "0"}], ";", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Slider", "[", 
     RowBox[{
      RowBox[{"Dynamic", "[", "y", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"-", "1"}]}], "}"}]}], "]"}], ",", 
    RowBox[{"Dynamic", "[", "y", "]"}]}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->639201867],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[Dynamic[$CellContext`y], {1, -1}], ",", 
   DynamicBox[ToBoxes[$CellContext`y, StandardForm],
    ImageSizeCache->{14., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{244, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->272548611]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->118668047],

Cell["Use only integer variable values:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->313272786],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Slider", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "n", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "100", ",", "1"}], "}"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "n", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->147792433],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[Dynamic[$CellContext`n], {0, 100, 1}], ",", 
   DynamicBox[ToBoxes[$CellContext`n, StandardForm],
    ImageSizeCache->{7., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{237, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->86964523]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->813085168],

Cell["Use rational steps:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->127649809],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Slider", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", 
       RowBox[{"1", "/", "5"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1591536834],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[Dynamic[
     BoxForm`RemapVariable[$CellContext`x, {0, 1, 
       Rational[1, 5]}], BoxForm`RemapValue[#, $CellContext`x, {0, 1, 
       Rational[1, 5]}]& ], {0, 5, 1}], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{21.6875, {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{251, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2050745653]
}, Open  ]],

Cell[TextData[{
 "Use slider increments of ",
 Cell[BoxData[
  StyleBox["\[Pi]", "TR"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->94183694],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Slider", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "y", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"10", "Pi"}], ",", "Pi"}], "}"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "y", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1917139268],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[Dynamic[
     BoxForm`RemapVariable[$CellContext`y, {0, 10 Pi, Pi}], 
     BoxForm`RemapValue[#, $CellContext`y, {0, 10 Pi, Pi}]& ], {0, 10, 1}], 
   ",", 
   DynamicBox[ToBoxes[$CellContext`y, StandardForm],
    ImageSizeCache->{14., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{244, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->515037688]
}, Open  ]],

Cell["Use a symbolic range:", "ExampleText",
 CellID->161212047],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Slider", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "z", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", 
       RowBox[{"20", "a"}], ",", 
       RowBox[{"2", "a"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "z", "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1879324806],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[Dynamic[
     BoxForm`RemapVariable[$CellContext`z, {$CellContext`a, 20 $CellContext`a,
        2 $CellContext`a}], 
     BoxForm`RemapValue[#, $CellContext`z, {$CellContext`a, 20 $CellContext`a,
        2 $CellContext`a}]& ], {0, 
     Rational[19, 2], 1}], ",", 
   DynamicBox[ToBoxes[$CellContext`z, StandardForm],
    ImageSizeCache->{7., {0., 6.}}]}], "}"}]], "Output",
 ImageSize->{237, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->622534366]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->278226741],

Cell["Use a list of possible values:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->223367795],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Slider", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"a", ",", "2", ",", "True"}], "}"}], "}"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->785057901],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[Dynamic[$CellContext`x], {{$CellContext`a, 2, True}}], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{21.6875, {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{251, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10953795]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26437080],

Cell["\<\
Change the relative width corresponding to each possible value:\
\>", "ExampleText",
 CellID->386607521],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Slider", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"a", ",", "10"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"True", ",", "20"}], "}"}]}], "}"}], "}"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->282227790],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[
    Dynamic[$CellContext`x], {{{$CellContext`a, 10}, {2, 5}, {True, 20}}}], 
   ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{21.6875, {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{251, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->40926384]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(11)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->309388764],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Appearance",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->228626761],

Cell["Different sizes:", "ExampleText",
 CellID->48195337],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Slider", "[", 
    RowBox[{"0.5", ",", 
     RowBox[{"Appearance", "\[Rule]", "a"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"Tiny", ",", "Small", ",", "Medium", ",", "Large"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->37142460],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[0.5,
    Appearance->Tiny], ",", 
   SliderBox[0.5,
    Appearance->Small], ",", 
   SliderBox[0.5,
    Appearance->Medium], ",", 
   SliderBox[0.5,
    Appearance->Large]}], "}"}]], "Output",
 ImageSize->{430, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->104305299]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->353870609],

Cell["Special arrow appearances:", "ExampleText",
 CellID->367290398],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Slider", "[", 
    RowBox[{"0.5", ",", 
     RowBox[{"Appearance", "\[Rule]", "a"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<UpArrow\>\"", ",", "\"\<DownArrow\>\""}], "}"}]}], "}"}]}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->476619144],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[0.5,
    Appearance->"UpArrow"], ",", 
   SliderBox[0.5,
    Appearance->"DownArrow"]}], "}"}]], "Output",
 ImageSize->{430, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4175766]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->99592028],

Cell[TextData[{
 "Use dynamic appearance, based on whether ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Round",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Round"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineMath"],
 " or ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->767433246],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Slider", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"Appearance", "\[Rule]", 
      RowBox[{"Dynamic", "[", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Round", "[", "x", "]"}], "\[Equal]", "1"}], ",", 
         "\"\<UpArrow\>\"", ",", "\"\<DownArrow\>\""}], "]"}], "]"}]}]}], 
    "]"}], ",", 
   RowBox[{"Dynamic", "[", 
    RowBox[{"Round", "[", "x", "]"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->394761178],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[Dynamic[$CellContext`x],
    Appearance->Dynamic[
      If[Round[$CellContext`x] == 1, "UpArrow", "DownArrow"]]], ",", 
   DynamicBox[ToBoxes[
     Round[$CellContext`x], StandardForm],
    ImageSizeCache->{7., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{237, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->160429497]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AutoAction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->160826823],

Cell["\<\
By default no slider values change until you click in the slider area:\
\>", "ExampleText",
 CellID->214704586],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Slider", "[", 
    RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->119939086],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[Dynamic[$CellContext`x]], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{14., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{244, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->33647980]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->56876034],

Cell[TextData[{
 "By setting ",
 Cell[BoxData[
  ButtonBox["AutoAction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AutoAction"]], "InlineFormula"],
 ", the slider values change as the mouse moves over the slider area:"
}], "ExampleText",
 CellID->306328665],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Slider", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"AutoAction", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->469113643],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[Dynamic[$CellContext`x],
    AutoAction->True], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{14., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{244, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->172785271]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Background",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->122183674],

Cell["Change the background colors:", "ExampleText",
 CellID->187974734],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Slider", "[", 
    RowBox[{"0.5", ",", 
     RowBox[{"Background", "\[Rule]", "c"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"{", 
      RowBox[{"Pink", ",", "Green", ",", "Gray", ",", "Yellow"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->155850066],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[0.5,
    Background->RGBColor[1, 0.5, 0.5]], ",", 
   SliderBox[0.5,
    Background->RGBColor[0, 1, 0]], ",", 
   SliderBox[0.5,
    Background->GrayLevel[0.5]], ",", 
   SliderBox[0.5,
    Background->RGBColor[1, 1, 0]]}], "}"}]], "Output",
 ImageSize->{430, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->89700621]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->584674232],

Cell["Change the background color dynamically:", "ExampleText",
 CellID->375560463],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Slider", "[", 
  RowBox[{
   RowBox[{"Dynamic", "[", "x", "]"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"Dynamic", "[", 
     RowBox[{"Hue", "[", "x", "]"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->179308],

Cell[BoxData[
 SliderBox[Dynamic[$CellContext`x],
  Background->Dynamic[
    Hue[$CellContext`x]]]], "Output",
 ImageSize->{204, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->407082308]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "BaselinePosition",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->333883692],

Cell["Align with the surrounding text:", "ExampleText",
 CellID->397440850],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Slider", "[", 
      RowBox[{"0.5", ",", 
       RowBox[{"ImageSize", "\[Rule]", "100"}], ",", 
       RowBox[{"BaselinePosition", "\[Rule]", "p"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", 
       RowBox[{"{", 
        RowBox[{"Top", ",", "Center", ",", "Bottom"}], "}"}]}], "}"}]}], 
    "]"}], ",", "\"\<xxx\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->340562913],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SliderBox[0.5,
    BaselinePosition->Top,
    ImageSize->100], "xxx", 
   SliderBox[0.5,
    BaselinePosition->Center,
    ImageSize->100], "xxx", 
   SliderBox[0.5,
    BaselinePosition->Bottom,
    ImageSize->100]}],
  Row[{
    Slider[0.5, ImageSize -> 100, BaselinePosition -> Top], 
    Slider[0.5, ImageSize -> 100, BaselinePosition -> Center], 
    Slider[0.5, ImageSize -> 100, BaselinePosition -> Bottom]}, 
   "xxx"]]], "Output",
 ImageSize->{358, 38},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->267509775]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2597070],

Cell["Dynamically change the baseline position:", "ExampleText",
 CellID->685322303],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"\"\<x\>\"", ",", 
    RowBox[{"Slider", "[", 
     RowBox[{
      RowBox[{"Dynamic", "[", "x", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"Top", ",", "Center", ",", "Bottom"}], "}"}], "}"}], ",", 
      RowBox[{"BaselinePosition", "\[Rule]", 
       RowBox[{"Dynamic", "[", "x", "]"}]}]}], "]"}], ",", "\"\<x\>\""}], 
   "}"}], "//", "Row"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->385391123],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x\"\>", "\[InvisibleSpace]", 
   SliderBox[Dynamic[$CellContext`x], {{Top, Center, Bottom}},
    BaselinePosition->Dynamic[$CellContext`x]], 
   "\[InvisibleSpace]", "\<\"x\"\>"}],
  Row[{"x", 
    Slider[
     Dynamic[$CellContext`x], {{Top, Center, Bottom}}, BaselinePosition -> 
     Dynamic[$CellContext`x]], "x"}]]], "Output",
 ImageSize->{218, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->145111115]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ContinuousAction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->182334888],

Cell["By default, variables are continuously updated:", "ExampleText",
 CellID->155072301],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Slider", "[", 
    RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->357598064],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[Dynamic[$CellContext`x]], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{14., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{244, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->105357883]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->979817465],

Cell[TextData[{
 "Setting ",
 Cell[BoxData[
  ButtonBox["ContinuousAction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ContinuousAction"]], "InlineFormula"],
 " to False makes variables update only when the slider is released:"
}], "ExampleText",
 CellID->83870],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Slider", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "y", "]"}], ",", 
     RowBox[{"ContinuousAction", "\[Rule]", "False"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "y", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->470641416],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[Dynamic[$CellContext`y],
    ContinuousAction->False], ",", 
   DynamicBox[ToBoxes[$CellContext`y, StandardForm],
    ImageSizeCache->{14., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{244, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->34053294]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Enabled",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->572752972],

Cell[TextData[{
 "By default ",
 Cell[BoxData[
  ButtonBox["Slider",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Slider"]], "InlineFormula"],
 " is enabled: "
}], "ExampleText",
 CellID->154813376],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Slider", "[", "0.5", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->94729581],

Cell[BoxData[
 SliderBox[0.658]], "Output",
 ImageSize->{204, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->469328000]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->524517898],

Cell[TextData[{
 "By setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Enabled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Enabled"], " ", "\[Rule]", " ", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", the slider is disabled but visible in its current state:"
}], "ExampleText",
 CellID->576258550],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Slider", "[", 
  RowBox[{"0.3", ",", 
   RowBox[{"Enabled", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->227336428],

Cell[BoxData[
 SliderBox[0.3,
  Enabled->False]], "Output",
 ImageSize->{204, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->727354493]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Exclusions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->394791677],

Cell["Exclude values from the range:", "ExampleText",
 CellID->175289357],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Slider", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0.2"}], "}"}], ",", 
     RowBox[{"Exclusions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0.4", ",", "0.8"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->394705405],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[Dynamic[$CellContext`x], {0, 1, 0.2},
    Exclusions->{0.4, 0.8}], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{14., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{244, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->352420066]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ImageMargins",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->226870291],

Cell[TextData[{
 "By setting ",
 Cell[BoxData[
  ButtonBox["ImageMargins",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageMargins"]], "InlineFormula"],
 " you make the slider area larger:"
}], "ExampleText",
 CellID->33301087],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Slider", "[", 
    RowBox[{"0.5", ",", 
     RowBox[{"ImageMargins", "\[Rule]", "m"}], ",", 
     RowBox[{"Background", "\[Rule]", "Pink"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "5", ",", "10", ",", "20"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23634922],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[0.5,
    Background->RGBColor[1, 0.5, 0.5],
    ImageMargins->0], ",", 
   SliderBox[0.46900000000000003`,
    Background->RGBColor[1, 0.5, 0.5],
    ImageMargins->5], ",", 
   SliderBox[0.5,
    Background->RGBColor[1, 0.5, 0.5],
    ImageMargins->10], ",", 
   SliderBox[0.5,
    Background->RGBColor[1, 0.5, 0.5],
    ImageMargins->20]}], "}"}]], "Output",
 ImageSize->{490, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->242512162]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ImageSize",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->49575055],

Cell["Use preset values:", "ExampleText",
 CellID->601874456],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Slider", "[", 
     RowBox[{"0.5", ",", 
      RowBox[{"ImageSize", "\[Rule]", "i"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"{", 
       RowBox[{"Tiny", ",", "Small", ",", "Medium", ",", "Large"}], "}"}]}], 
     "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->234360116],

Cell[BoxData[
 TagBox[GridBox[{
    {
     SliderBox[0.5,
      ImageSize->Tiny]},
    {
     SliderBox[0.5,
      ImageSize->Small]},
    {
     SliderBox[0.5,
      ImageSize->Medium]},
    {
     SliderBox[0.5,
      ImageSize->Large]}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}}],
  "Column"]], "Output",
 ImageSize->{404, 97},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->625992958]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->50171665],

Cell["Or use any values:", "ExampleText",
 CellID->27069804],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Slider", "[", 
     RowBox[{"0.5", ",", 
      RowBox[{"ImageSize", "\[Rule]", "i"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"{", 
       RowBox[{"50", ",", "150", ",", "300", ",", "500"}], "}"}]}], "}"}]}], 
   "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->289053222],

Cell[BoxData[
 TagBox[GridBox[{
    {
     SliderBox[0.5,
      ImageSize->50]},
    {
     SliderBox[0.5,
      ImageSize->150]},
    {
     SliderBox[0.5,
      ImageSize->300]},
    {
     SliderBox[0.5,
      ImageSize->500]}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}}],
  "Column"]], "Output",
 ImageSize->{504, 97},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->380450089]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->120666697],

Cell["\<\
By setting the second element you can also control the height:\
\>", "ExampleText",
 CellID->73815513],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Slider", "[", 
  RowBox[{"0.5", ",", 
   RowBox[{"ImageSize", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "50"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->643525534],

Cell[BoxData[
 SliderBox[0.5,
  ImageSize->{Automatic, 50}]], "Output",
 ImageSize->{204, 53},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->333671422]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->434447726],

Cell["A fully custom image size:", "ExampleText",
 CellID->114063303],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Slider", "[", 
  RowBox[{"0.5", ",", 
   RowBox[{"ImageSize", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"50", ",", "50"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->700558927],

Cell[BoxData[
 SliderBox[0.5700000000000001,
  ImageSize->{50, 50}]], "Output",
 ImageSize->{54, 53},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12482657]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5006],

Cell[TextData[{
 "Selecting the ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " prime:"
}], "ExampleText",
 CellID->451134786],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"n", "=", "1000"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Slider", "[", 
      RowBox[{
       RowBox[{"Dynamic", "[", "n", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         SuperscriptBox["10", "5"], ",", "1"}], "}"}]}], "]"}], ",", 
     RowBox[{
      SubscriptBox["p", 
       RowBox[{"Dynamic", "[", "n", "]"}]], "\[LongRightArrow]", 
      RowBox[{"Dynamic", "[", 
       RowBox[{"Prime", "[", "n", "]"}], "]"}]}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10599679],

Cell[BoxData[
 DynamicModuleBox[{Cell$$3708`n$$ = 18784}, 
  RowBox[{"{", 
   RowBox[{
    SliderBox[Dynamic[Cell$$3708`n$$], {1, 100000, 1}], ",", 
    RowBox[{
     SubscriptBox["p", 
      DynamicBox[ToBoxes[Cell$$3708`n$$, StandardForm],
       ImageSizeCache->{26.5, {0., 6.}}]], "\[LongRightArrow]", 
     DynamicBox[ToBoxes[
       Prime[Cell$$3708`n$$], StandardForm],
      ImageSizeCache->{44.125, {0., 8.}}]}]}], "}"}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{325, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->738870353]
}, Open  ]],

Cell[TextData[{
 "Selecting the ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " digit in the decimal expansion of ",
 Cell[BoxData[
  StyleBox["\[Pi]", "TR"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->411560072],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"n", "=", "10000"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Slider", "[", 
      RowBox[{
       RowBox[{"Dynamic", "[", "n", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         SuperscriptBox["10", "5"], ",", "1"}], "}"}]}], "]"}], ",", 
     RowBox[{
      SubscriptBox["\[Pi]", 
       RowBox[{"Dynamic", "[", "n", "]"}]], "\[LongRightArrow]", 
      RowBox[{"Dynamic", "[", 
       RowBox[{"First", "@", 
        RowBox[{"First", "@", 
         RowBox[{"RealDigits", "[", 
          RowBox[{"Pi", ",", "10", ",", "1", ",", 
           RowBox[{"-", "n"}]}], "]"}]}]}], "]"}]}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->72247648],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`n$$ = 57804}, 
  RowBox[{"{", 
   RowBox[{
    SliderBox[Dynamic[$CellContext`n$$], {1, 100000, 1}], ",", 
    RowBox[{
     SubscriptBox["\[Pi]", 
      DynamicBox[ToBoxes[$CellContext`n$$, StandardForm],
       ImageSizeCache->{26.5, {0., 6.}}]], "\[LongRightArrow]", 
     DynamicBox[ToBoxes[
       First[
        First[
         RealDigits[Pi, 10, 1, -$CellContext`n$$]]], StandardForm],
      ImageSizeCache->{7., {0., 8.}}]}]}], "}"}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{287, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->262881419]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->624291444],

Cell["A color selector:", "ExampleText",
 CellID->433452198],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"red", "=", "0"}], ",", 
     RowBox[{"green", "=", "0"}], ",", 
     RowBox[{"blue", "=", "0"}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Column", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Grid", "[", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Graphics", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"Red", ",", 
               RowBox[{"Rectangle", "[", "]"}]}], "}"}], ",", 
             RowBox[{"ImageSize", "\[Rule]", "30"}]}], "]"}], ",", 
           RowBox[{"Slider", "[", 
            RowBox[{"Dynamic", "[", "red", "]"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Graphics", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"Green", ",", 
               RowBox[{"Rectangle", "[", "]"}]}], "}"}], ",", 
             RowBox[{"ImageSize", "\[Rule]", "30"}]}], "]"}], ",", 
           RowBox[{"Slider", "[", 
            RowBox[{"Dynamic", "[", "green", "]"}], "]"}]}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Graphics", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"Blue", ",", 
               RowBox[{"Rectangle", "[", "]"}]}], "}"}], ",", 
             RowBox[{"ImageSize", "\[Rule]", "30"}]}], "]"}], ",", 
           RowBox[{"Slider", "[", 
            RowBox[{"Dynamic", "[", "blue", "]"}], "]"}]}], "}"}]}], "}"}], 
       "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Dynamic", "[", 
       RowBox[{"Graphics", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"RGBColor", "[", 
           RowBox[{
            RowBox[{"Dynamic", "[", "red", "]"}], ",", 
            RowBox[{"Dynamic", "[", "green", "]"}], ",", 
            RowBox[{"Dynamic", "[", "blue", "]"}]}], "]"}], ",", 
          RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], "]"}]}], "}"}], "]"}]}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->33727928],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`red$$ = 0, $CellContext`green$$ = 
  0, $CellContext`blue$$ = 0.24}, 
  TagBox[GridBox[{
     {
      TagBox[GridBox[{
         {
          GraphicsBox[
           {RGBColor[1, 0, 0], RectangleBox[{0, 0}]},
           ImageSize->30], 
          SliderBox[Dynamic[$CellContext`red$$]]},
         {
          GraphicsBox[
           {RGBColor[0, 1, 0], RectangleBox[{0, 0}]},
           ImageSize->30], 
          SliderBox[Dynamic[$CellContext`green$$]]},
         {
          GraphicsBox[
           {RGBColor[0, 0, 1], RectangleBox[{0, 0}]},
           ImageSize->30], 
          SliderBox[Dynamic[$CellContext`blue$$]]}
        }],
       "Grid"]},
     {
      DynamicBox[ToBoxes[
        Graphics[{
          RGBColor[
           Dynamic[$CellContext`red$$], 
           Dynamic[$CellContext`green$$], 
           Dynamic[$CellContext`blue$$]], 
          Disk[]}], StandardForm],
       ImageSizeCache->{180., {88., 92.}}]}
    },
    GridBoxAlignment->{"Columns" -> {{Left}}}],
   "Column"],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{242, 289},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23310603]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27880],

Cell["Randomly sized sliders:", "ExampleText",
 CellID->730530296],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "=", 
     RowBox[{"Random", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Column", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Slider", "[", 
       RowBox[{
        RowBox[{"Dynamic", "[", "x", "]"}], ",", 
        RowBox[{"ImageSize", "\[Rule]", 
         RowBox[{"RandomReal", "[", "200", "]"}]}]}], "]"}], ",", 
      RowBox[{"{", "10", "}"}]}], "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8300],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`x$$ = 0.418}, 
  TagBox[GridBox[{
     {
      SliderBox[Dynamic[$CellContext`x$$],
       ImageSize->57.96554690055693]},
     {
      SliderBox[Dynamic[$CellContext`x$$],
       ImageSize->63.41111190277906]},
     {
      SliderBox[Dynamic[$CellContext`x$$],
       ImageSize->167.60532398847792`]},
     {
      SliderBox[Dynamic[$CellContext`x$$],
       ImageSize->192.91274394063134`]},
     {
      SliderBox[Dynamic[$CellContext`x$$],
       ImageSize->21.537497291884034`]},
     {
      SliderBox[Dynamic[$CellContext`x$$],
       ImageSize->5.841086351720115]},
     {
      SliderBox[Dynamic[$CellContext`x$$],
       ImageSize->198.55028523557422`]},
     {
      SliderBox[Dynamic[$CellContext`x$$],
       ImageSize->134.3257865354329]},
     {
      SliderBox[Dynamic[$CellContext`x$$],
       ImageSize->164.4377910648839]},
     {
      SliderBox[Dynamic[$CellContext`x$$],
       ImageSize->196.60277375105952`]}
    },
    GridBoxAlignment->{"Columns" -> {{Left}}}],
   "Column"],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{203, 221},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->735468270]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9988],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["VerticalSlider",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VerticalSlider"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Manipulator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Manipulator"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ProgressIndicator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ProgressIndicator"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Locator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Locator"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Animator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Animator"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Slider2D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Slider2D"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ColorSlider",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorSlider"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LocatorPane",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LocatorPane"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ControlsRendering",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ControlsRendering"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->12493]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->6217],

Cell[TextData[ButtonBox["Introduction to Dynamic",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntroductionToDynamic"]], "Tutorials",
 CellID->445434225],

Cell[TextData[ButtonBox["Generalized Input",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GeneralizedInput"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->197188429],

Cell[TextData[ButtonBox["Control Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ControlObjects"]], "MoreAbout",
 CellID->19646270],

Cell[TextData[ButtonBox["Creating Inspectors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CreatingInspectors"]], "MoreAbout",
 CellID->524285192],

Cell[TextData[ButtonBox["Dynamic Interactivity Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DynamicInteractivityLanguage"]], "MoreAbout",
 CellID->101747682],

Cell[TextData[ButtonBox["Dynamic Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DynamicVisualization"]], "MoreAbout",
 CellID->30921482],

Cell[TextData[ButtonBox["Interactive Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/InteractiveManipulation"]], "MoreAbout",
 CellID->32759882],

Cell[TextData[ButtonBox["Options & Styling for Interactive Manipulation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/OptionsAndStylingForInteractiveManipulation"]], "MoreAbout",
 CellID->631363210],

Cell[TextData[ButtonBox["New in 6.0: Dynamic Interactivity",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DynamicInteractivity"]], "MoreAbout",
 CellID->221303900]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Slider - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 21, 15.5584580}", "context" -> "System`", 
    "keywords" -> {"scrollbar", "slider"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Slider[x] represents a slider with setting x in the range 0 to 1. \
Slider[Dynamic[x]] takes the setting to be the dynamically updated current \
value of x, with the value of x being reset if the slider is moved. Slider[x, \
{x_min, x_max}] represents a slider with range x_min to x_max. Slider[x, \
{x_min, x_max, dx}] represents a slider that jumps in steps dx. Slider[x, \
{{e_1, e_2, ...}}] represents a slider in which equally spaced intervals \
correspond to successive settings e_i. Slider[x, {{{e_1, w_1}, {e_2, w_2}, \
...}}] uses intervals of relative widths w_i for the e_i. ", "synonyms" -> {},
     "title" -> "Slider", "type" -> "Symbol", "uri" -> "ref/Slider"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[21178, 683, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->747621363]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 68994, 2521}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3890, 82, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4513, 109, 1571, 37, 70, "ObjectNameGrid"],
Cell[6087, 148, 4762, 156, 70, "Usage",
 CellID->27122]
}, Open  ]],
Cell[CellGroupData[{
Cell[10886, 309, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[11364, 326, 312, 10, 70, "Notes",
 CellID->20757],
Cell[11679, 338, 625, 23, 70, "Notes",
 CellID->12597],
Cell[12307, 363, 784, 30, 70, "Notes",
 CellID->12713],
Cell[13094, 395, 950, 36, 70, "Notes",
 CellID->27013],
Cell[14047, 433, 261, 9, 70, "Notes",
 CellID->829],
Cell[14311, 444, 801, 31, 70, "Notes",
 CellID->27486],
Cell[15115, 477, 139, 4, 70, "Notes",
 CellID->26510],
Cell[15257, 483, 508, 19, 70, "Notes",
 CellID->6138],
Cell[15768, 504, 766, 30, 70, "Notes",
 CellID->4013],
Cell[16537, 536, 69, 1, 70, "Notes",
 CellID->26075],
Cell[16609, 539, 2958, 77, 70, "3ColumnTableMod",
 CellID->25324],
Cell[19570, 618, 861, 32, 70, "Notes",
 CellID->1689],
Cell[20434, 652, 343, 10, 70, "Notes",
 CellID->708313727],
Cell[20780, 664, 361, 14, 70, "Notes",
 CellID->15841]
}, Closed]],
Cell[CellGroupData[{
Cell[21178, 683, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->747621363],
Cell[CellGroupData[{
Cell[21563, 697, 148, 5, 70, "ExampleSection",
 CellID->626198783],
Cell[21714, 704, 311, 12, 70, "ExampleText",
 CellID->258827707],
Cell[CellGroupData[{
Cell[22050, 720, 104, 3, 28, "Input",
 CellID->348675845],
Cell[22157, 725, 172, 6, 46, "Output",
 CellID->169222830]
}, Open  ]],
Cell[22344, 734, 125, 3, 70, "ExampleDelimiter",
 CellID->297788944],
Cell[22472, 739, 87, 1, 70, "ExampleText",
 CellID->186407634],
Cell[CellGroupData[{
Cell[22584, 744, 220, 7, 70, "Input",
 CellID->156176220],
Cell[22807, 753, 325, 10, 70, "Output",
 CellID->65816724]
}, Open  ]],
Cell[23147, 766, 125, 3, 70, "ExampleDelimiter",
 CellID->144900709],
Cell[23275, 771, 244, 9, 70, "ExampleText",
 CellID->10336265],
Cell[CellGroupData[{
Cell[23544, 784, 311, 10, 70, "Input",
 CellID->129400021],
Cell[23858, 796, 338, 10, 70, "Output",
 CellID->539078251]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[24245, 812, 215, 7, 70, "ExampleSection",
 CellID->5056],
Cell[24463, 821, 324, 11, 70, "ExampleText",
 CellID->120461931],
Cell[CellGroupData[{
Cell[24812, 836, 375, 13, 70, "Input",
 CellID->61980051],
Cell[25190, 851, 338, 10, 70, "Output",
 CellID->19596566]
}, Open  ]],
Cell[25543, 864, 282, 10, 70, "ExampleText",
 CellID->211277733],
Cell[CellGroupData[{
Cell[25850, 878, 376, 13, 70, "Input",
 CellID->639201867],
Cell[26229, 893, 335, 10, 70, "Output",
 CellID->272548611]
}, Open  ]],
Cell[26579, 906, 125, 3, 70, "ExampleDelimiter",
 CellID->118668047],
Cell[26707, 911, 124, 2, 70, "ExampleText",
 CellID->313272786],
Cell[CellGroupData[{
Cell[26856, 917, 311, 10, 70, "Input",
 CellID->147792433],
Cell[27170, 929, 337, 10, 70, "Output",
 CellID->86964523]
}, Open  ]],
Cell[27522, 942, 125, 3, 70, "ExampleDelimiter",
 CellID->813085168],
Cell[27650, 947, 110, 2, 70, "ExampleText",
 CellID->127649809],
Cell[CellGroupData[{
Cell[27785, 953, 338, 11, 70, "Input",
 CellID->1591536834],
Cell[28126, 966, 476, 13, 70, "Output",
 CellID->2050745653]
}, Open  ]],
Cell[28617, 982, 149, 6, 70, "ExampleText",
 CellID->94183694],
Cell[CellGroupData[{
Cell[28791, 992, 336, 11, 70, "Input",
 CellID->1917139268],
Cell[29130, 1005, 450, 13, 70, "Output",
 CellID->515037688]
}, Open  ]],
Cell[29595, 1021, 64, 1, 70, "ExampleText",
 CellID->161212047],
Cell[CellGroupData[{
Cell[29684, 1026, 357, 12, 70, "Input",
 CellID->1879324806],
Cell[30044, 1040, 558, 15, 70, "Output",
 CellID->622534366]
}, Open  ]],
Cell[30617, 1058, 125, 3, 70, "ExampleDelimiter",
 CellID->278226741],
Cell[30745, 1063, 121, 2, 70, "ExampleText",
 CellID->223367795],
Cell[CellGroupData[{
Cell[30891, 1069, 340, 11, 70, "Input",
 CellID->785057901],
Cell[31234, 1082, 358, 10, 70, "Output",
 CellID->10953795]
}, Open  ]],
Cell[31607, 1095, 124, 3, 70, "ExampleDelimiter",
 CellID->26437080],
Cell[31734, 1100, 114, 3, 70, "ExampleText",
 CellID->386607521],
Cell[CellGroupData[{
Cell[31873, 1107, 519, 17, 70, "Input",
 CellID->282227790],
Cell[32395, 1126, 384, 12, 70, "Output",
 CellID->40926384]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[32828, 1144, 223, 7, 70, "ExampleSection",
 CellID->309388764],
Cell[CellGroupData[{
Cell[33076, 1155, 231, 7, 70, "ExampleSubsection",
 CellID->228626761],
Cell[33310, 1164, 58, 1, 70, "ExampleText",
 CellID->48195337],
Cell[CellGroupData[{
Cell[33393, 1169, 368, 12, 70, "Input",
 CellID->37142460],
Cell[33764, 1183, 376, 15, 70, "Output",
 CellID->104305299]
}, Open  ]],
Cell[34155, 1201, 125, 3, 70, "ExampleDelimiter",
 CellID->353870609],
Cell[34283, 1206, 69, 1, 70, "ExampleText",
 CellID->367290398],
Cell[CellGroupData[{
Cell[34377, 1211, 361, 12, 70, "Input",
 CellID->476619144],
Cell[34741, 1225, 288, 11, 70, "Output",
 CellID->4175766]
}, Open  ]],
Cell[35044, 1239, 124, 3, 70, "ExampleDelimiter",
 CellID->99592028],
Cell[35171, 1244, 415, 16, 70, "ExampleText",
 CellID->767433246],
Cell[CellGroupData[{
Cell[35611, 1264, 554, 17, 70, "Input",
 CellID->394761178],
Cell[36168, 1283, 426, 13, 70, "Output",
 CellID->160429497]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[36643, 1302, 231, 7, 70, "ExampleSubsection",
 CellID->160826823],
Cell[36877, 1311, 121, 3, 70, "ExampleText",
 CellID->214704586],
Cell[CellGroupData[{
Cell[37023, 1318, 220, 7, 70, "Input",
 CellID->119939086],
Cell[37246, 1327, 325, 10, 70, "Output",
 CellID->33647980]
}, Open  ]],
Cell[37586, 1340, 124, 3, 70, "ExampleDelimiter",
 CellID->56876034],
Cell[37713, 1345, 264, 8, 70, "ExampleText",
 CellID->306328665],
Cell[CellGroupData[{
Cell[38002, 1357, 290, 9, 70, "Input",
 CellID->469113643],
Cell[38295, 1368, 348, 11, 70, "Output",
 CellID->172785271]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[38692, 1385, 231, 7, 70, "ExampleSubsection",
 CellID->122183674],
Cell[38926, 1394, 72, 1, 70, "ExampleText",
 CellID->187974734],
Cell[CellGroupData[{
Cell[39023, 1399, 368, 12, 70, "Input",
 CellID->155850066],
Cell[39394, 1413, 424, 15, 70, "Output",
 CellID->89700621]
}, Open  ]],
Cell[39833, 1431, 125, 3, 70, "ExampleDelimiter",
 CellID->584674232],
Cell[39961, 1436, 83, 1, 70, "ExampleText",
 CellID->375560463],
Cell[CellGroupData[{
Cell[40069, 1441, 265, 8, 70, "Input",
 CellID->179308],
Cell[40337, 1451, 241, 8, 70, "Output",
 CellID->407082308]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[40627, 1465, 237, 7, 70, "ExampleSubsection",
 CellID->333883692],
Cell[40867, 1474, 75, 1, 70, "ExampleText",
 CellID->397440850],
Cell[CellGroupData[{
Cell[40967, 1479, 495, 15, 70, "Input",
 CellID->340562913],
Cell[41465, 1496, 618, 21, 70, "Output",
 CellID->267509775]
}, Open  ]],
Cell[42098, 1520, 123, 3, 70, "ExampleDelimiter",
 CellID->2597070],
Cell[42224, 1525, 84, 1, 70, "ExampleText",
 CellID->685322303],
Cell[CellGroupData[{
Cell[42333, 1530, 474, 14, 70, "Input",
 CellID->385391123],
Cell[42810, 1546, 511, 14, 70, "Output",
 CellID->145111115]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[43370, 1566, 237, 7, 70, "ExampleSubsection",
 CellID->182334888],
Cell[43610, 1575, 90, 1, 70, "ExampleText",
 CellID->155072301],
Cell[CellGroupData[{
Cell[43725, 1580, 220, 7, 70, "Input",
 CellID->357598064],
Cell[43948, 1589, 326, 10, 70, "Output",
 CellID->105357883]
}, Open  ]],
Cell[44289, 1602, 125, 3, 70, "ExampleDelimiter",
 CellID->979817465],
Cell[44417, 1607, 268, 8, 70, "ExampleText",
 CellID->83870],
Cell[CellGroupData[{
Cell[44710, 1619, 297, 9, 70, "Input",
 CellID->470641416],
Cell[45010, 1630, 354, 11, 70, "Output",
 CellID->34053294]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[45413, 1647, 228, 7, 70, "ExampleSubsection",
 CellID->572752972],
Cell[45644, 1656, 202, 8, 70, "ExampleText",
 CellID->154813376],
Cell[CellGroupData[{
Cell[45871, 1668, 103, 3, 70, "Input",
 CellID->94729581],
Cell[45977, 1673, 174, 6, 70, "Output",
 CellID->469328000]
}, Open  ]],
Cell[46166, 1682, 125, 3, 70, "ExampleDelimiter",
 CellID->524517898],
Cell[46294, 1687, 369, 12, 70, "ExampleText",
 CellID->576258550],
Cell[CellGroupData[{
Cell[46688, 1703, 167, 5, 70, "Input",
 CellID->227336428],
Cell[46858, 1710, 190, 7, 70, "Output",
 CellID->727354493]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[47097, 1723, 231, 7, 70, "ExampleSubsection",
 CellID->394791677],
Cell[47331, 1732, 73, 1, 70, "ExampleText",
 CellID->175289357],
Cell[CellGroupData[{
Cell[47429, 1737, 421, 13, 70, "Input",
 CellID->394705405],
Cell[47853, 1752, 367, 11, 70, "Output",
 CellID->352420066]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[48269, 1769, 233, 7, 70, "ExampleSubsection",
 CellID->226870291],
Cell[48505, 1778, 233, 8, 70, "ExampleText",
 CellID->33301087],
Cell[CellGroupData[{
Cell[48763, 1790, 408, 13, 70, "Input",
 CellID->23634922],
Cell[49174, 1805, 544, 19, 70, "Output",
 CellID->242512162]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[49767, 1830, 229, 7, 70, "ExampleSubsection",
 CellID->49575055],
Cell[49999, 1839, 61, 1, 70, "ExampleText",
 CellID->601874456],
Cell[CellGroupData[{
Cell[50085, 1844, 410, 13, 70, "Input",
 CellID->234360116],
Cell[50498, 1859, 446, 21, 70, "Output",
 CellID->625992958]
}, Open  ]],
Cell[50959, 1883, 124, 3, 70, "ExampleDelimiter",
 CellID->50171665],
Cell[51086, 1888, 60, 1, 70, "ExampleText",
 CellID->27069804],
Cell[CellGroupData[{
Cell[51171, 1893, 399, 13, 70, "Input",
 CellID->289053222],
Cell[51573, 1908, 437, 21, 70, "Output",
 CellID->380450089]
}, Open  ]],
Cell[52025, 1932, 125, 3, 70, "ExampleDelimiter",
 CellID->120666697],
Cell[52153, 1937, 112, 3, 70, "ExampleText",
 CellID->73815513],
Cell[CellGroupData[{
Cell[52290, 1944, 225, 7, 70, "Input",
 CellID->643525534],
Cell[52518, 1953, 202, 7, 70, "Output",
 CellID->333671422]
}, Open  ]],
Cell[52735, 1963, 125, 3, 70, "ExampleDelimiter",
 CellID->434447726],
Cell[52863, 1968, 69, 1, 70, "ExampleText",
 CellID->114063303],
Cell[CellGroupData[{
Cell[52957, 1973, 218, 7, 70, "Input",
 CellID->700558927],
Cell[53178, 1982, 208, 7, 70, "Output",
 CellID->12482657]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[53447, 1996, 222, 7, 70, "ExampleSection",
 CellID->5006],
Cell[53672, 2005, 223, 9, 70, "ExampleText",
 CellID->451134786],
Cell[CellGroupData[{
Cell[53920, 2018, 615, 19, 70, "Input",
 CellID->10599679],
Cell[54538, 2039, 600, 17, 70, "Output",
 CellID->738870353]
}, Open  ]],
Cell[55153, 2059, 318, 12, 70, "ExampleText",
 CellID->411560072],
Cell[CellGroupData[{
Cell[55496, 2075, 775, 24, 70, "Input",
 CellID->72247648],
Cell[56274, 2101, 658, 19, 70, "Output",
 CellID->262881419]
}, Open  ]],
Cell[56947, 2123, 125, 3, 70, "ExampleDelimiter",
 CellID->624291444],
Cell[57075, 2128, 60, 1, 70, "ExampleText",
 CellID->433452198],
Cell[CellGroupData[{
Cell[57160, 2133, 2150, 58, 70, "Input",
 CellID->33727928],
Cell[59313, 2193, 1213, 40, 70, "Output",
 CellID->23310603]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[60575, 2239, 224, 7, 70, "ExampleSection",
 CellID->27880],
Cell[60802, 2248, 66, 1, 70, "ExampleText",
 CellID->730530296],
Cell[CellGroupData[{
Cell[60893, 2253, 523, 16, 70, "Input",
 CellID->8300],
Cell[61419, 2271, 1218, 41, 70, "Output",
 CellID->735468270]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[62698, 2319, 310, 9, 70, "SeeAlsoSection",
 CellID->9988],
Cell[63011, 2330, 2230, 80, 70, "SeeAlso",
 CellID->12493]
}, Open  ]],
Cell[CellGroupData[{
Cell[65278, 2415, 313, 9, 70, "TutorialsSection",
 CellID->6217],
Cell[65594, 2426, 159, 3, 70, "Tutorials",
 CellID->445434225],
Cell[65756, 2431, 148, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[65941, 2439, 319, 9, 70, "MoreAboutSection",
 CellID->197188429],
Cell[66263, 2450, 140, 3, 70, "MoreAbout",
 CellID->19646270],
Cell[66406, 2455, 149, 3, 70, "MoreAbout",
 CellID->524285192],
Cell[66558, 2460, 170, 3, 70, "MoreAbout",
 CellID->101747682],
Cell[66731, 2465, 152, 3, 70, "MoreAbout",
 CellID->30921482],
Cell[66886, 2470, 158, 3, 70, "MoreAbout",
 CellID->32759882],
Cell[67047, 2475, 204, 4, 70, "MoreAbout",
 CellID->631363210],
Cell[67254, 2481, 172, 3, 70, "MoreAbout",
 CellID->221303900]
}, Open  ]],
Cell[67441, 2487, 27, 0, 70, "History"],
Cell[67471, 2489, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

