(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    116840,       3176]
NotebookOptionsPosition[    105947,       2801]
NotebookOutlinePosition[    107786,       2846]
CellTagsIndexPosition[    107699,       2841]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Introduction to Dynamic" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntroductionToDynamic"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Introduction to Dynamic\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LocatorPane" :> 
          Documentation`HelpLookup["paclet:ref/LocatorPane"], "Locator" :> 
          Documentation`HelpLookup["paclet:ref/Locator"], "Manipulate" :> 
          Documentation`HelpLookup["paclet:ref/Manipulate"], "Slider" :> 
          Documentation`HelpLookup["paclet:ref/Slider"], "VerticalSlider" :> 
          Documentation`HelpLookup["paclet:ref/VerticalSlider"], "Inset" :> 
          Documentation`HelpLookup["paclet:ref/Inset"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"LocatorPane\"\>", 2->"\<\"Locator\"\>", 
       3->"\<\"Manipulate\"\>", 4->"\<\"Slider\"\>", 
       5->"\<\"VerticalSlider\"\>", 6->"\<\"Inset\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Control Objects" :> 
          Documentation`HelpLookup["paclet:guide/ControlObjects"], 
          "Dynamic Visualization" :> 
          Documentation`HelpLookup["paclet:guide/DynamicVisualization"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Control Objects\"\>", 
       2->"\<\"Dynamic Visualization\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Slider2D", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Slider2D",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Slider2D"], "[", 
       RowBox[{"{", 
        RowBox[{
         StyleBox["x", "TI"], ",", 
         StyleBox["y", "TI"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a 2D slider with settings ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " in the range 0 to 1. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Slider2D",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Slider2D"], "[", 
       RowBox[{
        ButtonBox["Dynamic",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Dynamic"], "[", 
        StyleBox["pt", "TI"], "]"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]takes the setting to be the dynamically updated current \
value of ",
     Cell[BoxData[
      StyleBox["pt", "TI"]], "InlineFormula"],
     ", with the value of ",
     Cell[BoxData[
      StyleBox["pt", "TI"]], "InlineFormula"],
     " being reset if the slider is moved. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Slider2D",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Slider2D"], "[", 
       RowBox[{
        StyleBox["pt", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["min", "TI"], ",", 
          StyleBox["max", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a 2D slider with range ",
     Cell[BoxData[
      StyleBox["min", "TI"]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      StyleBox["max", "TI"]], "InlineFormula"],
     " in each direction. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Slider2D",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Slider2D"], "[", 
       RowBox[{
        StyleBox["pt", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["min", "TI"], ",", 
          StyleBox["max", "TI"], ",", 
          StyleBox["d", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a 2D slider that jumps in steps ",
     Cell[BoxData[
      StyleBox["d", "TI"]], "InlineFormula"],
     " in each direction. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Slider2D",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Slider2D"], "[", 
       RowBox[{
        StyleBox["pt", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["min", "TI"]], ",", 
            SubscriptBox[
             StyleBox["y", "TI"], 
             StyleBox["min", "TI"]]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["max", "TI"]], ",", 
            SubscriptBox[
             StyleBox["y", "TI"], 
             StyleBox["max", "TI"]]}], "}"}]}], "}"}]}], "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]specifies different ranges in ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " directions. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Slider2D",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Slider2D"], "[", 
       RowBox[{
        StyleBox["pt", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["min", "TI"]], ",", 
            SubscriptBox[
             StyleBox["y", "TI"], 
             StyleBox["min", "TI"]]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["max", "TI"]], ",", 
            SubscriptBox[
             StyleBox["y", "TI"], 
             StyleBox["max", "TI"]]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            StyleBox["dx", "TI"], ",", 
            StyleBox["dy", "TI"]}], "}"}]}], "}"}]}], "]"}]], 
      "InlineFormula"],
     " \[LineSeparator]uses jumps ",
     Cell[BoxData[
      StyleBox["dx", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["dy", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->4670]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Slider2D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Slider2D"], "[", 
   StyleBox["\[Ellipsis]", "TR"], "]"}]], "InlineFormula"],
 " displays in a notebook as a 2D slider that can be manipulated \
interactively, and moved in both horizontal and vertical directions. "
}], "Notes",
 CellID->10631],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Slider2D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Slider2D"], "[", 
   RowBox[{
    ButtonBox["Dynamic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Dynamic"], "[", 
    StyleBox["pt", "TI"], "]"}], "]"}]], "InlineFormula"],
 " will reset the value of ",
 Cell[BoxData[
  StyleBox["pt", "TI"]], "InlineFormula"],
 " when the slider is moved; ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Slider2D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Slider2D"], "[", 
   StyleBox["pt", "TI"], "]"}]], "InlineFormula"],
 " will not. "
}], "Notes",
 CellID->379],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Slider2D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Slider2D"], "[", 
   RowBox[{
    StyleBox["pt", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["min", "TI"]], ",", 
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["max", "TI"]], ",", 
      StyleBox["dn", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
 " jumps to integer positions if ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["n", "TI"], 
   StyleBox["min", "TI"]]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["dn", "TI"]], "InlineFormula"],
 " are integers. "
}], "Notes",
 CellID->19238],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Slider2D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Slider2D"], "[", 
   RowBox[{
    StyleBox["pt", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["r", "TI"], 
       StyleBox["min", "TI"]], ",", 
      SubscriptBox[
       StyleBox["r", "TI"], 
       StyleBox["max", "TI"]], ",", 
      StyleBox["dr", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
 " in general jumps to positions given by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Range",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Range"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["r", "TI"], 
     StyleBox["min", "TI"]], ",", 
    SubscriptBox[
     StyleBox["r", "TI"], 
     StyleBox["max", "TI"]], ",", 
    StyleBox["dr", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->14531],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Slider2D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Slider2D"], "[", 
   RowBox[{
    StyleBox["pt", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["min", "TI"]], ",", 
        SubscriptBox[
         StyleBox["y", "TI"], 
         StyleBox["min", "TI"]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["max", "TI"]], ",", 
        SubscriptBox[
         StyleBox["y", "TI"], 
         StyleBox["max", "TI"]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["dx", "TI"], ",", 
        StyleBox["dy", "TI"]}], "}"}]}], "}"}]}], "]"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["dx", "TI"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  StyleBox["dy", "TI"]], "InlineFormula"],
 " can be ",
 Cell[BoxData["0"], "InlineFormula"],
 ", indicating that settings in the corresponding direction should be \
continuous."
}], "Notes",
 CellID->4738],

Cell[TextData[{
 "The coordinates in ",
 Cell[BoxData[
  ButtonBox["Slider2D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Slider2D"]], "InlineFormula"],
 " run in the same directions as the default for ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 ", with ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " running from left to right, and ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " running from bottom to top. "
}], "Notes",
 CellID->22065],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Slider2D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Slider2D"], "[", 
   RowBox[{
    StyleBox["pt", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["min", "TI"]], ",", 
        SubscriptBox[
         StyleBox["y", "TI"], 
         StyleBox["max", "TI"]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["max", "TI"]], ",", 
        SubscriptBox[
         StyleBox["y", "TI"], 
         StyleBox["min", "TI"]]}], "}"}]}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " with ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["y", "TI"], 
   StyleBox["max", "TI"]]], "InlineFormula"],
 " > ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["y", "TI"], 
   StyleBox["min", "TI"]]], "InlineFormula"],
 " represents a 2D slider with ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " running from top to bottom. "
}], "Notes",
 CellID->11856],

Cell["\<\
If the value of the 2D slider is outside the ranges given, it will be \
displayed at one of the sides. \
\>", "Notes",
 CellID->15013],

Cell["The following options can be given: ", "Notes",
 CellID->7420],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Appearance",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Appearance"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the overall appearance of the 2D slider ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["AutoAction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AutoAction"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether to move the 2D slider automatically when the mouse is over it \
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BaselinePosition",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaselinePosition"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how to align with a surrounding text baseline ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BaseStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaseStyle"], 
    RowBox[{"{", "}"}], Cell[
    "base style specifications for the 2D slider", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ContinuousAction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ContinuousAction"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to update continuously when the slider is moved", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Enabled",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Enabled"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether the 2D slider is enabled, or grayed out ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Exclusions",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Exclusions"], 
    RowBox[{"{", "}"}], Cell["specific points to exclude", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageMargins",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageMargins"], "0", Cell[
    "margins around the image of the displayed 2D slider ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the overall image size of the displayed 2D slider ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True, True}}}},
 CellID->20383],

Cell[TextData[{
 "The settings for ",
 Cell[BoxData[
  ButtonBox["BaseStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaseStyle"]], "InlineFormula"],
 " are appended to the default style typically given by the ",
 Cell[BoxData["\"\<Slider2D\>\""], "InlineFormula"],
 " style in the current stylesheet. "
}], "Notes",
 CellID->307511469],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Slider2D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Slider2D"], "[", "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Slider2D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Slider2D"], "[", 
   RowBox[{"{", 
    RowBox[{"0.5", ",", "0.5"}], "}"}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->7088]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->57406271],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->9885374],

Cell["A particular 2D slider setting: ", "ExampleText",
 CellID->327036597],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Slider2D", "[", 
  RowBox[{"{", 
   RowBox[{".7", ",", ".3"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25352],

Cell[BoxData[
 Slider2DBox[{0.7, 0.3}]], "Output",
 ImageSize->{84, 83},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->142246035]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9139],

Cell["Dynamically update the slider setting: ", "ExampleText",
 CellID->453920004],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Slider2D", "[", 
    RowBox[{"Dynamic", "[", "r", "]"}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "r", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20269],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Slider2DBox[Dynamic[$CellContext`r]], ",", 
   DynamicBox[ToBoxes[$CellContext`r, StandardForm],
    ImageSizeCache->{53.1875, {2., 8.}}]}], "}"}]], "Output",
 ImageSize->{163, 83},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30778179]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13169636],

Cell["Define a range:", "ExampleText",
 CellID->178027514],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Slider2D", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "4"}], ",", 
         RowBox[{"-", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "1"}], "}"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->178405583],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Slider2DBox[Dynamic[$CellContext`x], {{-4, -1}, {4, 1}}], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{68.5625, {2., 8.}}]}], "}"}]], "Output",
 ImageSize->{178, 83},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->199183722]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14817284],

Cell["Define a range and step size:", "ExampleText",
 CellID->156915461],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Slider2D", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "y", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "4"}], ",", 
         RowBox[{"-", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "0.25"}], "}"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "y", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->415982474],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Slider2DBox[Dynamic[$CellContext`y], {{-4, -1}, {4, 1}, {2, 0.25}}], ",", 
   DynamicBox[ToBoxes[$CellContext`y, StandardForm],
    ImageSizeCache->{61.5625, {2., 8.}}]}], "}"}]], "Output",
 ImageSize->{171, 83},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->74656750]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25643],

Cell[TextData[{
 "Use ",
 StyleBox["evaluate-in-place", "MenuName"],
 " to get an active 2D slider: "
}], "ExampleText",
 CellID->687636405],

Cell[BoxData[
 RowBox[{"Setting", "[", 
  RowBox[{"Slider2D", "[", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32189298],

Cell[TextData[{
 "Then evaluate ",
 Cell[BoxData[
  ButtonBox["Setting",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Setting"]], "InlineFormula"],
 " to get the actual value out: "
}], "ExampleText",
 CellID->545668548],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Setting", "[", 
  Slider2DBox[{0.99, 0.1}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24274],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.99`", ",", "0.1`"}], "}"}]], "Output",
 ImageSize->{79, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->315906352]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->37532733],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AutoAction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->579665997],

Cell["Values will change as the cursor moves over the slider:", "ExampleText",
 CellID->228866288],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Slider2D", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"AutoAction", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->469113643],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Slider2DBox[Dynamic[$CellContext`x],
    AutoAction->True], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{53.1875, {2., 8.}}]}], "}"}]], "Output",
 ImageSize->{163, 83},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->75969109]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Background",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->231878366],

Cell["Set the background color:", "ExampleText",
 CellID->108424938],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Slider2D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.5", ",", "0.5"}], "}"}], ",", 
     RowBox[{"ImageMargins", "\[Rule]", "10"}], ",", 
     RowBox[{"Background", "\[Rule]", "c"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"{", 
      RowBox[{"Pink", ",", "Green", ",", "Gray", ",", "Yellow"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->297116580],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Slider2DBox[{0.5, 0.5},
    Background->RGBColor[1, 0.5, 0.5],
    ImageMargins->10], ",", 
   Slider2DBox[{0.5, 0.5},
    Background->RGBColor[0, 1, 0],
    ImageMargins->10], ",", 
   Slider2DBox[{0.5, 0.5},
    Background->GrayLevel[0.5],
    ImageMargins->10], ",", 
   Slider2DBox[{0.5, 0.5},
    Background->RGBColor[1, 1, 0],
    ImageMargins->10]}], "}"}]], "Output",
 ImageSize->{452, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->194694647]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->114659569],

Cell["Change the background dynamically:", "ExampleText",
 CellID->690849739],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Slider2D", "[", 
  RowBox[{
   RowBox[{"Dynamic", "[", "x", "]"}], ",", 
   RowBox[{"ImageMargins", "\[Rule]", "10"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"Dynamic", "[", 
     RowBox[{"Hue", "@@", "x"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->404816900],

Cell[BoxData[
 Slider2DBox[Dynamic[$CellContext`x],
  Background->Dynamic[
    Apply[Hue, $CellContext`x]],
  ImageMargins->10]], "Output",
 ImageSize->{104, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->492740067]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "BaselinePosition",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->122431969],

Cell["Set the baseline for alignment with surrounding text:", "ExampleText",
 CellID->147138306],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Slider2D", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.5", ",", "0.5"}], "}"}], ",", 
       RowBox[{"BaselinePosition", "\[Rule]", "p"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", 
       RowBox[{"{", 
        RowBox[{"Bottom", ",", "Center", ",", "Top"}], "}"}]}], "}"}]}], 
    "]"}], ",", "\"\<xxx\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->70754828],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   Slider2DBox[{0.5, 0.5},
    BaselinePosition->Bottom], "xxx", 
   Slider2DBox[{0.5, 0.5},
    BaselinePosition->Center], "xxx", 
   Slider2DBox[{0.5, 0.5},
    BaselinePosition->Top]}],
  Row[{
    Slider2D[{0.5, 0.5}, BaselinePosition -> Bottom], 
    Slider2D[{0.5, 0.5}, BaselinePosition -> Center], 
    Slider2D[{0.5, 0.5}, BaselinePosition -> Top]}, "xxx"]]], "Output",
 ImageSize->{298, 162},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->59282758]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ContinuousAction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->78759265],

Cell["\<\
By default, settings are changed continuously as the controller is affected: \
\
\>", "ExampleText",
 CellID->901882983],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Slider2D", "[", 
    RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->357598064],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Slider2DBox[Dynamic[$CellContext`x]], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{53.1875, {2., 8.}}]}], "}"}]], "Output",
 ImageSize->{163, 83},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->53765106]
}, Open  ]],

Cell["Makes settings update only when the mouse is released:", "ExampleText",
 CellID->324931920],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Slider2D", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "y", "]"}], ",", 
     RowBox[{"ContinuousAction", "\[Rule]", "False"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "y", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->470641416],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Slider2DBox[Dynamic[$CellContext`y],
    ContinuousAction->False], ",", 
   DynamicBox[ToBoxes[$CellContext`y, StandardForm],
    ImageSizeCache->{53.1875, {2., 8.}}]}], "}"}]], "Output",
 ImageSize->{163, 83},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->219236242]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Enabled",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->377515614],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["Slider2D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Slider2D"]], "InlineFormula"],
 " is enabled: "
}], "ExampleText",
 CellID->154813376],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Slider2D", "[", 
  RowBox[{"{", 
   RowBox[{"0.5", ",", "0.5"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->94729581],

Cell[BoxData[
 Slider2DBox[{0.34, 0.55}]], "Output",
 ImageSize->{84, 83},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->235066354]
}, Open  ]],

Cell["Make the slider disabled but visible in its current state:", \
"ExampleText",
 CellID->44441049],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Slider2D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.3", ",", "0.8"}], "}"}], ",", 
   RowBox[{"Enabled", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->227336428],

Cell[BoxData[
 Slider2DBox[{0.3, 0.8},
  Enabled->False]], "Output",
 ImageSize->{84, 83},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->493694664]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ImageMargins",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->306654534],

Cell["Use symbolic values for image margins:", "ExampleText",
 CellID->92573072],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Framed", "@", 
    RowBox[{"Slider2D", "[", 
     RowBox[{"ImageMargins", "\[Rule]", "m"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", 
     RowBox[{"{", 
      RowBox[{"Small", ",", "Medium", ",", "Large"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2036876092],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FrameBox[
    Slider2DBox[{0.5, 0.5},
     ImageMargins->Small],
    StripOnInput->False], ",", 
   FrameBox[
    Slider2DBox[{0.5, 0.5},
     ImageMargins->Medium],
    StripOnInput->False], ",", 
   FrameBox[
    Slider2DBox[{0.5, 0.5},
     ImageMargins->Large],
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{345, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6263125]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->250177698],

Cell["Set the image margin in printer's points:", "ExampleText",
 CellID->45456487],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Framed", "@", 
    RowBox[{"Slider2D", "[", 
     RowBox[{"ImageMargins", "\[Rule]", "m"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "5", ",", "10"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1854086683],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FrameBox[
    Slider2DBox[{0.5, 0.5},
     ImageMargins->0],
    StripOnInput->False], ",", 
   FrameBox[
    Slider2DBox[{0.5, 0.5},
     ImageMargins->5],
    StripOnInput->False], ",", 
   FrameBox[
    Slider2DBox[{0.5, 0.5},
     ImageMargins->10],
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{341, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->283522443]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ImageSize",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->385827153],

Cell["Use preset values:", "ExampleText",
 CellID->286784798],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Slider2D", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "s"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{"Tiny", ",", "Small", ",", "Medium", ",", "Large"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->173859533],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Slider2DBox[Dynamic[$CellContext`x],
    ImageSize->Tiny], ",", 
   Slider2DBox[Dynamic[$CellContext`x],
    ImageSize->Small], ",", 
   Slider2DBox[Dynamic[$CellContext`x],
    ImageSize->Medium], ",", 
   Slider2DBox[Dynamic[$CellContext`x],
    ImageSize->Large]}], "}"}]], "Output",
 ImageSize->{432, 203},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->38304221]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->186767476],

Cell["Use numerical values:", "ExampleText",
 CellID->780920219],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Slider2D", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"s", ",", "s"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{"30", ",", "50", ",", "100"}], "}"}]}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->840670805],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Slider2DBox[Dynamic[$CellContext`x],
    ImageSize->{30, 30}], ",", 
   Slider2DBox[Dynamic[$CellContext`x],
    ImageSize->{50, 50}], ",", 
   Slider2DBox[Dynamic[$CellContext`x],
    ImageSize->{100, 100}]}], "}"}]], "Output",
 ImageSize->{221, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->619899784]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9240],

Cell["A color selector:", "ExampleText",
 CellID->18862839],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Slider2D", "[", 
    RowBox[{"Dynamic", "[", "c", "]"}], "]"}], ",", 
   RowBox[{"Dynamic", "@", 
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Hue", "@@", "c"}], ",", 
        RowBox[{"Rectangle", "[", "]"}]}], "}"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "100"}]}], "]"}]}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16275],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Slider2DBox[Dynamic[$CellContext`c]], ",", 
   DynamicBox[ToBoxes[
     Graphics[{
       Apply[Hue, $CellContext`c], 
       Rectangle[]}, ImageSize -> 100], StandardForm],
    ImageSizeCache->{100., {48., 52.}}]}], "}"}]], "Output",
 ImageSize->{210, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->809105816]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->69443931],

Cell["A simple camera controller: ", "ExampleText",
 CellID->58966592],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"p", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"2", "\[Pi]"}], ",", "0"}], "}"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Slider2D", "[", 
      RowBox[{
       RowBox[{"Dynamic", "[", "p", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"2", "Pi"}], ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "Pi"}], "}"}]}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"ParametricPlot3D", "[", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"Cos", "[", "u", "]"}], " ", 
           RowBox[{"Cos", "[", "v", "]"}]}], ",", 
          RowBox[{
           RowBox[{"Sin", "[", "u", "]"}], " ", 
           RowBox[{"Cos", "[", "v", "]"}]}], ",", 
          RowBox[{"Sin", "[", "v", "]"}]}], "}"}], "3"], ",", " ", 
       RowBox[{"{", 
        RowBox[{"u", ",", "0", ",", 
         RowBox[{"2", "Pi"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"v", ",", 
         RowBox[{
          RowBox[{"-", "Pi"}], "/", "2"}], ",", 
         RowBox[{"Pi", "/", "2"}]}], "}"}], ",", 
       RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
       RowBox[{"Ticks", "\[Rule]", "None"}], ",", 
       RowBox[{"SphericalRegion", "\[Rule]", "True"}], ",", 
       RowBox[{"ViewPoint", "\[Rule]", 
        RowBox[{"Dynamic", "[", 
         RowBox[{"4", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"Cos", "[", 
              RowBox[{"p", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "]"}], 
             RowBox[{"Sin", "[", 
              RowBox[{"p", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"Sin", "[", 
              RowBox[{"p", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "]"}], 
             RowBox[{"Sin", "[", 
              RowBox[{"p", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "]"}]}], ",", 
            RowBox[{"Cos", "[", 
             RowBox[{"p", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "}"}]}], "]"}]}]}], 
      "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->254325476],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`p$$ = {3.6128315516282616`, 
  1.413716694115407}}, 
  RowBox[{"{", 
   RowBox[{
    Slider2DBox[Dynamic[
      BoxForm`RemapVariable[$CellContext`p$$, {{2 Pi, 0}, {0, Pi}}], 
      BoxForm`RemapValue[#, $CellContext`p$$, {{2 Pi, 0}, {0, Pi}}]& ], {{0, 
     0}, {1, 1}}], ",", 
    Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJyFXXlYTlsXpwyZh8gs8/ChFBVeLGXIHKWMmTOTuYiIDJmlkqFSposMkfGl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      "], {{
        {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxN3QeUPUXRBfDZ92ZFQHLOOWfJknMUJAcBiSogiChmFBAliCAiQZAs2QAK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           "]]]}, {}, {}, {}}, {}},
      VertexNormals->CompressedData["
1:eJx1XXk8l9n3b18U7TXRvi+INhV9TrRq0b7vWlRaqSSFklJpQdO+0kKbohAf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       "]],
     Axes->True,
     PlotRange->{All, All, All},
     PlotRangePadding->{Automatic, Automatic, Automatic},
     SphericalRegion->True,
     Ticks->None,
     ViewPoint->Dynamic[4 {Cos[
           Part[$CellContext`p$$, 1]] Sin[
           Part[$CellContext`p$$, 2]], Sin[
           Part[$CellContext`p$$, 1]] Sin[
           Part[$CellContext`p$$, 2]], 
         Cos[
          Part[$CellContext`p$$, 2]]}]]}], "}"}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{290, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->955817602]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1455],

Cell[TextData[{
 "A ",
 Cell[BoxData[
  ButtonBox["Locator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Locator"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["LocatorPane",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LocatorPane"]], "InlineFormula"],
 " can be used if the control should be contained within graphics:"
}], "ExampleText",
 CellID->330947770],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Slider2D", "[", 
    RowBox[{"Dynamic", "[", "pt1", "]"}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "pt1", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->116838381],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Slider2DBox[Dynamic[$CellContext`pt1]], ",", 
   DynamicBox[ToBoxes[$CellContext`pt1, StandardForm],
    ImageSizeCache->{53.1875, {2., 8.}}]}], "}"}]], "Output",
 ImageSize->{163, 83},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->228943359]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"pt2", "=", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Framed", "[", 
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Locator", "[", 
          RowBox[{"Dynamic", "[", "pt2", "]"}], "]"}], "}"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "1"}]}], "]"}], "]"}], ",", 
     RowBox[{"Dynamic", "[", "pt2", "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->505485847],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`pt2$$ = {0, 0}}, 
  RowBox[{"{", 
   RowBox[{
    FrameBox[
     GraphicsBox[LocatorBox[Dynamic[$CellContext`pt2$$]],
      PlotRange->1],
     StripOnInput->False], ",", 
    DynamicBox[ToBoxes[$CellContext`pt2$$, StandardForm],
     ImageSizeCache->{39.1875, {2., 8.}}]}], "}"}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{179, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->8643360]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"LocatorPane", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "pt3", "]"}], ",", 
     RowBox[{"Framed", "[", 
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"{", "}"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "1"}]}], "]"}], "]"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "pt3", "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->541283873],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   LocatorPaneBox[Dynamic[$CellContext`pt3], 
    FrameBox[
     GraphicsBox[{},
      PlotRange->1],
     StripOnInput->False]], ",", 
   DynamicBox[ToBoxes[$CellContext`pt3, StandardForm],
    ImageSizeCache->{124.5625, {2., 8.}}]}], "}"}]], "Output",
 ImageSize->{4, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[3]=",
 CellID->480326327]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28703],

Cell[TextData[{
 "The limits in ",
 Cell[BoxData[
  ButtonBox["Slider2D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Slider2D"]], "InlineFormula"],
 " are specified by giving coordinates of corners, not ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " ranges:"
}], "ExampleText",
 CellID->14604],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Slider2D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "/", "2"}], ",", 
     RowBox[{"1", "/", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2995],

Cell[BoxData[
 Slider2DBox[{0.535, 0.43}, {{0, 0}, {1, 1}}]], "Output",
 ImageSize->{84, 83},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16634872]
}, Open  ]],

Cell["The limits are identical, so the slider cannot move:", "ExampleText",
 CellID->3902],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Slider2D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "/", "2"}], ",", 
     RowBox[{"1", "/", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5436],

Cell[BoxData[
 Slider2DBox[{0, 1}, {{0, 1}, {0, 1}}]], "Output",
 ImageSize->{84, 83},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->32391]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22710],

Cell["Coupled sliders: ", "ExampleText",
 CellID->435591239],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Slider2D", "[", 
    RowBox[{"Dynamic", "[", "r", "]"}], "]"}], ",", 
   RowBox[{"Slider2D", "[", 
    RowBox[{"Dynamic", "[", 
     RowBox[{
      RowBox[{"1", "-", "r"}], ",", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"r", "=", 
         RowBox[{"1", "-", "#"}]}], ")"}], "&"}]}], "]"}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->519388525],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Slider2DBox[Dynamic[$CellContext`r]], ",", 
   Slider2DBox[Dynamic[1 - $CellContext`r, ($CellContext`r = 1 - #)& ]]}], 
  "}"}]], "Output",
 ImageSize->{190, 83},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->405808576]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27699],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["LocatorPane",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LocatorPane"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Locator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Locator"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Manipulate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Manipulate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Slider",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Slider"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["VerticalSlider",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VerticalSlider"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Inset",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Inset"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29599]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->30912],

Cell[TextData[ButtonBox["Introduction to Dynamic",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntroductionToDynamic"]], "Tutorials",
 CellID->445434225]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->413849650],

Cell[TextData[ButtonBox["Control Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ControlObjects"]], "MoreAbout",
 CellID->209908002],

Cell[TextData[ButtonBox["Dynamic Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DynamicVisualization"]], "MoreAbout",
 CellID->662988037]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Slider2D - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 21, 14.0584196}", "context" -> "System`", 
    "keywords" -> {
     "2D slider", "xy slider", "Cartesian slider", "coordinate slider", 
      "2D position slider"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Slider2D[{x, y}] represents a 2D slider with settings x and y in the \
range 0 to 1. Slider2D[Dynamic[pt]] takes the setting to be the dynamically \
updated current value of pt, with the value of pt being reset if the slider \
is moved. Slider2D[pt, {min, max}] represents a 2D slider with range min to \
max in each direction. Slider2D[pt, {min, max, d}] represents a 2D slider \
that jumps in steps d in each direction. Slider2D[pt, {{x_min, y_min}, \
{x_max, y_max}}] specifies different ranges in x and y directions. \
Slider2D[pt, {{x_min, y_min}, {x_max, y_max}, {dx, dy}}] uses jumps dx, dy.", 
    "synonyms" -> {"slider 2d"}, "title" -> "Slider2D", "type" -> "Symbol", 
    "uri" -> "ref/Slider2D"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[19283, 631, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->57406271]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 107556, 2834}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2396, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3019, 82, 1573, 37, 70, "ObjectNameGrid"],
Cell[4595, 121, 4802, 156, 70, "Usage",
 CellID->4670]
}, Open  ]],
Cell[CellGroupData[{
Cell[9434, 282, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[9912, 299, 362, 10, 70, "Notes",
 CellID->10631],
Cell[10277, 311, 634, 23, 70, "Notes",
 CellID->379],
Cell[10914, 336, 702, 27, 70, "Notes",
 CellID->19238],
Cell[11619, 365, 868, 33, 70, "Notes",
 CellID->14531],
Cell[12490, 400, 1121, 42, 70, "Notes",
 CellID->4738],
Cell[13614, 444, 555, 19, 70, "Notes",
 CellID->22065],
Cell[14172, 465, 1079, 42, 70, "Notes",
 CellID->11856],
Cell[15254, 509, 144, 4, 70, "Notes",
 CellID->15013],
Cell[15401, 515, 68, 1, 70, "Notes",
 CellID->7420],
Cell[15472, 518, 2980, 77, 70, "3ColumnTableMod",
 CellID->20383],
Cell[18455, 597, 345, 10, 70, "Notes",
 CellID->307511469],
Cell[18803, 609, 443, 17, 70, "Notes",
 CellID->7088]
}, Closed]],
Cell[CellGroupData[{
Cell[19283, 631, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->57406271],
Cell[CellGroupData[{
Cell[19667, 645, 146, 5, 70, "ExampleSection",
 CellID->9885374],
Cell[19816, 652, 75, 1, 70, "ExampleText",
 CellID->327036597],
Cell[CellGroupData[{
Cell[19916, 657, 149, 5, 28, "Input",
 CellID->25352],
Cell[20068, 664, 180, 6, 104, "Output",
 CellID->142246035]
}, Open  ]],
Cell[20263, 673, 120, 3, 70, "ExampleDelimiter",
 CellID->9139],
Cell[20386, 678, 82, 1, 70, "ExampleText",
 CellID->453920004],
Cell[CellGroupData[{
Cell[20493, 683, 218, 7, 70, "Input",
 CellID->20269],
Cell[20714, 692, 331, 10, 70, "Output",
 CellID->30778179]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21094, 708, 219, 7, 70, "ExampleSection",
 CellID->13169636],
Cell[21316, 717, 58, 1, 70, "ExampleText",
 CellID->178027514],
Cell[CellGroupData[{
Cell[21399, 722, 465, 16, 70, "Input",
 CellID->178405583],
Cell[21867, 740, 352, 10, 70, "Output",
 CellID->199183722]
}, Open  ]],
Cell[22234, 753, 124, 3, 70, "ExampleDelimiter",
 CellID->14817284],
Cell[22361, 758, 72, 1, 70, "ExampleText",
 CellID->156915461],
Cell[CellGroupData[{
Cell[22458, 763, 535, 18, 70, "Input",
 CellID->415982474],
Cell[22996, 783, 362, 10, 70, "Output",
 CellID->74656750]
}, Open  ]],
Cell[23373, 796, 121, 3, 70, "ExampleDelimiter",
 CellID->25643],
Cell[23497, 801, 140, 5, 70, "ExampleText",
 CellID->687636405],
Cell[23640, 808, 132, 4, 70, "Input",
 CellID->32189298],
Cell[23775, 814, 224, 8, 70, "ExampleText",
 CellID->545668548],
Cell[CellGroupData[{
Cell[24024, 826, 123, 4, 70, "Input",
 CellID->24274],
Cell[24150, 832, 210, 7, 36, "Output",
 CellID->315906352]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[24409, 845, 221, 7, 70, "ExampleSection",
 CellID->37532733],
Cell[CellGroupData[{
Cell[24655, 856, 231, 7, 70, "ExampleSubsection",
 CellID->579665997],
Cell[24889, 865, 98, 1, 70, "ExampleText",
 CellID->228866288],
Cell[CellGroupData[{
Cell[25012, 870, 292, 9, 70, "Input",
 CellID->469113643],
Cell[25307, 881, 353, 11, 70, "Output",
 CellID->75969109]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[25709, 898, 231, 7, 70, "ExampleSubsection",
 CellID->231878366],
Cell[25943, 907, 68, 1, 70, "ExampleText",
 CellID->108424938],
Cell[CellGroupData[{
Cell[26036, 912, 479, 15, 70, "Input",
 CellID->297116580],
Cell[26518, 929, 550, 19, 70, "Output",
 CellID->194694647]
}, Open  ]],
Cell[27083, 951, 125, 3, 70, "ExampleDelimiter",
 CellID->114659569],
Cell[27211, 956, 77, 1, 70, "ExampleText",
 CellID->690849739],
Cell[CellGroupData[{
Cell[27313, 961, 318, 9, 70, "Input",
 CellID->404816900],
Cell[27634, 972, 271, 9, 70, "Output",
 CellID->492740067]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[27954, 987, 237, 7, 70, "ExampleSubsection",
 CellID->122431969],
Cell[28194, 996, 96, 1, 70, "ExampleText",
 CellID->147138306],
Cell[CellGroupData[{
Cell[28315, 1001, 501, 16, 70, "Input",
 CellID->70754828],
Cell[28819, 1019, 554, 17, 70, "Output",
 CellID->59282758]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[29422, 1042, 236, 7, 70, "ExampleSubsection",
 CellID->78759265],
Cell[29661, 1051, 130, 4, 70, "ExampleText",
 CellID->901882983],
Cell[CellGroupData[{
Cell[29816, 1059, 222, 7, 70, "Input",
 CellID->357598064],
Cell[30041, 1068, 331, 10, 70, "Output",
 CellID->53765106]
}, Open  ]],
Cell[30387, 1081, 97, 1, 70, "ExampleText",
 CellID->324931920],
Cell[CellGroupData[{
Cell[30509, 1086, 299, 9, 70, "Input",
 CellID->470641416],
Cell[30811, 1097, 361, 11, 70, "Output",
 CellID->219236242]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[31221, 1114, 228, 7, 70, "ExampleSubsection",
 CellID->377515614],
Cell[31452, 1123, 207, 8, 70, "ExampleText",
 CellID->154813376],
Cell[CellGroupData[{
Cell[31684, 1135, 154, 5, 70, "Input",
 CellID->94729581],
Cell[31841, 1142, 182, 6, 70, "Output",
 CellID->235066354]
}, Open  ]],
Cell[32038, 1151, 102, 2, 70, "ExampleText",
 CellID->44441049],
Cell[CellGroupData[{
Cell[32165, 1157, 220, 7, 70, "Input",
 CellID->227336428],
Cell[32388, 1166, 198, 7, 70, "Output",
 CellID->493694664]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[32635, 1179, 233, 7, 70, "ExampleSubsection",
 CellID->306654534],
Cell[32871, 1188, 80, 1, 70, "ExampleText",
 CellID->92573072],
Cell[CellGroupData[{
Cell[32976, 1193, 362, 12, 70, "Input",
 CellID->2036876092],
Cell[33341, 1207, 484, 19, 70, "Output",
 CellID->6263125]
}, Open  ]],
Cell[33840, 1229, 125, 3, 70, "ExampleDelimiter",
 CellID->250177698],
Cell[33968, 1234, 83, 1, 70, "ExampleText",
 CellID->45456487],
Cell[CellGroupData[{
Cell[34076, 1239, 347, 11, 70, "Input",
 CellID->1854086683],
Cell[34426, 1252, 474, 19, 70, "Output",
 CellID->283522443]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[34949, 1277, 230, 7, 70, "ExampleSubsection",
 CellID->385827153],
Cell[35182, 1286, 61, 1, 70, "ExampleText",
 CellID->286784798],
Cell[CellGroupData[{
Cell[35268, 1291, 405, 13, 70, "Input",
 CellID->173859533],
Cell[35676, 1306, 460, 15, 70, "Output",
 CellID->38304221]
}, Open  ]],
Cell[36151, 1324, 125, 3, 70, "ExampleDelimiter",
 CellID->186767476],
Cell[36279, 1329, 64, 1, 70, "ExampleText",
 CellID->780920219],
Cell[CellGroupData[{
Cell[36368, 1334, 435, 15, 70, "Input",
 CellID->840670805],
Cell[36806, 1351, 403, 13, 70, "Output",
 CellID->619899784]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[37270, 1371, 222, 7, 70, "ExampleSection",
 CellID->9240],
Cell[37495, 1380, 59, 1, 70, "ExampleText",
 CellID->18862839],
Cell[CellGroupData[{
Cell[37579, 1385, 443, 14, 70, "Input",
 CellID->16275],
Cell[38025, 1401, 409, 13, 70, "Output",
 CellID->809105816]
}, Open  ]],
Cell[38449, 1417, 124, 3, 70, "ExampleDelimiter",
 CellID->69443931],
Cell[38576, 1422, 70, 1, 70, "ExampleText",
 CellID->58966592],
Cell[CellGroupData[{
Cell[38671, 1427, 2419, 70, 70, "Input",
 CellID->254325476],
Cell[41093, 1499, 55364, 922, 70, "Output",
 CellID->955817602]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[96506, 2427, 232, 7, 70, "ExampleSection",
 CellID->1455],
Cell[96741, 2436, 380, 13, 70, "ExampleText",
 CellID->330947770],
Cell[CellGroupData[{
Cell[97146, 2453, 226, 7, 70, "Input",
 CellID->116838381],
Cell[97375, 2462, 336, 10, 70, "Output",
 CellID->228943359]
}, Open  ]],
Cell[CellGroupData[{
Cell[97748, 2477, 584, 18, 70, "Input",
 CellID->505485847],
Cell[98335, 2497, 548, 16, 70, "Output",
 CellID->8643360]
}, Open  ]],
Cell[CellGroupData[{
Cell[98920, 2518, 425, 13, 70, "Input",
 CellID->541283873],
Cell[99348, 2533, 474, 15, 70, "Output",
 CellID->480326327]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[99871, 2554, 226, 7, 70, "ExampleSection",
 CellID->28703],
Cell[100100, 2563, 382, 14, 70, "ExampleText",
 CellID->14604],
Cell[CellGroupData[{
Cell[100507, 2581, 378, 14, 70, "Input",
 CellID->2995],
Cell[100888, 2597, 200, 6, 70, "Output",
 CellID->16634872]
}, Open  ]],
Cell[101103, 2606, 90, 1, 70, "ExampleText",
 CellID->3902],
Cell[CellGroupData[{
Cell[101218, 2611, 378, 14, 70, "Input",
 CellID->5436],
Cell[101599, 2627, 190, 6, 70, "Output",
 CellID->32391]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[101838, 2639, 224, 7, 70, "ExampleSection",
 CellID->22710],
Cell[102065, 2648, 60, 1, 70, "ExampleText",
 CellID->435591239],
Cell[CellGroupData[{
Cell[102150, 2653, 424, 15, 70, "Input",
 CellID->519388525],
Cell[102577, 2670, 313, 10, 70, "Output",
 CellID->405808576]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[102951, 2687, 311, 9, 70, "SeeAlsoSection",
 CellID->27699],
Cell[103265, 2698, 1441, 53, 70, "SeeAlso",
 CellID->29599]
}, Open  ]],
Cell[CellGroupData[{
Cell[104743, 2756, 314, 9, 70, "TutorialsSection",
 CellID->30912],
Cell[105060, 2767, 159, 3, 70, "Tutorials",
 CellID->445434225]
}, Open  ]],
Cell[CellGroupData[{
Cell[105256, 2775, 319, 9, 70, "MoreAboutSection",
 CellID->413849650],
Cell[105578, 2786, 141, 3, 70, "MoreAbout",
 CellID->209908002],
Cell[105722, 2791, 153, 3, 70, "MoreAbout",
 CellID->662988037]
}, Open  ]],
Cell[105890, 2797, 27, 0, 70, "History"],
Cell[105920, 2799, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

