(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     31326,       1283]
NotebookOptionsPosition[     23190,        985]
NotebookOutlinePosition[     24569,       1024]
CellTagsIndexPosition[     24483,       1019]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Pure Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/PureFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Pure Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SlotSequence" :> 
          Documentation`HelpLookup["paclet:ref/SlotSequence"], "Function" :> 
          Documentation`HelpLookup["paclet:ref/Function"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"SlotSequence\"\>", 
       2->"\<\"Function\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Functional Programming" :> 
          Documentation`HelpLookup["paclet:guide/FunctionalProgramming"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Functional Programming\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Slot ",
 StyleBox["(#)", "OperatorCharacter"]
}], "ObjectName",
 CellID->1155],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["#"], "InlineFormula"],
     "\[LineSeparator]represents the first argument supplied to a pure \
function. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"#", 
       StyleBox["n", "TI"]}]], "InlineFormula"],
     "\[LineSeparator]represents the ",
     Cell[BoxData[
      SuperscriptBox[
       StyleBox[
        RowBox[{
         StyleBox["n", "TI"], "\[Null]"}]], "th"]], "InlineFormula"],
     " argument. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->24623]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["#"], "InlineFormula"],
 " is used to represent arguments or formal parameters in pure functions of \
the form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["body", "TI"], "&"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Function",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Function"], "[", 
   StyleBox["body", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->20725],

Cell[TextData[{
 Cell[BoxData["#"], "InlineFormula"],
 "\[NonBreakingSpace]is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Slot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Slot"], "[", "1", "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->28401],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"#", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Slot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Slot"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula", "TemplateInclusion"],
 ". ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " must be a non\[Hyphen]negative integer. "
}], "Notes",
 CellID->4355],

Cell[TextData[{
 Cell[BoxData["#0"], "InlineFormula"],
 " gives the head of the function, i.e., the pure function itself. "
}], "Notes",
 CellID->4077]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->265655238],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->116524408],

Cell[TextData[{
 Cell[BoxData["#"], "InlineFormula"],
 " represents the first argument of a pure function:"
}], "ExampleText",
 CellID->31578],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"#", ",", "a", ",", "#", ",", "b"}], "]"}], "&"}], "[", 
  RowBox[{"x", ",", "y"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29537],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"x", ",", "a", ",", "x", ",", "b"}], "]"}]], "Output",
 ImageSize->{87, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->284120563]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15940],

Cell["Use numbered arguments:", "ExampleText",
 CellID->23492],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"#1", ",", "#2", ",", "#1", ",", "#3"}], "]"}], "&"}], "[", 
  RowBox[{"x", ",", "y", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11350],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"x", ",", "y", ",", "x", ",", "z"}], "]"}]], "Output",
 ImageSize->{87, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->88786492]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->298033249],

Cell[TextData[{
 Cell[BoxData["#"], "InlineFormula"],
 " is short for #1, the first argument:"
}], "ExampleText",
 CellID->2099147608],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"#", "&"}], "[", 
  RowBox[{"1", ",", "2", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2110718288],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1598288704]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"#1", "&"}], "[", 
  RowBox[{"1", ",", "2", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1412192477],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2036587626]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24637],

Cell[TextData[{
 Cell[BoxData["#0"], "InlineFormula"],
 " stands for the whole pure function:"
}], "ExampleText",
 CellID->22141],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "#0", "]"}], "&"}], "[", "x", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8102],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"f", "[", "#0", "]"}], "&"}], "]"}]], "Output",
 ImageSize->{71, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->56374574]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15073],

Cell["Programmatically create a pure function of 5 arguments:", "ExampleText",
 CellID->11661],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Function", "[", 
  RowBox[{"Evaluate", "[", 
   RowBox[{"f", "@@", 
    RowBox[{"Array", "[", 
     RowBox[{"Slot", ",", "5"}], "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27935],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"#1", ",", "#2", ",", "#3", ",", "#4", ",", "#5"}], "]"}], 
  "&"}]], "Output",
 ImageSize->{151, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->247350022]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "@@", 
  RowBox[{"Range", "[", "10", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1273],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "]"}]], "Output",
 ImageSize->{105, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->264012768]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28755],

Cell[TextData[{
 Cell[BoxData["#"], "InlineFormula"],
 " allows function arguments to be referenced without giving them names:"
}], "ExampleText",
 CellID->29247],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Function", "[", 
   RowBox[{"u", ",", 
    RowBox[{"1", "+", "u"}]}], "]"}], "[", "x", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20088],

Cell[BoxData[
 RowBox[{"1", "+", "x"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17054898]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", "#"}], ")"}], "&"}], "[", "x", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7733],

Cell[BoxData[
 RowBox[{"1", "+", "x"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->11208018]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23549],

Cell["Additional arguments are ignored:", "ExampleText",
 CellID->17855],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"#1", ",", "#2"}], "]"}], "&"}], "[", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18907],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"a", ",", "b"}], "]"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->272623026]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->254914705],

Cell[TextData[{
 Cell[BoxData["##"], "InlineFormula"],
 " stands for the sequence of all arguments:"
}], "ExampleText",
 CellID->749480516],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"#1", ",", "#2", ",", "#3"}], "}"}], "&"}], "[", 
  RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1265331868],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->565140873]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", "##", "}"}], "&"}], "[", 
  RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1283000320],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->260998970]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19399],

Cell["Use explicit names to set up nested pure functions:", "ExampleText",
 CellID->21069],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Function", "[", 
   RowBox[{"u", ",", 
    RowBox[{"Function", "[", 
     RowBox[{"v", ",", 
      RowBox[{"f", "[", 
       RowBox[{"u", ",", "v"}], "]"}]}], "]"}]}], "]"}], "[", "x", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9133],

Cell[BoxData[
 RowBox[{"Function", "[", 
  RowBox[{"v$", ",", 
   RowBox[{"f", "[", 
    RowBox[{"x", ",", "v$"}], "]"}]}], "]"}]], "Output",
 ImageSize->{153, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->135745840]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Function", "[", 
    RowBox[{"u", ",", 
     RowBox[{"Function", "[", 
      RowBox[{"v", ",", 
       RowBox[{"f", "[", 
        RowBox[{"u", ",", "v"}], "]"}]}], "]"}]}], "]"}], "[", "x", "]"}], 
  "[", "y", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29357],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"x", ",", "y"}], "]"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->751256484]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData["#"], "InlineFormula"],
 " for the inner function:"
}], "ExampleText",
 CellID->91014374],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Function", "[", 
   RowBox[{"u", ",", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"u", ",", "#"}], "]"}], "&"}]}], "]"}], "[", "x", 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->872578260],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"x", ",", "#1"}], "]"}], "&"}]], "Output",
 ImageSize->{68, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1298825]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Function", "[", 
    RowBox[{"u", ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"u", ",", "#"}], "]"}], "&"}]}], "]"}], "[", "x", "]"}], "[", 
  "y", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->68213856],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"x", ",", "y"}], "]"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->402247709]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData["#"], "InlineFormula"],
 " for the outer function: "
}], "ExampleText",
 CellID->76327444],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Function", "[", 
    RowBox[{"v", ",", 
     RowBox[{"f", "[", 
      RowBox[{"#", ",", "v"}], "]"}]}], "]"}], "&"}], "[", "x", 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->20500],

Cell[BoxData[
 RowBox[{"Function", "[", 
  RowBox[{"v", ",", 
   RowBox[{"f", "[", 
    RowBox[{"x", ",", "v"}], "]"}]}], "]"}]], "Output",
 ImageSize->{139, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->352049211]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Function", "[", 
     RowBox[{"v", ",", 
      RowBox[{"f", "[", 
       RowBox[{"#", ",", "v"}], "]"}]}], "]"}], "&"}], "[", "x", "]"}], "[", 
  "y", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->124365896],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"x", ",", "y"}], "]"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->314334390]
}, Open  ]],

Cell[TextData[{
 "Using nested ",
 Cell[BoxData["#"], "InlineFormula"],
 " notation behaves differently:"
}], "ExampleText",
 CellID->253773453],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"#", ",", "#"}], "]"}], "&"}], " ", "&"}], "[", "x", 
  "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->157658948],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"#1", ",", "#1"}], "]"}], "&"}]], "Output",
 ImageSize->{75, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->779149042]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"#", ",", "#"}], "]"}], "&"}], " ", "&"}], "[", "x", "]"}], "[",
   "y", "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->523577125],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"y", ",", "y"}], "]"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->480047099]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->298161947],

Cell["If too few arguments are provided, a message is generated:", \
"ExampleText",
 CellID->17638],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "#4", "]"}], "&"}], "[", 
  RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31656],

Cell[BoxData[
 RowBox[{
  RowBox[{"Function", "::", "\<\"slotn\"\>"}], ":", 
  " ", "\<\"Slot number \\!\\(4\\) in \\!\\(\\(\\(f[#4]\\)\\) &\\) cannot be \
filled from \\!\\(\\(\\((\\(\\(\\(f[#4]\\)\\) &\\))\\)\\)[\\(\\(a, b, \
c\\)\\)]\\). \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Function/slotn\\\", ButtonNote -> \
\\\"Function::slotn\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->13355607],

Cell[BoxData[
 RowBox[{"f", "[", "#4", "]"}]], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->776011259]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "#4", "]"}], "&"}], "[", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->20005],

Cell[BoxData[
 RowBox[{"f", "[", "d", "]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->88867526]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15627],

Cell[TextData[{
 "A recursive definition for factorial using ",
 Cell[BoxData["#0"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->3540],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"#1", "\[Equal]", "1"}], ",", "1", ",", 
     RowBox[{"#1", " ", 
      RowBox[{"#0", "[", 
       RowBox[{"#1", "-", "1"}], "]"}]}]}], "]"}], "&"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11021],

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"#1", "\[Equal]", "1"}], ",", "1", ",", 
    RowBox[{"#1", " ", 
     RowBox[{"#0", "[", 
      RowBox[{"#1", "-", "1"}], "]"}]}]}], "]"}], "&"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->40508155]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "10", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14262],

Cell[BoxData["3628800"], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->12039624]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"10", "!"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->53113854],

Cell[BoxData["3628800"], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->365904586]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->717],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SlotSequence",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SlotSequence"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Function",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Function"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20472]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->6200],

Cell[TextData[ButtonBox["Pure Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PureFunctions"]], "Tutorials",
 CellID->4845]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->79128900],

Cell[TextData[ButtonBox["Functional Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionalProgramming"]], "MoreAbout",
 CellID->142757718]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Slot (#) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 21, 21.9648720}", "context" -> "System`", 
    "keywords" -> {
     "crunch", "gate", "hash sign", "number sign", "octothorp", "octothorpe", 
      "pounds sign", "scratch mark", "sharp", "slot"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "# represents the first argument supplied to a pure function. # n \
represents the n\\[Null] th argument. ", 
    "synonyms" -> {"#", "#1", "#2", "#0"}, "title" -> "Slot", "type" -> 
    "Symbol", "uri" -> "ref/Slot"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5093, 182, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->265655238]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 24340, 1012}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1832, 47, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2455, 74, 96, 4, 70, "ObjectName",
 CellID->1155],
Cell[2554, 80, 683, 23, 70, "Usage",
 CellID->24623]
}, Open  ]],
Cell[CellGroupData[{
Cell[3274, 108, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3752, 125, 439, 16, 70, "Notes",
 CellID->20725],
Cell[4194, 143, 271, 10, 70, "Notes",
 CellID->28401],
Cell[4468, 155, 434, 16, 70, "Notes",
 CellID->4355],
Cell[4905, 173, 151, 4, 70, "Notes",
 CellID->4077]
}, Closed]],
Cell[CellGroupData[{
Cell[5093, 182, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->265655238],
Cell[CellGroupData[{
Cell[5478, 196, 148, 5, 70, "ExampleSection",
 CellID->116524408],
Cell[5629, 203, 142, 4, 70, "ExampleText",
 CellID->31578],
Cell[CellGroupData[{
Cell[5796, 211, 208, 7, 28, "Input",
 CellID->29537],
Cell[6007, 220, 228, 7, 36, "Output",
 CellID->284120563]
}, Open  ]],
Cell[6250, 230, 121, 3, 70, "ExampleDelimiter",
 CellID->15940],
Cell[6374, 235, 62, 1, 70, "ExampleText",
 CellID->23492],
Cell[CellGroupData[{
Cell[6461, 240, 222, 7, 70, "Input",
 CellID->11350],
Cell[6686, 249, 227, 7, 36, "Output",
 CellID->88786492]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6962, 262, 220, 7, 70, "ExampleSection",
 CellID->298033249],
Cell[7185, 271, 134, 4, 70, "ExampleText",
 CellID->2099147608],
Cell[CellGroupData[{
Cell[7344, 279, 149, 5, 70, "Input",
 CellID->2110718288],
Cell[7496, 286, 159, 5, 36, "Output",
 CellID->1598288704]
}, Open  ]],
Cell[CellGroupData[{
Cell[7692, 296, 150, 5, 70, "Input",
 CellID->1412192477],
Cell[7845, 303, 159, 5, 36, "Output",
 CellID->2036587626]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[8053, 314, 239, 7, 70, "ExampleSection",
 CellID->24637],
Cell[8295, 323, 129, 4, 70, "ExampleText",
 CellID->22141],
Cell[CellGroupData[{
Cell[8449, 331, 140, 5, 70, "Input",
 CellID->8102],
Cell[8592, 338, 232, 8, 36, "Output",
 CellID->56374574]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[8873, 352, 223, 7, 70, "ExampleSection",
 CellID->15073],
Cell[9099, 361, 94, 1, 70, "ExampleText",
 CellID->11661],
Cell[CellGroupData[{
Cell[9218, 366, 223, 7, 70, "Input",
 CellID->27935],
Cell[9444, 375, 266, 9, 36, "Output",
 CellID->247350022]
}, Open  ]],
Cell[CellGroupData[{
Cell[9747, 389, 121, 4, 70, "Input",
 CellID->1273],
Cell[9871, 395, 239, 7, 36, "Output",
 CellID->264012768]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10159, 408, 233, 7, 70, "ExampleSection",
 CellID->28755],
Cell[10395, 417, 162, 4, 70, "ExampleText",
 CellID->29247],
Cell[CellGroupData[{
Cell[10582, 425, 177, 6, 70, "Input",
 CellID->20088],
Cell[10762, 433, 179, 6, 36, "Output",
 CellID->17054898]
}, Open  ]],
Cell[CellGroupData[{
Cell[10978, 444, 159, 6, 70, "Input",
 CellID->7733],
Cell[11140, 452, 179, 6, 36, "Output",
 CellID->11208018]
}, Open  ]],
Cell[11334, 461, 121, 3, 70, "ExampleDelimiter",
 CellID->23549],
Cell[11458, 466, 72, 1, 70, "ExampleText",
 CellID->17855],
Cell[CellGroupData[{
Cell[11555, 471, 210, 7, 70, "Input",
 CellID->18907],
Cell[11768, 480, 208, 7, 36, "Output",
 CellID->272623026]
}, Open  ]],
Cell[11991, 490, 125, 3, 70, "ExampleDelimiter",
 CellID->254914705],
Cell[12119, 495, 139, 4, 70, "ExampleText",
 CellID->749480516],
Cell[CellGroupData[{
Cell[12283, 503, 211, 7, 70, "Input",
 CellID->1265331868],
Cell[12497, 512, 213, 7, 36, "Output",
 CellID->565140873]
}, Open  ]],
Cell[CellGroupData[{
Cell[12747, 524, 174, 6, 70, "Input",
 CellID->1283000320],
Cell[12924, 532, 213, 7, 36, "Output",
 CellID->260998970]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13186, 545, 226, 7, 70, "ExampleSection",
 CellID->19399],
Cell[13415, 554, 90, 1, 70, "ExampleText",
 CellID->21069],
Cell[CellGroupData[{
Cell[13530, 559, 277, 10, 70, "Input",
 CellID->9133],
Cell[13810, 571, 272, 9, 36, "Output",
 CellID->135745840]
}, Open  ]],
Cell[CellGroupData[{
Cell[14119, 585, 312, 11, 70, "Input",
 CellID->29357],
Cell[14434, 598, 208, 7, 36, "Output",
 CellID->751256484]
}, Open  ]],
Cell[14657, 608, 128, 5, 70, "ExampleText",
 CellID->91014374],
Cell[CellGroupData[{
Cell[14810, 617, 237, 9, 70, "Input",
 CellID->872578260],
Cell[15050, 628, 226, 8, 36, "Output",
 CellID->1298825]
}, Open  ]],
Cell[CellGroupData[{
Cell[15313, 641, 269, 10, 70, "Input",
 CellID->68213856],
Cell[15585, 653, 208, 7, 36, "Output",
 CellID->402247709]
}, Open  ]],
Cell[15808, 663, 129, 5, 70, "ExampleText",
 CellID->76327444],
Cell[CellGroupData[{
Cell[15962, 672, 233, 9, 70, "Input",
 CellID->20500],
Cell[16198, 683, 270, 9, 36, "Output",
 CellID->352049211]
}, Open  ]],
Cell[CellGroupData[{
Cell[16505, 697, 270, 10, 70, "Input",
 CellID->124365896],
Cell[16778, 709, 208, 7, 36, "Output",
 CellID->314334390]
}, Open  ]],
Cell[17001, 719, 144, 5, 70, "ExampleText",
 CellID->253773453],
Cell[CellGroupData[{
Cell[17170, 728, 198, 8, 70, "Input",
 CellID->157658948],
Cell[17371, 738, 229, 8, 36, "Output",
 CellID->779149042]
}, Open  ]],
Cell[CellGroupData[{
Cell[17637, 751, 230, 9, 70, "Input",
 CellID->523577125],
Cell[17870, 762, 208, 7, 36, "Output",
 CellID->480047099]
}, Open  ]],
Cell[18093, 772, 125, 3, 70, "ExampleDelimiter",
 CellID->298161947],
Cell[18221, 777, 99, 2, 70, "ExampleText",
 CellID->17638],
Cell[CellGroupData[{
Cell[18345, 783, 174, 6, 70, "Input",
 CellID->31656],
Cell[18522, 791, 480, 9, 70, "Message",
 CellID->13355607],
Cell[19005, 802, 186, 6, 36, "Output",
 CellID->776011259]
}, Open  ]],
Cell[CellGroupData[{
Cell[19228, 813, 184, 6, 70, "Input",
 CellID->20005],
Cell[19415, 821, 184, 6, 36, "Output",
 CellID->88867526]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19648, 833, 224, 7, 70, "ExampleSection",
 CellID->15627],
Cell[19875, 842, 141, 5, 70, "ExampleText",
 CellID->3540],
Cell[CellGroupData[{
Cell[20041, 851, 294, 10, 70, "Input",
 CellID->11021],
Cell[20338, 863, 357, 12, 36, "Output",
 CellID->40508155]
}, Open  ]],
Cell[CellGroupData[{
Cell[20732, 880, 94, 3, 70, "Input",
 CellID->14262],
Cell[20829, 885, 163, 5, 36, "Output",
 CellID->12039624]
}, Open  ]],
Cell[CellGroupData[{
Cell[21029, 895, 87, 3, 70, "Input",
 CellID->53113854],
Cell[21119, 900, 164, 5, 36, "Output",
 CellID->365904586]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21344, 912, 309, 9, 70, "SeeAlsoSection",
 CellID->717],
Cell[21656, 923, 459, 17, 70, "SeeAlso",
 CellID->20472]
}, Open  ]],
Cell[CellGroupData[{
Cell[22152, 945, 313, 9, 70, "TutorialsSection",
 CellID->6200],
Cell[22468, 956, 137, 3, 70, "Tutorials",
 CellID->4845]
}, Open  ]],
Cell[CellGroupData[{
Cell[22642, 964, 318, 9, 70, "MoreAboutSection",
 CellID->79128900],
Cell[22963, 975, 155, 3, 70, "MoreAbout",
 CellID->142757718]
}, Open  ]],
Cell[23133, 981, 27, 0, 70, "History"],
Cell[23163, 983, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

