(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     31703,       1161]
NotebookOptionsPosition[     25476,        948]
NotebookOutlinePosition[     26867,        987]
CellTagsIndexPosition[     26782,        982]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Partitioning Data into Clusters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PartitioningDataIntoClusters"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Partitioning Data into Clusters\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"JaccardDissimilarity" :> 
          Documentation`HelpLookup["paclet:ref/JaccardDissimilarity"], 
          "DiceDissimilarity" :> 
          Documentation`HelpLookup["paclet:ref/DiceDissimilarity"], 
          "MatchingDissimilarity" :> 
          Documentation`HelpLookup["paclet:ref/MatchingDissimilarity"], 
          "RogersTanimotoDissimilarity" :> 
          Documentation`HelpLookup["paclet:ref/RogersTanimotoDissimilarity"], 
          "RussellRaoDissimilarity" :> 
          Documentation`HelpLookup["paclet:ref/RussellRaoDissimilarity"], 
          "YuleDissimilarity" :> 
          Documentation`HelpLookup["paclet:ref/YuleDissimilarity"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"JaccardDissimilarity\"\>", 
       2->"\<\"DiceDissimilarity\"\>", 3->"\<\"MatchingDissimilarity\"\>", 
       4->"\<\"RogersTanimotoDissimilarity\"\>", 
       5->"\<\"RussellRaoDissimilarity\"\>", 
       6->"\<\"YuleDissimilarity\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Distance and Dissimilarity Measures" :> 
          Documentation`HelpLookup[
           "paclet:guide/DistanceAndDissimilarityMeasures"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Distance and Dissimilarity Measures\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["SokalSneathDissimilarity", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SokalSneathDissimilarity",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SokalSneathDissimilarity"], "[", 
       RowBox[{
        StyleBox["u", "TI"], ",", 
        StyleBox["v", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Sokal\[Dash]Sneath dissimilarity between \
Boolean vectors ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["v", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->13330]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SokalSneathDissimilarity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SokalSneathDissimilarity"]], "InlineFormula"],
 " works for both ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " vectors and ",
 Cell[BoxData["0"], "InlineFormula"],
 ", ",
 Cell[BoxData["1"], "InlineFormula"],
 " vectors."
}], "Notes",
 CellID->38632218],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SokalSneathDissimilarity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SokalSneathDissimilarity"], "[", 
   RowBox[{
    StyleBox["u", "TI"], ",", 
    StyleBox["v", "TI"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["n", "10"], "+", 
       SubscriptBox["n", "01"]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["n", "11"], "+", 
       RowBox[{"2", 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["n", "10"], "+", 
          SubscriptBox["n", "01"]}], ")"}]}]}], ")"}]}]}], TraditionalForm]], 
  "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["n", 
    RowBox[{"i", "\[InvisibleSpace]", "j"}]], TraditionalForm]], 
  "InlineMath"],
 " is the number of corresponding pairs of elements in ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["v", TraditionalForm]], "InlineMath"],
 " respectively equal to ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["j", TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->72507031]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->673712821],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->57352771],

Cell["\<\
Sokal\[Hyphen]Sneath dissimilarity between two Boolean vectors:\
\>", "ExampleText",
 CellID->235641551],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SokalSneathDissimilarity", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "1", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0", ",", "1", ",", "1"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->342070674],

Cell[BoxData[
 FractionBox["3", "4"]], "Output",
 ImageSize->{16, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->338486580]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->829874330],

Cell[TextData[{
 "The elements can also be ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->127306229],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SokalSneathDissimilarity", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"True", ",", "False", ",", "True"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "True", ",", "False"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->279206382],

Cell[BoxData[
 FractionBox["4", "5"]], "Output",
 ImageSize->{16, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->422830851]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31982],

Cell[TextData[{
 "Compute dissimilarity between any ",
 Cell[BoxData[
  FormBox[
   RowBox[{"0", ",", "1"}], TraditionalForm]], "InlineMath"],
 " vectors of equal length:"
}], "ExampleText",
 CellID->86273121],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SokalSneathDissimilarity", "[", 
  RowBox[{
   RowBox[{"RandomInteger", "[", 
    RowBox[{"1", ",", "100"}], "]"}], ",", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"1", ",", "100"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->488208944],

Cell[BoxData[
 FractionBox["7", "9"]], "Output",
 ImageSize->{16, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->222104389]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->204991544],

Cell[TextData[{
 "Compute dissimilarity between any ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " vectors of equal length:"
}], "ExampleText",
 CellID->14044010],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SokalSneathDissimilarity", "[", 
  RowBox[{
   RowBox[{"RandomChoice", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}], ",", "1000"}], "]"}], ",", 
   RowBox[{"RandomChoice", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}], ",", "1000"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->323525768],

Cell[BoxData[
 FractionBox["163", "205"]], "Output",
 ImageSize->{30, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->91419534]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21794],

Cell[TextData[{
 "Cluster ",
 Cell[BoxData[
  FormBox[
   RowBox[{"0", ",", "1"}], TraditionalForm]], "InlineMath"],
 " data using Sokal\[Dash]Sneath dissimilarity:"
}], "ExampleText",
 CellID->245478961],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindClusters", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"DistanceFunction", "\[Rule]", "SokalSneathDissimilarity"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->108189764],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{237, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->531475678]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->478877783],

Cell[TextData[{
 "Cluster",
 " ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " ",
 "data using Sokal\[Dash]Sneath dissimilarity:"
}], "ExampleText",
 CellID->68571327],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindClusters", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"False", ",", "True"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "True"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"False", ",", "False"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}]}], "}"}], ",", 
   RowBox[{"DistanceFunction", "\[Rule]", "SokalSneathDissimilarity"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->174963025],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"False", ",", "True"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "True"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"False", ",", "False"}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{433, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13681652]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6608],

Cell["\<\
Sokal\[Dash]Sneath dissimilarity is bounded by 0 and 1:\
\>", "ExampleText",
 CellID->482006564],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SokalSneathDissimilarity", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->107213585],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->313081617]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SokalSneathDissimilarity", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->582164693],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->281222037]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->787503120],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SokalSneathDissimilarity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SokalSneathDissimilarity"]], "InlineFormula"],
 " is greater than or equal to ",
 Cell[BoxData[
  ButtonBox["JaccardDissimilarity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JaccardDissimilarity"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->513369211],

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"1", ",", "100"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"1", ",", "100"}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->118519341],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SokalSneathDissimilarity", "[", 
   RowBox[{"u", ",", "v"}], "]"}], "\[GreaterEqual]", 
  RowBox[{"JaccardDissimilarity", "[", 
   RowBox[{"u", ",", "v"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->37948204],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->485022896]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->402417664],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SokalSneathDissimilarity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SokalSneathDissimilarity"]], "InlineFormula"],
 " is greater than or equal to ",
 Cell[BoxData[
  ButtonBox["DiceDissimilarity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DiceDissimilarity"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->82073186],

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"1", ",", "100"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"1", ",", "100"}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->593562083],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SokalSneathDissimilarity", "[", 
   RowBox[{"u", ",", "v"}], "]"}], "\[GreaterEqual]", 
  RowBox[{"DiceDissimilarity", "[", 
   RowBox[{"u", ",", "v"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->197212249],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->88686079]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->52926977],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SokalSneathDissimilarity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SokalSneathDissimilarity"]], "InlineFormula"],
 " is greater than or equal to ",
 Cell[BoxData[
  ButtonBox["MatchingDissimilarity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatchingDissimilarity"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->432064913],

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"1", ",", "100"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"1", ",", "100"}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->2521331],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SokalSneathDissimilarity", "[", 
   RowBox[{"u", ",", "v"}], "]"}], "\[GreaterEqual]", 
  RowBox[{"MatchingDissimilarity", "[", 
   RowBox[{"u", ",", "v"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->154730870],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->744449348]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->304312130],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SokalSneathDissimilarity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SokalSneathDissimilarity"]], "InlineFormula"],
 " is greater than or equal to ",
 Cell[BoxData[
  ButtonBox["RogersTanimotoDissimilarity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RogersTanimotoDissimilarity"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->195420953],

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"1", ",", "100"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"1", ",", "100"}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->16527881],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SokalSneathDissimilarity", "[", 
   RowBox[{"u", ",", "v"}], "]"}], "\[GreaterEqual]", 
  RowBox[{"RogersTanimotoDissimilarity", "[", 
   RowBox[{"u", ",", "v"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5508493],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->121404862]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6766],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["JaccardDissimilarity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JaccardDissimilarity"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DiceDissimilarity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DiceDissimilarity"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MatchingDissimilarity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MatchingDissimilarity"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RogersTanimotoDissimilarity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RogersTanimotoDissimilarity"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RussellRaoDissimilarity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RussellRaoDissimilarity"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["YuleDissimilarity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/YuleDissimilarity"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13985]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->8928],

Cell[TextData[ButtonBox["Partitioning Data into Clusters",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PartitioningDataIntoClusters"]], "Tutorials",
 CellID->22256]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with SokalSneathDissimilarity",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=\
SokalSneathDissimilarity"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->636469],

Cell[TextData[ButtonBox["Distance and Dissimilarity Measures",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DistanceAndDissimilarityMeasures"]], "MoreAbout",
 CellID->269457188]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SokalSneathDissimilarity - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 21, 26.0899776}", "context" -> "System`", 
    "keywords" -> {
     "Sokal Sneath dissimilarity", "Sokal\\[Hyphen]Sneath dissimilarity"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "SokalSneathDissimilarity[u, v] gives the Sokal\\[Dash]Sneath \
dissimilarity between Boolean vectors u and v.", 
    "synonyms" -> {"sokal sneath dissimilarity"}, "title" -> 
    "SokalSneathDissimilarity", "type" -> "Symbol", "uri" -> 
    "ref/SokalSneathDissimilarity"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7989, 249, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->673712821]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 26639, 975}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2629, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3252, 89, 1589, 37, 70, "ObjectNameGrid"],
Cell[4844, 128, 751, 24, 70, "Usage",
 CellID->13330]
}, Open  ]],
Cell[CellGroupData[{
Cell[5632, 157, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6110, 174, 564, 21, 70, "Notes",
 CellID->38632218],
Cell[6677, 197, 1275, 47, 70, "Notes",
 CellID->72507031]
}, Closed]],
Cell[CellGroupData[{
Cell[7989, 249, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->673712821],
Cell[CellGroupData[{
Cell[8374, 263, 147, 5, 70, "ExampleSection",
 CellID->57352771],
Cell[8524, 270, 114, 3, 70, "ExampleText",
 CellID->235641551],
Cell[CellGroupData[{
Cell[8663, 277, 304, 9, 28, "Input",
 CellID->342070674],
Cell[8970, 288, 178, 6, 51, "Output",
 CellID->338486580]
}, Open  ]],
Cell[9163, 297, 125, 3, 70, "ExampleDelimiter",
 CellID->829874330],
Cell[9291, 302, 323, 13, 70, "ExampleText",
 CellID->127306229],
Cell[CellGroupData[{
Cell[9639, 319, 281, 8, 70, "Input",
 CellID->279206382],
Cell[9923, 329, 178, 6, 51, "Output",
 CellID->422830851]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10150, 341, 216, 7, 70, "ExampleSection",
 CellID->31982],
Cell[10369, 350, 209, 7, 70, "ExampleText",
 CellID->86273121],
Cell[CellGroupData[{
Cell[10603, 361, 279, 8, 70, "Input",
 CellID->488208944],
Cell[10885, 371, 178, 6, 51, "Output",
 CellID->222104389]
}, Open  ]],
Cell[11078, 380, 125, 3, 70, "ExampleDelimiter",
 CellID->204991544],
Cell[11206, 385, 352, 13, 70, "ExampleText",
 CellID->14044010],
Cell[CellGroupData[{
Cell[11583, 402, 402, 13, 70, "Input",
 CellID->323525768],
Cell[11988, 417, 181, 6, 51, "Output",
 CellID->91419534]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12218, 429, 223, 7, 70, "ExampleSection",
 CellID->21794],
Cell[12444, 438, 204, 7, 70, "ExampleText",
 CellID->245478961],
Cell[CellGroupData[{
Cell[12673, 449, 483, 16, 70, "Input",
 CellID->108189764],
Cell[13159, 467, 497, 18, 36, "Output",
 CellID->531475678]
}, Open  ]],
Cell[13671, 488, 125, 3, 70, "ExampleDelimiter",
 CellID->478877783],
Cell[13799, 493, 356, 15, 70, "ExampleText",
 CellID->68571327],
Cell[CellGroupData[{
Cell[14180, 512, 511, 16, 70, "Input",
 CellID->174963025],
Cell[14694, 530, 524, 18, 36, "Output",
 CellID->13681652]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15267, 554, 232, 7, 70, "ExampleSection",
 CellID->6608],
Cell[15502, 563, 106, 3, 70, "ExampleText",
 CellID->482006564],
Cell[CellGroupData[{
Cell[15633, 570, 281, 8, 70, "Input",
 CellID->107213585],
Cell[15917, 580, 158, 5, 36, "Output",
 CellID->313081617]
}, Open  ]],
Cell[CellGroupData[{
Cell[16112, 590, 281, 8, 70, "Input",
 CellID->582164693],
Cell[16396, 600, 158, 5, 36, "Output",
 CellID->281222037]
}, Open  ]],
Cell[16569, 608, 125, 3, 70, "ExampleDelimiter",
 CellID->787503120],
Cell[16697, 613, 387, 12, 70, "ExampleText",
 CellID->513369211],
Cell[17087, 627, 299, 10, 70, "Input",
 CellID->118519341],
Cell[CellGroupData[{
Cell[17411, 641, 251, 7, 70, "Input",
 CellID->37948204],
Cell[17665, 650, 161, 5, 36, "Output",
 CellID->485022896]
}, Open  ]],
Cell[17841, 658, 125, 3, 70, "ExampleDelimiter",
 CellID->402417664],
Cell[17969, 663, 380, 12, 70, "ExampleText",
 CellID->82073186],
Cell[18352, 677, 299, 10, 70, "Input",
 CellID->593562083],
Cell[CellGroupData[{
Cell[18676, 691, 249, 7, 70, "Input",
 CellID->197212249],
Cell[18928, 700, 160, 5, 36, "Output",
 CellID->88686079]
}, Open  ]],
Cell[19103, 708, 124, 3, 70, "ExampleDelimiter",
 CellID->52926977],
Cell[19230, 713, 389, 12, 70, "ExampleText",
 CellID->432064913],
Cell[19622, 727, 297, 10, 70, "Input",
 CellID->2521331],
Cell[CellGroupData[{
Cell[19944, 741, 253, 7, 70, "Input",
 CellID->154730870],
Cell[20200, 750, 161, 5, 36, "Output",
 CellID->744449348]
}, Open  ]],
Cell[20376, 758, 125, 3, 70, "ExampleDelimiter",
 CellID->304312130],
Cell[20504, 763, 401, 12, 70, "ExampleText",
 CellID->195420953],
Cell[20908, 777, 298, 10, 70, "Input",
 CellID->16527881],
Cell[CellGroupData[{
Cell[21231, 791, 257, 7, 70, "Input",
 CellID->5508493],
Cell[21491, 800, 161, 5, 36, "Output",
 CellID->121404862]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21713, 812, 310, 9, 70, "SeeAlsoSection",
 CellID->6766],
Cell[22026, 823, 1585, 53, 70, "SeeAlso",
 CellID->13985]
}, Open  ]],
Cell[CellGroupData[{
Cell[23648, 881, 313, 9, 70, "TutorialsSection",
 CellID->8928],
Cell[23964, 892, 170, 3, 70, "Tutorials",
 CellID->22256]
}, Open  ]],
Cell[CellGroupData[{
Cell[24171, 900, 305, 8, 70, "RelatedLinksSection"],
Cell[24479, 910, 390, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24906, 927, 316, 9, 70, "MoreAboutSection",
 CellID->636469],
Cell[25225, 938, 179, 3, 70, "MoreAbout",
 CellID->269457188]
}, Open  ]],
Cell[25419, 944, 27, 0, 70, "History"],
Cell[25449, 946, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

