(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     52178,       1927]
NotebookOptionsPosition[     43323,       1613]
NotebookOutlinePosition[     44722,       1652]
CellTagsIndexPosition[     44636,       1647]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Eliminating Variables" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EliminatingVariables"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Eliminating Variables\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Eliminate" :> Documentation`HelpLookup["paclet:ref/Eliminate"],
           "Solve" :> Documentation`HelpLookup["paclet:ref/Solve"], "Reduce" :> 
          Documentation`HelpLookup["paclet:ref/Reduce"], "PolynomialReduce" :> 
          Documentation`HelpLookup["paclet:ref/PolynomialReduce"], "ForAll" :> 
          Documentation`HelpLookup["paclet:ref/ForAll"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Eliminate\"\>", 2->"\<\"Solve\"\>", 
       3->"\<\"Reduce\"\>", 4->"\<\"PolynomialReduce\"\>", 
       5->"\<\"ForAll\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Polynomial Systems" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialSystems"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Polynomial Systems\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SolveAlways", "ObjectName",
 CellID->26330],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SolveAlways",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SolveAlways"], "[", 
       RowBox[{
        StyleBox["eqns", "TI"], ",", 
        StyleBox["vars", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the values of parameters that make the equations \
",
     Cell[BoxData[
      StyleBox["eqns", "TI"]], "InlineFormula"],
     " valid for all values of the variables ",
     Cell[BoxData[
      StyleBox["vars", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->25145]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Equations are given in the form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["lhs", "TI"], "==", 
   StyleBox["rhs", "TI"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->14026],

Cell[TextData[{
 "Simultaneous equations can be combined either in a list or with ",
 Cell[BoxData["&&"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->17468],

Cell["A single variable or a list of variables can be specified. ", "Notes",
 CellID->7398],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SolveAlways",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SolveAlways"]], "InlineFormula"],
 " works primarily with linear and polynomial equations. "
}], "Notes",
 CellID->14922],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SolveAlways",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SolveAlways"]], "InlineFormula"],
 " produces relations between parameters that appear in ",
 Cell[BoxData[
  StyleBox["eqns", "TI"]], "InlineFormula"],
 ", but are not in the list of variables ",
 Cell[BoxData[
  StyleBox["vars", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->17659],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SolveAlways",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SolveAlways"], "[", 
   RowBox[{
    StyleBox["eqns", "TI"], ",", 
    StyleBox["vars", "TI"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Solve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Solve"], "[", 
   RowBox[{"!", 
    RowBox[{
     ButtonBox["Eliminate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Eliminate"], "[", 
     RowBox[{
      RowBox[{"!", 
       StyleBox["eqns", "TI"]}], ",", 
      StyleBox["vars", "TI"]}], "]"}]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->2858]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->81763082],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->832999392],

Cell[TextData[{
 "Find a condition for the equation to hold for any value of ",
 Cell[BoxData["x"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->72605031],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SolveAlways", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", "x"}], "+", "b"}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->131801068],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "\[Rule]", "0"}], ",", 
    RowBox[{"b", "\[Rule]", "0"}]}], "}"}], "}"}]], "Output",
 ImageSize->{104, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->292117906]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->319715144],

Cell["A univariate polynomial equation:", "ExampleText",
 CellID->728739865],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SolveAlways", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", "b"}], ")"}], 
      RowBox[{"x", "^", "2"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", "^", "2"}], "-", "b", "+", "1"}], ")"}], "x"}], "+", "a",
      "-", "c"}], "\[Equal]", "0"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->897308433],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNmd9O1EAUxmfbLcuCgMIKxn9BMUZviFfeaRQSkBAewMsNMYELI0FemPAU
hgvttDNQf0w7Z2anCZvstmfmnG+m33xzTts9ml6c/Pg5vTg9nm7un0/PTk6P
f2/u/Tovm/KBUtmSUmr1iSrP/5Zn1dd+VsqvUsPyNyubC3O8NMeJOf5Bf1FF
5fo3v0GrUJr2FeyHsK898dk9GuUF7GXYj2G/hr0CexLoT3zOdwH2m0C894n9
15Ow/hw219bqk+w9gr0m9OOq5CZuEe1bAhwdR5Zi/ch+HJu6vyjNMdpHsMfG
j/FkpzB+ZId4Cy14a444bT5A+1wkHvt53W18cG+3jSflIxbP8pEKL041lVfR
rBnKMSeuEftdc9PKH0WhUyEuJbSjM7qIQGe/Ho05WMbcUuDoYczdP3S/IjOP
V+6cm/Ya25kD07U7nBU+GJXa8VWwkcGjoqV4ZJC5oJsbm6FcvEtG7+YoCTp2
fQpcX/UcVNchqZ7DBJnPzeGsGY86oy5mzXG882pjIzQjyNiIQu2I7ydvxVVS
Vg1mGomedMZm1pz34IoU1Utl7tKVjCOqW6IHCUcxuOlnm0Ztul+bzH4+PVEn
1YoNa1tVHyL6rseFqAF5naE4vG935ShtMjfGzPd/BmZFnBgGns2IQ6Wlecom
KuNt3a07alrskzLfA2zApvpCsN8lxGI9pHb4hO8by2qNGSZr4eVlYvwPifGY
19O8NZs36PTjanBWHGfR4DxF+zgR/tuecNlP1fGtXdu4ziciAV+vesLf7glX
dEfl9froWQXaO4H+XwP9OV+q4HMg3kHP/r5VTLMKjPexSv8vgf6+vehbBeJ9
69lfthf4Tw5Zr1Dmbu26Kiq1K/Tj3mjzs3XEvk/61IhTNjM44g4S+zXr/e0/
VztN6879+25nb3fsdxc/d7wOE3qt1sfBP2k8J0A=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{525, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->34148102]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28149314],

Cell["A multivariate polynomial equation:", "ExampleText",
 CellID->489395941],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SolveAlways", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", "b"}], ")"}], "x"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", "^", "2"}], "-", "b", "+", "1"}], ")"}], "x", " ", "y"}],
      "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", "d"}], "-", "c", "+", "2"}], ")"}], "x", " ", "y", 
      " ", "z"}], "+", 
     RowBox[{"a", " ", "b"}], " ", "-", 
     RowBox[{"c", " ", "d"}]}], "\[Equal]", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->353712505],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWm1P1EAQLtc7uAMUBXyJqEHBSDR+9RsmQqIS4jflk5JciIl8MCqQ+JZI
4if/gvFnyP+r3XZX6nOzndm212uOJaHttrOzM8/MvswDz/tHb9+86x/t7/WX
nx70P7zd3ztcfvL+IH4VTgTBxJ8gCLavBvFzFD8lv+rnJP4Ngpn42tKvVvRz
R9+/JRLT6hqaXlFyuwPv2tD+XHHPVWjPQXsR2vcc5e8y/c9D+3IhL1agfRHa
Cxp3HN0mt2aRvwDtS4WsDeNLJ272GCymtRxqXYD2pJabqUhfN76EhL6Opf+U
xR/MjZ6lP+aMDMVWYtK/diIzaPM5aM8yY5kM6DZA+yShTfWeEvXG6OP3YlHA
GIekLapvT693VMRb+n2HGfPG8LUD3j2DL0aZtQJHM1bgqNjm1pBPkW0NaVeQ
kTTClWjN6Y+ZTSNcT0bL1hWUQlskiKi524L33Qr08taSGZ31meiDq/dw0FZ5
rJrXHf1Gj5I9rJ22g+SnrEblj1KIfqkIKbzSpS8dcMkRKxwLUSl26sFRQwvW
mIMt7RFG/GbF+tfgPZ6+EEUqV6gVNhuJUI9F7Z08onga7mlt3BpOIYHIKT23
hqR/VeuZ13eMXNcyDrVnuYwrQ/URMwq2txzlDxzlObSLeYHYPHOU/ziUWJjM
W898DUwmTJ5Kmw9bQrlDyhpCzszH/yvfbar3wC4mkzrMjDD49WdyV60TeKLq
8x8RFXl1wer6uKRk0+tuzK4vpBdNqbtNln0lrfT1dn6u+Ho7fTX6eluNls40
X2fbrKiqzv4e2dYKX1e7Ze4xiaSvo9N3ZetoGl1fN6tHRIXGytfJ8jqZRtDX
xW7j0ig2vQ4uZvWo697U6qbUuWkF2bT69pd+TtZysmr9De96JSXxpIL7MZ7G
bkObq28fMvK4YnHjrzP6uPo4JFHAvRTr2EUdF/TeVh+j1yiHemzjobeox1Zf
t0kvbfU17tbSetSc9HEfpXZ/SX2t+oUm+2H9U/3Re5tezIGi/pn6HXGc1e9R
L+7RNvu4ur5FRk9W16MNklOsvHZG7dK6ntaOvel1FaPOjclFvxwiODpWFlxO
cNbb2IZ03XJjG9AWaQWezzLYtHLsAq6xU9EpX4CIUbNLOs4i07+Y9x1trVmL
0AqzFmK8pVbjSp7UyWLWw3XWy1gP19zFCONejhjUPbNpr+ue0fQ5TMbCFPFY
wsKgXlGk2fxBrXjKqSXeWYwJGzFH64m2YRZw1rvyKoOsEGoswjMphYg9nrNd
9aI+V0/NrpzHSrnmF8dS0bHDVa4Mq4OoXmFQctGd/H1zYI7OVzgCnt85JDg+
DfVdgzbuF2Vsx3ktq46r4qFMzY8e2vg0V/0rGmlqNapCP0bChosrDzin9Szp
+7DsxzYdfaziOZ5uw1H+paP8fUf5147yiGoxVBDbx47yLxzl8X8QOPlXjvJ0
rpgZjGjYeMdNodyOUC6bC0Fg50V3hfrMupgyjxtRHpe5mft1J/frA8qeAand
XB3JHpa8Qi61nelHc6rcf2OpC82cDq/n2eRgOVTGk5PlvPYcrZt/o+VouWh6
zlY25jhzttwpy3O4483hSlZ8z+kWnflN4nSL7Qae4y0d/yzGhI31cLySea6a
nvOV9h8d5+tam3gOWIpE8zlg12rdc8J0ZMaDE+aywXPEVaB0NjhjZCc9d4xf
6+KOg4m//ntARw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{435, 75},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21484162]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->205100794],

Cell["A list of polynomial equations:", "ExampleText",
 CellID->58938623],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SolveAlways", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", "b", "-", "c"}], ")"}], "x", " ", "y"}], "-", 
       RowBox[{"(", 
        RowBox[{"a", "-", "d"}], ")"}]}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "-", "d", "+", "2"}], ")"}], "y"}], "\[Equal]", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "-", "b"}], ")"}], "x"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->272008067],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[Rule]", 
      RowBox[{"-", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"b", "\[Rule]", 
      RowBox[{"-", "1"}]}], ",", 
     RowBox[{"c", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "1"}], "-", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"d", "\[Rule]", 
      RowBox[{"1", "-", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[Rule]", "\[ImaginaryI]"}], ",", 
     RowBox[{"b", "\[Rule]", 
      RowBox[{"-", "1"}]}], ",", 
     RowBox[{"c", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"d", "\[Rule]", 
      RowBox[{"1", "+", "\[ImaginaryI]"}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{488, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29186617]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->153281817],

Cell["An equation involving radicals:", "ExampleText",
 CellID->30963109],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SolveAlways", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{"a", " ", "x"}], "]"}], "\[Equal]", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"b", "-", "1"}], "]"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->156649417],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "\[Rule]", "0"}], ",", 
    RowBox[{"b", "\[Rule]", "1"}]}], "}"}], "}"}]], "Output",
 ImageSize->{104, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->553075303]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->349454633],

Cell["An inequation:", "ExampleText",
 CellID->37599100],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SolveAlways", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", "x"}], "\[NotEqual]", "1"}], ",", "x"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->27387702],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"a", "\[Rule]", "0"}], "}"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->116609036]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->646066299],

Cell["Boolean combinations of equations and inequations:", "ExampleText",
 CellID->313202],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SolveAlways", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", "b"}], ")"}], "x"}], "+", "c"}], "\[Equal]", "0"}], 
    "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"c", " ", "x"}], "-", 
      RowBox[{"a", " ", "b"}]}], "\[NotEqual]", "0"}]}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->86356359],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "\[Rule]", 
     RowBox[{"-", "b"}]}], ",", 
    RowBox[{"c", "\[Rule]", "0"}]}], "}"}], "}"}]], "Output",
 ImageSize->{111, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->688846183]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SolveAlways", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", "b"}], ")"}], "x"}], "+", "c"}], "\[Equal]", "0"}], 
    "||", 
    RowBox[{
     RowBox[{
      RowBox[{"c", " ", "x"}], "-", 
      RowBox[{"a", " ", "b"}]}], "\[NotEqual]", "0"}]}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->187235788],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"c", "\[Rule]", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", "\[Rule]", 
     RowBox[{"-", 
      SqrtBox[
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["a", "2"]}], " ", "b"}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"]}]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", "\[Rule]", 
     SqrtBox[
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], " ", "b"}], "-", 
       RowBox[{"a", " ", 
        SuperscriptBox["b", "2"]}]}]]}], "}"}]}], "}"}]], "Output",
 ImageSize->{335, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->925838632]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->914559362],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "WorkingPrecision",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->13557841],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["SolveAlways",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SolveAlways"]], "InlineFormula"],
 " finds exact solutions:"
}], "ExampleText",
 CellID->385254824],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SolveAlways", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", "^", "2"}], "+", 
        RowBox[{"b", "^", "2"}], "-", "1"}], ")"}], "x"}], "+", "a", "+", 
     RowBox[{"2", "b"}], "+", "5"}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->50693184],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[Rule]", 
      RowBox[{
       FractionBox["1", "5"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "5"}], "-", 
         RowBox[{"4", " ", "\[ImaginaryI]", " ", 
          SqrtBox["5"]}]}], ")"}]}]}], ",", 
     RowBox[{"b", "\[Rule]", 
      RowBox[{
       FractionBox["2", "5"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "5"}], "+", 
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["5"]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[Rule]", 
      RowBox[{
       FractionBox["1", "5"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "5"}], "+", 
         RowBox[{"4", " ", "\[ImaginaryI]", " ", 
          SqrtBox["5"]}]}], ")"}]}]}], ",", 
     RowBox[{"b", "\[Rule]", 
      RowBox[{
       FractionBox["2", "5"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "5"}], "-", 
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["5"]}]}], ")"}]}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{553, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->126694852]
}, Open  ]],

Cell["This computes the solutions using 20 digit numbers: ", "ExampleText",
 CellID->123489819],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SolveAlways", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", "^", "2"}], "+", 
        RowBox[{"b", "^", "2"}], "-", "1"}], ")"}], "x"}], "+", "a", "+", 
     RowBox[{"2", "b"}], "+", "5"}], "\[Equal]", "0"}], ",", "x", ",", 
   RowBox[{"WorkingPrecision", "\[Rule]", "20"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->188358906],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "1.`18.516471570753367"}], "-", 
       RowBox[{
       "1.78885438199983175712733893498`18.81990398524883", " ", 
        "\[ImaginaryI]"}]}]}], ",", 
     RowBox[{"b", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "2.`18.839363018264017"}], "+", 
       RowBox[{
       "0.89442719099991587856366946749`18.489878016096007", " ", 
        "\[ImaginaryI]"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "1.`18.516471570753367"}], "+", 
       RowBox[{
       "1.78885438199983175712733893498`18.81990398524883", " ", 
        "\[ImaginaryI]"}]}]}], ",", 
     RowBox[{"b", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "2.`18.839363018264017"}], "-", 
       RowBox[{
       "0.89442719099991587856366946749`18.489878016096007", " ", 
        "\[ImaginaryI]"}]}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{367, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->97844394]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->371839585],

Cell["\<\
Find a condition for a cubic polynomial to have a triple root: \
\>", "ExampleText",
 CellID->453873882],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], ":=", 
   RowBox[{
    RowBox[{"x", "^", "3"}], "+", 
    RowBox[{"a", " ", 
     RowBox[{"x", "^", "2"}]}], "+", 
    RowBox[{"b", " ", "x"}], "+", "c"}]}], ";"}], "\n", 
 RowBox[{"SolveAlways", "[", 
  RowBox[{
   RowBox[{"Implies", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"f", "[", "x", "]"}], "\[Equal]", "0"}], "&&", 
      RowBox[{
       RowBox[{"f", "[", "y", "]"}], "\[Equal]", "0"}]}], ",", 
     RowBox[{"x", "==", "y"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->289437278],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"b", "\[Rule]", 
     FractionBox[
      SuperscriptBox["a", "2"], "3"]}], ",", 
    RowBox[{"c", "\[Rule]", 
     FractionBox[
      SuperscriptBox["a", "3"], "27"]}]}], "}"}], "}"}]], "Output",
 ImageSize->{124, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->159380308]
}, Open  ]],

Cell[TextData[{
 "This solves the same problem using ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->62860981],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"ForAll", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], ",", 
     RowBox[{"Implies", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"f", "[", "x", "]"}], "\[Equal]", "0"}], "&&", 
        RowBox[{
         RowBox[{"f", "[", "y", "]"}], "\[Equal]", "0"}]}], ",", 
       RowBox[{"x", "==", "y"}]}], "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->669287813],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"b", "\[Equal]", 
     FractionBox[
      SuperscriptBox["a", "2"], "3"]}], "&&", 
    RowBox[{"c", "\[Equal]", 
     FractionBox[
      SuperscriptBox["a", "3"], "27"]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[Equal]", "0"}], "&&", 
    RowBox[{"b", "\[Equal]", "0"}], "&&", 
    RowBox[{"c", "\[Equal]", "0"}]}], ")"}]}]], "Output",
 ImageSize->{287, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->14111200]
}, Open  ]],

Cell[TextData[{
 "The same problem can also be solved using ",
 Cell[BoxData[
  ButtonBox["Subresultants",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Subresultants"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->141162141],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Drop", "[", 
     RowBox[{
      RowBox[{"Subresultants", "[", 
       RowBox[{
        RowBox[{"f", "[", "x", "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{"f", "[", "x", "]"}], ",", "x"}], "]"}], ",", "x"}], "]"}], 
      ",", 
      RowBox[{"-", "1"}]}], "]"}], "\[Equal]", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->646083810],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"c", "\[Rule]", 
      FractionBox[
       SuperscriptBox["a", "3"], "27"]}], ",", 
     RowBox[{"b", "\[Rule]", 
      FractionBox[
       SuperscriptBox["a", "2"], "3"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"c", "\[Rule]", 
      FractionBox[
       SuperscriptBox["a", "3"], "27"]}], ",", 
     RowBox[{"b", "\[Rule]", 
      FractionBox[
       SuperscriptBox["a", "2"], "3"]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{242, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->194576384]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->80238498],

Cell["Solve for undetermined coefficients in the series expansion:", \
"ExampleText",
 CellID->484123067],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"y", "''"}], "[", "x", "]"}], "+", 
    RowBox[{"2", " ", 
     RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", "0"}], "/.", 
  RowBox[{"y", "\[Rule]", 
   RowBox[{"Function", "[", 
    RowBox[{"x", ",", 
     RowBox[{"Sin", "[", 
      RowBox[{"a", " ", "x"}], "]"}]}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->476063735],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"2", " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"a", " ", "x"}], "]"}]}], "-", 
   RowBox[{
    SuperscriptBox["a", "2"], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"a", " ", "x"}], "]"}]}]}], "\[Equal]", "0"}]], "Output",
 ImageSize->{171, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->204586392]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7647202],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "a"}], "-", 
       SuperscriptBox["a", "3"]}], ")"}], " ", "x"}], "+", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", 
        SuperscriptBox["a", "3"]}], "+", 
       SuperscriptBox["a", "5"]}], ")"}], " ", 
     SuperscriptBox["x", "3"]}], "+", 
    InterpretationBox[
     SuperscriptBox[
      RowBox[{"O", "[", "x", "]"}], "4"],
     SeriesData[$CellContext`x, 0, {}, 1, 4, 1],
     Editable->False]}],
   SeriesData[$CellContext`x, 0, {
    2 $CellContext`a - $CellContext`a^3, 0, 
     Rational[1, 6] ((-2) $CellContext`a^3 + $CellContext`a^5)}, 1, 4, 1],
   Editable->False], "\[Equal]", "0"}]], "Output",
 ImageSize->{252, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->117614977]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SolveAlways", "[", 
  RowBox[{"%", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->32857248],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", "\[Rule]", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", "\[Rule]", 
     RowBox[{"-", 
      SqrtBox["2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", "\[Rule]", 
     SqrtBox["2"]}], "}"}]}], "}"}]], "Output",
 ImageSize->{214, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->12036862]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->95665783],

Cell["Numeric solutions make the equations identically true:", "ExampleText",
 CellID->517230618],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"eqns", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", "b", "-", "c"}], ")"}], "x", " ", "y"}], "-", 
      RowBox[{"(", 
       RowBox[{"a", "-", "d"}], ")"}]}], "\[Equal]", "1"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "-", "d", "+", "2"}], ")"}], "y"}], "\[Equal]", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", "^", "2"}], "-", "b"}], ")"}], "x"}]}]}]}], 
  ";"}], "\n", 
 RowBox[{"SolveAlways", "[", 
  RowBox[{"eqns", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->70717514],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[Rule]", 
      RowBox[{"-", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"b", "\[Rule]", 
      RowBox[{"-", "1"}]}], ",", 
     RowBox[{"c", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "1"}], "-", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"d", "\[Rule]", 
      RowBox[{"1", "-", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[Rule]", "\[ImaginaryI]"}], ",", 
     RowBox[{"b", "\[Rule]", 
      RowBox[{"-", "1"}]}], ",", 
     RowBox[{"c", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"d", "\[Rule]", 
      RowBox[{"1", "+", "\[ImaginaryI]"}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{488, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->41813683]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eqns", "/.", "%"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->891509078],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->576465461]
}, Open  ]],

Cell[TextData[{
 "An equivalent formulation using ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Eliminate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Eliminate"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->183801004],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{"!", 
   RowBox[{"Eliminate", "[", 
    RowBox[{
     RowBox[{"!", "eqns"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->112727124],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlV9tOwzAMdW+Uwi7AeEAI0J64vADv8AYCCYmPqCak7QGBxj6ZfUeJS4qq
U6fJum4gUalNnDrH9onjNs/pbPzyms4mo3T4OE3fx5PRx/DhbaqGAo/I+ySi
/gGpfqZ6+c3XXN1EIT+DYiyryGcg34F8A/KlBW97SXzUR/wgjyqwaJ2rh6/E
e93e6vZaQONx9No0/8Ji1zd7F/7I6ooEmx09jpixerDYMej3VRtT1Wqs3ycw
HjWc1zHoo7/JSqONhWiaRN8GjgsbNRmBWlGZMxI46woofhFLZTYyiLN3SzLr
R7Vo6MtGq2hdYbYU6dYf4A0zpywvz+Pq0E28VrPVt2gFom3WSrQNaWdLPCZa
LxJ8k3Yq2+nVWpf29eIoUgz8Hler9++YQW1kBGPzstXVP5RxNWwVT4500UrH
39HQ4q2093Z+hQNbfWnGiQ3VxFGz+uSSTVwjsY5tunBljR1niVlV9oaq3y3k
yy0zEaUHs1wybH28OGXagjw1y9461Hazrvjvpfw6EhgKhXHeHcUfObOgDzk5
0KBGl4cPM/kbIVaXtXs3MHi3BMMl+RhkPJuegrwH8pMLZy3aw7OvzILtxM5r
cKLX4kq3+0IkvuZfeo+eI/PoeRs28WRvW+3vNOPu3KFH3he8dNdq\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{484, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->98106423]
}, Open  ]],

Cell[TextData[{
 "An equivalent formulation using ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->517984042],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{"Resolve", "[", 
   RowBox[{"ForAll", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], ",", "eqns"}], "]"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->100484287],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlV9tOwzAMdW+Uwi7AeEAI0J64vADv8AYCCYmPqCak7QGBxj6ZfUeJS4qq
U6fJum4gUalNnDrH9onjNs/pbPzyms4mo3T4OE3fx5PRx/DhbaqGAo/I+ySi
/gGpfqZ6+c3XXN1EIT+DYiyryGcg34F8A/KlBW97SXzUR/wgjyqwaJ2rh6/E
e93e6vZaQONx9No0/8Ji1zd7F/7I6ooEmx09jpixerDYMej3VRtT1Wqs3ycw
HjWc1zHoo7/JSqONhWiaRN8GjgsbNRmBWlGZMxI46woofhFLZTYyiLN3SzLr
R7Vo6MtGq2hdYbYU6dYf4A0zpywvz+Pq0E28VrPVt2gFom3WSrQNaWdLPCZa
LxJ8k3Yq2+nVWpf29eIoUgz8Hler9++YQW1kBGPzstXVP5RxNWwVT4500UrH
39HQ4q2093Z+hQNbfWnGiQ3VxFGz+uSSTVwjsY5tunBljR1niVlV9oaq3y3k
yy0zEaUHs1wybH28OGXagjw1y9461Hazrvjvpfw6EhgKhXHeHcUfObOgDzk5
0KBGl4cPM/kbIVaXtXs3MHi3BMMl+RhkPJuegrwH8pMLZy3aw7OvzILtxM5r
cKLX4kq3+0IkvuZfeo+eI/PoeRs28WRvW+3vNOPu3KFH3he8dNdq\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{484, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->15787260]
}, Open  ]],

Cell[TextData[{
 "This solves the same problem using ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->144751485],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"ForAll", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], ",", "eqns"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->15911780],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[Equal]", 
     RowBox[{"-", "\[ImaginaryI]"}]}], "||", 
    RowBox[{"a", "\[Equal]", "\[ImaginaryI]"}]}], ")"}], "&&", 
  RowBox[{"b", "\[Equal]", 
   RowBox[{"-", "1"}]}], "&&", 
  RowBox[{"c", "\[Equal]", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "a"}]}], "&&", 
  RowBox[{"d", "\[Equal]", 
   RowBox[{"1", "+", "a"}]}]}]], "Output",
 ImageSize->{316, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->458220604]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->45027653],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SolveAlways",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SolveAlways"]], "InlineFormula"],
 " gives generic solutions: "
}], "ExampleText",
 CellID->77505218],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"eqns", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", "b"}], ")"}], "x"}], "+", "c"}], "\[Equal]", "0"}], 
    "||", 
    RowBox[{
     RowBox[{
      RowBox[{"c", " ", "x"}], "-", 
      RowBox[{"a", " ", "b"}]}], "\[NotEqual]", "0"}]}]}], ";"}], "\n", 
 RowBox[{"SolveAlways", "[", 
  RowBox[{"eqns", ",", "x"}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->87707122],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"c", "\[Rule]", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", "\[Rule]", 
     RowBox[{"-", 
      SqrtBox[
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["a", "2"]}], " ", "b"}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"]}]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", "\[Rule]", 
     SqrtBox[
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], " ", "b"}], "-", 
       RowBox[{"a", " ", 
        SuperscriptBox["b", "2"]}]}]]}], "}"}]}], "}"}]], "Output",
 ImageSize->{335, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->94211426]
}, Open  ]],

Cell["\<\
The equations may not be identically true when parameters satisfy additional \
equations:\
\>", "ExampleText",
 CellID->49325429],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eqns", "/.", "%"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->339267307],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", "b"}], ")"}], " ", "x"}], "\[Equal]", "0"}], "||", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "a"}], " ", "b"}], "\[NotEqual]", "0"}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SqrtBox[
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["a", "2"]}], " ", "b"}], "-", 
         RowBox[{"a", " ", 
          SuperscriptBox["b", "2"]}]}]]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", "b"}], ")"}], " ", "x"}]}], "\[Equal]", "0"}], "||",
     
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "a"}], " ", "b"}], "-", 
      RowBox[{
       SqrtBox[
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["a", "2"]}], " ", "b"}], "-", 
         RowBox[{"a", " ", 
          SuperscriptBox["b", "2"]}]}]], " ", "x"}]}], "\[NotEqual]", "0"}]}],
    ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      SqrtBox[
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["a", "2"]}], " ", "b"}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"]}]}]], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", "b"}], ")"}], " ", "x"}]}], "\[Equal]", "0"}], "||",
     
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "a"}], " ", "b"}], "+", 
      RowBox[{
       SqrtBox[
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["a", "2"]}], " ", "b"}], "-", 
         RowBox[{"a", " ", 
          SuperscriptBox["b", "2"]}]}]], " ", "x"}]}], "\[NotEqual]", 
     "0"}]}]}], "}"}]], "Output",
 ImageSize->{521, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->498204244]
}, Open  ]],

Cell["\<\
This finds conditions on parameters for which the solutions are not correct:\
\>", "ExampleText",
 CellID->134831932],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Resolve", "[", 
    RowBox[{"Exists", "[", 
     RowBox[{"x", ",", 
      RowBox[{"Not", "[", "#", "]"}]}], "]"}], "]"}], "&"}], "/@", 
  "%"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->332371725],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", "\[Equal]", "0"}], "&&", 
      RowBox[{
       RowBox[{"a", "+", "b"}], "\[NotEqual]", "0"}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"b", "\[Equal]", "0"}], "&&", 
      RowBox[{
       RowBox[{"a", "+", "b"}], "\[NotEqual]", "0"}]}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"b", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"a", "\[Equal]", "0"}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"b", "\[Equal]", "0"}]}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"b", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"a", "\[Equal]", "0"}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"b", "\[Equal]", "0"}]}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{439, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->195251100]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->7143],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Eliminate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Eliminate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Solve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Solve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Reduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Reduce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolynomialReduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolynomialReduce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ForAll",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ForAll"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3890]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->5516],

Cell[TextData[ButtonBox["Eliminating Variables",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EliminatingVariables"]], "Tutorials",
 CellID->28807]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->148624026],

Cell[TextData[ButtonBox["Polynomial Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialSystems"]], "MoreAbout",
 CellID->423923715]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SolveAlways - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 21, 27.3712604}", "context" -> "System`", 
    "keywords" -> {
     "equations that are always satisfied", 
      "method of undetermined coefficients", "undetermined coefficients"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "SolveAlways[eqns, vars] gives the values of parameters that make the \
equations eqns valid for all values of the variables vars. ", 
    "synonyms" -> {"solve always"}, "title" -> "SolveAlways", "type" -> 
    "Symbol", "uri" -> "ref/SolveAlways"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5891, 202, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->81763082]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 44494, 1640}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2135, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2758, 78, 49, 1, 70, "ObjectName",
 CellID->26330],
Cell[2810, 81, 760, 24, 70, "Usage",
 CellID->25145]
}, Open  ]],
Cell[CellGroupData[{
Cell[3607, 110, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4085, 127, 193, 8, 70, "Notes",
 CellID->14026],
Cell[4281, 137, 158, 5, 70, "Notes",
 CellID->17468],
Cell[4442, 144, 91, 1, 70, "Notes",
 CellID->7398],
Cell[4536, 147, 228, 7, 70, "Notes",
 CellID->14922],
Cell[4767, 156, 398, 13, 70, "Notes",
 CellID->17659],
Cell[5168, 171, 686, 26, 70, "Notes",
 CellID->2858]
}, Closed]],
Cell[CellGroupData[{
Cell[5891, 202, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->81763082],
Cell[CellGroupData[{
Cell[6275, 216, 148, 5, 70, "ExampleSection",
 CellID->832999392],
Cell[6426, 223, 160, 5, 70, "ExampleText",
 CellID->72605031],
Cell[CellGroupData[{
Cell[6611, 232, 215, 8, 28, "Input",
 CellID->131801068],
Cell[6829, 242, 290, 10, 36, "Output",
 CellID->292117906]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7168, 258, 220, 7, 70, "ExampleSection",
 CellID->319715144],
Cell[7391, 267, 76, 1, 70, "ExampleText",
 CellID->728739865],
Cell[CellGroupData[{
Cell[7492, 272, 430, 15, 70, "Input",
 CellID->897308433],
Cell[7925, 289, 1166, 23, 70, "Output",
 Evaluatable->False,
 CellID->34148102]
}, Open  ]],
Cell[9106, 315, 124, 3, 70, "ExampleDelimiter",
 CellID->28149314],
Cell[9233, 320, 78, 1, 70, "ExampleText",
 CellID->489395941],
Cell[CellGroupData[{
Cell[9336, 325, 681, 23, 70, "Input",
 CellID->353712505],
Cell[10020, 350, 1935, 36, 70, "Output",
 Evaluatable->False,
 CellID->21484162]
}, Open  ]],
Cell[11970, 389, 125, 3, 70, "ExampleDelimiter",
 CellID->205100794],
Cell[12098, 394, 73, 1, 70, "ExampleText",
 CellID->58938623],
Cell[CellGroupData[{
Cell[12196, 399, 678, 23, 70, "Input",
 CellID->272008067],
Cell[12877, 424, 889, 28, 36, "Output",
 CellID->29186617]
}, Open  ]],
Cell[13781, 455, 125, 3, 70, "ExampleDelimiter",
 CellID->153281817],
Cell[13909, 460, 73, 1, 70, "ExampleText",
 CellID->30963109],
Cell[CellGroupData[{
Cell[14007, 465, 279, 9, 70, "Input",
 CellID->156649417],
Cell[14289, 476, 290, 10, 36, "Output",
 CellID->553075303]
}, Open  ]],
Cell[14594, 489, 125, 3, 70, "ExampleDelimiter",
 CellID->349454633],
Cell[14722, 494, 56, 1, 70, "ExampleText",
 CellID->37599100],
Cell[CellGroupData[{
Cell[14803, 499, 190, 7, 70, "Input",
 CellID->27387702],
Cell[14996, 508, 233, 8, 36, "Output",
 CellID->116609036]
}, Open  ]],
Cell[15244, 519, 125, 3, 70, "ExampleDelimiter",
 CellID->646066299],
Cell[15372, 524, 90, 1, 70, "ExampleText",
 CellID->313202],
Cell[CellGroupData[{
Cell[15487, 529, 414, 16, 70, "Input",
 CellID->86356359],
Cell[15904, 547, 311, 11, 36, "Output",
 CellID->688846183]
}, Open  ]],
Cell[CellGroupData[{
Cell[16252, 563, 415, 16, 70, "Input",
 CellID->187235788],
Cell[16670, 581, 773, 28, 48, "Output",
 CellID->925838632]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17492, 615, 222, 7, 70, "ExampleSection",
 CellID->914559362],
Cell[CellGroupData[{
Cell[17739, 626, 236, 7, 70, "ExampleSubsection",
 CellID->13557841],
Cell[17978, 635, 223, 8, 70, "ExampleText",
 CellID->385254824],
Cell[CellGroupData[{
Cell[18226, 647, 373, 13, 70, "Input",
 CellID->50693184],
Cell[18602, 662, 1238, 43, 51, "Output",
 CellID->126694852]
}, Open  ]],
Cell[19855, 708, 95, 1, 70, "ExampleText",
 CellID->123489819],
Cell[CellGroupData[{
Cell[19975, 713, 427, 13, 70, "Input",
 CellID->188358906],
Cell[20405, 728, 1131, 35, 88, "Output",
 CellID->97844394]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[21597, 770, 227, 7, 70, "ExampleSection",
 CellID->371839585],
Cell[21827, 779, 114, 3, 70, "ExampleText",
 CellID->453873882],
Cell[CellGroupData[{
Cell[21966, 786, 656, 22, 70, "Input",
 CellID->289437278],
Cell[22625, 810, 395, 14, 54, "Output",
 CellID->159380308]
}, Open  ]],
Cell[23035, 827, 213, 8, 70, "ExampleText",
 CellID->62860981],
Cell[CellGroupData[{
Cell[23273, 839, 560, 18, 70, "Input",
 CellID->669287813],
Cell[23836, 859, 553, 19, 54, "Output",
 CellID->14111200]
}, Open  ]],
Cell[24404, 881, 358, 13, 70, "ExampleText",
 CellID->141162141],
Cell[CellGroupData[{
Cell[24787, 898, 508, 17, 70, "Input",
 CellID->646083810],
Cell[25298, 917, 648, 23, 54, "Output",
 CellID->194576384]
}, Open  ]],
Cell[25961, 943, 124, 3, 70, "ExampleDelimiter",
 CellID->80238498],
Cell[26088, 948, 105, 2, 70, "ExampleText",
 CellID->484123067],
Cell[CellGroupData[{
Cell[26218, 954, 405, 14, 70, "Input",
 CellID->476063735],
Cell[26626, 970, 401, 14, 36, "Output",
 CellID->204586392]
}, Open  ]],
Cell[CellGroupData[{
Cell[27064, 989, 182, 6, 70, "Input",
 CellID->7647202],
Cell[27249, 997, 958, 31, 51, "Output",
 CellID->117614977]
}, Open  ]],
Cell[CellGroupData[{
Cell[28244, 1033, 129, 4, 70, "Input",
 CellID->32857248],
Cell[28376, 1039, 430, 16, 43, "Output",
 CellID->12036862]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[28855, 1061, 236, 7, 70, "ExampleSection",
 CellID->95665783],
Cell[29094, 1070, 97, 1, 70, "ExampleText",
 CellID->517230618],
Cell[CellGroupData[{
Cell[29216, 1075, 700, 25, 70, "Input",
 CellID->70717514],
Cell[29919, 1102, 889, 28, 36, "Output",
 CellID->41813683]
}, Open  ]],
Cell[CellGroupData[{
Cell[30845, 1135, 96, 3, 70, "Input",
 CellID->891509078],
Cell[30944, 1140, 209, 7, 36, "Output",
 CellID->576465461]
}, Open  ]],
Cell[31168, 1150, 340, 13, 70, "ExampleText",
 CellID->183801004],
Cell[CellGroupData[{
Cell[31533, 1167, 258, 9, 70, "Input",
 CellID->112727124],
Cell[31794, 1178, 873, 18, 70, "Output",
 Evaluatable->False,
 CellID->98106423]
}, Open  ]],
Cell[32682, 1199, 336, 13, 70, "ExampleText",
 CellID->517984042],
Cell[CellGroupData[{
Cell[33043, 1216, 253, 9, 70, "Input",
 CellID->100484287],
Cell[33299, 1227, 873, 18, 70, "Output",
 Evaluatable->False,
 CellID->15787260]
}, Open  ]],
Cell[34187, 1248, 214, 8, 70, "ExampleText",
 CellID->144751485],
Cell[CellGroupData[{
Cell[34426, 1260, 308, 10, 70, "Input",
 CellID->15911780],
Cell[34737, 1272, 538, 18, 36, "Output",
 CellID->458220604]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[35324, 1296, 229, 7, 70, "ExampleSection",
 CellID->45027653],
Cell[35556, 1305, 208, 7, 70, "ExampleText",
 CellID->77505218],
Cell[CellGroupData[{
Cell[35789, 1316, 470, 17, 70, "Input",
 CellID->87707122],
Cell[36262, 1335, 772, 28, 48, "Output",
 CellID->94211426]
}, Open  ]],
Cell[37049, 1366, 139, 4, 70, "ExampleText",
 CellID->49325429],
Cell[CellGroupData[{
Cell[37213, 1374, 96, 3, 70, "Input",
 CellID->339267307],
Cell[37312, 1379, 1868, 70, 75, "Output",
 CellID->498204244]
}, Open  ]],
Cell[39195, 1452, 127, 3, 70, "ExampleText",
 CellID->134831932],
Cell[CellGroupData[{
Cell[39347, 1459, 244, 9, 70, "Input",
 CellID->332371725],
Cell[39594, 1470, 1083, 36, 54, "Output",
 CellID->195251100]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[40738, 1513, 310, 9, 70, "SeeAlsoSection",
 CellID->7143],
Cell[41051, 1524, 1189, 44, 70, "SeeAlso",
 CellID->3890]
}, Open  ]],
Cell[CellGroupData[{
Cell[42277, 1573, 313, 9, 70, "TutorialsSection",
 CellID->5516],
Cell[42593, 1584, 152, 3, 70, "Tutorials",
 CellID->28807]
}, Open  ]],
Cell[CellGroupData[{
Cell[42782, 1592, 319, 9, 70, "MoreAboutSection",
 CellID->148624026],
Cell[43104, 1603, 147, 3, 70, "MoreAbout",
 CellID->423923715]
}, Open  ]],
Cell[43266, 1609, 27, 0, 70, "History"],
Cell[43296, 1611, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

