(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     60540,       2241]
NotebookOptionsPosition[     48062,       1797]
NotebookOutlinePosition[     49830,       1841]
CellTagsIndexPosition[     49744,       1836]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Rearranging Lists" :> 
          Documentation`HelpLookup["paclet:tutorial/RearrangingLists"], 
          "Ordering in Lists" :> 
          Documentation`HelpLookup["paclet:tutorial/OrderingInLists"], 
          "Structural Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralOperations"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Rearranging Lists\"\>", 
       2->"\<\"Ordering in Lists\"\>", 
       3->"\<\"Structural Operations\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SortBy" :> Documentation`HelpLookup["paclet:ref/SortBy"], 
          "Ordering" :> Documentation`HelpLookup["paclet:ref/Ordering"], 
          "Order" :> Documentation`HelpLookup["paclet:ref/Order"], "OrderedQ" :> 
          Documentation`HelpLookup["paclet:ref/OrderedQ"], "Orderless" :> 
          Documentation`HelpLookup["paclet:ref/Orderless"], "Median" :> 
          Documentation`HelpLookup["paclet:ref/Median"], "Quantile" :> 
          Documentation`HelpLookup["paclet:ref/Quantile"], "Tally" :> 
          Documentation`HelpLookup["paclet:ref/Tally"], "Nearest" :> 
          Documentation`HelpLookup["paclet:ref/Nearest"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"SortBy\"\>", 2->"\<\"Ordering\"\>", 
       3->"\<\"Order\"\>", 4->"\<\"OrderedQ\"\>", 5->"\<\"Orderless\"\>", 
       6->"\<\"Median\"\>", 7->"\<\"Quantile\"\>", 8->"\<\"Tally\"\>", 
       9->"\<\"Nearest\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Discrete & Integer Data" :> 
          Documentation`HelpLookup["paclet:guide/DiscreteAndIntegerData"], 
          "Discrete Mathematics" :> 
          Documentation`HelpLookup["paclet:guide/DiscreteMathematics"], 
          "Handling Arrays of Data" :> 
          Documentation`HelpLookup["paclet:guide/HandlingArraysOfData"], 
          "List Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/ListManipulation"], 
          "Math & Counting Operations on Lists" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicalAndCountingOperationsOnLists"], 
          "Numerical Data" :> 
          Documentation`HelpLookup["paclet:guide/NumericalData"], 
          "Processing Textual Data" :> 
          Documentation`HelpLookup["paclet:guide/ProcessingTextualData"], 
          "Rearranging & Restructuring Lists" :> 
          Documentation`HelpLookup[
           "paclet:guide/RearrangingAndRestructuringLists"], 
          "String Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/StringManipulation"], 
          "Structural Operations on Expressions" :> 
          Documentation`HelpLookup[
           "paclet:guide/StructuralOperationsOnExpressions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Discrete & Integer Data\"\>", 
       2->"\<\"Discrete Mathematics\"\>", 
       3->"\<\"Handling Arrays of Data\"\>", 4->"\<\"List Manipulation\"\>", 
       5->"\<\"Math & Counting Operations on Lists\"\>", 
       6->"\<\"Numerical Data\"\>", 7->"\<\"Processing Textual Data\"\>", 
       8->"\<\"Rearranging & Restructuring Lists\"\>", 
       9->"\<\"String Manipulation\"\>", 
       10->"\<\"Structural Operations on Expressions\"\>"}, "\<\"more about\"\
\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Sort", "ObjectName",
 CellID->23888],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Sort",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Sort"], "[", 
       StyleBox["list", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]sorts the elements of ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " into canonical order. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Sort",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Sort"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["p", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]sorts using the ordering function ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->31912]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sort",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sort"]], "InlineFormula"],
 " by default orders integers, rational and approximate real numbers by their \
numerical values."
}], "Notes",
 CellID->167593680],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sort",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sort"]], "InlineFormula"],
 " orders complex numbers by their real parts, and in the event of a tie, by \
the absolute values of their imaginary parts."
}], "Notes",
 CellID->33742251],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sort",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sort"]], "InlineFormula"],
 " orders symbols by their names, and in the event of a tie, by their \
contexts."
}], "Notes",
 CellID->748496529],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sort",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sort"]], "InlineFormula"],
 " usually orders expressions by putting shorter ones first, and then \
comparing parts in a depth\[Hyphen]first manner. "
}], "Notes",
 CellID->44838889],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sort",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sort"]], "InlineFormula"],
 " treats powers and products specially, ordering them to correspond to terms \
in a polynomial."
}], "Notes",
 CellID->145824070],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sort",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sort"]], "InlineFormula"],
 " orders strings as in a dictionary, with upper\[Hyphen]case versions of \
letters coming after lower\[Hyphen]case ones.",
 " ",
 Cell[BoxData[
  ButtonBox["Sort",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sort"]], "InlineFormula"],
 " places ordinary letters appear first, followed in order by script, Gothic, \
double\[Hyphen]struck, Greek and Hebrew. Mathematical operators appear in \
order of decreasing precedence."
}], "Notes",
 CellID->574799963],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sort",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sort"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    StyleBox["p", "TI"]}], "]"}]], "InlineFormula"],
 " applies the function ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 " to pairs of elements in ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " to determine whether they are in order. The default function ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["OrderedQ",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/OrderedQ"], "[", 
    RowBox[{"{", 
     RowBox[{"#1", ",", "#2"}], "}"}], "]"}], "&"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->16341],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sort",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sort"]], "InlineFormula"],
 " can be used on expressions with any head, not only ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->17942]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->518037411],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->185010028],

Cell["Sort a list:", "ExampleText",
 CellID->32690],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sort", "[", 
  RowBox[{"{", 
   RowBox[{"d", ",", "b", ",", "c", ",", "a"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14219],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->834]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30086],

Cell[TextData[{
 "Sort using ",
 Cell[BoxData[
  ButtonBox["Greater",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Greater"]], "InlineFormula"],
 " as the ordering function:"
}], "ExampleText",
 CellID->20716],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sort", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4", ",", "1", ",", "3", ",", "2", ",", "2"}], "}"}], ",", 
   "Greater"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20692],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "3", ",", "2", ",", "2", ",", "1"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24772]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sort", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4", ",", "1", ",", "3", ",", "2", ",", "2"}], "}"}], ",", 
   RowBox[{
    RowBox[{"#1", ">", "#2"}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28722],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "3", ",", "2", ",", "2", ",", "1"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->31132]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5618],

Cell["Sort by comparing the second part of each element:", "ExampleText",
 CellID->14372],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sort", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"#1", "[", 
      RowBox[{"[", "2", "]"}], "]"}], "<", 
     RowBox[{"#2", "[", 
      RowBox[{"[", "2", "]"}], "]"}]}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18716],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"c", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "3"}], "}"}]}], "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22519]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8108],

Cell["Sort any expressions:", "ExampleText",
 CellID->32412],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sort", "[", 
  RowBox[{"{", 
   RowBox[{"y", ",", 
    RowBox[{"x", "^", "2"}], ",", 
    RowBox[{"x", "+", "y"}], ",", 
    RowBox[{"y", "^", "3"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19240],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SuperscriptBox["x", "2"], ",", "y", ",", 
   SuperscriptBox["y", "3"], ",", 
   RowBox[{"x", "+", "y"}]}], "}"}]], "Output",
 ImageSize->{111, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20573]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19298],

Cell["Sort strings into dictionary order:", "ExampleText",
 CellID->6357],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sort", "[", 
  RowBox[{"{", 
   RowBox[{
   "\"\<cat\>\"", ",", " ", "\"\<fish\>\"", ",", " ", "\"\<catfish\>\"", ",", 
    " ", "\"\<Cat\>\""}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6569],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"cat\"\>", ",", "\<\"Cat\"\>", ",", "\<\"catfish\"\>", 
   ",", "\<\"fish\"\>"}], "}"}]], "Output",
 ImageSize->{171, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11673]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30898],

Cell["Sort by structure:", "ExampleText",
 CellID->25625],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sort", "[", 
  RowBox[{"{", 
   RowBox[{"Pi", ",", "E", ",", "2", ",", "3", ",", "1", ",", 
    RowBox[{"Sqrt", "[", "2", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22395],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3", ",", 
   SqrtBox["2"], ",", "\[ExponentialE]", ",", "\[Pi]"}], "}"}]], "Output",
 ImageSize->{134, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18820]
}, Open  ]],

Cell["Sort by numerical value:", "ExampleText",
 CellID->2067],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sort", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Pi", ",", "E", ",", "2", ",", "3", ",", "1", ",", 
     RowBox[{"Sqrt", "[", "2", "]"}]}], "}"}], ",", "Less"}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->25302],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   SqrtBox["2"], ",", "2", ",", "\[ExponentialE]", ",", "3", ",", "\[Pi]"}], 
  "}"}]], "Output",
 ImageSize->{134, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->20969]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32392],

Cell["Sort expressions with any head:", "ExampleText",
 CellID->25427],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sort", "[", 
  RowBox[{"f", "[", 
   RowBox[{"4", ",", "2", ",", "1", ",", "3"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11374],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "]"}]], "Output",
 ImageSize->{87, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1116]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sort", "[", 
  RowBox[{"b", ".", "c", ".", "d", ".", "a"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21955],

Cell[BoxData[
 RowBox[{"a", ".", "b", ".", "c", ".", "d"}]], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->15661]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29830],

Cell["Sort integers by magnitude:", "ExampleText",
 CellID->16997],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sort", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "11"}], ",", "10", ",", "2", ",", "1", ",", 
    RowBox[{"-", "4"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28445],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "11"}], ",", 
   RowBox[{"-", "4"}], ",", "1", ",", "2", ",", "10"}], "}"}]], "Output",
 ImageSize->{128, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29544]
}, Open  ]],

Cell["Sort by absolute value:", "ExampleText",
 CellID->7905],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sort", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "11"}], ",", "10", ",", "2", ",", "1", ",", 
     RowBox[{"-", "4"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"Abs", "[", "#1", "]"}], "<", 
     RowBox[{"Abs", "[", "#2", "]"}]}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->11354],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", 
   RowBox[{"-", "4"}], ",", "10", ",", 
   RowBox[{"-", "11"}]}], "}"}]], "Output",
 ImageSize->{128, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->26995]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->521],

Cell["Sort by structure:", "ExampleText",
 CellID->1880],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sort", "[", 
  RowBox[{"Join", "[", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"Range", "[", "10", "]"}], "]"}], ",", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"Range", "[", "10", "]"}], "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3626],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "1", ",", "2", ",", "3", ",", 
   SqrtBox["2"], ",", 
   RowBox[{"2", " ", 
    SqrtBox["2"]}], ",", 
   SqrtBox["3"], ",", 
   SqrtBox["5"], ",", 
   SqrtBox["6"], ",", 
   SqrtBox["7"], ",", 
   SqrtBox["10"], ",", 
   RowBox[{"Log", "[", "2", "]"}], ",", 
   RowBox[{"Log", "[", "3", "]"}], ",", 
   RowBox[{"Log", "[", "4", "]"}], ",", 
   RowBox[{"Log", "[", "5", "]"}], ",", 
   RowBox[{"Log", "[", "6", "]"}], ",", 
   RowBox[{"Log", "[", "7", "]"}], ",", 
   RowBox[{"Log", "[", "8", "]"}], ",", 
   RowBox[{"Log", "[", "9", "]"}], ",", 
   RowBox[{"Log", "[", "10", "]"}]}], "}"}]], "Output",
 ImageSize->{440, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27047]
}, Open  ]],

Cell["Sort by numerical value:", "ExampleText",
 CellID->10954],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sort", "[", 
  RowBox[{
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"Range", "[", "10", "]"}], "]"}], ",", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"Range", "[", "10", "]"}], "]"}]}], "]"}], ",", "Less"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16963],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{"Log", "[", "2", "]"}], ",", "1", ",", 
   RowBox[{"Log", "[", "3", "]"}], ",", 
   RowBox[{"Log", "[", "4", "]"}], ",", 
   SqrtBox["2"], ",", 
   RowBox[{"Log", "[", "5", "]"}], ",", 
   SqrtBox["3"], ",", 
   RowBox[{"Log", "[", "6", "]"}], ",", 
   RowBox[{"Log", "[", "7", "]"}], ",", "2", ",", 
   RowBox[{"Log", "[", "8", "]"}], ",", 
   RowBox[{"Log", "[", "9", "]"}], ",", 
   SqrtBox["5"], ",", 
   RowBox[{"Log", "[", "10", "]"}], ",", 
   SqrtBox["6"], ",", 
   SqrtBox["7"], ",", 
   RowBox[{"2", " ", 
    SqrtBox["2"]}], ",", "3", ",", 
   SqrtBox["10"]}], "}"}]], "Output",
 ImageSize->{456, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->10781]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27372],

Cell["Sort strings by dictionary order:", "ExampleText",
 CellID->30174],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sort", "[", 
  RowBox[{"{", 
   RowBox[{
   "\"\<aa\>\"", ",", "\"\<abb\>\"", ",", "\"\<ba\>\"", ",", "\"\<b\>\"", 
    ",", "\"\<aaa\>\""}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2457],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"aa\"\>", ",", "\<\"aaa\"\>", ",", "\<\"abb\"\>", 
   ",", "\<\"b\"\>", ",", "\<\"ba\"\>"}], "}"}]], "Output",
 ImageSize->{140, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6818]
}, Open  ]],

Cell["Sort strings by length:", "ExampleText",
 CellID->1287],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sort", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "\"\<aa\>\"", ",", "\"\<abb\>\"", ",", "\"\<ba\>\"", ",", "\"\<b\>\"", 
     ",", "\"\<aaa\>\""}], "}"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"StringLength", "[", "#1", "]"}], "<", 
     RowBox[{"StringLength", "[", "#2", "]"}]}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->9929],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"b\"\>", ",", "\<\"ba\"\>", ",", "\<\"aa\"\>", 
   ",", "\<\"aaa\"\>", ",", "\<\"abb\"\>"}], "}"}]], "Output",
 ImageSize->{140, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->12897]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16881],

Cell["Sort by norm:", "ExampleText",
 CellID->5738],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomInteger", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11618],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "1", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", 
     RowBox[{"-", "3"}], ",", 
     RowBox[{"-", "3"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "4"}], ",", "4", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "2", ",", 
     RowBox[{"-", "3"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "3", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "5"}], ",", "5", ",", 
     RowBox[{"-", "4"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "3"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{396, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18719]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sort", "[", 
  RowBox[{"%", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"Norm", "[", "#1", "]"}], "<", 
     RowBox[{"Norm", "[", "#2", "]"}]}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23792],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "3"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "3", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "2", ",", 
     RowBox[{"-", "3"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "4"}], ",", "4", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", 
     RowBox[{"-", "3"}], ",", 
     RowBox[{"-", "3"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "5"}], ",", "5", ",", 
     RowBox[{"-", "4"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{404, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->3676]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31375],

Cell["Sort by real part:", "ExampleText",
 CellID->17980],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sort", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"I", ",", 
     RowBox[{"1", "+", "I"}], ",", 
     RowBox[{"1", "-", "I"}], ",", 
     RowBox[{"2", "+", 
      RowBox[{"3", "I"}]}]}], "}"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"Re", "[", "#1", "]"}], "<", 
     RowBox[{"Re", "[", "#2", "]"}]}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15699],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\[ImaginaryI]", ",", 
   RowBox[{"1", "-", "\[ImaginaryI]"}], ",", 
   RowBox[{"1", "+", "\[ImaginaryI]"}], ",", 
   RowBox[{"2", "+", 
    RowBox[{"3", " ", "\[ImaginaryI]"}]}]}], "}"}]], "Output",
 ImageSize->{153, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->26852]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5665],

Cell["Shorter expressions are sorted before longer ones:", "ExampleText",
 CellID->5966],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sort", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "+", "b", "+", "c"}], ",", 
    RowBox[{"a", "+", "b"}], ",", 
    RowBox[{"a", "+", "c"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28424],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "+", "b"}], ",", 
   RowBox[{"a", "+", "c"}], ",", 
   RowBox[{"a", "+", "b", "+", "c"}]}], "}"}]], "Output",
 ImageSize->{140, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13382]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9404],

Cell["Explicit numbers are sorted in numerical order:", "ExampleText",
 CellID->25210],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sort", "[", 
  RowBox[{"{", 
   RowBox[{"5.6", ",", "5", ",", "2.3", ",", 
    RowBox[{"-", "1"}], ",", 
    RowBox[{"4", "/", "3"}], ",", "1"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19666],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", "1", ",", 
   FractionBox["4", "3"], ",", "2.3`", ",", "5", ",", "5.6`"}], 
  "}"}]], "Output",
 ImageSize->{156, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->28740]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14059],

Cell["Sort in reverse order:", "ExampleText",
 CellID->1709],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sort", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "+", "b", "+", "c"}], ",", 
     RowBox[{"a", "+", "b"}], ",", 
     RowBox[{"a", "+", "c"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{"OrderedQ", "[", 
     RowBox[{"{", 
      RowBox[{"#2", ",", "#1"}], "}"}], "]"}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18484],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "+", "b", "+", "c"}], ",", 
   RowBox[{"a", "+", "c"}], ",", 
   RowBox[{"a", "+", "b"}]}], "}"}]], "Output",
 ImageSize->{140, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23913]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3040],

Cell[TextData[{
 "Orderless functions sort in the same order as ",
 Cell[BoxData[
  ButtonBox["Sort",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sort"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->995],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"a", "+", "b", "+", "c"}], ")"}], 
  RowBox[{"(", 
   RowBox[{"a", "+", "b"}], ")"}], 
  RowBox[{"(", 
   RowBox[{"a", "+", "c"}], ")"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26768],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"a", "+", "b"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"a", "+", "c"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"a", "+", "b", "+", "c"}], ")"}]}]], "Output",
 ImageSize->{152, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3994]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10682],

Cell["Print each comparison done:", "ExampleText",
 CellID->16979],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sort", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4", ",", "1", ",", "3", ",", "2"}], "}"}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Print", "[", 
       RowBox[{"{", 
        RowBox[{"#1", ",", "#2"}], "}"}], "]"}], ";", 
      RowBox[{"#1", ">", "#2"}]}], ")"}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17808],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "1"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->3822],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "3"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->19203],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "1"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->23014],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "2"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->197],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "3"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->31424],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "3"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->17789],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->28142]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "3", ",", "2", ",", "1"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->654]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25346],

Cell["Collect a list of the comparisons done:", "ExampleText",
 CellID->19998],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reap", "[", 
  RowBox[{"Sort", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"4", ",", "1", ",", "3", ",", "2"}], "}"}], ",", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sow", "[", 
        RowBox[{"{", 
         RowBox[{"#1", ",", "#2"}], "}"}], "]"}], ";", 
       RowBox[{"#1", ">", "#2"}]}], ")"}], "&"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28949],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4", ",", "3", ",", "2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"4", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}]}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{475, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->32316]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->597400362],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sort",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sort"], "[", 
   StyleBox["list", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   StyleBox["list", "TI"], "[", 
   RowBox[{"[", 
    RowBox[{
     ButtonBox["Ordering",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Ordering"], "[", 
     StyleBox["list", "TI"], "]"}], "]"}], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->87001366],

Cell[BoxData[
 RowBox[{
  RowBox[{"list", " ", "=", " ", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"10", ",", "10"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->338990403],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sort", "[", "list", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3625846],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "1", ",", "3", ",", "3", ",", "6", ",", "6", ",", "7", 
   ",", "8", ",", "10"}], "}"}]], "Output",
 ImageSize->{196, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->192113041]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"list", "[", 
  RowBox[{"[", 
   RowBox[{"Ordering", "[", "list", "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->413706816],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "1", ",", "3", ",", "3", ",", "6", ",", "6", ",", "7", 
   ",", "8", ",", "10"}], "}"}]], "Output",
 ImageSize->{196, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->29584337]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19411],

Cell["\<\
Numeric expressions are sorted by structure as well as numerical value:\
\>", "ExampleText",
 CellID->15961],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sort", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Sqrt", "[", "2", "]"}], ",", "1", ",", "2", ",", 
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", "2", "]"}]}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26003],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", 
   FractionBox["1", 
    SqrtBox["2"]], ",", 
   SqrtBox["2"]}], "}"}]], "Output",
 ImageSize->{118, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->371]
}, Open  ]],

Cell["Sort by numerical value only:", "ExampleText",
 CellID->3924],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sort", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sqrt", "[", "2", "]"}], ",", "1", ",", "2", ",", 
     RowBox[{"1", "/", 
      RowBox[{"Sqrt", "[", "2", "]"}]}]}], "}"}], ",", "Less"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16031],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", 
    SqrtBox["2"]], ",", "1", ",", 
   SqrtBox["2"], ",", "2"}], "}"}]], "Output",
 ImageSize->{118, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->28069]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4819],

Cell["\<\
Elements whose order is not determined by the ordering function may not be \
kept in order:\
\>", "ExampleText",
 CellID->4536],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sort", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4", ",", "1", ",", "3", ",", "7", ",", "9"}], "}"}], ",", 
   RowBox[{
    RowBox[{"#", ">", "3"}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31270],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "7", ",", "9", ",", "3", ",", "1"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16442]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sort", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4", ",", "3", ",", "1", ",", "7", ",", "9"}], "}"}], ",", 
   RowBox[{
    RowBox[{"#", ">", "3"}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->9176],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "7", ",", "9", ",", "1", ",", "3"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->31643]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21999],

Cell["Show comparisons made in doing a sort:", "ExampleText",
 CellID->23039],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Reap", "[", 
    RowBox[{"Sort", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Round", "[", 
         RowBox[{"10", 
          RowBox[{"Sin", "[", "t", "]"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", "50"}], "}"}]}], "]"}], ",", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Sow", "[", "#1", "]"}], ";", 
         RowBox[{"#1", ">", "#2"}]}], ")"}], "&"}]}], "]"}], "]"}], "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", "1"}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28309],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->159954098]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->30890],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SortBy",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SortBy"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Ordering",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Ordering"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Order",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Order"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OrderedQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OrderedQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Orderless",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Orderless"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Median",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Median"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Quantile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Quantile"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Tally",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tally"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Nearest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Nearest"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->10521]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->14361],

Cell[TextData[ButtonBox["Rearranging Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RearrangingLists"]], "Tutorials",
 CellID->3501],

Cell[TextData[ButtonBox["Ordering in Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OrderingInLists"]], "Tutorials",
 CellID->7239],

Cell[TextData[ButtonBox["Structural Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StructuralOperations"]], "Tutorials",
 CellID->19437]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->63258813],

Cell[TextData[ButtonBox["Discrete & Integer Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteAndIntegerData"]], "MoreAbout",
 CellID->446045953],

Cell[TextData[ButtonBox["Discrete Mathematics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteMathematics"]], "MoreAbout",
 CellID->5103217],

Cell[TextData[ButtonBox["Handling Arrays of Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/HandlingArraysOfData"]], "MoreAbout",
 CellID->164724238],

Cell[TextData[ButtonBox["List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListManipulation"]], "MoreAbout",
 CellID->66714239],

Cell[TextData[ButtonBox["Math & Counting Operations on Lists",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/MathematicalAndCountingOperationsOnLists"]], "MoreAbout",
 CellID->221035817],

Cell[TextData[ButtonBox["Numerical Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalData"]], "MoreAbout",
 CellID->578791133],

Cell[TextData[ButtonBox["Processing Textual Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ProcessingTextualData"]], "MoreAbout",
 CellID->51503267],

Cell[TextData[ButtonBox["Rearranging & Restructuring Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RearrangingAndRestructuringLists"]], "MoreAbout",
 CellID->807332279],

Cell[TextData[ButtonBox["String Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringManipulation"]], "MoreAbout",
 CellID->15262245],

Cell[TextData[ButtonBox["Structural Operations on Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StructuralOperationsOnExpressions"]], "MoreAbout",
 CellID->8320012]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Sort"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Sort - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 21, 38.2777896}", "context" -> "System`", 
    "keywords" -> {
     "alphabetic", "alphabetizing of lists", "alphabetizing of string", 
      "arrange", "ascending order", "canonical order", "collating of strings",
       "collation", "decreasing order", "descending order", 
      "element positions", "expressions ordering", "grade", "grade in APL", 
      "increasing order", "largest", "lists ordering", "order in lists", 
      "order statistics", "ordering permutation", "ordinal sort", "ranking", 
      "smallest element", "sorting", "sorting of lists", "sorting of strings",
       "string order"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Sort[list] sorts the elements of list into canonical order. Sort[list, \
p] sorts using the ordering function p. ", "synonyms" -> {}, "title" -> 
    "Sort", "type" -> "Symbol", "uri" -> "ref/Sort"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9557, 289, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->518037411]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 49601, 1829}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 4307, 89, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4930, 116, 42, 1, 70, "ObjectName",
 CellID->23888],
Cell[4975, 119, 976, 32, 70, "Usage",
 CellID->31912]
}, Open  ]],
Cell[CellGroupData[{
Cell[5988, 156, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6466, 173, 258, 8, 70, "Notes",
 CellID->167593680],
Cell[6727, 183, 284, 8, 70, "Notes",
 CellID->33742251],
Cell[7014, 193, 242, 8, 70, "Notes",
 CellID->748496529],
Cell[7259, 203, 281, 8, 70, "Notes",
 CellID->44838889],
Cell[7543, 213, 257, 8, 70, "Notes",
 CellID->145824070],
Cell[7803, 223, 589, 16, 70, "Notes",
 CellID->574799963],
Cell[8395, 241, 793, 29, 70, "Notes",
 CellID->16341],
Cell[9191, 272, 329, 12, 70, "Notes",
 CellID->17942]
}, Closed]],
Cell[CellGroupData[{
Cell[9557, 289, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->518037411],
Cell[CellGroupData[{
Cell[9942, 303, 148, 5, 70, "ExampleSection",
 CellID->185010028],
Cell[10093, 310, 51, 1, 70, "ExampleText",
 CellID->32690],
Cell[CellGroupData[{
Cell[10169, 315, 163, 5, 28, "Input",
 CellID->14219],
Cell[10335, 322, 217, 7, 36, "Output",
 CellID->834]
}, Open  ]],
Cell[10567, 332, 121, 3, 70, "ExampleDelimiter",
 CellID->30086],
Cell[10691, 337, 213, 8, 70, "ExampleText",
 CellID->20716],
Cell[CellGroupData[{
Cell[10929, 349, 208, 7, 70, "Input",
 CellID->20692],
Cell[11140, 358, 229, 7, 36, "Output",
 CellID->24772]
}, Open  ]],
Cell[CellGroupData[{
Cell[11406, 370, 244, 8, 70, "Input",
 CellID->28722],
Cell[11653, 380, 229, 7, 36, "Output",
 CellID->31132]
}, Open  ]],
Cell[11897, 390, 120, 3, 70, "ExampleDelimiter",
 CellID->5618],
Cell[12020, 395, 89, 1, 70, "ExampleText",
 CellID->14372],
Cell[CellGroupData[{
Cell[12134, 400, 499, 18, 70, "Input",
 CellID->18716],
Cell[12636, 420, 357, 13, 36, "Output",
 CellID->22519]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13042, 439, 215, 7, 70, "ExampleSection",
 CellID->8108],
Cell[13260, 448, 60, 1, 70, "ExampleText",
 CellID->32412],
Cell[CellGroupData[{
Cell[13345, 453, 238, 8, 70, "Input",
 CellID->19240],
Cell[13586, 463, 294, 10, 39, "Output",
 CellID->20573]
}, Open  ]],
Cell[13895, 476, 121, 3, 70, "ExampleDelimiter",
 CellID->19298],
Cell[14019, 481, 73, 1, 70, "ExampleText",
 CellID->6357],
Cell[CellGroupData[{
Cell[14117, 486, 231, 7, 70, "Input",
 CellID->6569],
Cell[14351, 495, 269, 8, 36, "Output",
 CellID->11673]
}, Open  ]],
Cell[14635, 506, 121, 3, 70, "ExampleDelimiter",
 CellID->30898],
Cell[14759, 511, 57, 1, 70, "ExampleText",
 CellID->25625],
Cell[CellGroupData[{
Cell[14841, 516, 217, 6, 70, "Input",
 CellID->22395],
Cell[15061, 524, 271, 8, 43, "Output",
 CellID->18820]
}, Open  ]],
Cell[15347, 535, 62, 1, 70, "ExampleText",
 CellID->2067],
Cell[CellGroupData[{
Cell[15434, 540, 248, 8, 70, "Input",
 CellID->25302],
Cell[15685, 550, 274, 9, 43, "Output",
 CellID->20969]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16008, 565, 239, 7, 70, "ExampleSection",
 CellID->32392],
Cell[16250, 574, 70, 1, 70, "ExampleText",
 CellID->25427],
Cell[CellGroupData[{
Cell[16345, 579, 168, 5, 70, "Input",
 CellID->11374],
Cell[16516, 586, 223, 7, 36, "Output",
 CellID->1116]
}, Open  ]],
Cell[CellGroupData[{
Cell[16776, 598, 139, 4, 70, "Input",
 CellID->21955],
Cell[16918, 604, 196, 6, 36, "Output",
 CellID->15661]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17163, 616, 223, 7, 70, "ExampleSection",
 CellID->29830],
Cell[17389, 625, 66, 1, 70, "ExampleText",
 CellID->16997],
Cell[CellGroupData[{
Cell[17480, 630, 215, 7, 70, "Input",
 CellID->28445],
Cell[17698, 639, 270, 9, 36, "Output",
 CellID->29544]
}, Open  ]],
Cell[17983, 651, 61, 1, 70, "ExampleText",
 CellID->7905],
Cell[CellGroupData[{
Cell[18069, 656, 354, 12, 70, "Input",
 CellID->11354],
Cell[18426, 670, 270, 9, 36, "Output",
 CellID->26995]
}, Open  ]],
Cell[18711, 682, 119, 3, 70, "ExampleDelimiter",
 CellID->521],
Cell[18833, 687, 56, 1, 70, "ExampleText",
 CellID->1880],
Cell[CellGroupData[{
Cell[18914, 692, 287, 9, 70, "Input",
 CellID->3626],
Cell[19204, 703, 777, 24, 65, "Output",
 CellID->27047]
}, Open  ]],
Cell[19996, 730, 63, 1, 70, "ExampleText",
 CellID->10954],
Cell[CellGroupData[{
Cell[20084, 735, 323, 11, 70, "Input",
 CellID->16963],
Cell[20410, 748, 777, 24, 65, "Output",
 CellID->10781]
}, Open  ]],
Cell[21202, 775, 121, 3, 70, "ExampleDelimiter",
 CellID->27372],
Cell[21326, 780, 72, 1, 70, "ExampleText",
 CellID->30174],
Cell[CellGroupData[{
Cell[21423, 785, 227, 7, 70, "Input",
 CellID->2457],
Cell[21653, 794, 279, 8, 36, "Output",
 CellID->6818]
}, Open  ]],
Cell[21947, 805, 61, 1, 70, "ExampleText",
 CellID->1287],
Cell[CellGroupData[{
Cell[22033, 810, 384, 12, 70, "Input",
 CellID->9929],
Cell[22420, 824, 280, 8, 36, "Output",
 CellID->12897]
}, Open  ]],
Cell[22715, 835, 121, 3, 70, "ExampleDelimiter",
 CellID->16881],
Cell[22839, 840, 51, 1, 70, "ExampleText",
 CellID->5738],
Cell[CellGroupData[{
Cell[22915, 845, 248, 9, 70, "Input",
 CellID->11618],
Cell[23166, 856, 1101, 38, 54, "Output",
 CellID->18719]
}, Open  ]],
Cell[CellGroupData[{
Cell[24304, 899, 233, 8, 70, "Input",
 CellID->23792],
Cell[24540, 909, 1100, 38, 54, "Output",
 CellID->3676]
}, Open  ]],
Cell[25655, 950, 121, 3, 70, "ExampleDelimiter",
 CellID->31375],
Cell[25779, 955, 57, 1, 70, "ExampleText",
 CellID->17980],
Cell[CellGroupData[{
Cell[25861, 960, 398, 14, 70, "Input",
 CellID->15699],
Cell[26262, 976, 365, 11, 36, "Output",
 CellID->26852]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[26676, 993, 232, 7, 70, "ExampleSection",
 CellID->5665],
Cell[26911, 1002, 88, 1, 70, "ExampleText",
 CellID->5966],
Cell[CellGroupData[{
Cell[27024, 1007, 238, 8, 70, "Input",
 CellID->28424],
Cell[27265, 1017, 292, 10, 36, "Output",
 CellID->13382]
}, Open  ]],
Cell[27572, 1030, 120, 3, 70, "ExampleDelimiter",
 CellID->9404],
Cell[27695, 1035, 86, 1, 70, "ExampleText",
 CellID->25210],
Cell[CellGroupData[{
Cell[27806, 1040, 232, 7, 70, "Input",
 CellID->19666],
Cell[28041, 1049, 290, 10, 51, "Output",
 CellID->28740]
}, Open  ]],
Cell[28346, 1062, 121, 3, 70, "ExampleDelimiter",
 CellID->14059],
Cell[28470, 1067, 60, 1, 70, "ExampleText",
 CellID->1709],
Cell[CellGroupData[{
Cell[28555, 1072, 377, 13, 70, "Input",
 CellID->18484],
Cell[28935, 1087, 292, 10, 36, "Output",
 CellID->23913]
}, Open  ]],
Cell[29242, 1100, 120, 3, 70, "ExampleDelimiter",
 CellID->3040],
Cell[29365, 1105, 215, 8, 70, "ExampleText",
 CellID->995],
Cell[CellGroupData[{
Cell[29605, 1117, 239, 9, 70, "Input",
 CellID->26768],
Cell[29847, 1128, 337, 12, 36, "Output",
 CellID->3994]
}, Open  ]],
Cell[30199, 1143, 121, 3, 70, "ExampleDelimiter",
 CellID->10682],
Cell[30323, 1148, 66, 1, 70, "ExampleText",
 CellID->16979],
Cell[CellGroupData[{
Cell[30414, 1153, 382, 13, 70, "Input",
 CellID->17808],
Cell[CellGroupData[{
Cell[30821, 1170, 132, 4, 70, "Print",
 CellID->3822],
Cell[30956, 1176, 133, 4, 70, "Print",
 CellID->19203],
Cell[31092, 1182, 133, 4, 70, "Print",
 CellID->23014],
Cell[31228, 1188, 131, 4, 70, "Print",
 CellID->197],
Cell[31362, 1194, 133, 4, 70, "Print",
 CellID->31424],
Cell[31498, 1200, 133, 4, 70, "Print",
 CellID->17789],
Cell[31634, 1206, 133, 4, 70, "Print",
 CellID->28142]
}, Open  ]],
Cell[31782, 1213, 217, 7, 36, "Output",
 CellID->654]
}, Open  ]],
Cell[32014, 1223, 121, 3, 70, "ExampleDelimiter",
 CellID->25346],
Cell[32138, 1228, 78, 1, 70, "ExampleText",
 CellID->19998],
Cell[CellGroupData[{
Cell[32241, 1233, 421, 14, 70, "Input",
 CellID->28949],
Cell[32665, 1249, 779, 26, 36, "Output",
 CellID->32316]
}, Open  ]],
Cell[33459, 1278, 125, 3, 70, "ExampleDelimiter",
 CellID->597400362],
Cell[33587, 1283, 504, 19, 70, "ExampleText",
 CellID->87001366],
Cell[34094, 1304, 191, 6, 70, "Input",
 CellID->338990403],
Cell[CellGroupData[{
Cell[34310, 1314, 101, 3, 70, "Input",
 CellID->3625846],
Cell[34414, 1319, 292, 9, 36, "Output",
 CellID->192113041]
}, Open  ]],
Cell[CellGroupData[{
Cell[34743, 1333, 162, 5, 70, "Input",
 CellID->413706816],
Cell[34908, 1340, 291, 9, 36, "Output",
 CellID->29584337]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[35248, 1355, 226, 7, 70, "ExampleSection",
 CellID->19411],
Cell[35477, 1364, 118, 3, 70, "ExampleText",
 CellID->15961],
Cell[CellGroupData[{
Cell[35620, 1371, 255, 8, 70, "Input",
 CellID->26003],
Cell[35878, 1381, 267, 10, 55, "Output",
 CellID->371]
}, Open  ]],
Cell[36160, 1394, 67, 1, 70, "ExampleText",
 CellID->3924],
Cell[CellGroupData[{
Cell[36252, 1399, 289, 10, 70, "Input",
 CellID->16031],
Cell[36544, 1411, 269, 10, 55, "Output",
 CellID->28069]
}, Open  ]],
Cell[36828, 1424, 120, 3, 70, "ExampleDelimiter",
 CellID->4819],
Cell[36951, 1429, 137, 4, 70, "ExampleText",
 CellID->4536],
Cell[CellGroupData[{
Cell[37113, 1437, 242, 8, 70, "Input",
 CellID->31270],
Cell[37358, 1447, 229, 7, 36, "Output",
 CellID->16442]
}, Open  ]],
Cell[CellGroupData[{
Cell[37624, 1459, 241, 8, 70, "Input",
 CellID->9176],
Cell[37868, 1469, 229, 7, 36, "Output",
 CellID->31643]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[38146, 1482, 224, 7, 70, "ExampleSection",
 CellID->21999],
Cell[38373, 1491, 77, 1, 70, "ExampleText",
 CellID->23039],
Cell[CellGroupData[{
Cell[38475, 1496, 653, 21, 70, "Input",
 CellID->28309],
Cell[39131, 1519, 2836, 51, 70, "Output",
 Evaluatable->False,
 CellID->159954098]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[42028, 1577, 311, 9, 70, "SeeAlsoSection",
 CellID->30890],
Cell[42342, 1588, 2146, 80, 70, "SeeAlso",
 CellID->10521]
}, Open  ]],
Cell[CellGroupData[{
Cell[44525, 1673, 314, 9, 70, "TutorialsSection",
 CellID->14361],
Cell[44842, 1684, 143, 3, 70, "Tutorials",
 CellID->3501],
Cell[44988, 1689, 142, 3, 70, "Tutorials",
 CellID->7239],
Cell[45133, 1694, 152, 3, 70, "Tutorials",
 CellID->19437]
}, Open  ]],
Cell[CellGroupData[{
Cell[45322, 1702, 318, 9, 70, "MoreAboutSection",
 CellID->63258813],
Cell[45643, 1713, 157, 3, 70, "MoreAbout",
 CellID->446045953],
Cell[45803, 1718, 149, 3, 70, "MoreAbout",
 CellID->5103217],
Cell[45955, 1723, 155, 3, 70, "MoreAbout",
 CellID->164724238],
Cell[46113, 1728, 144, 3, 70, "MoreAbout",
 CellID->66714239],
Cell[46260, 1733, 190, 4, 70, "MoreAbout",
 CellID->221035817],
Cell[46453, 1739, 139, 3, 70, "MoreAbout",
 CellID->578791133],
Cell[46595, 1744, 155, 3, 70, "MoreAbout",
 CellID->51503267],
Cell[46753, 1749, 177, 3, 70, "MoreAbout",
 CellID->807332279],
Cell[46933, 1754, 148, 3, 70, "MoreAbout",
 CellID->15262245],
Cell[47084, 1759, 179, 3, 70, "MoreAbout",
 CellID->8320012]
}, Open  ]],
Cell[CellGroupData[{
Cell[47300, 1767, 305, 8, 70, "RelatedLinksSection"],
Cell[47608, 1777, 382, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[48005, 1793, 27, 0, 70, "History"],
Cell[48035, 1795, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

