(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[   1160500,      22058]
NotebookOptionsPosition[   1151666,      21764]
NotebookOutlinePosition[   1153281,      21806]
CellTagsIndexPosition[   1153192,      21801]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Sound" :> Documentation`HelpLookup["paclet:tutorial/Sound"], 
          "The Representation of Sound" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheRepresentationOfSound"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Sound\"\>", 
       2->"\<\"The Representation of Sound\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SoundNote" :> Documentation`HelpLookup["paclet:ref/SoundNote"],
           "SampledSoundList" :> 
          Documentation`HelpLookup["paclet:ref/SampledSoundList"], 
          "SampledSoundFunction" :> 
          Documentation`HelpLookup["paclet:ref/SampledSoundFunction"], 
          "EmitSound" :> Documentation`HelpLookup["paclet:ref/EmitSound"], 
          "ListPlay" :> Documentation`HelpLookup["paclet:ref/ListPlay"], 
          "Play" :> Documentation`HelpLookup["paclet:ref/Play"], "Import" :> 
          Documentation`HelpLookup["paclet:ref/Import"], "Export" :> 
          Documentation`HelpLookup["paclet:ref/Export"], "Graphics" :> 
          Documentation`HelpLookup["paclet:ref/Graphics"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"SoundNote\"\>", 
       2->"\<\"SampledSoundList\"\>", 3->"\<\"SampledSoundFunction\"\>", 
       4->"\<\"EmitSound\"\>", 5->"\<\"ListPlay\"\>", 6->"\<\"Play\"\>", 
       7->"\<\"Import\"\>", 8->"\<\"Export\"\>", 
       9->"\<\"Graphics\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Sound and Sonification" :> 
          Documentation`HelpLookup["paclet:guide/SoundAndSonification"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Sound and Sonification\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Sound", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Sound",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Sound"], "[", 
       StyleBox["primitives", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a sound. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Sound",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Sound"], "[", 
       RowBox[{
        StyleBox["primitives", "TI"], ",", 
        StyleBox["t", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]specifies that the sound should have duration ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Sound",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Sound"], "[", 
       RowBox[{
        StyleBox["primitives", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["t", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["t", "TI"], 
           StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]specifies that the sound should extend from time ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["t", "TI"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     " to time ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["t", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->260]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["Lists containing the following primitives can be used: ", "Notes",
 CellID->19464],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["SampledSoundFunction",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SampledSoundFunction"], "[", 
     RowBox[{
      StyleBox["f", "TI"], ",", 
      StyleBox["n", "TI"], ",", 
      StyleBox["r", "TI"]}], "]"}], Cell[
    "amplitude levels generated by a function ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox[
     RowBox[{"SampledSoundList", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["a", "TI"], "1"], ",", 
         SubscriptBox[
          StyleBox["a", "TI"], "2"], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
       StyleBox["r", "TI"]}], "]"}],
     GridElementStyleOptions -> {ColumnAlignments -> Left}], 
    "\[SpanFromLeft]"},
   {Cell["      ", "TableRowIcon"], "", Cell[
    "amplitude levels given in a list ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{
     ButtonBox["SoundNote",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SoundNote"], "[", 
     RowBox[{
      StyleBox["spec", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], Cell[
    "a music-like note", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{"Sound", "[", 
     RowBox[{
      StyleBox["prims", "TI"], ",", 
      StyleBox["t", "TI"]}], "]"}], Cell[TextData[{
     "a sound scaled to have duration ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{"Sound", "[", 
     RowBox[{
      StyleBox["prims", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["t", "TI"], 
         StyleBox["min", "TI"]], ",", 
        SubscriptBox[
         StyleBox["t", "TI"], 
         StyleBox["max", "TI"]]}], "}"}]}], "]"}], Cell[TextData[{
     "a sound played over the time interval ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["t", "TI"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["t", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"]
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], {
      Dynamic[
       If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
        RGBColor[0.92, 1, 0.59], None]]}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, False, True, True, True, True}}}},
 CellID->27585],

Cell["\<\
Primitives with duration specifications are played consecutively in sequence, \
independent of primitives with explicit time specifications. \
\>", "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->15418],

Cell[TextData[{
 "When primitives ",
 Cell[BoxData[
  StyleBox["prims", "TI"]], "InlineFormula"],
 " appear in ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sound",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sound"], "[", 
   RowBox[{
    StyleBox["prims", "TI"], ",", 
    StyleBox["tspec", "TI"]}], "]"}]], "InlineFormula"],
 ", the sequence of durations and time specifications in ",
 Cell[BoxData[
  StyleBox["prims", "TI"]], "InlineFormula"],
 " are rescaled and shifted to fit into the time interval defined by ",
 Cell[BoxData[
  StyleBox["tspec", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->26128],

Cell[TextData[{
 "For the outermost ",
 Cell[BoxData[
  ButtonBox["Sound",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sound"]], "InlineFormula"],
 " object, times are by default taken to be given in absolute seconds."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->22586],

Cell[TextData[{
 "For inner ",
 Cell[BoxData[
  ButtonBox["Sound",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sound"]], "InlineFormula"],
 " objects, times can be given as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Scaled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Scaled"], "[", 
   StyleBox["r", "TI"], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->11883],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sound",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sound"], "[", 
   RowBox[{
    StyleBox["prims", "TI"], ",", 
    RowBox[{
     ButtonBox["Scaled",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Scaled"], "[", 
     StyleBox["r", "TI"], "]"}]}], "]"}]], "InlineFormula"],
 " will slow down ",
 Cell[BoxData[
  StyleBox["prims", "TI"]], "InlineFormula"],
 " by a factor ",
 Cell[BoxData[
  StyleBox["r", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->29374],

Cell[TextData[{
 "Mixed into lists of sound primitives can be the following ",
 Cell[BoxData[
  ButtonBox["SoundNote",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SoundNote"]], "InlineFormula"],
 " directives:"
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->10823],

Cell[BoxData[GridBox[{
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], "\"\<\!\(\*
StyleBox[\"style\", \"TI\"]\)\>\"", Cell[
    "use the specified style", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{
     StyleBox["opt", "TI"], "->", 
     StyleBox["value", "TI"]}], Cell[
    "use the specified option setting", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], {
      Dynamic[
       If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
        RGBColor[0.92, 1, 0.59], None]]}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->10901],

Cell[TextData[{
 "The possible styles and options are those for ",
 Cell[BoxData[
  ButtonBox["SoundNote",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SoundNote"]], "InlineFormula"],
 "."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->22432],

Cell["\<\
Nested lists of sound primitives and directives can be given. Directive \
specifications normally remain in effect only until the end of the list which \
contains them. \
\>", "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->7823],

Cell["\<\
A list containing only graphics directives is treated as if its elements were \
directly inserted into an enclosing list. \
\>", "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->6079],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"], "[", 
   RowBox[{
    StyleBox["obj", "TI"], ",", 
    StyleBox["opts", "TI"]}], "]"}]], "InlineFormula"],
 " can be used to apply the options or directives ",
 Cell[BoxData[
  StyleBox["opts", "TI"]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  StyleBox["obj", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->22947],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sound",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sound"]], "InlineFormula"],
 " can be played using ",
 Cell[BoxData[
  ButtonBox["EmitSound",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EmitSound"]], "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->1359],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sound",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sound"], "[", 
   StyleBox["\[Ellipsis]", "TR"], "]"}]], "InlineFormula"],
 " is displayed in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " as a button containing a graphic representing the sound. Clicking the \
button plays the sound, preempting any other sounds that are already playing. \
"
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->308],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sound",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sound"], "[", 
   StyleBox["\[Ellipsis]", "TR"], "]"}]], "InlineFormula"],
 " is displayed as an explicit list of primitives. "
}], "Notes",
 CellID->22524],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  RowBox[{"SoundVolume", "->", 
   StyleBox["v", "TI"]}]], "InlineFormula"],
 " specifies an relative sound volume ",
 Cell[BoxData[
  StyleBox["v", "TI"]], "InlineFormula"],
 " for a note."
}], "Notes",
 CellID->726003106]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->707734244],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->7091229],

Cell["Represent a sound consisting of a sequence of two notes:", "ExampleText",
 CellID->670645724],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sound", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"SoundNote", "[", "\"\<C\>\"", "]"}], ",", 
    RowBox[{"SoundNote", "[", "\"\<G\>\"", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->310332543],

Cell[BoxData[
 InterpretationBox[
  GraphicsBox[{
    {GrayLevel[0.9], RectangleBox[{0, 0}, {360, -164}]}, {InsetBox[
      GraphicsBox[
       {RGBColor[0.5, 0, 0.5], 
        StyleBox[{
          RectangleBox[{0., 0.43198696602798653`}, \
{0.95, 0.4438917279327484}], 
          RectangleBox[{1., 0.5153202993613198}, {1.95, 0.5272250612660818}]},
         
         Antialiasing->True]},
       AspectRatio->NCache[
         Rational[6, 35], 0.17142857142857143`],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0.75],
       FrameTicks->False,
       PlotRange->All,
       PlotRangePadding->{Automatic, 0.05}], {180, -35}, 
      ImageScaled[{0.5, 0.5}], {350, 60},
      Background->GrayLevel[0.9]], InsetBox[
      GraphicsBox[
       {GrayLevel[0.6], RectangleBox[{0, 0}]},
       AspectRatio->NCache[
         Rational[6, 35], 0.17142857142857143`],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0.75],
       FrameTicks->False], {180, -100}, ImageScaled[{0.5, 0.5}], {350, 60},
      Background->GrayLevel[0.9]]}, InsetBox[
     StyleBox[
      InterpretationBox[
       InterpretationBox[
        RowBox[{"2", "\[InvisibleSpace]", "\<\" s\"\>"}],
        Row[{2, " s"}]],
       Row[{
         Row[{2, " s"}]}, 
        Style[" | ", FontSize -> 14, FontColor -> GrayLevel[0.75]]]], 
      "DialogStyle",
      StripOnInput->False], {355, -159}, Scaled[{1, 0}]], 
    TagBox[
     TooltipBox[
      TagBox[{
        {GrayLevel[0.9], RectangleBox[{5, -158}, {29, -135}]}, 
        {GrayLevel[0.3], 
         PolygonBox[
          NCache[{{13, -153}, {13, -140}, {21, Rational[-293, 2]}, {
            13, -153}}, {{13, -153}, {13, -140}, {21, -146.5}, {
            13, -153}}]]}, 
        {GrayLevel[0.5], 
         StyleBox[
          LineBox[{{5, -158}, {5, -135}, {29, -135}, {29, -158}, {5, -158}}],
          Antialiasing->False]}},
       EventHandlerTag[{"MouseClicked" :> (If[Sound`MIDISequence[{
               Sound`MIDITrack[{
                 Sound`MIDIEvent[0, "SetTempo", "Tempo" -> 1000000], 
                 Sound`MIDIEvent[
                 0, "ProgramCommand", "Channel" -> 0, "Value" -> 0], 
                 Sound`MIDIEvent[
                 0, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 1, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 1, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 2, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0]}]}, "DivisionType" -> "PPQ", "Resolution" -> 1] =!= None,
             
            Sound`EmitMIDI[
             Sound`MIDISequence[{
               Sound`MIDITrack[{
                 Sound`MIDIEvent[0, "SetTempo", "Tempo" -> 1000000], 
                 Sound`MIDIEvent[
                 0, "ProgramCommand", "Channel" -> 0, "Value" -> 0], 
                 Sound`MIDIEvent[
                 0, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 1, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 1, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 2, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0]}]}, "DivisionType" -> "PPQ", "Resolution" -> 1]]]; 
          Sound`SoundDump`emitSoundThroughFE[None, "Preemptive"]), 
         PassEventsDown -> Automatic, PassEventsUp -> True}]],
      "\"Play\""],
     Annotation[#, "Play", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[{
        {GrayLevel[0.9], RectangleBox[{34, -158}, {58, -135}]}, 
        {GrayLevel[0.3], RectangleBox[{42, -150}, {50, -143}]}, 
        {GrayLevel[0.5], 
         StyleBox[
          LineBox[{{34, -158}, {34, -135}, {58, -135}, {58, -158}, {
           34, -158}}],
          Antialiasing->False]}},
       EventHandlerTag[{
        "MouseClicked" :> (Sound`SoundDump`emitSoundThroughFE[
            SampledSoundList[{{0.}}, 8000], "Preemptive"]; 
          Sound`MIDIDump`stopMIDI[]), PassEventsDown -> Automatic, 
         PassEventsUp -> True}]],
      "\"Stop\""],
     Annotation[#, "Stop", "Tooltip"]& ], 
    {GrayLevel[0.75], 
     StyleBox[LineBox[{{0, 0}, {360, 0}, {360, -164}, {0, -164}, {0, 0}}],
      Antialiasing->False]}},
   ContentSelectable->False,
   ImageSize->250,
   PlotRange->{{0, 360}, {0, -164}},
   PlotRangePadding->1],
  Sound[{
    SoundNote["C"], 
    SoundNote["G"]}]]], "Output",
 ImageSize->{254, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->310583765]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->38817087],

Cell["Represent a sound consisting of a sequence of two waveforms:", \
"ExampleText",
 CellID->510803100],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sound", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Play", "[", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"1000", "t", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"t", "^", "2"}]}], ")"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", ".2"}], "}"}]}], "]"}], ",", 
    RowBox[{"Play", "[", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"500", "t", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"t", "^", "3"}]}], ")"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", ".5"}], "}"}]}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9556438],

Cell[BoxData[
 InterpretationBox[
  GraphicsBox[{
    {GrayLevel[0.9], RectangleBox[{0, 0}, {360, -164}]}, {InsetBox[
      GraphicsBox[InsetBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJzs23k0lVH4L/BooIFCk0qkKJQGaUB9TaFCKppLUlEaSKSBSkSkohRFJPN4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          "],
          ColorFunction->(Blend[{
             RGBColor[1, 1, 1], 
             RGBColor[0, 0, 1]}, #]& )],
         AspectRatio->Full,
         ImageSize->NCache[{
            Rational[7, 10]}, {0.7}],
         PlotRangePadding->None], {0, 0}, {0, 0}, 
        NCache[{Rational[7, 10], 1}, {0.7, 1}]],
       AspectRatio->NCache[
         Rational[6, 35], 0.17142857142857143`],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0.75],
       FrameTicks->False,
       PlotRange->NCache[{{0, 
           Rational[7, 10]}, {0, 1}}, {{0, 0.7}, {0, 1}}],
       PlotRangePadding->{
         Scaled[0.017142857142857144`], 
         Scaled[0.1]}], {180, -35}, ImageScaled[{0.5, 0.5}], {350, 60},
      Background->GrayLevel[0.9]], InsetBox[
      GraphicsBox[InsetBox[
        GraphicsBox[
         {RGBColor[0.325101, 0.364492, 0.820256], LineBox[CompressedData["
1:eJw0XHc81G8cLxXtQlEpaadoKFKqd0IUqWhIiVCkVNLQElEiZCRbVvbeexx3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           "]]},
         AspectRatio->Full,
         PlotRange->{Automatic, {0, 1}},
         PlotRangePadding->None], {0, 0}, {0, 0}, 
        NCache[{Rational[7, 10], 1}, {0.7, 1}]],
       AspectRatio->NCache[
         Rational[6, 35], 0.17142857142857143`],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0.75],
       FrameTicks->False,
       PlotRange->NCache[{{0, 
           Rational[7, 10]}, {0, 1}}, {{0, 0.7}, {0, 1}}],
       PlotRangePadding->{
         Scaled[0.017142857142857144`], 
         Scaled[0.1]}], {180, -100}, ImageScaled[{0.5, 0.5}], {350, 60},
      Background->GrayLevel[0.9]]}, InsetBox[
     StyleBox[
      InterpretationBox[
       RowBox[{
        InterpretationBox[
         RowBox[{"\<\"0.7\"\>", "\[InvisibleSpace]", "\<\" s\"\>"}],
         Row[{"0.7", " s"}]], 
        StyleBox["\<\" | \"\>",
         StripOnInput->False,
         FontSize->14,
         FontColor->GrayLevel[0.75]], 
        InterpretationBox[
         RowBox[{"8000", "\[InvisibleSpace]", "\<\" Hz\"\>"}],
         Row[{8000, " Hz"}]]}],
       Row[{
         Row[{"0.7", " s"}], 
         Row[{8000, " Hz"}]}, 
        Style[" | ", FontSize -> 14, FontColor -> GrayLevel[0.75]]]], 
      "DialogStyle",
      StripOnInput->False], {355, -159}, Scaled[{1, 0}]], 
    TagBox[
     TooltipBox[
      TagBox[{
        {GrayLevel[0.9], RectangleBox[{5, -158}, {29, -135}]}, 
        {GrayLevel[0.3], 
         PolygonBox[
          NCache[{{13, -153}, {13, -140}, {21, Rational[-293, 2]}, {
            13, -153}}, {{13, -153}, {13, -140}, {21, -146.5}, {
            13, -153}}]]}, 
        {GrayLevel[0.5], 
         StyleBox[
          LineBox[{{5, -158}, {5, -135}, {29, -135}, {29, -158}, {5, -158}}],
          Antialiasing->False]}},
       EventHandlerTag[{"MouseClicked" :> (If[None =!= None, 
            Sound`EmitMIDI[None]]; Sound`SoundDump`emitSoundThroughFE[
            SampledSoundList[CompressedData["
1:eJwsmXc41f///xs0NISsEqFhj96hNB5RUpRkpUGSKFIqhBShZJWVFEXIKtkN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             "], 8000], "Preemptive"]), PassEventsDown -> Automatic, 
         PassEventsUp -> True}]],
      "\"Play\""],
     Annotation[#, "Play", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[{
        {GrayLevel[0.9], RectangleBox[{34, -158}, {58, -135}]}, 
        {GrayLevel[0.3], RectangleBox[{42, -150}, {50, -143}]}, 
        {GrayLevel[0.5], 
         StyleBox[
          LineBox[{{34, -158}, {34, -135}, {58, -135}, {58, -158}, {
           34, -158}}],
          Antialiasing->False]}},
       EventHandlerTag[{
        "MouseClicked" :> (Sound`SoundDump`emitSoundThroughFE[
            SampledSoundList[{{0.}}, 8000], "Preemptive"]; 
          Sound`MIDIDump`stopMIDI[]), PassEventsDown -> Automatic, 
         PassEventsUp -> True}]],
      "\"Stop\""],
     Annotation[#, "Stop", "Tooltip"]& ], 
    {GrayLevel[0.75], 
     StyleBox[LineBox[{{0, 0}, {360, 0}, {360, -164}, {0, -164}, {0, 0}}],
      Antialiasing->False]}},
   ContentSelectable->False,
   ImageSize->250,
   PlotRange->{{0, 360}, {0, -164}},
   PlotRangePadding->1],
  Sound[{
    Sound[
     SampledSoundFunction[
      CompiledFunction[{
        Blank[Integer]}, {{2, 0, 0}, {3, 0, 2}}, {0, 4, 3, 0, 
       0}, {{1, 5}, {8, 0., 0}, {8, 0.000125, 1}, {15, 1, 0, 2}, {21, 1, 2, 
        1}, {18, 0, 1, 0}, {7, 1000, 1}, {7, 1, 2}, {7, 2, 3}, {94, 264, 3, 0,
         0, 2, 0, 3, 3, 0, 1}, {15, 0, 2, 2}, {18, 2, 1, 2}, {15, 1, 1, 1}, {
        21, 1, 0, 2, 1}, {93, 1, 3, 0, 1, 3, 0, 2}, {
        8, 4.869052694145282*^-6, 1}, {18, 2, 1, 2}, {
        8, 1.0000103390973851`, 1}, {21, 2, 1, 2}, {2}}, 
       Function[{Play`Time61}, 
        Block[{$CellContext`t = 0. + 0.000125 Play`Time61}, (
          Sin[1000 $CellContext`t (1 + $CellContext`t^2)] + 
          4.869052694145282*^-6) 1.0000103390973851`]], Evaluate], 1600, 
      8000]], 
    Sound[
     SampledSoundFunction[
      CompiledFunction[{
        Blank[Integer]}, {{2, 0, 0}, {3, 0, 2}}, {0, 4, 3, 0, 
       0}, {{1, 5}, {8, 0., 0}, {8, 0.000125, 1}, {15, 1, 0, 2}, {21, 1, 2, 
        1}, {18, 0, 1, 0}, {7, 500, 1}, {7, 1, 2}, {7, 3, 3}, {94, 264, 3, 0, 
        0, 2, 0, 3, 3, 0, 1}, {15, 0, 2, 2}, {18, 2, 1, 2}, {15, 1, 1, 1}, {
        21, 1, 0, 2, 1}, {93, 1, 3, 0, 1, 3, 0, 2}, {
        8, -0.00001422033195530581, 1}, {18, 2, 1, 2}, {
        8, 1.0000142366019642`, 1}, {21, 2, 1, 2}, {2}}, 
       Function[{Play`Time62}, 
        Block[{$CellContext`t = 0. + 0.000125 Play`Time62}, (
          Sin[500 $CellContext`t (1 + $CellContext`t^3)] - 
          0.00001422033195530581) 1.0000142366019642`]], Evaluate], 4000, 
      8000]]}]]], "Output",
 ImageSize->{254, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->498601044]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23789],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Time Sequences",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->247547451],

Cell["\<\
Represent a sequence of notes, with each note taking 1 second:\
\>", "ExampleText",
 CellID->583462302],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sound", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"SoundNote", "[", "i", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", "12"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->151785638],

Cell[BoxData[
 InterpretationBox[
  GraphicsBox[{
    {GrayLevel[0.9], RectangleBox[{0, 0}, {360, -164}]}, {InsetBox[
      GraphicsBox[
       {RGBColor[0.5, 0, 0.5], 
        StyleBox[{
          RectangleBox[{0., 0.43198696602798653`}, \
{0.95, 0.4438917279327484}], 
          RectangleBox[{1., 0.4438917279327484}, \
{1.95, 0.45579648983751037`}], 
          RectangleBox[{2., 0.45579648983751037`}, \
{2.95, 0.4677012517422721}], 
          RectangleBox[{3., 0.4677012517422721}, {3.95, 0.4796060136470343}], 
          RectangleBox[{4., 0.4796060136470343}, \
{4.95, 0.49151077555179606`}], 
          RectangleBox[{5., 0.49151077555179606`}, \
{5.95, 0.5034155374565581}], 
          RectangleBox[{6., 0.5034155374565581}, {6.95, 0.5153202993613198}], 
          RectangleBox[{7., 0.5153202993613198}, {7.95, 0.5272250612660818}], 
          RectangleBox[{8., 0.5272250612660818}, {8.95, 0.5391298231708438}], 
          RectangleBox[{9., 0.5391298231708438}, {9.95, 0.5510345850756055}], 
          RectangleBox[{10., 0.5510345850756055}, \
{10.95, 0.5629393469803675}], 
          RectangleBox[{11., 0.5629393469803675}, \
{11.95, 0.5748441088851295}], 
          RectangleBox[{12., 0.5748441088851295}, \
{12.95, 0.5867488707898912}]},
         Antialiasing->True]},
       AspectRatio->NCache[
         Rational[6, 35], 0.17142857142857143`],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0.75],
       FrameTicks->False,
       PlotRange->All,
       PlotRangePadding->{Automatic, 0.05}], {180, -35}, 
      ImageScaled[{0.5, 0.5}], {350, 60},
      Background->GrayLevel[0.9]], InsetBox[
      GraphicsBox[
       {GrayLevel[0.6], RectangleBox[{0, 0}]},
       AspectRatio->NCache[
         Rational[6, 35], 0.17142857142857143`],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0.75],
       FrameTicks->False], {180, -100}, ImageScaled[{0.5, 0.5}], {350, 60},
      Background->GrayLevel[0.9]]}, InsetBox[
     StyleBox[
      InterpretationBox[
       InterpretationBox[
        RowBox[{"13", "\[InvisibleSpace]", "\<\" s\"\>"}],
        Row[{13, " s"}]],
       Row[{
         Row[{13, " s"}]}, 
        Style[" | ", FontSize -> 14, FontColor -> GrayLevel[0.75]]]], 
      "DialogStyle",
      StripOnInput->False], {355, -159}, Scaled[{1, 0}]], 
    TagBox[
     TooltipBox[
      TagBox[{
        {GrayLevel[0.9], RectangleBox[{5, -158}, {29, -135}]}, 
        {GrayLevel[0.3], 
         PolygonBox[
          NCache[{{13, -153}, {13, -140}, {21, Rational[-293, 2]}, {
            13, -153}}, {{13, -153}, {13, -140}, {21, -146.5}, {
            13, -153}}]]}, 
        {GrayLevel[0.5], 
         StyleBox[
          LineBox[{{5, -158}, {5, -135}, {29, -135}, {29, -158}, {5, -158}}],
          Antialiasing->False]}},
       EventHandlerTag[{"MouseClicked" :> (If[Sound`MIDISequence[{
               Sound`MIDITrack[{
                 Sound`MIDIEvent[0, "SetTempo", "Tempo" -> 1000000], 
                 Sound`MIDIEvent[
                 0, "ProgramCommand", "Channel" -> 0, "Value" -> 0], 
                 Sound`MIDIEvent[
                 0, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 1, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 1, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 2, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 2, "NoteOn", "Note" -> 62, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 3, "NoteOff", "Note" -> 62, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 3, "NoteOn", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 4, "NoteOff", "Note" -> 63, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 4, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 5, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 5, "NoteOn", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 6, "NoteOff", "Note" -> 65, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 6, "NoteOn", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 7, "NoteOff", "Note" -> 66, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 7, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 8, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 8, "NoteOn", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 9, "NoteOff", "Note" -> 68, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 9, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 10, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 10, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 11, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 11, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 12, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 12, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 13, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0]}]}, "DivisionType" -> "PPQ", "Resolution" -> 1] =!= None,
             
            Sound`EmitMIDI[
             Sound`MIDISequence[{
               Sound`MIDITrack[{
                 Sound`MIDIEvent[0, "SetTempo", "Tempo" -> 1000000], 
                 Sound`MIDIEvent[
                 0, "ProgramCommand", "Channel" -> 0, "Value" -> 0], 
                 Sound`MIDIEvent[
                 0, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 1, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 1, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 2, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 2, "NoteOn", "Note" -> 62, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 3, "NoteOff", "Note" -> 62, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 3, "NoteOn", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 4, "NoteOff", "Note" -> 63, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 4, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 5, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 5, "NoteOn", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 6, "NoteOff", "Note" -> 65, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 6, "NoteOn", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 7, "NoteOff", "Note" -> 66, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 7, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 8, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 8, "NoteOn", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 9, "NoteOff", "Note" -> 68, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 9, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 10, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 10, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 11, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 11, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 12, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 12, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 13, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0]}]}, "DivisionType" -> "PPQ", "Resolution" -> 1]]]; 
          Sound`SoundDump`emitSoundThroughFE[None, "Preemptive"]), 
         PassEventsDown -> Automatic, PassEventsUp -> True}]],
      "\"Play\""],
     Annotation[#, "Play", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[{
        {GrayLevel[0.9], RectangleBox[{34, -158}, {58, -135}]}, 
        {GrayLevel[0.3], RectangleBox[{42, -150}, {50, -143}]}, 
        {GrayLevel[0.5], 
         StyleBox[
          LineBox[{{34, -158}, {34, -135}, {58, -135}, {58, -158}, {
           34, -158}}],
          Antialiasing->False]}},
       EventHandlerTag[{
        "MouseClicked" :> (Sound`SoundDump`emitSoundThroughFE[
            SampledSoundList[{{0.}}, 8000], "Preemptive"]; 
          Sound`MIDIDump`stopMIDI[]), PassEventsDown -> Automatic, 
         PassEventsUp -> True}]],
      "\"Stop\""],
     Annotation[#, "Stop", "Tooltip"]& ], 
    {GrayLevel[0.75], 
     StyleBox[LineBox[{{0, 0}, {360, 0}, {360, -164}, {0, -164}, {0, 0}}],
      Antialiasing->False]}},
   ContentSelectable->False,
   ImageSize->250,
   PlotRange->{{0, 360}, {0, -164}},
   PlotRangePadding->1],
  Sound[{
    SoundNote[0], 
    SoundNote[1], 
    SoundNote[2], 
    SoundNote[3], 
    SoundNote[4], 
    SoundNote[5], 
    SoundNote[6], 
    SoundNote[7], 
    SoundNote[8], 
    SoundNote[9], 
    SoundNote[10], 
    SoundNote[11], 
    SoundNote[12]}]]], "Output",
 ImageSize->{254, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->903086217]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->111028776],

Cell["\<\
Represent a sequence of notes, with the whole sequence lasting 1.5 seconds:\
\>", "ExampleText",
 CellID->648409438],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sound", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"SoundNote", "[", "i", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "12"}], "}"}]}], "]"}], ",", "1.5"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->261739344],

Cell[BoxData[
 InterpretationBox[
  GraphicsBox[{
    {GrayLevel[0.9], RectangleBox[{0, 0}, {360, -164}]}, {InsetBox[
      GraphicsBox[
       {RGBColor[0.5, 0, 0.5], 
        StyleBox[{
          RectangleBox[{0., 0.43198696602798653`}, \
{0.10961538461538461`, 0.4438917279327484}], 
          RectangleBox[{0.11538461538461539`, 0.4438917279327484}, \
{0.225, 0.45579648983751037`}], 
          RectangleBox[{0.23076923076923078`, 0.45579648983751037`}, \
{0.3403846153846154, 0.4677012517422721}], 
          RectangleBox[{0.34615384615384615`, 0.4677012517422721}, \
{0.4557692307692308, 0.4796060136470343}], 
          RectangleBox[{0.46153846153846156`, 0.4796060136470343}, \
{0.5711538461538461, 0.49151077555179606`}], 
          RectangleBox[{0.5769230769230769, 0.49151077555179606`}, \
{0.6865384615384615, 0.5034155374565581}], 
          RectangleBox[{0.6923076923076923, 0.5034155374565581}, \
{0.801923076923077, 0.5153202993613198}], 
          RectangleBox[{0.8076923076923077, 0.5153202993613198}, \
{0.9173076923076924, 0.5272250612660818}], 
          RectangleBox[{0.9230769230769231, 0.5272250612660818}, \
{1.0326923076923078`, 0.5391298231708438}], 
          RectangleBox[{1.0384615384615385`, 0.5391298231708438}, \
{1.148076923076923, 0.5510345850756055}], 
          RectangleBox[{1.1538461538461537`, 0.5510345850756055}, \
{1.2634615384615384`, 0.5629393469803675}], 
          RectangleBox[{1.2692307692307692`, 0.5629393469803675}, \
{1.3788461538461538`, 0.5748441088851295}], 
          RectangleBox[{1.3846153846153846`, 0.5748441088851295}, \
{1.4942307692307693`, 0.5867488707898912}]},
         Antialiasing->True]},
       AspectRatio->NCache[
         Rational[6, 35], 0.17142857142857143`],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0.75],
       FrameTicks->False,
       PlotRange->All,
       PlotRangePadding->{Automatic, 0.05}], {180, -35}, 
      ImageScaled[{0.5, 0.5}], {350, 60},
      Background->GrayLevel[0.9]], InsetBox[
      GraphicsBox[
       {GrayLevel[0.6], RectangleBox[{0, 0}]},
       AspectRatio->NCache[
         Rational[6, 35], 0.17142857142857143`],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0.75],
       FrameTicks->False], {180, -100}, ImageScaled[{0.5, 0.5}], {350, 60},
      Background->GrayLevel[0.9]]}, InsetBox[
     StyleBox[
      InterpretationBox[
       InterpretationBox[
        RowBox[{"\<\"1.5\"\>", "\[InvisibleSpace]", "\<\" s\"\>"}],
        Row[{"1.5", " s"}]],
       Row[{
         Row[{"1.5", " s"}]}, 
        Style[" | ", FontSize -> 14, FontColor -> GrayLevel[0.75]]]], 
      "DialogStyle",
      StripOnInput->False], {355, -159}, Scaled[{1, 0}]], 
    TagBox[
     TooltipBox[
      TagBox[{
        {GrayLevel[0.9], RectangleBox[{5, -158}, {29, -135}]}, 
        {GrayLevel[0.3], 
         PolygonBox[
          NCache[{{13, -153}, {13, -140}, {21, Rational[-293, 2]}, {
            13, -153}}, {{13, -153}, {13, -140}, {21, -146.5}, {
            13, -153}}]]}, 
        {GrayLevel[0.5], 
         StyleBox[
          LineBox[{{5, -158}, {5, -135}, {29, -135}, {29, -158}, {5, -158}}],
          Antialiasing->False]}},
       EventHandlerTag[{"MouseClicked" :> (If[Sound`MIDISequence[{
               Sound`MIDITrack[{
                 Sound`MIDIEvent[0, "SetTempo", "Tempo" -> 1000000], 
                 Sound`MIDIEvent[
                 0, "ProgramCommand", "Channel" -> 0, "Value" -> 0], 
                 Sound`MIDIEvent[
                 0, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 3, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 3, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 6, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 6, "NoteOn", "Note" -> 62, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 9, "NoteOff", "Note" -> 62, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 9, "NoteOn", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 12, "NoteOff", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 12, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 15, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 15, "NoteOn", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 18, "NoteOff", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 18, "NoteOn", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 21, "NoteOff", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 21, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 24, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 24, "NoteOn", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 27, "NoteOff", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 27, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 30, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 30, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 33, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 33, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 36, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 36, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 39, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0]}]}, "DivisionType" -> "PPQ", "Resolution" -> 26] =!= 
            None, 
            Sound`EmitMIDI[
             Sound`MIDISequence[{
               Sound`MIDITrack[{
                 Sound`MIDIEvent[0, "SetTempo", "Tempo" -> 1000000], 
                 Sound`MIDIEvent[
                 0, "ProgramCommand", "Channel" -> 0, "Value" -> 0], 
                 Sound`MIDIEvent[
                 0, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 3, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 3, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 6, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 6, "NoteOn", "Note" -> 62, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 9, "NoteOff", "Note" -> 62, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 9, "NoteOn", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 12, "NoteOff", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 12, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 15, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 15, "NoteOn", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 18, "NoteOff", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 18, "NoteOn", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 21, "NoteOff", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 21, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 24, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 24, "NoteOn", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 27, "NoteOff", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 27, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 30, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 30, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 33, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 33, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 36, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 36, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 39, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0]}]}, "DivisionType" -> "PPQ", "Resolution" -> 26]]]; 
          Sound`SoundDump`emitSoundThroughFE[None, "Preemptive"]), 
         PassEventsDown -> Automatic, PassEventsUp -> True}]],
      "\"Play\""],
     Annotation[#, "Play", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[{
        {GrayLevel[0.9], RectangleBox[{34, -158}, {58, -135}]}, 
        {GrayLevel[0.3], RectangleBox[{42, -150}, {50, -143}]}, 
        {GrayLevel[0.5], 
         StyleBox[
          LineBox[{{34, -158}, {34, -135}, {58, -135}, {58, -158}, {
           34, -158}}],
          Antialiasing->False]}},
       EventHandlerTag[{
        "MouseClicked" :> (Sound`SoundDump`emitSoundThroughFE[
            SampledSoundList[{{0.}}, 8000], "Preemptive"]; 
          Sound`MIDIDump`stopMIDI[]), PassEventsDown -> Automatic, 
         PassEventsUp -> True}]],
      "\"Stop\""],
     Annotation[#, "Stop", "Tooltip"]& ], 
    {GrayLevel[0.75], 
     StyleBox[LineBox[{{0, 0}, {360, 0}, {360, -164}, {0, -164}, {0, 0}}],
      Antialiasing->False]}},
   ContentSelectable->False,
   ImageSize->250,
   PlotRange->{{0, 360}, {0, -164}},
   PlotRangePadding->1],
  Sound[{
    SoundNote[0], 
    SoundNote[1], 
    SoundNote[2], 
    SoundNote[3], 
    SoundNote[4], 
    SoundNote[5], 
    SoundNote[6], 
    SoundNote[7], 
    SoundNote[8], 
    SoundNote[9], 
    SoundNote[10], 
    SoundNote[11], 
    SoundNote[12]}, 1.5]]], "Output",
 ImageSize->{254, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->362507717]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->290937765],

Cell[TextData[{
 "Represent a sequence of notes to be played between ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "=", "0"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "=", "1.5"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->322053937],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s1", "=", 
  RowBox[{"Sound", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"SoundNote", "[", "i", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "0", ",", "12"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1.5"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->470538796],

Cell[BoxData[
 InterpretationBox[
  GraphicsBox[{
    {GrayLevel[0.9], RectangleBox[{0, 0}, {360, -164}]}, {InsetBox[
      GraphicsBox[
       {RGBColor[0.5, 0, 0.5], 
        StyleBox[{
          RectangleBox[{0., 0.43198696602798653`}, \
{0.10961538461538461`, 0.4438917279327484}], 
          RectangleBox[{0.11538461538461539`, 0.4438917279327484}, \
{0.225, 0.45579648983751037`}], 
          RectangleBox[{0.23076923076923078`, 0.45579648983751037`}, \
{0.3403846153846154, 0.4677012517422721}], 
          RectangleBox[{0.34615384615384615`, 0.4677012517422721}, \
{0.4557692307692308, 0.4796060136470343}], 
          RectangleBox[{0.46153846153846156`, 0.4796060136470343}, \
{0.5711538461538461, 0.49151077555179606`}], 
          RectangleBox[{0.5769230769230769, 0.49151077555179606`}, \
{0.6865384615384615, 0.5034155374565581}], 
          RectangleBox[{0.6923076923076923, 0.5034155374565581}, \
{0.801923076923077, 0.5153202993613198}], 
          RectangleBox[{0.8076923076923077, 0.5153202993613198}, \
{0.9173076923076924, 0.5272250612660818}], 
          RectangleBox[{0.9230769230769231, 0.5272250612660818}, \
{1.0326923076923078`, 0.5391298231708438}], 
          RectangleBox[{1.0384615384615385`, 0.5391298231708438}, \
{1.148076923076923, 0.5510345850756055}], 
          RectangleBox[{1.1538461538461537`, 0.5510345850756055}, \
{1.2634615384615384`, 0.5629393469803675}], 
          RectangleBox[{1.2692307692307692`, 0.5629393469803675}, \
{1.3788461538461538`, 0.5748441088851295}], 
          RectangleBox[{1.3846153846153846`, 0.5748441088851295}, \
{1.4942307692307693`, 0.5867488707898912}]},
         Antialiasing->True]},
       AspectRatio->NCache[
         Rational[6, 35], 0.17142857142857143`],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0.75],
       FrameTicks->False,
       PlotRange->All,
       PlotRangePadding->{Automatic, 0.05}], {180, -35}, 
      ImageScaled[{0.5, 0.5}], {350, 60},
      Background->GrayLevel[0.9]], InsetBox[
      GraphicsBox[
       {GrayLevel[0.6], RectangleBox[{0, 0}]},
       AspectRatio->NCache[
         Rational[6, 35], 0.17142857142857143`],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0.75],
       FrameTicks->False], {180, -100}, ImageScaled[{0.5, 0.5}], {350, 60},
      Background->GrayLevel[0.9]]}, InsetBox[
     StyleBox[
      InterpretationBox[
       InterpretationBox[
        RowBox[{"\<\"1.5\"\>", "\[InvisibleSpace]", "\<\" s\"\>"}],
        Row[{"1.5", " s"}]],
       Row[{
         Row[{"1.5", " s"}]}, 
        Style[" | ", FontSize -> 14, FontColor -> GrayLevel[0.75]]]], 
      "DialogStyle",
      StripOnInput->False], {355, -159}, Scaled[{1, 0}]], 
    TagBox[
     TooltipBox[
      TagBox[{
        {GrayLevel[0.9], RectangleBox[{5, -158}, {29, -135}]}, 
        {GrayLevel[0.3], 
         PolygonBox[
          NCache[{{13, -153}, {13, -140}, {21, Rational[-293, 2]}, {
            13, -153}}, {{13, -153}, {13, -140}, {21, -146.5}, {
            13, -153}}]]}, 
        {GrayLevel[0.5], 
         StyleBox[
          LineBox[{{5, -158}, {5, -135}, {29, -135}, {29, -158}, {5, -158}}],
          Antialiasing->False]}},
       EventHandlerTag[{"MouseClicked" :> (If[Sound`MIDISequence[{
               Sound`MIDITrack[{
                 Sound`MIDIEvent[0, "SetTempo", "Tempo" -> 1000000], 
                 Sound`MIDIEvent[
                 0, "ProgramCommand", "Channel" -> 0, "Value" -> 0], 
                 Sound`MIDIEvent[
                 0, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 3, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 3, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 6, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 6, "NoteOn", "Note" -> 62, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 9, "NoteOff", "Note" -> 62, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 9, "NoteOn", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 12, "NoteOff", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 12, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 15, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 15, "NoteOn", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 18, "NoteOff", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 18, "NoteOn", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 21, "NoteOff", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 21, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 24, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 24, "NoteOn", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 27, "NoteOff", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 27, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 30, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 30, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 33, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 33, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 36, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 36, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 39, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0]}]}, "DivisionType" -> "PPQ", "Resolution" -> 26] =!= 
            None, 
            Sound`EmitMIDI[
             Sound`MIDISequence[{
               Sound`MIDITrack[{
                 Sound`MIDIEvent[0, "SetTempo", "Tempo" -> 1000000], 
                 Sound`MIDIEvent[
                 0, "ProgramCommand", "Channel" -> 0, "Value" -> 0], 
                 Sound`MIDIEvent[
                 0, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 3, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 3, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 6, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 6, "NoteOn", "Note" -> 62, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 9, "NoteOff", "Note" -> 62, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 9, "NoteOn", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 12, "NoteOff", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 12, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 15, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 15, "NoteOn", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 18, "NoteOff", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 18, "NoteOn", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 21, "NoteOff", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 21, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 24, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 24, "NoteOn", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 27, "NoteOff", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 27, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 30, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 30, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 33, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 33, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 36, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 36, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 39, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0]}]}, "DivisionType" -> "PPQ", "Resolution" -> 26]]]; 
          Sound`SoundDump`emitSoundThroughFE[None, "Preemptive"]), 
         PassEventsDown -> Automatic, PassEventsUp -> True}]],
      "\"Play\""],
     Annotation[#, "Play", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[{
        {GrayLevel[0.9], RectangleBox[{34, -158}, {58, -135}]}, 
        {GrayLevel[0.3], RectangleBox[{42, -150}, {50, -143}]}, 
        {GrayLevel[0.5], 
         StyleBox[
          LineBox[{{34, -158}, {34, -135}, {58, -135}, {58, -158}, {
           34, -158}}],
          Antialiasing->False]}},
       EventHandlerTag[{
        "MouseClicked" :> (Sound`SoundDump`emitSoundThroughFE[
            SampledSoundList[{{0.}}, 8000], "Preemptive"]; 
          Sound`MIDIDump`stopMIDI[]), PassEventsDown -> Automatic, 
         PassEventsUp -> True}]],
      "\"Stop\""],
     Annotation[#, "Stop", "Tooltip"]& ], 
    {GrayLevel[0.75], 
     StyleBox[LineBox[{{0, 0}, {360, 0}, {360, -164}, {0, -164}, {0, 0}}],
      Antialiasing->False]}},
   ContentSelectable->False,
   ImageSize->250,
   PlotRange->{{0, 360}, {0, -164}},
   PlotRangePadding->1],
  Sound[{
    SoundNote[0], 
    SoundNote[1], 
    SoundNote[2], 
    SoundNote[3], 
    SoundNote[4], 
    SoundNote[5], 
    SoundNote[6], 
    SoundNote[7], 
    SoundNote[8], 
    SoundNote[9], 
    SoundNote[10], 
    SoundNote[11], 
    SoundNote[12]}, {0, 1.5}]]], "Output",
 ImageSize->{254, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->148472537]
}, Open  ]],

Cell[TextData[{
 "Represent a sequence of notes to be played between ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "=", "0.5"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "=", "2"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->206191853],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s2", "=", 
  RowBox[{"Sound", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"SoundNote", "[", 
       RowBox[{"12", "-", "i"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "0", ",", "12"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.5", ",", "2"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14219607],

Cell[BoxData[
 InterpretationBox[
  GraphicsBox[{
    {GrayLevel[0.9], RectangleBox[{0, 0}, {360, -164}]}, {InsetBox[
      GraphicsBox[
       {RGBColor[0.5, 0, 0.5], 
        StyleBox[{
          RectangleBox[{1.8846153846153846`, 0.43198696602798653`}, \
{1.9942307692307693`, 0.4438917279327484}], 
          RectangleBox[{1.7692307692307692`, 0.4438917279327484}, \
{1.8788461538461538`, 0.45579648983751037`}], 
          RectangleBox[{1.6538461538461537`, 0.45579648983751037`}, \
{1.7634615384615384`, 0.4677012517422721}], 
          RectangleBox[{1.5384615384615385`, 0.4677012517422721}, \
{1.648076923076923, 0.4796060136470343}], 
          RectangleBox[{1.4230769230769231`, 0.4796060136470343}, \
{1.5326923076923078`, 0.49151077555179606`}], 
          RectangleBox[{1.3076923076923077`, 0.49151077555179606`}, \
{1.4173076923076924`, 0.5034155374565581}], 
          RectangleBox[{1.1923076923076923`, 0.5034155374565581}, \
{1.301923076923077, 0.5153202993613198}], 
          RectangleBox[{1.0769230769230769`, 0.5153202993613198}, \
{1.1865384615384615`, 0.5272250612660818}], 
          RectangleBox[{0.9615384615384616, 0.5272250612660818}, \
{1.0711538461538461`, 0.5391298231708438}], 
          RectangleBox[{0.8461538461538461, 0.5391298231708438}, \
{0.9557692307692308, 0.5510345850756055}], 
          RectangleBox[{0.7307692307692307, 0.5510345850756055}, \
{0.8403846153846154, 0.5629393469803675}], 
          RectangleBox[{0.6153846153846154, 0.5629393469803675}, \
{0.725, 0.5748441088851295}], 
          RectangleBox[{0.5, 0.5748441088851295}, \
{0.6096153846153847, 0.5867488707898912}]},
         Antialiasing->True]},
       AspectRatio->NCache[
         Rational[6, 35], 0.17142857142857143`],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0.75],
       FrameTicks->False,
       PlotRange->All,
       PlotRangePadding->{Automatic, 0.05}], {180, -35}, 
      ImageScaled[{0.5, 0.5}], {350, 60},
      Background->GrayLevel[0.9]], InsetBox[
      GraphicsBox[
       {GrayLevel[0.6], RectangleBox[{0, 0}]},
       AspectRatio->NCache[
         Rational[6, 35], 0.17142857142857143`],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0.75],
       FrameTicks->False], {180, -100}, ImageScaled[{0.5, 0.5}], {350, 60},
      Background->GrayLevel[0.9]]}, InsetBox[
     StyleBox[
      InterpretationBox[
       InterpretationBox[
        RowBox[{"2", "\[InvisibleSpace]", "\<\" s\"\>"}],
        Row[{2, " s"}]],
       Row[{
         Row[{2, " s"}]}, 
        Style[" | ", FontSize -> 14, FontColor -> GrayLevel[0.75]]]], 
      "DialogStyle",
      StripOnInput->False], {355, -159}, Scaled[{1, 0}]], 
    TagBox[
     TooltipBox[
      TagBox[{
        {GrayLevel[0.9], RectangleBox[{5, -158}, {29, -135}]}, 
        {GrayLevel[0.3], 
         PolygonBox[
          NCache[{{13, -153}, {13, -140}, {21, Rational[-293, 2]}, {
            13, -153}}, {{13, -153}, {13, -140}, {21, -146.5}, {
            13, -153}}]]}, 
        {GrayLevel[0.5], 
         StyleBox[
          LineBox[{{5, -158}, {5, -135}, {29, -135}, {29, -158}, {5, -158}}],
          Antialiasing->False]}},
       EventHandlerTag[{"MouseClicked" :> (If[Sound`MIDISequence[{
               Sound`MIDITrack[{
                 Sound`MIDIEvent[0, "SetTempo", "Tempo" -> 1000000], 
                 Sound`MIDIEvent[
                 0, "ProgramCommand", "Channel" -> 0, "Value" -> 0], 
                 Sound`MIDIEvent[
                 13, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 16, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 16, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 19, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 19, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 22, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 22, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 25, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 25, "NoteOn", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 28, "NoteOff", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 28, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 31, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 31, "NoteOn", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 34, "NoteOff", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 34, "NoteOn", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 37, "NoteOff", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 37, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 40, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 40, "NoteOn", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 43, "NoteOff", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 43, "NoteOn", "Note" -> 62, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 46, "NoteOff", "Note" -> 62, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 46, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 49, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 49, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 52, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  0]}]}, "DivisionType" -> "PPQ", "Resolution" -> 26] =!= 
            None, 
            Sound`EmitMIDI[
             Sound`MIDISequence[{
               Sound`MIDITrack[{
                 Sound`MIDIEvent[0, "SetTempo", "Tempo" -> 1000000], 
                 Sound`MIDIEvent[
                 0, "ProgramCommand", "Channel" -> 0, "Value" -> 0], 
                 Sound`MIDIEvent[
                 13, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 16, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 16, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 19, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 19, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 22, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 22, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 25, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 25, "NoteOn", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 28, "NoteOff", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 28, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 31, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 31, "NoteOn", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 34, "NoteOff", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 34, "NoteOn", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 37, "NoteOff", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 37, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 40, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 40, "NoteOn", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 43, "NoteOff", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 43, "NoteOn", "Note" -> 62, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 46, "NoteOff", "Note" -> 62, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 46, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 49, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 49, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 52, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  0]}]}, "DivisionType" -> "PPQ", "Resolution" -> 26]]]; 
          Sound`SoundDump`emitSoundThroughFE[None, "Preemptive"]), 
         PassEventsDown -> Automatic, PassEventsUp -> True}]],
      "\"Play\""],
     Annotation[#, "Play", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[{
        {GrayLevel[0.9], RectangleBox[{34, -158}, {58, -135}]}, 
        {GrayLevel[0.3], RectangleBox[{42, -150}, {50, -143}]}, 
        {GrayLevel[0.5], 
         StyleBox[
          LineBox[{{34, -158}, {34, -135}, {58, -135}, {58, -158}, {
           34, -158}}],
          Antialiasing->False]}},
       EventHandlerTag[{
        "MouseClicked" :> (Sound`SoundDump`emitSoundThroughFE[
            SampledSoundList[{{0.}}, 8000], "Preemptive"]; 
          Sound`MIDIDump`stopMIDI[]), PassEventsDown -> Automatic, 
         PassEventsUp -> True}]],
      "\"Stop\""],
     Annotation[#, "Stop", "Tooltip"]& ], 
    {GrayLevel[0.75], 
     StyleBox[LineBox[{{0, 0}, {360, 0}, {360, -164}, {0, -164}, {0, 0}}],
      Antialiasing->False]}},
   ContentSelectable->False,
   ImageSize->250,
   PlotRange->{{0, 360}, {0, -164}},
   PlotRangePadding->1],
  Sound[{
    SoundNote[12], 
    SoundNote[11], 
    SoundNote[10], 
    SoundNote[9], 
    SoundNote[8], 
    SoundNote[7], 
    SoundNote[6], 
    SoundNote[5], 
    SoundNote[4], 
    SoundNote[3], 
    SoundNote[2], 
    SoundNote[1], 
    SoundNote[0]}, {0.5, 2}]]], "Output",
 ImageSize->{254, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->668400225]
}, Open  ]],

Cell["Combine the two sound sequences:", "ExampleText",
 CellID->96455145],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sound", "[", 
  RowBox[{"{", 
   RowBox[{"s1", ",", "s2"}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->745203679],

Cell[BoxData[
 InterpretationBox[
  GraphicsBox[{
    {GrayLevel[0.9], RectangleBox[{0, 0}, {360, -164}]}, {InsetBox[
      GraphicsBox[
       {RGBColor[0.5, 0, 0.5], 
        StyleBox[{
          RectangleBox[{0., 0.43198696602798653`}, \
{0.10961538461538461`, 0.4438917279327484}], 
          RectangleBox[{1.8846153846153846`, 0.43198696602798653`}, \
{1.9942307692307693`, 0.4438917279327484}], 
          RectangleBox[{0.11538461538461539`, 0.4438917279327484}, \
{0.225, 0.45579648983751037`}], 
          RectangleBox[{1.7692307692307692`, 0.4438917279327484}, \
{1.8788461538461538`, 0.45579648983751037`}], 
          RectangleBox[{0.23076923076923078`, 0.45579648983751037`}, \
{0.3403846153846154, 0.4677012517422721}], 
          RectangleBox[{1.6538461538461537`, 0.45579648983751037`}, \
{1.7634615384615384`, 0.4677012517422721}], 
          RectangleBox[{0.34615384615384615`, 0.4677012517422721}, \
{0.4557692307692308, 0.4796060136470343}], 
          RectangleBox[{1.5384615384615385`, 0.4677012517422721}, \
{1.648076923076923, 0.4796060136470343}], 
          RectangleBox[{0.46153846153846156`, 0.4796060136470343}, \
{0.5711538461538461, 0.49151077555179606`}], 
          RectangleBox[{1.4230769230769231`, 0.4796060136470343}, \
{1.5326923076923078`, 0.49151077555179606`}], 
          RectangleBox[{0.5769230769230769, 0.49151077555179606`}, \
{0.6865384615384615, 0.5034155374565581}], 
          RectangleBox[{1.3076923076923077`, 0.49151077555179606`}, \
{1.4173076923076924`, 0.5034155374565581}], 
          RectangleBox[{0.6923076923076923, 0.5034155374565581}, \
{0.801923076923077, 0.5153202993613198}], 
          RectangleBox[{1.1923076923076923`, 0.5034155374565581}, \
{1.301923076923077, 0.5153202993613198}], 
          RectangleBox[{0.8076923076923077, 0.5153202993613198}, \
{0.9173076923076924, 0.5272250612660818}], 
          RectangleBox[{1.0769230769230769`, 0.5153202993613198}, \
{1.1865384615384615`, 0.5272250612660818}], 
          RectangleBox[{0.9230769230769231, 0.5272250612660818}, \
{1.0326923076923078`, 0.5391298231708438}], 
          
          RectangleBox[{0.9615384615384616, 0.5272250612660818}, \
{1.0711538461538461`, 0.5391298231708438}], 
          RectangleBox[{0.8461538461538461, 0.5391298231708438}, \
{0.9557692307692308, 0.5510345850756055}], 
          RectangleBox[{1.0384615384615385`, 0.5391298231708438}, \
{1.148076923076923, 0.5510345850756055}], 
          RectangleBox[{0.7307692307692307, 0.5510345850756055}, \
{0.8403846153846154, 0.5629393469803675}], 
          RectangleBox[{1.1538461538461537`, 0.5510345850756055}, \
{1.2634615384615384`, 0.5629393469803675}], 
          RectangleBox[{0.6153846153846154, 0.5629393469803675}, \
{0.725, 0.5748441088851295}], 
          RectangleBox[{1.2692307692307692`, 0.5629393469803675}, \
{1.3788461538461538`, 0.5748441088851295}], 
          RectangleBox[{0.5, 0.5748441088851295}, \
{0.6096153846153847, 0.5867488707898912}], 
          RectangleBox[{1.3846153846153846`, 0.5748441088851295}, \
{1.4942307692307693`, 0.5867488707898912}]},
         Antialiasing->True]},
       AspectRatio->NCache[
         Rational[6, 35], 0.17142857142857143`],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0.75],
       FrameTicks->False,
       PlotRange->All,
       PlotRangePadding->{Automatic, 0.05}], {180, -35}, 
      ImageScaled[{0.5, 0.5}], {350, 60},
      Background->GrayLevel[0.9]], InsetBox[
      GraphicsBox[
       {GrayLevel[0.6], RectangleBox[{0, 0}]},
       AspectRatio->NCache[
         Rational[6, 35], 0.17142857142857143`],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0.75],
       FrameTicks->False], {180, -100}, ImageScaled[{0.5, 0.5}], {350, 60},
      Background->GrayLevel[0.9]]}, InsetBox[
     StyleBox[
      InterpretationBox[
       InterpretationBox[
        RowBox[{"2", "\[InvisibleSpace]", "\<\" s\"\>"}],
        Row[{2, " s"}]],
       Row[{
         Row[{2, " s"}]}, 
        Style[" | ", FontSize -> 14, FontColor -> GrayLevel[0.75]]]], 
      "DialogStyle",
      StripOnInput->False], {355, -159}, Scaled[{1, 0}]], 
    TagBox[
     TooltipBox[
      TagBox[{
        {GrayLevel[0.9], RectangleBox[{5, -158}, {29, -135}]}, 
        {GrayLevel[0.3], 
         PolygonBox[
          NCache[{{13, -153}, {13, -140}, {21, Rational[-293, 2]}, {
            13, -153}}, {{13, -153}, {13, -140}, {21, -146.5}, {
            13, -153}}]]}, 
        {GrayLevel[0.5], 
         StyleBox[
          LineBox[{{5, -158}, {5, -135}, {29, -135}, {29, -158}, {5, -158}}],
          Antialiasing->False]}},
       EventHandlerTag[{"MouseClicked" :> (If[Sound`MIDISequence[{
               Sound`MIDITrack[{
                 Sound`MIDIEvent[0, "SetTempo", "Tempo" -> 1000000], 
                 Sound`MIDIEvent[
                 0, "ProgramCommand", "Channel" -> 0, "Value" -> 0], 
                 Sound`MIDIEvent[
                 0, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 3, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 3, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 6, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 6, "NoteOn", "Note" -> 62, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 9, "NoteOff", "Note" -> 62, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 9, "NoteOn", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 12, "NoteOff", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 12, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 13, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 15, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 15, "NoteOn", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 16, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 16, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 18, "NoteOff", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 18, "NoteOn", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 19, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 19, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 21, "NoteOff", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 21, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 22, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 22, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 24, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 24, "NoteOn", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 25, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 25, "NoteOn", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 27, "NoteOff", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 27, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 28, "NoteOff", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 28, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 30, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 30, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 31, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 31, "NoteOn", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 33, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 33, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 34, "NoteOff", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 34, "NoteOn", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 36, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 36, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 37, "NoteOff", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 37, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 39, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 40, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 40, "NoteOn", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 43, "NoteOff", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 43, "NoteOn", "Note" -> 62, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 46, "NoteOff", "Note" -> 62, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 46, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 49, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 49, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 52, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  0]}]}, "DivisionType" -> "PPQ", "Resolution" -> 26] =!= 
            None, 
            Sound`EmitMIDI[
             Sound`MIDISequence[{
               Sound`MIDITrack[{
                 Sound`MIDIEvent[0, "SetTempo", "Tempo" -> 1000000], 
                 Sound`MIDIEvent[
                 0, "ProgramCommand", "Channel" -> 0, "Value" -> 0], 
                 Sound`MIDIEvent[
                 0, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 3, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 3, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 6, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 6, "NoteOn", "Note" -> 62, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 9, "NoteOff", "Note" -> 62, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 9, "NoteOn", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 12, "NoteOff", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 12, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 13, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 15, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 15, "NoteOn", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 16, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 16, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 18, "NoteOff", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 18, "NoteOn", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 19, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 19, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 21, "NoteOff", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 21, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 22, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 22, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 24, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 24, "NoteOn", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 25, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 25, "NoteOn", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 27, "NoteOff", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 27, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 28, "NoteOff", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 28, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 30, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 30, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 31, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 31, "NoteOn", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 33, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 33, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 34, "NoteOff", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 34, "NoteOn", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 36, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 36, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 37, "NoteOff", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 37, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 39, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 40, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 40, "NoteOn", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 43, "NoteOff", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 43, "NoteOn", "Note" -> 62, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 46, "NoteOff", "Note" -> 62, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 46, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 49, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 49, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 52, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  0]}]}, "DivisionType" -> "PPQ", "Resolution" -> 26]]]; 
          Sound`SoundDump`emitSoundThroughFE[None, "Preemptive"]), 
         PassEventsDown -> Automatic, PassEventsUp -> True}]],
      "\"Play\""],
     Annotation[#, "Play", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[{
        {GrayLevel[0.9], RectangleBox[{34, -158}, {58, -135}]}, 
        {GrayLevel[0.3], RectangleBox[{42, -150}, {50, -143}]}, 
        {GrayLevel[0.5], 
         StyleBox[
          LineBox[{{34, -158}, {34, -135}, {58, -135}, {58, -158}, {
           34, -158}}],
          Antialiasing->False]}},
       EventHandlerTag[{
        "MouseClicked" :> (Sound`SoundDump`emitSoundThroughFE[
            SampledSoundList[{{0.}}, 8000], "Preemptive"]; 
          Sound`MIDIDump`stopMIDI[]), PassEventsDown -> Automatic, 
         PassEventsUp -> True}]],
      "\"Stop\""],
     Annotation[#, "Stop", "Tooltip"]& ], 
    {GrayLevel[0.75], 
     StyleBox[LineBox[{{0, 0}, {360, 0}, {360, -164}, {0, -164}, {0, 0}}],
      Antialiasing->False]}},
   ContentSelectable->False,
   ImageSize->250,
   PlotRange->{{0, 360}, {0, -164}},
   PlotRangePadding->1],
  Sound[{
    Sound[{
      SoundNote[0], 
      SoundNote[1], 
      SoundNote[2], 
      SoundNote[3], 
      SoundNote[4], 
      SoundNote[5], 
      SoundNote[6], 
      SoundNote[7], 
      SoundNote[8], 
      SoundNote[9], 
      SoundNote[10], 
      SoundNote[11], 
      SoundNote[12]}, {0, 1.5}], 
    Sound[{
      SoundNote[12], 
      SoundNote[11], 
      SoundNote[10], 
      SoundNote[9], 
      SoundNote[8], 
      SoundNote[7], 
      SoundNote[6], 
      SoundNote[5], 
      SoundNote[4], 
      SoundNote[3], 
      SoundNote[2], 
      SoundNote[1], 
      SoundNote[0]}, {0.5, 2}]}]]], "Output",
 ImageSize->{254, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->324819169]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1741996],

Cell["Superimpose three time-warped versions of a sound:", "ExampleText",
 CellID->188121737],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{"Sound", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"SoundNote", "[", "i", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "0", ",", "12"}], "}"}]}], "]"}], ",", "1"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->242511346],

Cell[BoxData[
 InterpretationBox[
  GraphicsBox[{
    {GrayLevel[0.9], RectangleBox[{0, 0}, {360, -164}]}, {InsetBox[
      GraphicsBox[
       {RGBColor[0.5, 0, 0.5], 
        StyleBox[{
          RectangleBox[{0., 0.43198696602798653`}, \
{0.07307692307692308, 0.4438917279327484}], 
          RectangleBox[{0.07692307692307693, 0.4438917279327484}, \
{0.15000000000000002`, 0.45579648983751037`}], 
          RectangleBox[{0.15384615384615385`, 0.45579648983751037`}, \
{0.22692307692307695`, 0.4677012517422721}], 
          RectangleBox[{0.23076923076923078`, 0.4677012517422721}, \
{0.3038461538461539, 0.4796060136470343}], 
          RectangleBox[{0.3076923076923077, 0.4796060136470343}, \
{0.3807692307692308, 0.49151077555179606`}], 
          RectangleBox[{0.38461538461538464`, 0.49151077555179606`}, \
{0.45769230769230773`, 0.5034155374565581}], 
          RectangleBox[{0.46153846153846156`, 0.5034155374565581}, \
{0.5346153846153846, 0.5153202993613198}], 
          RectangleBox[{0.5384615384615384, 0.5153202993613198}, \
{0.6115384615384616, 0.5272250612660818}], 
          RectangleBox[{0.6153846153846154, 0.5272250612660818}, \
{0.6884615384615385, 0.5391298231708438}], 
          RectangleBox[{0.6923076923076923, 0.5391298231708438}, \
{0.7653846153846154, 0.5510345850756055}], 
          RectangleBox[{0.7692307692307693, 0.5510345850756055}, \
{0.8423076923076923, 0.5629393469803675}], 
          RectangleBox[{0.8461538461538461, 0.5629393469803675}, \
{0.9192307692307693, 0.5748441088851295}], 
          RectangleBox[{0.9230769230769231, 0.5748441088851295}, \
{0.9961538461538462, 0.5867488707898912}]},
         Antialiasing->True]},
       AspectRatio->NCache[
         Rational[6, 35], 0.17142857142857143`],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0.75],
       FrameTicks->False,
       PlotRange->All,
       PlotRangePadding->{Automatic, 0.05}], {180, -35}, 
      ImageScaled[{0.5, 0.5}], {350, 60},
      Background->GrayLevel[0.9]], InsetBox[
      GraphicsBox[
       {GrayLevel[0.6], RectangleBox[{0, 0}]},
       AspectRatio->NCache[
         Rational[6, 35], 0.17142857142857143`],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0.75],
       FrameTicks->False], {180, -100}, ImageScaled[{0.5, 0.5}], {350, 60},
      Background->GrayLevel[0.9]]}, InsetBox[
     StyleBox[
      InterpretationBox[
       InterpretationBox[
        RowBox[{"1", "\[InvisibleSpace]", "\<\" s\"\>"}],
        Row[{1, " s"}]],
       Row[{
         Row[{1, " s"}]}, 
        Style[" | ", FontSize -> 14, FontColor -> GrayLevel[0.75]]]], 
      "DialogStyle",
      StripOnInput->False], {355, -159}, Scaled[{1, 0}]], 
    TagBox[
     TooltipBox[
      TagBox[{
        {GrayLevel[0.9], RectangleBox[{5, -158}, {29, -135}]}, 
        {GrayLevel[0.3], 
         PolygonBox[
          NCache[{{13, -153}, {13, -140}, {21, Rational[-293, 2]}, {
            13, -153}}, {{13, -153}, {13, -140}, {21, -146.5}, {
            13, -153}}]]}, 
        {GrayLevel[0.5], 
         StyleBox[
          LineBox[{{5, -158}, {5, -135}, {29, -135}, {29, -158}, {5, -158}}],
          Antialiasing->False]}},
       EventHandlerTag[{"MouseClicked" :> (If[Sound`MIDISequence[{
               Sound`MIDITrack[{
                 Sound`MIDIEvent[0, "SetTempo", "Tempo" -> 1000000], 
                 Sound`MIDIEvent[
                 0, "ProgramCommand", "Channel" -> 0, "Value" -> 0], 
                 Sound`MIDIEvent[
                 0, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 1, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 1, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 2, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 2, "NoteOn", "Note" -> 62, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 3, "NoteOff", "Note" -> 62, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 3, "NoteOn", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 4, "NoteOff", "Note" -> 63, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 4, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 5, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 5, "NoteOn", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 6, "NoteOff", "Note" -> 65, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 6, "NoteOn", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 7, "NoteOff", "Note" -> 66, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 7, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 8, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 8, "NoteOn", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 9, "NoteOff", "Note" -> 68, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 9, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 10, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 10, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 11, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 11, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 12, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 12, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 13, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0]}]}, "DivisionType" -> "PPQ", "Resolution" -> 13] =!= 
            None, 
            Sound`EmitMIDI[
             Sound`MIDISequence[{
               Sound`MIDITrack[{
                 Sound`MIDIEvent[0, "SetTempo", "Tempo" -> 1000000], 
                 Sound`MIDIEvent[
                 0, "ProgramCommand", "Channel" -> 0, "Value" -> 0], 
                 Sound`MIDIEvent[
                 0, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 1, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 1, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 2, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 2, "NoteOn", "Note" -> 62, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 3, "NoteOff", "Note" -> 62, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 3, "NoteOn", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 4, "NoteOff", "Note" -> 63, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 4, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 5, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 5, "NoteOn", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 6, "NoteOff", "Note" -> 65, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 6, "NoteOn", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 7, "NoteOff", "Note" -> 66, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 7, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 8, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 8, "NoteOn", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 9, "NoteOff", "Note" -> 68, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 9, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 10, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 10, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 11, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 11, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 12, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 12, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 13, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0]}]}, "DivisionType" -> "PPQ", "Resolution" -> 13]]]; 
          Sound`SoundDump`emitSoundThroughFE[None, "Preemptive"]), 
         PassEventsDown -> Automatic, PassEventsUp -> True}]],
      "\"Play\""],
     Annotation[#, "Play", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[{
        {GrayLevel[0.9], RectangleBox[{34, -158}, {58, -135}]}, 
        {GrayLevel[0.3], RectangleBox[{42, -150}, {50, -143}]}, 
        {GrayLevel[0.5], 
         StyleBox[
          LineBox[{{34, -158}, {34, -135}, {58, -135}, {58, -158}, {
           34, -158}}],
          Antialiasing->False]}},
       EventHandlerTag[{
        "MouseClicked" :> (Sound`SoundDump`emitSoundThroughFE[
            SampledSoundList[{{0.}}, 8000], "Preemptive"]; 
          Sound`MIDIDump`stopMIDI[]), PassEventsDown -> Automatic, 
         PassEventsUp -> True}]],
      "\"Stop\""],
     Annotation[#, "Stop", "Tooltip"]& ], 
    {GrayLevel[0.75], 
     StyleBox[LineBox[{{0, 0}, {360, 0}, {360, -164}, {0, -164}, {0, 0}}],
      Antialiasing->False]}},
   ContentSelectable->False,
   ImageSize->250,
   PlotRange->{{0, 360}, {0, -164}},
   PlotRangePadding->1],
  Sound[{
    SoundNote[0], 
    SoundNote[1], 
    SoundNote[2], 
    SoundNote[3], 
    SoundNote[4], 
    SoundNote[5], 
    SoundNote[6], 
    SoundNote[7], 
    SoundNote[8], 
    SoundNote[9], 
    SoundNote[10], 
    SoundNote[11], 
    SoundNote[12]}, 1]]], "Output",
 ImageSize->{254, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->164391567]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sound", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Sound", "[", 
     RowBox[{"s", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "2"}], "}"}]}], "]"}], ",", 
    RowBox[{"Sound", "[", 
     RowBox[{"s", ",", 
      RowBox[{"{", 
       RowBox[{".5", ",", "1.5"}], "}"}]}], "]"}], ",", 
    RowBox[{"Sound", "[", 
     RowBox[{"s", ",", 
      RowBox[{"{", 
       RowBox[{".7", ",", ".9"}], "}"}]}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->149732189],

Cell[BoxData[
 InterpretationBox[
  GraphicsBox[{
    {GrayLevel[0.9], RectangleBox[{0, 0}, {360, -164}]}, {InsetBox[
      GraphicsBox[
       {RGBColor[0.5, 0, 0.5], 
        StyleBox[{
          RectangleBox[{0., 0.43198696602798653`}, \
{0.14615384615384616`, 0.4438917279327484}], 
          RectangleBox[{0.5, 0.43198696602798653`}, \
{0.573076923076923, 0.4438917279327484}], 
          RectangleBox[{0.7, 0.43198696602798653`}, \
{0.7146153846153847, 0.4438917279327484}], 
          RectangleBox[{0.15384615384615385`, 0.4438917279327484}, \
{0.30000000000000004`, 0.45579648983751037`}], 
          RectangleBox[{0.5769230769230769, 0.4438917279327484}, \
{0.65, 0.45579648983751037`}], 
          RectangleBox[{0.7153846153846154, 0.4438917279327484}, \
{0.73, 0.45579648983751037`}], 
          RectangleBox[{0.3076923076923077, 0.45579648983751037`}, \
{0.4538461538461539, 0.4677012517422721}], 
          RectangleBox[{0.6538461538461539, 0.45579648983751037`}, \
{0.7269230769230769, 0.4677012517422721}], 
          RectangleBox[{0.7307692307692307, 0.45579648983751037`}, \
{0.7453846153846154, 0.4677012517422721}], 
          RectangleBox[{0.46153846153846156`, 0.4677012517422721}, \
{0.6076923076923078, 0.4796060136470343}], 
          RectangleBox[{0.7307692307692307, 0.4677012517422721}, \
{0.76, 0.4796060136470343}], 
          RectangleBox[{0.7461538461538462, 0.4677012517422721}, \
{0.8046153846153846, 0.4796060136470343}], 
          RectangleBox[{0.6153846153846154, 0.4796060136470343}, \
{0.7615384615384616, 0.49151077555179606`}], 
          RectangleBox[{0.7615384615384615, 0.4796060136470343}, \
{0.7761538461538462, 0.49151077555179606`}], 
          RectangleBox[{0.8076923076923077, 0.4796060136470343}, \
{0.8807692307692307, 0.49151077555179606`}], 
          RectangleBox[{0.7692307692307693, 0.49151077555179606`}, \
{0.7911538461538461, 0.5034155374565581}], 
          RectangleBox[{0.7769230769230769, 0.49151077555179606`}, \
{0.9157692307692308, 0.5034155374565581}], 
          RectangleBox[{0.8846153846153846, 0.49151077555179606`}, \
{0.9576923076923077, 0.5034155374565581}], 
          RectangleBox[{0.7923076923076923, 0.5034155374565581}, \
{0.806923076923077, 0.5153202993613198}], 
          RectangleBox[{0.9230769230769231, 0.5034155374565581}, \
{1.0326923076923078`, 0.5153202993613198}], 
          RectangleBox[{0.9615384615384616, 0.5034155374565581}, \
{1.0711538461538461`, 0.5153202993613198}], 
          RectangleBox[{0.8076923076923077, 0.5153202993613198}, \
{0.8223076923076923, 0.5272250612660818}], 
          RectangleBox[{1.0384615384615385`, 0.5153202993613198}, \
{1.1115384615384616`, 0.5272250612660818}], 
          RectangleBox[{1.0769230769230769`, 0.5153202993613198}, \
{1.2230769230769232`, 0.5272250612660818}], 
          RectangleBox[{0.823076923076923, 0.5272250612660818}, \
{0.8376923076923077, 0.5391298231708438}], 
          RectangleBox[{1.1153846153846154`, 0.5272250612660818}, \
{1.1884615384615385`, 0.5391298231708438}], 
          RectangleBox[{1.2307692307692308`, 0.5272250612660818}, \
{1.376923076923077, 0.5391298231708438}], 
          RectangleBox[{0.8384615384615385, 0.5391298231708438}, \
{0.8530769230769231, 0.5510345850756055}], 
          RectangleBox[{1.1923076923076923`, 0.5391298231708438}, \
{1.2653846153846153`, 0.5510345850756055}], 
          RectangleBox[{1.3846153846153846`, 0.5391298231708438}, \
{1.5307692307692309`, 0.5510345850756055}], 
          RectangleBox[{0.8538461538461538, 0.5510345850756055}, \
{0.8684615384615385, 0.5629393469803675}], 
          RectangleBox[{1.2692307692307692`, 0.5510345850756055}, \
{1.3423076923076924`, 0.5629393469803675}], 
          RectangleBox[{1.5384615384615385`, 0.5510345850756055}, \
{1.6846153846153846`, 0.5629393469803675}], 
          RectangleBox[{0.8692307692307693, 0.5629393469803675}, \
{0.8838461538461538, 0.5748441088851295}], 
          RectangleBox[{1.3461538461538463`, 0.5629393469803675}, \
{1.4192307692307693`, 0.5748441088851295}], 
          RectangleBox[{1.6923076923076923`, 0.5629393469803675}, \
{1.8384615384615386`, 0.5748441088851295}], 
          RectangleBox[{0.8846153846153846, 0.5748441088851295}, \
{0.8992307692307693, 0.5867488707898912}], 
          RectangleBox[{1.4230769230769231`, 0.5748441088851295}, \
{1.4961538461538462`, 0.5867488707898912}], 
          RectangleBox[{1.8461538461538463`, 0.5748441088851295}, \
{1.9923076923076923`, 0.5867488707898912}]},
         Antialiasing->True]},
       AspectRatio->NCache[
         Rational[6, 35], 0.17142857142857143`],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0.75],
       FrameTicks->False,
       PlotRange->All,
       PlotRangePadding->{Automatic, 0.05}], {180, -35}, 
      ImageScaled[{0.5, 0.5}], {350, 60},
      Background->GrayLevel[0.9]], InsetBox[
      GraphicsBox[
       {GrayLevel[0.6], RectangleBox[{0, 0}]},
       AspectRatio->NCache[
         Rational[6, 35], 0.17142857142857143`],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0.75],
       FrameTicks->False], {180, -100}, ImageScaled[{0.5, 0.5}], {350, 60},
      Background->GrayLevel[0.9]]}, InsetBox[
     StyleBox[
      InterpretationBox[
       InterpretationBox[
        RowBox[{"2", "\[InvisibleSpace]", "\<\" s\"\>"}],
        Row[{2, " s"}]],
       Row[{
         Row[{2, " s"}]}, 
        Style[" | ", FontSize -> 14, FontColor -> GrayLevel[0.75]]]], 
      "DialogStyle",
      StripOnInput->False], {355, -159}, Scaled[{1, 0}]], 
    TagBox[
     TooltipBox[
      TagBox[{
        {GrayLevel[0.9], RectangleBox[{5, -158}, {29, -135}]}, 
        {GrayLevel[0.3], 
         PolygonBox[
          NCache[{{13, -153}, {13, -140}, {21, Rational[-293, 2]}, {
            13, -153}}, {{13, -153}, {13, -140}, {21, -146.5}, {
            13, -153}}]]}, 
        {GrayLevel[0.5], 
         StyleBox[
          LineBox[{{5, -158}, {5, -135}, {29, -135}, {29, -158}, {5, -158}}],
          Antialiasing->False]}},
       EventHandlerTag[{"MouseClicked" :> (If[Sound`MIDISequence[{
               Sound`MIDITrack[{
                 Sound`MIDIEvent[0, "SetTempo", "Tempo" -> 1000000], 
                 Sound`MIDIEvent[
                 0, "ProgramCommand", "Channel" -> 0, "Value" -> 0], 
                 Sound`MIDIEvent[
                 0, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 20, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 20, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 40, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 40, "NoteOn", "Note" -> 62, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 60, "NoteOff", "Note" -> 62, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 60, "NoteOn", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 65, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 75, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 75, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 80, "NoteOff", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 80, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 85, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 85, "NoteOn", "Note" -> 62, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 91, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 93, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 93, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 95, "NoteOff", "Note" -> 62, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 95, "NoteOn", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 95, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 95, "NoteOn", "Note" -> 62, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 97, "NoteOff", "Note" -> 62, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 97, "NoteOn", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 99, "NoteOff", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 99, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 100, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 100, "NoteOn", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 101, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 101, "NoteOn", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 103, "NoteOff", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 103, "NoteOn", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 105, "NoteOff", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 105, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 105, "NoteOff", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 105, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 107, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 107, "NoteOn", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 109, "NoteOff", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 109, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 111, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 111, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 113, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 113, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 115, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 115, "NoteOn", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 115, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 115, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 117, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 120, "NoteOff", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 120, "NoteOn", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 125, "NoteOff", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 125, "NoteOn", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 135, "NoteOff", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 135, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 140, "NoteOff", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 140, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 145, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 145, "NoteOn", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 155, "NoteOff", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 155, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 160, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 160, "NoteOn", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 165, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 165, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 175, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 175, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 180, "NoteOff", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 180, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 185, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 185, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 195, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 200, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 200, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 220, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 220, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 240, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 240, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 260, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0]}]}, "DivisionType" -> "PPQ", "Resolution" -> 130] =!= 
            None, 
            Sound`EmitMIDI[
             Sound`MIDISequence[{
               Sound`MIDITrack[{
                 Sound`MIDIEvent[0, "SetTempo", "Tempo" -> 1000000], 
                 Sound`MIDIEvent[
                 0, "ProgramCommand", "Channel" -> 0, "Value" -> 0], 
                 Sound`MIDIEvent[
                 0, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 20, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 20, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 40, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 40, "NoteOn", "Note" -> 62, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 60, "NoteOff", "Note" -> 62, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 60, "NoteOn", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 65, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 75, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 75, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 80, "NoteOff", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 80, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 85, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 85, "NoteOn", "Note" -> 62, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 91, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 93, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 93, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 95, "NoteOff", "Note" -> 62, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 95, "NoteOn", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 95, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 95, "NoteOn", "Note" -> 62, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 97, "NoteOff", "Note" -> 62, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 97, "NoteOn", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 99, "NoteOff", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 99, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 100, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 100, "NoteOn", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 101, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 101, "NoteOn", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 103, "NoteOff", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 103, "NoteOn", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 105, "NoteOff", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 105, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 105, "NoteOff", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 105, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 107, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 107, "NoteOn", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 109, "NoteOff", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 109, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 111, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 111, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 113, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 113, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 115, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 115, "NoteOn", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 115, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 115, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 117, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 120, "NoteOff", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 120, "NoteOn", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 125, "NoteOff", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 125, "NoteOn", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 135, "NoteOff", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 135, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 140, "NoteOff", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 140, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 145, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 145, "NoteOn", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 155, "NoteOff", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 155, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 160, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 160, "NoteOn", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 165, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 165, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 175, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 175, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 180, "NoteOff", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 180, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 185, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 185, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 195, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 200, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 200, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 220, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 220, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 240, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 240, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 260, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0]}]}, "DivisionType" -> "PPQ", "Resolution" -> 130]]]; 
          Sound`SoundDump`emitSoundThroughFE[None, "Preemptive"]), 
         PassEventsDown -> Automatic, PassEventsUp -> True}]],
      "\"Play\""],
     Annotation[#, "Play", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[{
        {GrayLevel[0.9], RectangleBox[{34, -158}, {58, -135}]}, 
        {GrayLevel[0.3], RectangleBox[{42, -150}, {50, -143}]}, 
        {GrayLevel[0.5], 
         StyleBox[
          LineBox[{{34, -158}, {34, -135}, {58, -135}, {58, -158}, {
           34, -158}}],
          Antialiasing->False]}},
       EventHandlerTag[{
        "MouseClicked" :> (Sound`SoundDump`emitSoundThroughFE[
            SampledSoundList[{{0.}}, 8000], "Preemptive"]; 
          Sound`MIDIDump`stopMIDI[]), PassEventsDown -> Automatic, 
         PassEventsUp -> True}]],
      "\"Stop\""],
     Annotation[#, "Stop", "Tooltip"]& ], 
    {GrayLevel[0.75], 
     StyleBox[LineBox[{{0, 0}, {360, 0}, {360, -164}, {0, -164}, {0, 0}}],
      Antialiasing->False]}},
   ContentSelectable->False,
   ImageSize->250,
   PlotRange->{{0, 360}, {0, -164}},
   PlotRangePadding->1],
  Sound[{
    Sound[
     Sound[{
       SoundNote[0], 
       SoundNote[1], 
       SoundNote[2], 
       SoundNote[3], 
       SoundNote[4], 
       SoundNote[5], 
       SoundNote[6], 
       SoundNote[7], 
       SoundNote[8], 
       SoundNote[9], 
       SoundNote[10], 
       SoundNote[11], 
       SoundNote[12]}, 1], {0, 2}], 
    Sound[
     Sound[{
       SoundNote[0], 
       SoundNote[1], 
       SoundNote[2], 
       SoundNote[3], 
       SoundNote[4], 
       SoundNote[5], 
       SoundNote[6], 
       SoundNote[7], 
       SoundNote[8], 
       SoundNote[9], 
       SoundNote[10], 
       SoundNote[11], 
       SoundNote[12]}, 1], {0.5, 1.5}], 
    Sound[
     Sound[{
       SoundNote[0], 
       SoundNote[1], 
       SoundNote[2], 
       SoundNote[3], 
       SoundNote[4], 
       SoundNote[5], 
       SoundNote[6], 
       SoundNote[7], 
       SoundNote[8], 
       SoundNote[9], 
       SoundNote[10], 
       SoundNote[11], 
       SoundNote[12]}, 1], {0.7, 0.9}]}]]], "Output",
 ImageSize->{254, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->137988045]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Style Directives",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->74874445],

Cell["\<\
Represent a sequence of notes to be rendered in accordion style:\
\>", "ExampleText",
 CellID->73262262],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sound", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<Accordion\>\"", ",", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"SoundNote", "[", "i", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "5"}], "}"}]}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->279095819],

Cell[BoxData[
 InterpretationBox[
  GraphicsBox[{
    {GrayLevel[0.9], RectangleBox[{0, 0}, {360, -164}]}, {InsetBox[
      GraphicsBox[
       {Hue[0.1943075285030702, 0.9, 0.7], 
        StyleBox[{
          RectangleBox[{0., 0.4438917279327484}, \
{0.95, 0.45579648983751037`}], 
          RectangleBox[{1., 0.45579648983751037`}, \
{1.95, 0.4677012517422721}], 
          RectangleBox[{2., 0.4677012517422721}, {2.95, 0.4796060136470343}], 
          RectangleBox[{3., 0.4796060136470343}, \
{3.95, 0.49151077555179606`}], 
          RectangleBox[{4., 0.49151077555179606`}, \
{4.95, 0.5034155374565581}]},
         Antialiasing->True]},
       AspectRatio->NCache[
         Rational[6, 35], 0.17142857142857143`],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0.75],
       FrameTicks->False,
       PlotRange->All,
       PlotRangePadding->{Automatic, 0.05}], {180, -35}, 
      ImageScaled[{0.5, 0.5}], {350, 60},
      Background->GrayLevel[0.9]], InsetBox[
      GraphicsBox[
       {GrayLevel[0.6], RectangleBox[{0, 0}]},
       AspectRatio->NCache[
         Rational[6, 35], 0.17142857142857143`],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0.75],
       FrameTicks->False], {180, -100}, ImageScaled[{0.5, 0.5}], {350, 60},
      Background->GrayLevel[0.9]]}, InsetBox[
     StyleBox[
      InterpretationBox[
       InterpretationBox[
        RowBox[{"5", "\[InvisibleSpace]", "\<\" s\"\>"}],
        Row[{5, " s"}]],
       Row[{
         Row[{5, " s"}]}, 
        Style[" | ", FontSize -> 14, FontColor -> GrayLevel[0.75]]]], 
      "DialogStyle",
      StripOnInput->False], {355, -159}, Scaled[{1, 0}]], 
    TagBox[
     TooltipBox[
      TagBox[{
        {GrayLevel[0.9], RectangleBox[{5, -158}, {29, -135}]}, 
        {GrayLevel[0.3], 
         PolygonBox[
          NCache[{{13, -153}, {13, -140}, {21, Rational[-293, 2]}, {
            13, -153}}, {{13, -153}, {13, -140}, {21, -146.5}, {
            13, -153}}]]}, 
        {GrayLevel[0.5], 
         StyleBox[
          LineBox[{{5, -158}, {5, -135}, {29, -135}, {29, -158}, {5, -158}}],
          Antialiasing->False]}},
       EventHandlerTag[{"MouseClicked" :> (If[Sound`MIDISequence[{
               Sound`MIDITrack[{
                 Sound`MIDIEvent[0, "SetTempo", "Tempo" -> 1000000], 
                 Sound`MIDIEvent[
                 0, "ProgramCommand", "Channel" -> 0, "Value" -> 21], 
                 Sound`MIDIEvent[
                 0, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 1, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 1, "NoteOn", "Note" -> 62, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 2, "NoteOff", "Note" -> 62, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 2, "NoteOn", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 3, "NoteOff", "Note" -> 63, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 3, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 4, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 4, "NoteOn", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 5, "NoteOff", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  0]}]}, "DivisionType" -> "PPQ", "Resolution" -> 1] =!= None,
             
            Sound`EmitMIDI[
             Sound`MIDISequence[{
               Sound`MIDITrack[{
                 Sound`MIDIEvent[0, "SetTempo", "Tempo" -> 1000000], 
                 Sound`MIDIEvent[
                 0, "ProgramCommand", "Channel" -> 0, "Value" -> 21], 
                 Sound`MIDIEvent[
                 0, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 1, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 1, "NoteOn", "Note" -> 62, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 2, "NoteOff", "Note" -> 62, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 2, "NoteOn", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 3, "NoteOff", "Note" -> 63, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 3, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 4, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 4, "NoteOn", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 5, "NoteOff", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  0]}]}, "DivisionType" -> "PPQ", "Resolution" -> 1]]]; 
          Sound`SoundDump`emitSoundThroughFE[None, "Preemptive"]), 
         PassEventsDown -> Automatic, PassEventsUp -> True}]],
      "\"Play\""],
     Annotation[#, "Play", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[{
        {GrayLevel[0.9], RectangleBox[{34, -158}, {58, -135}]}, 
        {GrayLevel[0.3], RectangleBox[{42, -150}, {50, -143}]}, 
        {GrayLevel[0.5], 
         StyleBox[
          LineBox[{{34, -158}, {34, -135}, {58, -135}, {58, -158}, {
           34, -158}}],
          Antialiasing->False]}},
       EventHandlerTag[{
        "MouseClicked" :> (Sound`SoundDump`emitSoundThroughFE[
            SampledSoundList[{{0.}}, 8000], "Preemptive"]; 
          Sound`MIDIDump`stopMIDI[]), PassEventsDown -> Automatic, 
         PassEventsUp -> True}]],
      "\"Stop\""],
     Annotation[#, "Stop", "Tooltip"]& ], 
    {GrayLevel[0.75], 
     StyleBox[LineBox[{{0, 0}, {360, 0}, {360, -164}, {0, -164}, {0, 0}}],
      Antialiasing->False]}},
   ContentSelectable->False,
   ImageSize->250,
   PlotRange->{{0, 360}, {0, -164}},
   PlotRangePadding->1],
  Sound[{"Accordion", {
     SoundNote[1], 
     SoundNote[2], 
     SoundNote[3], 
     SoundNote[4], 
     SoundNote[5]}}]]], "Output",
 ImageSize->{254, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->866700536]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->71812371],

Cell["Combine two note sequences with different instrument styles:", \
"ExampleText",
 CellID->86598890],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{"Sound", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"SoundNote", "[", "i", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "0", ",", "12"}], "}"}]}], "]"}], ",", "1"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->164316513],

Cell[BoxData[
 InterpretationBox[
  GraphicsBox[{
    {GrayLevel[0.9], RectangleBox[{0, 0}, {360, -164}]}, {InsetBox[
      GraphicsBox[
       {RGBColor[0.5, 0, 0.5], 
        StyleBox[{
          RectangleBox[{0., 0.43198696602798653`}, \
{0.07307692307692308, 0.4438917279327484}], 
          RectangleBox[{0.07692307692307693, 0.4438917279327484}, \
{0.15000000000000002`, 0.45579648983751037`}], 
          RectangleBox[{0.15384615384615385`, 0.45579648983751037`}, \
{0.22692307692307695`, 0.4677012517422721}], 
          RectangleBox[{0.23076923076923078`, 0.4677012517422721}, \
{0.3038461538461539, 0.4796060136470343}], 
          RectangleBox[{0.3076923076923077, 0.4796060136470343}, \
{0.3807692307692308, 0.49151077555179606`}], 
          RectangleBox[{0.38461538461538464`, 0.49151077555179606`}, \
{0.45769230769230773`, 0.5034155374565581}], 
          RectangleBox[{0.46153846153846156`, 0.5034155374565581}, \
{0.5346153846153846, 0.5153202993613198}], 
          RectangleBox[{0.5384615384615384, 0.5153202993613198}, \
{0.6115384615384616, 0.5272250612660818}], 
          RectangleBox[{0.6153846153846154, 0.5272250612660818}, \
{0.6884615384615385, 0.5391298231708438}], 
          RectangleBox[{0.6923076923076923, 0.5391298231708438}, \
{0.7653846153846154, 0.5510345850756055}], 
          RectangleBox[{0.7692307692307693, 0.5510345850756055}, \
{0.8423076923076923, 0.5629393469803675}], 
          RectangleBox[{0.8461538461538461, 0.5629393469803675}, \
{0.9192307692307693, 0.5748441088851295}], 
          RectangleBox[{0.9230769230769231, 0.5748441088851295}, \
{0.9961538461538462, 0.5867488707898912}]},
         Antialiasing->True]},
       AspectRatio->NCache[
         Rational[6, 35], 0.17142857142857143`],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0.75],
       FrameTicks->False,
       PlotRange->All,
       PlotRangePadding->{Automatic, 0.05}], {180, -35}, 
      ImageScaled[{0.5, 0.5}], {350, 60},
      Background->GrayLevel[0.9]], InsetBox[
      GraphicsBox[
       {GrayLevel[0.6], RectangleBox[{0, 0}]},
       AspectRatio->NCache[
         Rational[6, 35], 0.17142857142857143`],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0.75],
       FrameTicks->False], {180, -100}, ImageScaled[{0.5, 0.5}], {350, 60},
      Background->GrayLevel[0.9]]}, InsetBox[
     StyleBox[
      InterpretationBox[
       InterpretationBox[
        RowBox[{"1", "\[InvisibleSpace]", "\<\" s\"\>"}],
        Row[{1, " s"}]],
       Row[{
         Row[{1, " s"}]}, 
        Style[" | ", FontSize -> 14, FontColor -> GrayLevel[0.75]]]], 
      "DialogStyle",
      StripOnInput->False], {355, -159}, Scaled[{1, 0}]], 
    TagBox[
     TooltipBox[
      TagBox[{
        {GrayLevel[0.9], RectangleBox[{5, -158}, {29, -135}]}, 
        {GrayLevel[0.3], 
         PolygonBox[
          NCache[{{13, -153}, {13, -140}, {21, Rational[-293, 2]}, {
            13, -153}}, {{13, -153}, {13, -140}, {21, -146.5}, {
            13, -153}}]]}, 
        {GrayLevel[0.5], 
         StyleBox[
          LineBox[{{5, -158}, {5, -135}, {29, -135}, {29, -158}, {5, -158}}],
          Antialiasing->False]}},
       EventHandlerTag[{"MouseClicked" :> (If[Sound`MIDISequence[{
               Sound`MIDITrack[{
                 Sound`MIDIEvent[0, "SetTempo", "Tempo" -> 1000000], 
                 Sound`MIDIEvent[
                 0, "ProgramCommand", "Channel" -> 0, "Value" -> 0], 
                 Sound`MIDIEvent[
                 0, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 1, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 1, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 2, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 2, "NoteOn", "Note" -> 62, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 3, "NoteOff", "Note" -> 62, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 3, "NoteOn", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 4, "NoteOff", "Note" -> 63, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 4, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 5, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 5, "NoteOn", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 6, "NoteOff", "Note" -> 65, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 6, "NoteOn", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 7, "NoteOff", "Note" -> 66, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 7, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 8, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 8, "NoteOn", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 9, "NoteOff", "Note" -> 68, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 9, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 10, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 10, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 11, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 11, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 12, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 12, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 13, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0]}]}, "DivisionType" -> "PPQ", "Resolution" -> 13] =!= 
            None, 
            Sound`EmitMIDI[
             Sound`MIDISequence[{
               Sound`MIDITrack[{
                 Sound`MIDIEvent[0, "SetTempo", "Tempo" -> 1000000], 
                 Sound`MIDIEvent[
                 0, "ProgramCommand", "Channel" -> 0, "Value" -> 0], 
                 Sound`MIDIEvent[
                 0, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 1, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 1, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 2, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 2, "NoteOn", "Note" -> 62, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 3, "NoteOff", "Note" -> 62, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 3, "NoteOn", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 4, "NoteOff", "Note" -> 63, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 4, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 5, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 5, "NoteOn", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 6, "NoteOff", "Note" -> 65, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 6, "NoteOn", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 7, "NoteOff", "Note" -> 66, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 7, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 8, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 8, "NoteOn", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 9, "NoteOff", "Note" -> 68, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 9, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 10, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 10, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 11, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 11, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 12, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 12, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 13, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0]}]}, "DivisionType" -> "PPQ", "Resolution" -> 13]]]; 
          Sound`SoundDump`emitSoundThroughFE[None, "Preemptive"]), 
         PassEventsDown -> Automatic, PassEventsUp -> True}]],
      "\"Play\""],
     Annotation[#, "Play", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[{
        {GrayLevel[0.9], RectangleBox[{34, -158}, {58, -135}]}, 
        {GrayLevel[0.3], RectangleBox[{42, -150}, {50, -143}]}, 
        {GrayLevel[0.5], 
         StyleBox[
          LineBox[{{34, -158}, {34, -135}, {58, -135}, {58, -158}, {
           34, -158}}],
          Antialiasing->False]}},
       EventHandlerTag[{
        "MouseClicked" :> (Sound`SoundDump`emitSoundThroughFE[
            SampledSoundList[{{0.}}, 8000], "Preemptive"]; 
          Sound`MIDIDump`stopMIDI[]), PassEventsDown -> Automatic, 
         PassEventsUp -> True}]],
      "\"Stop\""],
     Annotation[#, "Stop", "Tooltip"]& ], 
    {GrayLevel[0.75], 
     StyleBox[LineBox[{{0, 0}, {360, 0}, {360, -164}, {0, -164}, {0, 0}}],
      Antialiasing->False]}},
   ContentSelectable->False,
   ImageSize->250,
   PlotRange->{{0, 360}, {0, -164}},
   PlotRangePadding->1],
  Sound[{
    SoundNote[0], 
    SoundNote[1], 
    SoundNote[2], 
    SoundNote[3], 
    SoundNote[4], 
    SoundNote[5], 
    SoundNote[6], 
    SoundNote[7], 
    SoundNote[8], 
    SoundNote[9], 
    SoundNote[10], 
    SoundNote[11], 
    SoundNote[12]}, 1]]], "Output",
 ImageSize->{254, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->500063338]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sound", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<Flute\>\"", ",", 
    RowBox[{"Sound", "[", 
     RowBox[{"s", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "]"}], ",", "\"\<Trumpet\>\"", ",", 
    RowBox[{"Sound", "[", 
     RowBox[{"s", ",", 
      RowBox[{"{", 
       RowBox[{".2", ",", "1.3"}], "}"}]}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->187993525],

Cell[BoxData[
 InterpretationBox[
  GraphicsBox[{
    {GrayLevel[0.9], RectangleBox[{0, 0}, {360, -164}]}, {InsetBox[
      GraphicsBox[{
        {Hue[0.0027707033834458716`, 0.9, 0.7], 
         StyleBox[{
           RectangleBox[{0.2, 0.43198696602798653`}, \
{0.2803846153846154, 0.4438917279327484}], 
           RectangleBox[{0.2846153846153846, 0.4438917279327484}, \
{0.365, 0.45579648983751037`}], 
           RectangleBox[{0.36923076923076925`, 0.45579648983751037`}, \
{0.44961538461538464`, 0.4677012517422721}], 
           RectangleBox[{0.45384615384615384`, 0.4677012517422721}, \
{0.5342307692307692, 0.4796060136470343}], 
           RectangleBox[{0.5384615384615384, 0.4796060136470343}, \
{0.6188461538461538, 0.49151077555179606`}], 
           RectangleBox[{0.6230769230769231, 0.49151077555179606`}, \
{0.7034615384615385, 0.5034155374565581}], 
           RectangleBox[{0.7076923076923077, 0.5034155374565581}, \
{0.788076923076923, 0.5153202993613198}], 
           RectangleBox[{0.7923076923076923, 0.5153202993613198}, \
{0.8726923076923077, 0.5272250612660818}], 
           RectangleBox[{0.8769230769230769, 0.5272250612660818}, \
{0.9573076923076923, 0.5391298231708438}], 
           RectangleBox[{0.9615384615384616, 0.5391298231708438}, \
{1.041923076923077, 0.5510345850756055}], 
           RectangleBox[{1.0461538461538462`, 0.5510345850756055}, \
{1.1265384615384615`, 0.5629393469803675}], 
           RectangleBox[{1.1307692307692307`, 0.5629393469803675}, \
{1.211153846153846, 0.5748441088851295}], 
           RectangleBox[{1.2153846153846153`, 0.5748441088851295}, \
{1.2957692307692308`, 0.5867488707898912}]},
          Antialiasing->True]}, 
        {Hue[-0.006832897388943049, 0.9, 0.7], 
         StyleBox[{
           RectangleBox[{0., 0.43198696602798653`}, \
{0.07307692307692308, 0.4438917279327484}], 
           RectangleBox[{0.07692307692307693, 0.4438917279327484}, \
{0.15000000000000002`, 0.45579648983751037`}], 
           RectangleBox[{0.15384615384615385`, 0.45579648983751037`}, \
{0.22692307692307695`, 0.4677012517422721}], 
           
           RectangleBox[{0.23076923076923078`, 0.4677012517422721}, \
{0.3038461538461539, 0.4796060136470343}], 
           RectangleBox[{0.3076923076923077, 0.4796060136470343}, \
{0.3807692307692308, 0.49151077555179606`}], 
           RectangleBox[{0.38461538461538464`, 0.49151077555179606`}, \
{0.45769230769230773`, 0.5034155374565581}], 
           RectangleBox[{0.46153846153846156`, 0.5034155374565581}, \
{0.5346153846153846, 0.5153202993613198}], 
           RectangleBox[{0.5384615384615384, 0.5153202993613198}, \
{0.6115384615384616, 0.5272250612660818}], 
           RectangleBox[{0.6153846153846154, 0.5272250612660818}, \
{0.6884615384615385, 0.5391298231708438}], 
           RectangleBox[{0.6923076923076923, 0.5391298231708438}, \
{0.7653846153846154, 0.5510345850756055}], 
           RectangleBox[{0.7692307692307693, 0.5510345850756055}, \
{0.8423076923076923, 0.5629393469803675}], 
           RectangleBox[{0.8461538461538461, 0.5629393469803675}, \
{0.9192307692307693, 0.5748441088851295}], 
           RectangleBox[{0.9230769230769231, 0.5748441088851295}, \
{0.9961538461538462, 0.5867488707898912}]},
          Antialiasing->True]}},
       AspectRatio->NCache[
         Rational[6, 35], 0.17142857142857143`],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0.75],
       FrameTicks->False,
       PlotRange->All,
       PlotRangePadding->{Automatic, 0.05}], {180, -35}, 
      ImageScaled[{0.5, 0.5}], {350, 60},
      Background->GrayLevel[0.9]], InsetBox[
      GraphicsBox[
       {GrayLevel[0.6], RectangleBox[{0, 0}]},
       AspectRatio->NCache[
         Rational[6, 35], 0.17142857142857143`],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0.75],
       FrameTicks->False], {180, -100}, ImageScaled[{0.5, 0.5}], {350, 60},
      Background->GrayLevel[0.9]]}, InsetBox[
     StyleBox[
      InterpretationBox[
       InterpretationBox[
        RowBox[{"\<\"1.3\"\>", "\[InvisibleSpace]", "\<\" s\"\>"}],
        Row[{"1.3", " s"}]],
       Row[{
         Row[{"1.3", " s"}]}, 
        Style[" | ", FontSize -> 14, FontColor -> GrayLevel[0.75]]]], 
      "DialogStyle",
      StripOnInput->False], {355, -159}, Scaled[{1, 0}]], 
    TagBox[
     TooltipBox[
      TagBox[{
        {GrayLevel[0.9], RectangleBox[{5, -158}, {29, -135}]}, 
        {GrayLevel[0.3], 
         PolygonBox[
          NCache[{{13, -153}, {13, -140}, {21, Rational[-293, 2]}, {
            13, -153}}, {{13, -153}, {13, -140}, {21, -146.5}, {
            13, -153}}]]}, 
        {GrayLevel[0.5], 
         StyleBox[
          LineBox[{{5, -158}, {5, -135}, {29, -135}, {29, -158}, {5, -158}}],
          Antialiasing->False]}},
       EventHandlerTag[{"MouseClicked" :> (If[Sound`MIDISequence[{
               Sound`MIDITrack[{
                 Sound`MIDIEvent[0, "SetTempo", "Tempo" -> 1000000], 
                 Sound`MIDIEvent[
                 0, "ProgramCommand", "Channel" -> 0, "Value" -> 56], 
                 Sound`MIDIEvent[
                 26, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 37, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 37, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 48, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 48, "NoteOn", "Note" -> 62, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 59, "NoteOff", "Note" -> 62, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 59, "NoteOn", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 70, "NoteOff", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 70, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 81, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 81, "NoteOn", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 92, "NoteOff", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 92, "NoteOn", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 103, "NoteOff", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 103, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 114, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 114, "NoteOn", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 125, "NoteOff", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 125, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 136, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 136, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 147, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 147, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 158, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 158, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 169, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0]}], 
               Sound`MIDITrack[{
                 Sound`MIDIEvent[0, "SetTempo", "Tempo" -> 1000000], 
                 Sound`MIDIEvent[
                 0, "ProgramCommand", "Channel" -> 1, "Value" -> 73], 
                 Sound`MIDIEvent[
                 0, "NoteOn", "Note" -> 60, "Channel" -> 1, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 10, "NoteOff", "Note" -> 60, "Channel" -> 1, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 10, "NoteOn", "Note" -> 61, "Channel" -> 1, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 20, "NoteOff", "Note" -> 61, "Channel" -> 1, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 20, "NoteOn", "Note" -> 62, "Channel" -> 1, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 30, "NoteOff", "Note" -> 62, "Channel" -> 1, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 30, "NoteOn", "Note" -> 63, "Channel" -> 1, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 40, "NoteOff", "Note" -> 63, "Channel" -> 1, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 40, "NoteOn", "Note" -> 64, "Channel" -> 1, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 50, "NoteOff", "Note" -> 64, "Channel" -> 1, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 50, "NoteOn", "Note" -> 65, "Channel" -> 1, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 60, "NoteOff", "Note" -> 65, "Channel" -> 1, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 60, "NoteOn", "Note" -> 66, "Channel" -> 1, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 70, "NoteOff", "Note" -> 66, "Channel" -> 1, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 70, "NoteOn", "Note" -> 67, "Channel" -> 1, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 80, "NoteOff", "Note" -> 67, "Channel" -> 1, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 80, "NoteOn", "Note" -> 68, "Channel" -> 1, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 90, "NoteOff", "Note" -> 68, "Channel" -> 1, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 90, "NoteOn", "Note" -> 69, "Channel" -> 1, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 100, "NoteOff", "Note" -> 69, "Channel" -> 1, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 100, "NoteOn", "Note" -> 70, "Channel" -> 1, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 110, "NoteOff", "Note" -> 70, "Channel" -> 1, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 110, "NoteOn", "Note" -> 71, "Channel" -> 1, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 120, "NoteOff", "Note" -> 71, "Channel" -> 1, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 120, "NoteOn", "Note" -> 72, "Channel" -> 1, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 130, "NoteOff", "Note" -> 72, "Channel" -> 1, "Velocity" -> 
                  0]}]}, "DivisionType" -> "PPQ", "Resolution" -> 130] =!= 
            None, 
            Sound`EmitMIDI[
             Sound`MIDISequence[{
               Sound`MIDITrack[{
                 Sound`MIDIEvent[0, "SetTempo", "Tempo" -> 1000000], 
                 Sound`MIDIEvent[
                 0, "ProgramCommand", "Channel" -> 0, "Value" -> 56], 
                 Sound`MIDIEvent[
                 26, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 37, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 37, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 48, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 48, "NoteOn", "Note" -> 62, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 59, "NoteOff", "Note" -> 62, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 59, "NoteOn", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 70, "NoteOff", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 70, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 81, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 81, "NoteOn", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 92, "NoteOff", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 92, "NoteOn", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 103, "NoteOff", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 103, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 114, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 114, "NoteOn", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 125, "NoteOff", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 125, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 136, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 136, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 147, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 147, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 158, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 158, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 169, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0]}], 
               Sound`MIDITrack[{
                 Sound`MIDIEvent[0, "SetTempo", "Tempo" -> 1000000], 
                 Sound`MIDIEvent[
                 0, "ProgramCommand", "Channel" -> 1, "Value" -> 73], 
                 Sound`MIDIEvent[
                 0, "NoteOn", "Note" -> 60, "Channel" -> 1, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 10, "NoteOff", "Note" -> 60, "Channel" -> 1, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 10, "NoteOn", "Note" -> 61, "Channel" -> 1, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 20, "NoteOff", "Note" -> 61, "Channel" -> 1, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 20, "NoteOn", "Note" -> 62, "Channel" -> 1, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 30, "NoteOff", "Note" -> 62, "Channel" -> 1, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 30, "NoteOn", "Note" -> 63, "Channel" -> 1, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 40, "NoteOff", "Note" -> 63, "Channel" -> 1, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 40, "NoteOn", "Note" -> 64, "Channel" -> 1, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 50, "NoteOff", "Note" -> 64, "Channel" -> 1, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 50, "NoteOn", "Note" -> 65, "Channel" -> 1, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 60, "NoteOff", "Note" -> 65, "Channel" -> 1, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 60, "NoteOn", "Note" -> 66, "Channel" -> 1, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 70, "NoteOff", "Note" -> 66, "Channel" -> 1, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 70, "NoteOn", "Note" -> 67, "Channel" -> 1, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 80, "NoteOff", "Note" -> 67, "Channel" -> 1, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 80, "NoteOn", "Note" -> 68, "Channel" -> 1, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 90, "NoteOff", "Note" -> 68, "Channel" -> 1, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 90, "NoteOn", "Note" -> 69, "Channel" -> 1, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 100, "NoteOff", "Note" -> 69, "Channel" -> 1, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 100, "NoteOn", "Note" -> 70, "Channel" -> 1, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 110, "NoteOff", "Note" -> 70, "Channel" -> 1, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 110, "NoteOn", "Note" -> 71, "Channel" -> 1, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 120, "NoteOff", "Note" -> 71, "Channel" -> 1, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 120, "NoteOn", "Note" -> 72, "Channel" -> 1, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 130, "NoteOff", "Note" -> 72, "Channel" -> 1, "Velocity" -> 
                  0]}]}, "DivisionType" -> "PPQ", "Resolution" -> 130]]]; 
          Sound`SoundDump`emitSoundThroughFE[None, "Preemptive"]), 
         PassEventsDown -> Automatic, PassEventsUp -> True}]],
      "\"Play\""],
     Annotation[#, "Play", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[{
        {GrayLevel[0.9], RectangleBox[{34, -158}, {58, -135}]}, 
        {GrayLevel[0.3], RectangleBox[{42, -150}, {50, -143}]}, 
        {GrayLevel[0.5], 
         StyleBox[
          LineBox[{{34, -158}, {34, -135}, {58, -135}, {58, -158}, {
           34, -158}}],
          Antialiasing->False]}},
       EventHandlerTag[{
        "MouseClicked" :> (Sound`SoundDump`emitSoundThroughFE[
            SampledSoundList[{{0.}}, 8000], "Preemptive"]; 
          Sound`MIDIDump`stopMIDI[]), PassEventsDown -> Automatic, 
         PassEventsUp -> True}]],
      "\"Stop\""],
     Annotation[#, "Stop", "Tooltip"]& ], 
    {GrayLevel[0.75], 
     StyleBox[LineBox[{{0, 0}, {360, 0}, {360, -164}, {0, -164}, {0, 0}}],
      Antialiasing->False]}},
   ContentSelectable->False,
   ImageSize->250,
   PlotRange->{{0, 360}, {0, -164}},
   PlotRangePadding->1],
  Sound[{"Flute", 
    Sound[
     Sound[{
       SoundNote[0], 
       SoundNote[1], 
       SoundNote[2], 
       SoundNote[3], 
       SoundNote[4], 
       SoundNote[5], 
       SoundNote[6], 
       SoundNote[7], 
       SoundNote[8], 
       SoundNote[9], 
       SoundNote[10], 
       SoundNote[11], 
       SoundNote[12]}, 1], {0, 1}], "Trumpet", 
    Sound[
     Sound[{
       SoundNote[0], 
       SoundNote[1], 
       SoundNote[2], 
       SoundNote[3], 
       SoundNote[4], 
       SoundNote[5], 
       SoundNote[6], 
       SoundNote[7], 
       SoundNote[8], 
       SoundNote[9], 
       SoundNote[10], 
       SoundNote[11], 
       SoundNote[12]}, 1], {0.2, 1.3}]}]]], "Output",
 ImageSize->{254, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->24372948]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22410],

Cell["\<\
Create an algorithmic composition from a cellular automaton pattern:\
\>", "ExampleText",
 CellID->87667414],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sound", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"SoundNote", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"DeleteCases", "[", 
        RowBox[{
         RowBox[{"3", " ", 
          RowBox[{"Range", "[", "21", "]"}], 
          RowBox[{"Reverse", "[", "#", "]"}]}], ",", "0"}], "]"}], "-", 
       "24"}], ",", ".1"}], "]"}], "&"}], "/@", 
   RowBox[{"Transpose", "[", 
    RowBox[{"CellularAutomaton", "[", 
     RowBox[{"90", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", "20"}], "]"}], 
    "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->75500746],

Cell[BoxData[
 InterpretationBox[
  GraphicsBox[{
    {GrayLevel[0.9], RectangleBox[{0, 0}, {360, -164}]}, {InsetBox[
      GraphicsBox[
       {RGBColor[0.5, 0, 0.5], 
        StyleBox[{
          RectangleBox[{0., 0.18198696602798659`}, \
{0.095, 0.19389172793274845`}], 
          RectangleBox[{0.8, 0.18198696602798659`}, \
{0.895, 0.19389172793274845`}], 
          RectangleBox[{3.2, 0.18198696602798659`}, \
{3.295, 0.19389172793274845`}], 
          RectangleBox[{4., 0.18198696602798659`}, \
{4.095, 0.19389172793274845`}], 
          RectangleBox[{0.1, 0.2177012517422722}, \
{0.195, 0.22960601364703406`}], 
          RectangleBox[{0.3, 0.2177012517422722}, \
{0.395, 0.22960601364703406`}], 
          RectangleBox[{0.5, 0.2177012517422722}, \
{0.595, 0.22960601364703406`}], 
          RectangleBox[{0.7, 0.2177012517422722}, \
{0.795, 0.22960601364703406`}], 
          RectangleBox[{3.3, 0.2177012517422722}, \
{3.395, 0.22960601364703406`}], 
          RectangleBox[{3.5, 0.2177012517422722}, \
{3.595, 0.22960601364703406`}], 
          RectangleBox[{3.7, 0.2177012517422722}, \
{3.795, 0.22960601364703406`}], 
          RectangleBox[{3.9, 0.2177012517422722}, \
{3.995, 0.22960601364703406`}], 
          RectangleBox[{0.2, 0.25341553745655804`}, \
{0.295, 0.2653202993613199}], 
          RectangleBox[{0.6, 0.25341553745655804`}, \
{0.695, 0.2653202993613199}], 
          RectangleBox[{3.4, 0.25341553745655804`}, \
{3.495, 0.2653202993613199}], 
          RectangleBox[{3.8, 0.25341553745655804`}, \
{3.895, 0.2653202993613199}], 
          RectangleBox[{0.3, 0.2891298231708436}, \
{0.395, 0.3010345850756056}], 
          RectangleBox[{0.5, 0.2891298231708436}, \
{0.595, 0.3010345850756056}], 
          RectangleBox[{3.5, 0.2891298231708436}, \
{3.595, 0.3010345850756056}], 
          RectangleBox[{3.7, 0.2891298231708436}, \
{3.795, 0.3010345850756056}], 
          RectangleBox[{0.4, 0.3248441088851295}, \
{0.495, 0.33674887078989135`}], 
          RectangleBox[{3.6, 0.3248441088851295}, \
{3.6950000000000003`, 0.33674887078989135`}], 
          RectangleBox[{0.5, 0.3605583945994151}, \
{0.595, 0.37246315650417705`}], 
          
          RectangleBox[{0.7, 0.3605583945994151}, \
{0.795, 0.37246315650417705`}], 
          RectangleBox[{0.9, 0.3605583945994151}, \
{0.995, 0.37246315650417705`}], 
          RectangleBox[{1.1, 0.3605583945994151}, \
{1.195, 0.37246315650417705`}], 
          RectangleBox[{1.3, 0.3605583945994151}, \
{1.395, 0.37246315650417705`}], 
          RectangleBox[{1.5, 0.3605583945994151}, \
{1.5950000000000002`, 0.37246315650417705`}], 
          RectangleBox[{1.7, 0.3605583945994151}, \
{1.795, 0.37246315650417705`}], 
          RectangleBox[{1.9, 0.3605583945994151}, \
{1.995, 0.37246315650417705`}], 
          RectangleBox[{2.1, 0.3605583945994151}, \
{2.1950000000000003`, 0.37246315650417705`}], 
          RectangleBox[{2.3, 0.3605583945994151}, \
{2.395, 0.37246315650417705`}], 
          RectangleBox[{2.5, 0.3605583945994151}, \
{2.595, 0.37246315650417705`}], 
          RectangleBox[{2.7, 0.3605583945994151}, \
{2.795, 0.37246315650417705`}], 
          RectangleBox[{2.9, 0.3605583945994151}, \
{2.995, 0.37246315650417705`}], 
          RectangleBox[{3.1, 0.3605583945994151}, \
{3.1950000000000003`, 0.37246315650417705`}], 
          RectangleBox[{3.3, 0.3605583945994151}, \
{3.395, 0.37246315650417705`}], 
          RectangleBox[{3.5, 0.3605583945994151}, \
{3.595, 0.37246315650417705`}], 
          RectangleBox[{0.6, 0.3962726803137009}, \
{0.695, 0.40817744221846264`}], 
          RectangleBox[{1., 0.3962726803137009}, \
{1.0950000000000002`, 0.40817744221846264`}], 
          RectangleBox[{1.4, 0.3962726803137009}, \
{1.495, 0.40817744221846264`}], 
          RectangleBox[{1.8, 0.3962726803137009}, \
{1.895, 0.40817744221846264`}], 
          RectangleBox[{2.2, 0.3962726803137009}, \
{2.295, 0.40817744221846264`}], 
          RectangleBox[{2.6, 0.3962726803137009}, \
{2.6950000000000003`, 0.40817744221846264`}], 
          RectangleBox[{3., 0.3962726803137009}, \
{3.095, 0.40817744221846264`}], 
          RectangleBox[{3.4, 0.3962726803137009}, \
{3.495, 0.40817744221846264`}], 
          RectangleBox[{0.7, 0.43198696602798653`}, \
{0.795, 0.4438917279327484}], 
          RectangleBox[{0.9, 0.43198696602798653`}, \
{0.995, 0.4438917279327484}], 
          RectangleBox[{1.5, 0.43198696602798653`}, \
{1.5950000000000002`, 0.4438917279327484}], 
          RectangleBox[{1.7, 0.43198696602798653`}, \
{1.795, 0.4438917279327484}], 
          RectangleBox[{2.3, 0.43198696602798653`}, \
{2.395, 0.4438917279327484}], 
          RectangleBox[{2.5, 0.43198696602798653`}, \
{2.595, 0.4438917279327484}], 
          RectangleBox[{3.1, 0.43198696602798653`}, \
{3.1950000000000003`, 0.4438917279327484}], 
          RectangleBox[{3.3, 0.43198696602798653`}, \
{3.395, 0.4438917279327484}], 
          RectangleBox[{0.8, 0.4677012517422721}, \
{0.895, 0.4796060136470343}], 
          RectangleBox[{1.6, 0.4677012517422721}, \
{1.695, 0.4796060136470343}], 
          RectangleBox[{2.4, 0.4677012517422721}, \
{2.495, 0.4796060136470343}], 
          RectangleBox[{3.2, 0.4677012517422721}, \
{3.295, 0.4796060136470343}], 
          RectangleBox[{0.9, 0.5034155374565581}, \
{0.995, 0.5153202993613198}], 
          RectangleBox[{1.1, 0.5034155374565581}, \
{1.195, 0.5153202993613198}], 
          RectangleBox[{1.3, 0.5034155374565581}, \
{1.395, 0.5153202993613198}], 
          RectangleBox[{1.5, 0.5034155374565581}, \
{1.5950000000000002`, 0.5153202993613198}], 
          RectangleBox[{2.5, 0.5034155374565581}, \
{2.595, 0.5153202993613198}], 
          RectangleBox[{2.7, 0.5034155374565581}, \
{2.795, 0.5153202993613198}], 
          RectangleBox[{2.9, 0.5034155374565581}, \
{2.995, 0.5153202993613198}], 
          RectangleBox[{3.1, 0.5034155374565581}, \
{3.1950000000000003`, 0.5153202993613198}], 
          RectangleBox[{1., 0.5391298231708438}, \
{1.0950000000000002`, 0.5510345850756055}], 
          RectangleBox[{1.4, 0.5391298231708438}, \
{1.495, 0.5510345850756055}], 
          RectangleBox[{2.6, 0.5391298231708438}, \
{2.6950000000000003`, 0.5510345850756055}], 
          RectangleBox[{3., 0.5391298231708438}, {3.095, 0.5510345850756055}],
           RectangleBox[{1.1, 0.5748441088851295}, \
{1.195, 0.5867488707898912}], 
          RectangleBox[{1.3, 0.5748441088851295}, \
{1.395, 0.5867488707898912}], 
          RectangleBox[{2.7, 0.5748441088851295}, \
{2.795, 0.5867488707898912}], 
          
          RectangleBox[{2.9, 0.5748441088851295}, \
{2.995, 0.5867488707898912}], 
          RectangleBox[{1.2, 0.610558394599415}, {1.295, 0.6224631565041769}],
           RectangleBox[{2.8, 0.610558394599415}, \
{2.895, 0.6224631565041769}], 
          RectangleBox[{1.3, 0.646272680313701}, {1.395, 0.658177442218463}], 
          RectangleBox[{1.5, 0.646272680313701}, \
{1.5950000000000002`, 0.658177442218463}], 
          RectangleBox[{1.7, 0.646272680313701}, {1.795, 0.658177442218463}], 
          RectangleBox[{1.9, 0.646272680313701}, {1.995, 0.658177442218463}], 
          RectangleBox[{2.1, 0.646272680313701}, \
{2.1950000000000003`, 0.658177442218463}], 
          RectangleBox[{2.3, 0.646272680313701}, {2.395, 0.658177442218463}], 
          RectangleBox[{2.5, 0.646272680313701}, {2.595, 0.658177442218463}], 
          RectangleBox[{2.7, 0.646272680313701}, {2.795, 0.658177442218463}], 
          RectangleBox[{1.4, 0.6819869660279864}, \
{1.495, 0.6938917279327484}], 
          RectangleBox[{1.8, 0.6819869660279864}, \
{1.895, 0.6938917279327484}], 
          RectangleBox[{2.2, 0.6819869660279864}, \
{2.295, 0.6938917279327484}], 
          RectangleBox[{2.6, 0.6819869660279864}, \
{2.6950000000000003`, 0.6938917279327484}], 
          RectangleBox[{1.5, 0.7177012517422724}, \
{1.5950000000000002`, 0.7296060136470344}], 
          RectangleBox[{1.7, 0.7177012517422724}, \
{1.795, 0.7296060136470344}], 
          RectangleBox[{2.3, 0.7177012517422724}, \
{2.395, 0.7296060136470344}], 
          RectangleBox[{2.5, 0.7177012517422724}, \
{2.595, 0.7296060136470344}], 
          RectangleBox[{1.6, 0.7534155374565579}, \
{1.695, 0.7653202993613198}], 
          RectangleBox[{2.4, 0.7534155374565579}, \
{2.495, 0.7653202993613198}], 
          RectangleBox[{1.7, 0.7891298231708438}, \
{1.795, 0.8010345850756058}], 
          RectangleBox[{1.9, 0.7891298231708438}, \
{1.995, 0.8010345850756058}], 
          RectangleBox[{2.1, 0.7891298231708438}, \
{2.1950000000000003`, 0.8010345850756058}], 
          RectangleBox[{2.3, 0.7891298231708438}, \
{2.395, 0.8010345850756058}], 
          RectangleBox[{1.8, 0.8248441088851293}, \
{1.895, 0.8367488707898912}], 
          RectangleBox[{2.2, 0.8248441088851293}, \
{2.295, 0.8367488707898912}], 
          RectangleBox[{1.9, 0.860558394599415}, {1.995, 0.872463156504177}], 
          RectangleBox[{2.1, 0.860558394599415}, \
{2.1950000000000003`, 0.872463156504177}], 
          RectangleBox[{2., 0.896272680313701}, {2.095, 0.9081774422184627}]},
         
         Antialiasing->True]},
       AspectRatio->NCache[
         Rational[6, 35], 0.17142857142857143`],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0.75],
       FrameTicks->False,
       PlotRange->All,
       PlotRangePadding->{Automatic, 0.05}], {180, -35}, 
      ImageScaled[{0.5, 0.5}], {350, 60},
      Background->GrayLevel[0.9]], InsetBox[
      GraphicsBox[
       {GrayLevel[0.6], RectangleBox[{0, 0}]},
       AspectRatio->NCache[
         Rational[6, 35], 0.17142857142857143`],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0.75],
       FrameTicks->False], {180, -100}, ImageScaled[{0.5, 0.5}], {350, 60},
      Background->GrayLevel[0.9]]}, InsetBox[
     StyleBox[
      InterpretationBox[
       InterpretationBox[
        RowBox[{"\<\"4.1\"\>", "\[InvisibleSpace]", "\<\" s\"\>"}],
        Row[{"4.1", " s"}]],
       Row[{
         Row[{"4.1", " s"}]}, 
        Style[" | ", FontSize -> 14, FontColor -> GrayLevel[0.75]]]], 
      "DialogStyle",
      StripOnInput->False], {355, -159}, Scaled[{1, 0}]], 
    TagBox[
     TooltipBox[
      TagBox[{
        {GrayLevel[0.9], RectangleBox[{5, -158}, {29, -135}]}, 
        {GrayLevel[0.3], 
         PolygonBox[
          NCache[{{13, -153}, {13, -140}, {21, Rational[-293, 2]}, {
            13, -153}}, {{13, -153}, {13, -140}, {21, -146.5}, {
            13, -153}}]]}, 
        {GrayLevel[0.5], 
         StyleBox[
          LineBox[{{5, -158}, {5, -135}, {29, -135}, {29, -158}, {5, -158}}],
          Antialiasing->False]}},
       EventHandlerTag[{"MouseClicked" :> (If[Sound`MIDISequence[{
               Sound`MIDITrack[{
                 Sound`MIDIEvent[0, "SetTempo", "Tempo" -> 1000000], 
                 Sound`MIDIEvent[
                 0, "ProgramCommand", "Channel" -> 0, "Value" -> 0], 
                 Sound`MIDIEvent[
                 0, "NoteOn", "Note" -> 39, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 1, "NoteOff", "Note" -> 39, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 1, "NoteOn", "Note" -> 42, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 2, "NoteOff", "Note" -> 42, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 2, "NoteOn", "Note" -> 45, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 3, "NoteOff", "Note" -> 45, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 3, "NoteOn", "Note" -> 42, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 3, "NoteOn", "Note" -> 48, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 4, "NoteOff", "Note" -> 42, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 4, "NoteOff", "Note" -> 48, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 4, "NoteOn", "Note" -> 51, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 5, "NoteOff", "Note" -> 51, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 5, "NoteOn", "Note" -> 42, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 5, "NoteOn", "Note" -> 48, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 5, "NoteOn", "Note" -> 54, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 6, "NoteOff", "Note" -> 42, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 6, "NoteOff", "Note" -> 48, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 6, "NoteOff", "Note" -> 54, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 6, "NoteOn", "Note" -> 45, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 6, "NoteOn", "Note" -> 57, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 7, "NoteOff", "Note" -> 45, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 7, "NoteOff", "Note" -> 57, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 7, "NoteOn", "Note" -> 42, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 7, "NoteOn", "Note" -> 54, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 7, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 8, "NoteOff", "Note" -> 42, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 8, "NoteOff", "Note" -> 54, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 8, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 8, "NoteOn", "Note" -> 39, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 8, "NoteOn", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 9, "NoteOff", "Note" -> 39, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 9, "NoteOff", "Note" -> 63, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 9, "NoteOn", "Note" -> 54, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 9, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 9, "NoteOn", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 10, "NoteOff", "Note" -> 54, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 10, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 10, "NoteOff", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 10, "NoteOn", "Note" -> 57, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 10, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 11, "NoteOff", "Note" -> 57, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 11, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 11, "NoteOn", "Note" -> 54, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 11, "NoteOn", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 11, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 12, "NoteOff", "Note" -> 54, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 12, "NoteOff", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 12, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 12, "NoteOn", "Note" -> 75, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 13, "NoteOff", "Note" -> 75, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 13, "NoteOn", "Note" -> 54, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 13, "NoteOn", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 13, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 13, "NoteOn", "Note" -> 78, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 14, "NoteOff", "Note" -> 54, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 14, "NoteOff", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 14, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 14, "NoteOff", "Note" -> 78, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 14, "NoteOn", "Note" -> 57, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 14, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 14, "NoteOn", "Note" -> 81, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 15, "NoteOff", "Note" -> 57, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 15, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 15, "NoteOff", "Note" -> 81, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 15, "NoteOn", "Note" -> 54, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 15, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 15, "NoteOn", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 15, "NoteOn", "Note" -> 78, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 15, "NoteOn", "Note" -> 84, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 16, "NoteOff", "Note" -> 54, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 16, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 16, "NoteOff", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 16, "NoteOff", "Note" -> 78, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 16, "NoteOff", "Note" -> 84, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 16, "NoteOn", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 16, "NoteOn", "Note" -> 87, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 17, "NoteOff", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 17, "NoteOff", "Note" -> 87, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 17, "NoteOn", "Note" -> 54, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 17, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 17, "NoteOn", "Note" -> 78, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 17, "NoteOn", "Note" -> 84, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 17, "NoteOn", "Note" -> 90, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 18, "NoteOff", "Note" -> 54, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 18, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 18, "NoteOff", "Note" -> 78, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 18, "NoteOff", "Note" -> 84, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 18, "NoteOff", "Note" -> 90, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 18, "NoteOn", "Note" -> 57, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 18, "NoteOn", "Note" -> 81, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 18, "NoteOn", "Note" -> 93, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 19, "NoteOff", "Note" -> 57, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 19, "NoteOff", "Note" -> 81, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 19, "NoteOff", "Note" -> 93, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 19, "NoteOn", "Note" -> 54, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 19, "NoteOn", "Note" -> 78, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 19, "NoteOn", "Note" -> 90, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 19, "NoteOn", "Note" -> 96, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 20, "NoteOff", "Note" -> 54, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 20, "NoteOff", "Note" -> 78, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 20, "NoteOff", "Note" -> 90, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 20, "NoteOff", "Note" -> 96, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 20, "NoteOn", "Note" -> 99, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 21, "NoteOff", "Note" -> 99, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 21, "NoteOn", "Note" -> 54, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 21, "NoteOn", "Note" -> 78, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 21, "NoteOn", "Note" -> 90, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 21, "NoteOn", "Note" -> 96, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 22, "NoteOff", "Note" -> 54, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 22, "NoteOff", "Note" -> 78, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 22, "NoteOff", "Note" -> 90, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 22, "NoteOff", "Note" -> 96, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 22, "NoteOn", "Note" -> 57, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 22, "NoteOn", "Note" -> 81, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 22, "NoteOn", "Note" -> 93, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 23, "NoteOff", "Note" -> 57, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 23, "NoteOff", "Note" -> 81, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 23, "NoteOff", "Note" -> 93, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 23, "NoteOn", "Note" -> 54, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 23, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 23, "NoteOn", "Note" -> 78, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 23, "NoteOn", "Note" -> 84, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 23, "NoteOn", "Note" -> 90, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 24, "NoteOff", "Note" -> 54, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 24, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 24, "NoteOff", "Note" -> 78, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 24, "NoteOff", "Note" -> 84, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 24, "NoteOff", "Note" -> 90, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 24, "NoteOn", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 24, "NoteOn", "Note" -> 87, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 25, "NoteOff", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 25, "NoteOff", "Note" -> 87, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 25, "NoteOn", "Note" -> 54, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 25, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 25, "NoteOn", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 25, "NoteOn", "Note" -> 78, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 25, "NoteOn", "Note" -> 84, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 26, "NoteOff", "Note" -> 54, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 26, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 26, "NoteOff", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 26, "NoteOff", "Note" -> 78, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 26, "NoteOff", "Note" -> 84, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 26, "NoteOn", "Note" -> 57, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 26, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 26, "NoteOn", "Note" -> 81, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 27, "NoteOff", "Note" -> 57, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 27, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 27, "NoteOff", "Note" -> 81, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 27, "NoteOn", "Note" -> 54, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 27, "NoteOn", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 27, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 27, "NoteOn", "Note" -> 78, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 28, "NoteOff", "Note" -> 54, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 28, "NoteOff", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 28, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 28, "NoteOff", "Note" -> 78, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 28, "NoteOn", "Note" -> 75, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 29, "NoteOff", "Note" -> 75, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 29, "NoteOn", "Note" -> 54, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 29, "NoteOn", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 29, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 30, "NoteOff", "Note" -> 54, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 30, "NoteOff", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 30, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 30, "NoteOn", "Note" -> 57, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 30, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 31, "NoteOff", "Note" -> 57, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 31, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 31, "NoteOn", "Note" -> 54, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 31, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 31, "NoteOn", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 32, "NoteOff", "Note" -> 54, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 32, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 32, "NoteOff", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 32, "NoteOn", "Note" -> 39, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 32, "NoteOn", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 33, "NoteOff", "Note" -> 39, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 33, "NoteOff", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 33, "NoteOn", "Note" -> 42, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 33, "NoteOn", "Note" -> 54, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 33, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 34, "NoteOff", "Note" -> 42, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 34, "NoteOff", "Note" -> 54, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 34, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 34, "NoteOn", "Note" -> 45, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 34, "NoteOn", "Note" -> 57, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 35, "NoteOff", "Note" -> 45, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 35, "NoteOff", "Note" -> 57, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 35, "NoteOn", "Note" -> 42, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 35, "NoteOn", "Note" -> 48, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 35, "NoteOn", "Note" -> 54, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 36, "NoteOff", "Note" -> 42, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 36, "NoteOff", "Note" -> 48, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 36, "NoteOff", "Note" -> 54, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 36, "NoteOn", "Note" -> 51, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 37, "NoteOff", "Note" -> 51, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 37, "NoteOn", "Note" -> 42, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 37, "NoteOn", "Note" -> 48, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 38, "NoteOff", "Note" -> 42, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 38, "NoteOff", "Note" -> 48, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 38, "NoteOn", "Note" -> 45, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 39, "NoteOff", "Note" -> 45, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 39, "NoteOn", "Note" -> 42, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 40, "NoteOff", "Note" -> 42, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 40, "NoteOn", "Note" -> 39, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 41, "NoteOff", "Note" -> 39, "Channel" -> 0, "Velocity" -> 
                  0]}]}, "DivisionType" -> "PPQ", "Resolution" -> 10] =!= 
            None, 
            Sound`EmitMIDI[
             Sound`MIDISequence[{
               Sound`MIDITrack[{
                 Sound`MIDIEvent[0, "SetTempo", "Tempo" -> 1000000], 
                 Sound`MIDIEvent[
                 0, "ProgramCommand", "Channel" -> 0, "Value" -> 0], 
                 Sound`MIDIEvent[
                 0, "NoteOn", "Note" -> 39, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 1, "NoteOff", "Note" -> 39, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 1, "NoteOn", "Note" -> 42, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 2, "NoteOff", "Note" -> 42, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 2, "NoteOn", "Note" -> 45, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 3, "NoteOff", "Note" -> 45, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 3, "NoteOn", "Note" -> 42, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 3, "NoteOn", "Note" -> 48, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 4, "NoteOff", "Note" -> 42, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 4, "NoteOff", "Note" -> 48, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 4, "NoteOn", "Note" -> 51, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 5, "NoteOff", "Note" -> 51, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 5, "NoteOn", "Note" -> 42, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 5, "NoteOn", "Note" -> 48, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 5, "NoteOn", "Note" -> 54, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 6, "NoteOff", "Note" -> 42, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 6, "NoteOff", "Note" -> 48, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 6, "NoteOff", "Note" -> 54, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 6, "NoteOn", "Note" -> 45, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 6, "NoteOn", "Note" -> 57, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 7, "NoteOff", "Note" -> 45, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 7, "NoteOff", "Note" -> 57, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 7, "NoteOn", "Note" -> 42, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 7, "NoteOn", "Note" -> 54, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 7, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 8, "NoteOff", "Note" -> 42, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 8, "NoteOff", "Note" -> 54, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 8, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 8, "NoteOn", "Note" -> 39, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 8, "NoteOn", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 9, "NoteOff", "Note" -> 39, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 9, "NoteOff", "Note" -> 63, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 9, "NoteOn", "Note" -> 54, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 9, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 9, "NoteOn", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 10, "NoteOff", "Note" -> 54, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 10, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 10, "NoteOff", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 10, "NoteOn", "Note" -> 57, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 10, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 11, "NoteOff", "Note" -> 57, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 11, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 11, "NoteOn", "Note" -> 54, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 11, "NoteOn", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 11, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 12, "NoteOff", "Note" -> 54, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 12, "NoteOff", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 12, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 12, "NoteOn", "Note" -> 75, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 13, "NoteOff", "Note" -> 75, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 13, "NoteOn", "Note" -> 54, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 13, "NoteOn", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 13, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 13, "NoteOn", "Note" -> 78, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 14, "NoteOff", "Note" -> 54, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 14, "NoteOff", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 14, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 14, "NoteOff", "Note" -> 78, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 14, "NoteOn", "Note" -> 57, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 14, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 14, "NoteOn", "Note" -> 81, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 15, "NoteOff", "Note" -> 57, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 15, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 15, "NoteOff", "Note" -> 81, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 15, "NoteOn", "Note" -> 54, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 15, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 15, "NoteOn", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 15, "NoteOn", "Note" -> 78, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 15, "NoteOn", "Note" -> 84, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 16, "NoteOff", "Note" -> 54, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 16, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 16, "NoteOff", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 16, "NoteOff", "Note" -> 78, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 16, "NoteOff", "Note" -> 84, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 16, "NoteOn", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 16, "NoteOn", "Note" -> 87, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 17, "NoteOff", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 17, "NoteOff", "Note" -> 87, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 17, "NoteOn", "Note" -> 54, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 17, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 17, "NoteOn", "Note" -> 78, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 17, "NoteOn", "Note" -> 84, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 17, "NoteOn", "Note" -> 90, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 18, "NoteOff", "Note" -> 54, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 18, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 18, "NoteOff", "Note" -> 78, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 18, "NoteOff", "Note" -> 84, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 18, "NoteOff", "Note" -> 90, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 18, "NoteOn", "Note" -> 57, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 18, "NoteOn", "Note" -> 81, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 18, "NoteOn", "Note" -> 93, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 19, "NoteOff", "Note" -> 57, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 19, "NoteOff", "Note" -> 81, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 19, "NoteOff", "Note" -> 93, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 19, "NoteOn", "Note" -> 54, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 19, "NoteOn", "Note" -> 78, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 19, "NoteOn", "Note" -> 90, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 19, "NoteOn", "Note" -> 96, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 20, "NoteOff", "Note" -> 54, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 20, "NoteOff", "Note" -> 78, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 20, "NoteOff", "Note" -> 90, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 20, "NoteOff", "Note" -> 96, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 20, "NoteOn", "Note" -> 99, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 21, "NoteOff", "Note" -> 99, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 21, "NoteOn", "Note" -> 54, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 21, "NoteOn", "Note" -> 78, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 21, "NoteOn", "Note" -> 90, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 21, "NoteOn", "Note" -> 96, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 22, "NoteOff", "Note" -> 54, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 22, "NoteOff", "Note" -> 78, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 22, "NoteOff", "Note" -> 90, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 22, "NoteOff", "Note" -> 96, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 22, "NoteOn", "Note" -> 57, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 22, "NoteOn", "Note" -> 81, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 22, "NoteOn", "Note" -> 93, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 23, "NoteOff", "Note" -> 57, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 23, "NoteOff", "Note" -> 81, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 23, "NoteOff", "Note" -> 93, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 23, "NoteOn", "Note" -> 54, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 23, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 23, "NoteOn", "Note" -> 78, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 23, "NoteOn", "Note" -> 84, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 23, "NoteOn", "Note" -> 90, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 24, "NoteOff", "Note" -> 54, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 24, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 24, "NoteOff", "Note" -> 78, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 24, "NoteOff", "Note" -> 84, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 24, "NoteOff", "Note" -> 90, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 24, "NoteOn", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 24, "NoteOn", "Note" -> 87, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 25, "NoteOff", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 25, "NoteOff", "Note" -> 87, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 25, "NoteOn", "Note" -> 54, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 25, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 25, "NoteOn", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 25, "NoteOn", "Note" -> 78, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 25, "NoteOn", "Note" -> 84, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 26, "NoteOff", "Note" -> 54, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 26, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 26, "NoteOff", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 26, "NoteOff", "Note" -> 78, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 26, "NoteOff", "Note" -> 84, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 26, "NoteOn", "Note" -> 57, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 26, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 26, "NoteOn", "Note" -> 81, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 27, "NoteOff", "Note" -> 57, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 27, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 27, "NoteOff", "Note" -> 81, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 27, "NoteOn", "Note" -> 54, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 27, "NoteOn", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 27, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 27, "NoteOn", "Note" -> 78, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 28, "NoteOff", "Note" -> 54, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 28, "NoteOff", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 28, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 28, "NoteOff", "Note" -> 78, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 28, "NoteOn", "Note" -> 75, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 29, "NoteOff", "Note" -> 75, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 29, "NoteOn", "Note" -> 54, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 29, "NoteOn", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 29, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 30, "NoteOff", "Note" -> 54, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 30, "NoteOff", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 30, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 30, "NoteOn", "Note" -> 57, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 30, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 31, "NoteOff", "Note" -> 57, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 31, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 31, "NoteOn", "Note" -> 54, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 31, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 31, "NoteOn", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 32, "NoteOff", "Note" -> 54, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 32, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 32, "NoteOff", "Note" -> 66, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 32, "NoteOn", "Note" -> 39, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 32, "NoteOn", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 33, "NoteOff", "Note" -> 39, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 33, "NoteOff", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 33, "NoteOn", "Note" -> 42, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 33, "NoteOn", "Note" -> 54, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 33, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 34, "NoteOff", "Note" -> 42, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 34, "NoteOff", "Note" -> 54, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 34, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 34, "NoteOn", "Note" -> 45, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 34, "NoteOn", "Note" -> 57, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 35, "NoteOff", "Note" -> 45, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 35, "NoteOff", "Note" -> 57, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 35, "NoteOn", "Note" -> 42, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 35, "NoteOn", "Note" -> 48, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 35, "NoteOn", "Note" -> 54, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 36, "NoteOff", "Note" -> 42, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 36, "NoteOff", "Note" -> 48, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 36, "NoteOff", "Note" -> 54, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 36, "NoteOn", "Note" -> 51, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 37, "NoteOff", "Note" -> 51, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 37, "NoteOn", "Note" -> 42, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 37, "NoteOn", "Note" -> 48, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 38, "NoteOff", "Note" -> 42, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 38, "NoteOff", "Note" -> 48, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 38, "NoteOn", "Note" -> 45, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 39, "NoteOff", "Note" -> 45, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 39, "NoteOn", "Note" -> 42, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 40, "NoteOff", "Note" -> 42, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 40, "NoteOn", "Note" -> 39, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 41, "NoteOff", "Note" -> 39, "Channel" -> 0, "Velocity" -> 
                  0]}]}, "DivisionType" -> "PPQ", "Resolution" -> 10]]]; 
          Sound`SoundDump`emitSoundThroughFE[None, "Preemptive"]), 
         PassEventsDown -> Automatic, PassEventsUp -> True}]],
      "\"Play\""],
     Annotation[#, "Play", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[{
        {GrayLevel[0.9], RectangleBox[{34, -158}, {58, -135}]}, 
        {GrayLevel[0.3], RectangleBox[{42, -150}, {50, -143}]}, 
        {GrayLevel[0.5], 
         StyleBox[
          LineBox[{{34, -158}, {34, -135}, {58, -135}, {58, -158}, {
           34, -158}}],
          Antialiasing->False]}},
       EventHandlerTag[{
        "MouseClicked" :> (Sound`SoundDump`emitSoundThroughFE[
            SampledSoundList[{{0.}}, 8000], "Preemptive"]; 
          Sound`MIDIDump`stopMIDI[]), PassEventsDown -> Automatic, 
         PassEventsUp -> True}]],
      "\"Stop\""],
     Annotation[#, "Stop", "Tooltip"]& ], 
    {GrayLevel[0.75], 
     StyleBox[LineBox[{{0, 0}, {360, 0}, {360, -164}, {0, -164}, {0, 0}}],
      Antialiasing->False]}},
   ContentSelectable->False,
   ImageSize->250,
   PlotRange->{{0, 360}, {0, -164}},
   PlotRangePadding->1],
  Sound[{
    SoundNote[{-21}, 0.1], 
    SoundNote[{-18}, 0.1], 
    SoundNote[{-15}, 0.1], 
    SoundNote[{-18, -12}, 0.1], 
    SoundNote[{-9}, 0.1], 
    SoundNote[{-18, -12, -6}, 0.1], 
    SoundNote[{-15, -3}, 0.1], 
    SoundNote[{-18, -6, 0}, 0.1], 
    SoundNote[{-21, 3}, 0.1], 
    SoundNote[{-6, 0, 6}, 0.1], 
    SoundNote[{-3, 9}, 0.1], 
    SoundNote[{-6, 6, 12}, 0.1], 
    SoundNote[{15}, 0.1], 
    SoundNote[{-6, 6, 12, 18}, 0.1], 
    SoundNote[{-3, 9, 21}, 0.1], 
    SoundNote[{-6, 0, 6, 18, 24}, 0.1], 
    SoundNote[{3, 27}, 0.1], 
    SoundNote[{-6, 0, 18, 24, 30}, 0.1], 
    SoundNote[{-3, 21, 33}, 0.1], 
    SoundNote[{-6, 18, 30, 36}, 0.1], 
    SoundNote[{39}, 0.1], 
    SoundNote[{-6, 18, 30, 36}, 0.1], 
    SoundNote[{-3, 21, 33}, 0.1], 
    SoundNote[{-6, 0, 18, 24, 30}, 0.1], 
    SoundNote[{3, 27}, 0.1], 
    SoundNote[{-6, 0, 6, 18, 24}, 0.1], 
    SoundNote[{-3, 9, 21}, 0.1], 
    SoundNote[{-6, 6, 12, 18}, 0.1], 
    SoundNote[{15}, 0.1], 
    SoundNote[{-6, 6, 12}, 0.1], 
    SoundNote[{-3, 9}, 0.1], 
    SoundNote[{-6, 0, 6}, 0.1], 
    SoundNote[{-21, 3}, 0.1], 
    SoundNote[{-18, -6, 0}, 0.1], 
    SoundNote[{-15, -3}, 0.1], 
    SoundNote[{-18, -12, -6}, 0.1], 
    SoundNote[{-9}, 0.1], 
    SoundNote[{-18, -12}, 0.1], 
    SoundNote[{-15}, 0.1], 
    SoundNote[{-18}, 0.1], 
    SoundNote[{-21}, 0.1]}]]], "Output",
 ImageSize->{254, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->137625022]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->688093758],

Cell["Generate a simple WolframTones-like composition:", "ExampleText",
 CellID->421247838],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sound", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"SoundNote", "[", 
     RowBox[{"#", ",", 
      RowBox[{"1", "/", "6"}], ",", "\"\<Warm\>\""}], "]"}], "&"}], "/@", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"Pick", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "5", ",", "9", ",", "12", ",", "16", ",", "21"}], 
         "}"}], ",", "#", ",", "1"}], "]"}], "&"}], "/@", 
     RowBox[{"CellularAutomaton", "[", 
      RowBox[{"30", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], 
          "}"}], ",", "0"}], "}"}], ",", "13", ",", 
       RowBox[{"{", 
        RowBox[{"13", ",", "5"}], "}"}]}], "]"}]}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->333718560],

Cell[BoxData[
 InterpretationBox[
  GraphicsBox[{
    {GrayLevel[0.9], RectangleBox[{0, 0}, {360, -164}]}, {InsetBox[
      GraphicsBox[
       {Hue[0.15589312541351202`, 0.9, 0.7], 
        StyleBox[{
          RectangleBox[{0., 0.43198696602798653`}, \
{0.15833333333333333`, 0.4438917279327484}], 
          RectangleBox[{0.16666666666666666`, 0.43198696602798653`}, \
{0.32499999999999996`, 0.4438917279327484}], 
          RectangleBox[{0.5, 0.43198696602798653`}, \
{0.6583333333333333, 0.4438917279327484}], 
          RectangleBox[{0.6666666666666666, 0.43198696602798653`}, \
{0.8250000000000001, 0.4438917279327484}], 
          RectangleBox[{0.8333333333333334, 0.43198696602798653`}, \
{0.9916666666666667, 0.4438917279327484}], 
          RectangleBox[{1.3333333333333333`, 0.43198696602798653`}, \
{1.4916666666666667`, 0.4438917279327484}], 
          RectangleBox[{1.5, 0.43198696602798653`}, \
{1.6583333333333334`, 0.4438917279327484}], 
          RectangleBox[{2.1666666666666665`, 0.43198696602798653`}, \
{2.325, 0.4438917279327484}], 
          RectangleBox[{0.16666666666666666`, 0.49151077555179606`}, \
{0.32499999999999996`, 0.5034155374565581}], 
          RectangleBox[{0.5, 0.49151077555179606`}, \
{0.6583333333333333, 0.5034155374565581}], 
          RectangleBox[{0.8333333333333334, 0.49151077555179606`}, \
{0.9916666666666667, 0.5034155374565581}], 
          RectangleBox[{1.3333333333333333`, 0.49151077555179606`}, \
{1.4916666666666667`, 0.5034155374565581}], 
          RectangleBox[{1.6666666666666667`, 0.49151077555179606`}, \
{1.825, 0.5034155374565581}], 
          RectangleBox[{1.8333333333333333`, 0.49151077555179606`}, \
{1.9916666666666667`, 0.5034155374565581}], 
          RectangleBox[{2., 0.49151077555179606`}, \
{2.158333333333333, 0.5034155374565581}], 
          RectangleBox[{2.1666666666666665`, 0.49151077555179606`}, \
{2.325, 0.5034155374565581}], 
          RectangleBox[{0.3333333333333333, 0.5391298231708438}, \
{0.49166666666666664`, 0.5510345850756055}], 
          RectangleBox[{0.5, 0.5391298231708438}, \
{0.6583333333333333, 0.5510345850756055}], 
          RectangleBox[{1.1666666666666667`, 0.5391298231708438}, \
{1.325, 0.5510345850756055}], 
          RectangleBox[{1.3333333333333333`, 0.5391298231708438}, \
{1.4916666666666667`, 0.5510345850756055}], 
          RectangleBox[{1.6666666666666667`, 0.5391298231708438}, \
{1.825, 0.5510345850756055}], 
          RectangleBox[{2., 0.5391298231708438}, \
{2.158333333333333, 0.5510345850756055}], 
          RectangleBox[{0.5, 0.5748441088851295}, \
{0.6583333333333333, 0.5867488707898912}], 
          RectangleBox[{0.8333333333333334, 0.5748441088851295}, \
{0.9916666666666667, 0.5867488707898912}], 
          RectangleBox[{1., 0.5748441088851295}, \
{1.1583333333333334`, 0.5867488707898912}], 
          RectangleBox[{1.1666666666666667`, 0.5748441088851295}, \
{1.325, 0.5867488707898912}], 
          RectangleBox[{1.5, 0.5748441088851295}, \
{1.6583333333333334`, 0.5867488707898912}], 
          RectangleBox[{1.6666666666666667`, 0.5748441088851295}, \
{1.825, 0.5867488707898912}], 
          RectangleBox[{2.1666666666666665`, 0.5748441088851295}, \
{2.325, 0.5867488707898912}], 
          RectangleBox[{0.6666666666666666, 0.6224631565041769}, \
{0.8250000000000001, 0.6343679184089389}], 
          RectangleBox[{0.8333333333333334, 0.6224631565041769}, \
{0.9916666666666667, 0.6343679184089389}], 
          RectangleBox[{1.1666666666666667`, 0.6224631565041769}, \
{1.325, 0.6343679184089389}], 
          RectangleBox[{1.6666666666666667`, 0.6224631565041769}, \
{1.825, 0.6343679184089389}], 
          RectangleBox[{2.1666666666666665`, 0.6224631565041769}, \
{2.325, 0.6343679184089389}], 
          RectangleBox[{0.8333333333333334, 0.6819869660279864}, \
{0.9916666666666667, 0.6938917279327484}], 
          RectangleBox[{1.1666666666666667`, 0.6819869660279864}, \
{1.325, 0.6938917279327484}], 
          RectangleBox[{2., 0.6819869660279864}, \
{2.158333333333333, 0.6938917279327484}], 
          RectangleBox[{2.1666666666666665`, 0.6819869660279864}, \
{2.325, 0.6938917279327484}]},
         Antialiasing->True]},
       AspectRatio->NCache[
         Rational[6, 35], 0.17142857142857143`],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0.75],
       FrameTicks->False,
       PlotRange->All,
       PlotRangePadding->{Automatic, 0.05}], {180, -35}, 
      ImageScaled[{0.5, 0.5}], {350, 60},
      Background->GrayLevel[0.9]], InsetBox[
      GraphicsBox[
       {GrayLevel[0.6], RectangleBox[{0, 0}]},
       AspectRatio->NCache[
         Rational[6, 35], 0.17142857142857143`],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0.75],
       FrameTicks->False], {180, -100}, ImageScaled[{0.5, 0.5}], {350, 60},
      Background->GrayLevel[0.9]]}, InsetBox[
     StyleBox[
      InterpretationBox[
       InterpretationBox[
        RowBox[{"\<\"2.33\"\>", "\[InvisibleSpace]", "\<\" s\"\>"}],
        Row[{"2.33", " s"}]],
       Row[{
         Row[{"2.33", " s"}]}, 
        Style[" | ", FontSize -> 14, FontColor -> GrayLevel[0.75]]]], 
      "DialogStyle",
      StripOnInput->False], {355, -159}, Scaled[{1, 0}]], 
    TagBox[
     TooltipBox[
      TagBox[{
        {GrayLevel[0.9], RectangleBox[{5, -158}, {29, -135}]}, 
        {GrayLevel[0.3], 
         PolygonBox[
          NCache[{{13, -153}, {13, -140}, {21, Rational[-293, 2]}, {
            13, -153}}, {{13, -153}, {13, -140}, {21, -146.5}, {
            13, -153}}]]}, 
        {GrayLevel[0.5], 
         StyleBox[
          LineBox[{{5, -158}, {5, -135}, {29, -135}, {29, -158}, {5, -158}}],
          Antialiasing->False]}},
       EventHandlerTag[{"MouseClicked" :> (If[Sound`MIDISequence[{
               Sound`MIDITrack[{
                 Sound`MIDIEvent[0, "SetTempo", "Tempo" -> 1000000], 
                 Sound`MIDIEvent[
                 0, "ProgramCommand", "Channel" -> 0, "Value" -> 89], 
                 Sound`MIDIEvent[
                 0, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 1, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 1, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 1, "NoteOn", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 2, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 2, "NoteOff", "Note" -> 65, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 2, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 3, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 3, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 3, "NoteOn", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 3, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 3, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 4, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 4, "NoteOff", "Note" -> 65, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 4, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 4, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 4, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 4, "NoteOn", "Note" -> 76, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 5, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 5, "NoteOff", "Note" -> 76, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 5, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 5, "NoteOn", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 5, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 5, "NoteOn", "Note" -> 76, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 5, "NoteOn", "Note" -> 81, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 6, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 6, "NoteOff", "Note" -> 65, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 6, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 6, "NoteOff", "Note" -> 76, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 6, "NoteOff", "Note" -> 81, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 6, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 7, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 7, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 7, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 7, "NoteOn", "Note" -> 76, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 7, "NoteOn", "Note" -> 81, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 8, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 8, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 8, "NoteOff", "Note" -> 76, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 8, "NoteOff", "Note" -> 81, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 8, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 8, "NoteOn", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 8, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 9, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 9, "NoteOff", "Note" -> 65, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 9, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 9, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 9, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 10, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 10, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 10, "NoteOn", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 10, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 10, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 10, "NoteOn", "Note" -> 76, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 11, "NoteOff", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 11, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 11, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 11, "NoteOff", "Note" -> 76, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 11, "NoteOn", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 12, "NoteOff", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 12, "NoteOn", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 12, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 12, "NoteOn", "Note" -> 81, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 13, "NoteOff", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 13, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 13, "NoteOff", "Note" -> 81, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 13, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 13, "NoteOn", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 13, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 13, "NoteOn", "Note" -> 76, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 13, "NoteOn", "Note" -> 81, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 14, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 14, "NoteOff", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 14, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 14, "NoteOff", "Note" -> 76, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 14, "NoteOff", "Note" -> 81, "Channel" -> 0, "Velocity" -> 
                  0]}]}, "DivisionType" -> "PPQ", "Resolution" -> 6] =!= None,
             
            Sound`EmitMIDI[
             Sound`MIDISequence[{
               Sound`MIDITrack[{
                 Sound`MIDIEvent[0, "SetTempo", "Tempo" -> 1000000], 
                 Sound`MIDIEvent[
                 0, "ProgramCommand", "Channel" -> 0, "Value" -> 89], 
                 Sound`MIDIEvent[
                 0, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 1, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 1, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 1, "NoteOn", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 2, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 2, "NoteOff", "Note" -> 65, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 2, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 3, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 3, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 3, "NoteOn", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 3, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 3, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 4, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 4, "NoteOff", "Note" -> 65, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 4, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 4, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 4, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 4, "NoteOn", "Note" -> 76, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 5, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 5, "NoteOff", "Note" -> 76, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 5, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 5, "NoteOn", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 5, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 5, "NoteOn", "Note" -> 76, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 5, "NoteOn", "Note" -> 81, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 6, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 6, "NoteOff", "Note" -> 65, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 6, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 6, "NoteOff", "Note" -> 76, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 6, "NoteOff", "Note" -> 81, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 6, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 7, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 7, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 7, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 7, "NoteOn", "Note" -> 76, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 7, "NoteOn", "Note" -> 81, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 8, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 8, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 8, "NoteOff", "Note" -> 76, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 8, "NoteOff", "Note" -> 81, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 8, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 8, "NoteOn", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 8, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 9, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 9, "NoteOff", "Note" -> 65, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 9, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 9, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 9, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 10, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 10, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 10, "NoteOn", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 10, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 10, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 10, "NoteOn", "Note" -> 76, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 11, "NoteOff", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 11, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 11, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 11, "NoteOff", "Note" -> 76, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 11, "NoteOn", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 12, "NoteOff", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 12, "NoteOn", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 12, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 12, "NoteOn", "Note" -> 81, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 13, "NoteOff", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 13, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 13, "NoteOff", "Note" -> 81, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 13, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 13, "NoteOn", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 13, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 13, "NoteOn", "Note" -> 76, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 13, "NoteOn", "Note" -> 81, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 14, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 14, "NoteOff", "Note" -> 65, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 14, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 14, "NoteOff", "Note" -> 76, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 14, "NoteOff", "Note" -> 81, "Channel" -> 0, "Velocity" -> 
                  0]}]}, "DivisionType" -> "PPQ", "Resolution" -> 6]]]; 
          Sound`SoundDump`emitSoundThroughFE[None, "Preemptive"]), 
         PassEventsDown -> Automatic, PassEventsUp -> True}]],
      "\"Play\""],
     Annotation[#, "Play", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[{
        {GrayLevel[0.9], RectangleBox[{34, -158}, {58, -135}]}, 
        {GrayLevel[0.3], RectangleBox[{42, -150}, {50, -143}]}, 
        {GrayLevel[0.5], 
         StyleBox[
          LineBox[{{34, -158}, {34, -135}, {58, -135}, {58, -158}, {
           34, -158}}],
          Antialiasing->False]}},
       EventHandlerTag[{
        "MouseClicked" :> (Sound`SoundDump`emitSoundThroughFE[
            SampledSoundList[{{0.}}, 8000], "Preemptive"]; 
          Sound`MIDIDump`stopMIDI[]), PassEventsDown -> Automatic, 
         PassEventsUp -> True}]],
      "\"Stop\""],
     Annotation[#, "Stop", "Tooltip"]& ], 
    {GrayLevel[0.75], 
     StyleBox[LineBox[{{0, 0}, {360, 0}, {360, -164}, {0, -164}, {0, 0}}],
      Antialiasing->False]}},
   ContentSelectable->False,
   ImageSize->250,
   PlotRange->{{0, 360}, {0, -164}},
   PlotRangePadding->1],
  Sound[{
    SoundNote[{0}, 
     Rational[1, 6], "Warm"], 
    SoundNote[{0, 5}, 
     Rational[1, 6], "Warm"], 
    SoundNote[{9}, 
     Rational[1, 6], "Warm"], 
    SoundNote[{0, 5, 9, 12}, 
     Rational[1, 6], "Warm"], 
    SoundNote[{0, 16}, 
     Rational[1, 6], "Warm"], 
    SoundNote[{0, 5, 12, 16, 21}, 
     Rational[1, 6], "Warm"], 
    SoundNote[{12}, 
     Rational[1, 6], "Warm"], 
    SoundNote[{9, 12, 16, 21}, 
     Rational[1, 6], "Warm"], 
    SoundNote[{0, 5, 9}, 
     Rational[1, 6], "Warm"], 
    SoundNote[{0, 12}, 
     Rational[1, 6], "Warm"], 
    SoundNote[{5, 9, 12, 16}, 
     Rational[1, 6], "Warm"], 
    SoundNote[{5}, 
     Rational[1, 6], "Warm"], 
    SoundNote[{5, 9, 21}, 
     Rational[1, 6], "Warm"], 
    SoundNote[{0, 5, 12, 16, 21}, 
     Rational[1, 6], "Warm"]}]]], "Output",
 ImageSize->{254, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->476466265]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->475030017],

Cell["Record a sound:", "ExampleText",
 CellID->135090883],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"SystemDialogInput", "[", "\"\<RecordSound\>\"", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20076332],

Cell[BoxData[
 InterpretationBox[
  GraphicsBox[{
    {GrayLevel[0.9], RectangleBox[{0, 0}, {360, -164}]}, {InsetBox[
      GraphicsBox[InsetBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJzs2mk0leH/LnAVaaBEgyEhZCjSQBFdGVIpY6MhY4WoFM0pIkoqqVCKRkNR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          "],
          ColorFunction->(Blend[{
             RGBColor[1, 1, 1], 
             RGBColor[0, 0, 1]}, #]& )],
         AspectRatio->Full,
         ImageSize->NCache[{
            Rational[2756, 2205]}, {1.2498866213151927`}],
         PlotRangePadding->None], {0, 0}, {0, 0}, 
        NCache[{Rational[2756, 2205], 1}, {1.2498866213151927`, 1}]],
       AspectRatio->NCache[
         Rational[6, 35], 0.17142857142857143`],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0.75],
       FrameTicks->False,
       PlotRange->NCache[{{0, 
           Rational[2756, 2205]}, {0, 1}}, {{0, 1.2498866213151927`}, {0, 
          1}}],
       PlotRangePadding->{
         Scaled[0.017142857142857144`], 
         Scaled[0.1]}], {180, -35}, ImageScaled[{0.5, 0.5}], {350, 60},
      Background->GrayLevel[0.9]], InsetBox[
      GraphicsBox[InsetBox[
        GraphicsBox[
         {RGBColor[0.325101, 0.364492, 0.820256], LineBox[CompressedData["
1:eJxdW3WYVtXXRQlBUFK6Q0KlFGkuIqFICUoporQgAoKAhCKhdHcjIc1QQw7M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           "]]},
         AspectRatio->Full,
         PlotRange->{Automatic, {0, 1}},
         PlotRangePadding->None], {0, 0}, {0, 0}, 
        NCache[{Rational[2756, 2205], 1}, {1.2498866213151927`, 1}]],
       AspectRatio->NCache[
         Rational[6, 35], 0.17142857142857143`],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0.75],
       FrameTicks->False,
       PlotRange->NCache[{{0, 
           Rational[2756, 2205]}, {0, 1}}, {{0, 1.2498866213151927`}, {0, 
          1}}],
       PlotRangePadding->{
         Scaled[0.017142857142857144`], 
         Scaled[0.1]}], {180, -100}, ImageScaled[{0.5, 0.5}], {350, 60},
      Background->GrayLevel[0.9]]}, InsetBox[
     StyleBox[
      InterpretationBox[
       RowBox[{
        InterpretationBox[
         RowBox[{"\<\"1.25\"\>", "\[InvisibleSpace]", "\<\" s\"\>"}],
         Row[{"1.25", " s"}]], 
        StyleBox["\<\" | \"\>",
         StripOnInput->False,
         FontSize->14,
         FontColor->GrayLevel[0.75]], 
        InterpretationBox[
         RowBox[{"11025", "\[InvisibleSpace]", "\<\" Hz\"\>"}],
         Row[{11025, " Hz"}]]}],
       Row[{
         Row[{"1.25", " s"}], 
         Row[{11025, " Hz"}]}, 
        Style[" | ", FontSize -> 14, FontColor -> GrayLevel[0.75]]]], 
      "DialogStyle",
      StripOnInput->False], {355, -159}, Scaled[{1, 0}]], 
    TagBox[
     TooltipBox[
      TagBox[{
        {GrayLevel[0.9], RectangleBox[{5, -158}, {29, -135}]}, 
        {GrayLevel[0.3], 
         PolygonBox[
          NCache[{{13, -153}, {13, -140}, {21, Rational[-293, 2]}, {
            13, -153}}, {{13, -153}, {13, -140}, {21, -146.5}, {
            13, -153}}]]}, 
        {GrayLevel[0.5], 
         StyleBox[
          LineBox[{{5, -158}, {5, -135}, {29, -135}, {29, -158}, {5, -158}}],
          Antialiasing->False]}},
       EventHandlerTag[{"MouseClicked" :> (If[None =!= None, 
            Sound`EmitMIDI[None]]; Sound`SoundDump`emitSoundThroughFE[
            SampledSoundList[CompressedData["
1:eJztnUluHMmShtl9kz5Er98d+ggN9LqvkEfQUksuuNBCC0IoCIIgqCiJpVmi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             "], 11025], "Preemptive"]), PassEventsDown -> Automatic, 
         PassEventsUp -> True}]],
      "\"Play\""],
     Annotation[#, "Play", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[{
        {GrayLevel[0.9], RectangleBox[{34, -158}, {58, -135}]}, 
        {GrayLevel[0.3], RectangleBox[{42, -150}, {50, -143}]}, 
        {GrayLevel[0.5], 
         StyleBox[
          LineBox[{{34, -158}, {34, -135}, {58, -135}, {58, -158}, {
           34, -158}}],
          Antialiasing->False]}},
       EventHandlerTag[{
        "MouseClicked" :> (Sound`SoundDump`emitSoundThroughFE[
            SampledSoundList[{{0.}}, 8000], "Preemptive"]; 
          Sound`MIDIDump`stopMIDI[]), PassEventsDown -> Automatic, 
         PassEventsUp -> True}]],
      "\"Stop\""],
     Annotation[#, "Stop", "Tooltip"]& ], 
    {GrayLevel[0.75], 
     StyleBox[LineBox[{{0, 0}, {360, 0}, {360, -164}, {0, -164}, {0, 0}}],
      Antialiasing->False]}},
   ContentSelectable->False,
   ImageSize->250,
   PlotRange->{{0, 360}, {0, -164}},
   PlotRangePadding->1],
  Sound[
   SampledSoundList[CompressedData["
1:eJztnUluHMmShtl9kz5Er98d+ggN9LqvkEfQUksuuNBCC0IoCIIgqCiJpVmi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    "], 11025]]]], "Output",
 ImageSize->{254, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->233630681]
}, Open  ]],

Cell["Squash the sound to play over 0.8 seconds:", "ExampleText",
 CellID->240968665],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sound", "[", 
  RowBox[{"data", ",", ".8"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->658920736],

Cell[BoxData[
 InterpretationBox[
  GraphicsBox[{
    {GrayLevel[0.9], RectangleBox[{0, 0}, {360, -164}]}, {InsetBox[
      GraphicsBox[InsetBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJzs2Pk3VfH/L/AQiiYKSYZoFJLQqCelSVFmSQiFBqVQUUJRVKRCiqI0UZnn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          "],
          ColorFunction->(Blend[{
             RGBColor[1, 1, 1], 
             RGBColor[0, 0, 1]}, #]& )],
         AspectRatio->Full,
         ImageSize->NCache[{
            Rational[4, 5]}, {0.8}],
         PlotRangePadding->None], {0, 0}, {0, 0}, 
        NCache[{Rational[4, 5], 1}, {0.8, 1}]],
       AspectRatio->NCache[
         Rational[6, 35], 0.17142857142857143`],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0.75],
       FrameTicks->False,
       PlotRange->NCache[{{0, 
           Rational[4, 5]}, {0, 1}}, {{0, 0.8}, {0, 1}}],
       PlotRangePadding->{
         Scaled[0.017142857142857144`], 
         Scaled[0.1]}], {180, -35}, ImageScaled[{0.5, 0.5}], {350, 60},
      Background->GrayLevel[0.9]], InsetBox[
      GraphicsBox[InsetBox[
        GraphicsBox[
         {RGBColor[0.325101, 0.364492, 0.820256], LineBox[CompressedData["
1:eJxce3dcTv//vpESCSVSUskqIZIychHZW3lHqJAio4GUqIRItLX33nuveyQN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           "]]},
         AspectRatio->Full,
         PlotRange->{Automatic, {0, 1}},
         PlotRangePadding->None], {0, 0}, {0, 0}, 
        NCache[{Rational[4, 5], 1}, {0.8, 1}]],
       AspectRatio->NCache[
         Rational[6, 35], 0.17142857142857143`],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0.75],
       FrameTicks->False,
       PlotRange->NCache[{{0, 
           Rational[4, 5]}, {0, 1}}, {{0, 0.8}, {0, 1}}],
       PlotRangePadding->{
         Scaled[0.017142857142857144`], 
         Scaled[0.1]}], {180, -100}, ImageScaled[{0.5, 0.5}], {350, 60},
      Background->GrayLevel[0.9]]}, InsetBox[
     StyleBox[
      InterpretationBox[
       RowBox[{
        InterpretationBox[
         RowBox[{"\<\"0.8\"\>", "\[InvisibleSpace]", "\<\" s\"\>"}],
         Row[{"0.8", " s"}]], 
        StyleBox["\<\" | \"\>",
         StripOnInput->False,
         FontSize->14,
         FontColor->GrayLevel[0.75]], 
        InterpretationBox[
         RowBox[{"11025", "\[InvisibleSpace]", "\<\" Hz\"\>"}],
         Row[{11025, " Hz"}]]}],
       Row[{
         Row[{"0.8", " s"}], 
         Row[{11025, " Hz"}]}, 
        Style[" | ", FontSize -> 14, FontColor -> GrayLevel[0.75]]]], 
      "DialogStyle",
      StripOnInput->False], {355, -159}, Scaled[{1, 0}]], 
    TagBox[
     TooltipBox[
      TagBox[{
        {GrayLevel[0.9], RectangleBox[{5, -158}, {29, -135}]}, 
        {GrayLevel[0.3], 
         PolygonBox[
          NCache[{{13, -153}, {13, -140}, {21, Rational[-293, 2]}, {
            13, -153}}, {{13, -153}, {13, -140}, {21, -146.5}, {
            13, -153}}]]}, 
        {GrayLevel[0.5], 
         StyleBox[
          LineBox[{{5, -158}, {5, -135}, {29, -135}, {29, -158}, {5, -158}}],
          Antialiasing->False]}},
       EventHandlerTag[{"MouseClicked" :> (If[None =!= None, 
            Sound`EmitMIDI[None]]; Sound`SoundDump`emitSoundThroughFE[
            SampledSoundList[CompressedData["
1:eJw8l3c41m/4/q2kErIySpFCNFQyczWMkmgSkhXZiaxEMiKRFbJl7709nstj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