(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     53334,       1460]
NotebookOptionsPosition[     49589,       1336]
NotebookOutlinePosition[     50926,       1374]
CellTagsIndexPosition[     50840,       1369]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"PlayRange" :> Documentation`HelpLookup["paclet:ref/PlayRange"], 
         "EmitSound" :> Documentation`HelpLookup["paclet:ref/EmitSound"]}, #, 
        2]& , Evaluator -> Automatic], {1->"\<\"PlayRange\"\>", 
      2->"\<\"EmitSound\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["SoundVolume", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["SoundVolume",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/SoundVolume"]], "InlineFormula"],
     " \[LineSeparator]is an option to ",
     Cell[BoxData[
      ButtonBox["Sound",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Sound"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["SoundNote",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/SoundNote"]], "InlineFormula"],
     " and related functions that specifies the relative volume of the sound \
produced."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"SoundVolume", "->", 
   StyleBox["v", "TI"]}]], "InlineFormula"],
 " specifies that a sound should be rendered at a fraction ",
 Cell[BoxData[
  StyleBox["v", "TI"]], "InlineFormula"],
 " of its default volume."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SoundVolume",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SoundVolume"]], "InlineFormula"],
 " specifications in nested ",
 Cell[BoxData[
  ButtonBox["Sound",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sound"]], "InlineFormula"],
 " objects are multiplied."
}], "Notes",
 CellID->482570345],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SoundVolume",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SoundVolume"]], "InlineFormula"],
 " in the outermost sound construct refers to sound volume relative to the \
default volume level on your computer system."
}], "Notes",
 CellID->94520715],

Cell[TextData[{
 "Effective ",
 Cell[BoxData[
  ButtonBox["SoundVolume",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SoundVolume"]], "InlineFormula"],
 " values larger than 1 may lead to distorted sounds."
}], "Notes",
 CellID->60790924]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->434244076],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->172049871],

Cell["Play two notes, at 1/4 volume and full volume: ", "ExampleText",
 CellID->134521906],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sound", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"SoundNote", "[", 
     RowBox[{"\"\<C\>\"", ",", 
      RowBox[{"SoundVolume", "\[Rule]", 
       RowBox[{"1", "/", "4"}]}]}], "]"}], ",", 
    RowBox[{"SoundNote", "[", "\"\<C\>\"", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->249374502],

Cell[BoxData[
 InterpretationBox[
  GraphicsBox[{
    {GrayLevel[0.9], RectangleBox[{0, 0}, {360, -164}]}, {InsetBox[
      GraphicsBox[
       {RGBColor[0.5, 0, 0.5], 
        StyleBox[{
          RectangleBox[{0., 0.43198696602798653`}, \
{0.95, 0.4438917279327484}], 
          RectangleBox[{1., 0.43198696602798653`}, \
{1.95, 0.4438917279327484}]},
         Antialiasing->True]},
       AspectRatio->NCache[
         Rational[6, 35], 0.17142857142857143`],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0.75],
       FrameTicks->False,
       PlotRange->All,
       PlotRangePadding->{Automatic, 0.05}], {180, -35}, 
      ImageScaled[{0.5, 0.5}], {350, 60},
      Background->GrayLevel[0.9]], InsetBox[
      GraphicsBox[
       {GrayLevel[0.6], RectangleBox[{0, 0}]},
       AspectRatio->NCache[
         Rational[6, 35], 0.17142857142857143`],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0.75],
       FrameTicks->False], {180, -100}, ImageScaled[{0.5, 0.5}], {350, 60},
      Background->GrayLevel[0.9]]}, InsetBox[
     StyleBox[
      InterpretationBox[
       InterpretationBox[
        RowBox[{"2", "\[InvisibleSpace]", "\<\" s\"\>"}],
        Row[{2, " s"}]],
       Row[{
         Row[{2, " s"}]}, 
        Style[" | ", FontSize -> 14, FontColor -> GrayLevel[0.75]]]], 
      "DialogStyle",
      StripOnInput->False], {355, -159}, Scaled[{1, 0}]], 
    TagBox[
     TooltipBox[
      TagBox[{
        {GrayLevel[0.9], RectangleBox[{5, -158}, {29, -135}]}, 
        {GrayLevel[0.3], 
         PolygonBox[
          NCache[{{13, -153}, {13, -140}, {21, Rational[-293, 2]}, {
            13, -153}}, {{13, -153}, {13, -140}, {21, -146.5}, {
            13, -153}}]]}, 
        {GrayLevel[0.5], 
         StyleBox[
          LineBox[{{5, -158}, {5, -135}, {29, -135}, {29, -158}, {5, -158}}],
          Antialiasing->False]}},
       EventHandlerTag[{"MouseClicked" :> (If[Sound`MIDISequence[{
               Sound`MIDITrack[{
                 Sound`MIDIEvent[0, "SetTempo", "Tempo" -> 1000000], 
                 Sound`MIDIEvent[
                 0, "ProgramCommand", "Channel" -> 0, "Value" -> 0], 
                 Sound`MIDIEvent[
                 0, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 31],
                  
                 Sound`MIDIEvent[
                 1, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 1, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 2, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  0]}]}, "DivisionType" -> "PPQ", "Resolution" -> 1] =!= None,
             
            Sound`EmitMIDI[
             Sound`MIDISequence[{
               Sound`MIDITrack[{
                 Sound`MIDIEvent[0, "SetTempo", "Tempo" -> 1000000], 
                 Sound`MIDIEvent[
                 0, "ProgramCommand", "Channel" -> 0, "Value" -> 0], 
                 Sound`MIDIEvent[
                 0, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 31],
                  
                 Sound`MIDIEvent[
                 1, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 1, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 2, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  0]}]}, "DivisionType" -> "PPQ", "Resolution" -> 1]]]; 
          Sound`SoundDump`emitSoundThroughFE[None, "Preemptive"]), 
         PassEventsDown -> Automatic, PassEventsUp -> True}]],
      "\"Play\""],
     Annotation[#, "Play", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[{
        {GrayLevel[0.9], RectangleBox[{34, -158}, {58, -135}]}, 
        {GrayLevel[0.3], RectangleBox[{42, -150}, {50, -143}]}, 
        {GrayLevel[0.5], 
         StyleBox[
          LineBox[{{34, -158}, {34, -135}, {58, -135}, {58, -158}, {
           34, -158}}],
          Antialiasing->False]}},
       EventHandlerTag[{
        "MouseClicked" :> (Sound`SoundDump`emitSoundThroughFE[
            SampledSoundList[{{0.}}, 8000], "Preemptive"]; 
          Sound`MIDIDump`stopMIDI[]), PassEventsDown -> Automatic, 
         PassEventsUp -> True}]],
      "\"Stop\""],
     Annotation[#, "Stop", "Tooltip"]& ], 
    {GrayLevel[0.75], 
     StyleBox[LineBox[{{0, 0}, {360, 0}, {360, -164}, {0, -164}, {0, 0}}],
      Antialiasing->False]}},
   ContentSelectable->False,
   ImageSize->250,
   PlotRange->{{0, 360}, {0, -164}},
   PlotRangePadding->1],
  Sound[{
    SoundNote["C", SoundVolume -> Rational[1, 4]], 
    SoundNote["C"]}]]], "Output",
 ImageSize->{254, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->588490110]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SoundVolume",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SoundVolume"]], "InlineFormula"],
 " works with any instrument:"
}], "ExampleText",
 CellID->432570197],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sound", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"SoundNote", "[", 
     RowBox[{"\"\<C\>\"", ",", ".5", ",", "\"\<Violin\>\"", ",", 
      RowBox[{"SoundVolume", "\[Rule]", "v"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"v", ",", "0", ",", "1", ",", 
      RowBox[{"1", "/", "4"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->467930623],

Cell[BoxData[
 InterpretationBox[
  GraphicsBox[{
    {GrayLevel[0.9], RectangleBox[{0, 0}, {360, -164}]}, {InsetBox[
      GraphicsBox[
       {Hue[-0.1599553194190092, 0.9, 0.7], 
        StyleBox[{
          RectangleBox[{0., 0.43198696602798653`}, \
{0.475, 0.4438917279327484}], 
          RectangleBox[{0.5, 0.43198696602798653`}, \
{0.975, 0.4438917279327484}], 
          RectangleBox[{1., 0.43198696602798653`}, \
{1.475, 0.4438917279327484}], 
          RectangleBox[{1.5, 0.43198696602798653`}, \
{1.975, 0.4438917279327484}], 
          RectangleBox[{2., 0.43198696602798653`}, \
{2.475, 0.4438917279327484}]},
         Antialiasing->True]},
       AspectRatio->NCache[
         Rational[6, 35], 0.17142857142857143`],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0.75],
       FrameTicks->False,
       PlotRange->All,
       PlotRangePadding->{Automatic, 0.05}], {180, -35}, 
      ImageScaled[{0.5, 0.5}], {350, 60},
      Background->GrayLevel[0.9]], InsetBox[
      GraphicsBox[
       {GrayLevel[0.6], RectangleBox[{0, 0}]},
       AspectRatio->NCache[
         Rational[6, 35], 0.17142857142857143`],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0.75],
       FrameTicks->False], {180, -100}, ImageScaled[{0.5, 0.5}], {350, 60},
      Background->GrayLevel[0.9]]}, InsetBox[
     StyleBox[
      InterpretationBox[
       InterpretationBox[
        RowBox[{"\<\"2.5\"\>", "\[InvisibleSpace]", "\<\" s\"\>"}],
        Row[{"2.5", " s"}]],
       Row[{
         Row[{"2.5", " s"}]}, 
        Style[" | ", FontSize -> 14, FontColor -> GrayLevel[0.75]]]], 
      "DialogStyle",
      StripOnInput->False], {355, -159}, Scaled[{1, 0}]], 
    TagBox[
     TooltipBox[
      TagBox[{
        {GrayLevel[0.9], RectangleBox[{5, -158}, {29, -135}]}, 
        {GrayLevel[0.3], 
         PolygonBox[
          NCache[{{13, -153}, {13, -140}, {21, Rational[-293, 2]}, {
            13, -153}}, {{13, -153}, {13, -140}, {21, -146.5}, {
            13, -153}}]]}, 
        {GrayLevel[0.5], 
         StyleBox[
          LineBox[{{5, -158}, {5, -135}, {29, -135}, {29, -158}, {5, -158}}],
          Antialiasing->False]}},
       EventHandlerTag[{"MouseClicked" :> (If[Sound`MIDISequence[{
               Sound`MIDITrack[{
                 Sound`MIDIEvent[0, "SetTempo", "Tempo" -> 1000000], 
                 Sound`MIDIEvent[
                 0, "ProgramCommand", "Channel" -> 0, "Value" -> 40], 
                 Sound`MIDIEvent[
                 0, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0], 
                 
                 Sound`MIDIEvent[
                 1, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 1, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 31],
                  
                 Sound`MIDIEvent[
                 2, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 2, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 63],
                  
                 Sound`MIDIEvent[
                 3, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 3, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 95],
                  
                 Sound`MIDIEvent[
                 4, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 4, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 5, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  0]}]}, "DivisionType" -> "PPQ", "Resolution" -> 2] =!= None,
             
            Sound`EmitMIDI[
             Sound`MIDISequence[{
               Sound`MIDITrack[{
                 Sound`MIDIEvent[0, "SetTempo", "Tempo" -> 1000000], 
                 Sound`MIDIEvent[
                 0, "ProgramCommand", "Channel" -> 0, "Value" -> 40], 
                 Sound`MIDIEvent[
                 0, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0], 
                 
                 Sound`MIDIEvent[
                 1, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 1, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 31],
                  
                 Sound`MIDIEvent[
                 2, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 2, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 63],
                  
                 Sound`MIDIEvent[
                 3, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 3, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 95],
                  
                 Sound`MIDIEvent[
                 4, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 4, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 5, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  0]}]}, "DivisionType" -> "PPQ", "Resolution" -> 2]]]; 
          Sound`SoundDump`emitSoundThroughFE[None, "Preemptive"]), 
         PassEventsDown -> Automatic, PassEventsUp -> True}]],
      "\"Play\""],
     Annotation[#, "Play", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[{
        {GrayLevel[0.9], RectangleBox[{34, -158}, {58, -135}]}, 
        {GrayLevel[0.3], RectangleBox[{42, -150}, {50, -143}]}, 
        {GrayLevel[0.5], 
         StyleBox[
          LineBox[{{34, -158}, {34, -135}, {58, -135}, {58, -158}, {
           34, -158}}],
          Antialiasing->False]}},
       EventHandlerTag[{
        "MouseClicked" :> (Sound`SoundDump`emitSoundThroughFE[
            SampledSoundList[{{0.}}, 8000], "Preemptive"]; 
          Sound`MIDIDump`stopMIDI[]), PassEventsDown -> Automatic, 
         PassEventsUp -> True}]],
      "\"Stop\""],
     Annotation[#, "Stop", "Tooltip"]& ], 
    {GrayLevel[0.75], 
     StyleBox[LineBox[{{0, 0}, {360, 0}, {360, -164}, {0, -164}, {0, 0}}],
      Antialiasing->False]}},
   ContentSelectable->False,
   ImageSize->250,
   PlotRange->{{0, 360}, {0, -164}},
   PlotRangePadding->1],
  Sound[{
    SoundNote["C", 0.5, "Violin", SoundVolume -> 0], 
    SoundNote["C", 0.5, "Violin", SoundVolume -> Rational[1, 4]], 
    SoundNote["C", 0.5, "Violin", SoundVolume -> Rational[1, 2]], 
    SoundNote["C", 0.5, "Violin", SoundVolume -> Rational[3, 4]], 
    SoundNote["C", 0.5, "Violin", SoundVolume -> 1]}]]], "Output",
 ImageSize->{254, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->214495546]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5181212],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SoundVolume",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SoundVolume"]], "InlineFormula"],
 " works with percussion:"
}], "ExampleText",
 CellID->501247853],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sound", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"SoundNote", "[", 
     RowBox[{"\"\<HighBongo\>\"", ",", ".2", ",", 
      RowBox[{"SoundVolume", "\[Rule]", "v"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"v", ",", "0", ",", "1", ",", 
      RowBox[{"1", "/", "4"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->187117538],

Cell[BoxData[
 InterpretationBox[
  GraphicsBox[{
    {GrayLevel[0.9], RectangleBox[{0, 0}, {360, -164}]}, {InsetBox[
      GraphicsBox[
       {RGBColor[0.5, 0, 0.5], 
        StyleBox[{
          RectangleBox[{0., 0.43198696602798653`}, \
{0.19, 0.4438917279327484}], 
          RectangleBox[{0.2, 0.43198696602798653`}, \
{0.39, 0.4438917279327484}], 
          RectangleBox[{0.4, 0.43198696602798653`}, \
{0.59, 0.4438917279327484}], 
          RectangleBox[{0.6, 0.43198696602798653`}, \
{0.79, 0.4438917279327484}], 
          RectangleBox[{0.8, 0.43198696602798653`}, \
{0.99, 0.4438917279327484}]},
         Antialiasing->True]},
       AspectRatio->NCache[
         Rational[6, 35], 0.17142857142857143`],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0.75],
       FrameTicks->False,
       PlotRange->All,
       PlotRangePadding->{Automatic, 0.05}], {180, -35}, 
      ImageScaled[{0.5, 0.5}], {350, 60},
      Background->GrayLevel[0.9]], InsetBox[
      GraphicsBox[
       {GrayLevel[0.6], RectangleBox[{0, 0}]},
       AspectRatio->NCache[
         Rational[6, 35], 0.17142857142857143`],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0.75],
       FrameTicks->False], {180, -100}, ImageScaled[{0.5, 0.5}], {350, 60},
      Background->GrayLevel[0.9]]}, InsetBox[
     StyleBox[
      InterpretationBox[
       InterpretationBox[
        RowBox[{"1", "\[InvisibleSpace]", "\<\" s\"\>"}],
        Row[{1, " s"}]],
       Row[{
         Row[{1, " s"}]}, 
        Style[" | ", FontSize -> 14, FontColor -> GrayLevel[0.75]]]], 
      "DialogStyle",
      StripOnInput->False], {355, -159}, Scaled[{1, 0}]], 
    TagBox[
     TooltipBox[
      TagBox[{
        {GrayLevel[0.9], RectangleBox[{5, -158}, {29, -135}]}, 
        {GrayLevel[0.3], 
         PolygonBox[
          NCache[{{13, -153}, {13, -140}, {21, Rational[-293, 2]}, {
            13, -153}}, {{13, -153}, {13, -140}, {21, -146.5}, {13, -153}}]]},
         
        {GrayLevel[0.5], 
         StyleBox[
          LineBox[{{5, -158}, {5, -135}, {29, -135}, {29, -158}, {5, -158}}],
          Antialiasing->False]}},
       EventHandlerTag[{"MouseClicked" :> (If[Sound`MIDISequence[{
               Sound`MIDITrack[{
                 Sound`MIDIEvent[0, "SetTempo", "Tempo" -> 1000000], 
                 Sound`MIDIEvent[
                 0, "ProgramCommand", "Channel" -> 9, "Value" -> 0], 
                 Sound`MIDIEvent[
                 0, "NoteOn", "Note" -> 60, "Channel" -> 9, "Velocity" -> 0], 
                 
                 Sound`MIDIEvent[
                 1, "NoteOff", "Note" -> 60, "Channel" -> 9, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 1, "NoteOn", "Note" -> 60, "Channel" -> 9, "Velocity" -> 31],
                  
                 Sound`MIDIEvent[
                 2, "NoteOff", "Note" -> 60, "Channel" -> 9, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 2, "NoteOn", "Note" -> 60, "Channel" -> 9, "Velocity" -> 63],
                  
                 Sound`MIDIEvent[
                 3, "NoteOff", "Note" -> 60, "Channel" -> 9, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 3, "NoteOn", "Note" -> 60, "Channel" -> 9, "Velocity" -> 95],
                  
                 Sound`MIDIEvent[
                 4, "NoteOff", "Note" -> 60, "Channel" -> 9, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 4, "NoteOn", "Note" -> 60, "Channel" -> 9, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 5, "NoteOff", "Note" -> 60, "Channel" -> 9, "Velocity" -> 
                  0]}]}, "DivisionType" -> "PPQ", "Resolution" -> 5] =!= None,
             
            Sound`EmitMIDI[
             Sound`MIDISequence[{
               Sound`MIDITrack[{
                 Sound`MIDIEvent[0, "SetTempo", "Tempo" -> 1000000], 
                 Sound`MIDIEvent[
                 0, "ProgramCommand", "Channel" -> 9, "Value" -> 0], 
                 Sound`MIDIEvent[
                 0, "NoteOn", "Note" -> 60, "Channel" -> 9, "Velocity" -> 0], 
                 
                 Sound`MIDIEvent[
                 1, "NoteOff", "Note" -> 60, "Channel" -> 9, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 1, "NoteOn", "Note" -> 60, "Channel" -> 9, "Velocity" -> 31],
                  
                 Sound`MIDIEvent[
                 2, "NoteOff", "Note" -> 60, "Channel" -> 9, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 2, "NoteOn", "Note" -> 60, "Channel" -> 9, "Velocity" -> 63],
                  
                 Sound`MIDIEvent[
                 3, "NoteOff", "Note" -> 60, "Channel" -> 9, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 3, "NoteOn", "Note" -> 60, "Channel" -> 9, "Velocity" -> 95],
                  
                 Sound`MIDIEvent[
                 4, "NoteOff", "Note" -> 60, "Channel" -> 9, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 4, "NoteOn", "Note" -> 60, "Channel" -> 9, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 5, "NoteOff", "Note" -> 60, "Channel" -> 9, "Velocity" -> 
                  0]}]}, "DivisionType" -> "PPQ", "Resolution" -> 5]]]; 
          Sound`SoundDump`emitSoundThroughFE[None, "Preemptive"]), 
         PassEventsDown -> Automatic, PassEventsUp -> True}]],
      "\"Play\""],
     Annotation[#, "Play", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[{
        {GrayLevel[0.9], RectangleBox[{34, -158}, {58, -135}]}, 
        {GrayLevel[0.3], RectangleBox[{42, -150}, {50, -143}]}, 
        {GrayLevel[0.5], 
         StyleBox[
          LineBox[{{34, -158}, {34, -135}, {58, -135}, {58, -158}, {
           34, -158}}],
          Antialiasing->False]}},
       EventHandlerTag[{
        "MouseClicked" :> (Sound`SoundDump`emitSoundThroughFE[
            SampledSoundList[{{0.}}, 8000], "Preemptive"]; 
          Sound`MIDIDump`stopMIDI[]), PassEventsDown -> Automatic, 
         PassEventsUp -> True}]],
      "\"Stop\""],
     Annotation[#, "Stop", "Tooltip"]& ], 
    {GrayLevel[0.75], 
     StyleBox[LineBox[{{0, 0}, {360, 0}, {360, -164}, {0, -164}, {0, 0}}],
      Antialiasing->False]}},
   ContentSelectable->False,
   ImageSize->250,
   PlotRange->{{0, 360}, {0, -164}},
   PlotRangePadding->1],
  Sound[{
    SoundNote["HighBongo", 0.2, SoundVolume -> 0], 
    SoundNote["HighBongo", 0.2, SoundVolume -> Rational[1, 4]], 
    SoundNote["HighBongo", 0.2, SoundVolume -> Rational[1, 2]], 
    SoundNote["HighBongo", 0.2, SoundVolume -> Rational[3, 4]], 
    SoundNote["HighBongo", 0.2, SoundVolume -> 1]}]]], "Output",
 ImageSize->{254, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->82759044]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->245778647],

Cell[TextData[{
 "Nested uses of ",
 Cell[BoxData[
  ButtonBox["SoundVolume",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SoundVolume"]], "InlineFormula"],
 " are multiplied:"
}], "ExampleText",
 CellID->493945476],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sound", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"SoundNote", "[", 
      RowBox[{"i", ",", ".1", ",", 
       RowBox[{"SoundVolume", "\[Rule]", 
        RowBox[{"i", "/", "8"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "8"}], "}"}]}], "]"}], ",", 
   RowBox[{"SoundVolume", "\[Rule]", 
    RowBox[{"1", "/", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->258599538],

Cell[BoxData[
 InterpretationBox[
  GraphicsBox[{
    {GrayLevel[0.9], RectangleBox[{0, 0}, {360, -164}]}, {InsetBox[
      GraphicsBox[
       {RGBColor[0.5, 0, 0.5], 
        StyleBox[{
          RectangleBox[{0., 0.4438917279327484}, \
{0.095, 0.45579648983751037`}], 
          RectangleBox[{0.1, 0.45579648983751037`}, \
{0.195, 0.4677012517422721}], 
          RectangleBox[{0.2, 0.4677012517422721}, \
{0.295, 0.4796060136470343}], 
          RectangleBox[{0.3, 0.4796060136470343}, \
{0.395, 0.49151077555179606`}], 
          RectangleBox[{0.4, 0.49151077555179606`}, \
{0.495, 0.5034155374565581}], 
          RectangleBox[{0.5, 0.5034155374565581}, \
{0.595, 0.5153202993613198}], 
          RectangleBox[{0.6, 0.5153202993613198}, \
{0.695, 0.5272250612660818}], 
          RectangleBox[{0.7, 0.5272250612660818}, \
{0.795, 0.5391298231708438}]},
         Antialiasing->True]},
       AspectRatio->NCache[
         Rational[6, 35], 0.17142857142857143`],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0.75],
       FrameTicks->False,
       PlotRange->All,
       PlotRangePadding->{Automatic, 0.05}], {180, -35}, 
      ImageScaled[{0.5, 0.5}], {350, 60},
      Background->GrayLevel[0.9]], InsetBox[
      GraphicsBox[
       {GrayLevel[0.6], RectangleBox[{0, 0}]},
       AspectRatio->NCache[
         Rational[6, 35], 0.17142857142857143`],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0.75],
       FrameTicks->False], {180, -100}, ImageScaled[{0.5, 0.5}], {350, 60},
      Background->GrayLevel[0.9]]}, InsetBox[
     StyleBox[
      InterpretationBox[
       InterpretationBox[
        RowBox[{"\<\"0.8\"\>", "\[InvisibleSpace]", "\<\" s\"\>"}],
        Row[{"0.8", " s"}]],
       Row[{
         Row[{"0.8", " s"}]}, 
        Style[" | ", FontSize -> 14, FontColor -> GrayLevel[0.75]]]], 
      "DialogStyle",
      StripOnInput->False], {355, -159}, Scaled[{1, 0}]], 
    TagBox[
     TooltipBox[
      TagBox[{
        {GrayLevel[0.9], RectangleBox[{5, -158}, {29, -135}]}, 
        {GrayLevel[0.3], 
         PolygonBox[
          NCache[{{13, -153}, {13, -140}, {21, Rational[-293, 2]}, {
            13, -153}}, {{13, -153}, {13, -140}, {21, -146.5}, {
            13, -153}}]]}, 
        {GrayLevel[0.5], 
         StyleBox[
          LineBox[{{5, -158}, {5, -135}, {29, -135}, {29, -158}, {5, -158}}],
          Antialiasing->False]}},
       EventHandlerTag[{"MouseClicked" :> (If[Sound`MIDISequence[{
               Sound`MIDITrack[{
                 Sound`MIDIEvent[0, "SetTempo", "Tempo" -> 1000000], 
                 Sound`MIDIEvent[
                 0, "ProgramCommand", "Channel" -> 0, "Value" -> 0], 
                 Sound`MIDIEvent[
                 0, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 7], 
                 
                 Sound`MIDIEvent[
                 1, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 1, "NoteOn", "Note" -> 62, "Channel" -> 0, "Velocity" -> 15],
                  
                 Sound`MIDIEvent[
                 2, "NoteOff", "Note" -> 62, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 2, "NoteOn", "Note" -> 63, "Channel" -> 0, "Velocity" -> 23],
                  
                 Sound`MIDIEvent[
                 3, "NoteOff", "Note" -> 63, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 3, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 31],
                  
                 Sound`MIDIEvent[
                 4, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 4, "NoteOn", "Note" -> 65, "Channel" -> 0, "Velocity" -> 39],
                  
                 Sound`MIDIEvent[
                 5, "NoteOff", "Note" -> 65, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 5, "NoteOn", "Note" -> 66, "Channel" -> 0, "Velocity" -> 47],
                  
                 Sound`MIDIEvent[
                 6, "NoteOff", "Note" -> 66, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 6, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 55],
                  
                 Sound`MIDIEvent[
                 7, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 7, "NoteOn", "Note" -> 68, "Channel" -> 0, "Velocity" -> 63],
                  
                 Sound`MIDIEvent[
                 8, "NoteOff", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  0]}]}, "DivisionType" -> "PPQ", "Resolution" -> 10] =!= 
            None, 
            Sound`EmitMIDI[
             Sound`MIDISequence[{
               Sound`MIDITrack[{
                 Sound`MIDIEvent[0, "SetTempo", "Tempo" -> 1000000], 
                 Sound`MIDIEvent[
                 0, "ProgramCommand", "Channel" -> 0, "Value" -> 0], 
                 Sound`MIDIEvent[
                 0, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 7], 
                 
                 Sound`MIDIEvent[
                 1, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 1, "NoteOn", "Note" -> 62, "Channel" -> 0, "Velocity" -> 15],
                  
                 Sound`MIDIEvent[
                 2, "NoteOff", "Note" -> 62, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 2, "NoteOn", "Note" -> 63, "Channel" -> 0, "Velocity" -> 23],
                  
                 Sound`MIDIEvent[
                 3, "NoteOff", "Note" -> 63, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 3, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 31],
                  
                 Sound`MIDIEvent[
                 4, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 4, "NoteOn", "Note" -> 65, "Channel" -> 0, "Velocity" -> 39],
                  
                 Sound`MIDIEvent[
                 5, "NoteOff", "Note" -> 65, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 5, "NoteOn", "Note" -> 66, "Channel" -> 0, "Velocity" -> 47],
                  
                 Sound`MIDIEvent[
                 6, "NoteOff", "Note" -> 66, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 6, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 55],
                  
                 Sound`MIDIEvent[
                 7, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 7, "NoteOn", "Note" -> 68, "Channel" -> 0, "Velocity" -> 63],
                  
                 Sound`MIDIEvent[
                 8, "NoteOff", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  0]}]}, "DivisionType" -> "PPQ", "Resolution" -> 10]]]; 
          Sound`SoundDump`emitSoundThroughFE[None, "Preemptive"]), 
         PassEventsDown -> Automatic, PassEventsUp -> True}]],
      "\"Play\""],
     Annotation[#, "Play", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[{
        {GrayLevel[0.9], RectangleBox[{34, -158}, {58, -135}]}, 
        {GrayLevel[0.3], RectangleBox[{42, -150}, {50, -143}]}, 
        {GrayLevel[0.5], 
         StyleBox[
          LineBox[{{34, -158}, {34, -135}, {58, -135}, {58, -158}, {
           34, -158}}],
          Antialiasing->False]}},
       EventHandlerTag[{
        "MouseClicked" :> (Sound`SoundDump`emitSoundThroughFE[
            SampledSoundList[{{0.}}, 8000], "Preemptive"]; 
          Sound`MIDIDump`stopMIDI[]), PassEventsDown -> Automatic, 
         PassEventsUp -> True}]],
      "\"Stop\""],
     Annotation[#, "Stop", "Tooltip"]& ], 
    {GrayLevel[0.75], 
     StyleBox[LineBox[{{0, 0}, {360, 0}, {360, -164}, {0, -164}, {0, 0}}],
      Antialiasing->False]}},
   ContentSelectable->False,
   ImageSize->250,
   PlotRange->{{0, 360}, {0, -164}},
   PlotRangePadding->1],
  Sound[{
    SoundNote[1, 0.1, SoundVolume -> Rational[1, 8]], 
    SoundNote[2, 0.1, SoundVolume -> Rational[1, 4]], 
    SoundNote[3, 0.1, SoundVolume -> Rational[3, 8]], 
    SoundNote[4, 0.1, SoundVolume -> Rational[1, 2]], 
    SoundNote[5, 0.1, SoundVolume -> Rational[5, 8]], 
    SoundNote[6, 0.1, SoundVolume -> Rational[3, 4]], 
    SoundNote[7, 0.1, SoundVolume -> Rational[7, 8]], 
    SoundNote[8, 0.1, SoundVolume -> 1]}, SoundVolume -> 
   Rational[1, 2]]]], "Output",
 ImageSize->{254, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->590000635]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->258228157],

Cell["Play a sequence of progressively louder notes:", "ExampleText",
 CellID->69188691],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sound", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"SoundNote", "[", 
     RowBox[{"\"\<C\>\"", ",", ".2", ",", 
      RowBox[{"SoundVolume", "\[Rule]", "v"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"v", ",", "0", ",", "1", ",", "0.1"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->561880915],

Cell[BoxData[
 InterpretationBox[
  GraphicsBox[{
    {GrayLevel[0.9], RectangleBox[{0, 0}, {360, -164}]}, {InsetBox[
      GraphicsBox[
       {RGBColor[0.5, 0, 0.5], 
        StyleBox[{
          RectangleBox[{0., 0.43198696602798653`}, \
{0.19, 0.4438917279327484}], 
          RectangleBox[{0.2, 0.43198696602798653`}, \
{0.39, 0.4438917279327484}], 
          RectangleBox[{0.4, 0.43198696602798653`}, \
{0.59, 0.4438917279327484}], 
          RectangleBox[{0.6, 0.43198696602798653`}, \
{0.79, 0.4438917279327484}], 
          RectangleBox[{0.8, 0.43198696602798653`}, \
{0.99, 0.4438917279327484}], 
          RectangleBox[{1., 0.43198696602798653`}, \
{1.19, 0.4438917279327484}], 
          RectangleBox[{1.2, 0.43198696602798653`}, \
{1.39, 0.4438917279327484}], 
          RectangleBox[{1.4, 0.43198696602798653`}, \
{1.59, 0.4438917279327484}], 
          RectangleBox[{1.6, 0.43198696602798653`}, \
{1.79, 0.4438917279327484}], 
          RectangleBox[{1.8, 0.43198696602798653`}, \
{1.99, 0.4438917279327484}], 
          RectangleBox[{2., 0.43198696602798653`}, \
{2.1900000000000004`, 0.4438917279327484}]},
         Antialiasing->True]},
       AspectRatio->NCache[
         Rational[6, 35], 0.17142857142857143`],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0.75],
       FrameTicks->False,
       PlotRange->All,
       PlotRangePadding->{Automatic, 0.05}], {180, -35}, 
      ImageScaled[{0.5, 0.5}], {350, 60},
      Background->GrayLevel[0.9]], InsetBox[
      GraphicsBox[
       {GrayLevel[0.6], RectangleBox[{0, 0}]},
       AspectRatio->NCache[
         Rational[6, 35], 0.17142857142857143`],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0.75],
       FrameTicks->False], {180, -100}, ImageScaled[{0.5, 0.5}], {350, 60},
      Background->GrayLevel[0.9]]}, InsetBox[
     StyleBox[
      InterpretationBox[
       InterpretationBox[
        RowBox[{"\<\"2.2\"\>", "\[InvisibleSpace]", "\<\" s\"\>"}],
        Row[{"2.2", " s"}]],
       Row[{
         Row[{"2.2", " s"}]}, 
        Style[" | ", FontSize -> 14, FontColor -> GrayLevel[0.75]]]], 
      "DialogStyle",
      StripOnInput->False], {355, -159}, Scaled[{1, 0}]], 
    TagBox[
     TooltipBox[
      TagBox[{
        {GrayLevel[0.9], RectangleBox[{5, -158}, {29, -135}]}, 
        {GrayLevel[0.3], 
         PolygonBox[
          NCache[{{13, -153}, {13, -140}, {21, Rational[-293, 2]}, {
            13, -153}}, {{13, -153}, {13, -140}, {21, -146.5}, {
            13, -153}}]]}, 
        {GrayLevel[0.5], 
         StyleBox[
          LineBox[{{5, -158}, {5, -135}, {29, -135}, {29, -158}, {5, -158}}],
          Antialiasing->False]}},
       EventHandlerTag[{"MouseClicked" :> (If[Sound`MIDISequence[{
               Sound`MIDITrack[{
                 Sound`MIDIEvent[0, "SetTempo", "Tempo" -> 1000000], 
                 Sound`MIDIEvent[
                 0, "ProgramCommand", "Channel" -> 0, "Value" -> 0], 
                 Sound`MIDIEvent[
                 0, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0], 
                 
                 Sound`MIDIEvent[
                 1, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 1, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 12],
                  
                 Sound`MIDIEvent[
                 2, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 2, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 25],
                  
                 Sound`MIDIEvent[
                 3, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 3, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 38],
                  
                 Sound`MIDIEvent[
                 4, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 4, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 50],
                  
                 Sound`MIDIEvent[
                 5, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 5, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 63],
                  
                 Sound`MIDIEvent[
                 6, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 6, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 76],
                  
                 Sound`MIDIEvent[
                 7, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 7, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 88],
                  
                 Sound`MIDIEvent[
                 8, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 8, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  101], 
                 Sound`MIDIEvent[
                 9, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 9, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  114], 
                 Sound`MIDIEvent[
                 10, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 10, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 11, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  0]}]}, "DivisionType" -> "PPQ", "Resolution" -> 5] =!= None,
             
            Sound`EmitMIDI[
             Sound`MIDISequence[{
               Sound`MIDITrack[{
                 Sound`MIDIEvent[0, "SetTempo", "Tempo" -> 1000000], 
                 Sound`MIDIEvent[
                 0, "ProgramCommand", "Channel" -> 0, "Value" -> 0], 
                 Sound`MIDIEvent[
                 0, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0], 
                 
                 Sound`MIDIEvent[
                 1, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 1, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 12],
                  
                 Sound`MIDIEvent[
                 2, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 2, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 25],
                  
                 Sound`MIDIEvent[
                 3, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 3, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 38],
                  
                 Sound`MIDIEvent[
                 4, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 4, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 50],
                  
                 Sound`MIDIEvent[
                 5, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 5, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 63],
                  
                 Sound`MIDIEvent[
                 6, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 6, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 76],
                  
                 Sound`MIDIEvent[
                 7, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 7, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 88],
                  
                 Sound`MIDIEvent[
                 8, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 8, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  101], 
                 Sound`MIDIEvent[
                 9, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 9, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  114], 
                 Sound`MIDIEvent[
                 10, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 10, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 11, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  0]}]}, "DivisionType" -> "PPQ", "Resolution" -> 5]]]; 
          Sound`SoundDump`emitSoundThroughFE[None, "Preemptive"]), 
         PassEventsDown -> Automatic, PassEventsUp -> True}]],
      "\"Play\""],
     Annotation[#, "Play", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[{
        {GrayLevel[0.9], RectangleBox[{34, -158}, {58, -135}]}, 
        {GrayLevel[0.3], RectangleBox[{42, -150}, {50, -143}]}, 
        {GrayLevel[0.5], 
         StyleBox[
          LineBox[{{34, -158}, {34, -135}, {58, -135}, {58, -158}, {
           34, -158}}],
          Antialiasing->False]}},
       EventHandlerTag[{
        "MouseClicked" :> (Sound`SoundDump`emitSoundThroughFE[
            SampledSoundList[{{0.}}, 8000], "Preemptive"]; 
          Sound`MIDIDump`stopMIDI[]), PassEventsDown -> Automatic, 
         PassEventsUp -> True}]],
      "\"Stop\""],
     Annotation[#, "Stop", "Tooltip"]& ], 
    {GrayLevel[0.75], 
     StyleBox[LineBox[{{0, 0}, {360, 0}, {360, -164}, {0, -164}, {0, 0}}],
      Antialiasing->False]}},
   ContentSelectable->False,
   ImageSize->250,
   PlotRange->{{0, 360}, {0, -164}},
   PlotRangePadding->1],
  Sound[{
    SoundNote["C", 0.2, SoundVolume -> 0.], 
    SoundNote["C", 0.2, SoundVolume -> 0.1], 
    SoundNote["C", 0.2, SoundVolume -> 0.2], 
    SoundNote["C", 0.2, SoundVolume -> 0.30000000000000004`], 
    SoundNote["C", 0.2, SoundVolume -> 0.4], 
    SoundNote["C", 0.2, SoundVolume -> 0.5], 
    SoundNote["C", 0.2, SoundVolume -> 0.6000000000000001], 
    SoundNote["C", 0.2, SoundVolume -> 0.7000000000000001], 
    SoundNote["C", 0.2, SoundVolume -> 0.8], 
    SoundNote["C", 0.2, SoundVolume -> 0.9], 
    SoundNote["C", 0.2, SoundVolume -> 1.]}]]], "Output",
 ImageSize->{254, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->32981633]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlayRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlayRange"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EmitSound",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EmitSound"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell["New in 6.0", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SoundVolume - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 21, 57.0282696}", "context" -> "System`", 
    "keywords" -> {
     "sound volume", "loudness", "amplitude", "intensity", "decibels"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "SoundVolume is an option to Sound and SoundNote and related functions \
that specifies the relative volume of the sound produced.", "synonyms" -> {}, 
    "title" -> "SoundVolume", "type" -> "Symbol", "uri" -> 
    "ref/SoundVolume"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5372, 175, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->434244076]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 50697, 1362}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 658, 15, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1281, 42, 1576, 37, 70, "ObjectNameGrid"],
Cell[2860, 81, 781, 24, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[3678, 110, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4156, 127, 287, 9, 70, "Notes",
 CellID->1067943069],
Cell[4446, 138, 345, 12, 70, "Notes",
 CellID->482570345],
Cell[4794, 152, 296, 8, 70, "Notes",
 CellID->94520715],
Cell[5093, 162, 242, 8, 70, "Notes",
 CellID->60790924]
}, Closed]],
Cell[CellGroupData[{
Cell[5372, 175, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->434244076],
Cell[CellGroupData[{
Cell[5757, 189, 148, 5, 70, "ExampleSection",
 CellID->172049871],
Cell[5908, 196, 90, 1, 70, "ExampleText",
 CellID->134521906],
Cell[CellGroupData[{
Cell[6023, 201, 337, 10, 28, "Input",
 CellID->249374502],
Cell[6363, 213, 4954, 125, 136, "Output",
 CellID->588490110]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11366, 344, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[11590, 353, 210, 7, 70, "ExampleText",
 CellID->432570197],
Cell[CellGroupData[{
Cell[11825, 364, 404, 11, 70, "Input",
 CellID->467930623],
Cell[12232, 377, 7061, 170, 70, "Output",
 CellID->214495546]
}, Open  ]],
Cell[19308, 550, 123, 3, 70, "ExampleDelimiter",
 CellID->5181212],
Cell[19434, 555, 206, 7, 70, "ExampleText",
 CellID->501247853],
Cell[CellGroupData[{
Cell[19665, 566, 389, 11, 70, "Input",
 CellID->187117538],
Cell[20057, 579, 7010, 170, 70, "Output",
 CellID->82759044]
}, Open  ]],
Cell[27082, 752, 125, 3, 70, "ExampleDelimiter",
 CellID->245778647],
Cell[27210, 757, 219, 8, 70, "ExampleText",
 CellID->493945476],
Cell[CellGroupData[{
Cell[27454, 769, 450, 14, 70, "Input",
 CellID->258599538],
Cell[27907, 785, 9030, 216, 70, "Output",
 CellID->590000635]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[36986, 1007, 227, 7, 70, "ExampleSection",
 CellID->258228157],
Cell[37216, 1016, 88, 1, 70, "ExampleText",
 CellID->69188691],
Cell[CellGroupData[{
Cell[37329, 1021, 359, 11, 70, "Input",
 CellID->561880915],
Cell[37691, 1034, 10985, 260, 70, "Output",
 CellID->32981633]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[48737, 1301, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[49056, 1312, 459, 17, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[49530, 1332, 29, 0, 70, "History"],
Cell[49562, 1334, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

