(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     40580,       1536]
NotebookOptionsPosition[     32769,       1263]
NotebookOutlinePosition[     34336,       1305]
CellTagsIndexPosition[     34250,       1300]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Constructing Lists" :> 
          Documentation`HelpLookup["paclet:tutorial/ConstructingLists"], 
          "Collecting Expressions During Evaluation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/CollectingExpressionsDuringEvaluation"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Constructing Lists\"\>", 
       2->"\<\"Collecting Expressions During Evaluation\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Reap" :> Documentation`HelpLookup["paclet:ref/Reap"], "Throw" :> 
          Documentation`HelpLookup["paclet:ref/Throw"], "AppendTo" :> 
          Documentation`HelpLookup["paclet:ref/AppendTo"], 
          "EvaluationMonitor" :> 
          Documentation`HelpLookup["paclet:ref/EvaluationMonitor"], 
          "StepMonitor" :> Documentation`HelpLookup["paclet:ref/StepMonitor"],
           "Monitor" :> Documentation`HelpLookup["paclet:ref/Monitor"], 
          "Scan" :> Documentation`HelpLookup["paclet:ref/Scan"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Reap\"\>", 2->"\<\"Throw\"\>", 
       3->"\<\"AppendTo\"\>", 4->"\<\"EvaluationMonitor\"\>", 
       5->"\<\"StepMonitor\"\>", 6->"\<\"Monitor\"\>", 
       7->"\<\"Scan\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Constructing Lists" :> 
          Documentation`HelpLookup["paclet:guide/ConstructingLists"], 
          "Language Overview" :> 
          Documentation`HelpLookup["paclet:guide/LanguageOverview"], 
          "List Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/ListManipulation"], 
          "Tuning & Debugging" :> 
          Documentation`HelpLookup["paclet:guide/TuningAndDebugging"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Constructing Lists\"\>", 
       2->"\<\"Language Overview\"\>", 3->"\<\"List Manipulation\"\>", 
       4->"\<\"Tuning & Debugging\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Sow", "ObjectName",
 CellID->16184],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Sow",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Sow"], "[", 
       StyleBox["e", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]specifies that ",
     Cell[BoxData[
      StyleBox["e", "TI"]], "InlineFormula"],
     " should be collected by the nearest enclosing ",
     Cell[BoxData[
      ButtonBox["Reap",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Reap"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Sow",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Sow"], "[", 
       RowBox[{
        StyleBox["e", "TI"], ",", 
        StyleBox["tag", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]specifies that ",
     Cell[BoxData[
      StyleBox["e", "TI"]], "InlineFormula"],
     " should be collected by the nearest enclosing ",
     Cell[BoxData[
      ButtonBox["Reap",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Reap"]], "InlineFormula"],
     " whose pattern matches ",
     Cell[BoxData[
      StyleBox["tag", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Sow",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Sow"], "[", 
       RowBox[{
        StyleBox["e", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["tag", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["tag", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]specifies that ",
     Cell[BoxData[
      StyleBox["e", "TI"]], "InlineFormula"],
     " should be collected once for each pattern that matches a ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["tag", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->10217]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sow"], "[", 
   RowBox[{
    StyleBox["e", "TI"], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  StyleBox["e", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->29261],

Cell[TextData[{
 "By having several identical ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["tag", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ", a single expression can be made to appear multiple times in a list \
returned by ",
 Cell[BoxData[
  ButtonBox["Reap",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reap"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->16679],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sow"], "[", 
   StyleBox["e", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sow"], "[", 
   RowBox[{
    StyleBox["e", "TI"], ",", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->22579],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sow"], "[", 
   RowBox[{
    StyleBox["e", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      StyleBox["tag", "TI"], "}"}], "}"}]}], "]"}]], "InlineFormula"],
 " sows an expression with tag ",
 Cell[BoxData[
  RowBox[{"{", 
   StyleBox["tag", "TI"], "}"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->7989]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->186839116],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->91833090],

Cell[TextData[{
 "Evaluate a sequence of expressions, \[OpenCurlyDoubleQuote]sowing",
 "\[CloseCurlyDoubleQuote]",
 " some to be collected by ",
 Cell[BoxData[
  ButtonBox["Reap",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reap"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->22333],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reap", "[", 
  RowBox[{
   RowBox[{"Sow", "[", "a", "]"}], ";", "b", ";", 
   RowBox[{"Sow", "[", "c", "]"}], ";", 
   RowBox[{"Sow", "[", "d", "]"}], ";", "e"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12535],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"e", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"a", ",", "c", ",", "d"}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->26828]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6578],

Cell[TextData[{
 "Compute a sum, ",
 "\[OpenCurlyDoubleQuote]sowing\[CloseCurlyDoubleQuote]",
 " ",
 Cell[BoxData[
  RowBox[{"i", "^", "2"}]], "InlineFormula"],
 " at each step:"
}], "ExampleText",
 CellID->18301],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reap", "[", 
  RowBox[{"Sum", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sow", "[", 
      RowBox[{"i", "^", "2"}], "]"}], "+", "1"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "10"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24472],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"395", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "4", ",", "9", ",", "16", ",", "25", ",", "36", ",", "49", ",",
       "64", ",", "81", ",", "100"}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{305, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18948]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27899],

Cell["\<\
Make separate lists for expressions \[OpenCurlyDoubleQuote]sown\
\[CloseCurlyDoubleQuote] with different tags:\
\>", "ExampleText",
 CellID->11794],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reap", "[", 
  RowBox[{
   RowBox[{"Sow", "[", 
    RowBox[{"1", ",", "x"}], "]"}], ";", 
   RowBox[{"Sow", "[", 
    RowBox[{"2", ",", "y"}], "]"}], ";", 
   RowBox[{"Sow", "[", 
    RowBox[{"3", ",", "x"}], "]"}], ";", 
   RowBox[{"Sow", "[", 
    RowBox[{"4", ",", "y"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15051],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{140, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->31440]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17824],

Cell[TextData[{
 "Reap only expressions \[OpenCurlyDoubleQuote]sown\[CloseCurlyDoubleQuote] \
with tag ",
 Cell[BoxData["x"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->19527],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reap", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sow", "[", 
     RowBox[{"1", ",", "x"}], "]"}], ";", 
    RowBox[{"Sow", "[", 
     RowBox[{"2", ",", "y"}], "]"}], ";", 
    RowBox[{"Sow", "[", 
     RowBox[{"3", ",", "x"}], "]"}], ";", 
    RowBox[{"Sow", "[", 
     RowBox[{"4", ",", "y"}], "]"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11265],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3"}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30452]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11549],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sow"]], "InlineFormula"],
 " can be used anywhere in a computation:"
}], "ExampleText",
 CellID->26756],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reap", "[", 
  RowBox[{
   RowBox[{"MapAll", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"PrimeQ", "[", "#", "]"}], ",", 
        RowBox[{"Sow", "[", "#", "]"}]}], "]"}], "&"}], ",", 
     RowBox[{"Integrate", "[", 
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"x", "^", "5"}], "-", "1"}], ")"}]}], ",", "x"}], "]"}]}], 
    "]"}], ";"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23452],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Null", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "2"}], ",", "2", ",", "5", ",", "5", ",", "2", ",", "5", 
      ",", "5", ",", "5", ",", 
      RowBox[{"-", "2"}], ",", 
      RowBox[{"-", "2"}], ",", "5", ",", 
      RowBox[{"-", "2"}], ",", "5", ",", "5", ",", "5", ",", "5", ",", "2", 
      ",", "5", ",", "5", ",", "2"}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{469, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9690]
}, Open  ]],

Cell["It still works inside a function:", "ExampleText",
 CellID->25151],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "e_", "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"PrimeQ", "[", "e", "]"}], ",", 
    RowBox[{"Sow", "[", "e", "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2722],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reap", "[", 
  RowBox[{
   RowBox[{"MapAll", "[", 
    RowBox[{"f", ",", 
     RowBox[{"Integrate", "[", 
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"x", "^", "5"}], "-", "1"}], ")"}]}], ",", "x"}], "]"}]}], 
    "]"}], ";"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->11248],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Null", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "2"}], ",", "2", ",", "5", ",", "5", ",", "2", ",", "5", 
      ",", "5", ",", "5", ",", 
      RowBox[{"-", "2"}], ",", 
      RowBox[{"-", "2"}], ",", "5", ",", 
      RowBox[{"-", "2"}], ",", "5", ",", "5", ",", "5", ",", "5", ",", "2", 
      ",", "5", ",", "5", ",", "2"}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{469, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->7955]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3384],

Cell["\<\
A single expression can be \
\[OpenCurlyDoubleQuote]sown\[CloseCurlyDoubleQuote] with multiple tags:\
\>", "ExampleText",
 CellID->17934],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reap", "[", 
  RowBox[{
   RowBox[{"Sow", "[", 
    RowBox[{"1", ",", "x"}], "]"}], ";", 
   RowBox[{"Sow", "[", 
    RowBox[{"2", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}], "]"}], ";", 
   RowBox[{"Sow", "[", 
    RowBox[{"3", ",", "y"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17384],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{140, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->31415]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2276],

Cell["\<\
If a single tag is repeated, the expression is sown repeatedly:\
\>", "ExampleText",
 CellID->15235],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reap", "[", 
  RowBox[{
   RowBox[{"Sow", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "x", ",", "x"}], "}"}]}], "]"}], ";", 
   RowBox[{"Sow", "[", 
    RowBox[{"2", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}], "]"}], ";", 
   RowBox[{"Sow", "[", 
    RowBox[{"3", ",", "y"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28002],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{177, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5888]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->18212],

Cell[TextData[{
 "A pattern in ",
 Cell[BoxData[
  ButtonBox["Reap",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reap"]], "InlineFormula"],
 " can be used to specify which tags to collect:"
}], "ExampleText",
 CellID->12202],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reap", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sow", "[", 
     RowBox[{"1", ",", "x"}], "]"}], ";", 
    RowBox[{"Sow", "[", 
     RowBox[{"2", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}]}], "]"}], ";", 
    RowBox[{"Sow", "[", 
     RowBox[{"3", ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", "z"}], "}"}]}], "]"}], ";", 
    RowBox[{"Sow", "[", 
     RowBox[{"4", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]}], ",", 
   RowBox[{"x", "|", "y"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19314],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "4"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{177, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30592]
}, Open  ]],

Cell[TextData[{
 "The default is the pattern ",
 Cell[BoxData["_"], "InlineFormula"],
 ", so that everything is collected:"
}], "ExampleText",
 CellID->14038],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reap", "[", 
  RowBox[{
   RowBox[{"Sow", "[", 
    RowBox[{"1", ",", "x"}], "]"}], ";", 
   RowBox[{"Sow", "[", 
    RowBox[{"2", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}], "]"}], ";", 
   RowBox[{"Sow", "[", 
    RowBox[{"3", ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "z"}], "}"}]}], "]"}], ";", 
   RowBox[{"Sow", "[", 
    RowBox[{"4", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10558],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{227, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->4089]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29795],

Cell[TextData[{
 "Tags can have any form; here they are ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->17925],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reap", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sow", "[", 
      RowBox[{"#", ",", 
       RowBox[{"#", ">", "0"}]}], "]"}], "&"}], "/@", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "1"}], ",", "2", ",", 
      RowBox[{"-", "3"}], ",", "1", ",", "4", ",", "5"}], "}"}]}], ";"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14958],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Null", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "1", ",", "4", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "3"}]}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{231, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12153]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reap", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sow", "[", 
       RowBox[{"#", ",", 
        RowBox[{"#", ">", "0"}]}], "]"}], "&"}], "/@", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "1"}], ",", "2", ",", 
       RowBox[{"-", "3"}], ",", "1", ",", "4", ",", "5"}], "}"}]}], ";"}], 
   ",", "True"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28405],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Null", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "1", ",", "4", ",", "5"}], "}"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{165, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->21596]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12132],

Cell[TextData[{
 "Make a list of all the steps taken in evaluating ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->27842],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reap", "[", 
  RowBox[{"FindRoot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], "==", "x"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "1"}], "}"}], ",", 
    RowBox[{"StepMonitor", ":>", 
     RowBox[{"Sow", "[", "x", "]"}]}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10562],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "0.7390851332151607`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
     "0.7503638678402439`", ",", "0.7391128909113617`", ",", 
      "0.739085133385284`", ",", "0.7390851332151607`"}], "}"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{408, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20422]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17888],

Cell["\<\
Evaluate an iterated map, keeping iterates that are below 1/100:\
\>", "ExampleText",
 CellID->28052],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reap", "[", 
  RowBox[{"Nest", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"#", "<", 
          RowBox[{"1", "/", "100"}]}], ",", 
         RowBox[{"Sow", "[", "#", "]"}]}], "]"}], ";", 
       RowBox[{"4", " ", "#", 
        RowBox[{"(", 
         RowBox[{"1", "-", "#"}], ")"}]}]}], ")"}], "&"}], ",", "0.2", ",", 
    "100"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17316],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.8755911297724981`", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
     "0.00024630478163611714`", ",", "0.0009849764623626413`", ",", 
      "0.003936025134924932`", ",", "0.00631450740614895`", ",", 
      "0.0026431228031336984`"}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{522, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22621]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6692],

Cell[TextData[{
 "Find equivalence classes with respect to the value of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["i", "2"], TraditionalForm]], "InlineMath"],
 " mod 10:"
}], "ExampleText",
 CellID->18148],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reap", "[", 
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{"Sow", "[", 
     RowBox[{"i", ",", 
      RowBox[{"Mod", "[", 
       RowBox[{
        RowBox[{"i", "^", "2"}], ",", "10"}], "]"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "20"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21655],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Null", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "9", ",", "11", ",", "19"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "8", ",", "12", ",", "18"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "7", ",", "13", ",", "17"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "6", ",", "14", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "15"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "20"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{585, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->28954]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1645]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4809],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sow"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ", ",
 "\[OpenCurlyDoubleQuote]sowing\[CloseCurlyDoubleQuote]",
 " it as a side effect:"
}], "ExampleText",
 CellID->8681],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sow", "[", "x", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19553],

Cell[BoxData["x"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10271]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7013],

Cell[TextData[{
 "Expressions sown are reaped by the innermost enclosing ",
 Cell[BoxData[
  ButtonBox["Reap",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reap"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->9795],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reap", "[", 
  RowBox[{"Reap", "[", 
   RowBox[{
    RowBox[{"Sow", "[", 
     RowBox[{"2", "^", "20"}], "]"}], ";", 
    RowBox[{"Sow", "[", 
     RowBox[{"2", "^", "30"}], "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12044],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1073741824", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"1048576", ",", "1073741824"}], "}"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", "}"}]}], "}"}]], "Output",
 ImageSize->{314, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21048]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17165]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->30766],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Reap",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Reap"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Throw",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Throw"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AppendTo",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AppendTo"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EvaluationMonitor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EvaluationMonitor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StepMonitor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StepMonitor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Monitor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Monitor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Scan",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Scan"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24840]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->8433],

Cell[TextData[ButtonBox["Constructing Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ConstructingLists"]], "Tutorials",
 CellID->26090],

Cell[TextData[ButtonBox["Collecting Expressions During Evaluation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/CollectingExpressionsDuringEvaluation"]], "Tutorials",
 CellID->3365]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Sow",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Sow"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->377146527],

Cell[TextData[ButtonBox["Constructing Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ConstructingLists"]], "MoreAbout",
 CellID->389038510],

Cell[TextData[ButtonBox["Language Overview",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LanguageOverview"]], "MoreAbout",
 CellID->342926975],

Cell[TextData[ButtonBox["List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListManipulation"]], "MoreAbout",
 CellID->148557985],

Cell[TextData[ButtonBox["Tuning & Debugging",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TuningAndDebugging"]], "MoreAbout",
 CellID->144142039]
}, Open  ]],

Cell["New in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Sow - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 21, 57.7157872}", "context" -> "System`", 
    "keywords" -> {
     "Append", "appending", "AppendTo", "bags", "collect", 
      "intermediate results", "list accumulation", "lists", 
      "non-local accumulation", "tags"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Sow[e] specifies that e should be collected by the nearest enclosing \
Reap. Sow[e, tag] specifies that e should be collected by the nearest \
enclosing Reap whose pattern matches tag. Sow[e, {tag_1, tag_2, ...}] \
specifies that e should be collected once for each pattern that matches a \
tag_i. ", "synonyms" -> {}, "title" -> "Sow", "type" -> "Symbol", "uri" -> 
    "ref/Sow"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8050, 265, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->186839116]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 34107, 1293}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2961, 65, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3584, 92, 41, 1, 70, "ObjectName",
 CellID->16184],
Cell[3628, 95, 2216, 72, 70, "Usage",
 CellID->10217]
}, Open  ]],
Cell[CellGroupData[{
Cell[5881, 172, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6359, 189, 337, 14, 70, "Notes",
 CellID->29261],
Cell[6699, 205, 384, 14, 70, "Notes",
 CellID->16679],
Cell[7086, 221, 497, 20, 70, "Notes",
 CellID->22579],
Cell[7586, 243, 427, 17, 70, "Notes",
 CellID->7989]
}, Closed]],
Cell[CellGroupData[{
Cell[8050, 265, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->186839116],
Cell[CellGroupData[{
Cell[8435, 279, 147, 5, 70, "ExampleSection",
 CellID->91833090],
Cell[8585, 286, 295, 10, 70, "ExampleText",
 CellID->22333],
Cell[CellGroupData[{
Cell[8905, 300, 242, 7, 28, "Input",
 CellID->12535],
Cell[9150, 309, 285, 10, 36, "Output",
 CellID->26828]
}, Open  ]],
Cell[9450, 322, 120, 3, 70, "ExampleDelimiter",
 CellID->6578],
Cell[9573, 327, 213, 8, 70, "ExampleText",
 CellID->18301],
Cell[CellGroupData[{
Cell[9811, 339, 287, 10, 70, "Input",
 CellID->24472],
Cell[10101, 351, 378, 12, 36, "Output",
 CellID->18948]
}, Open  ]],
Cell[10494, 366, 121, 3, 70, "ExampleDelimiter",
 CellID->27899],
Cell[10618, 371, 157, 4, 70, "ExampleText",
 CellID->11794],
Cell[CellGroupData[{
Cell[10800, 379, 363, 12, 70, "Input",
 CellID->15051],
Cell[11166, 393, 355, 13, 36, "Output",
 CellID->31440]
}, Open  ]],
Cell[11536, 409, 121, 3, 70, "ExampleDelimiter",
 CellID->17824],
Cell[11660, 414, 183, 6, 70, "ExampleText",
 CellID->19527],
Cell[CellGroupData[{
Cell[11868, 424, 395, 13, 70, "Input",
 CellID->11265],
Cell[12266, 439, 274, 10, 36, "Output",
 CellID->30452]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12589, 455, 216, 7, 70, "ExampleSection",
 CellID->11549],
Cell[12808, 464, 202, 7, 70, "ExampleText",
 CellID->26756],
Cell[CellGroupData[{
Cell[13035, 475, 519, 18, 70, "Input",
 CellID->23452],
Cell[13557, 495, 559, 16, 36, "Output",
 CellID->9690]
}, Open  ]],
Cell[14131, 514, 72, 1, 70, "ExampleText",
 CellID->25151],
Cell[14206, 517, 237, 8, 70, "Input",
 CellID->2722],
Cell[CellGroupData[{
Cell[14468, 529, 362, 13, 70, "Input",
 CellID->11248],
Cell[14833, 544, 559, 16, 36, "Output",
 CellID->7955]
}, Open  ]],
Cell[15407, 563, 120, 3, 70, "ExampleDelimiter",
 CellID->3384],
Cell[15530, 568, 147, 4, 70, "ExampleText",
 CellID->17934],
Cell[CellGroupData[{
Cell[15702, 576, 350, 12, 70, "Input",
 CellID->17384],
Cell[16055, 590, 355, 13, 36, "Output",
 CellID->31415]
}, Open  ]],
Cell[16425, 606, 120, 3, 70, "ExampleDelimiter",
 CellID->2276],
Cell[16548, 611, 110, 3, 70, "ExampleText",
 CellID->15235],
Cell[CellGroupData[{
Cell[16683, 618, 413, 14, 70, "Input",
 CellID->28002],
Cell[17099, 634, 374, 13, 36, "Output",
 CellID->5888]
}, Open  ]],
Cell[17488, 650, 121, 3, 70, "ExampleDelimiter",
 CellID->18212],
Cell[17612, 655, 229, 8, 70, "ExampleText",
 CellID->12202],
Cell[CellGroupData[{
Cell[17866, 667, 594, 20, 70, "Input",
 CellID->19314],
Cell[18463, 689, 375, 13, 36, "Output",
 CellID->30592]
}, Open  ]],
Cell[18853, 705, 158, 5, 70, "ExampleText",
 CellID->14038],
Cell[CellGroupData[{
Cell[19036, 714, 532, 18, 70, "Input",
 CellID->10558],
Cell[19571, 734, 437, 15, 36, "Output",
 CellID->4089]
}, Open  ]],
Cell[20023, 752, 121, 3, 70, "ExampleDelimiter",
 CellID->29795],
Cell[20147, 757, 332, 13, 70, "ExampleText",
 CellID->17925],
Cell[CellGroupData[{
Cell[20504, 774, 395, 14, 70, "Input",
 CellID->14958],
Cell[20902, 790, 434, 15, 36, "Output",
 CellID->12153]
}, Open  ]],
Cell[CellGroupData[{
Cell[21373, 810, 432, 15, 70, "Input",
 CellID->28405],
Cell[21808, 827, 311, 11, 36, "Output",
 CellID->21596]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22168, 844, 223, 7, 70, "ExampleSection",
 CellID->12132],
Cell[22394, 853, 228, 8, 70, "ExampleText",
 CellID->27842],
Cell[CellGroupData[{
Cell[22647, 865, 344, 11, 70, "Input",
 CellID->10562],
Cell[22994, 878, 455, 15, 36, "Output",
 CellID->20422]
}, Open  ]],
Cell[23464, 896, 121, 3, 70, "ExampleDelimiter",
 CellID->17888],
Cell[23588, 901, 111, 3, 70, "ExampleText",
 CellID->28052],
Cell[CellGroupData[{
Cell[23724, 908, 498, 17, 70, "Input",
 CellID->17316],
Cell[24225, 927, 446, 13, 36, "Output",
 CellID->22621]
}, Open  ]],
Cell[24686, 943, 120, 3, 70, "ExampleDelimiter",
 CellID->6692],
Cell[24809, 948, 210, 7, 70, "ExampleText",
 CellID->18148],
Cell[CellGroupData[{
Cell[25044, 959, 351, 12, 70, "Input",
 CellID->21655],
Cell[25398, 973, 701, 21, 36, "Output",
 CellID->28954]
}, Open  ]],
Cell[26114, 997, 120, 3, 70, "ExampleDelimiter",
 CellID->1645]
}, Closed]],
Cell[CellGroupData[{
Cell[26271, 1005, 232, 7, 70, "ExampleSection",
 CellID->4809],
Cell[26506, 1014, 370, 14, 70, "ExampleText",
 CellID->8681],
Cell[CellGroupData[{
Cell[26901, 1032, 95, 3, 70, "Input",
 CellID->19553],
Cell[26999, 1037, 154, 5, 36, "Output",
 CellID->10271]
}, Open  ]],
Cell[27168, 1045, 120, 3, 70, "ExampleDelimiter",
 CellID->7013],
Cell[27291, 1050, 225, 8, 70, "ExampleText",
 CellID->9795],
Cell[CellGroupData[{
Cell[27541, 1062, 269, 9, 70, "Input",
 CellID->12044],
Cell[27813, 1073, 373, 13, 36, "Output",
 CellID->21048]
}, Open  ]],
Cell[28201, 1089, 121, 3, 70, "ExampleDelimiter",
 CellID->17165]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[28371, 1098, 311, 9, 70, "SeeAlsoSection",
 CellID->30766],
Cell[28685, 1109, 1676, 62, 70, "SeeAlso",
 CellID->24840]
}, Open  ]],
Cell[CellGroupData[{
Cell[30398, 1176, 313, 9, 70, "TutorialsSection",
 CellID->8433],
Cell[30714, 1187, 146, 3, 70, "Tutorials",
 CellID->26090],
Cell[30863, 1192, 190, 4, 70, "Tutorials",
 CellID->3365]
}, Open  ]],
Cell[CellGroupData[{
Cell[31090, 1201, 305, 8, 70, "RelatedLinksSection"],
Cell[31398, 1211, 346, 11, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[31781, 1227, 319, 9, 70, "MoreAboutSection",
 CellID->377146527],
Cell[32103, 1238, 147, 3, 70, "MoreAbout",
 CellID->389038510],
Cell[32253, 1243, 145, 3, 70, "MoreAbout",
 CellID->342926975],
Cell[32401, 1248, 145, 3, 70, "MoreAbout",
 CellID->148557985],
Cell[32549, 1253, 148, 3, 70, "MoreAbout",
 CellID->144142039]
}, Open  ]],
Cell[32712, 1259, 27, 0, 70, "History"],
Cell[32742, 1261, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

