(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     27572,        903]
NotebookOptionsPosition[     22602,        732]
NotebookOutlinePosition[     24055,        772]
CellTagsIndexPosition[     23970,        767]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"String\[Hyphen]Oriented Output Formats" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StringOrientedOutputFormats"], "Formatted Output" :> 
          Documentation`HelpLookup["paclet:tutorial/FormattedOutput"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"String\[Hyphen]Oriented Output Formats\"\>", 
       2->"\<\"Formatted Output\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Invisible" :> Documentation`HelpLookup["paclet:ref/Invisible"],
           "ImageSize" :> Documentation`HelpLookup["paclet:ref/ImageSize"], 
          "Row" :> Documentation`HelpLookup["paclet:ref/Row"], "Rasterize" :> 
          Documentation`HelpLookup["paclet:ref/Rasterize"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Invisible\"\>", 
       2->"\<\"ImageSize\"\>", 3->"\<\"Row\"\>", 
       4->"\<\"Rasterize\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Textual Elements in Notebooks" :> 
          Documentation`HelpLookup["paclet:guide/TextualElementsInNotebooks"],
           "New in 6.0: Formatting & Styling" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60FormattingAndStyling"], 
          "New in 6.0: Notebooks & Documents" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NotebooksAndDocuments"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Textual Elements in Notebooks\"\>", 
       2->"\<\"New in 6.0: Formatting & Styling\"\>", 
       3->"\<\"New in 6.0: Notebooks & Documents\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Spacer", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Spacer",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Spacer"], "[", 
       StyleBox["w", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]displays as a spacer ",
     Cell[BoxData[
      StyleBox["w", "TI"]], "InlineFormula"],
     " printer's points wide."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Spacer",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Spacer"], "[", 
       RowBox[{"{", 
        RowBox[{
         StyleBox["w", "TI"], ",", 
         StyleBox["h", "TI"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]displays as a spacer ",
     Cell[BoxData[
      StyleBox["w", "TI"]], "InlineFormula"],
     " points wide and a total of ",
     Cell[BoxData[
      StyleBox["h", "TI"]], "InlineFormula"],
     " points high."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Spacer",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Spacer"], "[", 
       RowBox[{"{", 
        RowBox[{
         StyleBox["w", "TI"], ",", 
         StyleBox["h", "TI"], ",", 
         StyleBox["dh", "TI"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator] makes the spacer extend ",
     Cell[BoxData[
      StyleBox["dh", "TI"]], "InlineFormula"],
     " points below the baseline. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->8047]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Spacer",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Spacer"], "[", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["w", "TI"], ",", 
     StyleBox["h", "TI"]}], "}"}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Spacer",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Spacer"], "[", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["w", "TI"], ",", 
     StyleBox["h", "TI"], ",", "0"}], "}"}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->6393]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->4214873],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->301733235],

Cell["Leave 20 printer's points between two letters:", "ExampleText",
 CellID->204549401],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "[", 
  RowBox[{"Row", "[", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"Spacer", "[", "20", "]"}], ",", "y"}], "}"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->42823183],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAw6ACxiAQDkP0fyAJj
nf//QTQzBwcHAwRoADEjhMsMUgEGDBpAghGigKqickCCBchlwyqrACKQ+KxY
VTEBCSYgF0ZLEKWLGUSwIPgMDJJQ/djdwgKVlUQynYE41Si2EOsacbDT4SJQ
24gLAVEgDZIGO4MBBlhoFIfIohISEsjpCMyFpjFGALqZA+M=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{44, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->563491940]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->225968263],

Cell["Display a blank space with 70 point wide, 50 point high:", "ExampleText",
 CellID->269402137],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "[", 
  RowBox[{"Spacer", "[", 
   RowBox[{"{", 
    RowBox[{"70", ",", "50"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->690690949],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwBACxnQQDkP0fyALj
gP//QTQzBwcHAwT4ADEjhMsMUgEGDD5AghGiYFR0VHRUdFR0mItKSEhAWJAS
EcyFlpaMAPifMBM=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{80, 62},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->135943788]
}, Open  ]],

Cell["\<\
Place a spacer with 20 point wide, 15 point high in a grid cell:\
\>", "ExampleText",
 CellID->301277925],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Spacer", "[", 
        RowBox[{"{", 
         RowBox[{"20", ",", "15"}], "}"}], "]"}], ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->566068598],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAw6AGxvgQDkP0fyAJj
vf//gTSUZAADZpA4GDBIgwgkPg+QYBwEqriABIjLh6aaGUiwArksWHVxgghW
OB/sZwYGXjQzmLCqYsVtIhKffzCZRZxPkfk4zQOFNwsWE0DhzQRWC7ECRGIP
e/R4ZcNiEmFdrFD7sLuS0hQ2dNI/CapYkFMBKEmwEWUiKaltMOkFpQ70dE1c
2mJCCi2IYhJCConPTmRcgFzKSZQNgyo9jaqimypIeQSpmxkYAUCit64=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{46, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->19092971]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30076],

Cell["Make the spacer extend 30 point below the baseline:", "ExampleText",
 CellID->120921098],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "[", 
  RowBox[{"Row", "[", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"Spacer", "[", 
      RowBox[{"{", 
       RowBox[{"20", ",", "10", ",", "30"}], "}"}], "]"}], ",", "y"}], "}"}], 
   "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->70695262],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAw6ACxgQQDkP0fyAJj
nf//QTQzBwcHAwRoADEjhMsMUgEGDBpAghGiYFR0VHTIicoBCRYglw2rrAKI
QOKzYlXFBCSYgFwYLUGULmYQwYLgMzBIQvVjdwsLVFYSyXQG4lSj2EKsa8TB
ToeLQG0jLgREgTRIGuwMBhhgoUPMSkhIQG0Dl1dgLrQsYwQAVgID4g==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{44, 48},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->104620171]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22568],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Invisible",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Invisible"]], "InlineFormula"],
 " to display a blank space the same size as a given expression:"
}], "ExampleText",
 CellID->397610484],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "[", 
  RowBox[{"Invisible", "[", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{
        RowBox[{"-", "\[Pi]"}], "/", "2"}], ",", 
       RowBox[{"\[Pi]", "/", "2"}]}], "}"}]}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->801539716],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAw+AOxoQQDkP0fyAJj
////QTQzBwcHAwR4ATEjkMsIlQGpAgMGLyABMmZUZlRmVGZUZqBkJCQkGCAA
XFYBuRAZaFnGCAAtN0Os\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{79, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->52469252]
}, Open  ]],

Cell["Here is the expression in visible form:", "ExampleText",
 CellID->825112979],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "[", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{
       RowBox[{"-", "\[Pi]"}], "/", "2"}], ",", 
      RowBox[{"\[Pi]", "/", "2"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->106834265],

Cell[BoxData[
 FrameBox[
  RowBox[{
   SubsuperscriptBox["\[Integral]", 
    RowBox[{"-", 
     FractionBox["\[Pi]", "2"]}], 
    FractionBox["\[Pi]", "2"]], 
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}],
  StripOnInput->False]], "Output",
 ImageSize->{83, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->491309768]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31124],

Cell["Linearly varying spacers: ", "ExampleText",
 CellID->58253729],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Row", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Framed", "[", "x", "]"}], ",", 
       RowBox[{"Spacer", "[", 
        RowBox[{"10", "i"}], "]"}], ",", 
       RowBox[{"Framed", "[", "x", "]"}], ",", 
       RowBox[{"Spacer", "[", 
        RowBox[{"10", 
         RowBox[{"(", 
          RowBox[{"10", "-", "i"}], ")"}]}], "]"}], ",", 
       RowBox[{"Framed", "[", "x", "]"}], ",", 
       RowBox[{"Spacer", "[", 
        RowBox[{"10", "i"}], "]"}], ",", 
       RowBox[{"Framed", "[", "x", "]"}], ",", 
       RowBox[{"Spacer", "[", 
        RowBox[{"10", 
         RowBox[{"(", 
          RowBox[{"10", "-", "i"}], ")"}]}], "]"}], ",", 
       RowBox[{"Framed", "[", "x", "]"}]}], "}"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", "10"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->203860747],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXcFO20AQXTsp9QVFyimHgDjlzJkzak/lzDWgSnBAVJRf7nektjeBMHjz
djfMemd3kSB2Zt6813oyflhm/Wv9+vD7af36eL+++Pmy/vPweP/34sfzS/vW
pFKqOlNK/VuodnvTbvXf3dd5+6039ZaaNE2j9Nep2u73mRt11/0g8brdnTnk
VfrtyY5/o0777Pf9O7Lfxet2d+aQV2niwnIES72N7l6/gWpD+d3rlLHOZ9WT
7sf0fV+pE8A3jHhTylrrs/7dv/I7YNrPq/d4jsHFrkb6sZX5iUpppslnWSwW
emt7dm73P6A/xut2d+aQV/Vvd2nUFxzeOuQabns+c7wBcR88dhm3A//X+/sN
iPvgcacUVdJUoZlOWVA+ZR2jvs+Zl+rACKpkPA5730MVmPIoL2e91NTn1mt5
TJA4p3dRJVOV2QXrquZ4A+I+eA7XfNPzmONzEPfBY9d8A47ZHMR98LgTiypp
qtA5hrKgfMo6Rn0fJ0N1YARVMh6Hve+kCkx5lJezXmrqc+u1PCZInNO7qJKp
yuxqdVVzfA7iPngO13zd85jjSxD3wWPXfA2O2RLEffC4E4sqaarQOYayoHzK
OkZ9HydDdWAEVTIeh73vpApMeZSXs15q6nPrtTwmSJzTu6iSqcrsanVVc3wJ
4j54Dtd81fOY4ysQ98Fj13wFjtkKxH3wuBOLKmmq0DmGsqB8yjpGfR8nQ3Vg
BFUyHoe976QKTHmUl7Neaupz67U8Jkic07uokqnK7Gp1VXN8BeI+eA7XfNnz
hI1j13wJjhlHHHdiUSVNFTrH0CoS8n2cDK0rCWHvO2m9GPJSUy+pc76i1yRM
hOMnSJzTu6iSqcrsajUqbJzDNXNcS0Z47Jo5fhNCeNyJRZU0VRKu/LjW93Ey
8VzNc+ew950hr8La1ktNfW69lscEiXN6F1UyVYW9lozwHK6Z475lhMeumeOu
G4THnVhUSVMl4S5D1/o+TiaeO0fdOex9Z8g7fm3rpaY+t17LY4LEOb2LKpmq
wt63jPAcrpljjQyEx66Z4y88ER53YlElTZWEv2h3re/jZOJZpcCdw953hlxd
wrZeaupz67U8Jkic07uokqkq7BoZCM/hmjnWY0Z47Jo5VhNEeNyJRZU0Vegc
E8Pqqa71fZxMPCviunPY+86QKxnb1ktNfW69lscEiXN6F1UyVYVdjxnhv8o1
uz77DOUNu+DuM+rypBiUN9wphcWFZWiGdq/TgfcPVeesY3umfqsf2ZO1Dvuk
eo8xxNPJYlcj/djK/ESlNNPksxz37DOUR12Dqv4DO7E7NQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{285, 229},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->754250036]
}, Open  ]],

Cell["Quadratically varying spacers: ", "ExampleText",
 CellID->87077366],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Row", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Framed", "[", "x", "]"}], ",", 
       RowBox[{"Spacer", "[", 
        RowBox[{"i", "^", "2"}], "]"}], ",", 
       RowBox[{"Framed", "[", "x", "]"}], ",", 
       RowBox[{"Spacer", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"10", "-", "i"}], ")"}], "^", "2"}], "]"}], ",", 
       RowBox[{"Framed", "[", "x", "]"}], ",", 
       RowBox[{"Spacer", "[", 
        RowBox[{"i", "^", "2"}], "]"}], ",", 
       RowBox[{"Framed", "[", "x", "]"}], ",", 
       RowBox[{"Spacer", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"10", "-", "i"}], ")"}], "^", "2"}], "]"}], ",", 
       RowBox[{"Framed", "[", "x", "]"}]}], "}"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", "10"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16939],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXc1OGzEQdja0yYXkSC6tUF6AN+DYniqkPkClBFWCQ9WK8sp9jnS9TgjM
2v7W7Noz6zUSxN75+yaezAyL8X7bPT/8/LV7frzfXX992v15eLz/e/3l91N9
aT5TavZJKfVvo+rxoR413/rrc/1thmak5svlUpmvS3WcN5wHtdc/CL2qp+sA
vpm5PD/ZP6jLhvs835O5plf1dB3ANzOGi5UeVqoj9fT6AWiz8evXi4h62qjn
+sfFea7UR2DPLvGCNKquNv6Tlwtg6TVf9cpOHznpaMa+tuP8ROWU08ZvZbPZ
mNGxOtfzN9Jv6VU9XQfwzZrLmo32Bf6Rr2u4a+zZ6foq7R5C+bdHBO73/87y
vp7myrIOofwFgUwEKN9SCz5+bRHl3aH1tT3CFZBi8Eso1aUSxtDZ9s3Va1Dr
Nj6l3D1HX/kxI805XvL7dPNnzIKAD4G7szMa7XR9lXZ4ofwGgR4O1/XdNhjc
9ArQB5H3ruutZ53OFiLLF4STQ4jqFrWI+CkCEfoDuxCKCUtQVIJsdOoVKRoX
H8WQVF+mngiKleTxKCI7JM0+8itCQZgvQndXbyy46RWgDyLfwB2u679pbLrp
C0DvK/8dxsUNWDdaPYaWLwiniRDVLWoR8du6IU79bY9xd0IxYQmKSoaNtu+u
XpSicfHReSp9OXsiI1Z44pE7O6TPPvIrQkGYL0J3120suOkLQO8rbxDq4XBd
f/P3Aw99Beh95X/AuNiCdVsBel/5gnCaCFHdohYRP0XArb/tMe5OKCYsQVHJ
sNH23dWLUjQuPoohlb6cPZERKzzxyJ0d0mcf+RWhIMwXobvrNhbc9BWg95U3
CPVwuK7/qrHJR9/DuLgC6xabXhBOEyGqW1Tj2PjbHuPuhNoYq0Tbd1cvSnVL
48vZExmxwhOP3NkhffaRXxEKwnwRurtuo4GPbhDq4XBdf+x7+Uge/zYY+7c9
JF8QThPh2O6ehep/z71VmXdKw210v0POdee7q76cPZERKzzxyJ0d0mcf+RWh
IMwXId+9fCQf415/7H37SB7v/Iq9swvJF4TTRIjqlrSdsqH637OPWuau6HAb
3XfDc+1y76ovZ09kxApPPHJnh/TZR35FKAjzRci3bx/Jx9jXXzU2+c74wf/l
XYF1i/1f4AXhNBGiukUtIn5pp26858wUiknQCSjhEp16ZYpG2gk5OXsiI1Z4
4pE7O6TPPvIrQkGYL0LmM3oSnuEzxHnsPn5N2nrXXTP3PVHVx18QyEXgqwva
QuoTmkP02T2Sepp2mE67b6lPN+8iP3akOcdLfp9u/oxZEPAhiHceu4//jEAP
+3V9oc/uQ3z2Z/tVlvd4b3mPu/LZn7dUrIRYseU6/RrzyWKhero+/+1Fv7An
w/mfplcpd/9A9Q8hJx3N2Nd2nJ+onHLa+K30e3Yf4qPP9lOz/8BZeRM=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{285, 229},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->91515745]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->29916],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Invisible",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Invisible"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ImageSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageSize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Row",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Row"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rasterize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rasterize"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2125]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26950],

Cell[TextData[ButtonBox["String\[Hyphen]Oriented Output Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StringOrientedOutputFormats"]], "Tutorials",
 CellID->140352686],

Cell[TextData[ButtonBox["Formatted Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FormattedOutput"]], "Tutorials",
 CellID->175077611]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->13093129],

Cell[TextData[ButtonBox["Textual Elements in Notebooks",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TextualElementsInNotebooks"]], "MoreAbout",
 CellID->173691598],

Cell[TextData[ButtonBox["New in 6.0: Formatting & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60FormattingAndStyling"]], "MoreAbout",
 CellID->396723203],

Cell[TextData[ButtonBox["New in 6.0: Notebooks & Documents",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60NotebooksAndDocuments"]], "MoreAbout",
 CellID->92184464]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Spacer - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 21, 58.8095652}", "context" -> "System`", 
    "keywords" -> {
     "space", "spacing element", "filling element", "row spacer", 
      "column spacer", "table spacer", "grid spacer"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Spacer[w] displays as a spacer w printer's points wide. Spacer[{w, h}] \
displays as a spacer w points wide and a total of h points high. Spacer[{w, \
h, dh}] makes the spacer extend dh points below the baseline. ", 
    "synonyms" -> {}, "title" -> "Spacer", "type" -> "Symbol", "uri" -> 
    "ref/Spacer"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7547, 227, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->4214873]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 23829, 760}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2628, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3251, 87, 1571, 37, 70, "ObjectNameGrid"],
Cell[4825, 126, 1611, 52, 70, "Usage",
 CellID->8047]
}, Open  ]],
Cell[CellGroupData[{
Cell[6473, 183, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6951, 200, 559, 22, 70, "Notes",
 CellID->6393]
}, Closed]],
Cell[CellGroupData[{
Cell[7547, 227, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->4214873],
Cell[CellGroupData[{
Cell[7930, 241, 148, 5, 70, "ExampleSection",
 CellID->301733235],
Cell[8081, 248, 89, 1, 70, "ExampleText",
 CellID->204549401],
Cell[CellGroupData[{
Cell[8195, 253, 230, 8, 28, "Input",
 CellID->42823183],
Cell[8428, 263, 442, 11, 41, "Output",
 Evaluatable->False,
 CellID->563491940]
}, Open  ]],
Cell[8885, 277, 125, 3, 70, "ExampleDelimiter",
 CellID->225968263],
Cell[9013, 282, 99, 1, 70, "ExampleText",
 CellID->269402137],
Cell[CellGroupData[{
Cell[9137, 287, 186, 6, 28, "Input",
 CellID->690690949],
Cell[9326, 295, 349, 10, 83, "Output",
 Evaluatable->False,
 CellID->135943788]
}, Open  ]],
Cell[9690, 308, 115, 3, 70, "ExampleText",
 CellID->301277925],
Cell[CellGroupData[{
Cell[9830, 315, 413, 14, 28, "Input",
 CellID->566068598],
Cell[10246, 331, 510, 12, 68, "Output",
 Evaluatable->False,
 CellID->19092971]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10805, 349, 216, 7, 70, "ExampleSection",
 CellID->30076],
Cell[11024, 358, 94, 1, 70, "ExampleText",
 CellID->120921098],
Cell[CellGroupData[{
Cell[11143, 363, 298, 10, 70, "Input",
 CellID->70695262],
Cell[11444, 375, 450, 11, 70, "Output",
 Evaluatable->False,
 CellID->104620171]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11943, 392, 233, 7, 70, "ExampleSection",
 CellID->22568],
Cell[12179, 401, 250, 8, 70, "ExampleText",
 CellID->397610484],
Cell[CellGroupData[{
Cell[12454, 413, 382, 12, 70, "Input",
 CellID->801539716],
Cell[12839, 427, 352, 10, 70, "Output",
 Evaluatable->False,
 CellID->52469252]
}, Open  ]],
Cell[13206, 440, 82, 1, 70, "ExampleText",
 CellID->825112979],
Cell[CellGroupData[{
Cell[13313, 445, 338, 11, 70, "Input",
 CellID->106834265],
Cell[13654, 458, 413, 15, 70, "Output",
 CellID->491309768]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14116, 479, 224, 7, 70, "ExampleSection",
 CellID->31124],
Cell[14343, 488, 68, 1, 70, "ExampleText",
 CellID->58253729],
Cell[CellGroupData[{
Cell[14436, 493, 941, 27, 70, "Input",
 CellID->203860747],
Cell[15380, 522, 1542, 29, 70, "Output",
 Evaluatable->False,
 CellID->754250036]
}, Open  ]],
Cell[16937, 554, 73, 1, 70, "ExampleText",
 CellID->87077366],
Cell[CellGroupData[{
Cell[17035, 559, 953, 27, 70, "Input",
 CellID->16939],
Cell[17991, 588, 1671, 31, 70, "Output",
 Evaluatable->False,
 CellID->91515745]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19723, 626, 311, 9, 70, "SeeAlsoSection",
 CellID->29916],
Cell[20037, 637, 936, 35, 70, "SeeAlso",
 CellID->2125]
}, Open  ]],
Cell[CellGroupData[{
Cell[21010, 677, 314, 9, 70, "TutorialsSection",
 CellID->26950],
Cell[21327, 688, 180, 3, 70, "Tutorials",
 CellID->140352686],
Cell[21510, 693, 146, 3, 70, "Tutorials",
 CellID->175077611]
}, Open  ]],
Cell[CellGroupData[{
Cell[21693, 701, 318, 9, 70, "MoreAboutSection",
 CellID->13093129],
Cell[22014, 712, 167, 3, 70, "MoreAbout",
 CellID->173691598],
Cell[22184, 717, 171, 3, 70, "MoreAbout",
 CellID->396723203],
Cell[22358, 722, 172, 3, 70, "MoreAbout",
 CellID->92184464]
}, Open  ]],
Cell[22545, 728, 27, 0, 70, "History"],
Cell[22575, 730, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

