(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19800,        714]
NotebookOptionsPosition[     15568,        576]
NotebookOutlinePosition[     17120,        616]
CellTagsIndexPosition[     17035,        611]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Take" :> Documentation`HelpLookup["paclet:ref/Take"], "Drop" :> 
          Documentation`HelpLookup["paclet:ref/Drop"], "Part" :> 
          Documentation`HelpLookup["paclet:ref/Part"], "Range" :> 
          Documentation`HelpLookup["paclet:ref/Range"], "Band" :> 
          Documentation`HelpLookup["paclet:ref/Band"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Take\"\>", 2->"\<\"Drop\"\>", 3->"\<\"Part\"\>", 
       4->"\<\"Range\"\>", 5->"\<\"Band\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Core Language: New in 6.0" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60CoreLanguage"], 
          "List Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/ListManipulation"], 
          "Mathematics and Algorithms: New in 6.0" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Core Language: New in 6.0\"\>", 
       2->"\<\"List Manipulation\"\>", 
       3->"\<\"Mathematics and Algorithms: New in 6.0\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     "Span ",
     StyleBox["(;;)", "OperatorCharacter"]
    }], "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["i", "TI"], ";;", 
       StyleBox["j", "TI"]}]], "InlineFormula"],
     " \[LineSeparator]represents a span of elements ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      StyleBox["j", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["i", "TI"], ";;"}]], "InlineFormula"],
     " \[LineSeparator]a span from ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     " to the end."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{";;", 
       StyleBox["j", "TI"]}]], "InlineFormula"],
     " \[LineSeparator]a span from the beginning to ",
     Cell[BoxData[
      StyleBox["j", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[";;"], "InlineFormula"],
     " \[LineSeparator]a span that includes all elements."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["i", "TI"], ";;", 
       StyleBox["j", "TI"], ";;", 
       StyleBox["k", "TI"]}]], "InlineFormula"],
     " \[LineSeparator]a span from ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      StyleBox["j", "TI"]], "InlineFormula"],
     " in steps of ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["i", "TI"], ";;", ";;", 
       StyleBox["k", "TI"]}]], "InlineFormula"],
     " \[LineSeparator]from ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     " to the end in steps of ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{";;", 
       StyleBox["j", "TI"], ";;", 
       StyleBox["k", "TI"]}]], "InlineFormula"],
     " \[LineSeparator]from the beginning to ",
     Cell[BoxData[
      StyleBox["j", "TI"]], "InlineFormula"],
     " in steps of ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{";;", ";;", 
       StyleBox["k", "TI"]}]], "InlineFormula"],
     " \[LineSeparator]from the beginning to the end in steps of ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["m", "TI"], "[", 
   RowBox[{"[", 
    RowBox[{
     StyleBox["i", "TI"], ";;", 
     StyleBox["j", "TI"], ";;", 
     StyleBox["k", "TI"]}], "]"}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Take",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Take"], "[", 
   RowBox[{
    StyleBox["m", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["i", "TI"], ",", 
      StyleBox["j", "TI"], ",", 
      StyleBox["k", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["m", "TI"], "[", 
    RowBox[{"[", 
     RowBox[{
      StyleBox["i", "TI"], ";;", 
      StyleBox["j", "TI"]}], "]"}], "]"}], "=", 
   StyleBox["v", "TI"]}]], "InlineFormula"],
 " can be used to reset a span of elements in a list or other expression."
}], "Notes",
 CellID->337201917],

Cell[TextData[{
 "When used in ",
 Cell[BoxData[
  ButtonBox["Part",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"]], "InlineFormula"],
 ", negative ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["j", "TI"]], "InlineFormula"],
 " count from the end."
}], "Notes",
 CellID->120093550]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->242630217],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->564793967],

Cell["Take a span of elements from a list:", "ExampleText",
 CellID->474796922],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
   "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g", ",", 
    "h"}], "}"}], "[", 
  RowBox[{"[", 
   RowBox[{"2", ";;", "5"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->143066431],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", "c", ",", "d", ",", "e"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->217955598]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->221218180],

Cell["Assign to a span of elements:", "ExampleText",
 CellID->543555569],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{"{", 
   RowBox[{
   "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g", ",", 
    "h"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->114790185],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g", ",", "h"}],
   "}"}]], "Output",
 ImageSize->{153, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->40539791]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"t", "[", 
   RowBox[{"[", 
    RowBox[{"2", ";;", "5"}], "]"}], "]"}], "=", "x"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->54912131],

Cell[BoxData["x"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->15658023]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["t"], "Input",
 CellLabel->"In[3]:=",
 CellID->769067957],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "a", ",", "x", ",", "x", ",", "x", ",", "x", ",", "f", ",", "g", ",", "h"}],
   "}"}]], "Output",
 ImageSize->{153, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->141578532]
}, Open  ]],

Cell["Assign a sequence of different elements:", "ExampleText",
 CellID->598234703],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"t", "[", 
   RowBox[{"[", 
    RowBox[{"2", ";;", "5"}], "]"}], "]"}], "=", 
  RowBox[{"{", 
   RowBox[{"p", ",", "q", ",", "r", ",", "s"}], "}"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->100466837],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"p", ",", "q", ",", "r", ",", "s"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->687945441]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["t"], "Input",
 CellLabel->"In[5]:=",
 CellID->83383697],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "a", ",", "p", ",", "q", ",", "r", ",", "s", ",", "f", ",", "g", ",", "h"}],
   "}"}]], "Output",
 ImageSize->{153, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->497503585]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell["Negative indices count from the end:", "ExampleText",
 CellID->194875585],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
   "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g", ",", 
    "h"}], "}"}], "[", 
  RowBox[{"[", 
   RowBox[{"2", ";;", 
    RowBox[{"-", "3"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->189336478],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8196969]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Take",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Take"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Drop",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Drop"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Part",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Part"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Range",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Range"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Band",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Band"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->388861907],

Cell[TextData[ButtonBox["Core Language: New in 6.0",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60CoreLanguage"]], "MoreAbout",
 CellID->87151637],

Cell[TextData[ButtonBox["List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListManipulation"]], "MoreAbout",
 CellID->25103056],

Cell[TextData[ButtonBox["Mathematics and Algorithms: New in 6.0",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->179944272]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Span (;;) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 22, 8.6379418}", "context" -> "System`", 
    "keywords" -> {
     "array subscript", "array subscripting", "slice", "subscript range"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "i ;; j represents a span of elements i through j. i ;; a span from i to \
the end. ;; j a span from the beginning to j. ;; a span that includes all \
elements. i ;; j ;; k a span from i through j in steps of k. i ;; ;; k from i \
to the end in steps of k. ;; j ;; k from the beginning to j in steps of k. ;; \
;; k from the beginning to the end in steps of k. ", "synonyms" -> {";;"}, 
    "title" -> "Span", "type" -> "Symbol", "uri" -> "ref/Span"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8669, 285, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->242630217]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16892, 604}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1840, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2463, 68, 1637, 40, 70, "ObjectNameGrid"],
Cell[4103, 110, 2708, 94, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[6848, 209, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7326, 226, 607, 24, 70, "Notes",
 CellID->1067943069],
Cell[7936, 252, 352, 12, 70, "Notes",
 CellID->337201917],
Cell[8291, 266, 341, 14, 70, "Notes",
 CellID->120093550]
}, Closed]],
Cell[CellGroupData[{
Cell[8669, 285, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->242630217],
Cell[CellGroupData[{
Cell[9054, 299, 148, 5, 70, "ExampleSection",
 CellID->564793967],
Cell[9205, 306, 79, 1, 70, "ExampleText",
 CellID->474796922],
Cell[CellGroupData[{
Cell[9309, 311, 261, 9, 28, "Input",
 CellID->143066431],
Cell[9573, 322, 223, 7, 36, "Output",
 CellID->217955598]
}, Open  ]],
Cell[9811, 332, 125, 3, 70, "ExampleDelimiter",
 CellID->221218180],
Cell[9939, 337, 72, 1, 70, "ExampleText",
 CellID->543555569],
Cell[CellGroupData[{
Cell[10036, 342, 208, 7, 70, "Input",
 CellID->114790185],
Cell[10247, 351, 269, 9, 36, "Output",
 CellID->40539791]
}, Open  ]],
Cell[CellGroupData[{
Cell[10553, 365, 169, 6, 70, "Input",
 CellID->54912131],
Cell[10725, 373, 157, 5, 36, "Output",
 CellID->15658023]
}, Open  ]],
Cell[CellGroupData[{
Cell[10919, 383, 70, 2, 70, "Input",
 CellID->769067957],
Cell[10992, 387, 270, 9, 36, "Output",
 CellID->141578532]
}, Open  ]],
Cell[11277, 399, 83, 1, 70, "ExampleText",
 CellID->598234703],
Cell[CellGroupData[{
Cell[11385, 404, 237, 8, 70, "Input",
 CellID->100466837],
Cell[11625, 414, 223, 7, 36, "Output",
 CellID->687945441]
}, Open  ]],
Cell[CellGroupData[{
Cell[11885, 426, 69, 2, 70, "Input",
 CellID->83383697],
Cell[11957, 430, 270, 9, 36, "Output",
 CellID->497503585]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12276, 445, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[12500, 454, 79, 1, 70, "ExampleText",
 CellID->194875585],
Cell[CellGroupData[{
Cell[12604, 459, 281, 10, 70, "Input",
 CellID->189336478],
Cell[12888, 471, 231, 7, 36, "Output",
 CellID->8196969]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13180, 485, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[13499, 496, 1152, 44, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[14688, 545, 319, 9, 70, "MoreAboutSection",
 CellID->388861907],
Cell[15010, 556, 155, 3, 70, "MoreAbout",
 CellID->87151637],
Cell[15168, 561, 144, 3, 70, "MoreAbout",
 CellID->25103056],
Cell[15315, 566, 181, 3, 70, "MoreAbout",
 CellID->179944272]
}, Open  ]],
Cell[15511, 572, 27, 0, 70, "History"],
Cell[15541, 574, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

