(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    133055,       4743]
NotebookOptionsPosition[    111743,       3989]
NotebookOutlinePosition[    113539,       4033]
CellTagsIndexPosition[    113452,       4028]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Constructing Lists" :> 
          Documentation`HelpLookup["paclet:tutorial/ConstructingLists"], 
          "Sparse Arrays: Manipulating Lists" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SparseArrays-ManipulatingLists"], 
          "Sparse Arrays: Linear Algebra" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SparseArrays-LinearAlgebra"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Constructing Lists\"\>", 
       2->"\<\"Sparse Arrays: Manipulating Lists\"\>", 
       3->"\<\"Sparse Arrays: Linear Algebra\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ArrayRules" :> 
          Documentation`HelpLookup["paclet:ref/ArrayRules"], "Normal" :> 
          Documentation`HelpLookup["paclet:ref/Normal"], "Band" :> 
          Documentation`HelpLookup["paclet:ref/Band"], "CoefficientArrays" :> 
          Documentation`HelpLookup["paclet:ref/CoefficientArrays"], 
          "ArrayPlot" :> Documentation`HelpLookup["paclet:ref/ArrayPlot"], 
          "Array" :> Documentation`HelpLookup["paclet:ref/Array"], 
          "ConstantArray" :> 
          Documentation`HelpLookup["paclet:ref/ConstantArray"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ArrayRules\"\>", 
       2->"\<\"Normal\"\>", 3->"\<\"Band\"\>", 4->"\<\"CoefficientArrays\"\>",
        5->"\<\"ArrayPlot\"\>", 6->"\<\"Array\"\>", 
       7->"\<\"ConstantArray\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Constructing Lists" :> 
          Documentation`HelpLookup["paclet:guide/ConstructingLists"], 
          "Constructing Matrices" :> 
          Documentation`HelpLookup["paclet:guide/ConstructingMatrices"], 
          "Handling Arrays of Data" :> 
          Documentation`HelpLookup["paclet:guide/HandlingArraysOfData"], 
          "List Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/ListManipulation"], 
          "Matrices and Linear Algebra" :> 
          Documentation`HelpLookup["paclet:guide/MatricesAndLinearAlgebra"], 
          "Operations on Vectors" :> 
          Documentation`HelpLookup["paclet:guide/OperationsOnVectors"], 
          "Sparse Arrays" :> 
          Documentation`HelpLookup["paclet:guide/SparseArrays"], "Tensors" :> 
          Documentation`HelpLookup["paclet:guide/Tensors"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Constructing Lists\"\>", 
       2->"\<\"Constructing Matrices\"\>", 
       3->"\<\"Handling Arrays of Data\"\>", 4->"\<\"List Manipulation\"\>", 
       5->"\<\"Matrices and Linear Algebra\"\>", 
       6->"\<\"Operations on Vectors\"\>", 7->"\<\"Sparse Arrays\"\>", 
       8->"\<\"Tensors\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["SparseArray", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SparseArray",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SparseArray"], "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SubscriptBox[
           StyleBox["pos", "TI"], 
           StyleBox["1", "TR"]], "->", 
          SubscriptBox[
           StyleBox["val", "TI"], 
           StyleBox["1", "TR"]]}], ",", 
         RowBox[{
          SubscriptBox[
           StyleBox["pos", "TI"], 
           StyleBox["2", "TR"]], "->", 
          SubscriptBox[
           StyleBox["val", "TI"], 
           StyleBox["2", "TR"]]}], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]yields a sparse array in which values ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["val", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " appear at positions ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["pos", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SparseArray",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SparseArray"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["pos", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["pos", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], "->", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["val", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["val", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]yields the same sparse array. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SparseArray",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SparseArray"], "[", 
       StyleBox["list", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]yields a sparse array version of ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SparseArray",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SparseArray"], "[", 
       RowBox[{
        StyleBox["data", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["d", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["d", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]yields a sparse array representing a ",
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["d", "TI"], 
        StyleBox["1", "TR"]], "\[Cross]", 
       SubscriptBox[
        StyleBox["d", "TI"], 
        StyleBox["2", "TR"]], "\[Cross]", 
       StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
     " array. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SparseArray",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SparseArray"], "[", 
       RowBox[{
        StyleBox["data", "TI"], ",", 
        StyleBox["dims", "TI"], ",", 
        StyleBox["val", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]yields a sparse array in which unspecified elements are \
taken to have value ",
     Cell[BoxData[
      StyleBox["val", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->2164]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " takes unspecified elements to be ",
 Cell[BoxData["0"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->11625],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SparseArray",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SparseArray"], "[", 
   RowBox[{
    StyleBox["data", "TI"], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " is always converted to an optimized standard form with structure ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SparseArray",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SparseArray"], "[", 
   RowBox[{
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], ",", 
    StyleBox["dims", "TI"], ",", 
    StyleBox["val", "TI"], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 ". "
}], "Notes",
 CellID->15719],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Normal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Normal"], "[", 
   RowBox[{"SparseArray", "[", 
    StyleBox["\[Ellipsis]", "TR"], "]"}], "]"}]], "InlineFormula"],
 " gives the ordinary array corresponding to a sparse array object. "
}], "Notes",
 CellID->20295],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ArrayRules",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArrayRules"], "[", 
   RowBox[{"SparseArray", "[", 
    StyleBox["\[Ellipsis]", "TR"], "]"}], "]"}]], "InlineFormula"],
 " gives the list of rules ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SubscriptBox[
      StyleBox["pos", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["pos", "TI"], 
      StyleBox["2", "TR"]], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["2", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->22732],

Cell[TextData[{
 "The elements in ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " need not be numeric. "
}], "Notes",
 CellID->12482],

Cell[TextData[{
 "The position specifications ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["pos", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " can contain patterns. "
}], "Notes",
 CellID->30081],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SparseArray",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SparseArray"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"i_", ",", "i_"}], "}"}], "->", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["d", "TI"], ",", 
      StyleBox["d", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
 " gives a ",
 Cell[BoxData[
  RowBox[{
   StyleBox["d", "TI"], "\[Cross]", 
   StyleBox["d", "TI"]}]], "InlineFormula"],
 " identity matrix. "
}], "Notes",
 CellID->719],

Cell[TextData[{
 "Rules of the form ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Band",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Band"], "[", 
    StyleBox["\[Ellipsis]", "TR"], "]"}], "->", 
   StyleBox["vals", "TI"]}]], "InlineFormula"],
 " specify values on bands in the sparse array."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->17396],

Cell[TextData[{
 "With rules ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["pos", "TI"], 
    StyleBox["i", "TI"]], ":>", 
   SubscriptBox[
    StyleBox["val", "TI"], 
    StyleBox["i", "TI"]]}]], "InlineFormula"],
 " the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["val", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are evaluated separately for each set of indices that match ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["pos", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->4680],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SparseArray",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SparseArray"], "[", 
   StyleBox["list", "TI"], "]"}]], "InlineFormula"],
 " requires that ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " be a full array, with all parts at a particular level being lists of the \
same length. "
}], "Notes",
 CellID->19248],

Cell["\<\
The individual elements of a sparse array cannot themselves be lists. \
\>", "Notes",
 CellID->26945],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SparseArray",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SparseArray"], "[", 
   StyleBox["rules", "TI"], "]"}]], "InlineFormula"],
 " yields a sparse array with dimensions exactly large enough to include \
elements whose positions have been explicitly specified. "
}], "Notes",
 CellID->22371],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SparseArray",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SparseArray"], "[", 
   RowBox[{
    StyleBox["rules", "TI"], ",", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], ",", 
    StyleBox["val", "TI"]}], "]"}]], "InlineFormula"],
 " takes unspecified elements to have value ",
 Cell[BoxData[
  StyleBox["val", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->3054],

Cell[TextData[{
 "List and matrix operations are typically set up to work as they do on ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Normal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Normal"], "[", 
   RowBox[{"SparseArray", "[", 
    StyleBox["\[Ellipsis]", "TR"], "]"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->10666],

Cell[TextData[{
 "Functions with attribute ",
 Cell[BoxData[
  ButtonBox["Listable",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Listable"]], "InlineFormula"],
 " are automatically threaded over the individual elements of the ordinary \
arrays represented by ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects. "
}], "Notes",
 CellID->13769],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Part",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"]], "InlineFormula"],
 " extracts specified parts of the array represented by a ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " object, rather than parts of the ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " expression itself. "
}], "Notes",
 CellID->23333],

Cell[TextData[{
 "Functions like ",
 Cell[BoxData[
  ButtonBox["Map",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Map"]], "InlineFormula"],
 " are automatically applied to components in a ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " object. "
}], "Notes",
 CellID->24793],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " is treated as a raw object by functions like ",
 Cell[BoxData[
  ButtonBox["AtomQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AtomQ"]], "InlineFormula"],
 ", and for purposes of pattern matching. "
}], "Notes",
 CellID->13716],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Dimensions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dimensions"]], "InlineFormula"],
 " gives the dimensions of a sparse array. "
}], "Notes",
 CellID->28749],

Cell["\<\
The standard output format for a sparse array indicates the number of \
non-default elements and the total dimensions. \
\>", "Notes",
 CellID->5656]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->716364897],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->46640407],

Cell["\<\
Construct a sparse matrix with values at only a few specified positions:\
\>", "ExampleText",
 CellID->448487540],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "1"}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "2"}], "}"}], "\[Rule]", "2"}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", "3"}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", "4"}]}], "}"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->64886468],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "4", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 4, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->63571722]
}, Open  ]],

Cell["View it as a matrix:", "ExampleText",
 CellID->87933516],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", "s", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->563873289],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztVi1vwzAQdZykTdeueLC8YLh/YEP7EVE1qQXTpq6grDAwMLA/obCwMDAw
MDAwsNA7fyR2PUtzF8NGSnw5nd87P3+c3+Lt6v0j3q6X8ex1E3+t1svv2cvn
Bly+hxBawDt/QmATsNi7IARa9RvSr384HAh70Jz97/d78e+zqICZZVmeTidq
0n8fACdaO2zRiqLQe2dZpmKGNJ/2ARs93OAdMJjL5bLb7SSP33o5Fee1RJyy
vp1X6JIkCcBRE3cMOM/zsDcyCAlyXiMzjeq6vjV3qj6GNtJmSUWWM9pfFZCE
LxgHDGZv1KohXJ6Rh2ZjWoUjLc7c+/kepek4hjYUrb2Ormb7fzxjcr1Cx84Z
JhqD+zE8agwj5wz6Po6cM7if7/vuTtPUIkrWbjUKzs6maYiYL3VXT0XLa2hV
VcfjkZrqWQ4FRFRwHvXX6jfXifP5bKhxkJZgtMOm3kGXL2hyVZH1u0Vojfnb
O9T0lQwY1LDLlp0/gYzieWMYMctU5CfzDaxQ1TNI3n+0G5XA5heIvtgShWPT
cWFxVrWrCLe9xV0SeT9r9hoh\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{57, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->385408191]
}, Open  ]],

Cell["Convert it to an ordinary dense matrix:", "ExampleText",
 CellID->85717782],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", "s", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->218092258],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->64236516]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1041],

Cell["Make a large sparse vector, matrix and depth 3 array:", "ExampleText",
 CellID->114675949],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SparseArray", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", "^", "i"}], "}"}], "\[Rule]", "1"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "10"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5337929],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "10", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 10, ">"],
     Editable->False], ",", 
    RowBox[{"{", "1024", "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{177, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->386107]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SparseArray", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"2", "^", "i"}], ",", 
       RowBox[{
        RowBox[{"3", "^", "i"}], "+", "i"}]}], "}"}], "\[Rule]", "1"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "10"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18211664],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "10", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 10, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"1024", ",", "59059"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{225, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->402286151]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SparseArray", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"2", "^", "i"}], ",", 
       RowBox[{
        RowBox[{"3", "^", "i"}], "+", "i"}], ",", 
       RowBox[{"i", "^", "5"}]}], "}"}], "\[Rule]", "1"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "10"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->647811041],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "10", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 10, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"1024", ",", "59059", ",", "100000"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{280, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->654032626]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->102094461],

Cell["Construct a tridiagonal matrix using patterns for indexes:", \
"ExampleText",
 CellID->504086207],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i_", ",", "i_"}], "}"}], "\[Rule]", 
       RowBox[{"-", "2"}]}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
        RowBox[{
         RowBox[{"Abs", "[", 
          RowBox[{"i", "-", "j"}], "]"}], "\[Equal]", "1"}]}], "\[Rule]", 
       "1"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->225514021],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "13", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 13, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->258066886]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", "s", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->907848603],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWDtPAkEQPjhQRATlkRgjhl+jsfBHXIgJFEZFTOiupKSk5CdQXklJSUlJ
SUlJec6+uGPYO+6xd1BIArOzjDPf7Xz7GebN6HfeP4x+t220XnrGV6fb/mk9
f/ZgS89ommbC+/Veg7UNK/o2bRus+zNPPvXJZGLTl/ZNfdM0ua/TqBxdLpdL
y7LIkvg6JKwjWwObB/vA7YXIvlgscLbxeOyuQcJt8YK1Vg2xW6dpdru0/mEU
Q7PdbgeDgYNGF7sMEEOnFE2Vn0YO7ReoPxwOoThZZnd4svP5PK8cxyPyL6kP
LYXG7ten3Vmv18mcRxP5rC8Ou9w4HCaqx/GEfHYXoBnsOqSGQ87WgugD38pI
0RDMsptIbBZsk/tX6O/k2X7/ozzOFStbkdvbQNnCcCYYO0ooKnkcXip2kzoS
rGPpnwVWsOvUEWDtKqaOQCUvZSrmVq8S96uBsp2rppxOxbzUq8a/vwuUTc6W
aLyQcywOa6PqVfJIjulV8giO6VXyCI7pVfIIkuelW8Vk6tWww9y2c9WU9KNI
f/3US/zXCHau7NeGGl7EYQvGEU+vVCKJplcqEUTTK5UIoumVSgSn4iVRMT/1
CnfbzlVTwkSNRqMAUc4MzR0Fv983m43Nb5GfegnLurRarabTKVm6pxCWZfFJ
GuWBUnbIdys042w2k8yI4ME4RqHQKrXLDw90ZG9mhieKuG5S5+JwwMGRhQ5V
UL04+iXfLZNKcPr0yfnkynn+MqoXR7286x/McDkONjjc1U2BpWVUl6ERN8xL
wYRt0GiT5cr8AfFDa/o=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{127, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->171211005]
}, Open  ]],

Cell["Construct a 10,000 by 10,000 version: ", "ExampleText",
 CellID->678175158],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i_", ",", "i_"}], "}"}], "\[Rule]", 
       RowBox[{"-", "2"}]}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
        RowBox[{
         RowBox[{"Abs", "[", 
          RowBox[{"i", "-", "j"}], "]"}], "\[Equal]", "1"}]}], "\[Rule]", 
       "1"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"10", "^", "4"}], ",", 
      RowBox[{"10", "^", "4"}]}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->193685268],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "29998", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 29998, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"10000", ",", "10000"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{257, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->537013807]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19656203],

Cell["Make a sparse diagonal matrix:", "ExampleText",
 CellID->192586105],

Cell[BoxData[
 RowBox[{
  RowBox[{"d", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", "100", "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->151624841],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"i_", ",", "i_"}], "}"}], "\[RuleDelayed]", 
     RowBox[{"d", "[", 
      RowBox[{"[", "i", "]"}], "]"}]}], ",", 
    RowBox[{
     RowBox[{"Length", "[", "d", "]"}], 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->302101121],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "100", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 100, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"100", ",", "100"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->20495727]
}, Open  ]],

Cell[TextData[{
 "This is equivalent to ",
 Cell[BoxData[
  ButtonBox["DiagonalMatrix",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DiagonalMatrix"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->127922396],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "\[Equal]", 
  RowBox[{"DiagonalMatrix", "[", "d", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->536438955],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->385854297]
}, Open  ]],

Cell["Except that as a sparse matrix, it uses much less memory:", \
"ExampleText",
 CellID->117422135],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ByteCount", "[", "m", "]"}], ",", 
   RowBox[{"ByteCount", "[", 
    RowBox[{"DiagonalMatrix", "[", "d", "]"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->91791708],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2072", ",", "80080"}], "}"}]], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->185752698]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->502417044],

Cell[TextData[{
 "Construct a block diagonal matrix using rules with ",
 Cell[BoxData[
  ButtonBox["Band",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Band"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->552031581],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"Band", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], "]"}], "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"5", ",", "6"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"7", ",", "8"}], "}"}]}], "}"}]}], "}"}]}], "]"}]}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->366198294],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "8", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 8, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "4"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->329185687]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", "s", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16975159],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlmL1uwjAQgE0Sp+GnzB15jS4dW5Y+RIQqwVC1AgY2RkZGRh6BkZGRkZGR
kZGRMb2zHWxOBjlKQlGLRGwfl3y+Hzs+3uNh9+MzHvY6ceutH393e51B6/Wr
DyK/whhrw/f5iUE/gZ74tpMEWvPK8erP5/NEfJgPFx9UG6p9FEK8V/5eV/IH
IR+Px8Z9jAWiu91ul8vlScpPdwsdxmpWaYOQ7FphOt/NZkO5s9nMnI0jl1pY
vcI9Ho+j0Uhz/VQq0XIehXKlnyeTCUCw65243nq95jl4qIXDSMghYBC2c4Lw
6H6/z2pZk5CiK5bpXDG5Oq+ycLNIJR2cKlP/Ap0n56sBs5+rFsfV1EtKv2J9
ygsZ/18t6k/aVp2eUlZORIXT3VbC3+Gm6wLboJR41olldFwrnUjfU2422jI/
MMZusbjXdf17O0lTtenbrIidxG315NlDIgshTGddOukWuySelzwVDxZofhks
amPNGN/yHWDuDOVwzaz3jP02W9bf65rOojWdTh20dF1jasF57XA4JCqOXMWE
W/wpo7Lb7RaLBXbNUyIcW1UNImsDkn8FnE5Xq5XlTA5TV7OhXOu7MRMRvHpW
Z9C6ihOCW812jagjpoke+JXa5lYtXa4ZPfCZsEbZoG0KyJPz7P4hebZvEGUh
ZSPmz5eQECQX44+7BPrOdtoWPlX/A7DKD4ccWXo=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{72, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->544420996]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->89444105],

Cell["Convert an ordinary matrix into a sparse matrix:", "ExampleText",
 CellID->88226687],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SparseArray", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->465934725],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "6", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 6, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->579411685]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->222833362],

Cell["Make a rank 4 sparse tensor with values at random positions:", \
"ExampleText",
 CellID->36970019],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"rules", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"RandomInteger", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], ",", "4"}], "]"}], "->", "i"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "10"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->388726075],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "1", ",", "1", ",", "1"}], "}"}], "\[Rule]", "1"}], 
   ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "1", ",", "2", ",", "2"}], "}"}], "\[Rule]", "2"}], 
   ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "2", ",", "2", ",", "1"}], "}"}], "\[Rule]", "3"}], 
   ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "2", ",", "1", ",", "2"}], "}"}], "\[Rule]", "4"}], 
   ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "1", ",", "1"}], "}"}], "\[Rule]", "5"}], 
   ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "2", ",", "1", ",", "1"}], "}"}], "\[Rule]", "6"}], 
   ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "2", ",", "2", ",", "1"}], "}"}], "\[Rule]", "7"}], 
   ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "2", ",", "1", ",", "1"}], "}"}], "\[Rule]", "8"}], 
   ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "1", ",", "2"}], "}"}], "\[Rule]", "9"}], 
   ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "2", ",", "1", ",", "2"}], "}"}], "\[Rule]", "10"}]}], 
  "}"}]], "Output",
 ImageSize->{563, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->391474820]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{"SparseArray", "[", "rules", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->176369732],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "7", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 7, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "2", ",", "2", ",", "2"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{203, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->320268]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->299488094],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWNtOwzAMTdfLNqa1gyce9zXwxEdUE9L2gEBjX80+ojRZC5XrYDuXgUQn
ravTxD72sRN3T/Vp//xSnw67evt4rN/2h9379uH12A6liVLJh1KqulftfdPe
ma/+nNuvUpm+pv1YI5aXQK6I+Tee6yl9vvhWgfFJ8caO7+aX4xuafyin+nK5
erI0a8VbRLseh17Y5mPosPVS+zBLufZd8YSKz92V4uPKDyXPmhDZpddrMQfj
RTdeEOsXTH1zyziFD+rn4ufagzUfGr/UH4zlXI3PRi4eCT+YnVj8LLtxKn9j
51ecqjJa8i/Z6LzEFtsRMGt6HszNn7XOrU8p5JgtmUd825j/sfxy8ZOrR+ax
jMmFs8f+TMLTfBbEo3AcjmsVQyju0kbYsNN8KK9ZWtboKLVHQd3Y3j+UVywr
ZUTEUg+gDPXzUPA4gF081dFQ2O1xK5CchtrcuJPmdGL0xDnFdB5liKcwzvhq
nFkKCfUmBjnFowpXwffPkIilHrAqikTB40D63k1h94kbVZ08Jv9SlxeSqTjV
0vfQJUv7f60SqgNwqRK9b5p52fc4ja/vonh8TbUgrYVRlzTVhMUj+J8Z1Xuz
To6BPKw5DsrptJDrmiokZoW47dFSDobRvXa+8KolhBYtVt0vfA5PZ2o+td52
WpcWfdhOKLEvxYPh0z3BRhgf23wpnnSgT+OAGerLD+tfGyOcGXcq+QQv761l
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{490, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->395488579]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArrayRules",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayRules"]], "InlineFormula"],
 " produce the minimal list of rules needed to specify the ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->75666710],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayRules", "[", "s", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->395170989],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "1", ",", "1"}], "}"}], "\[Rule]", "5"}], 
   ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "1", ",", "2"}], "}"}], "\[Rule]", "9"}], 
   ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "1", ",", "1", ",", "1"}], "}"}], "\[Rule]", "1"}], 
   ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "1", ",", "2", ",", "2"}], "}"}], "\[Rule]", "2"}], 
   ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "2", ",", "2", ",", "1"}], "}"}], "\[Rule]", "3"}], 
   ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "2", ",", "1", ",", "2"}], "}"}], "\[Rule]", "4"}], 
   ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "2", ",", "1", ",", "1"}], "}"}], "\[Rule]", "6"}], 
   ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"_", ",", "_", ",", "_", ",", "_"}], "}"}], "\[Rule]", "0"}]}], 
  "}"}]], "Output",
 ImageSize->{446, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->189746004]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->315374579],

Cell[TextData[{
 "Many typical operations work with ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects as they would for equivalent lists:"
}], "ExampleText",
 CellID->42469512],

Cell[BoxData[{
 RowBox[{
  RowBox[{"m1", "=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"i_", ",", "i_"}], "}"}], "\[Rule]", 
        RowBox[{"-", "2"}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
         RowBox[{
          RowBox[{"Abs", "[", 
           RowBox[{"i", "-", "j"}], "]"}], "\[Equal]", "1"}]}], "\[Rule]", 
        "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "5"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"m2", "=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i_", ",", "i_"}], "}"}], "\[Rule]", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "5"}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->172330095],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"MatrixForm", ",", 
   RowBox[{"{", 
    RowBox[{"m1", ",", "m2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->115720091],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWjuPGjEQXlgex+MegYsURbno+vyPPKTkR6BTpLsiSnK5SHSUlJSUlFtS
bklJSUlJSUlJuRm/sG/i9fp2zRsk1o9dz4w/z4y/BX9rPd1//9F6erhr3X56
bP26f7j7c/vx5yN0+TnP8xbw/fLGg3oENfpdRBGU6rVOrv5gMIjox/tN251O
h7ebtN3v93n7M20vl0s2xKtRKfTqT6fTMAxJtQAXHxReo5JIK0L5lpcloX0y
mZBqg7ZByHw+V+XUY8raMzlgNR9XVayStvvkQh6PxAfqTKdl7zUVs+ql8/j/
qZLAqN1uy1n1ej2jHdXMvXVkHbNjNpsxCDgqVWEd7y04R6XBV6WA+s9ou9vt
gnJSvaJtWPrRaBRviXtcymg9Kitc8uPxuOgcj3da/eDlEDASB7CH47J9HGjU
KDHoFo8b1GZ+KrMHwwP8hN/fLB5BEPCZq3jIjOgej/eoTT1QybHbxQOCE6Ji
k3josyrLHjKbX1rZsR5U8gCKmk2lFWTtdDsfKfNQ3vB2BY3DsxFy4na+OpdX
MVrzN0HL19PoHRuN/QczpiovrxK0xPmPYEw13j4zWvOS2LaLYhxNSfPIHtVY
o/4pc1RnwSGODZ0fHRKYBx2fL2DmUzs6BDDXqR4dAoeUF3VsR2U5gqU0EmZj
Yjtk/Hmk260K/G4BSbPdgX0+nvJt9lau4JFWahHJyZ+kO5WeR89jn3SvjfhI
zakW4e9x7K7J779C47Bc/BaB4wizPdEv4khvPUa4iLToc0+6PKfPmTj7iUi1
y8NZ8p05C5aQjBy777OCXMupsLLliHZoZdkrXKBESvIDNEGHIeTGo5L4436g
o/ehpIxhh1ASv9wPhNLlVDuEkvjnCSGXeXs/cVJZrY7Nvo70u7MNq1XZrN1u
vFvs63iku3272KXfGMmMTKxTvM3Z+nccy8T+rbcG74dZ8o/LrJQl/6R5l8Y4
ZOOEh4REOt53SAik43WHhEA63nZICBxrXiS7jImFvXS3imNhdrvV/v6zuP3R
8qRJmtHyjJrN6H6/v1jQI25kXU0sR5QsGmaz2XA4JFXdqQsTy1H9x/NBCIgi
VfXURBiG/KQbjSKn0azvZVgBOPisEX8EZ5ns0Rwf4+rpDRUVWCiOucDYJecx
4SLPXBFcyOmv8lbxwCcW8bzX5R8yllgWlbGG343WhQfzw/l8zlyTPUXxyEPE
XCIrsvAffe8F0QRe2BTz536x2fnD5J+dYGXrLf3hQmeNcxxUjeyfOwAjCIJN
4rE6A8cSMD9nzPBgEMVrdx8lF0hvE7Vxvlo7KnxvY6gQZmhiRqL8EJmZT115
XpwP93L/AMcInuk=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{239, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->5093019]
}, Open  ]],

Cell["Arithmetic works elementwise just as it does for lists:", "ExampleText",
 CellID->1013140],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"m1", "+", 
   RowBox[{"2", " ", "m2"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->419680251],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWD1vwjAQdZLSUgp7R35NKwZm5ghVgqFqRRmyZWRkZOQnMGZkZMyYMWPG
jBnT8xc2qYkcaA1FjpTcnXU5P3znZ3JDfz55e/fn07Hff535n5Pp+Kv/8jGD
Ic9BCI3gHjwj0EvQyD0qS5Dys4Wf3nq9LsmFBsQOw5DZHvG6I2qSJFEUYRXb
HgTsVuQTyBaT2H7g0eM4rkZbrVbyHPi1kl+go06D0S4Jsx894nVPvIqiCIJA
oPH4KAVE0RlAQ9dmsVjA1Fh192jc3W7XMooC0grJPURBMpRlmfk1EXUmoxE1
aRYNpIdujwujaZeHu8ZRosF1o9qZWLoge8x+rLynjja0XkfWtcp03G5rRWtS
M3rVUfWyOCyO28GhYjWZzbjd0Yp2rRxzOVY7xmbc1jst1NVyWl3UnYEWh8Vx
CzhkVlOxmf2vdpoXzm8dm/FTRG9d6Vfj79TFOdVicVgc/wEHZrU6Nmu2+66V
Y5p4LZdLDS/Rg5O94Hs/z3O+rnVsxiXNUpqmm80Gq3LXIooi1ok75wxsMkp7
KNvtVtFfgh/GMJpFA/k46Lnp9SP/Co2oA4HGhSyZWhPMGy7kgczH+sFiLVyD
KH7kgKGhTUjzaMS8FI2841SMxmWPeNP+OnK+AcvHjT0=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{87, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->291159855]
}, Open  ]],

Cell[TextData[{
 "Matrix products are done with ",
 Cell[BoxData[
  ButtonBox["Dot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dot"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->465055819],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"m1", ".", "m1"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->103729235],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWLFyGjEQFXfGxpjENrZnPIkh/ppkUuQjGE9m7CKTxHFm6K6kpKTkEyiv
pKSkpKSkpKRUVtIeJ5blciedCUWYgdVKq317Wulx2i+dl8ev3zovTw+d+0/P
nR+PTw+/7j9+f4ausCKEiOD7+VZAW0JLfyMpQdq/VfUbDodDqT/ip9ajKEI9
1FZHujmbzeI4Vk2lh+DwGuUVyCrIFup1lOeJ9+l0Sr0NBgMbQ02XyQfaosn2
XusJ617RJnqNnfVWW61Wq263m8YRJr0mFBOXYxxNXAHl8xjkGzJu9F6vB3Cq
GawjCCaTSdUD+V3GE1N8SB8kcRNfZ2KxWPiuwHvtINWFOJNmF1zIzd1jY6c7
zQf7ztIFItvjJgJYerPR/0EEl8lKo15hI6jKzXOlZADyA0rl9Wi9ouk83tvv
/1ZkXXfxVBvlSS5v/D5xYyZqdVxiBJSTTtlZ1KrMNeC5qc728ra1EqPZZigV
ieq42xopE5dyQ52Mt8n4a2JTXmo5Yds8ZfNTA/tbqOfzdqissX8rldMsfjrF
8Xz8b7jEl5HobnXDduMi/n+8KLY/CzVKiaMI/5SDWJR5Xgf1b5zjhqo4KIt7
zlA2c3k7VEbYv9W5zOaeK9Qvc3kzufTlHP4dPN8+STjVj3l8Imiwc334xyca
fRN0ZCEfXPtG6sJFZWIXZSQfbHWesvjpRhY5T4fKGkWs+v1+Dqu0JmVbwQ16
uVzqdMhsfkru0CZL8/l8NBqppn33j+MYK1P827QbL/G9phY2Ho+ZCgw8EkZX
IwgX0oWXsiKA1d+oQdFq3AlBuGV95TshWXGk+U7jCCAbSV5d2YjvVQwQwBrr
p8WqJ6lAevPBbuQtLIzAlN32EwHBWteSdvFRcn5utHVkfFX+AAS1prE=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{127, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//MatrixForm=",
 CellID->107466465]
}, Open  ]],

Cell["\<\
Many linear algebra functions are done efficiently with the sparse form:\
\>", "ExampleText",
 CellID->787358487],

Cell[CellGroupData[{

Cell["LinearSolve[N[m1],{0,1,2,1,0}]", "Input",
 CellLabel->"In[5]:=",
 CellID->84233051],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1.9999999999999998`"}], ",", 
   RowBox[{"-", "3.9999999999999996`"}], ",", 
   RowBox[{"-", "4.999999999999999`"}], ",", 
   RowBox[{"-", "3.9999999999999996`"}], ",", 
   RowBox[{"-", "1.9999999999999998`"}]}], "}"}]], "Output",
 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->405445031]
}, Open  ]],

Cell["Many other list commands work automatically:", "ExampleText",
 CellID->71796658],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"f", ",", "m1", ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->13691407],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "13", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 13, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}], ",", 
    RowBox[{"f", "[", "0", "]"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->662057432]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->418669584],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmzFv4jAUx0NycBXX0qpVTydVlfpprurQD4GqSu1Q9dR2YGNkZMzIR2DM
yMjIyHaMdGNkdB0nwfBi1w4kjp0YiSTvxX5x/nHfy6/C992Pp8eX7sfzQ/fm
9q377+n54f3m7+sbdnkNx3E+8ffuj4OPET4i30+E8D7aXuCti52/4v31nnYS
p0OiNsOtNxqNEPmQ1o4XXpttXyk+fwHsFrH7/X5se+QufpDD+XweBEHibTqJ
n/YO/aHZBP7zktq7HD+vfZvjbyVPcTabQVV8349bwV5wlC5xbmwSI30t+ER0
jgLbZ+3flhpFpP56ve71elR9L/FGDyAVW2fd9FCf99cB2/0k9mAwwGJvRk/0
d6fTacsgxfTQ/VjQP9Ibp1qccHf1JtlmuVyyouqsmB66nwDbY+pOq9y27rQi
hlfl1RrxPX5XqcrqLbJ5/TqsUaT0xEkjev3h6GnncTFV8wihnbeTBlP9MHt7
cW833m/bvws4H+6bnPPHwG6D8bLv4r/RrU7QYaRxCc6fS1+1TNKANux/JnUX
vGxsClnw/Lz4cqqYlFPVZEM4u7KOwuq+Lz1Y5VXzg1VcNTmoUVxH8iiKHXh1
0c5dk+tjEbSRhSY6gv5yb866ckS+tMGjC9i+HNrIShOi+Gppoyx6yEo/OmVT
M/JgPjWhSrqr4gSrvGpOsIqr5gSVihdDG7rxwmFUVKW5W736uA9t5EkTIpqp
M23I0oUa2sibJoqlDVPooRzaqFMe1OkNrF6cUCXlzeCEKiluBifoQBvV4gUd
aMPWx2J0Z9GGSpqwtEFpY1+6YNPGcDgUXrVMmpCjDboGZfsufN9frVYI8TOw
KfSQtf0psReLxXg8TsadqBIEQbzSQ5RN65cN84kSqT+ZTBi/cccTMn4mMv85
qxsz5Kk/zmw7azqiVvIrmupEDnnqTmsH1d3FGUc03+vEDflECd+qXJxNiD+O
Qec3L39UkR4O690BynlbekYLkjZeWy0LmcUpnVMEoZooZM4nq6udxhcSgvj+
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{232, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]//MatrixForm=",
 CellID->93686615]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27055],

Cell["The unspecified elements can have any value:", "ExampleText",
 CellID->550841534],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"i_", ",", "i_"}], "}"}], "\[Rule]", "y"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3"}], "}"}], ",", "x"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4980511],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "3", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 3, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3"}], "}"}], ",", "x"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{185, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->224570059]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", "s", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->50252504],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdVr1uwjAQNkkIPyVTVZURdWgrMXTmBdqpDxGhSjBUrSgDGyMjIyOPwMjI
yMjIyMjIyOie72Ls2CZyGaqqkeL4Tv7O9+PPl9d02Ht7T4f9btp6GaSfvX73
q/X8MQBVWGKMdeBtNxnMOczw7XAOXxofYYxAmaBUFmM4n885PuwOZYEhOUZ5
PB5ncoioCKfb7Xa5XIppAEMAIPmtGXLDaRV23Ww2ptXZbKbvFSkUY1eWJsl2
qCDgeDyORiNlMZRaMorRBhoq0fyCkVVRnkwmAJFxkZVgvV7HLnTOG/ICkgKp
yeMxrv1+jxCPuFBTPmky/yqOvEv7+RoVVUPIImhyRD6xzBUdhjO2n4walQpW
Kfk/rrrmxKOm1+obnmfArRfKrKTJI7OyVS+r9vmTJ9o+hzUvizqvdD41Mn39
51YsNvjbOcMvi031C6N18cvmU/Wi2vzV0/77q0QyRXEeUD+dTgtX0+2lanmP
suprOgpur8Ph4EK5bkpdpvt3t9stFgsx1e9IuJKzbib7xJlbPaehU7FarRwd
A5zM9ilrfuq8SjQ/MUe5vmX2UzcvbDsqq8pOALEh3oNFdpQibwHEQgTBaKKT
X9yHPWYlYiO2UFkOqc2KaduQaZX+N8RK3wrMKwI=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{57, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->930041877]
}, Open  ]],

Cell["Symbolic values can be replaced with local definitions:", "ExampleText",
 CellID->1039194561],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "=", "0"}], ",", 
      RowBox[{"y", "=", "1"}]}], "}"}], ",", "s"}], "]"}], "\[Equal]", 
  RowBox[{"IdentityMatrix", "[", "3", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->128170974],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->252057999]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->195905179],

Cell["Construct a sparse matrix with all machine number values:", \
"ExampleText",
 CellID->904000384],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ns", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i_", ",", "i_"}], "}"}], "\[Rule]", 
       RowBox[{"-", "2."}]}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
        RowBox[{
         RowBox[{"Abs", "[", 
          RowBox[{"i", "-", "j"}], "]"}], "\[Equal]", "1"}]}], "\[Rule]", 
       "1."}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}], ",", "0."}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->69266030],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "13", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 13, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->42357044]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", "ns", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->245943095],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmbtuwjAUhkMCVVVxabkVVAaqtq/SqkMfIkKVYKhaUQY2RkaWSumGxAsw
ZmRkZGRkZGRkTH0LSQ4mJLGTIrWRiH0c2+ePffyBDi96r/36pvc6Lb351NU/
2p3WZ/PxvYuatJSiKBP0ea4pqG6hGvlMLAuV7nsG37XxeGyRS/ki9mAwYLZG
eqVJdblcmqaJq9jWFNquorJyxC6jMoNKjdkNYJ/bKhaLBfRqGIZbCx5m2Zfi
mqMs8LRKpt899eg8PIqq3m63/X7fUa3ZrVQ4fYu9OeohWm+AujpbvTRoLxB7
OBwi57iq7vSo8/k8I13HHbDzxEYhggLF65/s4nq9jmc97oGds7zR6tbhRLZ8
HQ/AzlosEujxSkzHLbdXwd4H1pTiqsFRorE5YYlj/p7Zl2Acf7bv/15gXaMS
MgvsYiCv/NiKk4n5A6NE9IpRsQzs69iVQC6WElcAiVhMXAFk4VXiCvgUjLYX
PCq6aVhidj3QbKfKqN+nYlgKQorKoKJc7vkzVkRvVP7xT4/IeQzLv/gVHONf
/AqO8S9+BcH4J6LDTUUeDRvMrgWa7VQZlXwvvL8iFIxGxTPLGxlxck8GFaFe
Mf6JnAOoJBr/ZCqIxj+ZCqLxT6YCEf6JUtGPhvZvyL9DxdFoFKCXk4N09zIM
Y7PZ4CqkXlgKQptG5Gq1mk6nuOrOzpimyTKRJIeTKP38n1LVs9mMk2NDC8Xe
xf4GkclCfmvV3mFPzhFmbnPAr8gp9NPhxJSjQ0U7WQD+RHjIb8XRpaLVJ2/O
surO+8M4EaHhYf97uXKmgyZecfWCO1b+blSAX6oG+/Ejol2SXxzs/wkl9QNS
uAuR\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{162, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->323649898]
}, Open  ]],

Cell[TextData[{
 "This is the same as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["N",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/N"], "[", 
   StyleBox["s", "TI"], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->4078135],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SameQ", "[", 
  RowBox[{"ns", ",", 
   RowBox[{"N", "[", "s", "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->197558386],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->20034272]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4123],

Cell["Create a list with a single nonzero element:", "ExampleText",
 CellID->15333],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"10", "\[Rule]", "1"}], ",", "19"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25680],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   "0", ",", "0", ",", "0", ",", "0"}], "}"}]], "Output",
 ImageSize->{353, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->67938642]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", "1"}], ",", "5"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2586],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{532, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->932160446]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1040],

Cell["Plot a list of rules:", "ExampleText",
 CellID->26449],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"SparseArray", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "->", "2"}], ",", 
     RowBox[{"10", "->", "7"}], ",", 
     RowBox[{"3", "->", "2"}]}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19726],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    LineBox[{{1., 2.}, {2., 0.}, {3., 2.}, {4., 0.}, {5., 0.}, {6., 0.}, {7., 
     0.}, {8., 0.}, {9., 0.}, {10., 7.}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 10.}, {0., 7.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 125},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9094415]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21312068],

Cell["Represent a network with an adjacency matrix:", "ExampleText",
 CellID->16226076],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
       RowBox[{
        RowBox[{"Mod", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"2", "i"}], "+", "j"}], ",", "7"}], "]"}], "\[Equal]", 
        "1"}]}], "\[Rule]", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"20", ",", "20"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->54131642],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "57", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 57, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"20", ",", "20"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->106325491]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", "s", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->136784259],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.5839675387217873, -2.0365239759962837`}, {
    2.172522091783296, -1.1151868921845083`}, {
    1.6991245091831342`, -0.3892515649356545}, {
    2.5194530620739464`, -2.0370551217499013`}, {
    0.8861776498115206, -3.201890503116491}, {
    0.9321940668518267, -1.1143439312315795`}, {
    1.5515457934832744`, -2.423387373245182}, {
    0.8644965560889937, -1.7543864972616587`}, {
    2.428399153974869, -0.7389676689195035}, {
    1.5535991474771407`, -0.8119101652307834}, {
    2.2391090543978462`, -1.7555535393545927`}, {
    1.3892452375580553`, -4.066137686650293}, {
    0.5210943141714584, -0.9970677565212269}, {
    1.5519896062207703`, -2.095597561363861}, {
    0.38925156493565455`, -1.727619515257912}, {
    2.582867055907407, -0.9980925355527828}, {
    1.4068671473321228`, -0.39005789434344385`}, {
    2.715194315129996, -1.728566059253276}, {
    0.38925156493565455`, -4.069683310960695}, {
    0.6781247362195624, -0.7373170708757066}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 20}, {1, 6}, {1, 13}, {2, 11}, {2, 18}, {2, 4}, {3, 16}, {
       3, 2}, {3, 9}, {4, 7}, {4, 14}, {5, 12}, {5, 19}, {6, 3}, {6, 17}, {6, 
       10}, {7, 1}, {7, 8}, {7, 15}, {8, 13}, {8, 20}, {8, 6}, {9, 4}, {9, 
       18}, {9, 11}, {10, 16}, {10, 9}, {10, 2}, {11, 7}, {11, 14}, {12, 5}, {
       12, 19}, {13, 3}, {13, 10}, {13, 17}, {14, 8}, {14, 1}, {14, 15}, {15, 
       6}, {15, 20}, {15, 13}, {16, 4}, {16, 18}, {16, 11}, {17, 16}, {17, 
       9}, {17, 2}, {18, 14}, {18, 7}, {19, 12}, {19, 5}, {20, 17}, {20, 3}, {
       20, 10}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        "14"],
       Annotation[#, 14, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[16],
        "16"],
       Annotation[#, 16, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[17],
        "17"],
       Annotation[#, 17, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[18],
        "18"],
       Annotation[#, 18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[19],
        "19"],
       Annotation[#, 19, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[20],
        "20"],
       Annotation[#, 20, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.5839675387217873, -2.0365239759962837`}, {
     2.172522091783296, -1.1151868921845083`}, {
     1.6991245091831342`, -0.3892515649356545}, {
     2.5194530620739464`, -2.0370551217499013`}, {
     0.8861776498115206, -3.201890503116491}, {
     0.9321940668518267, -1.1143439312315795`}, {
     1.5515457934832744`, -2.423387373245182}, {
     0.8644965560889937, -1.7543864972616587`}, {
     2.428399153974869, -0.7389676689195035}, {
     1.5535991474771407`, -0.8119101652307834}, {
     2.2391090543978462`, -1.7555535393545927`}, {
     1.3892452375580553`, -4.066137686650293}, {
     0.5210943141714584, -0.9970677565212269}, {
     1.5519896062207703`, -2.095597561363861}, {
     0.38925156493565455`, -1.727619515257912}, {
     2.582867055907407, -0.9980925355527828}, {
     1.4068671473321228`, -0.39005789434344385`}, {
     2.715194315129996, -1.728566059253276}, {
     0.38925156493565455`, -4.069683310960695}, {
     0.6781247362195624, -0.7373170708757066}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{141, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->642591672]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->324580906],

Cell[TextData[{
 "Solve a boundary value problem ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      FractionBox[
       RowBox[{
        SuperscriptBox["\[PartialD]", "2"], "u"}], 
       RowBox[{"\[PartialD]", 
        SuperscriptBox["x", "2"]}],
       MultilineFunction->None], "+", 
      RowBox[{
       RowBox[{"f", "(", "x", ")"}], "u"}]}], "\[LongEqual]", 
     RowBox[{"g", "(", "x", ")"}]}], ",", 
    RowBox[{
     RowBox[{"u", "(", "0", ")"}], "\[LongEqual]", "0"}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"u", "'"}], 
      RowBox[{"(", "1", ")"}]}], "\[LongEqual]", "0"}]}], TraditionalForm]]],
 " using finite differences:"
}], "ExampleText",
 CellID->624007364],

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", "=", "1000"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"h", "=", 
   RowBox[{"1.", "/", "n"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"xgrid", "=", 
   RowBox[{"h", " ", 
    RowBox[{"Range", "[", 
     RowBox[{"1", ",", "n"}], "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], ":=", 
   RowBox[{"1", "+", 
    RowBox[{"100", " ", 
     RowBox[{"Exp", "[", 
      RowBox[{"-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"321", 
          RowBox[{"(", 
           RowBox[{"x", "-", 
            RowBox[{"1", "/", "2"}]}], ")"}]}], ")"}], "^", "2"}]}], 
      "]"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"g", "[", "x_", "]"}], ":=", 
   RowBox[{"Sin", "[", 
    RowBox[{"Pi", " ", "x"}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->306139826],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"id", "=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"i_", ",", "i_"}], "}"}], "\[Rule]", "1."}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "n"}], "}"}], ",", "0."}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"d2", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i_", ",", "i_"}], "}"}], "\[Rule]", 
       RowBox[{"-", "2."}]}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"n", ",", 
         RowBox[{"n", "-", "1"}]}], "}"}], "\[Rule]", "2."}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
        RowBox[{
         RowBox[{"Abs", "[", 
          RowBox[{"i", "-", "j"}], "]"}], "\[Equal]", "1"}]}], "\[Rule]", 
       "1."}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "n"}], "}"}], ",", "0."}], "]"}]}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->10535879],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "2998", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 2998, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"1000", ",", "1000"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{230, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->99863050]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"LinearSolve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"d2", "/", 
       RowBox[{"h", "^", "2"}]}], "+", 
      RowBox[{"id", " ", 
       RowBox[{"f", "[", "xgrid", "]"}]}]}], ",", 
     RowBox[{"g", "[", "xgrid", "]"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->323886016],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Transpose", "[", 
   RowBox[{"{", 
    RowBox[{"xgrid", ",", "u"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->495343823],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlWVtzFEUUbnYuAUIQs0FQvEQt0RItb0hZ0c1uQthApVJBvKBIlDVGkhIM
hKBgKXgvxfgkWGYxD7G09NUqCl+t8tny1X/T9umemZ4+883O7lbeTG0629Pn
O7f+zumZyWRjaW72dGNpfqYxOL7YODM3P3NusL6wqC55G4QQN9Tv7E6hvkv1
Tf/ukFIKj77pH9GkQfCrl/T8YH21WllRH1Gmwft2+a9o3YOo9/R8bPR6hNql
UQf2/5hBlRToLLOxVQ391UpTeKO15h83/6VlH9p5R8+PH/stQvaqIdTIkWqM
3AmRJ/V8anItQm5Sg8+QgxA5w2xuVIOnkdXh5pWv/qTl3RB5gmWlRw2lGDl9
7Fda3gOR0wwZppGRzcecnL7GchrqHVAQY0rshXaOsqwEiR2blX0a2RPZ8ZgG
uhayay/q+S8//+P6MtwcH7tOS0Nao0b5FiXMnjtXAqb5CPBXR2ncFRUDM3TT
P+SfUZNS24alw3qu+BhZ8lP5VBsgajkxBFGeaIXUTbJcBHEujkyt0dJo17mY
0PPzSzeBh++e+l0c6FrzIcZ4n+3fuMOIMPU3rWU8T0sU+SHIyDpjvsdQEw7r
62yXSrF0VF2T0MZ+5lmMWlFpo6UpiBpl3DMoWyeHIWpEunVpUBMHV6P15yGq
xrJgUCaopA6SLFQZx0zOTDC09AK0UWH8MTZqSX95CaKeg7kzxKCllyHqWZg7
m4WjEDUEc2ez8IqThaGCnL0KbTxDQ5gwiD6aB8cdjrfT9faxXUhYFfHDaOym
Hp+GO2WZNy3Xq+vthZbsPr3eUQyk+CnIF6vxjRYaPZDlJ6E+0xxo6USOPh4p
nz8B9Vr2NBw+xH+5lscLtLwpEQf1SZ6pDouaSVBks0j6LWjjUYiyPWIWoh6R
qAIt6m2I2lOAOglRD0OUaUa0NOdkwUjzarfS89DGQzSEiQ1T7Qp0Cko/iKRV
zZ2G0ruhR6ZEaQnbeCDHowUnWiilVJ+BOu+HmbSeLDhc1m0jSNDS9Aped/fl
+Lkocb1xvM/m90I+Wh/PyvZ7mg8qcRDqt/zI8zvtZ5wHmt5ToO9cjr70/WDa
v7sl6hS2RpY61HcX1Gf9O+/seU/B7txZ4J1+3svwbpee89PDdqb3ExT5gKWt
jQvQxu0FNi5ClH4mzJzN9tT4IB8V1BLCV1boSeojKHtbgYUPndh3ZDSrE1Fc
hpq3a9mkr0SyH0PZAS2brlKS/QTKlrVswmj1GRn+QXwKZftl62q13lB0/QVc
xP5sK0AZz9AdGdWpB3rALQUs/kzm11haN9e7tYCDn8v2eldRj+yDnLL+f5Hj
P69ucoSmW6A+6/eXHehLz7Veh82K9+LrHG3Fd6G9kjOe9F1x9j/vqXOzRBXw
DWTcpowsVcByIkv6tUyYrhJz8i5DjT2QcbZOsB8hRFnmY1tBATs2yvxKKctW
Z/8AQNLXUhtrdKkE1vB7wyDDHHpzsbklQ0TcYVreb9zaBu+yWrIyA0yvl5Eo
OXwxEaW5S2dGb5f++m16ud6RZOQyFbUlg+ZdYhv2KbWL5a4ii++AtncZTykT
D1V9XxfxxJ7gOLw2I+xoX5xaVV0peT8Wv2XI7ksnOc36y3vzujPNXlcN0Gf9
sk+63T7uPnxv+qX7XF7OwcVz9/8RrXrvd9ZTsmcO/cwbtquuVE5HvqalkjtF
I5g5hb+3UkF9bDVRR2fgil6jaFaTKIy+n9b+VlfozXTRmw5+l/F/X4fyOc82
3c/vgFZu5Ixiw38lep20\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->550508973]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23947],

Cell[TextData[{
 "A ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " object is ",
 Cell[BoxData[
  ButtonBox["Equal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Equal"]], "InlineFormula"],
 " to the corresponding ordinary list:"
}], "ExampleText",
 CellID->403840996],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", "3"}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"4", ",", "5"}], "}"}], "\[Rule]", "6"}]}], "}"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->505071543],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "2", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 2, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "5"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->361367467]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "\[Equal]", 
  RowBox[{"Normal", "[", "s", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->76891865],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->260309584]
}, Open  ]],

Cell[TextData[{
 "They are not ",
 Cell[BoxData[
  ButtonBox["SameQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SameQ"]], "InlineFormula"],
 " because the expression structure is different:"
}], "ExampleText",
 CellID->115196602],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "===", 
  RowBox[{"Normal", "[", "s", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->103516627],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->498236501]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->92865389],

Cell[TextData[{
 "For functions ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " that work with SparseArray objects, typically ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["f", "TI"], "[", 
    StyleBox["s", "TI"], "]"}], " ", "==", " ", 
   RowBox[{
    StyleBox["f", "TI"], "[", 
    RowBox[{
     ButtonBox["Normal",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Normal"], "[", 
     StyleBox["s", "TI"], "]"}], "]"}]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->237619058],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"RandomInteger", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "100"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1000", ",", "2"}], "}"}]}], "]"}], "\[Rule]", 
    RowBox[{"RandomReal", "[", 
     RowBox[{"1", ",", "1000"}], "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->35763440],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "943", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 943, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"100", ",", "100"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->41762125]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Transpose", "[", "s", "]"}], "\[Equal]", 
  RowBox[{"Transpose", "[", 
   RowBox[{"Normal", "[", "s", "]"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8799768],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->122659392]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"s", ".", "s"}], "\[Equal]", 
  RowBox[{
   RowBox[{"Normal", "[", "s", "]"}], ".", 
   RowBox[{"Normal", "[", "s", "]"}]}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->264608827],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->199499536]
}, Open  ]],

Cell[TextData[{
 "This includes all functions with the ",
 Cell[BoxData["Attribute"], "InlineFormula"],
 " ",
 Cell[BoxData[
  ButtonBox["Listable",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Listable"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->241251566],

Cell[BoxData[
 RowBox[{
  RowBox[{"listable", "=", 
   RowBox[{"Cases", "[", 
    RowBox[{
     RowBox[{"Map", "[", 
      RowBox[{"ToExpression", ",", 
       RowBox[{"Names", "[", "\"\<System`*\>\"", "]"}]}], "]"}], ",", 
     RowBox[{"s_Symbol", "/;", 
      RowBox[{"MemberQ", "[", 
       RowBox[{
        RowBox[{"Attributes", "[", "s", "]"}], ",", "Listable"}], "]"}]}]}], 
    "]"}]}], ";"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->154787062],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"First", "[", 
   RowBox[{"RandomChoice", "[", 
    RowBox[{"listable", ",", "1"}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->164772160],

Cell[BoxData["NevilleThetaC"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->450776818]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "s", "]"}], "\[Equal]", 
  RowBox[{"f", "[", 
   RowBox[{"Normal", "[", "s", "]"}], "]"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->110754245],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->93287055]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->743450663],

Cell[TextData[{
 "Convert linear expressions to ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects using ",
 Cell[BoxData[
  ButtonBox["CoefficientArrays",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CoefficientArrays"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->869461888],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"expr", "=", 
   RowBox[{"ListCorrelate", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "1"}], "}"}], ",", 
     RowBox[{"Array", "[", 
      RowBox[{"x", ",", 
       RowBox[{"{", "100", "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}]}], "]"}]}], ";", " ", 
  RowBox[{"Short", "[", "expr", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->641888539],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"2", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "+", 
     RowBox[{"x", "[", "2", "]"}], "+", 
     RowBox[{"x", "[", "100", "]"}]}], ",", 
    RowBox[{"\[LeftSkeleton]", "98", "\[RightSkeleton]"}], ",", 
    RowBox[{
     RowBox[{"x", "[", "1", "]"}], "+", 
     RowBox[{"x", "[", "99", "]"}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"x", "[", "100", "]"}]}]}]}], "}"}],
  Short]], "Output",
 ImageSize->{356, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->103858745]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"v", ",", "m"}], "}"}], "=", 
  RowBox[{"CoefficientArrays", "[", 
   RowBox[{"expr", ",", 
    RowBox[{"Array", "[", 
     RowBox[{"x", ",", 
      RowBox[{"{", "100", "}"}]}], "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->296875809],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"SparseArray", "[", 
     RowBox[{
      InterpretationBox[
       RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "0", 
        "\[InvisibleSpace]", "\<\">\"\>"}],
       SequenceForm["<", 0, ">"],
       Editable->False], ",", 
      RowBox[{"{", "100", "}"}]}], "]"}],
    False,
    Editable->False], ",", 
   TagBox[
    RowBox[{"SparseArray", "[", 
     RowBox[{
      InterpretationBox[
       RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "300", 
        "\[InvisibleSpace]", "\<\">\"\>"}],
       SequenceForm["<", 300, ">"],
       Editable->False], ",", 
      RowBox[{"{", 
       RowBox[{"100", ",", "100"}], "}"}]}], "]"}],
    False,
    Editable->False]}], "}"}]], "Output",
 ImageSize->{392, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->6441707]
}, Open  ]],

Cell[TextData[{
 "Convert from ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " to expressions using ",
 Cell[BoxData[
  ButtonBox["Dot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dot"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->308166598],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"m", ".", 
   RowBox[{"Array", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "100", "}"}]}], "]"}]}], "//", "Short"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->307038687],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"2", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "+", 
     RowBox[{"x", "[", "2", "]"}], "+", 
     RowBox[{"x", "[", "100", "]"}]}], ",", 
    RowBox[{"\[LeftSkeleton]", "98", "\[RightSkeleton]"}], ",", 
    RowBox[{
     RowBox[{"x", "[", "1", "]"}], "+", 
     RowBox[{"x", "[", "99", "]"}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"x", "[", "100", "]"}]}]}]}], "}"}],
  Short]], "Output",
 ImageSize->{356, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//Short=",
 CellID->232813981]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22710],

Cell[TextData[{
 "If a position is repeated in the rule list for ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 ", the first instance is used:"
}], "ExampleText",
 CellID->103778392],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SparseArray", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "1"}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "2"}]}], "}"}], "]"}], "//",
   "Normal"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->220491512],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", "1", "}"}], "}"}]], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->509277850]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SparseArray", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"i_", ",", "i_"}], "}"}], "\[Rule]", "1"}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "2"}]}], "}"}], "]"}], "//",
   "Normal"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->401557736],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", "1", "}"}], "}"}]], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1007098252]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->363928830],

Cell["\<\
SparseArray objects can represent data too large to represent in normal form:\
\
\>", "ExampleText",
 CellID->500574541],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"i_", ",", "i_"}], "}"}], "\[Rule]", "i"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"100000", ",", "100000"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->157508881],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "100000", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 100000, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"100000", ",", "100000"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{278, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->408709843]
}, Open  ]],

Cell[TextData[{
 "Using ",
 Cell[BoxData[
  ButtonBox["Normal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Normal"]], "InlineFormula"],
 " will give a ",
 Cell[BoxData["SystemException"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->4473673],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", "s", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->137123236],

Cell[BoxData[
 RowBox[{
  RowBox[{"SparseArray", "::", "\<\"ntb\"\>"}], ":", 
  " ", "\<\"Cannot convert the sparse array \
\\!\\(\\*TagBox[\\(\[LeftSkeleton] 1 \[RightSkeleton]\\), False, \
Rule[Editable, False]]\\) to an ordinary array because the \
\\!\\(10000000000\\) elements required exceeds the current size \
limit.\"\>"}]], "Message", "MSG",
 CellID->239158],

Cell[BoxData[
 RowBox[{"SystemException", "[", 
  RowBox[{"\<\"SparseArrayNormalLimit\"\>", ",", 
   RowBox[{"Normal", "[", 
    TagBox[
     RowBox[{"SparseArray", "[", 
      RowBox[{
       InterpretationBox[
        RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "100000", 
         "\[InvisibleSpace]", "\<\">\"\>"}],
        SequenceForm["<", 100000, ">"],
        Editable->False], ",", 
       RowBox[{"{", 
        RowBox[{"100000", ",", "100000"}], "}"}]}], "]"}],
     False,
     Editable->False], "]"}]}], "]"}]], "Output",
 ImageSize->{348, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->64708016]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4038244],

Cell["Sparse operations do not by default check for cancellation:", \
"ExampleText",
 CellID->383609449],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i_", ",", "i_"}], "}"}], "\[Rule]", "1"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
        RowBox[{
         RowBox[{"Abs", "[", 
          RowBox[{"i", "-", "j"}], "]"}], "\[Equal]", "1"}]}], "\[Rule]", 
       "1"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->64377389],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "7", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 7, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->36160175]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r", "=", 
  RowBox[{
   RowBox[{"s", ".", "s"}], "-", 
   RowBox[{"2", "s"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->428566553],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "9", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 9, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->853099588]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", "r", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->63650557],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztVr1ugzAQNnbTpG3auWP2DJ3zAu3Uh0BRpWSoWqUZ2BgZGRl5BEZGRkZG
RkZGRkb3/ENsiCuhOp1KJPD5cr7PfOfz3at73L29u8f91l29HNzP3X77tXr+
OICKOAihDTzrRwQyBYk/G0ph1N8z9iZxHFP+Q2s+931fzgm3uuJiWZZpmnba
GTi8g5HAuJTjvPNWFMVwdRRF0qfAZPsR81uuPM35GvSD9pqvbdvW8zyFQDqt
AJFWv0MQ3xAEAbhjIj4h4DzP59aegUIgsu+Zs1PX9WX2ruKkI6iY2iMANeLI
/AHCouNDqhwjAjtDGKzvaf8E3gzszKufJiuNRyIzWc/ocTzyzD6L4JKOif5i
QpgQDCeR+dQz+/9kdBiGI6xUrdat4L5smmbIo57Z4uauqipJEibqNzeUC1mx
zXE2x3UYfYGQZZmhvsHmJK49AvDUq83D/oJYIyjOFQIGhmz2zmoiBg64D9kD
qT1jS89n3y8RRFNxGQTlSyAMu78ucx/4v6K/RM43rlsvDA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{57, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->94789653]
}, Open  ]],

Cell["Use SparseArray to recompute the sparse structure:", "ExampleText",
 CellID->144685785],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SparseArray", "[", "r", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->276994691],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "3", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 3, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->358386805]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->557052891],

Cell["\<\
Operations with side effects may give different values when iterating over \
SparseArrays:\
\>", "ExampleText",
 CellID->229822179],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"{", "1", "}"}], "\[Rule]", "2"}], ",", 
     RowBox[{
      RowBox[{"{", "4", "}"}], "\[Rule]", "3"}]}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24998458],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "2", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 2, ">"],
     Editable->False], ",", 
    RowBox[{"{", "4", "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{149, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->367818152]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"i", "=", "1"}], "}"}], ",", 
   RowBox[{
    RowBox[{"Scan", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"i", "++"}], "&"}], ",", "s"}], "]"}], ";", "i"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->86755428],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->3833298]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"i", "=", "1"}], "}"}], ",", 
   RowBox[{
    RowBox[{"Scan", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"i", "++"}], "&"}], ",", 
      RowBox[{"Normal", "[", "s", "]"}]}], "]"}], ";", "i"}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->390567810],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->122230979]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  ButtonBox["Reap",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reap"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Sow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sow"]], "InlineFormula"],
 " you can see what elements are accessed:"
}], "ExampleText",
 CellID->351513083],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reap", "[", 
  RowBox[{"Map", "[", 
   RowBox[{"Sow", ",", "s"}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->654358336],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"SparseArray", "[", 
     RowBox[{
      InterpretationBox[
       RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "2", 
        "\[InvisibleSpace]", "\<\">\"\>"}],
       SequenceForm["<", 2, ">"],
       Editable->False], ",", 
      RowBox[{"{", "4", "}"}]}], "]"}],
    False,
    Editable->False], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "0"}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{245, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->151822493]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reap", "[", 
  RowBox[{"Map", "[", 
   RowBox[{"Sow", ",", 
    RowBox[{"Normal", "[", "s", "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->163237105],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "0", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"2", ",", "0", ",", "0", ",", "3"}], "}"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{195, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->469858233]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->60454687],

Cell[TextData[{
 "For a ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " object, ",
 Cell[BoxData[
  ButtonBox["Part",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"]], "InlineFormula"],
 " gives parts of the represented list:"
}], "ExampleText",
 CellID->254955338],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", " ", "=", " ", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", "i_", "}"}], "\[Rule]", "i"}], ",", 
    RowBox[{"{", "5", "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->63525935],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "5", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 5, ">"],
     Editable->False], ",", 
    RowBox[{"{", "5", "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{149, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->228740942]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Part", "[", 
  RowBox[{"s", ",", " ", "1"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->74751446],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->567387121]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 " is a way of reconstructing the object from basic storage information:"
}], "ExampleText",
 CellID->18563381],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "s", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->174837260],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"SparseArray", "[", 
    RowBox[{"Automatic", ",", 
     RowBox[{"List", "[", "5", "]"}], ",", "0", ",", 
     RowBox[{"List", "[", 
      RowBox[{"1", ",", 
       RowBox[{"List", "[", 
        RowBox[{
         RowBox[{"List", "[", 
          RowBox[{"0", ",", "5"}], "]"}], ",", 
         RowBox[{"List", "[", 
          RowBox[{
           RowBox[{"List", "[", "1", "]"}], ",", 
           RowBox[{"List", "[", "2", "]"}], ",", 
           RowBox[{"List", "[", "3", "]"}], ",", 
           RowBox[{"List", "[", "4", "]"}], ",", 
           RowBox[{"List", "[", "5", "]"}]}], "]"}]}], "]"}], ",", 
       RowBox[{"List", "[", 
        RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "]"}]}], 
      "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{524, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//FullForm=",
 CellID->43661046]
}, Open  ]],

Cell["\<\
It should not be necessary, but if you want, you can get pieces of the full \
form with patterns:\
\>", "ExampleText",
 CellID->22786900],

Cell[BoxData[
 RowBox[{
  RowBox[{"HoldPattern", "[", 
   RowBox[{"spart", "[", 
    RowBox[{
     RowBox[{"SparseArray", "[", "stuff___", "]"}], ",", " ", "p_"}], "]"}], 
   "]"}], " ", ":=", " ", 
  RowBox[{
   RowBox[{"{", "stuff", "}"}], "[", 
   RowBox[{"[", "p", "]"}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->64927234],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"spart", "[", 
  RowBox[{"s", ",", "1"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->2014429],

Cell[BoxData["Automatic"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->75092806]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->597522630],

Cell[TextData[{
 "A ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " object is treated as atomic for functions that do not work on the \
representation:"
}], "ExampleText",
 CellID->289881608],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", " ", "=", " ", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"i_", ",", " ", "i_"}], "}"}], "\[Rule]", "i"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->80938957],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "5", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 5, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->262348947]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Cases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cases"]], "InlineFormula"],
 " does not work on the represented matrix:"
}], "ExampleText",
 CellID->26565583],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{"s", ",", " ", 
   RowBox[{"i_", "/;", 
    RowBox[{"i", ">", "0"}]}], ",", " ", "Infinity"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->79714738],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->84202422]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"Normal", "[", "s", "]"}], ",", " ", 
   RowBox[{"i_", "/;", 
    RowBox[{"i", ">", "0"}]}], ",", " ", "Infinity"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->285974145],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->737727251]
}, Open  ]],

Cell[TextData[{
 "You can often use the result of ",
 Cell[BoxData[
  ButtonBox["ArrayRules",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayRules"]], "InlineFormula"],
 " to get the information without expanding:"
}], "ExampleText",
 CellID->261621404],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"ArrayRules", "[", "s", "]"}], ",", " ", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"p_", "\[Rule]", 
      RowBox[{"i_", " ", "/;", " ", 
       RowBox[{"i", ">", "0"}]}]}], ")"}], "\[Rule]", "i"}], ",", " ", "1"}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->59755746],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->445571484]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18821],

Cell["The game of life:", "ExampleText",
 CellID->24527765],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"cellupdate", ",", "Listable"}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"cellupdate", "[", 
    RowBox[{"1", ",", "2"}], "]"}], "=", 
   RowBox[{
    RowBox[{"cellupdate", "[", 
     RowBox[{"_", ",", "3"}], "]"}], "=", "1"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"cellupdate", "[", 
    RowBox[{"_", ",", "_"}], "]"}], "=", "0"}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->80265525],

Cell[BoxData[
 RowBox[{
  RowBox[{"update", "[", "m_", "]"}], ":=", 
  RowBox[{"cellupdate", "[", 
   RowBox[{"m", ",", 
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{"RotateRight", "[", 
       RowBox[{"m", ",", "r"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"r", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", 
            RowBox[{"-", "1"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", 
            RowBox[{"-", "1"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", 
            RowBox[{"-", "1"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "1"}], "}"}]}], "}"}]}], "}"}]}], "]"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->92220472],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"n", "=", "100"}], ",", 
      RowBox[{"m", "=", "10"}], ",", "h"}], "}"}], ",", 
    RowBox[{
     RowBox[{"h", "=", 
      RowBox[{"Floor", "[", 
       RowBox[{
        RowBox[{"n", "/", "2"}], "-", 
        RowBox[{"m", "/", "2"}]}], "]"}]}], ";", 
     RowBox[{"s", "=", 
      RowBox[{"SparseArray", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Band", "[", 
          RowBox[{"{", 
           RowBox[{"h", ",", "h"}], "}"}], "]"}], "\[Rule]", 
         RowBox[{"RandomInteger", "[", 
          RowBox[{"1", ",", 
           RowBox[{"{", 
            RowBox[{"m", ",", "m"}], "}"}]}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"n", ",", "n"}], "}"}]}], "]"}]}]}]}], "]"}], ";"}], "\n", 
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ArrayPlot", "[", 
    RowBox[{
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{"s", "=", 
        RowBox[{"update", "[", "s", "]"}]}], ",", 
       RowBox[{"{", "10", "}"}]}], "]"}], ";", 
     RowBox[{"s", "=", 
      RowBox[{"SparseArray", "[", "s", "]"}]}]}], "]"}], ",", 
   RowBox[{"{", "8", "}"}]}], "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->47995121],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzt21ty2jAUxnEZ2/S6gD7mrRMITS97aJ+6htSlnUkeOu2kWWCzhW7IlUAG
81lFeOwYM/kzw0XmGP+OJCsmw/lc3F1//1Hc3SyLs0+3xa/rm+Xvs48/b+2m
NDEm+WOM+fvK2NelfbW6u9u9vRvzxD5+s5te2udl4PnpJsqk1Z6l+SLtZx3f
fy7tK2lPUaBAgQIFChQoUKBAgQIFChQoUKBAgeKUFdm6bVa3/HiOfNP2mgzL
KVuybdv/P79jhIq79M7E9Bej8tauRmyfUZ11WT3W5TvtMUqPeKX9K+3k/84B
V+vUPiS26TTjEI2on3pary6k/W5AmzuWm52LERsvgrE6D2YR0bwsZZUdMoeF
72d/2bFFNHp2XG7t1aw8bL7Mq3xT//H29nZA93mt19ZH/xA5+qW03xyxl2PW
Ma1evVjGcmVeaz/6b0soUKBAgQIFChQoUKBAgQIFChQoUPSgcLVRL8pwjdS6
NsrtcN/jKyqyUKBAgQIFChQoUKBAgQIFChQoUKBA8bgU1S97q1/susfiKJIV
oPHr1K9YsLS1DFOZtRORt+ifB6/Nkphsj+28XJ//9c9x28PVF8eq29KqD22/
Lrc1Wel2N3+b7Y5WOVCVVyPKL7G1lTYL5NGY6flmVHxSc4nq+3zTmgit+pge
PCZp1YONcX3oHMLzV6s79q0kWp0x8fmksj1WgVQfUxPYv2t9TPdMNVaFsbHS
WVvf331+LEN3/EkgTjNVh1ZE7ctR57DmGKvHkjXENOf/IbV0eqWlZ1oo41z2
UWl0ZBtb9agqrf4mVNeGsXgnck0dj+D47ayKaWBk9uVz6feJzSh9v2udo2Yy
8473Leyxq6TFbu8c2O+TgCKkrbd7V7c412PxIbvLUWvjuph1vYv1cyz+1L5p
jeObJwoUKFCgQIECBQoUKFCgQIECBQoUKLoo2tTYmeQfFYuTrw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{448, 210},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[3]=",
 CellID->101564917]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->15510],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArrayRules",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArrayRules"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Normal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Normal"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Band",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Band"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CoefficientArrays",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CoefficientArrays"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArrayPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArrayPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Array",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Array"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ConstantArray",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ConstantArray"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->14051]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->24771],

Cell[TextData[ButtonBox["Constructing Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ConstructingLists"]], "Tutorials",
 CellID->21200],

Cell[TextData[ButtonBox["Sparse Arrays: Manipulating Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SparseArrays-ManipulatingLists"]], "Tutorials",
 CellID->13299],

Cell[TextData[ButtonBox["Sparse Arrays: Linear Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SparseArrays-LinearAlgebra"]], "Tutorials",
 CellID->385244474]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->8795],

Cell[TextData[{
 ButtonBox["Demonstrations with SparseArray",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=SparseArray"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[ButtonBox["Implementation notes: Numerical and Related \
Functions",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#7977"], None}]], "RelatedLinks",
 CellID->15005]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->775114680],

Cell[TextData[ButtonBox["Constructing Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ConstructingLists"]], "MoreAbout",
 CellID->77055811],

Cell[TextData[ButtonBox["Constructing Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ConstructingMatrices"]], "MoreAbout",
 CellID->307142166],

Cell[TextData[ButtonBox["Handling Arrays of Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/HandlingArraysOfData"]], "MoreAbout",
 CellID->355310717],

Cell[TextData[ButtonBox["List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListManipulation"]], "MoreAbout",
 CellID->249673512],

Cell[TextData[ButtonBox["Matrices and Linear Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatricesAndLinearAlgebra"]], "MoreAbout",
 CellID->686158142],

Cell[TextData[ButtonBox["Operations on Vectors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/OperationsOnVectors"]], "MoreAbout",
 CellID->29585007],

Cell[TextData[ButtonBox["Sparse Arrays",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SparseArrays"]], "MoreAbout",
 CellID->313694149],

Cell[TextData[ButtonBox["Tensors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Tensors"]], "MoreAbout",
 CellID->515440237]
}, Open  ]],

Cell["New in 5  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SparseArray - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 22, 10.6692438}", "context" -> "System`", 
    "keywords" -> {
     "arrays", "band-diagonal matrices", "hashing", "lists", "matrices", 
      "position-value pairs", "sparse matrix", "sparse representation", 
      "sparse vector"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "SparseArray[{pos_1 -> val_1, pos_2 -> val_2, ...}] yields a sparse array \
in which values val_i appear at positions pos_i. SparseArray[{pos_1, pos_2, \
...} -> {val_1, val_2, ...}] yields the same sparse array. SparseArray[list] \
yields a sparse array version of list. SparseArray[data, {d_1, d_2, ...}] \
yields a sparse array representing a d_1*d_2*... array. SparseArray[data, \
dims, val] yields a sparse array in which unspecified elements are taken to \
have value val. ", "synonyms" -> {"sparse array"}, "title" -> "SparseArray", 
    "type" -> "Symbol", "uri" -> "ref/SparseArray"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[20986, 651, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->716364897]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 113308, 4021}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3744, 79, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4367, 106, 4195, 83, 70, "ObjectNameGrid"],
Cell[8565, 191, 3926, 125, 70, "Usage",
 CellID->2164]
}, Open  ]],
Cell[CellGroupData[{
Cell[12528, 321, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[13006, 338, 269, 10, 70, "Notes",
 CellID->11625],
Cell[13278, 350, 747, 25, 70, "Notes",
 CellID->15719],
Cell[14028, 377, 330, 10, 70, "Notes",
 CellID->20295],
Cell[14361, 389, 774, 29, 70, "Notes",
 CellID->22732],
Cell[15138, 420, 216, 8, 70, "Notes",
 CellID->12482],
Cell[15357, 430, 206, 8, 70, "Notes",
 CellID->30081],
Cell[15566, 440, 572, 22, 70, "Notes",
 CellID->719],
Cell[16141, 464, 470, 15, 70, "Notes",
 CellID->17396],
Cell[16614, 481, 541, 22, 70, "Notes",
 CellID->4680],
Cell[17158, 505, 396, 13, 70, "Notes",
 CellID->19248],
Cell[17557, 520, 111, 3, 70, "Notes",
 CellID->26945],
Cell[17671, 525, 358, 10, 70, "Notes",
 CellID->22371],
Cell[18032, 537, 482, 17, 70, "Notes",
 CellID->3054],
Cell[18517, 556, 341, 11, 70, "Notes",
 CellID->10666],
Cell[18861, 569, 434, 14, 70, "Notes",
 CellID->13769],
Cell[19298, 585, 529, 17, 70, "Notes",
 CellID->23333],
Cell[19830, 604, 362, 13, 70, "Notes",
 CellID->24793],
Cell[20195, 619, 377, 12, 70, "Notes",
 CellID->13716],
Cell[20575, 633, 212, 7, 70, "Notes",
 CellID->28749],
Cell[20790, 642, 159, 4, 70, "Notes",
 CellID->5656]
}, Closed]],
Cell[CellGroupData[{
Cell[20986, 651, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->716364897],
Cell[CellGroupData[{
Cell[21371, 665, 147, 5, 70, "ExampleSection",
 CellID->46640407],
Cell[21521, 672, 123, 3, 70, "ExampleText",
 CellID->448487540],
Cell[CellGroupData[{
Cell[21669, 679, 550, 19, 28, "Input",
 CellID->64886468],
Cell[22222, 700, 478, 17, 36, "Output",
 CellID->63571722]
}, Open  ]],
Cell[22715, 720, 62, 1, 70, "ExampleText",
 CellID->87933516],
Cell[CellGroupData[{
Cell[22802, 725, 106, 3, 28, "Input",
 CellID->563873289],
Cell[22911, 730, 796, 17, 78, "Output",
 Evaluatable->False,
 CellID->385408191]
}, Open  ]],
Cell[23722, 750, 81, 1, 70, "ExampleText",
 CellID->85717782],
Cell[CellGroupData[{
Cell[23828, 755, 102, 3, 70, "Input",
 CellID->218092258],
Cell[23933, 760, 390, 13, 36, "Output",
 CellID->64236516]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[24372, 779, 215, 7, 70, "ExampleSection",
 CellID->1041],
Cell[24590, 788, 96, 1, 70, "ExampleText",
 CellID->114675949],
Cell[CellGroupData[{
Cell[24711, 793, 297, 10, 70, "Input",
 CellID->5337929],
Cell[25011, 805, 455, 16, 36, "Output",
 CellID->386107]
}, Open  ]],
Cell[CellGroupData[{
Cell[25503, 826, 383, 13, 70, "Input",
 CellID->18211664],
Cell[25889, 841, 488, 17, 36, "Output",
 CellID->402286151]
}, Open  ]],
Cell[CellGroupData[{
Cell[26414, 863, 422, 14, 70, "Input",
 CellID->647811041],
Cell[26839, 879, 503, 17, 36, "Output",
 CellID->654032626]
}, Open  ]],
Cell[27357, 899, 125, 3, 70, "ExampleDelimiter",
 CellID->102094461],
Cell[27485, 904, 103, 2, 70, "ExampleText",
 CellID->504086207],
Cell[CellGroupData[{
Cell[27613, 910, 606, 21, 70, "Input",
 CellID->225514021],
Cell[28222, 933, 481, 17, 36, "Output",
 CellID->258066886]
}, Open  ]],
Cell[CellGroupData[{
Cell[28740, 955, 106, 3, 70, "Input",
 CellID->907848603],
Cell[28849, 960, 1037, 21, 70, "Output",
 Evaluatable->False,
 CellID->171211005]
}, Open  ]],
Cell[29901, 984, 81, 1, 70, "ExampleText",
 CellID->678175158],
Cell[CellGroupData[{
Cell[30007, 989, 662, 23, 70, "Input",
 CellID->193685268],
Cell[30672, 1014, 495, 17, 36, "Output",
 CellID->537013807]
}, Open  ]],
Cell[31182, 1034, 124, 3, 70, "ExampleDelimiter",
 CellID->19656203],
Cell[31309, 1039, 73, 1, 70, "ExampleText",
 CellID->192586105],
Cell[31385, 1042, 201, 7, 70, "Input",
 CellID->151624841],
Cell[CellGroupData[{
Cell[31611, 1053, 414, 14, 70, "Input",
 CellID->302101121],
Cell[32028, 1069, 486, 17, 36, "Output",
 CellID->20495727]
}, Open  ]],
Cell[32529, 1089, 217, 8, 70, "ExampleText",
 CellID->127922396],
Cell[CellGroupData[{
Cell[32771, 1101, 140, 4, 70, "Input",
 CellID->536438955],
Cell[32914, 1107, 161, 5, 36, "Output",
 CellID->385854297]
}, Open  ]],
Cell[33090, 1115, 102, 2, 70, "ExampleText",
 CellID->117422135],
Cell[CellGroupData[{
Cell[33217, 1121, 231, 7, 70, "Input",
 CellID->91791708],
Cell[33451, 1130, 210, 7, 36, "Output",
 CellID->185752698]
}, Open  ]],
Cell[33676, 1140, 125, 3, 70, "ExampleDelimiter",
 CellID->502417044],
Cell[33804, 1145, 226, 8, 70, "ExampleText",
 CellID->552031581],
Cell[CellGroupData[{
Cell[34055, 1157, 645, 23, 70, "Input",
 CellID->366198294],
Cell[34703, 1182, 479, 17, 36, "Output",
 CellID->329185687]
}, Open  ]],
Cell[CellGroupData[{
Cell[35219, 1204, 105, 3, 70, "Input",
 CellID->16975159],
Cell[35327, 1209, 934, 19, 70, "Output",
 Evaluatable->False,
 CellID->544420996]
}, Open  ]],
Cell[36276, 1231, 124, 3, 70, "ExampleDelimiter",
 CellID->89444105],
Cell[36403, 1236, 90, 1, 70, "ExampleText",
 CellID->88226687],
Cell[CellGroupData[{
Cell[36518, 1241, 347, 11, 70, "Input",
 CellID->465934725],
Cell[36868, 1254, 479, 17, 36, "Output",
 CellID->579411685]
}, Open  ]],
Cell[37362, 1274, 125, 3, 70, "ExampleDelimiter",
 CellID->222833362],
Cell[37490, 1279, 104, 2, 70, "ExampleText",
 CellID->36970019],
Cell[CellGroupData[{
Cell[37619, 1285, 357, 12, 70, "Input",
 CellID->388726075],
Cell[37979, 1299, 1334, 47, 54, "Output",
 CellID->391474820]
}, Open  ]],
Cell[CellGroupData[{
Cell[39350, 1351, 134, 4, 70, "Input",
 CellID->176369732],
Cell[39487, 1357, 496, 17, 36, "Output",
 CellID->320268]
}, Open  ]],
Cell[CellGroupData[{
Cell[40020, 1379, 102, 3, 70, "Input",
 CellID->299488094],
Cell[40125, 1384, 944, 20, 70, "Output",
 Evaluatable->False,
 CellID->395488579]
}, Open  ]],
Cell[41084, 1407, 369, 12, 70, "ExampleText",
 CellID->75666710],
Cell[CellGroupData[{
Cell[41478, 1423, 106, 3, 70, "Input",
 CellID->395170989],
Cell[41587, 1428, 1103, 39, 54, "Output",
 CellID->189746004]
}, Open  ]],
Cell[42705, 1470, 125, 3, 70, "ExampleDelimiter",
 CellID->315374579],
Cell[42833, 1475, 265, 8, 70, "ExampleText",
 CellID->42469512],
Cell[43101, 1485, 932, 32, 70, "Input",
 CellID->172330095],
Cell[CellGroupData[{
Cell[44058, 1521, 182, 6, 70, "Input",
 CellID->115720091],
Cell[44243, 1529, 1568, 30, 70, "Output",
 Evaluatable->False,
 CellID->5093019]
}, Open  ]],
Cell[45826, 1562, 96, 1, 70, "ExampleText",
 CellID->1013140],
Cell[CellGroupData[{
Cell[45947, 1567, 155, 5, 70, "Input",
 CellID->419680251],
Cell[46105, 1574, 877, 18, 70, "Output",
 Evaluatable->False,
 CellID->291159855]
}, Open  ]],
Cell[46997, 1595, 203, 8, 70, "ExampleText",
 CellID->465055819],
Cell[CellGroupData[{
Cell[47225, 1607, 131, 4, 70, "Input",
 CellID->103729235],
Cell[47359, 1613, 1134, 22, 70, "Output",
 Evaluatable->False,
 CellID->107466465]
}, Open  ]],
Cell[48508, 1638, 123, 3, 70, "ExampleText",
 CellID->787358487],
Cell[CellGroupData[{
Cell[48656, 1645, 89, 2, 70, "Input",
 CellID->84233051],
Cell[48748, 1649, 418, 12, 36, "Output",
 CellID->405445031]
}, Open  ]],
Cell[49181, 1664, 86, 1, 70, "ExampleText",
 CellID->71796658],
Cell[CellGroupData[{
Cell[49292, 1669, 156, 5, 70, "Input",
 CellID->13691407],
Cell[49451, 1676, 521, 18, 36, "Output",
 CellID->662057432]
}, Open  ]],
Cell[CellGroupData[{
Cell[50009, 1699, 106, 3, 70, "Input",
 CellID->418669584],
Cell[50118, 1704, 1260, 25, 70, "Output",
 Evaluatable->False,
 CellID->93686615]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[51427, 1735, 239, 7, 70, "ExampleSection",
 CellID->27055],
Cell[51669, 1744, 87, 1, 70, "ExampleText",
 CellID->550841534],
Cell[CellGroupData[{
Cell[51781, 1749, 299, 10, 70, "Input",
 CellID->4980511],
Cell[52083, 1761, 489, 17, 36, "Output",
 CellID->224570059]
}, Open  ]],
Cell[CellGroupData[{
Cell[52609, 1783, 105, 3, 70, "Input",
 CellID->50252504],
Cell[52717, 1788, 873, 18, 70, "Output",
 Evaluatable->False,
 CellID->930041877]
}, Open  ]],
Cell[53605, 1809, 99, 1, 70, "ExampleText",
 CellID->1039194561],
Cell[CellGroupData[{
Cell[53729, 1814, 301, 10, 70, "Input",
 CellID->128170974],
Cell[54033, 1826, 161, 5, 36, "Output",
 CellID->252057999]
}, Open  ]],
Cell[54209, 1834, 125, 3, 70, "ExampleDelimiter",
 CellID->195905179],
Cell[54337, 1839, 102, 2, 70, "ExampleText",
 CellID->904000384],
Cell[CellGroupData[{
Cell[54464, 1845, 619, 21, 70, "Input",
 CellID->69266030],
Cell[55086, 1868, 480, 17, 36, "Output",
 CellID->42357044]
}, Open  ]],
Cell[CellGroupData[{
Cell[55603, 1890, 107, 3, 70, "Input",
 CellID->245943095],
Cell[55713, 1895, 1082, 22, 70, "Output",
 Evaluatable->False,
 CellID->323649898]
}, Open  ]],
Cell[56810, 1920, 238, 10, 70, "ExampleText",
 CellID->4078135],
Cell[CellGroupData[{
Cell[57073, 1934, 154, 5, 70, "Input",
 CellID->197558386],
Cell[57230, 1941, 161, 5, 36, "Output",
 CellID->20034272]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[57440, 1952, 222, 7, 70, "ExampleSection",
 CellID->4123],
Cell[57665, 1961, 83, 1, 70, "ExampleText",
 CellID->15333],
Cell[CellGroupData[{
Cell[57773, 1966, 193, 6, 70, "Input",
 CellID->25680],
Cell[57969, 1974, 384, 10, 36, "Output",
 CellID->67938642]
}, Open  ]],
Cell[CellGroupData[{
Cell[58390, 1989, 246, 9, 70, "Input",
 CellID->2586],
Cell[58639, 2000, 632, 18, 36, "Output",
 CellID->932160446]
}, Open  ]],
Cell[59286, 2021, 120, 3, 70, "ExampleDelimiter",
 CellID->1040],
Cell[59409, 2026, 60, 1, 70, "ExampleText",
 CellID->26449],
Cell[CellGroupData[{
Cell[59494, 2031, 283, 9, 70, "Input",
 CellID->19726],
Cell[59780, 2042, 548, 17, 146, "Output",
 CellID->9094415]
}, Open  ]],
Cell[60343, 2062, 124, 3, 70, "ExampleDelimiter",
 CellID->21312068],
Cell[60470, 2067, 87, 1, 70, "ExampleText",
 CellID->16226076],
Cell[CellGroupData[{
Cell[60582, 2072, 518, 18, 70, "Input",
 CellID->54131642],
Cell[61103, 2092, 483, 17, 36, "Output",
 CellID->106325491]
}, Open  ]],
Cell[CellGroupData[{
Cell[61623, 2114, 105, 3, 70, "Input",
 CellID->136784259],
Cell[61731, 2119, 4939, 141, 70, "Output",
 CellID->642591672]
}, Open  ]],
Cell[66685, 2263, 125, 3, 70, "ExampleDelimiter",
 CellID->324580906],
Cell[66813, 2268, 713, 24, 70, "ExampleText",
 CellID->624007364],
Cell[67529, 2294, 844, 31, 70, "Input",
 CellID->306139826],
Cell[CellGroupData[{
Cell[68398, 2329, 1042, 35, 70, "Input",
 CellID->10535879],
Cell[69443, 2366, 490, 17, 36, "Output",
 CellID->99863050]
}, Open  ]],
Cell[69948, 2386, 356, 12, 70, "Input",
 CellID->323886016],
Cell[CellGroupData[{
Cell[70329, 2402, 193, 6, 70, "Input",
 CellID->495343823],
Cell[70525, 2410, 2002, 37, 70, "Output",
 Evaluatable->False,
 CellID->550508973]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[72576, 2453, 233, 7, 70, "ExampleSection",
 CellID->23947],
Cell[72812, 2462, 355, 13, 70, "ExampleText",
 CellID->403840996],
Cell[CellGroupData[{
Cell[73192, 2479, 357, 13, 70, "Input",
 CellID->505071543],
Cell[73552, 2494, 479, 17, 36, "Output",
 CellID->361367467]
}, Open  ]],
Cell[CellGroupData[{
Cell[74068, 2516, 131, 4, 70, "Input",
 CellID->76891865],
Cell[74202, 2522, 161, 5, 36, "Output",
 CellID->260309584]
}, Open  ]],
Cell[74378, 2530, 236, 8, 70, "ExampleText",
 CellID->115196602],
Cell[CellGroupData[{
Cell[74639, 2542, 127, 4, 70, "Input",
 CellID->103516627],
Cell[74769, 2548, 162, 5, 36, "Output",
 CellID->498236501]
}, Open  ]],
Cell[74946, 2556, 124, 3, 70, "ExampleDelimiter",
 CellID->92865389],
Cell[75073, 2561, 518, 19, 70, "ExampleText",
 CellID->237619058],
Cell[CellGroupData[{
Cell[75616, 2584, 410, 13, 70, "Input",
 CellID->35763440],
Cell[76029, 2599, 486, 17, 36, "Output",
 CellID->41762125]
}, Open  ]],
Cell[CellGroupData[{
Cell[76552, 2621, 203, 6, 70, "Input",
 CellID->8799768],
Cell[76758, 2629, 161, 5, 36, "Output",
 CellID->122659392]
}, Open  ]],
Cell[CellGroupData[{
Cell[76956, 2639, 213, 7, 70, "Input",
 CellID->264608827],
Cell[77172, 2648, 161, 5, 36, "Output",
 CellID->199499536]
}, Open  ]],
Cell[77348, 2656, 272, 10, 70, "ExampleText",
 CellID->241251566],
Cell[77623, 2668, 453, 14, 70, "Input",
 CellID->154787062],
Cell[CellGroupData[{
Cell[78101, 2686, 196, 6, 70, "Input",
 CellID->164772160],
Cell[78300, 2694, 170, 5, 36, "Output",
 CellID->450776818]
}, Open  ]],
Cell[CellGroupData[{
Cell[78507, 2704, 189, 6, 70, "Input",
 CellID->110754245],
Cell[78699, 2712, 160, 5, 36, "Output",
 CellID->93287055]
}, Open  ]],
Cell[78874, 2720, 125, 3, 70, "ExampleDelimiter",
 CellID->743450663],
Cell[79002, 2725, 376, 13, 70, "ExampleText",
 CellID->869461888],
Cell[CellGroupData[{
Cell[79403, 2742, 442, 14, 70, "Input",
 CellID->641888539],
Cell[79848, 2758, 612, 20, 36, "Output",
 CellID->103858745]
}, Open  ]],
Cell[CellGroupData[{
Cell[80497, 2783, 299, 10, 70, "Input",
 CellID->296875809],
Cell[80799, 2795, 872, 30, 36, "Output",
 CellID->6441707]
}, Open  ]],
Cell[81686, 2828, 338, 13, 70, "ExampleText",
 CellID->308166598],
Cell[CellGroupData[{
Cell[82049, 2845, 206, 7, 70, "Input",
 CellID->307038687],
Cell[82258, 2854, 612, 20, 36, "Output",
 CellID->232813981]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[82919, 2880, 226, 7, 70, "ExampleSection",
 CellID->22710],
Cell[83148, 2889, 264, 8, 70, "ExampleText",
 CellID->103778392],
Cell[CellGroupData[{
Cell[83437, 2901, 362, 13, 70, "Input",
 CellID->220491512],
Cell[83802, 2916, 203, 7, 36, "Output",
 CellID->509277850]
}, Open  ]],
Cell[CellGroupData[{
Cell[84042, 2928, 364, 13, 70, "Input",
 CellID->401557736],
Cell[84409, 2943, 204, 7, 36, "Output",
 CellID->1007098252]
}, Open  ]],
Cell[84628, 2953, 125, 3, 70, "ExampleDelimiter",
 CellID->363928830],
Cell[84756, 2958, 130, 4, 70, "ExampleText",
 CellID->500574541],
Cell[CellGroupData[{
Cell[84911, 2966, 329, 11, 70, "Input",
 CellID->157508881],
Cell[85243, 2979, 499, 17, 36, "Output",
 CellID->408709843]
}, Open  ]],
Cell[85757, 2999, 253, 10, 70, "ExampleText",
 CellID->4473673],
Cell[CellGroupData[{
Cell[86035, 3013, 102, 3, 70, "Input",
 CellID->137123236],
Cell[86140, 3018, 368, 8, 70, "Message",
 CellID->239158],
Cell[86511, 3028, 661, 20, 54, "Output",
 CellID->64708016]
}, Open  ]],
Cell[87187, 3051, 123, 3, 70, "ExampleDelimiter",
 CellID->4038244],
Cell[87313, 3056, 104, 2, 70, "ExampleText",
 CellID->383609449],
Cell[CellGroupData[{
Cell[87442, 3062, 582, 20, 70, "Input",
 CellID->64377389],
Cell[88027, 3084, 478, 17, 36, "Output",
 CellID->36160175]
}, Open  ]],
Cell[CellGroupData[{
Cell[88542, 3106, 158, 6, 70, "Input",
 CellID->428566553],
Cell[88703, 3114, 479, 17, 36, "Output",
 CellID->853099588]
}, Open  ]],
Cell[CellGroupData[{
Cell[89219, 3136, 105, 3, 70, "Input",
 CellID->63650557],
Cell[89327, 3141, 758, 16, 70, "Output",
 Evaluatable->False,
 CellID->94789653]
}, Open  ]],
Cell[90100, 3160, 93, 1, 70, "ExampleText",
 CellID->144685785],
Cell[CellGroupData[{
Cell[90218, 3165, 107, 3, 70, "Input",
 CellID->276994691],
Cell[90328, 3170, 479, 17, 36, "Output",
 CellID->358386805]
}, Open  ]],
Cell[90822, 3190, 125, 3, 70, "ExampleDelimiter",
 CellID->557052891],
Cell[90950, 3195, 141, 4, 70, "ExampleText",
 CellID->229822179],
Cell[CellGroupData[{
Cell[91116, 3203, 296, 10, 70, "Input",
 CellID->24998458],
Cell[91415, 3215, 453, 16, 36, "Output",
 CellID->367818152]
}, Open  ]],
Cell[CellGroupData[{
Cell[91905, 3236, 305, 12, 70, "Input",
 CellID->86755428],
Cell[92213, 3250, 156, 5, 36, "Output",
 CellID->3833298]
}, Open  ]],
Cell[CellGroupData[{
Cell[92406, 3260, 343, 13, 70, "Input",
 CellID->390567810],
Cell[92752, 3275, 158, 5, 36, "Output",
 CellID->122230979]
}, Open  ]],
Cell[92925, 3283, 338, 13, 70, "ExampleText",
 CellID->351513083],
Cell[CellGroupData[{
Cell[93288, 3300, 156, 5, 70, "Input",
 CellID->654358336],
Cell[93447, 3307, 605, 21, 36, "Output",
 CellID->151822493]
}, Open  ]],
Cell[CellGroupData[{
Cell[94089, 3333, 191, 6, 70, "Input",
 CellID->163237105],
Cell[94283, 3341, 371, 13, 36, "Output",
 CellID->469858233]
}, Open  ]],
Cell[94669, 3357, 124, 3, 70, "ExampleDelimiter",
 CellID->60454687],
Cell[94796, 3362, 356, 13, 70, "ExampleText",
 CellID->254955338],
Cell[CellGroupData[{
Cell[95177, 3379, 246, 8, 70, "Input",
 CellID->63525935],
Cell[95426, 3389, 453, 16, 36, "Output",
 CellID->228740942]
}, Open  ]],
Cell[CellGroupData[{
Cell[95916, 3410, 127, 4, 70, "Input",
 CellID->74751446],
Cell[96046, 3416, 158, 5, 36, "Output",
 CellID->567387121]
}, Open  ]],
Cell[96219, 3424, 255, 8, 70, "ExampleText",
 CellID->18563381],
Cell[CellGroupData[{
Cell[96499, 3436, 104, 3, 70, "Input",
 CellID->174837260],
Cell[96606, 3441, 1021, 30, 85, "Output",
 CellID->43661046]
}, Open  ]],
Cell[97642, 3474, 147, 4, 70, "ExampleText",
 CellID->22786900],
Cell[97792, 3480, 336, 11, 70, "Input",
 CellID->64927234],
Cell[CellGroupData[{
Cell[98153, 3495, 122, 4, 70, "Input",
 CellID->2014429],
Cell[98278, 3501, 165, 5, 36, "Output",
 CellID->75092806]
}, Open  ]],
Cell[98458, 3509, 125, 3, 70, "ExampleDelimiter",
 CellID->597522630],
Cell[98586, 3514, 274, 9, 70, "ExampleText",
 CellID->289881608],
Cell[CellGroupData[{
Cell[98885, 3527, 305, 10, 70, "Input",
 CellID->80938957],
Cell[99193, 3539, 479, 17, 36, "Output",
 CellID->262348947]
}, Open  ]],
Cell[99687, 3559, 211, 7, 70, "ExampleText",
 CellID->26565583],
Cell[CellGroupData[{
Cell[99923, 3570, 201, 6, 70, "Input",
 CellID->79714738],
Cell[100127, 3578, 174, 6, 36, "Output",
 CellID->84202422]
}, Open  ]],
Cell[CellGroupData[{
Cell[100338, 3589, 236, 7, 70, "Input",
 CellID->285974145],
Cell[100577, 3598, 233, 7, 36, "Output",
 CellID->737727251]
}, Open  ]],
Cell[100825, 3608, 260, 8, 70, "ExampleText",
 CellID->261621404],
Cell[CellGroupData[{
Cell[101110, 3620, 339, 11, 70, "Input",
 CellID->59755746],
Cell[101452, 3633, 233, 7, 36, "Output",
 CellID->445571484]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[101734, 3646, 224, 7, 70, "ExampleSection",
 CellID->18821],
Cell[101961, 3655, 59, 1, 70, "ExampleText",
 CellID->24527765],
Cell[102023, 3658, 485, 16, 70, "Input",
 CellID->80265525],
Cell[102511, 3676, 1165, 37, 70, "Input",
 CellID->92220472],
Cell[CellGroupData[{
Cell[103701, 3717, 1243, 40, 70, "Input",
 CellID->47995121],
Cell[104947, 3759, 1232, 24, 70, "Output",
 Evaluatable->False,
 CellID->101564917]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[106240, 3790, 311, 9, 70, "SeeAlsoSection",
 CellID->15510],
Cell[106554, 3801, 1692, 62, 70, "SeeAlso",
 CellID->14051]
}, Open  ]],
Cell[CellGroupData[{
Cell[108283, 3868, 314, 9, 70, "TutorialsSection",
 CellID->24771],
Cell[108600, 3879, 146, 3, 70, "Tutorials",
 CellID->21200],
Cell[108749, 3884, 174, 3, 70, "Tutorials",
 CellID->13299],
Cell[108926, 3889, 170, 3, 70, "Tutorials",
 CellID->385244474]
}, Open  ]],
Cell[CellGroupData[{
Cell[109133, 3897, 320, 9, 70, "RelatedLinksSection",
 CellID->8795],
Cell[109456, 3908, 367, 12, 70, "RelatedLinks"],
Cell[109826, 3922, 266, 6, 70, "RelatedLinks",
 CellID->15005]
}, Open  ]],
Cell[CellGroupData[{
Cell[110129, 3933, 319, 9, 70, "MoreAboutSection",
 CellID->775114680],
Cell[110451, 3944, 146, 3, 70, "MoreAbout",
 CellID->77055811],
Cell[110600, 3949, 153, 3, 70, "MoreAbout",
 CellID->307142166],
Cell[110756, 3954, 155, 3, 70, "MoreAbout",
 CellID->355310717],
Cell[110914, 3959, 145, 3, 70, "MoreAbout",
 CellID->249673512],
Cell[111062, 3964, 163, 3, 70, "MoreAbout",
 CellID->686158142],
Cell[111228, 3969, 151, 3, 70, "MoreAbout",
 CellID->29585007],
Cell[111382, 3974, 137, 3, 70, "MoreAbout",
 CellID->313694149],
Cell[111522, 3979, 126, 3, 70, "MoreAbout",
 CellID->515440237]
}, Open  ]],
Cell[111663, 3985, 50, 0, 70, "History"],
Cell[111716, 3987, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

