(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    367677,       6900]
NotebookOptionsPosition[    359677,       6637]
NotebookOutlinePosition[    361362,       6680]
CellTagsIndexPosition[    361275,       6675]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Lighting" :> Documentation`HelpLookup["paclet:ref/Lighting"], 
          "RGBColor" :> Documentation`HelpLookup["paclet:ref/RGBColor"], 
          "Glow" :> Documentation`HelpLookup["paclet:ref/Glow"], 
          "ColorFunction" :> 
          Documentation`HelpLookup["paclet:ref/ColorFunction"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Lighting\"\>", 
       2->"\<\"RGBColor\"\>", 3->"\<\"Glow\"\>", 
       4->"\<\"ColorFunction\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"3D Graphics Options" :> 
          Documentation`HelpLookup["paclet:guide/3DGraphicsOptions"], 
          "Colors" :> Documentation`HelpLookup["paclet:guide/Colors"], 
          "Graphics Directives" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsDirectives"], 
          "New in 6.0: Graphics Primitives & Directives" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsPrimitivesAndDirectives"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"3D Graphics Options\"\>", 
       2->"\<\"Colors\"\>", 3->"\<\"Graphics Directives\"\>", 
       4->"\<\"New in 6.0: Graphics Primitives & Directives\"\>", 
       5->"\<\"New in 6.0: Visualization & Graphics\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Specularity", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Specularity",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Specularity"], "[", 
       StyleBox["s", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]is a graphics directive which specifies that surfaces \
of 3D graphics objects which follow are to be taken to have specularity ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Specularity",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Specularity"], "[", 
       RowBox[{
        StyleBox["s", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]uses specular exponent ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->11621]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Specularity is added to diffuse reflection and glow components to determine \
the final rendered color of a surface. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->518694676]
}], "Notes",
 CellID->27150],

Cell[TextData[{
 "With specularity ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 " a surface is taken to specularly reflect a fraction ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 " of light that falls on it from simulated light sources. "
}], "Notes",
 CellID->25202],

Cell[TextData[{
 "The specular exponent ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " defines how sharply the intensity of reflected light falls off away from \
the mirror\[Hyphen]reflection direction.",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->225462722]
}], "Notes",
 CellID->14110],

Cell["\<\
The default specular exponent is 1.5. Higher values lead to more sharply \
defined reflections, typical of shinier materials. Values above 10 produce \
definite \[OpenCurlyDoubleQuote]specular highlights\[CloseCurlyDoubleQuote]. \
\
\>", "Notes",
 CellID->25794],

Cell[TextData[{
 "The intensity of simulated light at an angle ",
 Cell[BoxData[
  FormBox["\[Theta]", TraditionalForm]], "InlineMath"],
 " from the mirror\[Hyphen]reflection direction is taken to be ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["cos", "n"], "(", "\[Theta]", ")"}], TraditionalForm]], 
  "InlineMath"],
 ". When ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Theta]", ">", 
    RowBox[{"90", "\[Degree]"}]}], TraditionalForm]], "InlineMath"],
 " the intensity is zero. "
}], "Notes",
 CellID->26956],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Specularity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Specularity"], "[", 
   StyleBox["s", "TI"], "]"}]], "InlineFormula"],
 " takes the reflected light to have the same color as the incident light \
from light sources. "
}], "Notes",
 CellID->16896],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Specularity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Specularity"], "[", 
   StyleBox["col", "TI"], "]"}]], "InlineFormula"],
 " specifies that the RGB components of the incident light should be \
multiplied by the RGB components of ",
 Cell[BoxData[
  StyleBox["col", "TI"]], "InlineFormula"],
 ".",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->210355696]
}], "Notes",
 CellID->6359],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Specularity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Specularity"], "[", 
   StyleBox["s", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Specularity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Specularity"], "[", 
   RowBox[{
    ButtonBox["GrayLevel",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/GrayLevel"], "[", 
    StyleBox["s", "TI"], "]"}], "]"}]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->253706442]
}], "Notes",
 CellID->30121],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Specularity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Specularity"], "[", "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Specularity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Specularity"], "[", "0", "]"}]], 
  "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Specularity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Specularity"], "[", 
   ButtonBox["Black",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Black"], "]"}]], "InlineFormula"],
 ", and specifies no specular reflection. "
}], "Notes",
 CellID->28321],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Specularity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Specularity"]], "InlineFormula"],
 " directives do not affect specifications from ",
 Cell[BoxData[
  ButtonBox["Glow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Glow"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["RGBColor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->31519]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->238055382],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->55453161],

Cell["A typical specular color:", "ExampleText",
 CellID->585523909],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Specularity", "[", 
     RowBox[{"1", ",", "20"}], "]"}], ",", 
    RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->274850458],

Cell[BoxData[
 Graphics3DBox[
  {Specularity[
    GrayLevel[0.5], 20], SphereBox[{0, 0, 0}]}]], "Output",
 ImageSize->{154, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->233850869,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27161693],

Cell["Specify the specular exponent:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->225462722],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{"Orange", ",", 
      RowBox[{"Specularity", "[", 
       RowBox[{"White", ",", "n"}], "]"}], ",", 
      RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "20", ",", "100"}], "}"}]}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->37956373],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {RGBColor[1, 0.5, 0], Specularity[
      GrayLevel[1], 5], SphereBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {RGBColor[1, 0.5, 0], Specularity[
      GrayLevel[1], 20], SphereBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {RGBColor[1, 0.5, 0], Specularity[
      GrayLevel[1], 100], SphereBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{341, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->74595844]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->326714863],

Cell["Specify the color of specularity:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->210355696],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Black", ",", 
       RowBox[{"Specularity", "[", 
        RowBox[{"c", ",", "10"}], "]"}], ",", 
       RowBox[{"Sphere", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"{", 
      RowBox[{"Red", ",", "Green", ",", "Blue"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->208428479],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {GrayLevel[0], Specularity[
      RGBColor[1, 0, 0], 10], SphereBox[{0, 0, 0}]},
    Lighting->"Neutral",
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {GrayLevel[0], Specularity[
      RGBColor[0, 1, 0], 10], SphereBox[{0, 0, 0}]},
    Lighting->"Neutral",
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {GrayLevel[0], Specularity[
      RGBColor[0, 0, 1], 10], SphereBox[{0, 0, 0}]},
    Lighting->"Neutral",
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJydWot/VMUVPtlXdjfJbja7eb9DEiBACKAhRAOU8rBYRFEQRIoxRaEiIC9b
aX1rFaiKitUq2mKp2Iq1KlT7tFrtT+vjL8qvPeebOTezszckMb8ku3Pv3DPf
d15zZu5sGD28e9fdo4f3jI12rDs4emD3nrFDHWv3H+RL0TIi2sV/exuIv/+P
v+Fv1fj4OEV37do1jh/qkH+0kv/H+GInWiP8X7pE+TPCn6bPVbaVKLo6ZPsm
Hbn8n9pxd9D2rQi9e4W9WyWtWICJv7Th/iIrOyuteHDfymhFn4VWRs1l+iyw
fQoe94jXbkLvPjtqnXc36rUb0XuOld04rd49VnazdzfmtRvQe5aV3Tat3p2u
XZy7ca9dj95tFkmXdzfhtaEFarGye6bVu9HKnu3dLffatehdb2X3Tat3re29
YIresDXVWCQLvbtJr51H72ore/G0emds7yu8uymvDc+kCotk0Lub9to59E5Z
2cum3du9OuS1K7x2NZ7yI7abPys4RfhjXObpopiVmM7z875PVHrt7MTzJfEq
cdHIMvzoqfLamRIG4yHxLN7YSlacuWyenFKSP75YvAOSvCd9jCWS/FgVi3Wq
JP6YXJLv0b5e5alZIilmJJkfX1ZlqCy/Lb26HVTyEwmRVhEqzecsHtQiwojK
Ep5UvlZizXCpvlfLKOIbMSM1wvjKIM4Kj4dITodK9j1cNFtPVjSIR4z8KMuM
xQR0FNfKZKhEyDip0HH8yBFfqLV6kbEi+MpfYvwtzn8JbpbLp5CJm1tWezK6
MPSjyYzs+4aPTyKjThgmHIZmbIwrX8rZefGb4itpvpmyl/h/Ajq2SqAwHMlQ
HL7/CHuWazFEFUNCR0/J5TRfqZTLVfKJX75aIb1SwJEwamEZgsTXcjiSrNMW
EHlSQ8iQMfkXF2QJi4PHk5EZQoYoy3OD9MhJo0Y+5bcaN/hKFVCl8KTBJmqK
hmipPBSbZNQ8WeWmVTVxRy9p4GEwWaCIAn+BZ0MZrE6A1qLNV3MAU4UHUj4e
0ZXMK5PrqIAkMqEXgeFiyIB3TgHUcacGwcOR2UTULA81R+R7GtfqgSYHTVVB
hgUkaAQFnNvJz+EaEmQ1gqze8R0DztVOBkMJLEFlAFEbUTsRZ29Ou1343yEC
2uUZvtcChHV4rEZBlkN0BOklZlH6mTwxqcfXhPlWDlJT8KpAiQUwYpytAMnY
OKP3EM3mwpJorjw5R3pzuxc3uoC2Bbqtg4gAcMzaWMCEzh0llaBoNRei1YRC
NVqthmJqoVKjT4OzFyD7iOZzGU40IE8vFLT9XHIzekDtwgPNijajPiDqiYRU
G5MjrdYIqXNwJlWlAUijzzaM3AOE8wBngGgxLzl4TUK0NCofjOVKXBkA0jno
31kMNmkcYfpIMxapGMjVqVFoWs1fgzEaYcp2aHO26nExYA3xgotXYkTLeXUm
YlYIxeW4dDXfBuSFIDcb3h2grgi8QVD7s+jkqLOCuqnEE5JB6oH0WqBuxZCz
oDRGvQiQlwHZCqJVRGuI1hF9jwVdI7j5+1pcXAncg2C5AC7UjkFrId/kq1Bt
xyfFnfFxB4kz0LaLuxNmngsvXcKuAD2vJFptEBNtILqeBd3Af9cLqI24dA2A
s/6H8dh8SGmH0BoMk5Sxp4+8yiKHRzc7+SxIEln16Ea4s3GReTD6lQ5og/gG
opuIthBtI9pOdIvI3Saa34qrNwD9WphmGMqfB4mtqvk0xg71GIPfz36B5lud
uSLhwK8uzm5d8JV+jD0IR1klvmGxbxHI9AOiUaIx7Fv8UESOiZTbcWMbGFxH
tJ7oOzDbAKzY6Zig3PrO9BlUFTGIqsN7YdqkSc/E6GJE54gyuA6qN/AZ651E
dxHtI9ovIveJ791NtBc3RkHiZqJNeHI5LMk66XYskbQzxgxYVAqLtuIIcN3I
mKIByca4f8BiOXzoWjXCrQ6FA0SHiX5M9JOIfPB8fy/RUaJ7iH7E9gGVbaC/
Bu54BezRjoFyGD0OSDNm0lIcyElnHsprFHdpNCxG3lkBEEzjRljiNqI7oHPG
eoToPqL72TsfZqkPCTRuH+LbYLATzxinGkJO6kIuNR6VmBGDqhJbBCGdBoNg
xm/RgDDJcwgM1iEaDAO2wh5xIQv/AaJHiZ4gOslqOSHgjhM9yZSIfsp9wGQX
HtyIML8aYnuhqgKGniw2YpMyqbicV1U7BUEHRjIutRSBwbb4PqJiuzK5B54U
0PgF0bMs9DT/PS9sniN6BoQeIfoZ2OyFFW+CUVcg5fZhpDqdlqOTs/FX7xll
0+HYJahwgjBv1ql4LpKsyVKr1a0MFfb8gxwR4kjKg+iXRK8QvUb0Kos+I9K4
+SLRKZjpUfA5AJfcLnMKfRfC58MHGnTi+zZ82h3TeGHS4ISJmTFMyl1fQuYY
3Og44J4m+hWY/JboDRH8O1HVOVwSQrJ2EPMfxsM7YaC18N9+aK4Rw8+cTdqy
KSuJ+8A6Jnf1IuiXIOGswuR3PbJQwOY++NAJuBRTeZXodaLzRBdEU2/z3wVs
l2RA93GY5m7MOZsh7WrMK91gkvvWTDpKQiYI/gbw7AGNAcSLifyNyL+s0d0I
lvtgFEODnemsmIPeInqH6CLRJayaWC9/Ivo9jHUGXngCfO5BBr8ZfEYQlT3K
Jz0jPlJ1J0PymbFMVpNZs86N/ZgEroKDXwvfuBVpaT+C/yEE+LMwy+vA/Uei
98GEzft3or/h98+4fh6cX+KExw+C1W7YeT2mrAE4QlNgopCqawpGzcWZIO0k
taDcmutY6Bp1tFHMjZyV7yf6OdHTiItfE71ptmlY3D+IPja/LP4TiUVm9b54
oNjwZSQNtu29YLVdE9wArNQUxA+F7GxEL8+pQeMn5gSPKX2bNEv3a/G4Cil6
C6qWO5CejiE5M7gXwCQOT/sL0T+J/k30HxH8mVj8U1D8gOhdGPEMlPAIqoM7
wWkDbLTQSQhJs5sYzsffta1WPoWS7GaSQb1TUA4g+axECBkDjWHuOIIoTyF3
XQCTvxJ9BCafE/2X6AuR/bnP501kjFPQxFEoZisojUBzXRg7aybTmfPJOWVy
EEJ5JyX0YdYehnHMpLPDeFUVFPyU+tp5BP6Hahom9DXRN/Kf5X8lnD7DPeb0
njrdM+B0RApr2gJOw6h2OuEfVUGpM0NOZqco4FTprLXatSww2Xo1mGRRDRxC
2fI4UAXZ4F210adinYDPN6Kir8UB5d6HSIHnkBqeQkFxECbnXLMarPowcB7q
jc/ASrIvj73qyuLVQMoh1aSkFoBLDsXvzZh89sJfHkCKew5BcQ75+n1E/7+U
lLVQLRh9AesZ33sb+e4FzMPHMCXtRE3OVekS3fKZSHYl+4qTcyqX7uWaGRJa
iSLVIUYKKEZGiiNoHzL2w0i/L6jPcVq+pOntMwTRVyzyS+tvHyFZvIeer0lZ
J/Y9irx9C9zZ5ASzgTURQzNkEnNNAysENagpdJZioHVQ3i3wdpfLaWB7A/q+
CNME/vZlRCjlEU4f49YlWPAsoo7T4oOYWY2vrUHamQd/qAWj+GXYuPubBfWz
VvM6wfw4K+ZmrXP6YZjljmECP3tQ/ewVTP5/QPB8YF0tKoxqYZNP1L3ekUpO
0gCntsegj7skuYj/rkCF0IuBc7rDXvrmJxLKJGb3G8U9g0QdUGnUWWcBZh2z
MNiIPQkzjR7WafQU8sBZdbOLhk1MslgBfnURHALXehIJZD9UshkaWgZzdCJD
V+kLi+my4O+Rop2AYNEWZOg2LdqW6LJgA6bP25yE9pjWA69B3ReQpsElIpmr
Dqwu4epb6PEqPPIkDHoIVds2TMtmwdOjC9E06XuuqflIpAR76mR+YhOr6piz
Gq3RpegsnXqW6dRzE7zjDgTPvchrTyBZvwjM52AJqUajQqYOVM8jj78MtzwO
RkdQk+8oXvJ06HxjchIZ5GHvq4p5ZSwvWXnHJyo4z+mCUmeOJoMVWKCYPH2b
U12bavQU0tsZWOysWe8UwO83IPoiSD8BLz0MQ5slzzrMnmbJU1Sy+bWZX5WW
8tJzAUnNC02OnUzJEzhgt+54DOviZxOS3JgG0zHUCcfhhs9jRfBSVGxSAJXT
4HsChcBP4XC7Uf7diPJ2RLcMWhC7FcH2jb834K8dlNPElXIbU5Vqq0Zn/knq
YqjWSdz9ToLYgJC+Fbl7L2CaDZDHwOykaOdpefgZVAAnYR/ZNkBm3Aev3QHN
rEOkLoYztDluh1D392OnZqXvgXLKqqE4otziNIioIfVAbz9kv26uMewHojI9
5eGT98OIR9FhDzx2K1KmyyXYBdFqYKo352WGy8RpDcuk4DApK660syWL1UU6
t5qNtk3IVTthpT0wFC8hDkWFVg2KsgO66Xk7aJtNNrP9vAg2b4eyTOzEQtak
/qkCw0JINCjuesevUsVLuHaES58u4UaQstcjF20G9B3Q7pj4S0Rw5rFUHcPU
tANq3wRfXIOHB/V1RRuUn1XU2B30o9y3h0EueyfNirzOqZtTExWZXXwa5Aux
nB6GB5Vu9G/FDn8NEttmgL0OfVbDSEPQ8lysWVogOeNC9usU/y2mRexdbVT0
vc5Kxt3tDzadenV/w7wWGkEhu0bfsKyHB63H97WYG1bCvQcBeh48rg3S8lBN
0pyQKDnVEI467OQdUOcnWX8FO/zeW7hBqHFYoEWEQxYgh3HVvMHqh4q7i19i
mfdv5l1Q1sPiZx3r0+PmrXyTIs058VjulOx53W9p04188wJ2gUCJisKz+vZ1
nr7Q7ELvRqDLqTrjNgvWeHj8XG/w+XoWjaKmqC5+95N0Tgjki98Yd5jX71FR
cgagOqA18ya7Ht5TDU9KBa+HZQsgBJ9UzYLLYCv3dZdxdkG8tzkTpxaArDEq
HxUYvlbf/1fr2YnkBA5RVdhp0GIkfv4K/C5djCh4E2zPLMTFa1LmIAmQpp2D
JMH4DVOOn7aaCHJMeclZCYwuOT5ivyTIHjOK6GEq/2RqpGQcP3e4J18xs8q/
4PRDRNrRiD1MUWYrUmGEM8Bxd06SstXMu36k++yll7yvngWnCK5LHY/n9Wym
/9yVTntitGqvV63X1lPMpnfOtsJ6ubKNtvJeLz/illpppndh3DnN7MmOBr18
X/SzjJybFsWaPdB6766/hpCTtKJCc5KswSLwe821vczZxCbvrr/H0m0RmPOp
zeOlp8Dla4eVaU4Nt3p3/fm/2co0p7T9M9H+nFtvZZuT5u0Wgd8rb3vBj3CC
+nLZMGMR4FwzdVmZfq+0lTkfvUQTpV6etH0G0KfHSnLXBRE7Fk4X02zbwnlg
DqP/A6SsGCs=\
\>"]]}], "}"}]], "Output",
 ImageSize->{341, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->39653021]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->67676268],

Cell["Set diffuse, glow and specular surface colors: ", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->518694676],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Darker", "[", 
      RowBox[{"Green", ",", ".4"}], "]"}], ",", 
     RowBox[{"Glow", "[", 
      RowBox[{"Darker", "[", 
       RowBox[{"Red", ",", ".5"}], "]"}], "]"}], ",", 
     RowBox[{"Specularity", "[", 
      RowBox[{"White", ",", "20"}], "]"}], ",", 
     RowBox[{"Sphere", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->50358000],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[0., 0.6, 0.], Glow[
    RGBColor[0.5, 0., 0.]], Specularity[
    GrayLevel[1], 20], SphereBox[{0, 0, 0}]},
  Lighting->"Neutral"]], "Output",
 ImageSize->{154, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->63926291,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23592],

Cell["Using specular surface for plots:", "ExampleText",
 CellID->16606973],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"x", " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"x", "+", 
      RowBox[{"y", "^", "2"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Orange", ",", 
      RowBox[{"Specularity", "[", 
       RowBox[{"White", ",", "20"}], "]"}]}], "}"}]}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->858661563],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->183883344]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31180],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Specularity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Specularity"], "[", 
   StyleBox["s", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Specularity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Specularity"], "[", 
   RowBox[{
    ButtonBox["GrayLevel",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/GrayLevel"], "[", 
    StyleBox["s", "TI"], "]"}], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->253706442],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{"Orange", ",", 
      RowBox[{"Specularity", "[", 
       RowBox[{"s", ",", "10"}], "]"}], ",", 
      RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", ".5", ",", "1"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->63357435],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {RGBColor[1, 0.5, 0], Specularity[], SphereBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {RGBColor[1, 0.5, 0], Specularity[
      GrayLevel[0.5], 10], SphereBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJydmwdYFNf398/OFpZet9F7771XAVGWDiIgRUBQERWxoAKiYEMsiIpYsXdR
7BF778aaRKPxZ4stNiyw53n/M7O7xiwmMa/PMu6de3fm+7mn3DvlivPKiwuH
5ZUPzs8zjS7LG1E8OH+UadTwMnIXkwEAheRfiRDI7/+P/Eb/hSMiMAsLC5H+
B6bUBkLILZvcaUaXgsgtQZaYsv+lewNkJfZXRyC3siP4kltqpxJVYn05PvnF
hK73lv1aVeHX0loP2a/Ve/zamK53k/1aiyqxv9TLjmFEt3GRtdH5hzaOsvPo
KfQCoVDWp1vby44o+K7WtrLWIoVapkKZrgcrmRIDhVqWQllIt7aQHdv4u1qb
yo5tqlDLVijTXGAsO7bFd7U2lLW2UqjlKJT5dGuRTImNQq2SQplHtxbIjm3/
Xa15staOCrVchTJta9CRKXFWqFVWKOvSrbVkx3b7rtbqsmN7/ktr2jNBVXZs
n+9qrSxr7adQq6JQ1qZbc2Wt/RVqVRXKWl9afx2LlnT3pfMghweDeDCMB+U8
GMuD8Tyo4gFRw+txnH84bs8coBvPg370wYt5MJwHo3kwgQeTeDCVBzN50MCD
eTxo4sEiHjTzYDEPltDbRh708C41hbLmn+ftEfl0hInieJAkP30RffoxPJjI
gxr69LPocy+gT7yUByt5sJoHa3mwngcbebCZB5voL+tpQT0i+h/U/EPWoCPE
RMyDRB6k8WAADwp4MJQHZXSHk91Sx4N6HsyldbXwYBkPWmlRpJAtPNjOhx08
aOfBbh7s5cNeAb3lwU4+1UDGrqlwTo1vKlPkobyaIIWBPiktXd5lpbQ7kBab
zIPptLkaaVstlevaQOtq48EuHuzhw34h/CCEQ0I4IoCjQjgmAOKYkOy8w+R+
PlDqtBTOS2f/HtGumIeoXzEpdYZxdMcpGHQKD2bwYA7tSc10r60iDceHzQLY
LoB2AewRwAEBdJC6RHBMBCf14bQBnCU/hnDOEIjzBqRGskiekBTeowe/rVHR
PzXkGi0TvqVx8lcaSYdaTrsb2X1bSZsKYJcQ9ongoD4c0YfjBnDKEM4YwXlj
uGQMV0zgqgn8aArXTOE6uTWhZJI7zxlQQBrf8sseWhXLdCtzUmwc7YrJtOBs
OgOU0kE6UW7y2bTgFj6s4MNqPmzgw1YB7CR7VAQH9OGQARw1hJNGcNYYzpvA
JVO4agbXzeGmBdyygNuW8LMlEL9YAR2hP1lSO0mQc0bS/PnvuhW9VkXupXbx
8tiWxlCJ3FHJ2J5GO+p8aTeTqgWwQQRbRbBTBHv04QcDOGwEx43hNNmFpnDJ
HK5awHVSmhX8ZA13bOCuDdyzhft28JsdPLCjOpv8ct+W2v+TFVwx66ld9Zva
FXM7V67dKo7u8XRae748/ivkaXGWPMhINyZ7fL0Atohghz7sMYAfDOGwMRw3
gdNmcN4crljCNSu4aQ0/2cAdW7hH6rWH/znAI0d47AhPnOCpEx1zBPkVWOQu
su5XO7hh1YNA5ZsEiuMNR+7hjqSHp/Iggwd58sROOnklnb5m0ulrIR+W8qFV
AOuFsEUfdhjAHkM4YAyHTeCEGZwxhwuWcMUKbtjAbVu4Ywf3HOCBIzxygifO
8LsLPHeBF67w0hVeuVEEL92oL+T2mSs8dYGHTvCzbY8MLGX4t1GDmj2xaCuQ
7tP/r8OeLM/xYbYAmoTQIoQVQlgrgk360GYIu43hgCkcNoMT5nDGEi5awVUb
uGkHP9vDrw7wmxM8cqbEPXelhL5whz884I0HvPOETi+pFd56kfLeecFbT6qO
bPHEFe469FCo/E0ORYsRcg6bONoWWbQrDeHBSB6M40E1bYtZfGgUwCIhLBPB
an3YaADbDKHdGPaZQoc5HLeEM9ZwwQaukj5hDz87wj0n+J8LPHaFZ2Rvu1Py
33sCpdgb3vnABx/45EuhfPYFID76kSI/+MJ7X6rutRf87gG/OPag4X6TRjFr
sSkSl/geaWjCl7zJhwUCWCKEVn1YZwBbjGCnCew1g4MWcMwKTtvABVu4ag83
HeEXJ7hPuogrPHGnJL30hDde0OkNXb5A6v7kBx/94WMAdJGfQAqmOxAkgUBu
PwVQ+8nat77wnDTV95F8GStIAgqCtolFIu1bZHAM/sogU/kygzSLYLkBrDGC
jcaw3RR2m8MPlnDEGk7ZwHk7uOIAN5zgFxe47wqP3OEZ6Spe8NIbXvlQyj74
QzctnVTcHUTaQRJMnrQ7hELpCgFJCOkZIWS+7QqGz8HwMRDe+cNz7540St+k
ocZZ2hbm0ggnE1QhHR2j+TCBD5MFMF0Ic4SwQARLDKDVCNabwFYz2GkB+6zg
kDUct4Wz9nDZEa47w8+ucM8NHnrAMy/4w5vS/s4P3vvD+0D4GATdwUCKJrpD
SfWSMJCEA4ZTDIQkgpqsRFBF8kPu7wqFTyHQGQRPfHrMPb9NofklxuPlw1u6
PFWNIGe3fKgSQK0Q6kUwTx+aDWC5EawxgY1msN0CdlvBQRs4agenHeCiE1xz
gdtucNcDHnjBU294SVN0BsAH0mGC4HMIkARS/ZRwQtKLnElIIgEj6ZhnYRRp
j0iSEXtBdwR8DoN3QbQnUXLpSZhUtozkb+c9lmSUJ9AkX2KdHDZGkdNGPtQI
YJoQZougyQBajKDVBNaZwRYL2GkN+2zhkD2cdITzznDVFW65wx1P+M0bHvnC
Mz94HUB16yfSTcguDoPP4dDdi1JOkKpJKdEg6U19MIZmYZP/E9gbaKjuSKr5
H0F0PqUEK16Vcr7J88Uy1lKeFNoyX0d8JR+mCGGmCOYawEIjWGYCq81goyVs
t4bdtvCDPRx1gjMucMkNbpD5xgvu+8AjP/g9AF4Fwttg+BQKXaTLkD0dCV2k
zGhAGgD7kNr7kn+xIL1KiQUUUx9qD1VDSu1DtZVEw8cIkMv+5pzvn6mS6VlJ
pjz6R/BhHB+qBVCnD7MModEYmk1hhTmstYTN1rDDFvY6wCEnOOEC59zgqgfj
tjfjV1/GQ3/G00DGy2DGmxDGhzBGVwSD9ClJFGWN7hjo7gsy/XGk9njyL0FG
lQDSD5PcS4qNoxvFUvRkT7wL/+aI3pNHQ54FqPhJkc9UCvgwVABlAqgQQo0I
phnAbCNoMoUWc2i1hPXWsNUOdjkwDjgxjrgyTrsTlzyJGz7EL37EgwDm0yDm
sxDmy3DiTQTxIZLojiYwhux1BsYyMI5BiqVkJ5Lxg0mUfyUDplAfKh+Q/xHk
DrqGQ7ahWsZT5KTRunr/VyJLKZFs4OfDMAGUi2CCPkzRhxlGMMcEFprBUktY
ZQ0b7RhtDsQeZ+KgK3HMnXnWi3nVh3nbn3UvkPU4mPUilPUqgvU6kvU2mvUh
htXdl4VisteZmEgqJUUTmMogMI3U3Y/8S5fZJx2oD7UnjcpyqTQnSZtE0VNY
sfBHrx4zx39hso6ns4LU5Yr4MFwAY4RQqQ+1hlBvAvPMYJElY7k1Y40dY7MD
scOZuc+VediDddKLdcGHfc2f/XMg+0EI5/cwzusIztsozvvenM6+7I9idnc8
GxPZmMzCVBb2Y2I6E/sTmEFgJkmWRV0SDwDyf2kiywTSFBmA/ekPCZkGMrwk
Cuxzn++kouY5HIrKIf6rXDeYDyOEMFYfqgyhzhhmmcF8C8Zia8YKO2KdA7HF
mdnuyjrgzjrixT7tw7nkz7kZpHQ3ROlhOPdFL+67aO77PtwPsdxPcdyuRCVJ
shKmcrAfB/uzMZONA1iYzcQcJuYSmMfAgeQHME86Y8Nc6tZNDmA2SFlJTBle
PxovGSTx0MMHaaYe9+k0vpDFye2VLw0pfagwhEnGMM0MGiwYTdaMFlui1YG5
3om1zZW924PzgxfnmK/SWX/ulSDl26Eq9yNUnkSp/tFb9UNf1Q9xqh8SVT8l
q3SlqUjSVTBTGQdwMUcJ85RwIAcL2FjAwkImDiKwiPwwcJCMrJAiywcpLMlJ
IUr5MuTmS/ovZEr0vCeFD1kCKBBCiQhGGcB4Y6gxhekWjDlWjAW2xBJ75ion
1gZXznZ3pT1e3A5f5RMBKueDVH8MVfs5Qu1BlPqzGPU3sRqf4zQ+JWl8StX4
lK7elakuGaCOuWo4UBULVbBIGYu5OESJJBjKJuWUsLCEiSVkiSHlGkJNdYqB
5CQRsYAGzJUbUGq9NPic0MMbv8dmAhgghEIRDNOHckOYYAKTzRkzrIg5NsyF
9qxlTuzVLpyN7tw2L+W9PiqH/FVPBqldCFW/FqHxS5TmwxitF7Fa7+O1u5O0
u9O0u/trd2dpdedoSQZqYqEGFqnjEDUcpoqlKjhCGUdysYyDZWwcxcIyJo4k
pGzDKbZhgEMBBwMFSRLmy+0nxUsHScp/YKPzh790LE7jQ7YQBulDqQGMNoaJ
ZowplsQMa+ZcO9YiR/YyF6U1btxNnio7fFT3+asdDlI/FapxKULrRpT23Rid
R2Ldlwl6ncl62I+HGTzM1sM8PSzQxSJdHKKNw7RwuCaWaWC5Oo5RxbEqOI6L
FUpYwcFxLBxLixrDwHLAkUBSUowlNGORnFFqwkwq7r6PTl1OFyCdA1I3C/iQ
I4QiEtAIxpgyKi2IKdbMmbaseQ7sRc5Ky924az2UN3ur7vRT3x+keSRU+3SE
zuUovZsx/Lti/qNEwcsUYWe6CDP1MUeE+SIsEuIQIQ4T4EgeluvhGB2s0MYJ
WjhRAyvVsEoFq5WxWgmrOVhF5/6JBFYwcAxQmGWAI2jMIX+1YzYVfv+fhClS
QhEUGcJwExhjzqi0ImptWfX27HlOnGZX7goPlbXealv8NHYGaB0I0T0awTsT
xb8SI7wVq/9rgsGjVMMX/Y3eZxlhjjEWGGOxEZYY4QhDHGWIY/VxvBAr+TiJ
h5N1sVYL6zSwTh2nquJUZaxTwloOpWsyE6sJnAhYATgWcJQccijIIjJf5ql/
Q6h4T/KLhwZIb1OR2SVdCLkGUGQMw80YYy2JKhtmrR273pHT6MJtdldZ4aW+
zldrS4BOe7DegTD+0Ujh2Rj9q7GGt+ON7yWbPE43fZll1plrLimwwGJzHGaO
I81wtBlWmOJEY5xkiLX6OE2IMwQ4Uw9naWODJs7WwAZVnKWM9Uo4g77NXEdg
DQOrgOIcBzKfLf0Kkkw4OT0zJ+tvCen84p8ogFQhZOhDriEUm8Bwc8ZYK2aV
LavWQanemdvoptLsqbbCR3Odv86WIL32UMGBCNGxaIOzfY2uxpveTjK/38/y
SabVq1zrzgIbyWBbLLXBMhscY40TrLHaCqeY41RTnGmMDYY4Vx/nCXC+Hjbp
4AItbFLH+SrYyMW5SpSumUycRmAtA2vkhKP/SlhAOer309H2cxTzIVEI/fQh
0xByjaHYjDHckhhrw6qyZ9c5cetdVRo91Jq9NVb4aa8L1Nsawm8P1z8QZXSs
j+nZOPOrSVa302zuZdo9ybV/VeDYOdhJMswZRznhOEec6Ig1DlhnjzNtsMEK
51lgkxkuMsJmfWwR4hIeLtPBJVrYoo6LVegkqo5zWdjAxBkMrAOcBDJvLf8q
HmkT/gdCauZPkIBgkyCEVH3IIBFNoNicGG7NHGPHrnLk1Loo17upNnqqN/to
rQjQWxcs2BKm3x5pfKC32VGx5dlEmyup9rf7O97Ldn6c7/pqsFvnMHdJmQeO
9cBKd5zshtPcsN4F5zpikz022+ASK1xujiuNsdUAVwvpiSV5CbJchZK1kI2N
TJxD4Az4E/BLLJbILPgf6JhyOiuxAOIEkEwCGkGuGaPIkhhuwxpjz6l0Uqp1
Van3UJ/nrdXsp7sikL82VH9LL+P2aLP9fayOxtueSXa4ku58O8vtXp7H40Fe
r0q8O0f6Ssb44UQ/rPHFaT7Y4I3zvHChO7a44ApHXGWPa61pIaCLm4S4URc3
aOM6DVyjiiu5lL5mFjYxsYGB0wFrAasBx9OOWkY7Km3E/2hBsCAhSUSxEJIN
IMMEcs0ZRdbEcDvWGEdOpQu31l213ktznq9ucwB/ebBobbjRlkiznTFW+8W2
RxIdz6S5XMlwv5Xjfa/A7/EQ/5fDAztHB0kmhGBNME4NwllB2BiIi/xxqQ+u
9JSS8XGbNbaZ404T3GGAbWRRF7dq4SY1XKuMrXQsNjOxkYGzgKKcDFhJh+Mo
eoQsocbGbxMqPnP6cnVqKiWME0GiEaSbQq4lo8iGWWrPHu2kNNFVZYqH+kxv
rXn+eouChMtDDdZEmGyOttjZ12ZfvOPhZNfT/T0vDfC5OdD/blHw49LQl+Vh
7ysiJNW9JHW9cFYEzgvHRWE0lwg3e+N2d9zpjLvsca817jfHfca4V4S79XCX
Dm7XwE0quI6Lq+kxYyGBcwHr/2rGkXQsFv+dDRUJteSEBnFCiDeABGNIM4Ns
K2KQLXOYA7vchTvBXW2yl8YMX+25AbxFwaJlYUarI803xdjsEDvsTXQ9lOp5
MtP3Ym7g9cKQO0MiHo6MfDE2+n1l7+4pfaTRZYireuH6UNwShDv8cbc37nPD
A07YYYeHLLHDFDsM8KAA9+viLk3croqblXEdB1fQo34TA2cDTgVZPh0j81FJ
8X9go+8AiUjrkaaLN4QEU0ixYGRZEwV2rBInTrmr8gQPtcnemjP8dOYEChaE
GiyNMF0VZbmxr31bvMueZM+Ofr4nBgSeHxh6rbjXz8Oi/1feR+qBppLZ8ZKm
OMkSMbbG4voY3BqJO8Nxbwge8McOLzziiscd8bgNHjPHY0Z4VISH9HC/Nu5S
xzYV3KiEq2jCRQzKgqSLTvnKRUvhc3GPu3XMfybkU+GnD3FGNKElI9OGyHdg
D3VWGuWmPN5TrcZHa5q/3uxgYVOY8ZJI89beNhtiHbcluu1O9TnYP/B4Tui5
gl40l8XTyoQ3tUmfZ6ZI5iVLmpMkKxIlaxNwsxh39MG9UdgRgUeC8bgfnvLA
My54xg5PW+IpEzxpgEd52KGD+zVwlypu4eJaNq6klc6Tu2ilfLgYDp1F8B8I
6Sc/elQECkFsQEEmmUGqFSPDlhjoyBriwilzVx7npV7tpz01kNcQIpofbtwS
Zbmyj916sfPWJM9daX40m9XlktibZfF3K5IeTUp5OTWtsyG9q6mfZEmaZFUq
bkjB7Qm4W4wH+uCRKDwRiqcD8LwPXnTHC454wRrPm+EZQzzBxyM6eFATd6vi
di5uYOMqJi6mrp+oXEOOGlUySMnwnveN/4VQS0aoD2JjSDSHNGtGhh2R58Qq
dlUa4aEy1lu9yl+nLohfH6rfGGHSHG1Fx5ftvgFhhwdGnSrue6E0/np58i8T
0h5MTn82I+Pt3KyPizK7lmdI1vbHzem4MwX3JeAhMR7vjafD8VwQXvLFy+54
2Qkv2+JlC7xghKeFeFwXD2niHlVs4+ImNq5mYgsD5wM9faPTTAWVZj6Xficd
/Z6FBnWDXzpEkHAmEGcByTaMdHsix5k1yE2p1FN1jI9GZYD2lGA+bSnHZbGO
qxPcNqX4tPUP2pMd0ZHf+8Rg8bkRSVfH9LtdmXG/NutJffarxtx3i3M+rszu
Xj8At2Xi7n74QzIeTcBTffFcJF4Kwav+eNUTrzrjVTuK76IxnhPhaT08rIn7
VHEnzUeabwnFR/ooJZrmk5TDx2F/w/f1fWf6bRbVP9kMKDaxBSTYQj8HItuF
VeiuVOKlIs0YztPDDeZEmi6IsV4idlyV6LEh1XdbRvDunF4/FPQ5OiT+zMiU
y2PTb1Rl3anL/t+s3Ofz89605L1vzf20MUfSNgD39MeONDyRhGfEeDEar4bh
tQC85oXXXPCaPV6Rw53SxaNauF8V27m48S9wpPEo1RXQNarH87CeZPQ7QEoy
MhLLFMSWEGcLqY6ElMatzE+9IlB7Uih/aoRBQ7TZ/D7WLXGOK5Pc16X5bckM
2Znba19hn8ND40+OTD4/Lv3Hqqzbddn3GnIfNw18uWTg21V5HzbmdpFYe2ms
41+wwvFaIN7wxhuuciwjPCfEE7qUzfbTNiOxWqmQw0bAmVTipJ5DjYNPZT2f
Lf8NF/MLl3SE8uzvysr14BT7KA/3Vx8bpF0VyqvtpV8fbTqvr1VzvMPyZPc1
/Xw3ZQa35fXaM6jPwaHxx8pSzoxLv1yVdWNq9i8NeQ+aBv6+ZOAfqwa+35T3
qS27e28GHpJCxeKFaLwShldpW113wR/tZFBnyEDTwQ4N3KuCbUq4gYUrCVwI
1GgwgxrvJBMprmelPZ72Ed9kom3iS5nJChLsIMmJkerGHODJLvThDgtQKw/W
mhCmN6WXaEZvkzl9LRfE2y9JdmtN91mfFbQ1L6K9KGZ/SfyRspRT49IvVGf9
ODXndkPerwvyHy3Nf7564JtNAzt3ZH+WMSXiaZIpCi+F4mU6uK44U8njojme
N8RTAjyqgz9oYLsyblHCtSxcRmATUGP4NGo6/Xk8dJZTWP/OpC1nCiS/UObS
l/mg2A4SnBgpbkSGJ3ugL3dIgGpZsGZFuO6kSOHU3kYNsRbzE+wWJ7usSPde
OyBwc17EjqLee0vEB8uSjo1LO1PV/1Jd1vVZ2T/Pz73fkvu4NefFhpw327I6
d6d/PpjSfTRecqqP5HwkXgjBi354yQMv0on/nCme0sdjfDysjXvJ4VsZN3Io
F2yRu2AddFXBx3HwdITsNaJvPW/+K5+GjI++dvcRi+jEQdPFOUGyG9Hfi5Xj
yykKVBkeoj4mXKcykl8bYzAz1mxugs2iFOdl6Z6rsvw25IVsG9Rr19CY/SPj
D49NPlmZdr62/5WZmTcbB9xpHvDbiqwn67JebEl/3Z76fn/ix47YT8eiu06F
d58J7D7nIznvhufs8YwlnjTGo0J6cqKJ7WrUwL2GTdpNspCBc6iZSVcNfJwA
f4zuOftXnIPJKf/coyqjpJ/+elMZ0vhPygQ3RpoXc4AfuyCQWxKiNipca3yU
Xk2MaLrYeHaCZVOKfUu668os77V5AZsLw3YMjdozou/BMfFHJyafntzvwoz0
H+dm3FqUcXdZ/wdr0p9sSn3elvh6t/j9/pjOQ70+Hg3+dML380mPrpNO3Sdt
JSfM8Yghdghwnw62q+M2FckGJVzJkiwmusm5ySzoqoUP1fB6XI+7RP9OSD3j
onIIPVZ4iQ1BbA5iWwov3g0SvYh0P1ZuIKc4RGVEhMbYKJ2qGEGt2LA+wWxe
ivWidMdlWe6rcn02FAZtGxLePiJ6/+i+hybEH69JOjMt5dLs1GtNqbdbUu62
Jj9Yn/Bkq/j5jpg/9kS+3R/6/qD/h8NeHw+7fDps9/mwZVeHcfcPItyrh+2a
uFW1az23u5UtWcLsms/oaoDP0+B9DbyeAA/Lez4vULyT1JNP/oSSHsU9qBC0
AbEjxLlBghcjxY/ICmQXhHBLIlRHRWmOj9GtEQunJRjPTrFoSrdtyXJekeu5
tsB30+CgttKw3aMiD1T0PlzV90St+Fx93OW5cdcXxt1eKr67qs9vG6Ifb4l4
1hbyclfAm73e7/a7de536Nxv/WGf6cc9Bp/a+V1t2pKt6l3rlT+3cj4vYX1e
SHyaDR+mw/sp8KoSnoz793efZGR/vmOJX73X7E7ZzQrEDiB2hThPSPZlpAcy
c0M4xRHKI6LUxsRoVYr1ahNEM5NN5vWzXJhptzTHuTXffX2Rz5aSgB0jQ/aO
DT84MfLo5OiT03qfa+h9uTH6enPU7eW97qwKu78u6OEmv6fbvJ63ub7a6fC6
3eZtu/m7HYbvtgs6t+h83Kjxaa3qx5VKH1pYnQuIzjmMdzPgdS28qIZHFd98
B+rrMoNmopDot5hdKevYgdgFxJ4Q7wupAURWCCs/QmlolEpZjHpFrPakBN60
ZP2GNOP5GRbN2bbLBzqtHuS2cajXthF+7eWB+8YHd1SHHq0NOzUj7Pzs0Mvz
Q64tDrq1LOCXVp97azwerHd5tNH+6Sbr55vNXm42fLVJ+Md63ddrNN+0qr5d
xn27mP26ifl6NuOPGfCiFp5Ww//Gf/t9gx76v95DvxfuQmUIRxC7Q7wPJAUw
0kKI7HDWoEil0hiV0bEaE+O1JyfxZqSJ5vQ3WjDAvCXPZmWhw9rBzpuGuW0v
89w1xnvfBN+OSX7H6vxOzfQ9N8fn0nyvHxd53Fzi+tNyxzsr7e6vsnqw2vTR
aoMnqwVPW3WfrdR6vkzt+WLuiwXsF43M5w2M36fD01p4WA2/jocLZT2vUv6O
QprbC+XvzzqRWYD0JrEXiP0hMZiRHkbkRrKKeyuNiFUZG69elaRVm6o3s79w
bpbhwhzTJfkWrUU264babR7u2FbuvGuc6/6Jbh01bsfqXE/NdDk72/niPMer
TbbXF1ndWmz+c4vx3SUG95byf2vRebBY8+Ei1UcLlB81ch7NZj6qZzycBg8m
w/1q+Gk8nBrZc06k+L6HVP8337m3pyLCA8S+IA6CpFBGZi8ivzdrSF+lkXHK
FYlq1SmaU9N16zP587JFiwYaLi00WTXYfP0wy80jrdtG2+6qsNtfaddRY3u0
zubkdOsz9ZYXZptdnmv8Y6PB9fnCW016PzXp/DJf406jyt253F9ns+/VM3+d
zvi1Du7UwE+VcK2ix9uuitlL5v8ofYOb9h1bSjHd5QkhkBYBWdFEfh/WUDFn
VAJ3fLLqpDT1qRlaswboNubyF+WLlhXptw4xXFdqvHmk6fbRprsqTPdNND04
yeTwFOPjdYanpovOzhBeqOddnqVzdZbmtVlqN2ap3JypdGsG+/Y05q1axq0a
uFkNP06AC2Ol754r3o/ooVWx7+lethJ7gzgQEsIgNRKyYhgFscySeNaoJKXx
qcqT0lWnZarPytZqzNNeVKC7tJjXOpS/rlS4aaRw22hh+zjhngmCA5X8jkl6
R2p0jk/RPlWrebZO7XydysU67qU6zuVa1pXJxJUaxuUquDgRzlbAcXIcV1zL
oWh7qValr/vVnNIYDPHhkBwNmX2gII4oSWSOSmFX9ONMyuBOHaAyK1d1Xr76
wkKNJcVaK4dqrSnV3jBSe0u5dtsYrV3jNPeO1zgwUa2jUvVIlfKxaqUT1ZyT
1azT1cTpSsbpiXBqApwYB0fGSN/w/ldlinmR7kUT0kXjIiChN/TvCwPjYUgS
MTKVOS6dVZ3Jrs1WmpnLnZuv3DRIeXGxyvKhKquGqa4brrJppMrWcuW20dz2
sUp7xnH2V7APVDAPVhAd4xkdFdAxDg6OhX3lsG0ESNeJKCijLvopRVJVinMF
ut8MxOEg7g2psZCTAEXJUJrGGN2fmJjFrMlmTctjNeSz5w1iLyzmtAzhLC/h
rCplrx3O3jCStbmMuW0Usb2csaMcdo6GneWwYxRsK4O1pQCK61+IHkrk6yXo
lrrkF3EviOsL6fEwMBkGp8GI/jA2EyqzGZNzGdPyiVmFxNwioqmYaB7CWFLC
WDEMWkthFXkmYs1wMjGsHg7kLupQ9Foa9tcjaCH9ZBWxZ5ah+0vv67ZkN6Qk
QHYKFPWD0gwoz4KKHKjOgyn5MK0AZg6ChiKYWwzzBsPcwdBQTK/g+euaCOmZ
NGR0ihbx+qr8py7FHML7rl9pK7RSjBj52ixpax1ZSbGVj2y/1CqKtYrnoJSw
vrSWr9VRbOUmayV95qe4zkrxuspJ1lr6VqxQdkzFVtQ6LLb8qkXqtwpz+K/L
lrJjSlfbKHqjYhSYylpLVzfJ10IptjKQKZCuC1Ncs6U44gpkx5SuhDORHVOx
la6sFe1HYKZQq5hZNGUK6HVXYI5/rudT7AvqmPQKKunqn794qLKs3pWut/rq
14X0+4zSc9CrnsCa3FI38el1SgCM/wP5MX3p\
\>"]], ",", 
   Graphics3DBox[
    {RGBColor[1, 0.5, 0], Specularity[
      GrayLevel[1], 10], SphereBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{341, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->188139789]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{"Orange", ",", 
      RowBox[{"Specularity", "[", 
       RowBox[{
        RowBox[{"GrayLevel", "[", "s", "]"}], ",", "10"}], "]"}], ",", 
      RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", ".5", ",", "1"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->256341244],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {RGBColor[1, 0.5, 0], Specularity[], SphereBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {RGBColor[1, 0.5, 0], Specularity[
      GrayLevel[0.5], 10], SphereBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {RGBColor[1, 0.5, 0], Specularity[
      GrayLevel[1], 10], SphereBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{341, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->119176125]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->90117218],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Specularity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Specularity"], "[", 
   StyleBox["color", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Specularity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Specularity"], "[", 
   RowBox[{
    StyleBox["color", "TI"], ",", "1.5"}], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->226188554],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{"Orange", ",", 
      RowBox[{"Specularity", "[", "White", "]"}], ",", 
      RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{"Orange", ",", 
      RowBox[{"Specularity", "[", 
       RowBox[{"White", ",", "1.5"}], "]"}], ",", 
      RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->51337253],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {RGBColor[1, 0.5, 0], Specularity[1], SphereBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {RGBColor[1, 0.5, 0], Specularity[1], SphereBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{230, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->47659562]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->181279056],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Specularity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Specularity"]], "InlineFormula"],
 " is strongly affected by ",
 Cell[BoxData[
  ButtonBox["Lighting",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Lighting"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->435397519],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{"Black", ",", 
    RowBox[{"Specularity", "[", 
     RowBox[{"White", ",", "10"}], "]"}], ",", 
    RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->85655928],

Cell[BoxData[
 Graphics3DBox[
  {GrayLevel[0], Specularity[
    GrayLevel[1], 10], SphereBox[{0, 0, 0}]}]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->792790470,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Black", ",", 
     RowBox[{"Specularity", "[", 
      RowBox[{"White", ",", "5"}], "]"}], ",", 
     RowBox[{"Sphere", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->133116279],

Cell[BoxData[
 Graphics3DBox[
  {GrayLevel[0], Specularity[
    GrayLevel[1], 5], SphereBox[{0, 0, 0}]},
  Lighting->"Neutral"]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->177486761,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJyd24ebHWX1B/DJbGHTdje7myUhlYTQi6GTUBQRkBqQokgxhC6RHgGlNwEb
qPRepSlgQXoRsNGrCiq9N/+APL/fZ+bcHSbvXsLGfZ7c3Dvz3vc933O+53vO
OzN327lHHrDv/LlHHjhv7tQtDp976AEHzjti6uaHHO5Qy7Asy/bx7+Bxmff/
5135b9OFCxdmLfvuu+/C8i+bUrxkm3htc3Bq+Wkjr7lPLY3/4+gsr8UX22oz
eG3MsH5jbEfTs+s2zo4oPrVWq3szuTy/VmPuUcWntup8Y45J5ZiZjTm6FjNm
jcaYnqZjJpZjVm2s1Zd4Ik8+jy9Hr9yYcekhjV6hMff45GxL8nlcOXpGY+6J
Qxo9vTF6cnK2NflcWppNbVgyNTnblnzuL0dPbsw9fUijJzTmnpGcbU8+jy1H
j2/MveKQRi/dGL1ycnap5HMZvfK1OLhqcrYj+dxbju5pzL3GkEZ3N0bPTM4O
Tz6XXMtGNyxZKzk7Ivk8phw9sjH3ukMaPbwxev3k7Mjkc3c5uqMxetbnzP3p
6Hq+Luf/EVk2aO70c9en314kn4t87/H9NF6jks+dn35/UJ4W/BpnjpTZi5lj
MZlZcHaS2cq0isPxzdqY0eVMqc3p+gUvuk2UDxs2rCP35//WcuZkps+dOc2r
IhadjZmLifOWlpbhra2txf9ZW6zkdOEcf13N/DJojTS/CsyjG2tkrbGGv2KV
tra2rKW9vX2p8i/LveQdHR3F/5nD7W3ln5HGmzBvYsPIpjY0Y0FhQ9YaQAev
b9ksHz58eNYyYsSIkSNHes1a/Z91eOd4R/lnbFGfWlqKabJskNebW5Mypcir
UQMeGVmZUxliuTBi1KhRo0ePzvLOzs72rq6ubKQ3Dowq/wwxZXipitQgi0Y0
tSjVkqUaFmVddf+YOGwKg8IaJjClu7t7zJgxWd7b25v39fVlXWPHju0r/xzp
6elx0hBji+JbOtBM4bdmVpb2DGJOmvttA1aOqVtZmchhYV8YxxBG9ff3L730
0uPGjcvax48fn432zmdHw+Cirnd1+Zovm6UgRV4EdlDON7cwHVVk7oiByHaz
L1xYxZQLLRfGWZ0Z7GHXhAkTJk6cmE+ePDlrmTJlytTyL8uLl06fJ02a5LRB
hhYdRF8fF5vIdEHKMDq1pqOpzanv84bN2djEq6YOk8OllqxMXmaZZRjEXBYu
u+yy06dPX2655bJ8xowZLcsvv3zW6Y0DDjtpiMV8g985HXjuDkJYbWg2p7pZ
2tsf9lZErewNFzPWiuHcsJQ9DGPgiiuuuPLKK6+yyiotq666ar7aaqtlXd74
vNJKKzm3wgorFB3M1Kn8zm6QYecEs0euDfL0Uk2trrQqi7+O4mVc5eWwmifC
xRVl+ZdzhT08G/Yyjp1rrLHGzJkz11xzzbXWWitfe+2183XWWSfr9sahL3zh
C06vvvrqFoTANyEwESeYl0/CfMun1rc3tb6oDcMLiydUfq6oXFlcOdlC4WHm
8iJ3soStDF133XXXX3/9DTbYYNasWbNnz95www2zfKONNsrGeOeQE+utt55B
lgZRYMJ6zucJC1jJkoVWN+kPwvZmda20fWJie0XoyvZgx7Rp01AjDOfFymr2
MnWTTTb50pe+tOmmm375y1/ebLPN8q985SvZGG8ccdzZjTfeGIyiaZs5E27z
AGBajuF7fC+qGt4U7C7alo7PtLrkyKQ6R0LcgtZ4iI1m5ZxwN2owWezDZP5k
7xe/+EWWbr755ltuueVWW2219dZbb7PNNttuu22Wb7fddlmPDw599atfddog
KNjAfmQykQDIXfSzjPUszHWNrqgwNu1O2ppi6RrAMrkp3yss8qvufgTgwgoI
73LzFltswV6mz5kzZ8cdd/za1762884777LLLvmuu+6a9Xi/0047Oe7s9ttv
Dy8rfNHXBRAgqWNygERb2FEAHYooNO2OFoMkCYmwkkXxjZAEDPTnQByQkWiN
P4IBA1dzO/sYyvRvfOMb3/zmN3ffffc99thjr732yr/1rW9lvXvuuaePjjsL
mpGsECZ0wzFguEawgRF+QoHGRafkL+2xmyPpHEAyRUwGkyuQCIjZAwnP8R95
QQ4W4FTA4Gle//rXvw4A6/fee+999tlnv/3223///Q844IAsP/DAA7NeHxxy
wmnwwGIJTHgooLwCECdZw2JWtbwiLDJLgKYEP7XK8QpNJDgXVXGhKRW3Iii8
ilWgYA8oPD937lzTQ/Dtb397/vz5hxxyyGGHHXb44YfnRxxxRNbrvSOOH3zw
wQACZvBuu+0mmsIakPjJEtaSnMSLGUVfOTQ8owfwLFvPmNAsVAs8VbqIDipY
DMnoKL7LZKHZYYcdUEdcuNzcDGUx04866qjvfve7Rx999LHHHvv9738/y487
7ris73vf+94xxxzjhNOAQuY78+bNw0SzyLiAZQ2MDt5FmNiX9pCBKlWHKkrr
1UUgIMkeGsxPQThuC8JFiECyOrbgjPgwiWF1PJAcf/zxJ5544sknn3zqqaee
dtppZ5xxxumnn+69I46fcMIJABrJHCHFRmQVLnNyFn2gmZLV0pRBrIoSM3RU
hSZm0+r1JbgXmhCVBQ14zRpqCnWFitjKIZ7FOuQRJWYxDqQFCxaAxOhTTjkF
kjPPPPPss8/+0Y9+9JOf/CT/6U9/mvX9+Mc//uEPf3jWWWf94Ac/ABJ4FuEm
WpoEgSUlbNI0hA9H2EBnCxIlCFoXj2v9SiGCgLxT12sFglgDRRsSUPJcHkmi
73znO2xDL3ZCxGbGw3Huuef+/Oc/P++88y644IKLLrrowgsvPP/883/xi1/8
7Gc/cwpe2FmEpBwi2BINnc1MCdVZK/InNZcNxT5tSLhGD+CaFfEK5YtmIGGh
gorrleahIFwcW8eFUoh10kknYZsYAcV+QC6++OJLL7308ssvv/LKK6+++uqr
rrrqiiuuuOyyyxx0yhihZFTEziTijtNmJiBqhBW5VFFnjPQo9uJLjs63otXh
HFELKurONJOoSDNoLnrwpBUJoGqKhwENkfic58UL/fBNUISJ/bBcc8011113
3S9/+csbb7zx5ptvvummm2644Ybrr7/eQWCNEUdGiTKAJhH9gw46yMwRO86U
bzjJGD4v8mXI6MrWb3agq3ItFCREUaJVnJRoFFEWaAXIoWIqy1SjQEf3mCeJ
zjnnHAZfcsklggUCULfccsuvf/3r22677Te/+c1vf/tbr7fffvutt97qILDG
iCa7sFfQSQxuS1upZwkksSKhDHJye6H8zRGm11k7BxBOr8u++EVRruJHIMWP
EzVH1FHK4Q2dpmqMCF4GPDGQSxiJfMIGGwzw/O53v7vjjjvuuuuuLL/nnnuy
/rvvvvvOO+/8wx/+4KjTv/rVr4SXYbzi+1KWGqkOeGoNOmxJJJUfEkXSCML/
gLAewKhq+B6iwnl0ixeRhUQTM9yR/TRAbTryyCOlHW5yP/OIh4AICzIKFAjg
3HfffQ888MBDDz2U5Q8//HDW/8c//vHBBx90yAlQhZUnGIax3IPhygau4oZM
VGZkBPIwgjWhMENHWF6TWy5RmEo5SXHEUB8SMSSbKMqt+CNN1DZ0QirCIvvw
U+pBKMUwU3jYDwVEjzzyyJ///Oe//e1v+eOPP571e/OXv/zlT3/606OPPgqp
8Ioz08RS/MkOf5lTPqIJtcFV/qUDBAG5/jeMoTP15jEklHxVUVRidVmiSD+V
pyCpHKR+RJ4YSkBqKYSYJzQA3n///dCB89hjjz3xxBNPP/10/uyzz2btzzzz
zFNPPfXkk09CDKmYFteas06xJ01CSYSFEllpDrLKDPlICmDUBDapFC2Lx7hS
5GK9rEcQo6aHkEoG7RFxC53R6Vqdn9E0spBWEMZrr71WBAEUGgESJiGDBajn
n3/+xRdf/Oc///n3v//dmxdeeMGRuGjQDSRGe8tBZjEXr5laUUQXS1JwXiap
FHDJES5f5WLQVC6G1EQvJstDSa2isRRCLViEkJe1V8FRrhcACoOgFTzBgw0Y
qF566aV//etf//nPf/7973+XuHohFEsuMFK8g6xUWE9gTtl46KGHcqXEsLRm
kDEBcFAnHQjTK+9dAwinV9uCupgGSdUKJFUJBVCRxxfZz60CqBOOAGpGZI8c
EgCyQWGCnkxHTOGCDapXX301Itb/2muvvfLKK7D+4x//QFsExmRh9M2QHd6S
jPhvDYJD3SQIN+s6FsfSZghbanufqmJUzQw9xVL9tC0CllZSo9Zbl5iqFcSd
xEucegwxjsIwGz8FqtgnZ+Pffvvtd955x+tbb7315ptvvv7660IKvyALNbWV
uQolNxnOa9gBoBgCSMcBFENWFVfVlxDhpKYIOUuVxfxKTGU77bZeCA1Bt9mh
eiq9xFHQJCGV+f3vfy+GFCQi1ipWggYTfPn777+fLf3ee++9++67Pr7xxhvO
CjEei6Rygt+6g0CpdJidYOOMHgpT9YwMQrBiUz40lOW9vgLlMhXKSm1Un1Cb
QGn2yMWQU7moYbO8LYOKyOeyR7HQkjGxxDY8OCpS4iVwUAH40Ucfffjhh1n+
wQcfZGN9Bh1loTQUSimpM1BOuQstzCOWltFCYQ8a8bbsYVyznfpnoyxj2V81
N3VBjaoYchMVQ4GKtkZJxCOKoNFWLtTDEtk0JgqHUiDJpJowRQSB+vjjj//7
3/9+8skn3sDqCOgy9OWXXxZHX5G/FUITEmlToguEREBhlDG8Xlz6SnDki0fX
k6CLAAY6bSml1nTLhrrUaGnKDButH1HKlAi2sTCgKQtiE9CECqKsFbKsTwQd
QlzBlaRykDtkLpExkapKRxHDzLIBYTBHwSJ8ZH4JUXVVyQdVtGv1mEWvVglo
ZNWYKPCqgx6NQYofkb/33nshw7HnnnsuQSZQWWsBr0/2iVcgM47SUiMNqgYc
u6mxeZUfxIhrY7SNdioPxWauKbL6/dfegXwblUhK7CKgiu2foiNWUa2qQAFF
LoGyl9NUh5hoyKRMBQrRKlBZawFrLAb6LAWxVDmUlH/961/VBLHWoBEmxLaZ
sIAul5JYVCJE+1nk2BKgGl7cGG5trTYP1d5IrBoVCv8iu8DS1lew9NMBqx6r
KOOMZnpoiPC0FvJRxAnQyCvQjYy8Ij4mkVd0115EJZfGVrS4cssUzm52B+oz
ELVHp1m10qS/xDG+UsSQi1122UX+RvNVlwtdRdWaKFM8H2WN3lWYsrzQfuqY
9fnkmJJODA3UZOtnuCPYZzOsKcA+yqvbwz7tA2sUo+KC1uei6htA1RL3swsg
ZRc7sdoAVfs75axquuxd+bEu9JpmuwIVV2ZEOSMYESrxiJqWQ5KNVcT8L9cc
d9aYSCkFm1hEqEigVsASlciTQE1g2WAPCVUZkymRULGrI+3VZiBaEDvWaEHs
QDA92sikQFfkI2dipUsUq+ghs1ZhycaCIc0ouTyCxDikE1+ppEXWy4iQwl9F
aPbs2ZogihW3ywfhGTYIz5gBPNPiVORU9JB1VacUlarTvzlz5oSqV1lFqdgT
ezjmRQNJL9gc7VW0/zl82VhVzP9wkX2nDBCkgIZ8aMxH0lRfynHipPvXuNqC
xE58kH6n98kGcC66Dxi4n1OycipNrDYDWuXosWKvU3UfQUo5HaSM3aoQyg36
QeulGw3Ay9iqxj6VPgKVi2fWF3s4guGUlFS1YPQtGBWu4KKGA0UkNcfKMb16
KPySoyw6lOqO25QqnFU5w1M7nvp+AE9jQ6dV1sFGOGmK3WXsB2JDJyp6CDix
lZoXFxtyeZhDlfUqCQ5A56RMM1BfFjscAHlM982BVuBP/KFmpLF4xCO9+pV2
WIMRLtWI4+gBhLFr5a3Y8dRb5SSMVascGzr8ij15/aqRfIQAE8Uzy4lN1ucd
XAIXV40krZaYJNXRkWKzU2bupGikjaeLp3kSPOmVh8H4Bu47di8aQQlZj6A0
iAhGQ7LllltWCRnXVYhCQNS4MxRZ47qfOEIpQpBkLYpy1uMdaQWLxhqkh1Ed
cdz3UcF0kNGxuL5ABmJj83lP/TSQffrU2sLa86ATi4dGBvp/ChqXU6Im0C95
Htf8qk1cHZeEUfCQUxLq2fGT1SiaU50c8bIeb0AVUycoLRIbjdAqtIJJLHff
fXeMV0u5jx85tHhII0GQIgxEBaBxNQwV98hSdB917sVl2cEY6GVclsVAMESI
25naAk02RrTiPoFT4ieKWOZbqGv1uIAetz2UG3WnyKQ0c5pbXz+yTPEyITJo
sN7XL4nUUcTF5fnz5/NkAIn7N7DEzZuspbh70+2d7NCYwylilDMukPu+dkyT
Lrz6zgCA182eMRnmY2H3olVr38azi9kyle3V/ipSo7qpUdkuO8irsM+bN6+6
WcN8BQYC3tWS5oBk3d746KBTCxYsIPqM9i3fjSvCcWGfe8LxaYVtH2R3ekWq
fGp5fJEbiwpz/Yop22WAkhe3OeOiadwT5H0iHXdrgZCiWU6Bsi7v7B6dcNog
dBMuHbbv63G0JORCeUNSBS+eS03u/C1qd1kpHSl5Mm4wT0wUBTMuu8Sd2bg3
FrcxeRxXWR13zE1FfnOmZcVzcg6qqwagg2QUJKGq7lLyBJdYqyexs3WQnemT
PGV29ifZWb9gix5xHUUCxc1kSmB98s3qnXbaieGMyosNXqc3Sgc3yrmtt95a
hTZebETIJGYTNvGzUO/nWprmZMmEaVWJrt/25tm4w5M8IlI968IQjo6nWryH
wHHc1AGKhK/Egy0SgjDxY3+ydssg6waeaC5zq6veHVX3QlkVzzzFQx/VA09Z
zpUtKJaNjIebHNYtIgY6CyUfsSJu8kV8kh57UUtSLSsZ2FlZVL+REo+OyXlY
rRWPuuUWzkZ6Ew+4sZfVhsXjYdDwR2HJhMVY8unT4+WoUcXhYcOqTXT1BFv1
hCCMrRbIlooHFx0HWaY0nigqf6HRVq+GhY7FSuleatzAitXYqs+pHuqKZz9z
1C6el81a4xFZp3Gp/H3BIs+LxzqpVqW/tlj7M77XtbD5rzPWqX3+FM2YZFT6
C5CBX6nE6IFfC6Sj1lskFunZdI3CkpZq9NjGnOmo4jcGrY09QDYIfeqd1RbW
n15LWZvWq5UWxm974inxgV9jpKNmNOaMXxyk/Es7kKmNOeM3GxMbc6ajJjbm
LLMkS3+30kwdi9Hxi6ApjTnTUb2NlWNTuGxyNq1oXY05VyhHT0vONtvFFKNX
KUcP/N4mHdXesKD8FUnptzrTWhtzlIzNlvdaPKle/nJDx/z/VxGD1A==\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Black", ",", 
     RowBox[{"Specularity", "[", 
      RowBox[{"White", ",", "5"}], "]"}], ",", 
     RowBox[{"Sphere", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Lighting", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"\"\<Point\>\"", ",", "Orange", ",", 
       RowBox[{"Scaled", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "2", ",", "2"}], "}"}], "]"}]}], "}"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->282128780],

Cell[BoxData[
 Graphics3DBox[
  {GrayLevel[0], Specularity[
    GrayLevel[1], 5], SphereBox[{0, 0, 0}]},
  Lighting->{{"Point", 
     RGBColor[1, 0.5, 0], 
     Scaled[{2, 2, 2}]}}]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[3]=",
 CellID->28886346,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->277160744],

Cell[TextData[{
 "Specify ",
 Cell[BoxData[
  ButtonBox["Lighting",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Lighting"]], "InlineFormula"],
 " to use different colors for diffuse and specular surfaces:"
}], "ExampleText",
 CellID->10874751],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"White", ",", 
     RowBox[{"Specularity", "[", 
      RowBox[{"White", ",", "10"}], "]"}], ",", 
     RowBox[{"Sphere", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Lighting", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"\"\<Point\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"Yellow", ",", 
         RowBox[{"Specularity", "[", "Cyan", "]"}]}], "}"}], ",", 
       RowBox[{"Scaled", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "2", ",", "2"}], "}"}], "]"}]}], "}"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18850506],

Cell[BoxData[
 Graphics3DBox[
  {GrayLevel[1], Specularity[
    GrayLevel[1], 10], SphereBox[{0, 0, 0}]},
  Lighting->{{"Point", {
      RGBColor[1, 1, 0], 
      Specularity[
       RGBColor[0, 1, 1]]}, 
     Scaled[{2, 2, 2}]}}]], "Output",
 ImageSize->{154, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->339773786,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->165571895],

Cell["Specular colors are mixed with surface colors:", "ExampleText",
 CellID->126206124],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Darker", "[", 
      RowBox[{"Red", ",", ".6"}], "]"}], ",", 
     RowBox[{"Specularity", "[", 
      RowBox[{"Blue", ",", "10"}], "]"}], ",", 
     RowBox[{"Sphere", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->218837766],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[0.4, 0., 0.], Specularity[
    RGBColor[0, 0, 1], 10], SphereBox[{0, 0, 0}]},
  Lighting->"Neutral"]], "Output",
 ImageSize->{154, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->70376847,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJydvYd7G8eZ+P8hAPYqUhIpUaIK1XvvvfdCUqLYewdBovdCNDqJ7dhJ7Dj2
OU7sxHHixJdc4jhOveRK7i7lvv+Qn99vZnYBgQtQkU7PiMRih4t5P/u2aYu7
Q67Jsdkh19TI0MbrjqH5yakR58Zrcw7xlrkIeFP8/6AJ8fr/E6/U/ze/+OIL
GBY/zWNjYwfV0aD4aRJHJnkk3/5C/WO/Otuvn7Xovw+od3v0K5Tk/I34qf9N
l163vODZTv1spTyyZD9PvNinznfo166WR8XZ8/o19qo6bfo16p5R575+nXqD
XEY5d6nad/Urrnqu2rf12o2Gs2bD8U5V+4bekjWGsxbD8Q5V+5p+7XXPVfuK
XrvFcLbYcLxd1b6ot2TTP7i2Vvu8fu0t/+Da21TtM/q1txnOlhiOt6rap/Rr
73yu2if02rsNZ0sNx6qlHNVbsve5ah/+Ikezc86WGY5bVe2Deu1DhrPlhuPN
qvY+vSVHnqv2Hv3axw1nKwzH6u4p3ZJvnjScrTQcb1S1t+vXPvNctbfqtc8Z
zlYZjjeo2pv1llx4rtob9WtfNpytNhwrjVY/Ze2rhrM1huP1qnaz3pLrz1V7
jX7t2/+gtrJEVuvXvvtctVfq135gOFtrOG5Wtev12m2Gs3WG47Wqdq3eko7n
ql2tX7vTcHaF4XhNtnbuu48Nx0Zv2qT+KvdOSw9s/Kxn/NWSCHBMvlPcCluE
DsI2obcibJl2iB+WnbArU0p2k0eywXDc+PQz8iKEsvXSTUJ14VmftlsV0x4w
7xVv7hO/94uzZvFC/xSjJT+jFf8oqlRo7clvkmiQaI5pl/xk0Zw9qmASLTKJ
hphEiywHBJOD8rx4sV81Ls+TrjQcry7YMmME257TstYXaJmCtT9TTKJZZtE+
yyHx/7A4PoT2xjKfaozCqwq21Ri1pIc2iaaaNsvPz22qSd5Ys9Za2VjTbllD
tHWvKjrFTCtNeistR+RfHYUjqmCSP4rFiQOZhktdMuYAWluNftV4N6QXNIu2
Up693/lgNbKWLFn9jislPKBKtr2mw1r7ikVzS4/Jv9LarTWyqZAu5LXRGB9b
nr+NxbszDdRwZnmaDO0ziWaZRPssx0U7T0gBxAtxLEk+XyuNcVl6UEvmrpuz
d/2Z93xf9p4r0zmoit5Kc04rTaJxJtFK80nR2lOy9knVVPG2qGG88w0F22v0
ENLPFkuqxbmWnvU8Jbme5+k9V201Z9uqWZBU0iOqKYb2mkQzTaK95tPigmfk
Z51W7RY/xRlRKa/t9QXbbsw8VuttV6zLCjqDXTrp4lzSsvG52kBJbsuPqSbl
ttskGmoS7TafFVXPyfqiDeK1KOLMKVXf6CMKS2A8XqnrtFlIYBICUFpQhGfI
gEXTFVEOZ3xCVghRpFJLOTCfUq09jSYLFtH6c5liPi+EuqBLJl6fV++eUcIZ
JVtRUDKjN6x/EclKspJpriRzX4oPZ7ydJpLSKIpPKL05pUpGHpMQxyTabBJN
NwtJzBdFxUvyc0WbxO+LqlzIyJUnlcpW8jTMmE3V5Vi3kqqioFRLbIWyrFDa
TcqKo6Qp0aQ5mZFGlwXzOXUbzqPkKTJdFP8vUYRZCHNZFUzih+WK/ATRQvH7
inr7Uo6kxihbWEpj7lJjlLLu2VLm3rccPSzN6uGJHPk07TNr2ielM+VIJyQy
ma5gwnwV01WKrkqB5Y/iq6IrminSO1uuogmvSXw+X9bagrIas9KqjP+reUZK
YZBU2V11/v00SHpGeQilldLAioScQky0uygEvUJWVNM1zKbrmC3XxRvFNzDd
oEiU67qs4reogawqb7K4vXmZXWFpjVl1Ra7H3JQv67Pv6rMFVbdTCnkBcTuF
lPJmShHNst3ma7JYEFJahHQW803x+6aQ+JY8fwvTLYqUrDeR0qOEFjJfVbfX
KG1NQWmNeb2MzSXy3rYasth8Ff6/SSpupybmZcxXpJQWeZ8smIWQN+R9LEbI
WCJkKzHfFr/vUGy5I+S+I2SWvYDbmG5TpAqSgKwt7vINJfnlAne5uqDcxlol
Gbl3GmK6Qe78O/xCQl+RJiqFviZvlpT2piwlt2QplaKVCknLzHfF/3vi9T1B
4J5AIg5kN+uegGC6K1TEcpeiOyDKbY0CQjm4rlQ9755qBIxZjNGbWzIENj3j
zufr+HK3PeusMuIXZcW/JqW4Lu+5Jr8QXklOyR1KhfR3ZSm/J0uF+T4VWB5Q
8YByrZgeUIblIaUPVOR9IHTjvrig5T6ClCjcFUTuSGsQaASZG0otjEyqCjJZ
bTg26bYvIzLbW3MMXyOSb/X5hlBQITLaoFt5RvdLblIq9OA2ZXdkKRcYpEgV
UrqK+1Q+UMX0kCpTG1WWNiopbaOinYo2FdDaKGmj+KG0qYeCSdkDBJsiwUTD
ckcBufm8NFSG+bR3b4xwrVuWh5HvFZbXDc3t6c5AI3FTJ1F2m/I7ksFdyeAe
lfepEuUB1UK+GsGgBks7Ne3UitJBjaVDnHlEFXUdVMrxFco6KO2gpJ3idgQv
80NJpugB3M9AuV2QSGVBIrn9G2kq5lweu5fjke8ls7aSqxkXZJTKGormJIqv
62pRklELoRMVd6m8J0FUCxCCw0Nq22Spw9TOCswdrOig/hH1mOSPxseseEyd
KrWdstR0Ui2EeEzlY8ofU/aI0keUdCDwmdsRWIsegsZI05obBbxKRUFCsm+0
hMqOLctYzTPcaNZkcj3IZYoy7uOpligqms+Q3kJpiKAikZgkEHHXV7RT30HD
I1lWYnrMKnMnq2jsZOUTWRpUqe+SpU4I8oTqJ1Q9obKTik6Jp+QxxY8kVUG3
qA00NvcUmBegYsqlsr9gEmFQl1xHcrIQlUtPqchM6IbMBKQ3zUVyXxmNpiht
0k7q2nX1kDwEjcesxtRJo+kJTeYummjsorFbltWqrOqmQUjSTV03Nd1Ud1PV
RWUX5U8o7aT4MZbHmB9R1A5tGa2RsVlmV9J5aJZk7PPnETn0QkQKepOLMu+R
RK7KlMK8VEl007mn49CMRrCob6ehg5WPFIjHUi2aOlnzRJa1Xaw1d9Ns7qGZ
xh7W9sqyRpVGIUovDb3U91LXS20P1T1UdlPeRWkXxU+wdCoqHYrKQ6Uvkoqk
ITEYx8vKl6WknIw2qqiTKtityHe9Bt3J9zPZaJxRnHxMmtbUtUlMKztY9Ugx
eqwzan7Cui7Wd9HSTYuphw2mXjZKRhv6aMmU9f2yrOunWcjVT2Mfq/po6KO+
j7o+qnup7KG8h9JuSrqwPJEWWvQI2jPUyr7In6lcnliTrlccze2bFOyFZcP2
M3Cdf4orm7xYcuxMw5X1xk+1SqmUYNX0mLWdS0Bt7GZTj7ibglWrqY8tpn71
v5WmATYPsEmUQTYO0CKEGmDtgHy/cYBVA6zsp66f6j4q+yjvpbSHkm5FrDOH
mHBKFp2Y0QstT4wThpHr5wF25JnAstlexgyLb6v8LuOVNOXSaK1Q/lkH1sla
Rauliw2ClkDVQ2svW3vZ1sd2QWqHeYCdpkHRujWDbB9imypbh9g8xEYh1xDr
hlg7RNMQjYM0DFI3QM0Alf2U91HaS3EPws8VPYHHCtoDbbRdIjGOyBQmpvKi
M/lj/QU7+obMcDliaoRCWmSu48oQK7unZ3+6Obbr7nuV8leap1qnKZfA1csW
gUuw6mNHPzsH2D3AnkH2DrLPMiSatGaYPcPsFmWEXSNsH2GLkG2EjSO0jLBu
mLXDNA7RMETdIDWDVA1Q3k9pH5YeTN0KnKZtd8mfw1memOo/nzT0n/NHRfJh
nSgAqygDS497tzLqdY+y+7KzUJUJd7puCecuPLtyWeuVYm3KkNqmMO3qV5gG
FKYhDgyJVpiHhaY3j3BohIOijMpyYJT9o+wZZaeQbpQto2weZeMo60dZO0Lj
CA3D1A1TM0TVIGUDlPRj6c3B9vC5mam+yPmCM1z5ow6GzkduGpV1+pnYWKRR
uymp6amC6GtlqAmLXJHrvzRHr5RrUzdbeqQhCs3aKXj1s3eA/YMcHOTQEIeH
ODLM0RGOjXBihOOjohWmUY6ZxsR9bBrj6DhHxjk4zj4h4zg7xtk2zpZxNo+x
foy1o6wepWGEuhFqhqkYonSQ4n7MfRIenQre3Xx2ilrevIey0LMau4LjcPl9
lWeAu/jUNjVw2RyrPGOYVRnDbFBBUkTINRmvL3Rts6K2o49dfezpZ98ABwSy
QY4McWyYE8OcHOHUCKdHOTMqPlYQOyuk4cw4p0XBNCFa1DjByQmOTXBYiDnB
3gl2T7Bjgm0TbBpn/Thrxlk9JlI16kapHqZ8iJJBLAMyzhRpBAvp3jP4ndEU
b7lBTEOvNzcvy6apmVCQdWxZrSu7kxMH2mQXrk4lpZpL0yNAxp9p8HYrckLZ
Dg9yNEPu9AhnRzg/yoUxLo5xyTwu7pV5gksTXBQF06RoROMk5yY5PcUJIeIU
h6bYP8XeSXZNsnWSjROsm2DNBKvHJb7aUSpHKBumZEjiK+qFLuh4bnarM7r3
jEi6N28MxRAXMgnt07zjukw6ND+XjQgau1rFboVyclo40Nht0uKmcm9ZdkLl
jgt908CNSnCC2pUxro1zfVz084Su3RTMbrBukutTslwTZZrL01yY5qwQc5rj
0xyZ5uA0+6bZOcWWKTZOyfprJlk1wYpx0bmkfJTSEYqHEAGbXqV+Ig82zg08
g+C5zc8Mq/sK9R4NkSI3y9ViqhYm7uoOrzJH9QS+hmyMyKheq4oOwtXtUX5O
ODmhd0LpTil2F0a5lGF3Y4JbE9yZ5N4k981T3DNNC2+1dpo7M7LcnOHajKg9
NjbDmRlOWjk2w6EZ9s6wY5rWaTZMs26KpkkaJqmdoGqcslFKhjEPUiQAdisF
fAF6Ja15o3dq1uhorvLlpnFZw80NsjnoLBl0pdlYkWO1KztZrbKQ9d1s0ExW
5B8iqg7IEJFVu1PKWAW3ywLaGDfHFbQJCe3BJG1TIqkwT9NhnqHdZBX60mTl
vpXbVm4I8Wa5OMu5WU7PcszKQSt7rGy3snmGDTM0T7NqihWT1ExQMU7pKJZh
RI5In1K95yOnRkTlEKhhIEeRO/aMkGFwebmdUK2vkJObVGZsVktMVomet+hs
KnLCYLfkaNw+FSOODXFqOINtVMcmmN2f4OEk7ZM8mqJzmq5puk0z9GCx0m2l
S5RZukyziF79LB02Htq4K0S1cd3GFRsXbJyycWSWA7PsnmXbLJuttMzQNE3D
NLVTVE1SPk7xKKZhigaUChamaOyXKf2TM+O5pqsxPFVwvPTo0iwv6/qWYahp
n8awPtNz1xiuy1jt9j49OxFx9rAKFYLhuREuZQGO6wA7Jumconua3mn6ZxiY
YcjKsJWhWYYEvUGTDdEJm6N/ju45OudoF5LOcWeOm3Ncm+P8HCfmOGxjv41d
Nrba2DhLs5VVM6yYpmaKiklKxzGPUjSkHOGjfI6ly3OUM/QFJ1/ULOmR/UuT
ZYMRZ/3fNT18yC6+NjCUzZEzeihTPa0fIbryyoKFHu5SUeOQCrea+Z4b1Rne
GudeLsAp+qYZnGFkhlEr41YmBb1JNtiYtDExJ8v4HGPzjM4zME/vPF1C1Hna
5rln59Y8V+Y5O8/xeQ7Ns2+OnXO02miZldrbYKV2hsopSicoHsM0grgnMii/
CEk5l57f4XjK8cA/NmnNGZpvZIZKtHESxbE6J3+RPdiMJ9ykPOHOjC4eUeHj
jEpYhA8UEfe2UsT2PIiSoJWZWWbNNuZMc9hM8wjNmsdqZ9rOmJ0hO/1CSAed
Djoc3Hdww84lO6ftHLNz0M6eebbOsXGOZhurZllhpXqasimKJ2R2iaaPL8Kw
eNvS2V1tndix/BmhgrH4cs74iZYDqrEAOWKrddZykxiliBrALSqD2ZMHUETe
G8oVPpiQWvhkip5pacC59Gw27DZcgp/HPI/bZMdFswOng3kHMw4mHIwIIZ30
Ouly0u7krpPrDi44OOngiIP9dnbY2TTP+jma5miYpcZK+TQlU4hUs2hYqeKL
MDy77TnWAuTq4Nmno71yWkAb/Vb+UOu5yTzwofKHmSxGxJSmLpozhqxlgFoc
FoZ8UkWTi6NcVZ5QWHHbJI8npfb1TzOs4E1Zsc4yN4tDwJvDO0cAoX8hwS9E
i52gQxUnASceJw4ns04mhaQuhl30u+h08cDFbRdXnZxzcsLJIQe7HbTaaZln
zTyr5qibpdJK6TSWSYpGYfB5Oao4XdGaseeCHNVamCPZxPrUU1uWM06X9bmm
YmXL+rCU1pHTspoMRy2ZzqY0OzN6eHRoSUTRvGG7UsLeKQanGZ2RGmi1SohO
Gx4bvjmC80TmWbCTsBM3OcR/J3HWO1lwyRJy4XPhdGMTsrqZcDPiptdNh5t7
bm64ueTijIujTvY52eZgo4NmO6vnWWGjapbSGYqnMI3DsEp68lYCazSLC3rH
rXmD7tnVUscP5qWKp5ea9RXdrPV+sdY90UYTtPii6aRiubHbmFYfUTopWIr0
5vrYU4/4RLnD4WkmZpi2YhPaOCtB+ucIzRGdJ24nZWfRwZccvIRg+ZLJJV6s
d7HoliXuJuLG78ElpPVg9TDpYdDDEw8PPdz2cNXNeTcn3BxwsdPJZifrHTTZ
WTFPtY3yWYqnZYeIUZX+vAjPc9uWV03DRODJHNXMzbkzKY/WV9FHZpbG6hY1
tKAF6myyc0LZ9yXFUqQ5WefYp4xbsBRKaZ/FLUDaMiDnSdslxa84eFVw/KrZ
xau0uHnVzSseXvaw6CHhIeol6MUjZPVi9TLqpddLh5d7Xm54uOThpIfDbva4
2eKixckaB/V2auapsFEyg2kKxlVKbrTzkuVJlm1bZu1B1sJz80ellUWZYGPK
amUm6xEWro/TZAebM2mjSL1zw8xx1UW+oNzkLaWSAmNXFqNVxyj0MSgYzkmG
Qhm/ZOdlB1918jUnbwhtfMPs5hu0ePiGh697ec3Ly14WvSR8RH0Ehaw+5n1M
+hj00eWjzccdL1e8nPZyxMNeD9vdbHSx1kmDgxo7FXOUzMpeEhMq9LwAyXPb
l1mzcKjQAE6uQqr8URuQ1sZtKjPGLRLw7IhNtu8nFVJ1Xw5nMGrR+maOlxQY
R5SLnJ19ijEmGM7zksbQoRi6+JaLd0xu3mGTh3c8vC2KV5Zv+XjDx+s+Xvbx
kp+kn6gQ2I/Tj9WPeNHn55Gf+z6u+zjn46iX/V52eNjsptnFKie1DirnKbEh
OpxFkyoAvQjP8zuWXxSUP6KTmwOpHnXJrczs0f3M8GHGuvUhnNz0UY0+HFM5
uJY75sLsz4HpnMWr7HpBGfVX7Lzq4HVB0slbgqSL99y87+F9TB6+a/LyHVp8
fMfHez7e9vOmn9f9vOznpQBJIW8ATwBbgIkAgwG6ArT5uenngo/jPg742OWl
1cM6N6td1DqptFM6J7ugEufwi9HcucwCo8OFBmbPLw3jN/V0UuTjVQ8yA/+Z
XFJLxjdmEkktETqW6c5cVlmkhrIrD6XPRljZ9qJQSjuvO/iGk286edvFt918
1833PPzAw4cIkh+afOJFqZ8P/XzPz3sB3gnwZoDXA7yC3L/DqiD+IPYg00FG
gvQG6QhwO8AlPyf9HPKz20erl3UeGt3UuahyUDqPxUbRlApCL8rzGev0DION
uenlDb2fKOeBc1SzXg2PSdXM9rLVAM/TbCjTp7mjUkqDXjoUzMgcCWXhr9j5
mkMn+a6L77j5wC1J/sjLj718jGD5sckvXpgDfBzgowDfU0uRaAzySoiUeBnC
FcIaQrzoD/IoyN0gVwOcDnA4wB4/W3ys89Lood5NlZNSO5Y5ioTnHFuWpHE/
irYCameOkcv175zIJ5mTERnUUpvxzA771GtqmZkaaM10tDUL14K3nghNyFGx
x1NyaGI4B6NX6aSGUdj21x285VQMXZLhhx5+6JEM/9nHzwTFnwqKP2VDgJ+O
Zf4F+SDEeyHeDvFmiNdDvKRoekPMhZgMMRTicYi7Ia4GORvkaIC9frb6Weej
0Uu9J4fmzAvTPLdr+WVRxwokRAalzHZ4tGxoZUYpteGzbdm+9hBHlYUbAni3
Ss7HVRLkyDHvLMpvOfm2i/fdfN+d4ejlX3x86uOXguSnUhxagvwiyD+H+FGI
D0O8H+bdMN8K8/UwXwmTEFXC2MNMhxkO8yTMvRDXQpwLcSzIvoBEud5Po0+h
dFHmwDJPkVWZuHGOoXh5kmd3PXMZbu6AWm7kWaqUNQ/ldJ82l6wllRuyI2gq
O9di+Fk11i0c5d0c2x5Vefm8it6hjJd8JaORAuP33Hzk5mMPn3j5mVcy/JWf
3yhB2BTk10E+D8nyqxA/D/NJmB+G+X6Y70b4pwjfiPByhFSEsKgeYTbCSIQu
ATPMtbCCGWJfkG0BWjSYXqrclDkzMIcLzNg8g+bJLM3llDIn8uhJ0Q2dZpny
lJXKU67QJgBzE8ts2MkopYjgV9XYt2bfPRn7Fl0cl42ASoS02P268pH/pDRS
oPyxR6mj5gktAf41wB+CqphC/J6WML8J88swP4vw4wgfRfhehG9HeSPKK1FS
USJRvOJPo4xG6I5wP8L1COfDEuXeENuCtARo9LPCS6WHMpdEyawaKXoBksd2
KJLLKeXS9NJ05WmWXmrILTNK2ZzJhbb1ZxLLYTnFfCYnendMySHwgRnG1NCF
Q/W3RWc7aefLdl5zyPznHRVnPhQYlQZafHzu53d+SfFPpqD4HxL/w/wb68P8
IcKvI3wa4adRPo7ygyjvRXlTcUzHiMbwxlQ3PUpPlIdRxTHC0TB7QmwNSQ8h
Ofokx1IXZrvimLeTojBFtSLnUL6HzJ8jvKCPkmftOpsDaeNBAmE2Zm/opVXT
xEGpiXouOSY18bYaye3MdG4m1aiFJxNmvqR8o8h7RCb+niJX4eXnXn7p49cZ
fv8e5D+C/HtIlv8QDP+Dlgj/HuFfI/w2yq+i/DzKJzF+FOO7Md6K8dUYiwqj
L8asuGSMnhhtUW5EFcYIu8Ns0TAGJEbxiaXuDMbCFI0r6tTauf37ls505c9S
ny/gHcuymY8a1pUTg9rslpaRq0U1+sDFiO4aRdpzb1JqYbcawR3PaKFfGbPu
FzXPV6Eii3CJv/DxmcYwoDP8c5D/Elr4Z0Hwz2yI8OcI/xHlX6MKYoxfxPhZ
jI8XeH+Bby3w2gKLC8QW8C5gXVADmTEexrgR41xUQYywJcz6EKuD1PklxBI3
JgdYl9XFghR351PMX5eT8YpPe9z3nk4TrlBzhNKWVSdRKOI2teDmgFJE2dEe
W+IS+2YYsTI1y5wNzxxhzeNVqjznfZUo/kSF5V/5+I2f3wf4o8YPQe8vtIb5
nzD/HVElKoukGOO3MUVxgZ8t8CNF8e0FXo/zUpyFBTyK4tCCmplY4JqgGONI
lF0RecF1IVYGqQ1Q7qNYozjzYhR37H3m4rlzT2dd9YQnM1WtUaxVKfjKzsxk
odafUUu7hDkfzyjiDTUN3ZbrDpXW1amQ8ooy5LeVI/y+h4+9/FQZsoD4B+EF
A9KK/0sgDPF3oYN/M0X4Kxuj/DXKX2L8Z4w/CogL/GqBTxf4aZyP4nwnzrfi
EuKX48TieOLMxBmM07nAfcXxdIzDMXZF2RxhbZiGIDUZiEUC4vQLMdy6Z+lM
TcElJ5eeukR9tYQKztUZY16lTbhqYxXaJPUQh1RIOTfG5XFuTnB/kkfT9GgW
W69GwYNq6PYlNbzzpot/Uv2/D1WOKDTxMz+/VRD/Lch/BvnvkKAX5n+l1P8v
wv9G+bsoMf4a488L/GmB3y3weZxP43wS5wdx3ovzzQSvJXgpQTSBO8F0nIE4
j+PcXVArBxY4GGNnlE0R1oSpD1EdoMyHRWC0569DtxRkqJ4nsenA8guecmde
NYDavPUDld1k7Fh4wzXdCqBmx4PsH+LwCCdHZUC5MsEtjdsaZcXTs8zP4Zkn
rAa+v6yGI76pOtAfePjIy098/FylhtIPBhXAkDTgvwl+Ef6u6P0vppj40bLA
XxcUwTi/i+sEf5Lg+wneTfBmglcTpBIEEzgSTCXoT/Aozq248C+S4P4Ftsek
Y20KsyJEVYBSH2Y3zL8QwZaCBJfasFxlpy2b0GatBUHhCTt0go1drO2mpVcR
HJAEDwxzZIRTitvaSR5O0zlDv5WxWaw2HHP45onaSTl42cnXXHzLzXc8fN/L
D7184uMXfj4P8PsgfxQARQRRHvDvit7fTELz2Bjj7wuy/PcC/xmX/H6f4PME
P0/wcYIPEryT4BtJXk4ST+JLMpdkPEFfgvYEN+Kci3NUIdwSY32U1RHqQlQE
KBH8XDC3HD/jczLU01LW7s+bbF2enz4EnuX3WG7aEPyaexS/frar2LBujIvj
XJ/g7hRt0zyZYcDK+CyzwnbnCdiJOVh08qqLb7h5R42BfejlY9FBFr26AL9W
mfQfVQIj4WXJ/Y1NMf62IMtfhObF+bc4f0jwmwSfJfhZkh8leT/J20m+luRL
SaJJ3EmsSUaSdCV5kOBagtNxDsXZpeJzc5RVEWpClAco9slZC2wF9pEUpqee
TLN6uRVj2jLiDDqzFj7uU/GQqvYcdHJHgyS2eVD6vYMjHBvl9JhcLnd9kntT
dMzI5SODs0zYsM3hnidkJ+7gS05ec/Gmm3c9fODlIx8/8fMvfn4Z4DeiByKS
Z5H7hfmvCH8R6KKyCG/3V5MwWWm3/xXn3+P8a4LfJviV0LskP07yYZL3kryV
4rUU6RShJI4kU0kGkjxKcifJ5QQnExyIs2OBDSrfbohQHaI0gMWrAohxJ+cz
yDUcXEpu6epYSe663E5quU3xXUqz5B7JTVWS2FW1s2HzADsEumG5Lvi4WqUp
0N0Q6KYluh61dmTSxtw8HjthBwknX3bxmptvepaiC/BZMINOpMwRhS7LLSb1
7S9x/ieu7DXB7xL8Oskvk/xzko+SfDfFOym+keLlFIkU/hRzKcZS9CZ5mORG
kvNJjiXYF2frAutjrFbd6KoQJQHMHrAX2Cv7DHZ1B5cd8JLsrhrZlStirZ2s
7KKpm3UCXT+tA3LB/h6BblSiOzvOpUluTEl0jwS6WYbUYhHbPG41yRx38pKL
r7p5w8M7Xt73ybHVj/38NMCnavDgt6KnFuZPEf4TYav/LWLE/7BpQTITRWjc
vyWUsSb5LKkb6wcp3k3xZoqvplhMEUnhSTGTYjjFkxR3k1xJcjrJoQS742xe
YO0CK6PUqBGyYj8mt5Y9Px+59fJHZcEJfbWoWMemZbfb26hU2lbXSUOX3HDU
3MtGAW1Qh3ZQQTszwUUN2gwdVrpnGbTJtTWz8zjtBBwsOFl08Yqbr6upku/4
+L6fHwb4JMjPg3wW4tdhfhuRPdw/RSW3mOixiZjABqVogpi00SS/SvKLJD9J
8WGK91LSRr+W4stpFtL40synmUjTn6Ijxc0UF5IcT7IvwfYEG+M0xaiPUqWg
iW42rgJPjzAvT6zMQCy7vUvp1J6b0rcV36PkAWWCWQc1j3Vmq3tY26cUTTHb
rVbtHxvntGJ2bZq7M7SrpXEDNrkYacaOw4HPSdRFyi0nOr/m5S0f3/bzgZ8f
BPhxkJ+F+DTMZ2E+V33ZP0T5k8iDBbE/Skn/pFyaZpqfKWL/nOKHKd4X1pnm
G2leTpNME0zjTDOdZihNV5r7Ka6mOJPkcJJdCVoTrIuzOkZtlIqw2tbsVTlJ
YWbql/am9rQ3+ZijLCzF6EBGt4oULEsGVkUH1QLWEx3Wmj7WD8hAsG1YbgU5
oFbpn5rgwhRXp7k9Q5uVJza5+G1UwbI78DqJuEi6+bJHTme+6eNdP98N8GGQ
H6kx0Z+H5bDJZxE+j8oO1+9jMtX9nUnka7Rk4uYvlDV+kuIjRerdNG+m+Wqa
xTSRNJ40s2lG0/SkaU9zK83FFCdS7E+yLcGGBGsWaIhRHaUsJEfB5EMQjDu3
lyF19Ih6PIT2L8fxZ2GZlsKqekztE+q7WdVLk4K1aZCtCta+Mbmf4dQk56e4
Ms2tGR7O0mmjT8GatssVRh4XIbecOf+Sl6+q+cp3/HwnwPeC/DDET8L8LMzP
I3wa5bMon8f4NUKvPmeTymxFkPxUpRifJPk4xQ9SyuWneSPNa2m+ZLDENI/S
3E1zJc2ZFEdS7E7qerVqgboYFRFKQpj94NCekPGPdUvaovJMh3JXfeQgI4PM
nEFW3iH3FNc8YUU3KxWy5gE2KmQ7R9krLjXOiUnOCWQz3LRyf5bHNnrnGLYz
6cDmxOUi4CbqIeXlKz45G/mmmkh7T81afBTm4wg/UcNy/yI816fS23+qegG/
SPAvCRkbRVoh1Or7ymu9rWzw1TQvKVyBRZyLTC9KM3wizDDN9TTn0hwTypVi
W1IqV1Oc+gWqY5SFsQQp8pDvpYzZWj472U+QFVRcOHx0Kb+M75cPbMjwK34g
t/Jr/KqfyM22gl9jn9wA2DJE6zA7FL+DExyb5MwUl2a4YeXuLO02uuYZsDPq
YNrJvAuPm5CHmJe0T07lfi3Am0HeDvLtEB+E+X5Ejmb+MMqPY/xE6tsnwjY/
kbYpwP1QpWTCJL+tPP7X07yirDKWxr+IY5GZRUYX6VmkLc1NYZhpaZgHU+xK
sTlJc4KVcWoXqIhKbTMJbXP+X+g16vTUCuMDx58u7TCgK1LoLA/kYw/KOqh4
LDdu13bLfbmr+1gzwPohNg2zbZTdwidOcHSSU9Ocn+GKlVuz3J/j0Tw9doYc
jDuxunC48XkIe4n7WPTzSoDXg7wRkpM774Z5L8J3o3wg9O5Dwe1DGTF/kOBD
0X0S6VhSMhMZ2TdTvK7cfjpNVFjoInalciOL9C7SscidRS6nOZ3msDDSFFuS
kn1jnBULVMUojSit85I/Lmx8Mk0+t5U6N7Xn+sDRJWsPDNxMiltxm3w8Qvlj
Kp/Izd0relnZJzecrhtiw7Dc3bZzTG41OjQpN32cmeGilWs2ufr54Tyddvoc
jDiZdGFz4/Li9xLxkVCrB14J8lpIzoi9FeFbEd6J8q7g9p601/fUcMd7qsv+
jsj+kzIdE8nFq8qrpVQM8KYltqlFhpW2CWx3F7ma5myao2n2CmNNsSHJmgQN
cWpilEcpDiuFk3mtcUbcSM6UR65O93VqnuPAiacTZ7nYuE3RXcz35ZMkSjoo
U9iqu+UG8Po+Vg/IXactw2waZduY3J61f1JulDk5wzkrl23cmOPePO12uhwM
uBh1M+1h3ovbR8BPNEAywEtBvhLiq2G+pmbA3ojyZoy3hLa9JbXtLTVK9EaC
ryd5LckrKb6UksCEeYZU3Jxfykyo2tVF6eCOp9mfZkeKTUnWJlmVoG6BSmGk
EcxBkD7OuBvCOCqXYfb0nWpd29RTpPafyvSk8oDJ57M8lI9iKH1Eead8fEBt
Dyv6WDkg9+g2D7NhlNYxuZlt76TcVnRshtNWuUPh6hy353lg57GTHheDbsY8
zHjliimXH1+AcJBYkGSIxTBfifBylFejcm7hNenXXqMlLkfUXk3IUY0vJ1lM
kkwRS0lWQr8caawidopgsEj3Iu0aLqViAteBNDuFT0vRnGR1ghVxZZxRLCGK
fPlPeDDOj+XTqtBpqTmy+5qGXdD7TjqtW3L7dtE9ScvSTskjyjqp6JJPFqjt
o36AVUNy8+76UTaNsXWCnZNyB9bhGU5YOWvj0hzX57lt54GTRy663Qx45Bq9
KR+zfuwBPGr5SShENEw8QlJNCS7G5CSCKC/FWVSDZ0k1BBRNEUzhTcm81ZZm
Ks1Imj4RNoXrX+T2okw0BKljGVKtKdZnSS1k7DGg0o3/A61SnZYaL9qn9QG0
tOOaehxJBpXpAeY2+XyO0k757IXKHmr65IbvhkFWD8tdpRvG2DzBtkl2T3Ng
hiNWTto4O8elea7ZueXkvksusO3y0OdlxMe4n+kANrVMxxnCGyYQIRglHCUS
IyL0KsL6OOEEoQQBNVTmTuFIYUvJ/H4szUCa7jQdKr24qXy9xkkzQMGpJUlT
kvo41YJTTNqgSdigm/wnBBrXVeRzMut+Sz2Zea+WXiyFxD35vBtTm3yCSfFj
+XSK8h4qe6npZ8UgK4flpuXmMTZMsGVS7kbbM8MBK0dscl/L2Xku2rnq4JaL
+27aPXR66fUx6GckwIRayGQNMRfGHsEZxRXFHROSCEpumXq64nIc1p7ElmQm
yaQaoBhM0ZvmcZqHaW6nuZbmggqHwq/vU4g2K1USiBoS1GQQmUPgzV+Dazwu
QGhMf/75zvNLre222lCcQWN5TMkTyrqp6KWqn9pB6odYNSJ3Lq8bZ+MkrVNs
n2G3lf2zHJnjxDxn7Fx0cNXFTTf3PLR5eeyj209fgMEgI2pl0kSYqQjTcnTC
SktMzjCJMhOXw/uTCSYSjCYZSjKQoidFZ0p2eEQWfyPNJaU3J9IcEvEuw2Vd
kkahOglq41RkuEh/ZLSogs8rVm+o5wHvPK1im6YpWRb35R5hU7t8cImlUz6O
Q2pKH9UD1A5RP8KqMZrG5U7PDVNy0+J2q9w6tn+Ow/Mct3PGwQUnV9xc93Db
Kxdetvl5FOBJgO4gvSH6wwxGGJYsRuSI1MiCLMNqumhAjTV3J3mSpCPJgxR3
1cDClRTnU5xKcTTFAZVmbhVBLOuVhYJoIKKYwxSJ8J8X6402la8h6jn8185m
tCPHcIR2FLVh6sDcSXEXJT2U9VE5QPWQ3ORfP8qqcZomaJ6SGzhbrXIb3W4b
++c5ZOeog5NOuV7/gpvLHq55ueXjrp8HAdqCdIR4HKYzQleE7ijdMVm6FngS
pzPOIzXs/jDBvSS3klxPcllxOJ3ieIpDKZkAab5kg4rnmtutjktbKc2iKPiU
r5zjoiVZkOzoqWf57zinYnieYhS1y2ezmJ9Q3C0fo1HWT+Wg3GleO0L9mNz5
2zQp92G2zLB5Vm6E2zkndyDtd3DIyTEXJ92c8XDeyyUfV/1cD3AryO0Qd9WS
ngcRHgi9eEhzjPsLstyNczvOzQTXE1xJcDHJuSQnkxxLSgD7NF1IyoRGGEWT
6HiInEYLPZo6hBSD+QJjdUaN0DgUfG72tnPKSJaqBG3yeSumTvkYkeIe+WSM
sgH5xILqEWrH5P7nlZM0TrF2hvVWuR2wdY5t8+y0s8fBfpdcIX/Uwwkvp32c
83MhwKUgl4NcCXE1zDVTRPin5ijXY3IK+uoClxe4FOdCnHMJTic4keBIkoNJ
9ibZmZSd1takDClrE1INNNdQuUBZjOJILgVjf9/4RESNQuZbQpRNbDmrDGKp
GtBB0WNMTzD3UNwrH3BRNkjFMFWj1IyzYoKGKVZPy727zbO02OTeqS12tjvY
5WSvi/1uDno47OWYjxN+TgU4HeRMiLOmsIjxayNy6cJZUWJy4vjUAicWOB7n
SFyOyO5PsCfBzgRbE2xOyG6T6HA2qT5nnYqmFUr9hdwmES2EVzQ+j9qYh2gy
G/cXqTt/9prxnvOIok5MXVJwSx8lA5QNUT5C5RjV49RNUj/FyhkarayxsW5O
bnTa5KDVyTYXO9zs8rDHyz4fB/wcCnA4yJEgR0McC8ulGqIciXI4yqGYnOc9
sMDeBTkCvTPOtjhb4nJMSKSza+Oyp7gqLrMHERorY3p0tAiLD6oAqc1Q5khj
fK6IJnNp7n3epMmavcPt8tE4RU/kcyPMvVj6KR6kdFhuSa8Yp2pCbmutm6be
yspZGm1yO1ezXW6d2eBkk4tWN1s9bPeyw8cuP7sD7AmyV96SvXLedU9Elt1R
uSRgZ0zOx26N0bogO4YbFlinRtwbF1i5IDvEtapPLJLJUpVPSnUOqFSp+bmk
NN7vbUul1W5rh3oQkJC2B1Mf5gEsQ5SMyD3k5eNUTlI1Rc0MdVa5DGDlHKvm
abTLrS3NLta72eBho5dNPjb7afWzJcCWIFultFtYHZYrRzZH2ByVqyg2RGXU
Ew5uTYzGmBzvbYixIia7r0LIiqjs+2tCyrzZp7qy6w0SGHtpmpxGW1Ya3GwQ
slPtmdWEHJRCFo9QMkbZBOWTVE5TNUPNLLU2VsxRP89KB6udNLpocrPWQ7OX
dXJV9nqa/KwPsD4oy7oQ68I0h6XhronQFGF1VM6XNERZEaUuKgdpRTezPCJl
KwnL3pPIdaVLcmvfI2KUTY7lSpk0uSpztXTtzcLyFPXLnf7mYSwjFI9RMkHp
lNyiWTFD5SxVNmrmqLVT52CFk3oXDW5Welht8rJarhtd7Wd1QJZVQVlWhmgI
UR9mRZi6MDVhqiNURuS4fFlYilAckgM04g5JKTxa/2azQZKSPEmMeaq6Q413
luqgEod+igblrnvzKJYxuVm3ZErukiybkTvSKmxUzlE1L/cGVDupcVEr56Rq
KfVQ66XOJxd6iVIbkKVG0q6W86VVISpClIfkkHlpiJKgFMIckCMmMn3U5dhq
aGVxnhw1X+R8609TjrvINp5BudXdNCIfY2OekJs7i6fl7q+SWUptlM1RNk+5
nQqHXM5V6aLSTaXJQyVmL5U+KkSRrSqXqzPKAnKityRAcUAO9Jv9mfZ6lQIJ
+9hhaLElr8XGcQz1Fw0Zjy7sXu7t61ObqYYQiWnRGEXj8rkx5im5MchipXiW
4jmK5ymxyyfVOuSTap1yWWepW5YSjyzFQp+K5RI7i1dKYvbJLSFyGM+jmupU
QXjXP2ytMXtVrV2lHbfrjirLWa5xHlEr8Cfkjpsi0c2YwWTFPIvZhnkO87xc
M2mWbTbLNptdsphUKXJTJGczsbhU8xxqFcc+w+eb81qY+aYbjWO2pviXBVqo
fUyqtV4zavp0Vj7T2yZ+WOYUF61Y5NCdaLJsh1wta/yGJlNeW4zPLy+kv1Q/
WqKcslGjqlHjmXZNqaZJeJKe+q222I1pT4Y7+ox2aHmV5GH8bGXxlm6lWINK
t9S3KxXnEpM5t3YV47c5GD3Kw2f8bZPeAuPfqO8iWvLtPFp9Y4awwXDcnnP8
9FOMEdf4fWUdeiu02uu+KPytZo+WsDOeNX7G0mtu0I+MteQ3NEkxtfFw4zej
GXNA+V1REqS2e9fIzHgfruvX1p6Q3PpF4W+Nu6zX0r4rwKgJRi09p7dA+3aU
bfo1jbVO6dfUvtXJ6OeMfuKofs31qvZO/ZrGWgf1a2rfVmb8LjbjaNNevbb2
7XB7DGeNvcmdegu079fbq7fAWGurfk3tmwT3G84a87VNeu3DqvaBL/K/lVC+
XKd/svrWtTyvYczum/Rrqu9Ry353nLFWg35NZbN5HsDYV8w86/aqqn3McNY4
/1Wp176pah//ovC3N5boLVDfVkbud8RJm7To11A2rnRFrhpQ3/UFRf8/wL4w
AA==\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19115],

Cell["Specularity may not be apparent in flat-faced surfaces:", "ExampleText",
 CellID->2079054],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Specularity", "[", 
      RowBox[{"Blue", ",", "20"}], "]"}], ",", 
     RowBox[{"Cuboid", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->571040256],

Cell[BoxData[
 Graphics3DBox[
  {Specularity[
    RGBColor[0, 0, 1], 20], CuboidBox[{0, 0, 0}]},
  Lighting->"Neutral"]], "Output",
 ImageSize->{184, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->643546238,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2876],

Cell["Metallic balls:", "ExampleText",
 CellID->438233207],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Specularity", "[", 
        RowBox[{"White", ",", "20"}], "]"}], ",", 
       RowBox[{"RGBColor", "[", 
        RowBox[{"RandomReal", "[", 
         RowBox[{"1", ",", 
          RowBox[{"{", "3", "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"Sphere", "[", 
        RowBox[{
         RowBox[{"RandomReal", "[", 
          RowBox[{"10", ",", 
           RowBox[{"{", "3", "}"}]}], "]"}], ",", 
         RowBox[{"RandomReal", "[", 
          RowBox[{"{", 
           RowBox[{".5", ",", "1"}], "}"}], "]"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"{", "50", "}"}]}], "]"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->470622724],

Cell[BoxData[
 Graphics3DBox[{
   {RGBColor[0.8727615282403629, 0.1311847289690562, 0.949579590444573], 
    Specularity[
     GrayLevel[1], 20], 
    SphereBox[{5.329849625017724, 6.470758971656107, 1.0711028275391161`}, 
     0.6032484797988652]}, 
   {RGBColor[0.8826819316452403, 0.3858853703361671, 0.12998344913779558`], 
    Specularity[
     GrayLevel[1], 20], 
    SphereBox[{8.979253241540988, 1.0558558644023464`, 0.7255564717337908}, 
     0.7532338108092318]}, 
   {RGBColor[0.8500742247469648, 0.07676047343061221, 0.684681327765196], 
    Specularity[
     GrayLevel[1], 20], 
    SphereBox[{7.3506426727956935`, 6.699945846636144, 2.179720400072151}, 
     0.5311229178854411]}, 
   {RGBColor[0.3608477338955167, 0.9755184203905853, 0.9939502023704208], 
    Specularity[
     GrayLevel[1], 20], 
    SphereBox[{5.266466361952949, 7.761553262777902, 5.523184677250406}, 
     0.9950772453947134]}, 
   {RGBColor[0.8186514207845939, 0.48684337337453054`, 0.8675748493495061], 
    Specularity[
     GrayLevel[1], 20], 
    SphereBox[{7.728908536070932, 5.170078573098317, 4.415413870373845}, 
     0.7968224690360903]}, 
   {RGBColor[0.3746710515685019, 0.15305552014916946`, 0.33482443652472216`], 
    Specularity[
     GrayLevel[1], 20], 
    SphereBox[{8.997293106400129, 3.149940996514715, 6.765350937873311}, 
     0.7791555032963958]}, 
   {RGBColor[0.6926758645713382, 0.008229502549331302, 0.7383933854580536], 
    Specularity[
     GrayLevel[1], 20], 
    SphereBox[{2.9648742500906593`, 8.136389043369526, 3.880222135154007}, 
     0.7020995740937263]}, 
   {RGBColor[0.25294894594903883`, 0.8454873452016078, 0.854526800459122], 
    Specularity[
     GrayLevel[1], 20], 
    SphereBox[{6.436880457248716, 4.409273403962214, 2.2672717732723857`}, 
     0.9844435924454411]}, 
   {RGBColor[0.1227896370420023, 0.458886162250018, 0.08924231831651297], 
    Specularity[
     GrayLevel[1], 20], 
    SphereBox[{0.694638532535869, 3.5917252592855213`, 7.848432145409269}, 
     0.974740311235767]}, 
   {RGBColor[0.7996907702771641, 0.45205904604956526`, 0.6557088240499367], 
    Specularity[
     GrayLevel[1], 20], 
    SphereBox[{4.59546492723906, 7.288227044394155, 1.5831488942946024`}, 
     0.6856156541584495]}, 
   {RGBColor[0.17125510634652263`, 0.42946035782075187`, 0.9192603574528044], 
    Specularity[
     GrayLevel[1], 20], 
    SphereBox[{4.545469021401667, 7.215663324255921, 7.86203703125291}, 
     0.7632580784416153]}, 
   {RGBColor[0.24233497170075102`, 0.03118231577694086, 0.8144427380709318], 
    Specularity[
     GrayLevel[1], 20], 
    SphereBox[{7.74077543514575, 2.019492118169204, 9.861306815803964}, 
     0.8356061336992341]}, 
   {RGBColor[0.5060954220540681, 0.6175084791213932, 0.2828736448024112], 
    Specularity[
     GrayLevel[1], 20], 
    SphereBox[{9.695039765273538, 0.706491534541211, 4.195407010492488}, 
     0.9744797530535944]}, 
   {RGBColor[0.4865212722234844, 0.9330441627829933, 0.21411779003542386`], 
    Specularity[
     GrayLevel[1], 20], 
    SphereBox[{3.1474324987083335`, 8.808275926811543, 3.214845384222624}, 
     0.7203840924789134]}, 
   {RGBColor[0.5825835613112684, 0.3463008609861551, 0.32126223581455315`], 
    Specularity[
     GrayLevel[1], 20], 
    SphereBox[{8.987664484850097, 5.857517431311617, 3.756866581107463}, 
     0.8932010259264292]}, 
   {RGBColor[0.17095243735138288`, 0.8345281764869308, 0.921145796300165], 
    Specularity[
     GrayLevel[1], 20], 
    SphereBox[{1.6388006504855923`, 8.619446401805277, 7.008810674311235}, 
     0.7636184658525841]}, 
   {RGBColor[0.49908089499400354`, 0.171323178131499, 0.15174032485978928`], 
    Specularity[
     GrayLevel[1], 20], 
    SphereBox[{1.2410605075787373`, 4.0698282546097495`, 5.747970061021675}, 
     0.9045607279760428]}, 
   {RGBColor[
    0.43916981411314415`, 0.19187288643017242`, 0.24837472595249377`], 
    Specularity[
     GrayLevel[1], 20], 
    SphereBox[{3.961482843953931, 4.192671091766336, 2.0041241235681007`}, 
     0.5305921691825092]}, 
   {RGBColor[0.4741114314374768, 0.18232287865856645`, 0.6970415184921319], 
    Specularity[
     GrayLevel[1], 20], 
    SphereBox[{6.860071357357448, 5.850189952112743, 0.9755320813021822}, 
     0.7591554697562516]}, 
   {RGBColor[0.46857262372352393`, 0.9913040011201113, 0.40696349993500114`], 
    Specularity[
     GrayLevel[1], 20], 
    SphereBox[{8.163701712880155, 6.153040943871208, 0.9541385147838088}, 
     0.6397824759055468]}, 
   {RGBColor[0.604186477550019, 0.06052846706332171, 0.40780269528079316`], 
    Specularity[
     GrayLevel[1], 20], 
    SphereBox[{6.502938797570948, 6.21069843070746, 3.8201884270960065`}, 
     0.5706637336302559]}, 
   {RGBColor[0.042133275934978176`, 0.6122279500382879, 0.3810439794759277], 
    Specularity[
     GrayLevel[1], 20], 
    SphereBox[{4.553196200901201, 9.955312716487903, 4.35100235563427}, 
     0.9086930494117833]}, 
   {RGBColor[
    0.23049712548771129`, 0.17997597165690582`, 0.41599168268661346`], 
    Specularity[
     GrayLevel[1], 20], 
    SphereBox[{4.867608113632095, 1.2577770313071905`, 3.0717388504602106`}, 
     0.8549031054679389]}, 
   {RGBColor[0.172779052917587, 0.059402449262014656`, 0.37978593014522866`], 
    Specularity[
     GrayLevel[1], 20], 
    SphereBox[{9.733199503167356, 2.339808526973144, 2.5319789022801835`}, 
     0.8952865941329271]}, 
   {RGBColor[0.15707464946587435`, 0.7391375357036121, 0.41434151864633284`], 
    Specularity[
     GrayLevel[1], 20], 
    SphereBox[{5.564568504274108, 1.308073816892815, 9.314145790410752}, 
     0.7820619322502688]}, 
   {RGBColor[0.6740884447823738, 0.8461132525909576, 0.5135355742704617], 
    Specularity[
     GrayLevel[1], 20], 
    SphereBox[{9.316783179538625, 9.972779463863105, 8.108219193157382}, 
     0.7191533729521039]}, 
   {RGBColor[0.6500350490781577, 0.19636793450794365`, 0.5424329701358219], 
    Specularity[
     GrayLevel[1], 20], 
    SphereBox[{8.787234181628929, 4.456465812424559, 7.794365278773881}, 
     0.672422976747954]}, 
   {RGBColor[0.5034179151339, 0.986010921481274, 0.36102949951433994`], 
    Specularity[
     GrayLevel[1], 20], 
    SphereBox[{1.9442508531512104`, 9.538615324401448, 8.273734933631008}, 
     0.785346868545323]}, 
   {RGBColor[0.008712339855886153, 0.05883718089659862, 0.29429917367884784`],
     Specularity[
     GrayLevel[1], 20], 
    SphereBox[{0.8062678529819323, 5.604873163297885, 6.072028521092868}, 
     0.8689975106257862]}, 
   {RGBColor[0.8504994622307693, 0.4144469497032257, 0.6941972629980284], 
    Specularity[
     GrayLevel[1], 20], 
    SphereBox[{6.994405783272192, 4.621807045357469, 7.619631979390306}, 
     0.9561369522074258]}, 
   {RGBColor[0.4262641027810361, 0.40321180425762626`, 0.300323415986522], 
    Specularity[
     GrayLevel[1], 20], 
    SphereBox[{2.8817454210993194`, 5.638155981139574, 7.443771266462338}, 
     0.9197732176575024]}, 
   {RGBColor[0.8524037475013924, 0.6303041573642401, 0.35720107492194897`], 
    Specularity[
     GrayLevel[1], 20], 
    SphereBox[{3.599451976330034, 1.4840106957174548`, 3.964876776084232}, 
     0.6053039773958971]}, 
   {RGBColor[0.5073005542875928, 0.6241130546687084, 0.4676838086354467], 
    Specularity[
     GrayLevel[1], 20], 
    SphereBox[{1.8564914290517986`, 1.2188570362555495`, 2.4213966349302485`},
      0.6013960525391023]}, 
   {RGBColor[0.9423342698467159, 0.8229247927706418, 0.255809658088205], 
    Specularity[
     GrayLevel[1], 20], 
    SphereBox[{3.833456033644609, 3.7923755133403567`, 7.935403238865437}, 
     0.9660773322719283]}, 
   {RGBColor[0.09367364711603487, 0.16694903139893236`, 0.36301223273697825`],
     Specularity[
     GrayLevel[1], 20], 
    SphereBox[{8.614104373055792, 0.020044506226085446`, 8.57354846774393}, 
     0.5122652445368736]}, 
   {RGBColor[0.14779217735561034`, 0.12458147562259225`, 0.08782431908668253],
     Specularity[
     GrayLevel[1], 20], 
    SphereBox[{7.212100856385064, 0.4774996104828677, 2.9969173639036555`}, 
     0.8708021654841459]}, 
   {RGBColor[0.6112252350170349, 0.7174918276399567, 0.8397313295810218], 
    Specularity[
     GrayLevel[1], 20], 
    SphereBox[{2.4996764839915997`, 2.6897464420415353`, 
     0.34527290881559836`}, 0.8137015380079773]}, 
   {RGBColor[
    0.026297126579083674`, 0.014924816548158137`, 0.5683627889099301], 
    Specularity[
     GrayLevel[1], 20], 
    SphereBox[{0.6671171733670693, 9.88873641482003, 9.809542120123385}, 
     0.9601246715312842]}, 
   {RGBColor[0.227953623962877, 0.7990469669306177, 0.5438426463737809], 
    Specularity[
     GrayLevel[1], 20], 
    SphereBox[{3.9250030135160507`, 2.1806663608804637`, 5.841561778123287}, 
     0.9391557678488043]}, 
   {RGBColor[0.8216773915062423, 0.23831143580268743`, 0.5815454061488481], 
    Specularity[
     GrayLevel[1], 20], 
    SphereBox[{5.401544185061715, 7.4220479569050966`, 6.17281732055223}, 
     0.6612258957175154]}, 
   {RGBColor[0.18094483954246376`, 0.9040072205654675, 0.9360311722395227], 
    Specularity[
     GrayLevel[1], 20], 
    SphereBox[{0.9760405809021648, 5.740931556483595, 9.497954764339049}, 
     0.5759763825820806]}, 
   {RGBColor[0.6582887448357564, 0.10331153819492567`, 0.4142653708185189], 
    Specularity[
     GrayLevel[1], 20], 
    SphereBox[{1.9753229111238326`, 7.960581564596161, 9.570361710817021}, 
     0.8022023762837227]}, 
   {RGBColor[0.18260517429596668`, 0.3177623011619306, 0.8332776049160935], 
    Specularity[
     GrayLevel[1], 20], 
    SphereBox[{4.760847614294466, 1.5316839733698018`, 4.977747398600453}, 
     0.5358877065604933]}, 
   {RGBColor[0.10652309413946548`, 0.7374185935374054, 0.5082534109579451], 
    Specularity[
     GrayLevel[1], 20], 
    SphereBox[{1.1625731419879521`, 9.756127588035493, 0.1338090922638564}, 
     0.6199009188246866]}, 
   {RGBColor[0.2541779570022136, 0.6673982442166406, 0.12933965086265853`], 
    Specularity[
     GrayLevel[1], 20], 
    SphereBox[{5.394755450794204, 6.847081976001196, 6.15836703507145}, 
     0.6586158985962636]}, 
   {RGBColor[0.6685009794324552, 0.33326323776015054`, 0.6043374257906762], 
    Specularity[
     GrayLevel[1], 20], 
    SphereBox[{8.99958145782658, 4.724550910889164, 9.949382458619947}, 
     0.6054389867396153]}, 
   {RGBColor[0.6924623180644387, 0.35274376540961794`, 0.05818568051821682], 
    Specularity[
     GrayLevel[1], 20], 
    SphereBox[{2.089088418989011, 3.266927188803697, 2.537179745595017}, 
     0.8327374817903734]}, 
   {RGBColor[0.7587925525414572, 0.028181858564596318`, 0.29573396002987407`],
     Specularity[
     GrayLevel[1], 20], 
    SphereBox[{0.6789560745701486, 0.7703295685320448, 6.069791943035796}, 
     0.7142208750637452]}, 
   {RGBColor[0.8864023565260053, 0.9133797786892972, 0.9024990263181913], 
    Specularity[
     GrayLevel[1], 20], 
    SphereBox[{2.378628488861679, 1.1120496828861768`, 3.6575379015012004`}, 
     0.6426915727305749]}, 
   {RGBColor[0.13140082410221976`, 0.8311846774782936, 0.7453241309420711], 
    Specularity[
     GrayLevel[1], 20], 
    SphereBox[{9.173196014498117, 7.845563050008732, 1.3907923612104174`}, 
     0.8256522153640089]}}]], "Output",
 ImageSize->{184, 198},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->112848342,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1061],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Lighting",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Lighting"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RGBColor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RGBColor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Glow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Glow"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ColorFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorFunction"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->28267]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Specularity",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Specularity"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->603904866],

Cell[TextData[ButtonBox["3D Graphics Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/3DGraphicsOptions"]], "MoreAbout",
 CellID->591345462],

Cell[TextData[ButtonBox["Colors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Colors"]], "MoreAbout",
 CellID->35170094],

Cell[TextData[ButtonBox["Graphics Directives",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsDirectives"]], "MoreAbout",
 CellID->29015998],

Cell[TextData[ButtonBox["New in 6.0: Graphics Primitives & Directives",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsPrimitivesAndDirectives"]], "MoreAbout",
 CellID->83284118],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60VisualizationAndGraphics"]], "MoreAbout",
 CellID->690156194]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Specularity - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 22, 14.2787112}", "context" -> "System`", 
    "keywords" -> {
     "specular color", "material property", "shininess", "specular exponent", 
      "specular reflection", "surface reflection", "reflection", 
      "metallic color", "plastic color", "metallic surface", 
      "plastic surface", "lighting", "lighting properties", 
      "shading equation", "shading properties", "Gouraud shading", 
      "Blinn shading"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Specularity[s] is a graphics directive which specifies that surfaces of \
3D graphics objects which follow are to be taken to have specularity s. \
Specularity[s, n] uses specular exponent n. ", "synonyms" -> {}, "title" -> 
    "Specularity", "type" -> "Symbol", "uri" -> "ref/Specularity"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10229, 330, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->238055382]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 361131, 6668}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2135, 47, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2758, 74, 1576, 37, 70, "ObjectNameGrid"],
Cell[4337, 113, 1069, 33, 70, "Usage",
 CellID->11621]
}, Open  ]],
Cell[CellGroupData[{
Cell[5443, 151, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5921, 168, 252, 7, 70, "Notes",
 CellID->27150],
Cell[6176, 177, 299, 9, 70, "Notes",
 CellID->25202],
Cell[6478, 188, 335, 10, 70, "Notes",
 CellID->14110],
Cell[6816, 200, 272, 6, 70, "Notes",
 CellID->25794],
Cell[7091, 208, 526, 17, 70, "Notes",
 CellID->26956],
Cell[7620, 227, 318, 10, 70, "Notes",
 CellID->16896],
Cell[7941, 239, 482, 16, 70, "Notes",
 CellID->6359],
Cell[8426, 257, 631, 23, 70, "Notes",
 CellID->30121],
Cell[9060, 282, 664, 24, 70, "Notes",
 CellID->28321],
Cell[9727, 308, 465, 17, 70, "Notes",
 CellID->31519]
}, Closed]],
Cell[CellGroupData[{
Cell[10229, 330, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->238055382],
Cell[CellGroupData[{
Cell[10614, 344, 147, 5, 70, "ExampleSection",
 CellID->55453161],
Cell[10764, 351, 68, 1, 70, "ExampleText",
 CellID->585523909],
Cell[CellGroupData[{
Cell[10857, 356, 250, 8, 28, "Input",
 CellID->274850458],
Cell[11110, 366, 26153, 435, 184, 105, 3, "CachedBoxData", "BoxData", \
"Output",
 CellID->233850869]
}, Open  ]],
Cell[37278, 804, 124, 3, 70, "ExampleDelimiter",
 CellID->27161693],
Cell[37405, 809, 121, 2, 70, "ExampleText",
 CellID->225462722],
Cell[CellGroupData[{
Cell[37551, 815, 450, 15, 70, "Input",
 CellID->37956373],
Cell[38004, 832, 35366, 592, 131, "Output",
 CellID->74595844]
}, Open  ]],
Cell[73385, 1427, 125, 3, 70, "ExampleDelimiter",
 CellID->326714863],
Cell[73513, 1432, 124, 2, 70, "ExampleText",
 CellID->210355696],
Cell[CellGroupData[{
Cell[73662, 1438, 537, 17, 70, "Input",
 CellID->208428479],
Cell[74202, 1457, 16989, 293, 131, "Output",
 CellID->39653021]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[91240, 1756, 219, 7, 70, "ExampleSection",
 CellID->67676268],
Cell[91462, 1765, 138, 2, 70, "ExampleText",
 CellID->518694676],
Cell[CellGroupData[{
Cell[91625, 1771, 522, 15, 70, "Input",
 CellID->50358000],
Cell[92150, 1788, 20699, 346, 184, 183, 5, "CachedBoxData", "BoxData", \
"Output",
 CellID->63926291]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[112898, 2140, 223, 7, 70, "ExampleSection",
 CellID->23592],
Cell[113124, 2149, 75, 1, 70, "ExampleText",
 CellID->16606973],
Cell[CellGroupData[{
Cell[113224, 2154, 629, 20, 70, "Input",
 CellID->858661563],
Cell[113856, 2176, 35544, 587, 70, "Output",
 Evaluatable->False,
 CellID->183883344]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[149449, 2769, 233, 7, 70, "ExampleSection",
 CellID->31180],
Cell[149685, 2778, 601, 21, 70, "ExampleText",
 CellID->253706442],
Cell[CellGroupData[{
Cell[150311, 2803, 443, 14, 70, "Input",
 CellID->63357435],
Cell[150757, 2819, 35000, 585, 131, "Output",
 CellID->188139789]
}, Open  ]],
Cell[CellGroupData[{
Cell[185794, 3409, 486, 15, 70, "Input",
 CellID->256341244],
Cell[186283, 3426, 35000, 585, 131, "Output",
 CellID->119176125]
}, Open  ]],
Cell[221298, 4014, 124, 3, 70, "ExampleDelimiter",
 CellID->90117218],
Cell[221425, 4019, 469, 17, 70, "ExampleText",
 CellID->226188554],
Cell[CellGroupData[{
Cell[221919, 4040, 508, 15, 70, "Input",
 CellID->51337253],
Cell[222430, 4057, 23530, 394, 131, "Output",
 CellID->47659562]
}, Open  ]],
Cell[245975, 4454, 125, 3, 70, "ExampleDelimiter",
 CellID->181279056],
Cell[246103, 4459, 333, 12, 70, "ExampleText",
 CellID->435397519],
Cell[CellGroupData[{
Cell[246461, 4475, 267, 8, 70, "Input",
 CellID->85655928],
Cell[246731, 4485, 9495, 161, 129, 117, 3, "CachedBoxData", "BoxData", \
"Output",
 CellID->792790470]
}, Open  ]],
Cell[CellGroupData[{
Cell[256263, 4651, 346, 10, 70, "Input",
 CellID->133116279],
Cell[256612, 4663, 7760, 133, 129, 139, 4, "CachedBoxData", "BoxData", \
"Output",
 CellID->177486761]
}, Open  ]],
Cell[CellGroupData[{
Cell[264409, 4801, 547, 17, 70, "Input",
 CellID->282128780],
Cell[264959, 4820, 5418, 96, 129, 193, 6, "CachedBoxData", "BoxData", \
"Output",
 CellID->28886346]
}, Open  ]],
Cell[270392, 4919, 125, 3, 70, "ExampleDelimiter",
 CellID->277160744],
Cell[270520, 4924, 248, 8, 70, "ExampleText",
 CellID->10874751],
Cell[CellGroupData[{
Cell[270793, 4936, 652, 20, 70, "Input",
 CellID->18850506],
Cell[271448, 4958, 16009, 271, 184, 242, 8, "CachedBoxData", "BoxData", \
"Output",
 CellID->339773786]
}, Open  ]],
Cell[287472, 5232, 125, 3, 70, "ExampleDelimiter",
 CellID->165571895],
Cell[287600, 5237, 89, 1, 70, "ExampleText",
 CellID->126206124],
Cell[CellGroupData[{
Cell[287714, 5242, 408, 12, 70, "Input",
 CellID->218837766],
Cell[288125, 5256, 17909, 300, 184, 154, 4, "CachedBoxData", "BoxData", \
"Output",
 CellID->70376847]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[306083, 5562, 226, 7, 70, "ExampleSection",
 CellID->19115],
Cell[306312, 5571, 96, 1, 70, "ExampleText",
 CellID->2079054],
Cell[CellGroupData[{
Cell[306433, 5576, 332, 10, 70, "Input",
 CellID->571040256],
Cell[306768, 5588, 2900, 54, 216, 131, 4, "CachedBoxData", "BoxData", \
"Output",
 CellID->643546238]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[309717, 5648, 223, 7, 70, "ExampleSection",
 CellID->2876],
Cell[309943, 5657, 58, 1, 70, "ExampleText",
 CellID->438233207],
Cell[CellGroupData[{
Cell[310026, 5662, 781, 23, 70, "Input",
 CellID->470622724],
Cell[310810, 5687, 45601, 823, 219, 11185, 254, "CachedBoxData", "BoxData", \
"Output",
 CellID->112848342]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[356472, 6517, 310, 9, 70, "SeeAlsoSection",
 CellID->1061],
Cell[356785, 6528, 943, 35, 70, "SeeAlso",
 CellID->28267]
}, Open  ]],
Cell[CellGroupData[{
Cell[357765, 6568, 305, 8, 70, "RelatedLinksSection"],
Cell[358073, 6578, 367, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[358477, 6595, 319, 9, 70, "MoreAboutSection",
 CellID->603904866],
Cell[358799, 6606, 148, 3, 70, "MoreAbout",
 CellID->591345462],
Cell[358950, 6611, 123, 3, 70, "MoreAbout",
 CellID->35170094],
Cell[359076, 6616, 148, 3, 70, "MoreAbout",
 CellID->29015998],
Cell[359227, 6621, 196, 4, 70, "MoreAbout",
 CellID->83284118],
Cell[359426, 6627, 179, 3, 70, "MoreAbout",
 CellID->690156194]
}, Open  ]],
Cell[359620, 6633, 27, 0, 70, "History"],
Cell[359650, 6635, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

