(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8367,        301]
NotebookOptionsPosition[      5664,        216]
NotebookOutlinePosition[      7105,        254]
CellTagsIndexPosition[      7021,        249]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"IgnoreCase" :> 
         Documentation`HelpLookup["paclet:ref/IgnoreCase"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"IgnoreCase\"\>"}, "\<\"see also\"\>",
       
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SpellingCorrection", "ObjectName",
 CellID->10013],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["SpellingCorrection",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/SpellingCorrection"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["StringMatchQ",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/StringMatchQ"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Names",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Names"]], "InlineFormula"],
     " and related functions which specifies whether strings should be \
considered to match even when a small fraction of the characters in them are \
different. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->32571]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The default setting ",
 Cell[BoxData[
  RowBox[{"SpellingCorrection", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " requires exact matching. "
}], "Notes",
 CellID->31632]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->212875071],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->105370030],

Cell["Test for an exact match:", "ExampleText",
 CellID->22838611],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringMatchQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "\"\<spear\>\"", ",", "\"\<spare\>\"", ",", "\"\<speer\>\"", ",", 
     "\"\<spire\>\"", ",", "\"\<stare\>\""}], "}"}], ",", "\"\<spare\>\"", 
   ",", 
   RowBox[{"SpellingCorrection", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->380325313],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"False", ",", "True", ",", "False", ",", "False", ",", "False"}], 
  "}"}]], "Output",
 ImageSize->{231, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->710188129]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4060389],

Cell["Test for a close match:", "ExampleText",
 CellID->26588926],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringMatchQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "\"\<spear\>\"", ",", "\"\<spare\>\"", ",", "\"\<speer\>\"", ",", 
     "\"\<spire\>\"", ",", "\"\<stare\>\""}], "}"}], ",", "\"\<spare\>\"", 
   ",", 
   RowBox[{"SpellingCorrection", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11697506],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"False", ",", "True", ",", "False", ",", "True", ",", "True"}], 
  "}"}]], "Output",
 ImageSize->{217, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->501793078]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->32007],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["IgnoreCase",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IgnoreCase"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->4336]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SpellingCorrection - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 22, 15.8568766}", "context" -> "System`", 
    "keywords" -> {"correct spelling", "spell-checker", "spellchecker"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "SpellingCorrection is an option for StringMatchQ, Names and related \
functions which specifies whether strings should be considered to match even \
when a small fraction of the characters in them are different. ", 
    "synonyms" -> {"spelling correction"}, "title" -> "SpellingCorrection", 
    "type" -> "Symbol", "uri" -> "ref/SpellingCorrection"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2930, 106, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->212875071]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6878, 242}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 571, 15, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1194, 42, 56, 1, 70, "ObjectName",
 CellID->10013],
Cell[1253, 45, 869, 25, 70, "Usage",
 CellID->32571]
}, Open  ]],
Cell[CellGroupData[{
Cell[2159, 75, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2637, 92, 256, 9, 70, "Notes",
 CellID->31632]
}, Closed]],
Cell[CellGroupData[{
Cell[2930, 106, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->212875071],
Cell[CellGroupData[{
Cell[3315, 120, 148, 5, 70, "ExampleSection",
 CellID->105370030],
Cell[3466, 127, 66, 1, 70, "ExampleText",
 CellID->22838611],
Cell[CellGroupData[{
Cell[3557, 132, 358, 10, 47, "Input",
 CellID->380325313],
Cell[3918, 144, 256, 8, 36, "Output",
 CellID->710188129]
}, Open  ]],
Cell[4189, 155, 123, 3, 70, "ExampleDelimiter",
 CellID->4060389],
Cell[4315, 160, 65, 1, 70, "ExampleText",
 CellID->26588926],
Cell[CellGroupData[{
Cell[4405, 165, 356, 10, 70, "Input",
 CellID->11697506],
Cell[4764, 177, 254, 8, 36, "Output",
 CellID->501793078]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5079, 192, 311, 9, 70, "SeeAlsoSection",
 CellID->32007],
Cell[5393, 203, 199, 6, 70, "SeeAlso",
 CellID->4336]
}, Open  ]],
Cell[5607, 212, 27, 0, 70, "History"],
Cell[5637, 214, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

