(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21698,        736]
NotebookOptionsPosition[     16833,        569]
NotebookOutlinePosition[     18164,        607]
CellTagsIndexPosition[     18079,        602]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Spheroidal Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/SpheroidalFunctions"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Spheroidal Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Spheroidal and Related Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/SpheroidalAndRelatedFunctions"], 
          "New in 6.0: Mathematical Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicalFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Spheroidal and Related Functions\"\>", 
       2->"\<\"New in 6.0: Mathematical Functions\"\>"}, "\<\"more about\"\>",
        
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["SpheroidalJoiningFactor", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SpheroidalJoiningFactor",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SpheroidalJoiningFactor"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["m", "TI"], ",", 
        StyleBox["\[Gamma]", "TR"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the spheroidal joining factor with degree ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " and order ",
     Cell[BoxData[
      FormBox["m", TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->10431]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["SpheroidalJoiningFactor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SpheroidalJoiningFactor"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->226770354],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SpheroidalJoiningFactor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SpheroidalJoiningFactor"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SpheroidalJoiningFactor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SpheroidalJoiningFactor"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->11015400],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->138787883],

Cell["Evaluate numerically:", "ExampleText",
 CellID->190563336],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SpheroidalJoiningFactor", "[", 
  RowBox[{"1", ",", "0", ",", "0.5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19520869],

Cell[BoxData[
 RowBox[{"0.16585061837612927188522258492`16.105104768022994", "+", 
  RowBox[{"0``16.885387672892", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9482424]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->569715319],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"SpheroidalJoiningFactor", "[", 
    RowBox[{"1", ",", "0", ",", "c"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->306249471],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWGuIVVUU3t5z7x0r844yNpaVo2milGKhPexlxWSJ9pShNOt6s+aWzdjM
KNX0GLO08FGNlhk9CCzo8cNIjMAgEiIhEiIhKgiDsB9JkPRjIDh9e6+zz+y9
9rpz79yJ6EcDM/fsc7717bW/9e119p0lxZ721Q8We8qlYst1XcW17eVSd0tr
ZxduRaOUUvvw2z1R4TrGlfndF8f4DP9Ow98MAJEeRRqp7yql7zXiWt/KOM/0
ZaVnNq6A62yFOOkZny8S4sw9dY7+mx18olQDw45l4yiIaGSIPBufyjLLBgwF
huA58BkyAUPmX1vNyBn+S6spxNVyGccQOSEH7adczavIJRGcuXr22SRy/LCz
jipEhnMOlfVQVawt+6B6XkS4M0IMz6O6FrQi25caks9C8plPPhvreB45z6mf
uJ2Qr/+tIe7qHrEnZTGYPIa9j36yrmf/8eN/OvpwzfnaRzAeKd//+QxvbLxM
1c7R3UNf/nzn8nc/3v+dmsCwzf/w2Jm7Ib174sTA5k2fwXLHjv2hXh9EBGug
PN/ec1i9lqIy6Q4eGPhr9yuHyu17jx79/VWRhXbxkW9/La36QLPsFlF5hw3T
Ab5LxI02OEyGKQFFwEsi7mQzxnyYFWRqp5f7GIdlR/8X0KJfZKH3+fvvfYOU
oIN6UURR58LWhZrQFGzPizgao+Jty97Rdd8uokw/z6blQZJbvdybbFUSPbeI
LE1BdZ4TcacZHFXnzTe+QsBmg0vak/nh57tI6E/Ndj6QkOSbCF2xoyuB5XSn
LqTk0wILf7PzvTrJ6pxUbaPAwc8X2ut6eKZTS7RkXGyoMdodn23GBz//Kdnh
fQJH+Abkakx2nEA1fCKojX0n8XflFKeucAkK85hY/6mOT6huvZ7bpjsV2bb1
IJJ5ROQ514w/3HsEK/70wI/qYRE1w6q7oe8AtZ71Im6mwaWdB+n1iLhZQfbd
XvbnB356SOSZ7TgGVVNrRdQcmz29q5F9h4ibG2S/RsRd4GePgAe87OfZ7FMv
lkWe+QaHvNFXaL77Ap+Yy1wakzzgrrkoyOhewbnV9t8lTt5QHXnfI7Bot2cF
1y9wagE/qVKFWLeP6HXo4WVxsmNgVZQcfigK0fZUzld/RZzsmdTrdw0j+qo4
2QGogs57ZVAD3jW4bguD7FeI9b4myPMOzzetLJPbRZZWZzbU+vDXv7SJuEUG
98P3v3V2fEQuXCbibghceKuIW+x4jBr0LV72S81zbC64h95/N4k8N8aDuwxU
WMhSEXezGSOjpDMtEVEmh6QzQVYsd7GIu81qD8kgHAKu97Jvs9pjNpwbSL2A
pc1qj8MHgNC+VcSZyumdRNpDlGsDV0n/8eDeXG5rk2p1teDs6m+kFbZ2JCeW
ubBmHk2z0qpMDse6r6wrj7ttFVJdLq/AEwlqrPLVwHIWCNE8iudQcrSA5WHE
S4Pa2G+QPHa11QEGxxLgtos9F7Wb55Anddl80R9l5rZ5Iur+wG0Xirg1vtsw
61wR12H1w7LpzDhHxHVahQACFJtvtrfKLqsC9hypcJ7I0+2oQaf1WSJunRnT
aV33vZkiar3jQTozzBBx5gSj+x6dHRAw3cvenJOc99Q0kaXXak+OB93UwCW1
7ODH48G+Qxq0CJ6tvnOedDTS3XByXSx9TuWoR58l8LhvSh38lIlKv7nAGJPq
mn2j9VV66jujLp5n4pidbScGtal0vjbfkpJ3rD7hN4vVf9ZWPz3BT/A8ZL67
Od+Nm0SWLc56iWW8iNvG2MaJqO0BW0HEvcDYxnqZ9wcsY0SWHYzlFBG102eD
sU4ScS9btsS9o0XULqs63AnhQZv3cjf/p9A7F0T6MieyDPU/PDXqb+zK3To=
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29921191]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15874],

Cell["Evaluate for complex arguments and parameters:", "ExampleText",
 CellID->152558253],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SpheroidalJoiningFactor", "[", 
  RowBox[{"2", ",", 
   RowBox[{"1", "-", "I"}], ",", 
   RowBox[{"2", "+", 
    RowBox[{"0.5", " ", "I"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->455397153],

Cell[BoxData[
 RowBox[{"0.06081877960505529958918908302`15.9729314235567", "+", 
  RowBox[{
  "0.05567510012575688229822976212`15.934554728991465", " ", 
   "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{294, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->736324001]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19726947],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->144184274],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"SpheroidalJoiningFactor", "[", 
    RowBox[{"3", ",", "2", ",", "100"}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14599008],

Cell[BoxData[
 RowBox[{"1.367503881306781470326893053777977249572099770316243750623084`50.\
15051499783199*^12", "+", 
  RowBox[{"0``38.01458643019198", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{483, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->135488390]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->89245610],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->476931846],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SpheroidalJoiningFactor", "[", 
  RowBox[{"3", ",", "2", ",", "100.00000000000000000000000000"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->224451537],

Cell[BoxData[
 RowBox[{"1.3675038813067814703268930537779772495721`28.15051499783199*^12", 
  "+", 
  RowBox[{"0``16.01458643019199", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{329, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->41462417]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->530769262],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SpheroidalJoiningFactor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SpheroidalJoiningFactor"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->172531554],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SpheroidalJoiningFactor", "[", 
  RowBox[{"1", ",", "0", ",", 
   RowBox[{"{", 
    RowBox[{"1.", ",", "2.", ",", "3."}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->194602464],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.32721793528004380898618769246`16.105104768022994", "+", 
    RowBox[{"0``16.59026766807358", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.63073783919138953222554158508`16.105104768022994", "+", 
    RowBox[{"0``16.305255882076324", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.94913138598694239093217204437`16.105104768022994", "+", 
    RowBox[{"0``16.127778433088228", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{438, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->301084002]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27401],

Cell["A relation between radial and angular spheroidal functions:", \
"ExampleText",
 CellID->21070552],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SpheroidalS1", "[", 
    RowBox[{"n", ",", "0", ",", "c", ",", "z"}], "]"}], "==", 
   RowBox[{
    RowBox[{"SpheroidalJoiningFactor", "[", 
     RowBox[{"n", ",", "0", ",", "c"}], "]"}], 
    RowBox[{"SpheroidalPS", "[", 
     RowBox[{"n", ",", "0", ",", "c", ",", "z"}], "]"}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->575026809],

Cell["Check numerically:", "ExampleText",
 CellID->633200132],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"n", "\[Rule]", "2"}], ",", 
    RowBox[{"c", "\[Rule]", "1"}], ",", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{"RandomComplex", "[", "]"}]}]}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->151665173],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->33750833]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7367],

Cell[TextData[{
 "Spheroidal functions do not evaluate for half-integer values of ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " and generic values of ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->348355882],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SpheroidalJoiningFactor", "[", 
  RowBox[{
   RowBox[{"3", "/", "2"}], ",", "1", ",", "0.5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->175415402],

Cell[BoxData[
 RowBox[{"SpheroidalJoiningFactor", "[", 
  RowBox[{
   FractionBox["3", "2"], ",", "1", ",", "0.5`"}], "]"}]], "Output",
 ImageSize->{241, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->689066193]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->15569],

Cell[TextData[ButtonBox["Spheroidal Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpheroidalFunctions"]], "Tutorials",
 CellID->12303]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->73310217],

Cell[TextData[ButtonBox["Spheroidal and Related Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpheroidalAndRelatedFunctions"]], "MoreAbout",
 CellID->932646420],

Cell[TextData[ButtonBox["New in 6.0: Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicalFunctions"]], "MoreAbout",
 CellID->71802921]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SpheroidalJoiningFactor - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 23, 31.7181936}", "context" -> "System`", 
    "keywords" -> {"spheroidal functions"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "SpheroidalJoiningFactor[n, m, \\[Gamma]] gives the spheroidal joining \
factor with degree n and order m.", 
    "synonyms" -> {"spheroidal joining factor"}, "title" -> 
    "SpheroidalJoiningFactor", "type" -> "Symbol", "uri" -> 
    "ref/SpheroidalJoiningFactor"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5893, 185, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->11015400]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17937, 595}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1450, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2073, 63, 1588, 37, 70, "ObjectNameGrid"],
Cell[3664, 102, 791, 24, 70, "Usage",
 CellID->10431]
}, Open  ]],
Cell[CellGroupData[{
Cell[4492, 131, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4970, 148, 120, 4, 70, "Notes",
 CellID->20640],
Cell[5093, 154, 278, 8, 70, "Notes",
 CellID->226770354],
Cell[5374, 164, 248, 7, 70, "Notes",
 CellID->31226],
Cell[5625, 173, 231, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[5893, 185, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->11015400],
Cell[CellGroupData[{
Cell[6277, 199, 148, 5, 70, "ExampleSection",
 CellID->138787883],
Cell[6428, 206, 64, 1, 70, "ExampleText",
 CellID->190563336],
Cell[CellGroupData[{
Cell[6517, 211, 153, 4, 28, "Input",
 CellID->19520869],
Cell[6673, 217, 280, 7, 36, "Output",
 CellID->9482424]
}, Open  ]],
Cell[6968, 227, 125, 3, 70, "ExampleDelimiter",
 CellID->569715319],
Cell[CellGroupData[{
Cell[7118, 234, 268, 8, 28, "Input",
 CellID->306249471],
Cell[7389, 244, 2103, 39, 136, "Output",
 Evaluatable->False,
 CellID->29921191]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9541, 289, 216, 7, 70, "ExampleSection",
 CellID->15874],
Cell[9760, 298, 89, 1, 70, "ExampleText",
 CellID->152558253],
Cell[CellGroupData[{
Cell[9874, 303, 227, 7, 70, "Input",
 CellID->455397153],
Cell[10104, 312, 319, 9, 36, "Output",
 CellID->736324001]
}, Open  ]],
Cell[10438, 324, 124, 3, 70, "ExampleDelimiter",
 CellID->19726947],
Cell[10565, 329, 70, 1, 70, "ExampleText",
 CellID->144184274],
Cell[CellGroupData[{
Cell[10660, 334, 208, 6, 70, "Input",
 CellID->14599008],
Cell[10871, 342, 320, 8, 36, "Output",
 CellID->135488390]
}, Open  ]],
Cell[11206, 353, 124, 3, 70, "ExampleDelimiter",
 CellID->89245610],
Cell[11333, 358, 113, 3, 70, "ExampleText",
 CellID->476931846],
Cell[CellGroupData[{
Cell[11471, 365, 184, 5, 70, "Input",
 CellID->224451537],
Cell[11658, 372, 300, 8, 36, "Output",
 CellID->41462417]
}, Open  ]],
Cell[11973, 383, 125, 3, 70, "ExampleDelimiter",
 CellID->530769262],
Cell[12101, 388, 240, 7, 70, "ExampleText",
 CellID->172531554],
Cell[CellGroupData[{
Cell[12366, 399, 214, 6, 70, "Input",
 CellID->194602464],
Cell[12583, 407, 606, 14, 58, "Output",
 CellID->301084002]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13238, 427, 223, 7, 70, "ExampleSection",
 CellID->27401],
Cell[13464, 436, 103, 2, 70, "ExampleText",
 CellID->21070552],
Cell[13570, 440, 390, 11, 70, "Input",
 CellID->575026809],
Cell[13963, 453, 61, 1, 70, "ExampleText",
 CellID->633200132],
Cell[CellGroupData[{
Cell[14049, 458, 281, 9, 70, "Input",
 CellID->151665173],
Cell[14333, 469, 160, 5, 36, "Output",
 CellID->33750833]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14542, 480, 225, 7, 70, "ExampleSection",
 CellID->7367],
Cell[14770, 489, 284, 9, 70, "ExampleText",
 CellID->348355882],
Cell[CellGroupData[{
Cell[15079, 502, 178, 5, 70, "Input",
 CellID->175415402],
Cell[15260, 509, 266, 8, 51, "Output",
 CellID->689066193]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15587, 524, 314, 9, 70, "TutorialsSection",
 CellID->15569],
Cell[15904, 535, 150, 3, 70, "Tutorials",
 CellID->12303]
}, Open  ]],
Cell[CellGroupData[{
Cell[16091, 543, 318, 9, 70, "MoreAboutSection",
 CellID->73310217],
Cell[16412, 554, 173, 3, 70, "MoreAbout",
 CellID->932646420],
Cell[16588, 559, 173, 3, 70, "MoreAbout",
 CellID->71802921]
}, Open  ]],
Cell[16776, 565, 27, 0, 70, "History"],
Cell[16806, 567, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

