(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     29417,        969]
NotebookOptionsPosition[     24230,        791]
NotebookOutlinePosition[     25568,        828]
CellTagsIndexPosition[     25483,        823]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Spheroidal Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/SpheroidalFunctions"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Spheroidal Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SpheroidalS1" :> 
          Documentation`HelpLookup["paclet:ref/SpheroidalS1"], 
          "SphericalBesselY" :> 
          Documentation`HelpLookup["paclet:ref/SphericalBesselY"], 
          "SpheroidalRadialFactor" :> 
          Documentation`HelpLookup["paclet:ref/SpheroidalRadialFactor"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"SpheroidalS1\"\>", 
       2->"\<\"SphericalBesselY\"\>", 
       3->"\<\"SpheroidalRadialFactor\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Spheroidal and Related Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/SpheroidalAndRelatedFunctions"], 
          "New in 6.0: Mathematical Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicalFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Spheroidal and Related Functions\"\>", 
       2->"\<\"New in 6.0: Mathematical Functions\"\>"}, "\<\"more about\"\>",
        
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["SpheroidalS2", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SpheroidalS2",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SpheroidalS2"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["m", "TI"], ",", 
        StyleBox["\[Gamma]", "TR"], ",", 
        StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the radial spheroidal function ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubsuperscriptBox["S", 
         RowBox[{"n", ",", "m"}], 
         RowBox[{"(", "2", ")"}]], "(", 
        RowBox[{"\[Gamma]", ",", "z"}], ")"}], TraditionalForm]], 
      "InlineMath"],
     " of the second kind."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->14127]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 "The radial spheroidal functions satisfy the differential equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox["z", "2"]}], ")"}], 
      SuperscriptBox["y", "\[DoublePrime]"]}], "-", 
     RowBox[{"2", "z", " ", 
      SuperscriptBox["y", "\[Prime]"]}], " ", "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"\[Lambda]", "+", 
        RowBox[{
         SuperscriptBox["\[Gamma]", "2"], "(", 
         RowBox[{"1", "-", 
          SuperscriptBox["z", "2"]}], ")"}], "-", 
        FractionBox[
         SuperscriptBox["m", "2"], 
         RowBox[{"1", "-", 
          SuperscriptBox["z", "2"]}]]}], ")"}], "y"}]}], "\[Equal]", "0"}], 
   TraditionalForm]], "InlineMath"],
 " with the spheroidal eigenvalue ",
 Cell[BoxData[
  FormBox["\[Lambda]", TraditionalForm]], "InlineMath"],
 " given by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SpheroidalEigenvalue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SpheroidalEigenvalue"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["m", "TI"], ",", 
    StyleBox["\[Gamma]", "TR"]}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->10593],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["S", 
     RowBox[{"n", ",", "m"}], 
     RowBox[{"(", "2", ")"}]], "(", 
    RowBox[{"\[Gamma]", ",", "z"}], ")"}], TraditionalForm]], "InlineMath"],
 " are normalized according to the Meixner\[Dash]Sch\[ADoubleDot]fke scheme."
}], "Notes",
 CellID->16544],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SpheroidalS2",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SpheroidalS2"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SpheroidalS2",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SpheroidalS2"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->322881978],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->308448091],

Cell["Evaluate numerically:", "ExampleText",
 CellID->45503221],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SpheroidalS2", "[", 
  RowBox[{"2", ",", "0", ",", "2.5", ",", "5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->416581269],

Cell[BoxData["0.08191210739680125474334468395`15.954589770191003"], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{137, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->257320837]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25831],

Cell["Evaluate for complex arguments and parameters:", "ExampleText",
 CellID->94393633],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SpheroidalS2", "[", 
  RowBox[{"3", ",", "2", ",", 
   RowBox[{"1", "-", "I"}], ",", " ", "3.5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->314925903],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1.09154513789407969781564133882`16.0537330841632"}], "-", 
  RowBox[{
  "0.56392121681644225006380111154`15.76690981934579", " ", 
   "\[ImaginaryI]"}]}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{288, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->99290271]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->217504807],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->283569038],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"SpheroidalS2", "[", 
    RowBox[{"2", ",", "1", ",", 
     RowBox[{"1", "/", "3"}], ",", "5"}], "]"}], ",", "50"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->852018633],

Cell[BoxData[
 RowBox[{"-", 
  "1.1004628645283103908192699573081353688424007970873829877669077258854`50."}\
]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{369, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->383193846]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3535261],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->173158339],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SpheroidalS2", "[", 
  RowBox[{"2", ",", "1", ",", 
   RowBox[{"1", "/", "3"}], ",", "5.000000000000000000000000000"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->429954945],

Cell[BoxData[
 RowBox[{"-", 
  "1.10046286452831039081926995730813536884`27.69897000433602"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{215, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->388589798]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->165479942],

Cell[TextData[{
 "For certain parameters ",
 Cell[BoxData[
  ButtonBox["SpheroidalS2",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SpheroidalS2"]], "InlineFormula"],
 " evaluates exactly:"
}], "ExampleText",
 CellID->160938561],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"n", "=", "3"}], "}"}], ",", 
   RowBox[{"SpheroidalS2", "[", 
    RowBox[{"n", ",", "1", ",", 
     RowBox[{"n", " ", 
      RowBox[{"Pi", "/", "2"}]}], ",", " ", "x"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10306910],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{
      FractionBox["3", "2"], " ", "\[Pi]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "x"}], ")"}]}], "]"}]}], 
   RowBox[{"3", " ", "\[Pi]", " ", 
    SqrtBox[
     RowBox[{"1", "-", 
      FractionBox["1", 
       SuperscriptBox["x", "2"]]}]], " ", "x"}]]}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{134, 64},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->798299319]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->728648831],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " typesetting:"
}], "ExampleText",
 CellID->558624730],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SpheroidalS2", "[", 
   RowBox[{"n", ",", "m", ",", "c", ",", "\[Eta]"}], "]"}], "//", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->261657998],

Cell[GraphicsData["CompressedBitmap", "\<\
eJydVNsKwjAMzdq5ORgi4oMPKvsD/0Kf/Igigj6IMv3/2fS2LilzWFi6HNOT
npzhWX1u14f63C+qObXqdbtf3s3x2WpIZgBw0M96A/q902/mOXSd3m2sMUpE
zYLGoAXGmUXBLF8G0kIYhd63fb3s6/PheYfOSC9J8hJD3ueOx+I/2Skb7RZr
Cg28nDzWiph0ffCAGN5LL+FQ4VWxW+PoM9wN5OuhoDO13USQ5VHBWMVkPcPe
9oIRESwZd80QzpOT/os0C7uRYEzUqUl5SXgdexW5kZgXm9qvr4TWe5fn3iUZ
7EvMaNw1cybhJM3Xad74BFKVxNdo3mOKVyTvPeFfoUw6WhCGZUqPmRhDB7PZ
/10XdCbqqgi3PtGJ7Mwv9v8Psi9JT4Tu\
\>"], "Output",
 Evaluatable->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{47, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->471480670]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->810],

Cell["Plot prolate and oblate functions:", "ExampleText",
 CellID->276450701],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"SpheroidalS2", "[", 
    RowBox[{"2", ",", "0", ",", "10", ",", "r"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "1", ",", "5"}], "}"}], ",", 
   RowBox[{"MaxRecursion", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->636762219],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVxXk8FHgfAGAMzYxzzJRre2sd9SKxWzli8/1SjdaRV0il2RyVLefiTdkU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     "]], 
    LineBox[{{1.03185481373093, -0.121919522288186}, {1.03733902552419, 
     0.115565968511935}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.618033988749895],
  Axes->True,
  Method->{},
  PlotRange->{{1, 5}, {-0.121919522288186, 0.115565968511935}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 96},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->738173756]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"SpheroidalS2", "[", 
    RowBox[{"2", ",", "0", ",", 
     RowBox[{
      RowBox[{"-", "10"}], " ", "I"}], ",", 
     RowBox[{"I", " ", "r"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "0", ",", "5"}], "}"}], ",", 
   RowBox[{"MaxRecursion", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->403287750],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVxXk8FGgfAPCRsxnHHI5yhbWJ1WHf7Ec6fo+VV45VibYlYXLsOzHRNiWj
9A4N7U5WZhwNdswKyZWk3Sk8DNaRc23WVW7KVRoTiuz7/vH9fE3p5z2DNxEI
hOD/+f/Z1+gqNkHsQ4Uax4mMAgpWHRyzmN9WCM+Ljpya3XQXxK2iyNltEjD4
5i21auIhxLZau9r418MUV69vjvoESstuDobtaoUW13+PeUmrQUR6Fkdx6oLG
afrGrrRqCIXuO3MXesB+VZXj+UYCjJSrNV3JvXDwfmMP6z8VwJy0HH9U2g8h
rnp/OyflQR1t65195BcQrKx0fAvbE4im8RbDdiMQ+0PN3tn8XNyWYWFZ2zYK
bHPT96m3ynES+ZmVOGAc5D0zkjTeY7wi12J56k5C24LK8nWj3zF90Asrtk0B
OUqxaf16JWZ0zSVLrrwCGkXaHNteiiMb4+nnLWbAaEbfpb86E1Mymwccf5+F
zuCGflsOG8oj1E9scZmH4JHDP3T558KHikVa9ccFYDOfrAXrPgAx+9zMnm/f
Ah5L0E3fXAEpGnt/oZotwlPlc0mJDg+BI1o7vjS3CC1RpTp/CYvBQcJ06at4
B0vkaf/HkAOEnhFUFS0DNbciZocjA/i5uacTPZegdtWs655PJt5+MSTKy0oO
78Mau+2/K8TKtrHTZTI5ZD2LepU6XIon5OknSdXvoSPBJN7PqxSnhyvMeKQv
AxK8JFFdCrDrJONqSuQK9NJOL248SMNtE1e9+pxXIZXQ5m5XfwE8JpK/MDb+
AF4xP74clmaD4V+r3rLJD+BBH999VL8AZurp15tLPsLUWhDhQcR94DEMO29w
1yBresPlHOEe7KL0Gjn6r0NpobP5XWoOGN6bxD9bfgKdk1fUardygQjywCHZ
JyhvuhEdLufiNp73DkrnBgzmpR46pZqDned9ls28CUiL4qzfuZyHyX3+MTW1
BFRe3Nm+fDQf90mDFHysFZDyAMf0mJcY/5Gnvac6WQHtYbjLyixScGViwxkT
uQJ6er9loOTtKdBsyhItB25CTL167dviVAhRZo10dGxCLZQqU5NWMUzsX2kN
36uIbgz8i3Ve9y6cvcCuVBcqIkaWfe/UrBhawnrqitcVUdCAbKBPPwN2h37R
4R6ohCRZdaSivGuwUVU0F9CuhKYGGjiDyVzcSbUmsfYpIz/FCDOKVIgbA77t
OfaLMkLikP1kfzF+WsrJtFZUQb7dHVO3z4uxwaleVkyECrqs4jQzxBBitoLV
sbYXKmjsoZNO0TQXS5me7kYuquin/ZfJQ7mXgDgUfYT5SBXZKevzI7sFEOXg
scDdoob+3nMpO2MyGybzTQWiGDXUnJKznaaXA1WhRu7Wr9UQ8+BR5pl8IQh2
bFWSeG9GT6oY12bGeZAyioM1nm5GXwY0DkfvJeJkYUhToAkRkTNL7EsO8zBL
b8z1tzgicqv+0XtfTAb2Efh1qE8TkVknN7LuQDYuDFMI6vUkIe2mufRKzUy8
cjhvVVRDQlX9utNC5RTM1Fmys/lMHYVR5s2ifS7h8cmvo6QJ6ijJ4B3/tVEs
SClPWpqW1NHu/T3c08/58OtBG4P2QA20oL4+augjhHuBJ3SFTRqoMvCT1jZV
IZTcYFFCd2qiMu8kk6zHfBCGh+2yva2JXjYUGP/G5kCC91k3RbkmKux1txlx
+R6/zOBEOwVqoUKnNeL700nYdkhcmNCuhbIquiM9yem4n/RV3ZGtZHQ28er3
Ez0ZOMMys6TdjYyKI880W4wKsDpLO5fHISO6a3yZTw0Xx9beynCTkBHrkG3r
6HceMBW+aEx6Q0ZGcarpx7RuwjcG3nmt5hQUXrAsUxcKoOlwEmHhJAW9KPvq
1693poMDs8mXcpOC7OmTr90uCiCiUbuWiSmoujh0e2dDIogM6eZtcgoS2b3o
PRB8AsbexPvd2kFFJbk6QZblHGxeX5Dm4UtF+R7t5Km429hn5VEA+RYVyXar
ff6QkYqTd0qt/qyhIt/LI3ZjFwSYnTy+3r5ERT/537ENSeLhEJlSd4sVDTke
v+7osBSJg/78GGXpR0MMpeGWgycvAb38ncnNn2lIJPnM9JUvD3Rq1rvN/qCh
5xOXD5in8aG5VS2uao2GTC9mfJjP4oPjsN6hM59o6Kjsv8Z2CXyokW1f3dig
oSu8lkznCD78A9kSD1Y=
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.618033988749895],
  Axes->True,
  Method->{},
  PlotRange->{{0, 5}, {-0.0942001917928181, 0.116246514551942}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 96},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->532517882]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16874],

Cell[TextData[{
 "Spheroidal functions do not evaluate for half-integer values of ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " and generic values of ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->348355882],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SpheroidalS2", "[", 
  RowBox[{
   RowBox[{"3", "/", "2"}], ",", "1", ",", "1", ",", "0.5"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->175415402],

Cell[BoxData[
 RowBox[{"SpheroidalS2", "[", 
  RowBox[{
   FractionBox["3", "2"], ",", "1", ",", "1", ",", "0.5`"}], "]"}]], "Output",\

 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{182, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->97597265]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14771],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SpheroidalS1",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SpheroidalS1"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SphericalBesselY",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SphericalBesselY"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SpheroidalRadialFactor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SpheroidalRadialFactor"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17958]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->9246],

Cell[TextData[ButtonBox["Spheroidal Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpheroidalFunctions"]], "Tutorials",
 CellID->12303]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->325725897],

Cell[TextData[ButtonBox["Spheroidal and Related Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpheroidalAndRelatedFunctions"]], "MoreAbout",
 CellID->118621446],

Cell[TextData[ButtonBox["New in 6.0: Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicalFunctions"]], "MoreAbout",
 CellID->376349821]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SpheroidalS2 - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 23, 35.8432992}", "context" -> "System`", 
    "keywords" -> {"spheroidal functions", "spheroidal harmonics"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "SpheroidalS2[n, m, \\[Gamma], z] gives the radial spheroidal function \
SubsuperscriptBox[S, n, m, (2)](\\[Gamma], z) of the second kind.", 
    "synonyms" -> {"spheroidal s2"}, "title" -> "SpheroidalS2", "type" -> 
    "Symbol", "uri" -> "ref/SpheroidalS2"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8066, 254, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->322881978]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 25340, 816}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2286, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2909, 83, 1577, 37, 70, "ObjectNameGrid"],
Cell[4489, 122, 894, 28, 70, "Usage",
 CellID->14127]
}, Open  ]],
Cell[CellGroupData[{
Cell[5420, 155, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5898, 172, 120, 4, 70, "Notes",
 CellID->20640],
Cell[6021, 178, 1222, 40, 70, "Notes",
 CellID->10593],
Cell[7246, 220, 342, 11, 70, "Notes",
 CellID->16544],
Cell[7591, 233, 226, 7, 70, "Notes",
 CellID->31226],
Cell[7820, 242, 209, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[8066, 254, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->322881978],
Cell[CellGroupData[{
Cell[8451, 268, 148, 5, 70, "ExampleSection",
 CellID->308448091],
Cell[8602, 275, 63, 1, 70, "ExampleText",
 CellID->45503221],
Cell[CellGroupData[{
Cell[8690, 280, 153, 4, 28, "Input",
 CellID->416581269],
Cell[8846, 286, 256, 7, 36, "Output",
 CellID->257320837]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9151, 299, 216, 7, 70, "ExampleSection",
 CellID->25831],
Cell[9370, 308, 88, 1, 70, "ExampleText",
 CellID->94393633],
Cell[CellGroupData[{
Cell[9483, 313, 182, 5, 70, "Input",
 CellID->314925903],
Cell[9668, 320, 383, 12, 36, "Output",
 CellID->99290271]
}, Open  ]],
Cell[10066, 335, 125, 3, 70, "ExampleDelimiter",
 CellID->217504807],
Cell[10194, 340, 70, 1, 70, "ExampleText",
 CellID->283569038],
Cell[CellGroupData[{
Cell[10289, 345, 234, 8, 70, "Input",
 CellID->852018633],
Cell[10526, 355, 301, 10, 36, "Output",
 CellID->383193846]
}, Open  ]],
Cell[10842, 368, 123, 3, 70, "ExampleDelimiter",
 CellID->3535261],
Cell[10968, 373, 113, 3, 70, "ExampleText",
 CellID->173158339],
Cell[CellGroupData[{
Cell[11106, 380, 206, 6, 70, "Input",
 CellID->429954945],
Cell[11315, 388, 284, 9, 36, "Output",
 CellID->388589798]
}, Open  ]],
Cell[11614, 400, 125, 3, 70, "ExampleDelimiter",
 CellID->165479942],
Cell[11742, 405, 232, 8, 70, "ExampleText",
 CellID->160938561],
Cell[CellGroupData[{
Cell[11999, 417, 315, 10, 70, "Input",
 CellID->10306910],
Cell[12317, 429, 587, 21, 85, "Output",
 CellID->798299319]
}, Open  ]],
Cell[12919, 453, 125, 3, 70, "ExampleDelimiter",
 CellID->728648831],
Cell[13047, 458, 204, 7, 70, "ExampleText",
 CellID->558624730],
Cell[CellGroupData[{
Cell[13276, 469, 198, 6, 70, "Input",
 CellID->261657998],
Cell[13477, 477, 674, 16, 70, "Output",
 Evaluatable->False,
 CellID->471480670]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14200, 499, 221, 7, 70, "ExampleSection",
 CellID->810],
Cell[14424, 508, 77, 1, 70, "ExampleText",
 CellID->276450701],
Cell[CellGroupData[{
Cell[14526, 513, 319, 9, 70, "Input",
 CellID->636762219],
Cell[14848, 524, 2759, 54, 117, "Output",
 CellID->738173756]
}, Open  ]],
Cell[CellGroupData[{
Cell[17644, 583, 393, 12, 70, "Input",
 CellID->403287750],
Cell[18040, 597, 2700, 53, 117, "Output",
 CellID->532517882]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20789, 656, 226, 7, 70, "ExampleSection",
 CellID->16874],
Cell[21018, 665, 284, 9, 70, "ExampleText",
 CellID->348355882],
Cell[CellGroupData[{
Cell[21327, 678, 179, 6, 70, "Input",
 CellID->175415402],
Cell[21509, 686, 314, 11, 51, "Output",
 CellID->97597265]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21884, 704, 311, 9, 70, "SeeAlsoSection",
 CellID->14771],
Cell[22198, 715, 748, 26, 70, "SeeAlso",
 CellID->17958]
}, Open  ]],
Cell[CellGroupData[{
Cell[22983, 746, 313, 9, 70, "TutorialsSection",
 CellID->9246],
Cell[23299, 757, 150, 3, 70, "Tutorials",
 CellID->12303]
}, Open  ]],
Cell[CellGroupData[{
Cell[23486, 765, 319, 9, 70, "MoreAboutSection",
 CellID->325725897],
Cell[23808, 776, 173, 3, 70, "MoreAbout",
 CellID->118621446],
Cell[23984, 781, 174, 3, 70, "MoreAbout",
 CellID->376349821]
}, Open  ]],
Cell[24173, 787, 27, 0, 70, "History"],
Cell[24203, 789, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

