(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     38482,       1375]
NotebookOptionsPosition[     31473,       1128]
NotebookOutlinePosition[     32904,       1167]
CellTagsIndexPosition[     32818,       1162]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Partitioning and Padding Lists" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PartitioningAndPaddingLists"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Partitioning and Padding Lists\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Partition" :> Documentation`HelpLookup["paclet:ref/Partition"],
           "StringSplit" :> 
          Documentation`HelpLookup["paclet:ref/StringSplit"], "FindClusters" :> 
          Documentation`HelpLookup["paclet:ref/FindClusters"], "Union" :> 
          Documentation`HelpLookup["paclet:ref/Union"], "Flatten" :> 
          Documentation`HelpLookup["paclet:ref/Flatten"], "ReplaceList" :> 
          Documentation`HelpLookup["paclet:ref/ReplaceList"], "Tally" :> 
          Documentation`HelpLookup["paclet:ref/Tally"], "BinLists" :> 
          Documentation`HelpLookup["paclet:ref/BinLists"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Partition\"\>", 
       2->"\<\"StringSplit\"\>", 3->"\<\"FindClusters\"\>", 
       4->"\<\"Union\"\>", 5->"\<\"Flatten\"\>", 6->"\<\"ReplaceList\"\>", 
       7->"\<\"Tally\"\>", 8->"\<\"BinLists\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Discrete & Integer Data" :> 
          Documentation`HelpLookup["paclet:guide/DiscreteAndIntegerData"], 
          "List Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/ListManipulation"], 
          "Rearranging & Restructuring Lists" :> 
          Documentation`HelpLookup[
           "paclet:guide/RearrangingAndRestructuringLists"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Discrete & Integer Data\"\>", 
       2->"\<\"List Manipulation\"\>", 
       3->"\<\"Rearranging & Restructuring Lists\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Split", "ObjectName",
 CellID->1605],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Split",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Split"], "[", 
       StyleBox["list", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]splits ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " into sublists consisting of runs of identical elements. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Split",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Split"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["test", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]treats pairs of adjacent elements as identical whenever \
applying the function ",
     Cell[BoxData[
      StyleBox["test", "TI"]], "InlineFormula"],
     " to them yields ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->17131]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The default function used to test whether elements are identical is ",
 Cell[BoxData[
  ButtonBox["SameQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SameQ"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->31594],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Split",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Split"]], "InlineFormula"],
 " can be used to perform run\[Hyphen]length encoding. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->20629,
  ButtonNote->"20629"]
}], "Notes",
 CellID->6030]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->101954275],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->245139816],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Split", "[", 
  RowBox[{"{", 
   RowBox[{
   "a", ",", "a", ",", "a", ",", "b", ",", "b", ",", "a", ",", "a", ",", 
    "c"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10545],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "a", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "a"}], "}"}], ",", 
   RowBox[{"{", "c", "}"}]}], "}"}]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20392]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19607],

Cell["Split based on first elements:", "ExampleText",
 CellID->19368],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Split", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "a"}], ",", 
     RowBox[{"1", "\[Rule]", "b"}], ",", 
     RowBox[{"2", "\[Rule]", "a"}], ",", 
     RowBox[{"2", "\[Rule]", "c"}], ",", 
     RowBox[{"3", "\[Rule]", "a"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"First", "[", "#1", "]"}], "===", 
     RowBox[{"First", "[", "#2", "]"}]}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14348],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "a"}], ",", 
     RowBox[{"1", "\[Rule]", "b"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", "\[Rule]", "a"}], ",", 
     RowBox[{"2", "\[Rule]", "c"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", "\[Rule]", "a"}], "}"}]}], "}"}]], "Output",
 ImageSize->{255, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24391]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26835],

Cell["Split at jumps:", "ExampleText",
 CellID->16680],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Split", "[", 
  RowBox[{
   RowBox[{"Array", "[", 
    RowBox[{"Prime", ",", "20"}], "]"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"#2", "-", "#1"}], "<", "4"}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16685],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "5", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "13"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", "19"}], "}"}], ",", 
   RowBox[{"{", "23", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"29", ",", "31"}], "}"}], ",", 
   RowBox[{"{", "37", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"41", ",", "43"}], "}"}], ",", 
   RowBox[{"{", "47", "}"}], ",", 
   RowBox[{"{", "53", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"59", ",", "61"}], "}"}], ",", 
   RowBox[{"{", "67", "}"}], ",", 
   RowBox[{"{", "71", "}"}]}], "}"}]], "Output",
 ImageSize->{396, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11840]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->18190],

Cell["\<\
Split so that in each sublist successive elements are not the same:\
\>", "ExampleText",
 CellID->9794],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Split", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "a", ",", "a", ",", "a", ",", "b", ",", "a", ",", "b", ",", "b", ",", "a",
      ",", "a", ",", "a", ",", "c", ",", "a"}], "}"}], ",", "UnsameQ"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28354],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "a", "}"}], ",", 
   RowBox[{"{", "a", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "a"}], "}"}], ",", 
   RowBox[{"{", "a", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "c", ",", "a"}], "}"}]}], "}"}]], "Output",
 ImageSize->{310, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->31261]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->289200437],

Cell[TextData[{
 "Split after every occurrence of ",
 Cell[BoxData["a"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->225274378],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Split", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "a", ",", "b", ",", "a", ",", "b", ",", "c", ",", "d", ",", "a", ",", 
     "a"}], "}"}], ",", 
   RowBox[{
    RowBox[{"#", "=!=", "a"}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4621533],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "a", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c", ",", "d", ",", "a"}], "}"}], ",", 
   RowBox[{"{", "a", "}"}]}], "}"}]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20007742]
}, Open  ]],

Cell[TextData[{
 "Split before every occurrence of ",
 Cell[BoxData["a"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->44493674],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Split", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "a", ",", "b", ",", "a", ",", "b", ",", "c", ",", "d", ",", "a", ",", 
     "a"}], "}"}], ",", 
   RowBox[{
    RowBox[{"#2", "=!=", "a"}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->98602439],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", "a", "}"}], ",", 
   RowBox[{"{", "a", "}"}]}], "}"}]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->321364457]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5022],

Cell["Group together identical elements:", "ExampleText",
 CellID->19232],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Split", "[", 
  RowBox[{"Sort", "[", 
   RowBox[{"{", 
    RowBox[{
    "a", ",", "a", ",", "a", ",", "b", ",", "b", ",", "a", ",", "a", ",", "c",
      ",", "c", ",", "c"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26347],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "a", ",", "a", ",", "a", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "c", ",", "c"}], "}"}]}], "}"}]], "Output",
 ImageSize->{231, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2567]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17640],

Cell["Run-length encoding:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->20629],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"First", "[", "#", "]"}], ",", 
     RowBox[{"Length", "[", "#", "]"}]}], "}"}], "&"}], "/@", 
  RowBox[{"Split", "[", 
   RowBox[{"{", 
    RowBox[{
    "a", ",", "a", ",", "a", ",", "b", ",", "b", ",", "a", ",", "a", ",", "c",
      ",", "c", ",", "c"}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15823],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "3"}], "}"}]}], "}"}]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13773]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->436563425],

Cell["\<\
Group equivalence classes according to an equivalence function:\
\>", "ExampleText",
 CellID->342161609],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "=", "Round"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"x", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"5", ",", "20"}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->659227528],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Split", "[", 
  RowBox[{
   RowBox[{"SortBy", "[", 
    RowBox[{"x", ",", "f"}], "]"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", "#1", "]"}], "===", 
     RowBox[{"f", "[", "#2", "]"}]}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->115633723],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.27142398146126956`", ",", "0.3186563348223381`"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{
    "0.5657652927223678`", ",", "1.165394066118669`", ",", 
     "1.2706595352249328`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1.6468737863164118`", ",", "1.6590610882111123`", ",", 
     "1.9870438366800658`", ",", "2.1147020149970794`", ",", 
     "2.297268776882758`"}], "}"}], ",", 
   RowBox[{"{", "2.724287842140881`", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "3.7717890801135368`", ",", "4.237654696684833`", ",", 
     "4.3716500151137385`", ",", "4.379561277019621`", ",", 
     "4.398298717008786`", ",", "4.423133823674114`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "4.61199465985087`", ",", "4.798201751701235`", ",", 
     "4.85509163772532`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{563, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2437810]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->68077607],

Cell["\<\
Distribution of lengths of runs of 0s or 1s in the first million bits of \
\[Pi]:\
\>", "ExampleText",
 CellID->205572028],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tally", "[", 
  RowBox[{"Map", "[", 
   RowBox[{"Length", ",", " ", 
    RowBox[{"Split", "[", 
     RowBox[{"First", "[", 
      RowBox[{"RealDigits", "[", 
       RowBox[{"\[Pi]", ",", "2", ",", 
        RowBox[{"10", "^", "6"}]}], "]"}], "]"}], "]"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->126950023],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "125330"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "249292"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "31081"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "7730"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "62641"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "3970"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "15635"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "1919"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "512"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "968"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "241"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"14", ",", "44"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "70"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "127"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"15", ",", "19"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"18", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"20", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{501, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->390865394]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->312486194],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1WDtv01AUdmInIAXxUJBAQEuSjW7dyqMiEgK6oE4oW1BUUdqhDSrtVraM
YYKFgpiAP0AFP4AFJlZm/oi5r+TcfDk+seM4Uuyc6++8vvNdO8mT3uHO873e
4e5Wr/H4oPdyZ3frVeNR/0AthaUgCE7Vu381UJ9j9cm8T+NYnf3jHXUM1aWm
O5fVuazON50dRAbmXsvKiDxUaC6u66MGx+ZlfIOIbIv3EUtgh2Df0IeKtcdH
E0U3VtLngjIvsRGKzrrs2Xyndx3jrXS5COH8mqky+HGa6TJV/EyBU05Q9f2S
eLznamvEpKaR9spOemWnOv+6Vd20lq9AfSfs6ltjf/n85/76+zfDn07gl9Xx
06jHKZ9zM+xKRnyU038Wvmbs37/+qaUf3/+6HrGrd2CHGVjMvzqAOdQFVOfp
V4V6+OBjAuoYYlVG/ff3v+n+JS+KfV1AUSweJXWup+HfW3F6FmVmKO43tI+g
61auOMRDljjaPAKG5q1jXh6IZf8uwbOME9oDDlcEFDEkoYgHHpV/52xDzasC
imomlGbnBdTKx+DzdyH/bYOqxpMqT5pDF+qy3mfEqQcpVNCFjvLE1ebJgurq
AFvthcYlHhcbl3hsj6eLz+D0u4xf3QRmNgQU9SmhqGoelaW6DahuU0BRdRKK
quNRto7Jb9y4m2Tey5mmn0YNbWChU2ge4nGRebTZhgkU1UdRc3DaCEkbqIgk
ZazBBJ+x2lsD/iUUscij8j/hVqHmbQFFNUsoqplH2Toq8eQzrMaiquJ09cez
YN+CfvZzxaGOs8TR/awAF6L/1C+70RNeZIH14pn2Vat9I0a9LWDOfNcMznso
LkcLeLJeF1wuHk2sTKP1+YNZvQi++EuO1/M16OK1gKKqJRRVy6Py78E61DwY
z03aIXXoYSBpRVB6HbqcN06WHTtT2/79mtFRDRgbpsyNNv47VANOh+NJSPd9
PgoxaqNcmuFl+UjaOXTVX8VKIuDF/ANjdhJXdwTdWjSqM4JueJR7apb+AzTF
9cg=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 111},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->195817612]
}, Open  ]],

Cell["\<\
Distribution of lengths of runs of 0s or 1s in one million pseudorandom bits:\
\
\>", "ExampleText",
 CellID->484483942],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{"Tally", "[", 
   RowBox[{"Map", "[", 
    RowBox[{"Length", ",", " ", 
     RowBox[{"Split", "[", 
      RowBox[{"RandomInteger", "[", 
       RowBox[{"1", ",", 
        RowBox[{"10", "^", "6"}]}], "]"}], "]"}]}], "]"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->57214932],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWD1PFFEUnd2ZQSJE0GwCBYm4LBbGitjxVQBaKJUaC2k2GxKIQQgflbGi
VCpjAZjYqH9AIj+ABipba//I832x983hcp3ZHWLcZOfNfXPufeeee98blsXm
9sryWnN7tdUcfbTZ3FhZbW2NPlzf1FNxJYqiI/3dGI70vdJ39nuklB7D65S+
xvpRw49VPVb1eMfbUWJh/lO3xqy5mofKftxsQraLEiJugx1zz/+7uNNeq/F8
8Qjh/ertKCG2kS9aGkYztRmz44yPPebHWFE9q76c53a2E9x1CNY6YGc/Wvvr
l5+z0/t7708cw6imr581qML6pCXb42DfBXvE2menv9dffz/+8ctzzJcfP7sH
WV8XUC+ef9OohblPIorY8agi7GjW1PeQxbyFDFKwbwlelFEKtuRFGaZg814u
iz6VPY2w9g7Vr/62U9Au4mfMHdCn3uG6O6BYd3FIw07jkMrhGcGrXE5PhrNr
oOo9AUWaSShShEfxPJaBx4SAIh4Sing4VI/K9rGs9DWxjlHuuv7bOMZcAmUn
S+K1BLUoNy5Vb7JdvbBqV7dPnoFecwKKspdQlAuPyr4tFmH9x6zPE1hfQtH6
PMqtn/3rEneJrHe1UNXzd335cedB3aclrmPMeahLmfEv5kGVvap1fG/E1BvY
EcV24hTo/1JAkYoSijTgUUX2/gNg1xJQxE5CETseJbFLVfaN1ceiesSam9te
sO9Dlq+6ikM6dBeHlBLjXPitdf5eF9VgvXjFw542vgnT2w1QcMt63whQ3BoN
0Mt5Dfi1eDSpIqMd/0GYTVgUdtsIZPNGQBF7CUWsCXX5LyGeVQ1Y7bYrJO2J
GrDclbpC6Mka5NFpnE73aB4/e37n3QHCGY//UekH5d+1lZfOez4KVcJFuZnL
i3R3XnLXD8As/yYavIR3Atl+UFw3JpCNhCL2PMq/Uyt/AIdGg4I=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->382094720]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32129],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Flatten",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Flatten"]], "InlineFormula"],
 " acts an inverse of ",
 Cell[BoxData[
  ButtonBox["Split",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Split"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->2894],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Split", "[", 
  RowBox[{"{", 
   RowBox[{
   "a", ",", "a", ",", "a", ",", "b", ",", "b", ",", "a", ",", "a", ",", "c", 
    ",", "c", ",", "c"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5974],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "a", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "c", ",", "c"}], "}"}]}], "}"}]], "Output",
 ImageSize->{245, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->26213]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Flatten", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->9589],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "a", ",", "a", ",", "a", ",", "b", ",", "b", ",", "a", ",", "a", ",", "c", 
   ",", "c", ",", "c"}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->4728]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12974],

Cell["\<\
Find runs of numbers in base 10 that contain the same number of 1s:\
\>", "ExampleText",
 CellID->7334],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Split", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"DigitCount", "[", 
     RowBox[{"n", ",", "10", ",", "1"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "50"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19257],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWu9OwjAQ75gIYvijUWPUDzyDD6GffIiFmMAHo0GeSfigvuLcbULMjxvX
re3moCSM3u3W6/167doffYoW0+eXaDGbROPHefQ2nU3exw+v80QVBkoFS6XU
/bVKynFSSr/0WSXfrJiVTukaru/G6gTkI5B7gv3QUB4ZPl+0vWgv4fHf4gvp
shUlRkFWLbVt1/vVj4Tfsx16HT957UG97fYgWi0WLdK2ExGtUe4yUZDYBn3H
sb7ruH4pbl28cOwcCl58lklokUw5jKiltbU3clq32lh3arrbrcGvDlq6KHNz
gEdZQi/LbMQcxwPKfZBD1nffkXbgqF4pSgmVwUGgghkUxGXmRlwF8aO1aVhJ
UUqo4FpyP1Gx83b1GcTJPoN8BvkM8hnkM6ieDEL+g7S0OsdVFPIaZEfiUPgd
CfexVZwfrj3nFbWHZ7uoiDxm8ZJrpq8o82fKXNq2N2UqTZlPbO8lXUozmMgc
mjKXpoxrHoMpMZ157b5i0clj6o5r0ncK2pdlYG0xmLr+XDOMrplNjPsi5rKp
CAdXhZ5rny4nWIxpLevFzGtdDGBdvCSHVjbrS4xj1e/qcgynKWOo58XVitbV
+hmjvIl15p66V2d6eznTvZGel6b1OEZ5G/se9z3ue3yXF9/jZWTf43X3eB7D
VXS/vpZ1mbGyzFZefRJzJTFc2J67FB0qmjNZUr417Uxf1UzYMkUxFKxcn6mr
ipFaaUV7qGfiXDFHus99aPWOG65h/9kE95wN93Q2v7QEX/t+iso2+8FxyH/l
z9jGSGr6f7a216qS/ZdH3QHqOBYQX4+6C9RxRsEZ3KPuAnW9d2uGvVR3Vecp
bO82sb7vNFoq6uwHVfADssEZrg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{423, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->823090390]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12903],

Cell[TextData[{
 "Iterated run-length encoding ",
 ButtonBox["[more info]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/page-905e-text]"], None}],
 ": "
}], "ExampleText",
 CellID->13171],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Length", "[", "#", "]"}], ",", 
         RowBox[{"First", "[", "#", "]"}]}], "}"}], "&"}], "/@", 
      RowBox[{"Split", "[", "#", "]"}]}], "]"}], "&"}], ",", 
   RowBox[{"{", "1", "}"}], ",", "8"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2091],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "2", ",", "2", ",", "1"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1", ",", "2", ",", "2", ",", "1", ",", "1"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "3", ",", "1", ",", "1", ",", "2", ",", "2", ",", "2", ",", 
     "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "1", ",", "1", ",", "3", ",", "2", ",", "1", ",", "3", ",", "2",
      ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "3", ",", "1", ",", "1", ",", "3", ",", "1", ",", "2", ",", "1", ",", "1",
      ",", "1", ",", "3", ",", "1", ",", "2", ",", "2", ",", "1"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{472, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->149982114]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31068],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Partition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Partition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringSplit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringSplit"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindClusters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindClusters"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Union",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Union"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Flatten",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Flatten"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReplaceList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReplaceList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Tally",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tally"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BinLists",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinLists"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13236]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->32620],

Cell[TextData[ButtonBox["Partitioning and Padding Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PartitioningAndPaddingLists"]], "Tutorials",
 CellID->11104]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->49437418],

Cell[TextData[ButtonBox["Discrete & Integer Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteAndIntegerData"]], "MoreAbout",
 CellID->323495090],

Cell[TextData[ButtonBox["List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListManipulation"]], "MoreAbout",
 CellID->616210644],

Cell[TextData[ButtonBox["Rearranging & Restructuring Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RearrangingAndRestructuringLists"]], "MoreAbout",
 CellID->693982416]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Split"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Split - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 23, 37.1714582}", "context" -> "System`", 
    "keywords" -> {
     "encoding", "lists", "run-length encoding", "group list elements", 
      "grouping", "runs of elements"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Split[list] splits list into sublists consisting of runs of identical \
elements. Split[list, test] treats pairs of adjacent elements as identical \
whenever applying the function test to them yields True. ", "synonyms" -> {}, 
    "title" -> "Split", "type" -> "Symbol", "uri" -> "ref/Split"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5819, 179, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->101954275]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 32675, 1155}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2838, 63, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3461, 90, 42, 1, 70, "ObjectName",
 CellID->1605],
Cell[3506, 93, 1203, 38, 70, "Usage",
 CellID->17131]
}, Open  ]],
Cell[CellGroupData[{
Cell[4746, 136, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5224, 153, 236, 8, 70, "Notes",
 CellID->31594],
Cell[5463, 163, 319, 11, 70, "Notes",
 CellID->6030]
}, Closed]],
Cell[CellGroupData[{
Cell[5819, 179, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->101954275],
Cell[CellGroupData[{
Cell[6204, 193, 148, 5, 70, "ExampleSection",
 CellID->245139816],
Cell[CellGroupData[{
Cell[6377, 202, 213, 7, 28, "Input",
 CellID->10545],
Cell[6593, 211, 401, 14, 36, "Output",
 CellID->20392]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7043, 231, 239, 7, 70, "ExampleSection",
 CellID->19607],
Cell[7285, 240, 69, 1, 70, "ExampleText",
 CellID->19368],
Cell[CellGroupData[{
Cell[7379, 245, 477, 15, 70, "Input",
 CellID->14348],
Cell[7859, 262, 491, 17, 36, "Output",
 CellID->24391]
}, Open  ]],
Cell[8365, 282, 121, 3, 70, "ExampleDelimiter",
 CellID->26835],
Cell[8489, 287, 54, 1, 70, "ExampleText",
 CellID->16680],
Cell[CellGroupData[{
Cell[8568, 292, 255, 9, 70, "Input",
 CellID->16685],
Cell[8826, 303, 774, 25, 54, "Output",
 CellID->11840]
}, Open  ]],
Cell[9615, 331, 121, 3, 70, "ExampleDelimiter",
 CellID->18190],
Cell[9739, 336, 113, 3, 70, "ExampleText",
 CellID->9794],
Cell[CellGroupData[{
Cell[9877, 343, 289, 9, 70, "Input",
 CellID->28354],
Cell[10169, 354, 489, 16, 36, "Output",
 CellID->31261]
}, Open  ]],
Cell[10673, 373, 125, 3, 70, "ExampleDelimiter",
 CellID->289200437],
Cell[10801, 378, 134, 5, 70, "ExampleText",
 CellID->225274378],
Cell[CellGroupData[{
Cell[10960, 387, 288, 10, 70, "Input",
 CellID->4621533],
Cell[11251, 399, 389, 13, 36, "Output",
 CellID->20007742]
}, Open  ]],
Cell[11655, 415, 134, 5, 70, "ExampleText",
 CellID->44493674],
Cell[CellGroupData[{
Cell[11814, 424, 290, 10, 70, "Input",
 CellID->98602439],
Cell[12107, 436, 390, 13, 36, "Output",
 CellID->321364457]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12546, 455, 222, 7, 70, "ExampleSection",
 CellID->5022],
Cell[12771, 464, 73, 1, 70, "ExampleText",
 CellID->19232],
Cell[CellGroupData[{
Cell[12869, 469, 268, 8, 70, "Input",
 CellID->26347],
Cell[13140, 479, 396, 13, 36, "Output",
 CellID->2567]
}, Open  ]],
Cell[13551, 495, 121, 3, 70, "ExampleDelimiter",
 CellID->17640],
Cell[13675, 500, 107, 2, 70, "ExampleText",
 CellID->20629],
Cell[CellGroupData[{
Cell[13807, 506, 399, 13, 70, "Input",
 CellID->15823],
Cell[14209, 521, 416, 15, 36, "Output",
 CellID->13773]
}, Open  ]],
Cell[14640, 539, 125, 3, 70, "ExampleDelimiter",
 CellID->436563425],
Cell[14768, 544, 114, 3, 70, "ExampleText",
 CellID->342161609],
Cell[14885, 549, 248, 8, 70, "Input",
 CellID->659227528],
Cell[CellGroupData[{
Cell[15158, 561, 293, 10, 70, "Input",
 CellID->115633723],
Cell[15454, 573, 1010, 29, 71, "Output",
 CellID->2437810]
}, Open  ]],
Cell[16479, 605, 124, 3, 70, "ExampleDelimiter",
 CellID->68077607],
Cell[16606, 610, 132, 4, 70, "ExampleText",
 CellID->205572028],
Cell[CellGroupData[{
Cell[16763, 618, 350, 11, 70, "Input",
 CellID->126950023],
Cell[17116, 631, 1357, 45, 71, "Output",
 CellID->390865394]
}, Open  ]],
Cell[CellGroupData[{
Cell[18510, 681, 107, 3, 70, "Input",
 CellID->312486194],
Cell[18620, 686, 1254, 25, 70, "Output",
 Evaluatable->False,
 CellID->195817612]
}, Open  ]],
Cell[19889, 714, 130, 4, 70, "ExampleText",
 CellID->484483942],
Cell[CellGroupData[{
Cell[20044, 722, 344, 11, 70, "Input",
 CellID->57214932],
Cell[20391, 735, 1180, 23, 70, "Output",
 Evaluatable->False,
 CellID->382094720]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21620, 764, 233, 7, 70, "ExampleSection",
 CellID->32129],
Cell[21856, 773, 309, 12, 70, "ExampleText",
 CellID->2894],
Cell[CellGroupData[{
Cell[22190, 789, 232, 7, 70, "Input",
 CellID->5974],
Cell[22425, 798, 436, 15, 36, "Output",
 CellID->26213]
}, Open  ]],
Cell[CellGroupData[{
Cell[22898, 818, 98, 3, 70, "Input",
 CellID->9589],
Cell[22999, 823, 286, 9, 36, "Output",
 CellID->4728]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23334, 838, 224, 7, 70, "ExampleSection",
 CellID->12974],
Cell[23561, 847, 113, 3, 70, "ExampleText",
 CellID->7334],
Cell[CellGroupData[{
Cell[23699, 854, 281, 9, 70, "Input",
 CellID->19257],
Cell[23983, 865, 1094, 22, 70, "Output",
 Evaluatable->False,
 CellID->823090390]
}, Open  ]],
Cell[25092, 890, 121, 3, 70, "ExampleDelimiter",
 CellID->12903],
Cell[25216, 895, 234, 8, 70, "ExampleText",
 CellID->13171],
Cell[CellGroupData[{
Cell[25475, 907, 432, 14, 70, "Input",
 CellID->2091],
Cell[25910, 923, 1094, 33, 71, "Output",
 CellID->149982114]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[27065, 963, 311, 9, 70, "SeeAlsoSection",
 CellID->31068],
Cell[27379, 974, 1929, 71, 70, "SeeAlso",
 CellID->13236]
}, Open  ]],
Cell[CellGroupData[{
Cell[29345, 1050, 314, 9, 70, "TutorialsSection",
 CellID->32620],
Cell[29662, 1061, 168, 3, 70, "Tutorials",
 CellID->11104]
}, Open  ]],
Cell[CellGroupData[{
Cell[29867, 1069, 318, 9, 70, "MoreAboutSection",
 CellID->49437418],
Cell[30188, 1080, 157, 3, 70, "MoreAbout",
 CellID->323495090],
Cell[30348, 1085, 145, 3, 70, "MoreAbout",
 CellID->616210644],
Cell[30496, 1090, 177, 3, 70, "MoreAbout",
 CellID->693982416]
}, Open  ]],
Cell[CellGroupData[{
Cell[30710, 1098, 305, 8, 70, "RelatedLinksSection"],
Cell[31018, 1108, 383, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[31416, 1124, 27, 0, 70, "History"],
Cell[31446, 1126, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

