(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     44233,       1655]
NotebookOptionsPosition[     34488,       1313]
NotebookOutlinePosition[     35886,       1351]
CellTagsIndexPosition[     35800,       1346]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integer and Number\[Hyphen]Theoretical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"], 
          "Algebraic Operations on Polynomials" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AlgebraicOperationsOnPolynomials"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Integer and Number\[Hyphen]Theoretical Functions\"\>", 
       2->"\<\"Algebraic Operations on Polynomials\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FactorInteger" :> 
          Documentation`HelpLookup["paclet:ref/FactorInteger"], "Factor" :> 
          Documentation`HelpLookup["paclet:ref/Factor"], "FactorSquareFree" :> 
          Documentation`HelpLookup["paclet:ref/FactorSquareFree"], 
          "PolynomialGCD" :> 
          Documentation`HelpLookup["paclet:ref/PolynomialGCD"], 
          "Discriminant" :> 
          Documentation`HelpLookup["paclet:ref/Discriminant"], "PrimeQ" :> 
          Documentation`HelpLookup["paclet:ref/PrimeQ"], "PrimePowerQ" :> 
          Documentation`HelpLookup["paclet:ref/PrimePowerQ"], "MoebiusMu" :> 
          Documentation`HelpLookup["paclet:ref/MoebiusMu"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"FactorInteger\"\>", 
       2->"\<\"Factor\"\>", 3->"\<\"FactorSquareFree\"\>", 
       4->"\<\"PolynomialGCD\"\>", 5->"\<\"Discriminant\"\>", 
       6->"\<\"PrimeQ\"\>", 7->"\<\"PrimePowerQ\"\>", 
       8->"\<\"MoebiusMu\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Number Recognition" :> 
          Documentation`HelpLookup["paclet:guide/NumberRecognition"], 
          "Number Theoretic Functions" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheoreticFunctions"], 
          "Polynomial Factoring & Decomposition" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialFactoring"], 
          "Prime Numbers" :> 
          Documentation`HelpLookup["paclet:guide/PrimeNumbers"], 
          "New in 6.0: Symbolic Computation" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60AlgebraicComputing"], 
          "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"], 
          "New in 6.0: Number Theory & Integer Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Number Recognition\"\>", 
       2->"\<\"Number Theoretic Functions\"\>", 
       3->"\<\"Polynomial Factoring & Decomposition\"\>", 
       4->"\<\"Prime Numbers\"\>", 
       5->"\<\"New in 6.0: Symbolic Computation\"\>", 
       6->"\<\"New in 6.0: Mathematics & Algorithms\"\>", 
       7->"\<\"New in 6.0: Number Theory & Integer Functions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["SquareFreeQ", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SquareFreeQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SquareFreeQ"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is a square-free polynomial or number, and ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SquareFreeQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SquareFreeQ"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["vars", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is square-free with respect to the variables ",
     Cell[BoxData[
      StyleBox["vars", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "For integers ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SquareFreeQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SquareFreeQ"], "[", 
   RowBox[{
    StyleBox["m", "TI"], "+", 
    RowBox[{
     ButtonBox["I",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/I"], " ", 
     StyleBox["n", "TI"]}]}], 
   StyleBox["]", "TI"]}]], "InlineFormula"],
 " automatically works over the Gaussian integers."
}], "Notes",
 CellID->25182],

Cell["The following options can be given:", "Notes",
 CellID->81386831],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["GaussianIntegers",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/GaussianIntegers"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether to allow Gaussian integers", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Modulus",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Modulus"], "0", Cell[
    "modulus for polynomial coefficients ", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->4696257],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SquareFreeQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SquareFreeQ"], "[", "0", "]"}]], 
  "InlineFormula"],
 " gives ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->18455]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->373838248],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->480479637],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SquareFreeQ", "[", "10", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->359189224],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->744075089]
}, Open  ]],

Cell["12 has a factor 4, which is a square:", "ExampleText",
 CellID->6185847],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SquareFreeQ", "[", "12", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->512611867],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->872744342]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->45589416],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SquareFreeQ", "[", 
  RowBox[{
   RowBox[{"x", "^", "4"}], "-", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14063338],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->900846984]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SquareFreeQ", "[", 
  RowBox[{
   RowBox[{"x", "^", "4"}], "-", 
   RowBox[{"2", 
    RowBox[{"x", "^", "2"}]}], "+", "1"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13918866],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->775548738]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell["Integers: ", "ExampleText",
 CellID->106913071],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SquareFreeQ", "[", "20", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1048303171],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1569385923]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorInteger", "[", "20", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->620669871],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1275055407]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->491707938],

Cell["Gaussian integers:", "ExampleText",
 CellID->263079570],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SquareFreeQ", "[", 
  RowBox[{"8", "+", 
   RowBox[{"2", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->673656816],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->116912036]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorInteger", "[", 
  RowBox[{"8", "+", 
   RowBox[{"2", "I"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28915175],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "\[ImaginaryI]"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "+", "\[ImaginaryI]"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"4", "+", "\[ImaginaryI]"}], ",", "1"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{208, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2140535694]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->299794839],

Cell["Univariate polynomials:", "ExampleText",
 CellID->252389675],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SquareFreeQ", "[", 
  RowBox[{"9", "+", 
   RowBox[{"6", "x"}], "+", 
   RowBox[{"x", "^", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->614131456],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1337354514]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorList", "[", 
  RowBox[{"9", "+", 
   RowBox[{"6", "x"}], "+", 
   RowBox[{"x", "^", "2"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->716926832],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3", "+", "x"}], ",", "2"}], "}"}]}], "}"}]], "Output",
 ImageSize->{128, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1353467296]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2081270271],

Cell["Multivariate polynomials:", "ExampleText",
 CellID->1695802361],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SquareFreeQ", "[", 
  RowBox[{
   RowBox[{"x", "^", "3"}], "-", 
   RowBox[{
    RowBox[{"x", "^", "2"}], "y"}], "-", 
   RowBox[{"x", " ", 
    RowBox[{"y", "^", "2"}]}], "+", 
   RowBox[{"y", "^", "3"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2094801990],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1578054848]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorList", "[", 
  RowBox[{
   RowBox[{"x", "^", "3"}], "-", 
   RowBox[{
    RowBox[{"x", "^", "2"}], "y"}], "-", 
   RowBox[{"x", " ", 
    RowBox[{"y", "^", "2"}]}], "+", 
   RowBox[{"y", "^", "3"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24149527],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "-", "y"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "+", "y"}], ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{198, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->944789886]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2031461528],

Cell["Polynomials in specific variables:", "ExampleText",
 CellID->2078881090],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SquareFreeQ", "[", 
  RowBox[{
   RowBox[{"a", " ", "x", " ", 
    RowBox[{"y", "^", "2"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1749365665],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->589528084]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SquareFreeQ", "[", 
  RowBox[{
   RowBox[{"a", " ", "x", " ", 
    RowBox[{"y", "^", "2"}]}], ",", "y"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->195542940],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1856444177]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13938505],

Cell["Polynomials over a finite field:", "ExampleText",
 CellID->113640257],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SquareFreeQ", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", "1"}], ",", 
   RowBox[{"Modulus", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10246196],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->467375576]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", "1"}], ",", 
   RowBox[{"Modulus", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->11825108],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "+", "x"}], ",", "2"}], "}"}]}], "}"}]], "Output",
 ImageSize->{128, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1833608753]
}, Open  ]],

Cell["This is square-free over the integers:", "ExampleText",
 CellID->330157148],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SquareFreeQ", "[", 
  RowBox[{
   RowBox[{"x", "^", "2"}], "+", "1"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->125212072],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1071977221]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->968373547],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "GaussianIntegers",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1757724783],

Cell["Square-free Gaussian integers:", "ExampleText",
 CellID->1483516997],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SquareFreeQ", "[", 
  RowBox[{"2", ",", 
   RowBox[{"GaussianIntegers", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1072154835],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1480838664]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SquareFreeQ", "[", 
  RowBox[{"2", ",", 
   RowBox[{"GaussianIntegers", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->249495614],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1267440765]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Modulus",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1295379749],

Cell["Square-free polynomials over finite fields:", "ExampleText",
 CellID->1185026909],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SquareFreeQ", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "-", "3"}], ",", 
   RowBox[{"Modulus", "\[Rule]", "3"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1166379302],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->986642762]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SquareFreeQ", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "-", "3"}], ",", 
   RowBox[{"Modulus", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->330464866],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1783662447]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->258228157],

Cell[TextData[{
 "The central binomial coefficients ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Binomial",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Binomial"], "[", 
   RowBox[{
    RowBox[{"2", 
     StyleBox["n", "TI"]}], ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 " is not square-free for ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], ">", "4"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1327065189],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Or", " ", "@@", " ", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"SquareFreeQ", "[", 
     RowBox[{"Binomial", "[", 
      RowBox[{
       RowBox[{"2", "n"}], ",", "n"}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "5", ",", 
      RowBox[{"2", "^", "10"}]}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->219473781],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1290518256]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[TextData[{
 "Square factors can found using ",
 Cell[BoxData[
  ButtonBox["FactorSquareFreeList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FactorSquareFreeList"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->221985567],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SquareFreeQ", "[", 
  RowBox[{"Expand", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "+", "1"}], ")"}], "^", "3"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "+", "2"}], ")"}], "^", "2"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "+", "3"}], ")"}], "^", "2"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->251823358],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->155493892]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorSquareFreeList", "[", 
  RowBox[{"Expand", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "+", "1"}], ")"}], "^", "3"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "+", "2"}], ")"}], "^", "2"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "+", "3"}], ")"}], "^", "2"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->509393744],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "+", "x"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"6", "+", 
      RowBox[{"5", " ", "x"}], "+", 
      SuperscriptBox["x", "2"]}], ",", "2"}], "}"}]}], "}"}]], "Output",
 ImageSize->{233, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2045728092]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24743123],

Cell[TextData[{
 "The polynomial ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["p", "TI"], "[", 
    StyleBox["x", "TI"], "]"}], "/", 
   RowBox[{
    ButtonBox["PolynomialGCD",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PolynomialGCD"], "[", 
    RowBox[{
     RowBox[{
      StyleBox["p", "TI"], "[", 
      StyleBox["x", "TI"], "]"}], ",", 
     RowBox[{
      RowBox[{
       StyleBox["p", "TI"], "'"}], "[", 
      StyleBox["x", "TI"], "]"}]}], "]"}]}]], "InlineFormula"],
 " is always square-free:"
}], "ExampleText",
 CellID->791603085],

Cell[BoxData[
 RowBox[{
  RowBox[{"p", "=", 
   RowBox[{"Expand", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "+", "1"}], ")"}], "^", "3"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "+", "2"}], ")"}], "^", "2"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "+", "3"}], ")"}], "^", "2"}]}], "]"}]}], ";"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->221319752],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SquareFreeQ", "[", 
  RowBox[{"Cancel", "[", 
   RowBox[{"p", "/", 
    RowBox[{"PolynomialGCD", "[", 
     RowBox[{"p", ",", 
      RowBox[{"D", "[", 
       RowBox[{"p", ",", "x"}], "]"}]}], "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->83220247],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1338853774]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1104031453],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MoebiusMu",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MoebiusMu"]], "InlineFormula"],
 " is zero for non-square-free integers:"
}], "ExampleText",
 CellID->1197920491],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MoebiusMu", "[", "12", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->790501612],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->781726352]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SquareFreeQ", "[", "12", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->486157397],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->169845718]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->589267740],

Cell["Pattern of square-free integers:", "ExampleText",
 CellID->2074839628],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Boole", "[", 
     RowBox[{"SquareFreeQ", "[", 
      RowBox[{
       RowBox[{"x", "+", 
        RowBox[{"I", " ", "y"}]}], ",", 
       RowBox[{"GaussianIntegers", "->", "True"}]}], "]"}], "]"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "30"}], ",", "30"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "30"}], ",", "30"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->267509659],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzNV9sRwjAMs9iEQViCEboA+/9xXJM2tmUnafoBhRyNXSuSnUef2+e9PUTk
VX7QF2B7UuvvK7VVH6A21lDbI1qOyfD34G1E7EwURmEnxHmAXTiqgLCMGNaR
dUhFTYthnU/txvSGUvscfsDLdZ951rxGKqzxaWF8fu29dSNoXofAh4QXU9II
vfIM5xYEIQX8RhlKxPE5Je0TTFVf0tyQRyZ36mK13MClhgFtEz1c+cD2VMV9
EYZM+1oUsJpuX9K8yHE+yHj2leCRfecxCDayFKUzGiOsVToxJLO516t3ItC/
iQFs3eyPBm5WzSMvcV5SeynPLqrvrDDEu8s28ZB7ZtWl+XzLShKx665hN66e
E+u2E5PAhTvG9b1qdZeMVB6wsJATJ4P1M8nV01Abe/YchiMIhSPdh2Hx7Ong
fElDXLY15yynf3nSN4tDK7zKKHFee68KaQ+80WVce9YvVBIHHA==
   "], {{0, 0}, {61, 61}}, {0, 1}],
  Frame->Automatic,
  FrameTicks->{None, None},
  PlotRangeClipping->True]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->591215563]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FactorInteger",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FactorInteger"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Factor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Factor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FactorSquareFree",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FactorSquareFree"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolynomialGCD",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolynomialGCD"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Discriminant",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Discriminant"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PrimeQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PrimeQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PrimePowerQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PrimePowerQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MoebiusMu",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MoebiusMu"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Integer and Number\[Hyphen]Theoretical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]], "Tutorials",
 CellID->28609],

Cell[TextData[ButtonBox["Algebraic Operations on Polynomials",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AlgebraicOperationsOnPolynomials"]], "Tutorials",\

 CellID->18564]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->41063124],

Cell[TextData[ButtonBox["Number Recognition",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberRecognition"]], "MoreAbout",
 CellID->257757022],

Cell[TextData[ButtonBox["Number Theoretic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheoreticFunctions"]], "MoreAbout",
 CellID->212687310],

Cell[TextData[ButtonBox["Polynomial Factoring & Decomposition",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialFactoring"]], "MoreAbout",
 CellID->1058706],

Cell[TextData[ButtonBox["Prime Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PrimeNumbers"]], "MoreAbout",
 CellID->195732159],

Cell[TextData[ButtonBox["New in 6.0: Symbolic Computation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60AlgebraicComputing"]], "MoreAbout",
 CellID->31079450],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->21718498],

Cell[TextData[ButtonBox["New in 6.0: Number Theory & Integer Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]], "MoreAbout",
 CellID->816393769]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SquareFreeQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 23, 43.1559864}", "context" -> "System`", 
    "keywords" -> {"square-free integers", "square-free polynomials"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "SquareFreeQ[expr] gives True if expr is a square-free polynomial or \
number, and False otherwise. SquareFreeQ[expr, vars] gives True if expr is \
square-free with respect to the variables vars. ", 
    "synonyms" -> {"square free q"}, "title" -> "SquareFreeQ", "type" -> 
    "Symbol", "uri" -> "ref/SquareFreeQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10001, 291, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->373838248]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 35656, 1339}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3930, 84, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4553, 111, 1576, 37, 70, "ObjectNameGrid"],
Cell[6132, 150, 1544, 50, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[7713, 205, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8191, 222, 603, 23, 70, "Notes",
 CellID->25182],
Cell[8797, 247, 71, 1, 70, "Notes",
 CellID->81386831],
Cell[8871, 250, 757, 20, 70, "3ColumnTableMod",
 CellID->4696257],
Cell[9631, 272, 333, 14, 70, "Notes",
 CellID->18455]
}, Closed]],
Cell[CellGroupData[{
Cell[10001, 291, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->373838248],
Cell[CellGroupData[{
Cell[10386, 305, 148, 5, 70, "ExampleSection",
 CellID->480479637],
Cell[CellGroupData[{
Cell[10559, 314, 108, 3, 28, "Input",
 CellID->359189224],
Cell[10670, 319, 161, 5, 36, "Output",
 CellID->744075089]
}, Open  ]],
Cell[10846, 327, 78, 1, 70, "ExampleText",
 CellID->6185847],
Cell[CellGroupData[{
Cell[10949, 332, 108, 3, 28, "Input",
 CellID->512611867],
Cell[11060, 337, 162, 5, 36, "Output",
 CellID->872744342]
}, Open  ]],
Cell[11237, 345, 124, 3, 70, "ExampleDelimiter",
 CellID->45589416],
Cell[CellGroupData[{
Cell[11386, 352, 153, 5, 70, "Input",
 CellID->14063338],
Cell[11542, 359, 161, 5, 36, "Output",
 CellID->900846984]
}, Open  ]],
Cell[CellGroupData[{
Cell[11740, 369, 207, 7, 70, "Input",
 CellID->13918866],
Cell[11950, 378, 162, 5, 36, "Output",
 CellID->775548738]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12161, 389, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[12385, 398, 53, 1, 70, "ExampleText",
 CellID->106913071],
Cell[CellGroupData[{
Cell[12463, 403, 109, 3, 70, "Input",
 CellID->1048303171],
Cell[12575, 408, 163, 5, 36, "Output",
 CellID->1569385923]
}, Open  ]],
Cell[CellGroupData[{
Cell[12775, 418, 110, 3, 70, "Input",
 CellID->620669871],
Cell[12888, 423, 303, 11, 36, "Output",
 CellID->1275055407]
}, Open  ]],
Cell[13206, 437, 125, 3, 70, "ExampleDelimiter",
 CellID->491707938],
Cell[13334, 442, 61, 1, 70, "ExampleText",
 CellID->263079570],
Cell[CellGroupData[{
Cell[13420, 447, 149, 5, 70, "Input",
 CellID->673656816],
Cell[13572, 454, 162, 5, 36, "Output",
 CellID->116912036]
}, Open  ]],
Cell[CellGroupData[{
Cell[13771, 464, 150, 5, 70, "Input",
 CellID->28915175],
Cell[13924, 471, 474, 17, 36, "Output",
 CellID->2140535694]
}, Open  ]],
Cell[14413, 491, 125, 3, 70, "ExampleDelimiter",
 CellID->299794839],
Cell[14541, 496, 66, 1, 70, "ExampleText",
 CellID->252389675],
Cell[CellGroupData[{
Cell[14632, 501, 183, 6, 70, "Input",
 CellID->614131456],
Cell[14818, 509, 163, 5, 36, "Output",
 CellID->1337354514]
}, Open  ]],
Cell[CellGroupData[{
Cell[15018, 519, 182, 6, 70, "Input",
 CellID->716926832],
Cell[15203, 527, 329, 12, 36, "Output",
 CellID->1353467296]
}, Open  ]],
Cell[15547, 542, 126, 3, 70, "ExampleDelimiter",
 CellID->2081270271],
Cell[15676, 547, 69, 1, 70, "ExampleText",
 CellID->1695802361],
Cell[CellGroupData[{
Cell[15770, 552, 292, 10, 70, "Input",
 CellID->2094801990],
Cell[16065, 564, 163, 5, 36, "Output",
 CellID->1578054848]
}, Open  ]],
Cell[CellGroupData[{
Cell[16265, 574, 289, 10, 70, "Input",
 CellID->24149527],
Cell[16557, 586, 413, 15, 36, "Output",
 CellID->944789886]
}, Open  ]],
Cell[16985, 604, 126, 3, 70, "ExampleDelimiter",
 CellID->2031461528],
Cell[17114, 609, 78, 1, 70, "ExampleText",
 CellID->2078881090],
Cell[CellGroupData[{
Cell[17217, 614, 190, 6, 70, "Input",
 CellID->1749365665],
Cell[17410, 622, 161, 5, 36, "Output",
 CellID->589528084]
}, Open  ]],
Cell[CellGroupData[{
Cell[17608, 632, 189, 6, 70, "Input",
 CellID->195542940],
Cell[17800, 640, 163, 5, 36, "Output",
 CellID->1856444177]
}, Open  ]],
Cell[17978, 648, 124, 3, 70, "ExampleDelimiter",
 CellID->13938505],
Cell[18105, 653, 75, 1, 70, "ExampleText",
 CellID->113640257],
Cell[CellGroupData[{
Cell[18205, 658, 214, 7, 70, "Input",
 CellID->10246196],
Cell[18422, 667, 162, 5, 36, "Output",
 CellID->467375576]
}, Open  ]],
Cell[CellGroupData[{
Cell[18621, 677, 213, 7, 70, "Input",
 CellID->11825108],
Cell[18837, 686, 329, 12, 36, "Output",
 CellID->1833608753]
}, Open  ]],
Cell[19181, 701, 81, 1, 70, "ExampleText",
 CellID->330157148],
Cell[CellGroupData[{
Cell[19287, 706, 154, 5, 70, "Input",
 CellID->125212072],
Cell[19444, 713, 162, 5, 36, "Output",
 CellID->1071977221]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19655, 724, 222, 7, 70, "ExampleSection",
 CellID->968373547],
Cell[CellGroupData[{
Cell[19902, 735, 238, 7, 70, "ExampleSubsection",
 CellID->1757724783],
Cell[20143, 744, 74, 1, 70, "ExampleText",
 CellID->1483516997],
Cell[CellGroupData[{
Cell[20242, 749, 179, 5, 70, "Input",
 CellID->1072154835],
Cell[20424, 756, 163, 5, 36, "Output",
 CellID->1480838664]
}, Open  ]],
Cell[CellGroupData[{
Cell[20624, 766, 179, 5, 70, "Input",
 CellID->249495614],
Cell[20806, 773, 162, 5, 36, "Output",
 CellID->1267440765]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21017, 784, 229, 7, 70, "ExampleSubsection",
 CellID->1295379749],
Cell[21249, 793, 87, 1, 70, "ExampleText",
 CellID->1185026909],
Cell[CellGroupData[{
Cell[21361, 798, 216, 7, 70, "Input",
 CellID->1166379302],
Cell[21580, 807, 162, 5, 36, "Output",
 CellID->986642762]
}, Open  ]],
Cell[CellGroupData[{
Cell[21779, 817, 215, 7, 70, "Input",
 CellID->330464866],
Cell[21997, 826, 162, 5, 36, "Output",
 CellID->1783662447]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[22220, 838, 227, 7, 70, "ExampleSection",
 CellID->258228157],
Cell[22450, 847, 446, 17, 70, "ExampleText",
 CellID->1327065189],
Cell[CellGroupData[{
Cell[22921, 868, 377, 12, 70, "Input",
 CellID->219473781],
Cell[23301, 882, 163, 5, 36, "Output",
 CellID->1290518256]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23513, 893, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[23754, 902, 238, 8, 70, "ExampleText",
 CellID->221985567],
Cell[CellGroupData[{
Cell[24017, 914, 398, 14, 70, "Input",
 CellID->251823358],
Cell[24418, 930, 162, 5, 36, "Output",
 CellID->155493892]
}, Open  ]],
Cell[CellGroupData[{
Cell[24617, 940, 407, 14, 70, "Input",
 CellID->509393744],
Cell[25027, 956, 479, 17, 39, "Output",
 CellID->2045728092]
}, Open  ]],
Cell[25521, 976, 124, 3, 70, "ExampleDelimiter",
 CellID->24743123],
Cell[25648, 981, 561, 21, 70, "ExampleText",
 CellID->791603085],
Cell[26212, 1004, 414, 16, 70, "Input",
 CellID->221319752],
Cell[CellGroupData[{
Cell[26651, 1024, 291, 9, 70, "Input",
 CellID->83220247],
Cell[26945, 1035, 162, 5, 36, "Output",
 CellID->1338853774]
}, Open  ]],
Cell[27122, 1043, 126, 3, 70, "ExampleDelimiter",
 CellID->1104031453],
Cell[27251, 1048, 218, 7, 70, "ExampleText",
 CellID->1197920491],
Cell[CellGroupData[{
Cell[27494, 1059, 106, 3, 70, "Input",
 CellID->790501612],
Cell[27603, 1064, 158, 5, 36, "Output",
 CellID->781726352]
}, Open  ]],
Cell[CellGroupData[{
Cell[27798, 1074, 108, 3, 70, "Input",
 CellID->486157397],
Cell[27909, 1079, 162, 5, 36, "Output",
 CellID->169845718]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[28120, 1090, 228, 7, 70, "ExampleSection",
 CellID->589267740],
Cell[28351, 1099, 76, 1, 70, "ExampleText",
 CellID->2074839628],
Cell[CellGroupData[{
Cell[28452, 1104, 552, 17, 70, "Input",
 CellID->267509659],
Cell[29007, 1123, 790, 18, 201, "Output",
 CellID->591215563]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[29858, 1148, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[30177, 1159, 1969, 71, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[32183, 1235, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[32504, 1246, 198, 4, 70, "Tutorials",
 CellID->28609],
Cell[32705, 1252, 180, 4, 70, "Tutorials",
 CellID->18564]
}, Open  ]],
Cell[CellGroupData[{
Cell[32922, 1261, 318, 9, 70, "MoreAboutSection",
 CellID->41063124],
Cell[33243, 1272, 147, 3, 70, "MoreAbout",
 CellID->257757022],
Cell[33393, 1277, 162, 3, 70, "MoreAbout",
 CellID->212687310],
Cell[33558, 1282, 165, 3, 70, "MoreAbout",
 CellID->1058706],
Cell[33726, 1287, 137, 3, 70, "MoreAbout",
 CellID->195732159],
Cell[33866, 1292, 168, 3, 70, "MoreAbout",
 CellID->31079450],
Cell[34037, 1297, 178, 3, 70, "MoreAbout",
 CellID->21718498],
Cell[34218, 1302, 198, 4, 70, "MoreAbout",
 CellID->816393769]
}, Open  ]],
Cell[34431, 1309, 27, 0, 70, "History"],
Cell[34461, 1311, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

