(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19690,        735]
NotebookOptionsPosition[     15338,        589]
NotebookOutlinePosition[     16790,        629]
CellTagsIndexPosition[     16705,        624]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"The Evaluation Stack" :> 
          Documentation`HelpLookup["paclet:tutorial/TheEvaluationStack"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"The Evaluation Stack\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"StackBegin" :> 
          Documentation`HelpLookup["paclet:ref/StackBegin"], "StackComplete" :> 
          Documentation`HelpLookup["paclet:ref/StackComplete"], 
          "StackInhibit" :> 
          Documentation`HelpLookup["paclet:ref/StackInhibit"], "Trace" :> 
          Documentation`HelpLookup["paclet:ref/Trace"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"StackBegin\"\>", 2->"\<\"StackComplete\"\>", 
       3->"\<\"StackInhibit\"\>", 4->"\<\"Trace\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Low-Level System Spelunking" :> 
          Documentation`HelpLookup["paclet:guide/LowLevelSystemSpelunking"], 
          "Symbolic Execution History" :> 
          Documentation`HelpLookup["paclet:guide/SymbolicExecutionHistory"], 
          "Tuning & Debugging" :> 
          Documentation`HelpLookup["paclet:guide/TuningAndDebugging"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Low-Level System Spelunking\"\>", 
       2->"\<\"Symbolic Execution History\"\>", 
       3->"\<\"Tuning & Debugging\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Stack", "ObjectName",
 CellID->23739],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Stack",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Stack"], "[", "]"}]], "InlineFormula"],
     "\[LineSeparator]shows the current evaluation stack, giving a list of \
the tags associated with evaluations that are currently being done. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Stack",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Stack"], "[", 
       StyleBox["pattern", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of expressions currently being evaluated \
which match the pattern. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->30739]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Stack",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Stack"], "[", "_", "]"}]], "InlineFormula"],
 " shows all expressions currently being evaluated. "
}], "Notes",
 CellID->11091],

Cell[TextData[{
 "You can call ",
 Cell[BoxData[
  ButtonBox["Stack",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Stack"]], "InlineFormula"],
 " from inside a dialog to see how the dialog was reached. "
}], "Notes",
 CellID->11950],

Cell[TextData[{
 "In the list returned by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Stack",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Stack"], "[", 
   StyleBox["pattern", "TI"], "]"}]], "InlineFormula"],
 ", each expression is wrapped with ",
 Cell[BoxData[
  ButtonBox["HoldForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldForm"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->1656],

Cell[TextData[{
 "The maximum length of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Stack",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Stack"], "[", "]"}]], "InlineFormula"],
 " is limited by ",
 Cell[BoxData[
  ButtonBox["$RecursionLimit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$RecursionLimit"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->28154],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Stack",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Stack"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["HoldFirst",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldFirst"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->28035]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->27388415],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->187166981],

Cell[TextData[{
 "Print the stack where the ",
 Cell[BoxData[
  ButtonBox["Stack",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Stack"]], "InlineFormula"],
 " command is being evaluated:"
}], "ExampleText",
 CellID->569399715],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"g", "[", 
   RowBox[{"1", ",", 
    RowBox[{
     RowBox[{"Print", "[", 
      RowBox[{"Stack", "[", "]"}], "]"}], ";", "2"}]}], "]"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->23919722],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"f", ",", "g", ",", "CompoundExpression", ",", "Print"}], 
  "}"}]], "Print",
 CellLabel->"During evaluation of In[4]:=",
 CellID->1011018326],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"g", "[", 
   RowBox[{"1", ",", "2"}], "]"}], "]"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->876756004]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->101473710],

Cell["\<\
Print the detailed stack contents including function arguments: \
\>", "ExampleText",
 CellID->407720504],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"g", "[", 
   RowBox[{"1", ",", 
    RowBox[{
     RowBox[{"Print", "[", 
      RowBox[{"Stack", "[", "_", "]"}], "]"}], ";", "2"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->179366444],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"f", "[", 
     RowBox[{"g", "[", 
      RowBox[{"1", ",", 
       RowBox[{
        RowBox[{"Print", "[", 
         RowBox[{"Stack", "[", "_", "]"}], "]"}], ";", "2"}]}], "]"}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"g", "[", 
     RowBox[{"1", ",", 
      RowBox[{
       RowBox[{"Print", "[", 
        RowBox[{"Stack", "[", "_", "]"}], "]"}], ";", "2"}]}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{
     RowBox[{"Print", "[", 
      RowBox[{"Stack", "[", "_", "]"}], "]"}], ";", "2"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"Print", "[", 
     RowBox[{"Stack", "[", "_", "]"}], "]"}],
    HoldForm]}], "}"}]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->45750374],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"g", "[", 
   RowBox[{"1", ",", "2"}], "]"}], "]"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->196546567]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24992],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Stack",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Stack"]], "InlineFormula"],
 " inside of ",
 Cell[BoxData[
  ButtonBox["Dialog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dialog"]], "InlineFormula"],
 " to see how it was reached:"
}], "ExampleText",
 CellID->452553867],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", " ", "+", " ", 
  RowBox[{"2", "*", 
   RowBox[{"Dialog", "[", "]"}]}], " ", "+", " ", 
  RowBox[{"3", "*", 
   RowBox[{
    RowBox[{"Dialog", "[", "]"}], "^", "2"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->184964320],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"3", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}], ")"}], "2"]}], "+", 
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}]}]}]], "Output",
 ImageSize->{151, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->172946585]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Stack",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Stack"]], "InlineFormula"],
 " shows that the dialog from ",
 Cell[BoxData[
  RowBox[{"2", "*", 
   RowBox[{
    ButtonBox["Dialog",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Dialog"], "[", "]"}]}]], "InlineFormula"],
 " is entered first:"
}], "ExampleText",
 CellID->291689452],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Stack", "[", "_", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->207755729],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"1", "+", 
     RowBox[{"2", " ", 
      RowBox[{"Dialog", "[", "]"}]}], "+", 
     RowBox[{"3", " ", 
      SuperscriptBox[
       RowBox[{"Dialog", "[", "]"}], "2"]}]}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"2", " ", 
     RowBox[{"Dialog", "[", "]"}]}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"Dialog", "[", "]"}],
    HoldForm]}], "}"}]], "Output",
 ImageSize->{333, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"(Dialog) Out[2]=",
 CellID->194364351]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Return", "[", 
  RowBox[{"x", "+", "1"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->317164918],

Cell["Upon return from the first dialog, the other is entered:", "ExampleText",
 CellID->438080308],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Stack", "[", "_", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->296251310],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"1", "+", 
     RowBox[{"2", " ", 
      RowBox[{"Dialog", "[", "]"}]}], "+", 
     RowBox[{"3", " ", 
      SuperscriptBox[
       RowBox[{"Dialog", "[", "]"}], "2"]}]}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"3", " ", 
     SuperscriptBox[
      RowBox[{"Dialog", "[", "]"}], "2"]}],
    HoldForm], ",", 
   TagBox[
    SuperscriptBox[
     RowBox[{"Dialog", "[", "]"}], "2"],
    HoldForm], ",", 
   TagBox[
    RowBox[{"Dialog", "[", "]"}],
    HoldForm]}], "}"}]], "Output",
 ImageSize->{411, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"(Dialog) Out[4]=",
 CellID->45915750]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Return", "[", 
  RowBox[{"x", "-", "1"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->54643623]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31976],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["StackBegin",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StackBegin"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StackComplete",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StackComplete"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StackInhibit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StackInhibit"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Trace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Trace"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->26659]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1199],

Cell[TextData[ButtonBox["The Evaluation Stack",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheEvaluationStack"]], "Tutorials",
 CellID->5634]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Low-Level System Spelunking",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelSystemSpelunking"]], "MoreAbout",
 CellID->58227489],

Cell[TextData[ButtonBox["Symbolic Execution History",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicExecutionHistory"]], "MoreAbout",
 CellID->510111044],

Cell[TextData[ButtonBox["Tuning & Debugging",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TuningAndDebugging"]], "MoreAbout",
 CellID->462420208]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Stack - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 23, 51.5624516}", "context" -> "System`", 
    "keywords" -> {
     "evaluation of functions", "functions being evaluated", 
      "pending evaluations", "evaluation stack"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Stack[] shows the current evaluation stack, giving a list of the tags \
associated with evaluations that are currently being done. Stack[pattern] \
gives a list of expressions currently being evaluated which match the \
pattern. ", "synonyms" -> {}, "title" -> "Stack", "type" -> "Symbol", "uri" -> 
    "ref/Stack"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6057, 203, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->27388415]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16563, 617}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2398, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3021, 83, 43, 1, 70, "ObjectName",
 CellID->23739],
Cell[3067, 86, 869, 25, 70, "Usage",
 CellID->30739]
}, Open  ]],
Cell[CellGroupData[{
Cell[3973, 116, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4451, 133, 242, 8, 70, "Notes",
 CellID->11091],
Cell[4696, 143, 236, 8, 70, "Notes",
 CellID->11950],
Cell[4935, 153, 406, 15, 70, "Notes",
 CellID->1656],
Cell[5344, 170, 369, 14, 70, "Notes",
 CellID->28154],
Cell[5716, 186, 304, 12, 70, "Notes",
 CellID->28035]
}, Closed]],
Cell[CellGroupData[{
Cell[6057, 203, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->27388415],
Cell[CellGroupData[{
Cell[6441, 217, 148, 5, 70, "ExampleSection",
 CellID->187166981],
Cell[6592, 224, 230, 8, 70, "ExampleText",
 CellID->569399715],
Cell[CellGroupData[{
Cell[6847, 236, 241, 9, 70, "Input",
 CellID->23919722],
Cell[7091, 247, 181, 5, 23, "Print",
 CellID->1011018326],
Cell[7275, 254, 237, 8, 36, "Output",
 CellID->876756004]
}, Open  ]],
Cell[7527, 265, 125, 3, 70, "ExampleDelimiter",
 CellID->101473710],
Cell[7655, 270, 115, 3, 70, "ExampleText",
 CellID->407720504],
Cell[CellGroupData[{
Cell[7795, 277, 248, 9, 70, "Input",
 CellID->179366444],
Cell[8046, 288, 775, 28, 70, "Print",
 CellID->45750374],
Cell[8824, 318, 237, 8, 36, "Output",
 CellID->196546567]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9110, 332, 216, 7, 70, "ExampleSection",
 CellID->24992],
Cell[9329, 341, 338, 13, 70, "ExampleText",
 CellID->452553867],
Cell[CellGroupData[{
Cell[9692, 358, 251, 8, 70, "Input",
 CellID->184964320],
Cell[9946, 368, 384, 14, 36, "Output",
 CellID->172946585]
}, Open  ]],
Cell[10345, 385, 390, 14, 70, "ExampleText",
 CellID->291689452],
Cell[CellGroupData[{
Cell[10760, 403, 101, 3, 70, "Input",
 CellID->207755729],
Cell[10864, 408, 567, 22, 53, "Output",
 CellID->194364351]
}, Open  ]],
Cell[11446, 433, 125, 4, 70, "Input",
 CellID->317164918],
Cell[11574, 439, 99, 1, 70, "ExampleText",
 CellID->438080308],
Cell[CellGroupData[{
Cell[11698, 444, 101, 3, 70, "Input",
 CellID->296251310],
Cell[11802, 449, 687, 27, 53, "Output",
 CellID->45915750]
}, Open  ]],
Cell[12504, 479, 124, 4, 70, "Input",
 CellID->54643623]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12677, 489, 311, 9, 70, "SeeAlsoSection",
 CellID->31976],
Cell[12991, 500, 957, 35, 70, "SeeAlso",
 CellID->26659]
}, Open  ]],
Cell[CellGroupData[{
Cell[13985, 540, 313, 9, 70, "TutorialsSection",
 CellID->1199],
Cell[14301, 551, 148, 3, 70, "Tutorials",
 CellID->5634]
}, Open  ]],
Cell[CellGroupData[{
Cell[14486, 559, 299, 8, 70, "MoreAboutSection"],
Cell[14788, 569, 162, 3, 70, "MoreAbout",
 CellID->58227489],
Cell[14953, 574, 162, 3, 70, "MoreAbout",
 CellID->510111044],
Cell[15118, 579, 148, 3, 70, "MoreAbout",
 CellID->462420208]
}, Open  ]],
Cell[15281, 585, 27, 0, 70, "History"],
Cell[15311, 587, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

