(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13198,        479]
NotebookOptionsPosition[     10078,        376]
NotebookOutlinePosition[     11465,        415]
CellTagsIndexPosition[     11380,        410]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"The Evaluation Stack" :> 
          Documentation`HelpLookup["paclet:tutorial/TheEvaluationStack"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"The Evaluation Stack\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Stack" :> Documentation`HelpLookup["paclet:ref/Stack"], 
          "TraceBackward" :> 
          Documentation`HelpLookup["paclet:ref/TraceBackward"], "TraceAbove" :> 
          Documentation`HelpLookup["paclet:ref/TraceAbove"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Stack\"\>", 
       2->"\<\"TraceBackward\"\>", 
       3->"\<\"TraceAbove\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Symbolic Execution History" :> 
          Documentation`HelpLookup[
           "paclet:guide/SymbolicExecutionHistory"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Symbolic Execution History\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["StackComplete", "ObjectName",
 CellID->7759],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StackComplete",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StackComplete"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]evaluates ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " with intermediate expressions in evaluation chains included on the \
stack. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->997]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " normally includes only the latest expression on each evaluation chain \
involved in the evaluation of a particular expression. Inside ",
 Cell[BoxData[
  ButtonBox["StackComplete",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StackComplete"]], "InlineFormula"],
 ", however, all preceding expressions on the evaluation chains are included. \
"
}], "Notes",
 CellID->22689],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StackComplete",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StackComplete"]], "InlineFormula"],
 " typically increases significantly the number of expressions kept on the \
evaluation stack. "
}], "Notes",
 CellID->11552]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->87260048],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->267186482],

Cell["Include intermediate expressions in the evaluation stack:", \
"ExampleText",
 CellID->140510490],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], " ", ":=", " ", 
   RowBox[{"g", "[", 
    RowBox[{"x", "^", "2"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"g", "[", "x_", "]"}], " ", ":=", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Print", "[", 
      RowBox[{"Stack", "[", "_", "]"}], "]"}], ";", 
     RowBox[{"x", "+", "1"}]}], ")"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->186776896],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StackComplete", "[", 
  RowBox[{"1", " ", "+", " ", 
   RowBox[{"f", "[", "2", "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->121397904],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"StackComplete", "[", 
     RowBox[{"1", "+", 
      RowBox[{"f", "[", "2", "]"}]}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"1", "+", 
     RowBox[{"f", "[", "2", "]"}]}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"f", "[", "2", "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"g", "[", 
     SuperscriptBox["2", "2"], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{
     RowBox[{"Print", "[", 
      RowBox[{"Stack", "[", "_", "]"}], "]"}], ";", 
     RowBox[{"4", "+", "1"}]}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"Print", "[", 
     RowBox[{"Stack", "[", "_", "]"}], "]"}],
    HoldForm]}], "}"}]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->202928794],

Cell[BoxData["6"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->42161844]
}, Open  ]],

Cell[TextData[{
 "Without ",
 Cell[BoxData[
  ButtonBox["StackComplete",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StackComplete"]], "InlineFormula"],
 ", you do not see how ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 " are used:"
}], "ExampleText",
 CellID->168317281],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"f", "[", "2", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->297571205],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"1", "+", 
     RowBox[{"f", "[", "2", "]"}]}],
    HoldForm], ",", 
   TagBox[
    RowBox[{
     RowBox[{"Print", "[", 
      RowBox[{"Stack", "[", "_", "]"}], "]"}], ";", 
     RowBox[{"4", "+", "1"}]}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"Print", "[", 
     RowBox[{"Stack", "[", "_", "]"}], "]"}],
    HoldForm]}], "}"}]], "Print",
 CellLabel->"During evaluation of In[16]:=",
 CellID->693727870],

Cell[BoxData["6"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->420622529]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->15181],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Stack",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Stack"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TraceBackward",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TraceBackward"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TraceAbove",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TraceAbove"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21061]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19963],

Cell[TextData[ButtonBox["The Evaluation Stack",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheEvaluationStack"]], "Tutorials",
 CellID->19270]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Symbolic Execution History",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicExecutionHistory"]], "MoreAbout",
 CellID->434067749]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"StackComplete - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 23, 51.0155626}", "context" -> "System`", 
    "keywords" -> {
     "evaluation of functions", "functions being evaluated", 
      "pending evaluations", "intermediate evaluations"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "StackComplete[expr] evaluates expr with intermediate expressions in \
evaluation chains included on the stack. ", "synonyms" -> {"stack complete"}, 
    "title" -> "StackComplete", "type" -> "Symbol", "uri" -> 
    "ref/StackComplete"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4539, 148, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->87260048]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11238, 403}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1977, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2600, 77, 50, 1, 70, "ObjectName",
 CellID->7759],
Cell[2653, 80, 617, 19, 70, "Usage",
 CellID->997]
}, Open  ]],
Cell[CellGroupData[{
Cell[3307, 104, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3785, 121, 444, 12, 70, "Notes",
 CellID->22689],
Cell[4232, 135, 270, 8, 70, "Notes",
 CellID->11552]
}, Closed]],
Cell[CellGroupData[{
Cell[4539, 148, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->87260048],
Cell[CellGroupData[{
Cell[4923, 162, 148, 5, 70, "ExampleSection",
 CellID->267186482],
Cell[5074, 169, 102, 2, 70, "ExampleText",
 CellID->140510490],
Cell[5179, 173, 462, 15, 70, "Input",
 CellID->186776896],
Cell[CellGroupData[{
Cell[5666, 192, 171, 5, 70, "Input",
 CellID->121397904],
Cell[5840, 199, 767, 30, 26, "Print",
 CellID->202928794],
Cell[6610, 231, 157, 5, 36, "Output",
 CellID->42161844]
}, Open  ]],
Cell[6782, 239, 360, 14, 70, "ExampleText",
 CellID->168317281],
Cell[CellGroupData[{
Cell[7167, 257, 120, 4, 70, "Input",
 CellID->297571205],
Cell[7290, 263, 472, 18, 70, "Print",
 CellID->693727870],
Cell[7765, 283, 158, 5, 36, "Output",
 CellID->420622529]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7984, 295, 311, 9, 70, "SeeAlsoSection",
 CellID->15181],
Cell[8298, 306, 704, 26, 70, "SeeAlso",
 CellID->21061]
}, Open  ]],
Cell[CellGroupData[{
Cell[9039, 337, 314, 9, 70, "TutorialsSection",
 CellID->19963],
Cell[9356, 348, 149, 3, 70, "Tutorials",
 CellID->19270]
}, Open  ]],
Cell[CellGroupData[{
Cell[9542, 356, 299, 8, 70, "MoreAboutSection"],
Cell[9844, 366, 162, 3, 70, "MoreAbout",
 CellID->434067749]
}, Open  ]],
Cell[10021, 372, 27, 0, 70, "History"],
Cell[10051, 374, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

