(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13027,        472]
NotebookOptionsPosition[      9952,        370]
NotebookOutlinePosition[     11285,        408]
CellTagsIndexPosition[     11200,        403]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"The Evaluation Stack" :> 
          Documentation`HelpLookup["paclet:tutorial/TheEvaluationStack"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"The Evaluation Stack\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Stack" :> Documentation`HelpLookup["paclet:ref/Stack"], 
          "StackBegin" :> 
          Documentation`HelpLookup["paclet:ref/StackBegin"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Stack\"\>", 
       2->"\<\"StackBegin\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Symbolic Execution History" :> 
          Documentation`HelpLookup[
           "paclet:guide/SymbolicExecutionHistory"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Symbolic Execution History\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["StackInhibit", "ObjectName",
 CellID->20717],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StackInhibit",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StackInhibit"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]evaluates ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " without modifying the evaluation stack. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->23365]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["StackInhibit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StackInhibit"]], "InlineFormula"],
 " to prevent \"innermost\" evaluations from appearing in the evaluation \
stack when you look at it with ",
 Cell[BoxData[
  ButtonBox["Stack",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Stack"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->29215],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StackInhibit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StackInhibit"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["HoldFirst",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldFirst"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->31193]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->267357075],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->129797002],

Cell[TextData[{
 "Prevent ",
 Cell[BoxData[
  ButtonBox["Print",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Print"]], "InlineFormula"],
 " from being shown on the stack:"
}], "ExampleText",
 CellID->445675715],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "+", "x", "+", 
  RowBox[{"f", "[", 
   RowBox[{"StackBegin", "[", 
    RowBox[{"2", "+", 
     RowBox[{"x", "*", 
      RowBox[{"g", "[", 
       RowBox[{
        RowBox[{"StackInhibit", "[", 
         RowBox[{"Print", "[", 
          RowBox[{"Stack", "[", "]"}], "]"}], "]"}], ";", "2"}], "]"}]}]}], 
    "]"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->372044000],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Plus", ",", "Times", ",", "g", ",", "CompoundExpression"}], 
  "}"}]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->703256928],

Cell[BoxData[
 RowBox[{"1", "+", "x", "+", 
  RowBox[{"f", "[", 
   RowBox[{"2", "+", 
    RowBox[{"x", " ", 
     RowBox[{"g", "[", "2", "]"}]}]}], "]"}]}]], "Output",
 ImageSize->{122, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->49320812]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->73877946],

Cell["Get the detailed stack contents as well: ", "ExampleText",
 CellID->618171458],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "+", "x", "+", 
  RowBox[{"f", "[", 
   RowBox[{"StackBegin", "[", 
    RowBox[{"2", "+", 
     RowBox[{"x", "*", 
      RowBox[{"g", "[", 
       RowBox[{
        RowBox[{"StackInhibit", "[", 
         RowBox[{"Print", "[", 
          RowBox[{"Stack", "[", "_", "]"}], "]"}], "]"}], ";", "2"}], 
       "]"}]}]}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->49635507],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"2", "+", 
     RowBox[{"x", " ", 
      RowBox[{"g", "[", 
       RowBox[{
        RowBox[{"StackInhibit", "[", 
         RowBox[{"Print", "[", 
          RowBox[{"Stack", "[", "_", "]"}], "]"}], "]"}], ";", "2"}], 
       "]"}]}]}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"x", " ", 
     RowBox[{"g", "[", 
      RowBox[{
       RowBox[{"StackInhibit", "[", 
        RowBox[{"Print", "[", 
         RowBox[{"Stack", "[", "_", "]"}], "]"}], "]"}], ";", "2"}], "]"}]}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"g", "[", 
     RowBox[{
      RowBox[{"StackInhibit", "[", 
       RowBox[{"Print", "[", 
        RowBox[{"Stack", "[", "_", "]"}], "]"}], "]"}], ";", "2"}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{
     RowBox[{"StackInhibit", "[", 
      RowBox[{"Print", "[", 
       RowBox[{"Stack", "[", "_", "]"}], "]"}], "]"}], ";", "2"}],
    HoldForm]}], "}"}]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->6850866],

Cell[BoxData[
 RowBox[{"1", "+", "x", "+", 
  RowBox[{"f", "[", 
   RowBox[{"2", "+", 
    RowBox[{"x", " ", 
     RowBox[{"g", "[", "2", "]"}]}]}], "]"}]}]], "Output",
 ImageSize->{122, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->236322228]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3937],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Stack",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Stack"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StackBegin",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StackBegin"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15271]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->29700],

Cell[TextData[ButtonBox["The Evaluation Stack",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheEvaluationStack"]], "Tutorials",
 CellID->5634]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Symbolic Execution History",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicExecutionHistory"]], "MoreAbout",
 CellID->485941904]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"StackInhibit - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 23, 51.2811944}", "context" -> "System`", 
    "keywords" -> {
     "evaluation of functions", "functions being evaluated", 
      "pending evaluations", "partial stack"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "StackInhibit[expr] evaluates expr without modifying the evaluation \
stack. ", "synonyms" -> {"stack inhibit"}, "title" -> "StackInhibit", "type" -> 
    "Symbol", "uri" -> "ref/StackInhibit"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4403, 151, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->267357075]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11057, 396}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1857, 48, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2480, 75, 50, 1, 70, "ObjectName",
 CellID->20717],
Cell[2533, 78, 581, 18, 70, "Usage",
 CellID->23365]
}, Open  ]],
Cell[CellGroupData[{
Cell[3151, 101, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3629, 118, 416, 14, 70, "Notes",
 CellID->29215],
Cell[4048, 134, 318, 12, 70, "Notes",
 CellID->31193]
}, Closed]],
Cell[CellGroupData[{
Cell[4403, 151, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->267357075],
Cell[CellGroupData[{
Cell[4788, 165, 148, 5, 70, "ExampleSection",
 CellID->129797002],
Cell[4939, 172, 215, 8, 70, "ExampleText",
 CellID->445675715],
Cell[CellGroupData[{
Cell[5179, 184, 403, 13, 70, "Input",
 CellID->372044000],
Cell[5585, 199, 183, 5, 23, "Print",
 CellID->703256928],
Cell[5771, 206, 298, 10, 36, "Output",
 CellID->49320812]
}, Open  ]],
Cell[6084, 219, 124, 3, 70, "ExampleDelimiter",
 CellID->73877946],
Cell[6211, 224, 84, 1, 70, "ExampleText",
 CellID->618171458],
Cell[CellGroupData[{
Cell[6320, 229, 410, 13, 70, "Input",
 CellID->49635507],
Cell[6733, 244, 1019, 35, 70, "Print",
 CellID->6850866],
Cell[7755, 281, 299, 10, 36, "Output",
 CellID->236322228]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8115, 298, 310, 9, 70, "SeeAlsoSection",
 CellID->3937],
Cell[8428, 309, 449, 17, 70, "SeeAlso",
 CellID->15271]
}, Open  ]],
Cell[CellGroupData[{
Cell[8914, 331, 314, 9, 70, "TutorialsSection",
 CellID->29700],
Cell[9231, 342, 148, 3, 70, "Tutorials",
 CellID->5634]
}, Open  ]],
Cell[CellGroupData[{
Cell[9416, 350, 299, 8, 70, "MoreAboutSection"],
Cell[9718, 360, 162, 3, 70, "MoreAbout",
 CellID->485941904]
}, Open  ]],
Cell[9895, 366, 27, 0, 70, "History"],
Cell[9925, 368, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

