(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11395,        403]
NotebookOptionsPosition[      8419,        303]
NotebookOutlinePosition[      9659,        339]
CellTagsIndexPosition[      9575,        334]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"String Patterns" :> 
          Documentation`HelpLookup["paclet:tutorial/StringPatterns"], 
          "Working with String Patterns" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/WorkingWithStringPatternsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"String Patterns\"\>", 
       2->"\<\"Working with String Patterns\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EndOfString" :> 
          Documentation`HelpLookup["paclet:ref/EndOfString"], "StartOfLine" :> 
          Documentation`HelpLookup["paclet:ref/StartOfLine"], 
          "StringExpression" :> 
          Documentation`HelpLookup["paclet:ref/StringExpression"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"EndOfString\"\>", 
       2->"\<\"StartOfLine\"\>", 
       3->"\<\"StringExpression\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"String Patterns" :> 
          Documentation`HelpLookup["paclet:guide/StringPatterns"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"String Patterns\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["StartOfString", "ObjectName",
 CellID->26685],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["StartOfString",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/StartOfString"]], "InlineFormula"],
     " \[LineSeparator]represents the start of a string for purposes of \
matching in ",
     Cell[BoxData[
      ButtonBox["StringExpression",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/StringExpression"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->2270]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->165508198],

Cell["Test whether a string starts with an \"a\":", "ExampleText",
 CellID->645002437],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringMatchQ", "[", 
  RowBox[{"\"\<abaababba\>\"", ",", 
   RowBox[{"StartOfString", "~~", "\"\<a\>\"", "~~", "__"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->1024638879],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->118913325]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->938819361],

Cell["Replace the first letter in a string:", "ExampleText",
 CellID->227790604],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<ababbabbaaab\>\"", ",", " ", 
   RowBox[{
    RowBox[{"StartOfString", " ", "~~", " ", "LetterCharacter"}], "  ", 
    "\[Rule]", " ", "\"\<t\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1954063942],

Cell[BoxData["\<\"tbabbabbaaab\"\>"], "Output",
 ImageSize->{88, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->663126246]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5699936],

Cell["Remove the leading spaces:", "ExampleText",
 CellID->1235924502],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StringReplace", "[", 
   RowBox[{"\"\<  Have a nice day.  \>\"", ",", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"StartOfString", " ", "~~", "Whitespace"}], ")"}], " ", 
     "\[Rule]", "  ", "\"\<\>\""}]}], "]"}], "//", "FullForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1721271330],

Cell[BoxData[
 TagBox[
  StyleBox["\"\<Have a nice day.  \>\"",
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//FullForm=",
 CellID->410447582]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22162],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["EndOfString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EndOfString"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StartOfLine",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StartOfLine"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringExpression"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->32506]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->32261],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StringPatterns"]], "Tutorials",
 CellID->8153],

Cell[TextData[ButtonBox["Working with String Patterns",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/WorkingWithStringPatternsOverview"]], "Tutorials",
 CellID->22514736]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->113268905],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringPatterns"]], "MoreAbout",
 CellID->934819885]
}, Open  ]],

Cell["New in 5.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"StartOfString - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 23, 58.6251324}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "StartOfString represents the start of a string for purposes of matching \
in StringExpression.", "synonyms" -> {"start of string"}, "title" -> 
    "StartOfString", "type" -> "Symbol", "uri" -> "ref/StartOfString"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3480, 107, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9440, 327}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2149, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2772, 80, 51, 1, 70, "ObjectName",
 CellID->26685],
Cell[2826, 83, 617, 19, 70, "Usage",
 CellID->2270]
}, Open  ]],
Cell[CellGroupData[{
Cell[3480, 107, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3857, 121, 148, 5, 70, "ExampleSection",
 CellID->165508198],
Cell[4008, 128, 86, 1, 70, "ExampleText",
 CellID->645002437],
Cell[CellGroupData[{
Cell[4119, 133, 207, 6, 28, "Input",
 CellID->1024638879],
Cell[4329, 141, 161, 5, 36, "Output",
 CellID->118913325]
}, Open  ]],
Cell[4505, 149, 125, 3, 70, "ExampleDelimiter",
 CellID->938819361],
Cell[4633, 154, 80, 1, 70, "ExampleText",
 CellID->227790604],
Cell[CellGroupData[{
Cell[4738, 159, 273, 7, 28, "Input",
 CellID->1954063942],
Cell[5014, 168, 177, 5, 36, "Output",
 CellID->663126246]
}, Open  ]],
Cell[5206, 176, 123, 3, 70, "ExampleDelimiter",
 CellID->5699936],
Cell[5332, 181, 70, 1, 70, "ExampleText",
 CellID->1235924502],
Cell[CellGroupData[{
Cell[5427, 186, 327, 9, 70, "Input",
 CellID->1721271330],
Cell[5757, 197, 315, 11, 50, "Output",
 CellID->410447582]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6133, 215, 311, 9, 70, "SeeAlsoSection",
 CellID->22162],
Cell[6447, 226, 724, 26, 70, "SeeAlso",
 CellID->32506]
}, Open  ]],
Cell[CellGroupData[{
Cell[7208, 257, 314, 9, 70, "TutorialsSection",
 CellID->32261],
Cell[7525, 268, 139, 3, 70, "Tutorials",
 CellID->8153],
Cell[7667, 273, 178, 4, 70, "Tutorials",
 CellID->22514736]
}, Open  ]],
Cell[CellGroupData[{
Cell[7882, 282, 319, 9, 70, "MoreAboutSection",
 CellID->113268905],
Cell[8204, 293, 141, 3, 70, "MoreAbout",
 CellID->934819885]
}, Open  ]],
Cell[8360, 299, 29, 0, 70, "History"],
Cell[8392, 301, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

