(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     28887,        931]
NotebookOptionsPosition[     24013,        765]
NotebookOutlinePosition[     25348,        802]
CellTagsIndexPosition[     25263,        797]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Formatted Output" :> 
          Documentation`HelpLookup["paclet:tutorial/FormattedOutput"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Formatted Output\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Tooltip" :> Documentation`HelpLookup["paclet:ref/Tooltip"], 
          "WindowStatusArea" :> 
          Documentation`HelpLookup["paclet:ref/WindowStatusArea"], 
          "Annotation" :> Documentation`HelpLookup["paclet:ref/Annotation"], 
          "Mouseover" :> Documentation`HelpLookup["paclet:ref/Mouseover"], 
          "CurrentValue" :> 
          Documentation`HelpLookup["paclet:ref/CurrentValue"], 
          "ProgressIndicator" :> 
          Documentation`HelpLookup["paclet:ref/ProgressIndicator"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Tooltip\"\>", 
       2->"\<\"WindowStatusArea\"\>", 3->"\<\"Annotation\"\>", 
       4->"\<\"Mouseover\"\>", 5->"\<\"CurrentValue\"\>", 
       6->"\<\"ProgressIndicator\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Annotating & Combining Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/AnnotatingAndCombiningGraphics"], 
          "Data Visualization" :> 
          Documentation`HelpLookup["paclet:guide/DataVisualization"], 
          "Dynamic Graphics Elements" :> 
          Documentation`HelpLookup["paclet:guide/DynamicGraphicsElements"], 
          "Dynamic Visualization" :> 
          Documentation`HelpLookup["paclet:guide/DynamicVisualization"], 
          "Graphics Annotation & Appearance" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsAnnotationAndAppearance"], "Palettes" :> 
          Documentation`HelpLookup["paclet:guide/Palettes"], 
          "Viewers and Annotation" :> 
          Documentation`HelpLookup["paclet:guide/ViewersAndAnnotation"], 
          "New in 6.0: Dynamic Interactivity" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DynamicInteractivity"], 
          "New in 6.0: Graphics & Visualization Options" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Annotating & Combining Graphics\"\>", 
       2->"\<\"Data Visualization\"\>", 
       3->"\<\"Dynamic Graphics Elements\"\>", 
       4->"\<\"Dynamic Visualization\"\>", 
       5->"\<\"Graphics Annotation & Appearance\"\>", 6->"\<\"Palettes\"\>", 
       7->"\<\"Viewers and Annotation\"\>", 
       8->"\<\"New in 6.0: Dynamic Interactivity\"\>", 
       9->"\<\"New in 6.0: Graphics & Visualization Options\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["StatusArea", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StatusArea",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StatusArea"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["string", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]displays ",
     Cell[BoxData[
      StyleBox["string", "TI"]], "InlineFormula"],
     " in the status area of the current notebook when the mouse pointer is \
in the region where ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " appears. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->21757]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["StatusArea",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StatusArea"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["string", "TI"]}], "]"}]], "InlineFormula"],
 " allows ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " to be graphics or any other expression. "
}], "Notes",
 CellID->24891],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StatusArea",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StatusArea"]], "InlineFormula"],
 " can be used to specify status lines for curves and points in functions \
like ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ListPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPlot"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->13459],

Cell[TextData[{
 "Status area specifications from ",
 Cell[BoxData[
  ButtonBox["StatusArea",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StatusArea"]], "InlineFormula"],
 " override the setting for the ",
 Cell[BoxData[
  ButtonBox["WindowStatusArea",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WindowStatusArea"]], "InlineFormula",
  ShowStringCharacters->False],
 " option. "
}], "Notes",
 CellID->5439]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->156197683],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->616515727],

Cell[TextData[{
 "Display ",
 Cell[BoxData["label"], "InlineFormula"],
 " in the status area whenever the mouse is over ",
 Cell[BoxData[
  RowBox[{"x", "+", "y"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->132765532],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StatusArea", "[", 
  RowBox[{
   RowBox[{"x", "+", "y"}], ",", "\"\<label\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->262167086],

Cell[BoxData[
 TagBox[
  RowBox[{"x", "+", "y"}],
  StatusArea[#, "label"]& ,
  TagBoxNote->"label"]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->257704626]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->302],

Cell["\<\
Labels appear in the status area as the mouse moves over the graphs.\
\>", "ExampleText",
 CellID->86576459],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"StatusArea", "[", 
      RowBox[{
       RowBox[{"Sin", "[", "x", "]"}], ",", "\"\<Sine\>\""}], "]"}], ",", 
     RowBox[{"StatusArea", "[", 
      RowBox[{
       RowBox[{"Cos", "[", "x", "]"}], ",", "\"\<Cosine\>\""}], "]"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19522003],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20041572]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5750781],

Cell["Display the mouse coordinates in the status area:", "ExampleText",
 CellID->60837903],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dynamic", "[", 
  RowBox[{"StatusArea", "[", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}], ",", 
    RowBox[{"MousePosition", "[", "\"\<Graphics\>\"", "]"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->49420938],

Cell[BoxData[
 DynamicBox[ToBoxes[
   StatusArea[
    Plot[
     Sin[$CellContext`x], {$CellContext`x, 0, 10}], 
    MousePosition["Graphics"]], StandardForm],
  ImageSizeCache->{180., {51., 55.}}]], "Output",
 ImageSize->{184, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->758848644]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27100],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StatusArea", "[", 
  RowBox[{
   RowBox[{"Hyperlink", "[", 
    RowBox[{
     RowBox[{"Framed", "[", "\"\<Wolfram\>\"", "]"}], ",", 
     "\"\<http://www.wolfram.com\>\""}], "]"}], ",", 
   "\"\<Makers of Mathematica\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->358238139],

Cell[BoxData[
 TagBox[
  TagBox[
   ButtonBox[
    PaneSelectorBox[{False->
     FrameBox["\<\"Wolfram\"\>",
      StripOnInput->False], True->
     StyleBox[
      FrameBox["\<\"Wolfram\"\>",
       StripOnInput->False], "HyperlinkActive"]}, Dynamic[
      CurrentValue["MouseOver"]],
     BaselinePosition->Baseline,
     FrameMargins->0,
     ImageSize->Automatic],
    BaseStyle->"Hyperlink",
    ButtonData->{
      URL["http://www.wolfram.com"], None},
    ButtonNote->"http://www.wolfram.com"],
   Annotation[#, "http://www.wolfram.com", "Hyperlink"]& ],
  StatusArea[#, "Makers of Mathematica"]& ,
  TagBoxNote->"Makers of Mathematica"]], "Output",
 ImageSize->{63, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->486209254]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17516],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StatusArea",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StatusArea"]], "InlineFormula"],
 " presents the label in the status area:"
}], "ExampleText",
 CellID->477652960],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StatusArea", "[", 
  RowBox[{
   RowBox[{"x", "+", "y"}], ",", "label"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->343638917],

Cell[BoxData[
 TagBox[
  RowBox[{"x", "+", "y"}],
  StatusArea[#, $CellContext`label]& ,
  TagBoxNote->"label"]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->54324094]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Tooltip",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tooltip"]], "InlineFormula"],
 " presents the label in a popup box:"
}], "ExampleText",
 CellID->96543143],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tooltip", "[", 
  RowBox[{
   RowBox[{"x", "+", "y"}], ",", "label"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->477464077],

Cell[BoxData[
 TagBox[
  TooltipBox[
   RowBox[{"x", "+", "y"}],
   "label"],
  Annotation[#, $CellContext`label, "Tooltip"]& ]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->218666862]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Mouseover",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mouseover"]], "InlineFormula"],
 " changes the expression itself:"
}], "ExampleText",
 CellID->30166704],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mouseover", "[", 
  RowBox[{
   RowBox[{"x", "+", "y"}], ",", "label"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->150980044],

Cell[BoxData[
 PaneSelectorBox[{False->
  RowBox[{"x", "+", "y"}], True->"label"}, Dynamic[
   CurrentValue["MouseOver"]],
  FrameMargins->0,
  ImageSize->Automatic]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->335004751]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2642],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Tooltip",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tooltip"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WindowStatusArea",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WindowStatusArea"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Annotation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Annotation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Mouseover",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mouseover"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CurrentValue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CurrentValue"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ProgressIndicator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ProgressIndicator"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->32116]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->23120],

Cell[TextData[ButtonBox["Formatted Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FormattedOutput"]], "Tutorials",
 CellID->175077611]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->175616413],

Cell[TextData[ButtonBox["Annotating & Combining Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AnnotatingAndCombiningGraphics"]], "MoreAbout",
 CellID->399070492],

Cell[TextData[ButtonBox["Data Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataVisualization"]], "MoreAbout",
 CellID->355704909],

Cell[TextData[ButtonBox["Dynamic Graphics Elements",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DynamicGraphicsElements"]], "MoreAbout",
 CellID->829127878],

Cell[TextData[ButtonBox["Dynamic Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DynamicVisualization"]], "MoreAbout",
 CellID->429936463],

Cell[TextData[ButtonBox["Graphics Annotation & Appearance",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsAnnotationAndAppearance"]], "MoreAbout",
 CellID->105061972],

Cell[TextData[ButtonBox["Palettes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Palettes"]], "MoreAbout",
 CellID->13574251],

Cell[TextData[ButtonBox["Viewers and Annotation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ViewersAndAnnotation"]], "MoreAbout",
 CellID->309915667],

Cell[TextData[ButtonBox["New in 6.0: Dynamic Interactivity",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DynamicInteractivity"]], "MoreAbout",
 CellID->127237302],

Cell[TextData[ButtonBox["New in 6.0: Graphics & Visualization Options",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]], "MoreAbout",
 CellID->50952507]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"StatusArea - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 23, 59.2032722}", "context" -> "System`", 
    "keywords" -> {"status line", "drill down", "dynamic status"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "StatusArea[expr, string] displays string in the status area of the \
current notebook when the mouse pointer is in the region where expr appears. \
", "synonyms" -> {"status area"}, "title" -> "StatusArea", "type" -> "Symbol",
     "uri" -> "ref/StatusArea"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8559, 249, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->156197683]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 25120, 790}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3721, 82, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4344, 109, 1575, 37, 70, "ObjectNameGrid"],
Cell[5922, 148, 775, 24, 70, "Usage",
 CellID->21757]
}, Open  ]],
Cell[CellGroupData[{
Cell[6734, 177, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7212, 194, 390, 14, 70, "Notes",
 CellID->24891],
Cell[7605, 210, 497, 18, 70, "Notes",
 CellID->13459],
Cell[8105, 230, 417, 14, 70, "Notes",
 CellID->5439]
}, Closed]],
Cell[CellGroupData[{
Cell[8559, 249, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->156197683],
Cell[CellGroupData[{
Cell[8944, 263, 148, 5, 70, "ExampleSection",
 CellID->616515727],
Cell[9095, 270, 227, 8, 70, "ExampleText",
 CellID->132765532],
Cell[CellGroupData[{
Cell[9347, 282, 165, 5, 28, "Input",
 CellID->262167086],
Cell[9515, 289, 242, 9, 36, "Output",
 CellID->257704626]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9806, 304, 214, 7, 70, "ExampleSection",
 CellID->302],
Cell[10023, 313, 118, 3, 70, "ExampleText",
 CellID->86576459],
Cell[CellGroupData[{
Cell[10166, 320, 464, 15, 70, "Input",
 CellID->19522003],
Cell[10633, 337, 4408, 76, 70, "Output",
 Evaluatable->False,
 CellID->20041572]
}, Open  ]],
Cell[15056, 416, 123, 3, 70, "ExampleDelimiter",
 CellID->5750781],
Cell[15182, 421, 91, 1, 70, "ExampleText",
 CellID->60837903],
Cell[CellGroupData[{
Cell[15298, 426, 382, 12, 70, "Input",
 CellID->49420938],
Cell[15683, 440, 341, 11, 70, "Output",
 CellID->758848644]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16073, 457, 223, 7, 70, "ExampleSection",
 CellID->27100],
Cell[CellGroupData[{
Cell[16321, 468, 308, 9, 70, "Input",
 CellID->358238139],
Cell[16632, 479, 786, 25, 70, "Output",
 CellID->486209254]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17467, 510, 233, 7, 70, "ExampleSection",
 CellID->17516],
Cell[17703, 519, 220, 7, 70, "ExampleText",
 CellID->477652960],
Cell[CellGroupData[{
Cell[17948, 530, 157, 5, 70, "Input",
 CellID->343638917],
Cell[18108, 537, 252, 9, 36, "Output",
 CellID->54324094]
}, Open  ]],
Cell[18375, 549, 209, 7, 70, "ExampleText",
 CellID->96543143],
Cell[CellGroupData[{
Cell[18609, 560, 154, 5, 70, "Input",
 CellID->477464077],
Cell[18766, 567, 269, 10, 70, "Output",
 CellID->218666862]
}, Open  ]],
Cell[19050, 580, 209, 7, 70, "ExampleText",
 CellID->30166704],
Cell[CellGroupData[{
Cell[19284, 591, 156, 5, 70, "Input",
 CellID->150980044],
Cell[19443, 598, 307, 10, 70, "Output",
 CellID->335004751]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19811, 615, 310, 9, 70, "SeeAlsoSection",
 CellID->2642],
Cell[20124, 626, 1477, 53, 70, "SeeAlso",
 CellID->32116]
}, Open  ]],
Cell[CellGroupData[{
Cell[21638, 684, 314, 9, 70, "TutorialsSection",
 CellID->23120],
Cell[21955, 695, 146, 3, 70, "Tutorials",
 CellID->175077611]
}, Open  ]],
Cell[CellGroupData[{
Cell[22138, 703, 319, 9, 70, "MoreAboutSection",
 CellID->175616413],
Cell[22460, 714, 173, 3, 70, "MoreAbout",
 CellID->399070492],
Cell[22636, 719, 147, 3, 70, "MoreAbout",
 CellID->355704909],
Cell[22786, 724, 160, 3, 70, "MoreAbout",
 CellID->829127878],
Cell[22949, 729, 153, 3, 70, "MoreAbout",
 CellID->429936463],
Cell[23105, 734, 175, 3, 70, "MoreAbout",
 CellID->105061972],
Cell[23283, 739, 127, 3, 70, "MoreAbout",
 CellID->13574251],
Cell[23413, 744, 154, 3, 70, "MoreAbout",
 CellID->309915667],
Cell[23570, 749, 172, 3, 70, "MoreAbout",
 CellID->127237302],
Cell[23745, 754, 196, 4, 70, "MoreAbout",
 CellID->50952507]
}, Open  ]],
Cell[23956, 761, 27, 0, 70, "History"],
Cell[23986, 763, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

