(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    278272,       5657]
NotebookOptionsPosition[    269720,       5368]
NotebookOutlinePosition[    271226,       5408]
CellTagsIndexPosition[    271139,       5403]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Monitoring and Selecting Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MonitoringAndSelectingAlgorithms"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Monitoring and Selecting Algorithms\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EvaluationMonitor" :> 
          Documentation`HelpLookup["paclet:ref/EvaluationMonitor"], "Sow" :> 
          Documentation`HelpLookup["paclet:ref/Sow"], "Monitor" :> 
          Documentation`HelpLookup["paclet:ref/Monitor"], "Print" :> 
          Documentation`HelpLookup["paclet:ref/Print"], "Method" :> 
          Documentation`HelpLookup["paclet:ref/Method"], "MaxSteps" :> 
          Documentation`HelpLookup["paclet:ref/MaxSteps"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"EvaluationMonitor\"\>", 
       2->"\<\"Sow\"\>", 3->"\<\"Monitor\"\>", 4->"\<\"Print\"\>", 
       5->"\<\"Method\"\>", 6->"\<\"MaxSteps\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Differential Equations" :> 
          Documentation`HelpLookup["paclet:guide/DifferentialEquations"], 
          "Numerical Evaluation & Precision" :> 
          Documentation`HelpLookup[
           "paclet:guide/NumericalEvaluationAndPrecision"], 
          "Tuning & Debugging" :> 
          Documentation`HelpLookup["paclet:guide/TuningAndDebugging"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Differential Equations\"\>", 
       2->"\<\"Numerical Evaluation & Precision\"\>", 
       3->"\<\"Tuning & Debugging\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["StepMonitor", "ObjectName",
 CellID->15180],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["StepMonitor",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/StepMonitor"]], "InlineFormula"],
     "\[LineSeparator]is an option for iterative numerical computation \
functions that gives an expression to evaluate whenever a step is taken by \
the numerical method used. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->10045]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The option setting is normally given as ",
 Cell[BoxData[
  RowBox[{"StepMonitor", ":>", 
   StyleBox["expr", "TI"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->20300],

Cell[TextData[{
 "The ",
 Cell[BoxData[":>"], "InlineFormula"],
 " is used instead of ",
 Cell[BoxData["->"], "InlineFormula"],
 " to avoid ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " being immediately evaluated. "
}], "Notes",
 CellID->14379],

Cell[TextData[{
 "Whenever ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is evaluated, all variables in the numerical computation are assigned \
their current values. "
}], "Notes",
 CellID->11355],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Block",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Block"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["var", "TI"], 
        StyleBox["1", "TR"]], "=", 
       SubscriptBox[
        StyleBox["val", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " is effectively used. "
}], "Notes",
 CellID->3476]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->227888789],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->159410782],

Cell[TextData[{
 "Monitor steps taken for a numerical minimization with ",
 Cell[BoxData[
  ButtonBox["FindMinimum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMinimum"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->71525653],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMinimum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", "x", "]"}], " ", "+", " ", 
    RowBox[{"1", "/", "x"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1"}], "}"}], ",", 
   RowBox[{"StepMonitor", "\[RuleDelayed]", 
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Step to x = \>\"", ",", "x"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->37659208],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Step to x = \"\>", "\[InvisibleSpace]", 
   "0.7888860720867006`"}],
  SequenceForm["Step to x = ", 0.7888860720867006],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->89225757],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Step to x = \"\>", "\[InvisibleSpace]", 
   "0.6773157596925296`"}],
  SequenceForm["Step to x = ", 0.6773157596925296],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->758155671],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Step to x = \"\>", "\[InvisibleSpace]", 
   "0.7065780750020638`"}],
  SequenceForm["Step to x = ", 0.7065780750020638],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->229547609],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Step to x = \"\>", "\[InvisibleSpace]", 
   "0.7035869069988058`"}],
  SequenceForm["Step to x = ", 0.7035869069988058],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->500411867],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Step to x = \"\>", "\[InvisibleSpace]", 
   "0.7034668856844262`"}],
  SequenceForm["Step to x = ", 0.7034668856844262],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->48189309],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Step to x = \"\>", "\[InvisibleSpace]", 
   "0.7034674225912187`"}],
  SequenceForm["Step to x = ", 0.7034674225912187],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->113583676]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3.442277294494974`", ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "0.7034674225912187`"}], "}"}]}], "}"}]], "Output",\

 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->205158846]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->48982570],

Cell["Count steps:", "ExampleText",
 CellID->232512768],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"c", "=", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"FindMinimum", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Exp", "[", "x", "]"}], " ", "+", " ", 
        RowBox[{"1", "/", "x"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "1"}], "}"}], ",", " ", 
       RowBox[{"StepMonitor", "\[RuleDelayed]", 
        RowBox[{"c", "++"}]}]}], "]"}], ",", "c"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->567579586],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3.442277294494974`", ",", 
     RowBox[{"{", 
      RowBox[{"x", "\[Rule]", "0.7034674225912187`"}], "}"}]}], "}"}], ",", 
   "6"}], "}"}]], "Output",
 ImageSize->{204, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->702318322]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->440031806],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Reap",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reap"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Sow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sow"]], "InlineFormula"],
 " to collect step data:"
}], "ExampleText",
 CellID->130128556],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], "=", 
   RowBox[{
    RowBox[{"Exp", "[", "x", "]"}], "+", 
    RowBox[{"1", "/", "x"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{"res", ",", "steps"}], "}"}], "=", 
  RowBox[{"Reap", "[", 
   RowBox[{"FindMinimum", "[", 
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "3"}], "}"}], ",", 
     RowBox[{"StepMonitor", "\[RuleDelayed]", 
      RowBox[{"Sow", "[", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"f", "[", "x", "]"}]}], "}"}], "]"}]}]}], "]"}], 
   "]"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->984478191],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3.442277294494974`", ",", 
     RowBox[{"{", 
      RowBox[{"x", "\[Rule]", "0.7034674226865598`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1.5`", ",", "5.1483557370047315`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1.1200164340171592`", ",", "3.9577486135249575`"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"0.6330446600221276`", ",", "3.463003357411588`"}], "}"}], ",",
       
      RowBox[{"{", 
       RowBox[{"0.7365374561265419`", ",", "3.446394998839886`"}], "}"}], ",",
       
      RowBox[{"{", 
       RowBox[{"0.706922829554141`", ",", "3.442323502269374`"}], "}"}], ",", 
      
      RowBox[{"{", 
       RowBox[{"0.7033060264155692`", ",", "3.4422773956559007`"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"0.7034682279419598`", ",", "3.4422772944974933`"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"0.7034674226865598`", ",", "3.442277294494974`"}], "}"}]}], 
     "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{459, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->52867424]
}, Open  ]],

Cell["Show steps on a plot of the function:", "ExampleText",
 CellID->281917312],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", ".1", ",", "1.5"}], "}"}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", 
      RowBox[{"Map", "[", 
       RowBox[{"Point", ",", 
        RowBox[{"steps", "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], "}"}]}]}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->446165886],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 126},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->278000332]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->126352434],

Cell["\<\
Monitor the solution progress when solving the sine-Gordon PDE:\
\>", "ExampleText",
 CellID->129132036],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Monitor", "[", 
  RowBox[{
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SubscriptBox["\[PartialD]", 
          RowBox[{"t", ",", "t"}]], 
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "x"}], "]"}]}], "\[Equal]", 
        RowBox[{
         RowBox[{
          SubscriptBox["\[PartialD]", 
           RowBox[{"x", ",", "x"}]], 
          RowBox[{"u", "[", 
           RowBox[{"t", ",", "x"}], "]"}]}], "+", 
         RowBox[{"Sin", "[", 
          RowBox[{"u", "[", 
           RowBox[{"t", ",", "x"}], "]"}], "]"}]}]}], " ", ",", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"0", ",", "x"}], "]"}], "\[Equal]", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", 
          SuperscriptBox["x", "2"]}]]}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["u", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"0", ",", "x"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"t", ",", 
          RowBox[{"-", "10"}]}], "]"}], "\[Equal]", 
        RowBox[{"u", "[", 
         RowBox[{"t", ",", "10"}], "]"}]}]}], "}"}], ",", "u", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
     RowBox[{"StepMonitor", "\[RuleDelayed]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sol", "=", 
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "x"}], "]"}]}], ";", " ", 
        RowBox[{"time", "=", "t"}]}], ")"}]}]}], "]"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{"sol", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "8"}], "}"}]}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", "time"}]}], "]"}]}], "]"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[1]:=",
 CellID->58124783],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"u", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0.`", ",", "10.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "10.`"}], ",", "10.`"}], "}"}]}], "}"}], 
       ",", "\<\"<>\"\>"}], "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 ImageSize->{402, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->607786033]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->265701811],

Cell["\<\
Monitor steps taken to numerically solve a system of equations:\
\>", "ExampleText",
 CellID->177463447],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"res", ",", " ", 
    RowBox[{"{", "steps", "}"}]}], "}"}], "=", 
  RowBox[{"Reap", "[", 
   RowBox[{"FindRoot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "+", 
         RowBox[{"y", "^", "2"}]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"y", "+", 
         RowBox[{"Cos", "[", "x", "]"}]}], "\[Equal]", "0"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"StepMonitor", "\[RuleDelayed]", 
      RowBox[{"Sow", "[", 
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}], "]"}]}]}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->64175913],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "0.6417143708728826`"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "0.8010707652092184`"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.`", ",", 
        RowBox[{"-", "0.5`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.75`"}], ",", 
        RowBox[{"-", "1.`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.6287183224056148`"}], ",", 
        RowBox[{"-", "0.8143591612028074`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.6416808184188504`"}], ",", 
        RowBox[{"-", "0.8011585821215`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.6417143673051949`"}], ",", 
        RowBox[{"-", "0.8010707677955492`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.6417143708728826`"}], ",", 
        RowBox[{"-", "0.8010707652092184`"}]}], "}"}]}], "}"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{522, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->127343525]
}, Open  ]],

Cell["Show steps on a surface plot of the functions:", "ExampleText",
 CellID->285988005],

Cell[BoxData[{
 RowBox[{
  RowBox[{"pts1", "=", 
   RowBox[{"Apply", "[", 
    RowBox[{
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "y", ",", 
         RowBox[{"x", "+", 
          RowBox[{"y", "^", "2"}]}]}], "}"}]}], "]"}], ",", "steps", ",", 
     RowBox[{"{", "1", "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pts2", "=", 
   RowBox[{"Apply", "[", 
    RowBox[{
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "y", ",", 
         RowBox[{"y", "+", 
          RowBox[{"Cos", "[", "x", "]"}]}]}], "}"}]}], "]"}], ",", "steps", 
     ",", 
     RowBox[{"{", "1", "}"}]}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->288695352],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"Plot3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "+", 
        RowBox[{"y", "^", "2"}]}], ",", 
       RowBox[{
        RowBox[{"Cos", "[", "x", "]"}], "+", "y"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", " ", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Opacity", "[", ".5", "]"}], ",", "Blue"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Opacity", "[", ".5", "]"}], ",", "Red"}], "}"}]}], "}"}]}],
      ",", " ", 
     RowBox[{"Mesh", "\[Rule]", "False"}]}], "]"}], ",", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Thickness", "[", "Medium", "]"}], ",", 
      RowBox[{"PointSize", "[", "Large", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"Blue", ",", " ", 
        RowBox[{"Line", "[", "pts1", "]"}], ",", 
        RowBox[{"Point", "[", "pts1", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Red", ",", 
        RowBox[{"Line", "[", "pts2", "]"}], ",", 
        RowBox[{"Point", "[", "pts2", "]"}]}], "}"}]}], "}"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->725029972],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{282, 214},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{300, 227.1111853988975}},
 CellLabel->"Out[3]=",
 CellID->915640436]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28586626],

Cell["Steps in parameter space for a nonlinear fit:", "ExampleText",
 CellID->735994752],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.18", ",", 
       RowBox[{"-", "0.13"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.84", ",", 
       RowBox[{"-", "0.06"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.05", ",", "0.88"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.24", ",", 
       RowBox[{"-", "0.63"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.67", ",", "0.93"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.05", ",", "0.88"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.65", ",", "0.92"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.01", ",", "0.99"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.17", ",", 
       RowBox[{"-", "0.04"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.23", ",", 
       RowBox[{"-", "0.55"}]}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->37843928],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"model", "[", 
    RowBox[{"{", 
     RowBox[{"a_", ",", " ", "k_", ",", " ", "w_", ",", " ", "p_"}], "}"}], 
    "]"}], " ", "=", " ", 
   RowBox[{"a", " ", 
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"-", "k"}], " ", "x"}], "]"}], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"w", " ", "x"}], " ", "+", "p"}], "]"}]}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->67367124],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"fit", ",", " ", "evals"}], "}"}], " ", "=", " ", 
  RowBox[{"Reap", "[", 
   RowBox[{"FindFit", "[", 
    RowBox[{"data", ",", " ", 
     RowBox[{"model", "[", 
      RowBox[{"{", 
       RowBox[{"a", ",", "k", ",", "w", ",", "p"}], "}"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "k", ",", "w", ",", "p"}], "}"}], ",", "x", ",", " ", 
     
     RowBox[{"StepMonitor", "\[RuleDelayed]", 
      RowBox[{"Sow", "[", 
       RowBox[{"{", 
        RowBox[{"a", ",", "k", ",", "w", ",", "p"}], "}"}], "]"}]}]}], "]"}], 
   "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->236963337],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[Rule]", "0.9972788935407546`"}], ",", 
     RowBox[{"k", "\[Rule]", "0.10440754896764828`"}], ",", 
     RowBox[{"w", "\[Rule]", 
      RowBox[{"-", "9.416425570747133`"}]}], ",", 
     RowBox[{"p", "\[Rule]", "1.5609257497834454`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.38093507867778`", ",", "1.6996894552400676`", ",", 
        RowBox[{"-", "10.354206820695074`"}], ",", "2.348171972607684`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.4898643186254818`", ",", "1.6002581410004173`", ",", 
        RowBox[{"-", "11.628107526687389`"}], ",", "2.168818624831494`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.7585895314040375`", ",", "1.2581085853456344`", ",", 
        RowBox[{"-", "10.040257955550063`"}], ",", "1.9017176372000126`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.9487784671568626`", ",", 
        RowBox[{"-", "0.7001168202849426`"}], ",", 
        RowBox[{"-", "9.101399492503266`"}], ",", "1.3968423024428216`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.9849907487549612`", ",", 
        RowBox[{"-", "0.06484428693420108`"}], ",", 
        RowBox[{"-", "9.341772113358886`"}], ",", "1.5461140519499206`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.9972269179643266`", ",", "0.09793243870995838`", ",", 
        RowBox[{"-", "9.407988962273128`"}], ",", "1.5596747434744662`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.9972812198476868`", ",", "0.10441107991538166`", ",", 
        RowBox[{"-", "9.416376272347184`"}], ",", "1.560916704508363`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.9972788931964798`", ",", "0.10440754664541053`", ",", 
        RowBox[{"-", "9.416425561235117`"}], ",", "1.560925747004169`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.9972788935407546`", ",", "0.10440754896764828`", ",", 
        RowBox[{"-", "9.416425570747133`"}], ",", "1.5609257497834454`"}], 
       "}"}]}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{574, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->135135994]
}, Open  ]],

Cell["\<\
Sequence of plots showing the evolution of the model over the steps:\
\>", "ExampleText",
 CellID->205567056],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"lp", " ", "=", " ", 
   RowBox[{"ListPlot", "[", 
    RowBox[{"data", ",", " ", 
     RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Show", "[", 
     RowBox[{"lp", ",", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"model", "[", "#", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]}], "]"}], "&"}], 
   ",", 
   RowBox[{"evals", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->14806094],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{487, 272},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[4]=",
 CellID->121081581]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->481444840],

Cell[TextData[{
 "Plot the spatial (",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ") solution for time (",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 ") steps used numerically solving a PDE with ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->817534615],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"sol", ",", " ", "steps"}], "}"}], "=", 
   RowBox[{"Reap", "[", 
    RowBox[{"NDSolve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"u", "[", 
            RowBox[{"t", ",", "x"}], "]"}], ",", "t"}], "]"}], "\[Equal]", 
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"u", "[", 
            RowBox[{"t", ",", "x"}], "]"}], ",", "x", ",", "x"}], "]"}]}], 
        ",", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"0", ",", "x"}], "]"}], "\[Equal]", "0"}], ",", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "0"}], "]"}], "\[Equal]", 
         RowBox[{"Sin", "[", 
          RowBox[{"6", " ", "\[Pi]", " ", "t"}], "]"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"u", "[", 
              RowBox[{"t", ",", "x"}], "]"}], ",", "x"}], "]"}], " ", "/.", 
           " ", 
           RowBox[{"x", "\[Rule]", "1"}]}], ")"}], " ", "\[Equal]", " ", 
         "0"}]}], "}"}], ",", "u", ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", " ", 
      RowBox[{"StepMonitor", "\[RuleDelayed]", 
       RowBox[{"Sow", "[", 
        RowBox[{"ParametricPlot3D", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"t", ",", "x", ",", 
            RowBox[{"u", "[", 
             RowBox[{"t", ",", "x"}], "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}]}], 
     "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->321180971],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"splot", "=", 
  RowBox[{"Show", "[", 
   RowBox[{"steps", ",", " ", 
    RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
    RowBox[{"BoxRatios", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "0.4"}], "}"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->624244831],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{280, 223},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->9415619]
}, Open  ]],

Cell["Show the steps with a surface plot of the solution:", "ExampleText",
 CellID->75928319],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"Plot3D", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{"First", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"t", ",", "x"}], "]"}], " ", "/.", " ", "sol"}], "]"}], 
      "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", " ", 
     RowBox[{"Mesh", "\[Rule]", "False"}]}], "]"}], ",", " ", "splot"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->644214206],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{305, 244},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->89300983]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->209915728],

Cell["\<\
Show how precision is adapted for high-precision root finding: \
\>", "ExampleText",
 CellID->488344211],

Cell[BoxData[
 RowBox[{
  RowBox[{"newts", "=", 
   RowBox[{
    RowBox[{"Reap", "[", 
     RowBox[{"FindRoot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "-", "2"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "1."}], "}"}], ",", 
       RowBox[{"WorkingPrecision", "\[Rule]", "1000"}], ",", 
       RowBox[{"StepMonitor", "\[RuleDelayed]", 
        RowBox[{"Sow", "[", 
         RowBox[{"Precision", "[", "x", "]"}], "]"}]}], ",", " ", 
       RowBox[{"Method", "\[Rule]", "\"\<Newton\>\""}]}], "]"}], "]"}], "[", 
    RowBox[{"[", 
     RowBox[{"2", ",", "1"}], "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13235078],

Cell[BoxData[
 RowBox[{
  RowBox[{"secs", "=", 
   RowBox[{
    RowBox[{"Reap", "[", 
     RowBox[{"FindRoot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "-", "2"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "1.", ",", "2."}], "}"}], ",", 
       RowBox[{"WorkingPrecision", "\[Rule]", "1000"}], ",", 
       RowBox[{"StepMonitor", "\[RuleDelayed]", 
        RowBox[{"Sow", "[", 
         RowBox[{"Precision", "[", "x", "]"}], "]"}]}], ",", " ", 
       RowBox[{"Method", "\[Rule]", "\"\<Brent\>\""}]}], "]"}], "]"}], "[", 
    RowBox[{"[", 
     RowBox[{"2", ",", "1"}], "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->61614511],

Cell["\<\
The quadratic convergence of Newton's method allows eventual precision \
doubling at each step:\
\>", "ExampleText",
 CellID->275659737],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"newts", ",", " ", "secs"}], "}"}], ",", " ", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->234098660],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], 
    PointBox[{{1., 15.954589770191003`}, {2., 15.954589770191003`}, {3., 
     15.954589770191003`}, {4., 15.954589770191003`}, {5., 
     31.2594071873645}, {6., 62.518814374729}, {7., 125.037628749458}, {8., 
     250.075257498916}, {9., 500.150514997832}, {10., 1000.}, {11., 
     1000.}}]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], 
    PointBox[{{1., 15.954589770191003`}, {2., 15.954589770191003`}, {3., 
     15.954589770191003`}, {4., 15.954589770191003`}, {5., 
     15.954589770191003`}, {6., 21.292644047814886`}, {7., 
     34.45222177971763}, {8., 34.45222177971763}, {9., 55.74486582753252}, {
     10., 90.19708760725015}, {11., 145.9419534347827}, {12., 
     236.13904104203286`}, {13., 382.0809944768156}, {14., 
     618.2200355188485}, {15., 1000.}}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->370312268]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->679429632],

Cell["\<\
Investigate steps and evaluations for a numerical minimization:\
\>", "ExampleText",
 CellID->39726061],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"sol", ",", " ", "data"}], "}"}], " ", "=", " ", 
   RowBox[{"Reap", "[", 
    RowBox[{
     RowBox[{"FindMinimum", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], "+", 
        RowBox[{"100", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"y", "-", 
            RowBox[{"x", "^", "2"}]}], ")"}], "^", "2"}]}]}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", 
           RowBox[{"-", "1"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"y", ",", "1"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
        RowBox[{"Sow", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x", ",", "y"}], "}"}], ",", "\"\<Evaluations\>\""}], 
         "]"}]}], ",", 
       RowBox[{"StepMonitor", "\[RuleDelayed]", " ", 
        RowBox[{"Sow", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x", ",", "y"}], "}"}], ",", "\"\<Steps\>\""}], "]"}]}]}], 
      "]"}], ",", "_", ",", "Rule"}], "]"}]}], ";", "sol"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->315075895],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "1.`"}], ",", 
     RowBox[{"y", "\[Rule]", "1.`"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{143, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->33203983]
}, Open  ]],

Cell["\<\
Show evaluations in red, steps in yellow, and the final point in green:\
\>", "ExampleText",
 CellID->166295432],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], "+", 
    RowBox[{"100", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"y", "-", 
        RowBox[{"x", "^", "2"}]}], ")"}], "^", "2"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Green", ",", " ", 
        RowBox[{"PointSize", "[", "0.05", "]"}], ",", " ", 
        RowBox[{"Point", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x", ",", "y"}], "}"}], " ", "/.", " ", 
          RowBox[{"sol", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Yellow", ",", " ", 
        RowBox[{"PointSize", "[", "0.03", "]"}], ",", " ", 
        RowBox[{"Point", "[", 
         RowBox[{"\"\<Steps\>\"", "/.", "data"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Red", ",", " ", 
        RowBox[{"PointSize", "[", "0.015", "]"}], ",", " ", 
        RowBox[{"Point", "[", 
         RowBox[{"\"\<Evaluations\>\"", " ", "/.", " ", "data"}], "]"}]}], 
       "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->351378906],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyEfXVYlc/ztqJgd6HYCXa3roHdmNid2N3d3WJ3B3ahI6iICkoJgsShzuE0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   "], {{{}, 
     {RGBColor[0.3371380401045714, 0.13342521994899653`, 0.5908686165537552], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNnHnclmPax6/7up/9vp+n+yFjH1tlG0KKMRSyLyGhsdQUZSki1DTRvlJK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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllltsVVUQhje0pafsfc7ZB4xi0CAE1Ed5QGICBYwgKJpYAbkJiqJBBKwo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         "],
         VertexColors->None]}]}, 
     {RGBColor[
      0.42458212031371406`, 0.28546685984698955`, 0.7137818496612657], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmnn4XdO9xvfP70z7nH3O2UcioUEmglDtbSVVQSkPQlRRs3vFWEOF1CyJ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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHmUVNURxt/Y3dM9vNfd7wGCkkQFlJyjSU4SFYkalcQjIChCRNZEgiYi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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.5120262005228567, 0.43750849974498257`, 0.836695082768776], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmgm0ldV1x78H975377vfvff7CIPM8EhLQ7SmhYhGTRRMQiwoSddS4gOx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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHmQVdURxu/MvHXue/fdR1RQEBBNGbeUhkFAISoiIBIgWoULIDuMomgU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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.5900314329820104, 0.5696785221424392, 0.9100962614859219], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmnu41lWVx3/wXs57/f3eVytMRS5SgALKRRsOZWWBoXGR+xkdkQMK3nCE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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlwm0VWUVxw/ce8+975177zlXbaXFKBSjzGA8nLJaCgaiaMQM8gDLhEgF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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.654323065786623, 0.6729772867223464, 0.9115619126929317], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmH2QVWUdxw/svffcu+fcc86yNg2FOrRjaoDg0ssS0rqQE8nrUmkuCoGi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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3mwj2UUxx/8Fve+2+8XzTCpRkbZ3a4W2q4lkp2kTYRoQyrlyh+MtqmZ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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.7186146985912358, 0.7762760513022536, 0.9130275638999414], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtll1olmUYx2+b7/u6Pc/73JtUGCWk5mCmrq2DluVyuo+0g9rsYxoLN20x
nU6t/NhRBRkIRVBEB5PqRCHPMs1Nt8w8kYiwkwqCosAOLMggqWXY79//Pri5
7+e6r+/rf133s2horG/XTSGEL1k1rAPVEOqyEAY490RofLeXQljD3sHaxfko
9OaGEI4h8N1c07Zz7oV+cx7CCb7PoGMb/C9xfov9A76H4XmgZBnxH4U2UfW5
tQhhGfIPlkPYAW2U9Sq877M/Bv0U56ZoGfHfg/3u+hA2zAvhmbLttOJzH/b3
o2slNkbhPwf/y/DfX2N/FWM/spe4G+SjHd7f60LoRMcT2OqGfgBdv3I3WrLP
U9iZZF3E1iF4ZuU3d7fBO4P8VNk2e3PbnWE/zd1kJYQu5DpZPchu5/sQcnfC
U2TOtfJ8gfM4/Ie5u8r+B+s3eHcq39EyY+jfyXm4bPtLon1QfF9VHeMQtAHW
JmRXq25Vx9CF7Oe58676zETXaAS+dcmf5+EdL+zDqhS/Yl8N/6fcXSo5NtVE
tr6Hdz+2z+LPKOs16I8SywloJ+F/ocZ5/KfG5/PQd1fNtw89x5ONh/Elz33u
KNlOe3C+5lOXbvbNFeuSnsZorAgnM+R1ObJfwDMP3eWqdTxZdS0ls5L9TWxv
4Vzl3Jo55tPIj80zHmrRU8e6UTGW11aMMdmXH4MJO+sT/zXof6tO8J3Hlzp8
uMLFNOcX0T9Zdn51X045G6s4b8u5u8y5Fj1L4F/MaoV2En3T6PlEPlRde9V9
HfROVg/0BfBe5vyD9BTOnfLWzr4wd66fhb6tcE+obyU3C/0I+v7N3X83OA/h
54dznDvhRb2jWjbUOd696CjBMwLtPc4ryM8eYukXvlhPIfMOelbWu56qk2Sz
Od7nJz2N3C9lNXLfD/8m4Qwf7kPHssxYex39E5n5P4I+hZ8fV4x11UR4UP/L
Zi22HoG/MXdupas/0VUr+aG4NqPn6eg7xScMCT86D6R470XH1ujvLZpD0ba6
K87dbKr5hqSzBM9gtB7hR7YU77fQv2H9UnJt1Zeqb0vZM+BH+JvLrr3oB4j1
XOGZpPmxMHqGKGbxiF+9+3bq3zfYl8JzC7K98PcVjlc4kx/yYS/3e6JnjOo4
leiv5K6fajdRMS4U+2DhnlG/CBd3Z8aGcLwqzT3VZ0Xh78XovpVzU9J9hoX4
/3NT9VeurlXdb+q1LHdvSJ/wrVzIf8lfSbPlZzDSmCU9YGRTg2uofCvvx1IP
NqQ5oJktrAgnlxD6s+qZo1wezJzPjfD0sTamGnaV3ReKbU3ZM3BjYSyOp3ib
UiyyoXyq1vJrQTR9a+aeEX0ttI5ojKxP/JoJsieMCpO3E/vFwjnZDe9Y9KxV
D0ymugyj73qd8TaWsK75IAxpBrfN9RzSnNMsugrvQ4XjWZPmi2LRvGhJmBGv
3g3l+WD0O6rZI4xvSTjXm9mT3k3hVLNEmLwj9xxRrvSexPSmKL71Cf/6L2hL
/wb72I9E40Bv+6Lomn5W+P9AtZNfp5I/+hd4vPA7LT8mUg/qTVXehGfNmsPp
nVmau8+Vzxr8fa7wO9UJfSSd9Z58nd6U6eh/FM1v4eVsyrPw+W7FGFVvtaR+
VD+o9qqv3qtSerMUj+5EF95/isbHhdzvqHIufcfTO/YXtpozx3I984xWTs9q
hkXHrzdnbr3fHc3Rtmgb0jGa3sEA/13R/mmmdkXr3xH99gsf/wEthyBO
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlUtsVWUQxz+9r3LvOeejC6KoGAq2iQhUYGF9UC1taUJitEUtrdbQojXF
2guI1TYxURMxcaELH3FRjDsT2QkChbaIkhjiCmKCJiYajbJQEiGR+MDH78//
LOZm5pvnmfnP3KaRet/EtSGEF6EidDYN4Qz0APxrpRD+qYXwSQzhSCWE7wsh
XKiG8D76g+juK4dwW81v4u/m7TfpsX8P+y7e1qK/yFs3fDv65VkIc0kIh9Gv
4+0G5PPY/4y8GnkN8mroV3LdhX2BXJ3oeyr2/xN+C/oyxV7i7V74fmz+LjhH
Gf5T6Cy2HdAA9r3YLMK+H/sm+AXyz+b5j1DfIDbbkKdLjnWQt70FxzyBvB1q
px9n0G/H9g38Z7AfgpYSLyCvy+u/OfOb+FZoA/xFfC6gvwf5K2J9VnNvf4Ie
xneCt325nMB/AZ2D71T9jdQGDVNLT0MII/h2Lzb/0TUh/Iv8MfEP5fO5Hn4p
dIxchAnn+DmFzevEOg+1Eut2aAv+H2LfSf40dS7l7Jcv8U83uGc3IbcgtyDX
yNdKrAXkL5HXE39F5p6ql+uhZdE+slUNp9FtQt5MfX+Rrx79jco3VnEvn8Tm
8bJ7+ju6y+p5yRhsJtc8+tmya5jAvwuf5UX3bBq5D3lt0d94BawNZ569ZvYM
+nHoZXKPlo3Nd4h/oGSM7kY+WXOsnchVYt0Rjb1f8CmSv7DY+VRzG7ZL8G9D
HiL+LLoPkA+X3LMf8P2x6t7fSr4F5FPE/KbonbkfflfmWurk60WewubVkr9B
u7AP55lSvhPoH+NtoOKe74d/hbfd2B5Xz7Ddn3r3dlJvC7re6Fzakeeod458
R8vu4fPIJzLPZq7sb/k6NTb0TavQtWfeXc1rGn4qs079fQj+j6pn/5Jykuvp
6O9Rvz8n/zzyRMnfPIl9PTXex7FJ0L+LPFn0jvfQvx01Y1mYnIH/NnNtwnwT
sVZE93IU+U18V2bG2hLyTWF/MjOW74RKyM+mrnUMm2bhN3r3ZP8EtjtS1y7M
HUt8g7Sv2qH5xDfq6m1Ajtg2pp6NMFSB35j4Fghj+jbtsHb36jemnrFmq5kO
k3skn59uylPE3hONNWFKt0o3SLdHN+uW6JurXdZNGcN+V/SuyP5o9M5LrxvW
nrimjtx/CP2GxLdJOTX7vdjXG4wBYW8RPf+v4pldh+226NsoDOu2X676tgpD
wspkzVgTZh6NvhG6DbqZulXHa+6n7od2STdO/dBOvQ3/VurZjZe8extT89pB
3fKtxNtaMV47ov8zdOt1M/qia1RtsulGvjExNoWhNfCPEO8F9IPoH0TfnDiW
fBoT32DNfxP6Zcg90fF13zfrXiXmFWMl8hXyf1fwDq4S9qJ3SzHadNsS3wbt
YFf0zqge/UddisaosKab35G6BuXWTlTp/Wj+f6IZCIu6weqdejiQeqaapTBx
SP83eTz9Z/apX5l1moFug3owmM9bWN2TGfvC7P9szvQQ
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.7808396237018556, 0.8530700908186087, 0.9058735528989105], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlU2MjlcUx286nvep933e504jUkoVYTrGMJQgaoy0g1RSYcwIYSEj0amX
GfXRhIWVtYXWjllIF41EtFJfYeojTdlbshCSIqKV+E5I/P7536SLk3ufc849
53//55z7TOkf6hn8IIRwGGlCtlRCGMhDWMb+bRHCh8gjDONjCOOQNmzvaiFM
Yz+chbCX/eUyhIX4rMLWjexkvwD7aM5+yXcna14PYcKoENbh2yMhTztnTzcT
S/mx/8GZXzLH+Ca3fjK6z5DZfJ/CZxMyB32DWO3obpNrIvZPo7/lt4gYd9Cf
wXcU0sX3T6w/IyfZTwTPiugcR5A5meO9robQC7Z1YPsYnx58XhGnD5+1Fe/P
ozuHXEB3IjMH99DvYr2KbirYdhPjI3KtQDeZ/QixbhF/PjF2ovunyZiUp0A/
lXhTkI7cvCiX7riGs33R31/k5kZnG+i2I9vQ/YDPdnIdwraF9QpyMDMHd3Pz
cDa6ZsJ6nzvei7Z9S9xrue91E4xXor9biPmoarwDdedQ/EZm/tQPXeifR9/n
Rbq/7r4E3a81f2vtrnvfi35Vqt0S1knR8dazthbmuIv9yZr7R/hnpvqux38W
PjW4Wsq6MfWS+GqkWovvmDgfD95JpeuyB11GzNXBvbiw4viL0beWvstXii1M
6k/hLM3NhcS5atePfXbhen0uzMi83PnuZo4/iE8fPnPxuZW5DsIp3VDdesXT
OdVR3M1P+0XkHFOYS82K7qmzMzRz0X6XuMcNbAeazMfmaE42RPer6nga+2/I
X5n5PpU4v8jZv1NvrNS8FJ5X9aF8FeclNR+uu469rB3pvp3sjyLjgnvoQW5O
PiHOhOg6PYu+g/Bfx/da3RzobdhX8/sg7EXCv5r1v6pn/HfegM7ouVee4ehc
6rnvctdF/P1YmkNhfFI1Tp1bls6OYJ/e7FmWfWbNPvrWjAtDa8UzL91+/A8g
QxXX/E103YVxKBrn5cIzrPu+Id7Y6H4TxqdV41yKva10b7Wl9+d2yqU82utd
beSOqbq1p37exf770vbl6PZE+61FtzHN/g7NWTQXoXB/q7e72Q9Gv9cZ9x5I
cb5G11R3nwvT49w4hbE7Wjej9BxqflrQTY9+Y/4kTkfNfaGZ6C/N/xPs/0bH
upreDnH7AA4eRveE3iP1l/y3ln47VMOxwls1H2ey/98M/Vs0h5rBlma/43rD
1Rf6N6g3jmM/Vvc5zZ/6Uj35HnX/wMg=
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlEuIzmEUxt/M980/vu//vV9N5H7LMGPkHgozYhCFMYNISkPuMyOysbCy
UMoCG4UiWcxmkPt9JOwsZsmCIZdEyl3I7+n5L946t/c8z3vOec+o1o7m9j4h
hC2cHOdMIYRjaQid+RB2craVQlhYRE5C2FgZQl/kOmwzkWdjqyd2Lmcgd99X
hNCEv4y+iLsvOWMiDmy9+E6jr8C3nDMGcwHAp8j3wTyYxY+K5iDsSeTv7RfC
CWxHkWvAXAX2Zu4UuduC/gvfd2JGk29Zpbl9xPYhMcduYm+Q7wD5ejjD8f1C
f15hjGHod7nzDH0CdwbAdQ221cg/sA1Dr0dvRF8qDuhNxK+sdIy4vQZ/ct4c
14G3ljMZPkNyvjuUO0sS5/hMbH1WP9VsHv4GTluF/Ye4+5aYt4nrtQ7f2mgu
wmwWdobfLA74VkXjybYE3xPwuhPXYwS+3+izyDUR2yK9Lau/OO1I3TPVXj04
nJqDsM9yqok/gn4OeWriWg3CNj5xzZqRW6KxxPF46pnQLGiGGvEtyN6nN19I
PQPq/UP1GOxL6A1597QP+jjipyXGrAZvLGc6d9+Q4zy9q8U/HX8b/nfII/D3
5Fyzv9w/Rb5L+L6ppsiPsd3Htxvb1WgM5b6O7TL67aLvy1ZDrtqSZ0NveE8v
GlJjicMn4msL7p1mrLoMv7JnZyc5buJrzeZzP/fvkPtKdD2FIS7qkeolTm3E
tnOm4JsXnPtP0djCyOHrSl0r1Ui9W5PVTz2cRPzPfv4L8o9Ff4X+InHP1fvB
4Ndlek10TVVL1bgVeVPJvR+e8+y2lDxbminV9lp0rcR/Avnulo0lDtvxN2Lb
lu2HDmJ3R8t6/z+45MvW9b715N+Q+m8ofy+xA0r+j+JcRa450b1S/+QbHb0L
FLNDuVP/5y3YHiHPL5q7bPuJ36sdQ+4OMDupx4zoXaUZFPaD1LtAHNqjeyBu
ekNdwTMkbO2UqZq/6NlXzU6mnkHNg2ZsH/Kdkns/E/9XYr9E31dMh3zRXMXx
nvZl0djiW4G+OHq3iN+96B2kv6Q/nCf/npL3qd6k3Xer4Npqxrqo7cWyd4fm
YXw0Z3HVH9kbPZOK1w4fgl6V7TvNhOT+Je9W2frjHxm9K1Rv7fIV8HmRNwft
6l34tyaembboN+ptsg2MnkHNmnZETL3jX2b3/wOAGr/x
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8385778735021411, 0.8723242586368561, 0.8800068687295122], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlMtLVVEUxjfee7xXzzl3S6KFQebAx8VuL8vQDFOTkCBNrEkIcZuEQUJG
EQRNg2jQsFmDQIhIs4dphJZl/QVCNIke9IAclJCFSL/FdwaLtc7a3/7W2utx
6oqjg+dKnHOjSAo5GjvXj1wMnGvIOVePtJQ69y9yrtY7dwpQPuNcY6nsP+Xg
wQzw/TiQzqadq8JXmROuDb0Mrgt7DZ58iA/sPeJMYl/AfodcReq4G1Q4tw5+
jTj94CvAFfBn4Vnn+2xKHMtePM34y/D/wP8GfQj8+7R4hzLK5yt81/Cj3F7u
7UHaObsCZgG5zN0OeA4gPeTZyvldYpwPdO96crcPnY/E2QnmINILTzW+Oa8a
NKJL+P4EZwn4TdirKb1jINJbpsHUEmsnsU6gBzm7xN1OvpeNj1izxB/zqovl
YXGMx7ifePFbb2YTvPF98+Lsy6kWVoc59IwX7jd6xSvGBx5UTwyO3WfsW5Y3
do1Xv62/DdbrjOxOcvxerljP6dGRWDXuyShv60sZvgWk2/JFt+eU83704Vjv
sDgfyxXL+m9cxvMlpdytzn/xbwFXgHs6qzwsT9OFxH6W0futDjZnTRlxrnC3
2itvi9eW0Wx0JTNqNdnNeYvXmfVkJJmxjfhWQ834OHn9ChX/p9ecGY/N9Wav
mKexi8gw9kygvRmz98K3Af8I34uBemv+AXxNyfzsw97uVbtjsebAcLdD3be7
NhePktmwXWzySc/R85Fq8JDzqVD8ecMgrTZXXnNpb+5Fn8lpvx7wrglkPiuc
xbF6bgVf5VVj64P1w2pr/4PJ5J9Q4Hw8VK/TXLoRCzeMPhlrn7rxL2IvBZqD
pWS/3kaaS6v/UzhexfLPYL9I7G1edbGa2BztCsXxOtZsmT0E5rjXbk/gS8d6
+8tYeVgOtnM2fzZ7d9A1kfpjO2//DOtjM777sfb/JrrZa7Y70JWR5treav8d
e+8UmB2R+lmMtZ+2m/8Bw8GZ/g==
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlMtLlWEQxif1eMzzfeeTUgODSig9ZpplSZphZREZlIW1yaBciUFRRhEE
/QUtatuiFkEXuqhdTFtoN7F/IIg2UUQXyKAEiyz6Pc4LZ2Dmm5lnZp6Z91T2
HN93LM/MupACZF1i9icya06ZtaTNLsVmVzNmfdg3kXn4Rol5gu9DvtlC7A1Z
s7ZCs3a+rSH2b7HZIeytxPfiS5WYzeKrpEAR8bMBX3gXYscU1kckB3Z14nYj
GJ/RP4HHzxqwW8DbiJwk9xcx/fi3R459nm/12HXI0XzvaTF6BXIYuxp7nNjl
WcfWDGP4Jvn2lvyH5B+knzvIM/RzyBT+b8jXfO9Z3IgT9S77CPog8jLl9a+g
z9BsZ6HjPRVW7FhnwbiL/jjj+nO+vVBu7Fzp2wT6SPC/1ozopVnvvYZ+R+jl
IjHl8DGKPVXsNVVrCzG3iG8TJ2nnaDP6psS50rf96J3gFTFvV9q5GIscS5x0
g1UbeW/qeT56U+JY4kC7/ok9lXZ+S9GnqVmNXYW8ip0TcfEGKUAfQibQ+8lv
IH594rclPM02Q34u7TP+o57Fvg/tsBO9lZh2fKfB2IO+M/b+xXEZWL/Jrwv1
c+QfSJyPuRmJrY98P2eQXdgrI9/vKaQG/XbsuuJ/ZHwmYQ0XmWW0m8h3oR0N
cMt5sfM5jv89/JeF/egdtcR+47oPvZnGxGeeu5+072KwxHOF0UF8V+K7UA9D
1L+mGwh8qdfucD/qWdw0Z33X4qiW3FWJ70I38YV+qsJ9y16Kb1mYR2+glfwa
/E34RXVF5ByLW9WcFla4L+14B/raxHvXDTxCH078LeqNbsN/I+O7Uj9LEq8h
bO2kHPtyJrw/7AF892KfTTXlW5T4bSumD98J+usFvw68B9j3Q7z2tzrynUrX
TWm3PeHetGO93Y6wT/Glt7k3xMv/HX52h3l1U+q9NfH/Ls2Qy/oOtTtx1JMN
N5Dy/7QF2O+KfT7FrCD/eonfir79B0XsoQA=
         "],
         VertexColors->None], 
        PolygonBox[{{3645, 2861, 2860, 2799, 1603}, {3433, 2820, 1640, 3697, 
         3432}, {2861, 4272, 2240, 4271, 2860}, {2813, 3433, 3432, 3683, 
         1629}},
         VertexColors->None]}]}, 
     {RGBColor[0.8963161233024266, 0.8915784264551037, 0.8541401845601136], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtk8tvTWEUxbfqufe653lFNDWTqldVXFSVNpJ6BylmEiGVSJhoRAz9CQZM
DTwTfcWrHShNPKIR5k0waY1QYuBVVcRvW2fw5dtnfWs/1t77LD7Wc/BUjZkd
4szl7I/NFkVmM3z8KZtVQ7Mt4BfBZ8GPg0+Cz0/MGgtmT0tmHYH4B+Dc5VTh
91XMrmI3YB/mXolvudasG/tFzhniHuY8x/8beRakZq88zjyzXrBx+E2R/N13
2jnkfQOnpSjOO+w1+K3jtILVwL2Tqabd2F3wz2C3J9LmdU7AOxEo1yPiL0mU
y2vck+cawy6C16OxPdDtWqbRfjnXdYF7JFUdq7ibUtVVS50nY/WtjRgWK8Zb
3ifKyv8Aew45rgd6/xuJcwP7Hv5nsW+ioxG7FXsQfAWcJ9gtqTS7Xn/zObxG
Sx3YpVDamrk7EvXBsYWp8E64p7nrfEbgO2J9Xwk1Y5/vWrg7Y3Hug9/CPgdn
gHoK1DBa0py78zm6jvOxtIxxP+OMB8q3tKB5baaWTYny18MfrGgWHst1eC7v
6+eyeuu78CXUjN6DTfH9wWeOX3+mnjeDreZsAN/rfcvUtyPYR/OaewK9+54U
yVuFv7Go+fh++4yG8RvKtMsDxP8Rqp/92B9T+V6DvyvWLvm+PI60M/5PrE/V
tzbev+e+vqc/Q2l3fZ7TOZ/gdsaqy/vlmjzOL/DZVLs3Q8zeTLP1eF6Tx/RZ
LUs0L6/ldqh6tvO+raL/xmNvzeNPoW95qN4GkfS4lofEHuW8LOlf+b8r8Psy
5fa8+2L11Pv5O1VPvZ9f4U7m/+k/lYGM0Q==
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtk8lrFGEQxcvMak93fxMPxsxNJC7EbdQ4iTFI1CAiIhHxKgiCJwcRj/4H
CvoXuETIjIpC4iFKxF3Bs4J6SXLSRPGg4o76e1QfCqr6Vb2qevX18qPNgyc6
zGwYy2PnE7Oz2FjBbBzbGJvtJz6N/xzblpqNEJ/E31n03PeR2XzJa6arZr+C
WQTZi7LZrYrZdXIegp3CnuBP8e0M/itsDfx7E8eUcxO/N/Z65YwRtyvebwqb
hXsOm6Hf6xwzgq0j3krcBH9G7T9sO36N+a4xT4H4Hbktvi1h/kE43xD3FH2X
ZbFzq8euxDlUK75zxPnYtdB+G+hVIu6nXwNrwf+l4rM0wHvBLyTeqw98Aryb
/J851/AI2HDsu2u/cuo7NLN5J/AnE9da+Xfgu6/8vHOuIn8BvbvM510P3kh9
P2nQT+0c+Eq4jhd810twHsv5ziVy251mK6jvJmcf+L2q30qaz0TOoVppfIPc
2+CPyr7DJ/CB1PUVxxb69wXXQj3q9HpM/UvwHeA1Zr+avR/V/wDvCs7/lvgi
8UB2D9UXY9dYfNP0/ID/Mbg+2nEef4SZRhe7Jr+J/wTXUvM/oP5u8FsJlzZr
g99C9d/o1676rdTzM/F4FuuGS8n9mt1TM+5htsHU37o0303vVqffQjP0kDsb
+VsSx2bqNwXP1Q56Wx1wDGXvdyH4DppN/4ze6tPYbyFNL5N7JfsfpG89uEbS
Rm/ub+xvppblH8D/Hnmualbrf6u6dprhMPgofHX8Q9QM6Xap30IzTZK7KJtP
N5avf06z6tt/+NCJkA==
         "],
         VertexColors->None], 
        PolygonBox[{{3669, 3411, 3410, 3670, 1620}, {3137, 3338, 3337, 3525, 
         1493}, {2993, 4283, 2250, 4285, 2992}, {3338, 3136, 1492, 3523, 
         3337}, {3499, 2993, 2992, 3500, 1473}, {3411, 3120, 1479, 3508, 
         3410}},
         VertexColors->None]}]}, 
     {RGBColor[0.9411759999999999, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{2743, 2737, 882}, {4283, 2993, 882}, {2762, 2738, 
         2024}, {2740, 2728, 1000}, {2758, 2759, 1589}, {3327, 3270, 1242}, {
         4076, 4075, 2026}, {3405, 3120, 1037}, {2729, 2745, 1242}, {3136, 
         3338, 1053}, {3269, 3327, 1242}, {2782, 2761, 2014}, {2735, 2741, 
         876}, {4265, 3062, 2234}, {2756, 2742, 1463}, {2794, 3623, 1589}, {
         3329, 4275, 876}, {2764, 2727, 2026}, {3385, 2975, 1385}, {2772, 
         2771, 2234}, {2776, 2735, 876}, {3097, 4274, 2241}, {2766, 2733, 
         2035}, {4092, 4091, 2036}, {3411, 3669, 1037}, {3887, 3078, 1000}, {
         2778, 2779, 2241}, {2747, 2740, 1000}, {4073, 4074, 2024}, {3079, 
         3887, 1000}, {3338, 3137, 1053}, {2773, 2774, 2235}, {3077, 4266, 
         2235}, {2769, 2770, 2233}, {4421, 4073, 2024}, {2985, 3491, 876}, {
         2737, 2765, 882}, {2734, 2782, 2014}, {3468, 3472, 11}, {3491, 3329, 
         876}, {2792, 3468, 11}, {3384, 2783, 1}, {3270, 3395, 1242}, {4065, 
         4064, 2014}, {3120, 3411, 1037}, {3137, 3423, 1053}, {2993, 3499, 
         882}, {2736, 2776, 876}, {2745, 2755, 1242}, {2975, 3889, 1385}, {
         3499, 2991, 882}, {3490, 3489, 1463}, {2785, 3384, 1}, {3059, 4264, 
         2232}, {4090, 4284, 2035}},
         VertexColors->None], 
        PolygonBox[{{4064, 3059, 2232, 2014}, {4521, 3591, 2757, 2754}, {4267,
          2856, 2732, 2775}, {2783, 4065, 2014, 1}, {2765, 2766, 2035, 882}, {
         4520, 4420, 2781, 2739}, {4276, 4524, 2777, 2780}, {2748, 2769, 2233,
          1385}, {4091, 4090, 2035, 2036}, {4284, 4283, 882, 2035}, {3889, 
         3079, 1000, 1385}, {4074, 2792, 11, 2024}, {2728, 2748, 1385, 
         1000}, {3061, 3385, 1385, 2233}, {2733, 2730, 2036, 2035}, {2726, 
         2762, 2024, 11}, {2761, 2760, 1, 2014}, {2767, 2734, 2014, 2232}},
         VertexColors->None], 
        PolygonBox[{{3395, 3394, 2749, 2729, 1242}, {4075, 4522, 2763, 2764, 
         2026}, {3591, 3269, 1242, 2755, 2757}, {3489, 4521, 2754, 2756, 
         1463}, {3398, 2985, 876, 2741, 2750}, {2856, 2794, 1589, 2759, 
         2732}, {3321, 4265, 2234, 2771, 2746}, {4264, 3321, 2746, 2767, 
         2232}, {3062, 4523, 2768, 2772, 2234}, {4275, 4276, 2780, 2736, 
         876}, {3404, 3405, 1037, 2744, 2752}, {3422, 4092, 2036, 2730, 
         2753}, {3078, 4267, 2775, 2747, 1000}, {4274, 3404, 2752, 2778, 
         2241}, {3623, 3398, 2750, 2758, 1589}, {4522, 3077, 2235, 2774, 
         2763}, {4524, 3097, 2241, 2779, 2777}, {3400, 3490, 1463, 2742, 
         2751}, {4523, 3061, 2233, 2770, 2768}, {3394, 4076, 2026, 2727, 
         2749}, {2991, 3400, 2751, 2743, 882}, {4266, 4520, 2739, 2773, 
         2235}, {3423, 3422, 2753, 2731, 1053}, {4420, 4421, 2024, 2738, 
         2781}},
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2785, 3384, 2783, 4065, 4064, 3059, 4264, 3321, 4265, 3062, 
         4523, 3061, 3385, 2975, 3889, 3079, 3887, 3078, 4267, 2856, 2794, 
         3623, 3398, 2985, 3491, 3329, 4275, 4276, 4524, 3097, 4274, 3404, 
         3405, 3120, 3411, 3669}],
        "225"],
       Annotation[#, 225, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{3136, 3338, 3137, 3423, 3422, 4092, 4091, 4090, 4284, 4283, 
         2993, 3499, 2991, 3400, 3490, 3489, 4521, 3591, 3269, 3327, 3270, 
         3395, 3394, 4076, 4075, 4522, 3077, 4266, 4520, 4420, 4421, 4073, 
         4074, 2792, 3468, 3472}],
        "225"],
       Annotation[#, 225, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2820, 3433, 2813, 2865, 3523, 3337, 3525, 3524, 3000, 3502, 
         3115, 3420, 3114, 3403, 4285, 2992, 3500, 3113, 3401, 3663, 2807, 
         3487, 2798, 3641, 3328, 3326, 3592, 2983, 3885, 3886, 3639, 3884, 
         3883, 3473, 4025, 3263, 3620, 3264, 4026, 3073, 3469, 3076}],
        "200"],
       Annotation[#, 200, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{3063, 3604, 3064, 3863, 2971, 3862, 3060, 3860, 3058, 4263, 
         2853, 2784, 3602, 3387, 2976, 3474, 3323, 3892, 3893, 3888, 3891, 
         3890, 3399, 3643, 3642, 3397, 3096, 3330, 4272, 2861, 3645, 3644, 
         3408, 3098, 3492, 2994, 3507, 3508, 3410, 3670, 3409, 3505, 3425, 
         3529}],
        "200"],
       Annotation[#, 200, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2788, 3993, 2786, 3605, 3603, 3867, 3866, 3322, 3871, 3872, 
         3861, 3065, 3870, 3388, 3625, 3624, 3386, 3080, 3324, 2857, 4078, 
         4077, 3627, 3081, 3894, 2986, 3903, 3904, 3901, 4273, 4271, 2860, 
         2799, 3406, 3407, 3504, 3503, 3332, 3506, 3119, 3412, 3118, 3426, 
         3002, 3955, 3141, 3688, 4101, 2814}],
        "175"],
       Annotation[#, 175, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{3151, 3344, 3152, 3434, 3697, 3432, 3683, 3682, 3339, 3138, 
         3526, 3001, 3521, 3522, 3421, 3419, 3501, 3402, 3924, 3925, 3664, 
         3112, 3926, 3094, 4031, 3272, 3657, 3271, 3396, 2984, 3900, 3091, 
         3640, 4083, 4084, 3391, 2793, 3622, 3621, 3880, 3879, 3074, 4022, 
         4023, 3615, 4072, 2791, 3464, 3467}],
        "175"],
       Annotation[#, 175, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2932, 3772, 2933, 3773, 4133, 4134, 3868, 3869, 3774, 3865, 
         3864, 2854, 2787, 4066, 3606, 3874, 3873, 2977, 3475, 3476, 3390, 
         3389, 3477, 3998, 2800, 3646, 3626, 3908, 3907, 3331, 3911, 3101, 
         3902, 3100, 3910, 3413, 3414, 3117, 3932, 3116, 4286, 2863, 2808, 
         3668, 3428, 3003, 3527, 3340, 3951, 3952, 3689, 3140, 3950, 3437, 
         3438, 3157, 3439, 3702}],
        "150"],
       Annotation[#, 150, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{3614, 3609, 3072, 3876, 3069, 4021, 3261, 3616, 3260, 4020, 
         3470, 3877, 3878, 3634, 3882, 3881, 2982, 3484, 3485, 3325, 2859, 
         2797, 3486, 2806, 4089, 3658, 3923, 3922, 3095, 3928, 3929, 3665, 
         3666, 3667, 3416, 3417, 3134, 3335, 3133, 3519, 3424, 3946, 3947, 
         3695, 3949, 3948, 3008, 3535, 3343, 3345, 3698, 2821, 3443, 3706, 
         3705}],
        "150"],
       Annotation[#, 150, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2830, 3448, 2826, 2872, 3349, 3544, 3543, 3012, 3962, 3154, 
         3703, 3153, 3961, 3435, 3436, 3149, 3696, 4105, 4106, 3430, 2812, 
         3681, 3336, 3334, 3520, 2999, 3930, 3931, 3927, 4282, 4281, 3488, 
         3920, 3109, 3659, 3110, 3921, 3092, 4030, 3268, 3653, 3267, 4029, 
         3392, 3393, 3089, 3635, 4081, 4082, 3471, 3619, 3618, 3617, 3262, 
         4024, 3070, 4018, 3258, 3610, 4071, 3462, 3066, 3875, 3068, 3608, 
         4070}],
        "125"],
       Annotation[#, 125, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2936, 3776, 2937, 3777, 4006, 4399, 4400, 4166, 4167, 2915, 
         3583, 2914, 4165, 4164, 4441, 4440, 4049, 3725, 2972, 3804, 2935, 
         3775, 2934, 3997, 3202, 3743, 4141, 3896, 3083, 3778, 3082, 3895, 
         2858, 3629, 3628, 3912, 3084, 3478, 4142, 3909, 3099, 3785, 3906, 
         3905, 2862, 2801, 3647, 3415, 2995, 3509, 3333, 3937, 3938, 3933, 
         3123, 3939, 3936, 3214, 3685, 3684, 3427, 3139, 3341, 2866, 4100, 
         4099, 3687, 3954, 3953, 3009, 3540, 3010, 3440, 3538, 3537, 3573, 
         3574, 3374, 2960}],
        "125"],
       Annotation[#, 125, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2834, 3551, 2831, 2873, 3352, 3550, 3549, 3018, 3971, 3164, 
         3710, 3163, 3444, 3013, 3967, 3161, 3704, 4107, 2824, 3441, 2819, 
         2868, 3342, 3534, 3533, 3007, 3944, 3945, 3943, 3135, 4289, 3418, 
         3942, 3130, 3677, 3131, 3498, 3497, 3662, 3661, 3660, 3276, 4034, 
         3093, 3919, 3107, 3654, 4087, 4088, 3483, 3638, 3637, 3636, 3266, 
         4028, 3075, 3899, 3088, 3630, 4079, 4080, 3465, 3613, 3612, 3611, 
         3259, 4019, 3067, 3463, 3256, 4016, 3257, 4017, 2974, 3805, 3807, 
         4451, 3806, 4452, 2790, 4069, 4511, 3201, 4337, 3994, 3996, 4461, 
         3995, 4462, 2884, 4139, 4140, 4007, 4009, 4008, 2926, 3846, 3847, 
         3843, 3845, 3844, 2789, 4258, 4259, 3848, 3850, 3849, 2928, 3852, 
         3853, 3851, 4260, 3056, 4138, 2883, 4508, 3826, 4460, 3827, 3824, 
         3033, 3825, 4068, 4067, 4419, 4418, 3200, 4135, 4136, 4137, 3569, 
         2882, 3742, 3243, 4171, 4172, 4173, 3585, 4170, 4169, 4168, 4472, 
         4471, 4442, 4125, 2973, 4216, 2939, 3584, 2938, 3367, 3034, 4269, 
         4270, 4268, 3085, 3479, 4176, 4175, 4174, 3244, 4401, 2978, 3781, 
         2944, 3779, 2943, 3780, 3035, 4278, 3103, 4277, 3102, 3493, 2917, 
         4181, 4180, 4403, 4402, 2987, 3787, 2948, 3786, 2947, 4001, 4002, 
         3747, 4143, 3935, 3122, 3791, 3121, 3934, 2864, 2809, 4093, 3671, 
         3749, 3748, 2890, 3528, 2891, 4146, 3750, 3215, 3369, 3368, 4003, 
         4004, 3700, 3699, 3686, 3155, 3963, 3346, 3347, 3701, 3972, 3156, 
         3539, 3759, 2894, 3375, 3376, 3044, 3833, 3043, 3834, 3372, 3459, 
         3378}],
        "100"],
       Annotation[#, 100, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2909, 3581, 2910, 4411, 4412, 4010, 4012, 4011, 2927, 3768, 
         3769, 3738, 4131, 2879, 3461, 4261, 4262, 3854, 3856, 3855, 2929, 
         3600, 3601, 3363, 2913}],
        "100"],
       Annotation[#, 100, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3193, 3991, 3194, 3992, 3356, 3357, 3191, 4330, 3192, 4331, 
         3025, 3821, 3823, 4505, 3822, 4506, 2847, 4381, 4382, 4380, 4384, 
         4383, 3239, 4388, 4389, 4385, 4387, 4386, 2848, 4391, 4392, 4390, 
         4394, 4393, 3240, 4397, 4398, 4395, 3241, 4396, 2849, 4458, 3294, 
         3242, 4470, 2911, 3582, 2912, 4334, 3196, 4332, 3195, 4333, 3564, 
         3565, 3198, 3724, 4122}],
        "75"],
       Annotation[#, 75, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{3381, 3460, 3377, 3838, 3839, 3837, 3048, 3380, 3379, 3762, 
         3761, 3373, 2959, 3555, 3318, 3815, 3015, 4223, 3014, 4221, 4222, 
         4410, 4409, 4196, 4197, 3545, 3546, 3165, 3707, 3708, 3709, 3458, 
         3370, 3371, 3218, 3757, 4147, 4148, 3536, 2893, 3755, 3756, 3690, 
         3730, 4453, 2815, 4055, 4054, 4443, 3306, 4187, 4188, 4189, 3587, 
         2923, 4191, 4190, 4407, 4406, 3752, 3751, 3040, 3829, 2952, 3792, 
         2953, 3793, 2996, 4404, 3247, 4182, 4183, 4184, 3510, 3124, 4287, 
         3125, 4288, 3037, 3789, 2949, 3788, 2950, 3790, 2988, 3246, 4473, 
         2918, 3494, 3104, 4279, 3105, 4280, 3036, 3783, 4517, 2945, 3782, 
         2946, 3784, 2979, 4217, 2980, 4218, 2916, 3586, 4179, 4178, 4177, 
         3245, 3744, 2885, 3570, 3571, 3204, 4338, 3203, 4339, 2795, 4238, 
         4239, 4237, 4241, 4240, 2940, 3607, 3726, 4519, 3727, 3840, 2855, 
         4126, 3841, 3842, 3828, 4479, 2941, 4198, 2942, 4343, 4344, 4340, 
         4342, 4341, 2796, 4493, 3809, 4492, 3810, 3808, 2981, 3898, 3087, 
         3897, 3086, 3466, 3071, 4027, 3265, 3631, 3632, 3633, 3480, 2804, 
         4086, 3649, 3918, 3917, 3090, 4032, 4033, 3655, 3656, 2805, 3496, 
         2811, 4098, 3673, 3129, 3941, 3111, 4036, 3279, 3678, 3679, 3680, 
         3517, 3518, 3147, 3692, 3146, 3957, 3431, 4298, 3150, 3958, 3960, 
         3959, 3011, 3541, 3542, 3348, 2871, 2825, 3447, 2828, 4109, 3711, 
         3166, 3973, 3019, 3593, 3285, 3353, 3713, 3552, 3168, 3979, 3176, 
         3978, 4311, 4310}],
        "75"],
       Annotation[#, 75, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2837, 4111, 2836, 2875, 4457, 4456, 3737, 3736, 3022, 3981, 
         3178, 3980, 3177, 3553, 3169, 3976, 3174, 3715, 4110, 2833, 3548, 
         2829, 3712, 3351, 3350, 3547, 3017, 3969, 3970, 3968, 3162, 4307, 
         3442, 3965, 3158, 3964, 3159, 3966, 3148, 3531, 3694, 3693, 3284, 
         4037, 3132, 3956, 3144, 3691, 4103, 4104, 3515, 3676, 3675, 3674, 
         3278, 4035, 3108, 3940, 3128, 3672, 4096, 4097, 3495, 3652, 3651, 
         3650, 3275, 3482, 3481, 3914, 3106, 3913, 3916, 3915, 2990, 3811, 
         2989, 3812, 4000, 4494, 2803, 4357, 3211, 4356, 3212, 4358, 3210, 
         4354, 4355, 4351, 4353, 4352, 2802, 4348, 4349, 4347, 3209, 4350, 
         3206, 4346, 3208, 4345, 3207, 3274, 4488, 3273, 3999, 3205, 3745, 
         3746, 2887, 3572, 2886, 4051, 4052, 4050, 3305, 4053, 3304, 4512, 
         3596, 2919, 3364, 4085, 3729, 3728, 3648, 2951, 4243, 3039, 4242, 
         3038, 3127, 4482, 3126, 3511, 2920, 4474, 3248, 2997, 3796, 2955, 
         3794, 2954, 4518, 3795, 3041, 4291, 4292, 4290, 3142, 3530, 2924, 
         4192, 4509, 3004, 4220, 4128, 3732, 4515, 3731, 3799, 2958, 4200, 
         4199, 4477, 4476, 3758, 4408, 3252, 4193, 4194, 4195, 3588, 3589, 
         3308, 4491, 3307, 2869, 2822, 3317, 3045, 3760, 3835, 4464, 2895, 
         3836, 3445, 4362, 4363, 4361, 4365, 4364, 3222, 4360, 3224, 4359, 
         3223, 3453, 3029, 4309, 3171, 4308, 3170, 3554, 2896, 4149, 4510, 
         3020, 4224, 4129, 3735, 4516, 3734, 3800, 4201, 3801, 3764, 3763, 
         2899, 3382, 4153, 4152, 3765, 3049, 4246, 4247, 4244, 3050, 4245, 
         3456, 3457, 3383, 2961}],
        "50"],
       Annotation[#, 50, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2851, 4124, 4123, 4336, 4335, 3197, 4432, 4433, 4120, 4121, 
         2850, 3563, 4117, 4116, 4115, 3293, 4431, 3189, 3580, 3238, 3599, 
         3320, 4378, 4379, 4162, 4163, 3579, 3236, 4377, 3237, 4374, 4376, 
         4375, 2844, 3723, 2841, 3722, 3721, 2968, 4253, 4254, 4252, 4257, 
         4256, 3055, 2877, 4255, 4130, 4229, 4228, 2967, 4210, 4212, 4211, 
         4373, 2843, 4503, 4504, 4502, 3820, 3818, 3024, 3819, 4114, 4113, 
         3187, 4316, 3354, 3987, 3188, 3984, 3986, 3985, 3452, 2846, 4119, 
         4118, 4327, 4326, 3355, 3989, 3990, 3988, 4329, 4328}],
        "50"],
       Annotation[#, 50, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2838, 4112, 4203, 4202, 4206, 4205, 4204, 3741, 4132, 4234, 
         3032, 4236, 4235, 3766, 4156, 2900, 3576, 4159, 4158, 4157, 3234, 
         3451, 3450, 4249, 3051, 4248, 4251, 4250, 3031, 4232, 3030, 4233, 
         2835, 2874, 3297, 4437, 3298, 4438, 3232, 3575, 4155, 4154, 3233, 
         4370, 3358, 4369, 3231, 4150, 4151, 2898, 3557, 4425, 4226, 4227, 
         4225, 3021, 3230, 4465, 2897, 3556, 3172, 4483, 3173, 3455, 3454, 
         4367, 3226, 4366, 3227, 4368, 3225, 3229, 4486, 3228, 3446, 3046, 
         4480, 3047, 3028, 4230, 3027, 4231, 2823, 2870, 3296, 4434, 4436, 
         4435, 3219, 3221, 4485, 3220, 2881, 3216, 4484, 3217, 3143, 3280, 
         4454, 2816, 2867, 3053, 4481, 3054, 3042, 3753, 3754, 2892, 3832, 
         3429, 4057, 4058, 4056, 4060, 4059, 3281, 3282, 4455, 2817, 3830, 
         3831, 3798, 2956, 3797, 2957, 4219, 2998, 4127, 4405, 3249, 4475, 
         2921, 3213, 4463, 2888, 3566, 3250, 4487, 3251, 2922, 4185, 4186, 
         4144, 4145, 2889, 3568, 4044, 4045, 4043, 3295, 4046, 3199, 3567, 
         3512, 3513, 3277, 4094, 4095, 2810, 3514, 2818, 4102, 3814, 3005, 
         3813, 3006, 4296, 4297, 4293, 4295, 4294, 3516, 3283, 4422, 4424, 
         4423, 3145, 4302, 4303, 4299, 4301, 4300, 3532, 3160, 4304, 4306, 
         4305, 3016, 4513, 4514, 3733, 4495, 4496, 4497, 2827, 4108, 2832, 
         4498, 4015, 3714, 3975, 3974, 3167, 3977, 3175, 3716, 3717, 3718, 
         3253, 4013, 3254, 4014, 3180, 3982, 3179, 3983, 3449, 3558, 3559, 
         3311, 3770, 3771, 2930, 3590, 2931, 4415, 4416, 4414, 3255, 4417, 
         3181, 3560, 3182, 4312, 3183, 4313, 3057, 3857, 3859, 3858, 2964, 
         3803, 2963}],
        "25"],
       Annotation[#, 25, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2845, 2878, 3361, 4459, 3362, 4507, 3301, 4048, 3303, 4047, 
         3302, 3360, 3359, 3300, 4469, 2908, 3595, 3291, 4490, 3292, 4430, 
         4214, 2969, 4213, 2970, 4215, 4439, 3299, 4468, 2907, 3594, 3287, 
         4489, 3288, 4426, 4208, 2965, 4207, 2966, 4209, 2901, 3365, 3366, 
         3312, 3319, 2839, 2876, 3561, 4445, 4446, 4061, 3313, 4063, 3316, 
         4062, 3315, 4448, 3314, 4447, 4450, 4449, 3184, 4314, 3185, 4315, 
         2902, 3577, 2903, 4466, 3235, 3286, 4371, 4372, 4160, 4161, 2904, 
         3578, 2905, 3309, 4444, 3310, 3598, 3597, 2925, 3052, 4467, 2906, 
         3767, 4478, 2962, 3802, 3719, 3720, 2840, 4005, 2842, 4500, 4501, 
         4499, 3817, 3816, 3023, 4041, 4042, 4038, 4040, 4039, 3562, 4428, 
         3289, 4427, 3290, 4429, 3186, 4320, 3190, 4317, 4319, 4318, 4413, 
         4322, 4323, 4321, 4325, 4324, 3026, 3739, 3740, 2880, 2852}],
        "25"],
       Annotation[#, 25, "Tooltip"]& ]}, {}, {}, {}}}],
  AspectRatio->1,
  Epilog->{{
     RGBColor[0, 1, 0], 
     PointSize[0.05], 
     PointBox[{1., 1.}]}, {
     RGBColor[1, 1, 0], 
     PointSize[0.03], 
     PointBox[{{-0.7988841452188974, 
      0.6022347780061224}, {-0.6930658122375167, 
      0.47261814334377983`}, {-0.5016271379568569, 
      0.2183893689907362}, {-0.4010788754044047, 
      0.1527158663297618}, {-0.2030274286763937, 0.003954824785511624}, {
      0.007195016997410791, -0.043594254058133636`}, {0.21758401461138044`, 
      0.002650731938453159}, {0.4189643241083033, 0.13409387846535334`}, {
      0.6065029231372221, 0.33182723134715647`}, {0.7793682545701844, 
      0.5769864049408566}, {0.9387380735672282, 0.8556713885662588}, {
      0.9999999999999999, 0.9962469763697455}, {1., 1.}}]}, {
     RGBColor[1, 0, 0], 
     PointSize[0.015], 
     PointBox[{{-1., 1.}, {1., -3.}, {-0.7988841452188974, 
      0.6022347780061224}, {-0.3475865213740005, -0.07968356449192993}, \
{-0.6930658122375167, 0.47261814334377983`}, {-0.5016271379568569, 
      0.2183893689907362}, {-0.08403095173729119, -0.16530577446478129`}, \
{-0.4010788754044047, 0.1527158663297618}, {-0.2030274286763937, 
      0.003954824785511624}, {0.007195016997410791, -0.043594254058133636`}, {
      0.21758401461138044`, 0.002650731938453159}, {0.4189643241083033, 
      0.13409387846535334`}, {0.6065029231372221, 0.33182723134715647`}, {
      0.7793682545701844, 0.5769864049408566}, {0.9387380735672282, 
      0.8556713885662588}, {0.9999999999999999, 0.9962469763697455}, {1., 
      1.}}]}},
  Frame->True,
  PlotRange->{{-1, 1}, {-1, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->117210415]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->137629177],

Cell[TextData[{
 "Get step sizes for the numerical solution of an ODE with ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->126283434],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"sol", ",", " ", 
     RowBox[{"{", "steps", "}"}]}], "}"}], " ", "=", " ", 
   RowBox[{"Reap", "[", 
    RowBox[{"NDSolve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"x", "''"}], "[", "t", "]"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"t", "+", "1"}], ")"}], 
           RowBox[{"x", "[", "t", "]"}]}]}], "\[Equal]", "0"}], ",", 
        RowBox[{
         RowBox[{"x", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], 
      ",", "x", ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", 
      RowBox[{"StepMonitor", "\[RuleDelayed]", 
       RowBox[{"Sow", "[", "t", "]"}]}]}], "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->339195753],

Cell[TextData[{
 "Show the solution and step size as a function of ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->745677703],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"x", "[", "t", "]"}], ",", 
          RowBox[{
           RowBox[{"x", "'"}], "[", "t", "]"}]}], "}"}], "/.", 
        RowBox[{"First", "[", "sol", "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "10"}], "}"}]}], "]"}], ",", 
    RowBox[{"ListPlot", "[", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Drop", "[", 
         RowBox[{"steps", ",", 
          RowBox[{"-", "1"}]}], "]"}], ",", 
        RowBox[{"Differences", "[", "steps", "]"}]}], "}"}], "]"}], "]"}]}], 
   "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->262465920],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 217},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->17026252]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29162762],

Cell[TextData[{
 "Compare steps, evaluations, and timing for different ODE integration \
methods in ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->24971481],

Cell[BoxData[
 RowBox[{
  RowBox[{"evals", "[", "method_", "]"}], ":=", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"e", "=", "0"}], ",", " ", 
      RowBox[{"s", "=", "0"}]}], "}"}], ",", 
    RowBox[{"Timing", "[", 
     RowBox[{
      RowBox[{"NDSolve", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"x", "''"}], "[", "t", "]"}], "+", 
            RowBox[{"Sin", "[", 
             RowBox[{"x", "[", "t", "]"}], "]"}]}], "\[Equal]", "0"}], ",", 
          RowBox[{
           RowBox[{"x", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], 
        ",", "x", ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", 
          RowBox[{"100", "\[Pi]"}]}], "}"}], ",", 
        RowBox[{"MaxSteps", "\[Rule]", "Infinity"}], ",", 
        RowBox[{"Method", "\[Rule]", "method"}], ",", 
        RowBox[{"StepMonitor", "\[RuleDelayed]", 
         RowBox[{"s", "++"}]}], ",", 
        RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
         RowBox[{"e", "++"}]}]}], "]"}], ";", 
      RowBox[{"{", 
       RowBox[{"s", ",", "e"}], "}"}]}], "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->48126008],

Cell[BoxData[
 RowBox[{
  RowBox[{"methods", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
    "Automatic", ",", "\"\<Adams\>\"", ",", "\"\<BDF\>\"", ",", 
     "\"\<ExplicitRungeKutta\>\"", ",", "\"\<ImplicitRungeKutta\>\"", ",", 
     "\"\<Extrapolation\>\""}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->99922964],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Flatten", "[", 
      RowBox[{"{", 
       RowBox[{"method", ",", " ", 
        RowBox[{"evals", "[", "method", "]"}]}], "}"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"method", ",", " ", "methods"}], "}"}]}], "]"}], ",", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "\"\<Method\>\"", ",", "\"\<Timing\>\"", ",", "\"\<Steps\>\"", ",", 
        "\"\<Evaluations\>\""}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->411642616],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      StyleBox["\[Null]",
       ShowStringCharacters->False], 
      TagBox["\<\"Method\"\>",
       HoldForm], 
      TagBox["\<\"Timing\"\>",
       HoldForm], 
      TagBox["\<\"Steps\"\>",
       HoldForm], 
      TagBox["\<\"Evaluations\"\>",
       HoldForm]},
     {
      TagBox[
       StyleBox["\<\"\[Null]\"\>",
        ShowStringCharacters->False],
       StyleForm[#, ShowStringCharacters -> False]& ], "Automatic", 
      "0.5159999999999997`", "3187", "6645"},
     {
      TagBox[
       StyleBox["\<\"\[Null]\"\>",
        ShowStringCharacters->False],
       StyleForm[#, ShowStringCharacters -> False]& ], "\<\"Adams\"\>", 
      "0.4530000000000015`", "3187", "6645"},
     {
      TagBox[
       StyleBox["\<\"\[Null]\"\>",
        ShowStringCharacters->False],
       StyleForm[#, ShowStringCharacters -> False]& ], "\<\"BDF\"\>", 
      "0.7649999999999986`", "7045", "8205"},
     {
      TagBox[
       StyleBox["\<\"\[Null]\"\>",
        ShowStringCharacters->False],
       StyleForm[#, ShowStringCharacters -> 
        False]& ], "\<\"ExplicitRungeKutta\"\>", "0.7190000000000015`", "856",
       "13699"},
     {
      TagBox[
       StyleBox["\<\"\[Null]\"\>",
        ShowStringCharacters->False],
       StyleForm[#, ShowStringCharacters -> 
        False]& ], "\<\"ImplicitRungeKutta\"\>", "1.9530000000000003`", 
      "2318", "34516"},
     {
      TagBox[
       StyleBox["\<\"\[Null]\"\>",
        ShowStringCharacters->False],
       StyleForm[#, ShowStringCharacters -> 
        False]& ], "\<\"Extrapolation\"\>", "0.6720000000000009`", "243", 
      "14133"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxDividers->{
     "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
      "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$, BoxForm`opts$7309]]]], "Output",
 ImageSize->{317, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//TableForm=",
 CellID->276386994]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1008],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["EvaluationMonitor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EvaluationMonitor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sow"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Monitor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Monitor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Print",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Print"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Method",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Method"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MaxSteps",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MaxSteps"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->4605],

Cell[TextData[ButtonBox["Monitoring and Selecting Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MonitoringAndSelectingAlgorithms"]], "Tutorials",\

 CellID->10296]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with StepMonitor",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=StepMonitor"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->129763704],

Cell[TextData[ButtonBox["Differential Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DifferentialEquations"]], "MoreAbout",
 CellID->73800185],

Cell[TextData[ButtonBox["Numerical Evaluation & Precision",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalEvaluationAndPrecision"]], "MoreAbout",
 CellID->512749238],

Cell[TextData[ButtonBox["Tuning & Debugging",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TuningAndDebugging"]], "MoreAbout",
 CellID->94356430]
}, Open  ]],

Cell["New in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"StepMonitor - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 23, 59.8751644}", "context" -> "System`", 
    "keywords" -> {
     "benchmark solution methods", "collect numerical solution steps", 
      "compare solution methods", "intermediate results", 
      "monitor solution progress", "monitor solution steps"}, "index" -> True,
     "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "StepMonitor is an option for iterative numerical computation functions \
that gives an expression to evaluate whenever a step is taken by the \
numerical method used. ", "synonyms" -> {"step monitor"}, "title" -> 
    "StepMonitor", "type" -> "Symbol", "uri" -> "ref/StepMonitor"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5614, 182, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->227888789]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 270996, 5396}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2632, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3255, 87, 49, 1, 70, "ObjectName",
 CellID->15180],
Cell[3307, 90, 544, 15, 70, "Usage",
 CellID->10045]
}, Open  ]],
Cell[CellGroupData[{
Cell[3888, 110, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4366, 127, 190, 7, 70, "Notes",
 CellID->20300],
Cell[4559, 136, 265, 10, 70, "Notes",
 CellID->14379],
Cell[4827, 148, 217, 7, 70, "Notes",
 CellID->11355],
Cell[5047, 157, 530, 20, 70, "Notes",
 CellID->3476]
}, Closed]],
Cell[CellGroupData[{
Cell[5614, 182, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->227888789],
Cell[CellGroupData[{
Cell[5999, 196, 148, 5, 70, "ExampleSection",
 CellID->159410782],
Cell[6150, 203, 242, 8, 70, "ExampleText",
 CellID->71525653],
Cell[CellGroupData[{
Cell[6417, 215, 405, 12, 70, "Input",
 CellID->37659208],
Cell[CellGroupData[{
Cell[6847, 231, 262, 7, 70, "Print",
 CellID->89225757],
Cell[7112, 240, 263, 7, 70, "Print",
 CellID->758155671],
Cell[7378, 249, 263, 7, 70, "Print",
 CellID->229547609],
Cell[7644, 258, 263, 7, 70, "Print",
 CellID->500411867],
Cell[7910, 267, 262, 7, 70, "Print",
 CellID->48189309],
Cell[8175, 276, 263, 7, 70, "Print",
 CellID->113583676]
}, Open  ]],
Cell[8453, 286, 296, 10, 36, "Output",
 CellID->205158846]
}, Open  ]],
Cell[8764, 299, 124, 3, 70, "ExampleDelimiter",
 CellID->48982570],
Cell[8891, 304, 55, 1, 70, "ExampleText",
 CellID->232512768],
Cell[CellGroupData[{
Cell[8971, 309, 541, 17, 70, "Input",
 CellID->567579586],
Cell[9515, 328, 351, 12, 36, "Output",
 CellID->702318322]
}, Open  ]],
Cell[9881, 343, 125, 3, 70, "ExampleDelimiter",
 CellID->440031806],
Cell[10009, 348, 319, 13, 70, "ExampleText",
 CellID->130128556],
Cell[CellGroupData[{
Cell[10353, 365, 677, 23, 70, "Input",
 CellID->984478191],
Cell[11033, 390, 1237, 37, 71, "Output",
 CellID->52867424]
}, Open  ]],
Cell[12285, 430, 80, 1, 70, "ExampleText",
 CellID->281917312],
Cell[CellGroupData[{
Cell[12390, 435, 448, 15, 28, "Input",
 CellID->446165886],
Cell[12841, 452, 2840, 51, 147, "Output",
 Evaluatable->False,
 CellID->278000332]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15730, 509, 220, 7, 70, "ExampleSection",
 CellID->126352434],
Cell[15953, 518, 114, 3, 70, "ExampleText",
 CellID->129132036],
Cell[CellGroupData[{
Cell[16092, 525, 2170, 66, 70, "Input",
 CellID->58124783],
Cell[18265, 593, 593, 21, 36, "Output",
 CellID->607786033]
}, Open  ]],
Cell[18873, 617, 125, 3, 70, "ExampleDelimiter",
 CellID->265701811],
Cell[19001, 622, 114, 3, 70, "ExampleText",
 CellID->177463447],
Cell[CellGroupData[{
Cell[19140, 629, 831, 27, 70, "Input",
 CellID->64175913],
Cell[19974, 658, 1261, 40, 71, "Output",
 CellID->127343525]
}, Open  ]],
Cell[21250, 701, 89, 1, 70, "ExampleText",
 CellID->285988005],
Cell[21342, 704, 895, 29, 70, "Input",
 CellID->288695352],
Cell[CellGroupData[{
Cell[22262, 737, 1420, 43, 70, "Input",
 CellID->725029972],
Cell[23685, 782, 8558, 144, 70, "Output",
 Evaluatable->False,
 CellID->915640436]
}, Open  ]],
Cell[32258, 929, 124, 3, 70, "ExampleDelimiter",
 CellID->28586626],
Cell[32385, 934, 88, 1, 70, "ExampleText",
 CellID->735994752],
Cell[32476, 937, 956, 31, 70, "Input",
 CellID->37843928],
Cell[33435, 970, 451, 15, 70, "Input",
 CellID->67367124],
Cell[CellGroupData[{
Cell[33911, 989, 647, 19, 70, "Input",
 CellID->236963337],
Cell[34561, 1010, 2293, 55, 139, "Output",
 CellID->135135994]
}, Open  ]],
Cell[36869, 1068, 119, 3, 70, "ExampleText",
 CellID->205567056],
Cell[CellGroupData[{
Cell[37013, 1075, 607, 20, 70, "Input",
 CellID->14806094],
Cell[37623, 1097, 14014, 234, 70, "Output",
 Evaluatable->False,
 CellID->121081581]
}, Open  ]],
Cell[51652, 1334, 125, 3, 70, "ExampleDelimiter",
 CellID->481444840],
Cell[51780, 1339, 388, 14, 70, "ExampleText",
 CellID->817534615],
Cell[52171, 1355, 1827, 54, 70, "Input",
 CellID->321180971],
Cell[CellGroupData[{
Cell[54023, 1413, 315, 9, 70, "Input",
 CellID->624244831],
Cell[54341, 1424, 9889, 166, 70, "Output",
 Evaluatable->False,
 CellID->9415619]
}, Open  ]],
Cell[64245, 1593, 93, 1, 70, "ExampleText",
 CellID->75928319],
Cell[CellGroupData[{
Cell[64363, 1598, 570, 18, 70, "Input",
 CellID->644214206],
Cell[64936, 1618, 52948, 872, 70, "Output",
 Evaluatable->False,
 CellID->89300983]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[117933, 2496, 227, 7, 70, "ExampleSection",
 CellID->209915728],
Cell[118163, 2505, 114, 3, 70, "ExampleText",
 CellID->488344211],
Cell[118280, 2510, 675, 19, 70, "Input",
 CellID->13235078],
Cell[118958, 2531, 684, 19, 70, "Input",
 CellID->61614511],
Cell[119645, 2552, 146, 4, 70, "ExampleText",
 CellID->275659737],
Cell[CellGroupData[{
Cell[119816, 2560, 233, 7, 70, "Input",
 CellID->234098660],
Cell[120052, 2569, 1173, 26, 135, "Output",
 CellID->370312268]
}, Open  ]],
Cell[121240, 2598, 125, 3, 70, "ExampleDelimiter",
 CellID->679429632],
Cell[121368, 2603, 113, 3, 70, "ExampleText",
 CellID->39726061],
Cell[CellGroupData[{
Cell[121506, 2610, 1243, 38, 70, "Input",
 CellID->315075895],
Cell[122752, 2650, 322, 11, 36, "Output",
 CellID->33203983]
}, Open  ]],
Cell[123089, 2664, 122, 3, 70, "ExampleText",
 CellID->166295432],
Cell[CellGroupData[{
Cell[123236, 2671, 1416, 42, 70, "Input",
 CellID->351378906],
Cell[124655, 2715, 126190, 2119, 70, "Output",
 CellID->117210415]
}, Open  ]],
Cell[250860, 4837, 125, 3, 70, "ExampleDelimiter",
 CellID->137629177],
Cell[250988, 4842, 238, 8, 70, "ExampleText",
 CellID->126283434],
Cell[251229, 4852, 969, 30, 70, "Input",
 CellID->339195753],
Cell[252201, 4884, 170, 6, 70, "ExampleText",
 CellID->745677703],
Cell[CellGroupData[{
Cell[252396, 4894, 820, 26, 70, "Input",
 CellID->262465920],
Cell[253219, 4922, 7243, 123, 70, "Output",
 Evaluatable->False,
 CellID->17026252]
}, Open  ]],
Cell[260477, 5048, 124, 3, 70, "ExampleDelimiter",
 CellID->29162762],
Cell[260604, 5053, 262, 9, 70, "ExampleText",
 CellID->24971481],
Cell[260869, 5064, 1358, 39, 70, "Input",
 CellID->48126008],
Cell[262230, 5105, 331, 9, 70, "Input",
 CellID->99922964],
Cell[CellGroupData[{
Cell[262586, 5118, 663, 20, 70, "Input",
 CellID->411642616],
Cell[263252, 5140, 2510, 74, 138, "Output",
 CellID->276386994]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[265823, 5221, 310, 9, 70, "SeeAlsoSection",
 CellID->1008],
Cell[266136, 5232, 1426, 53, 70, "SeeAlso",
 CellID->2436]
}, Open  ]],
Cell[CellGroupData[{
Cell[267599, 5290, 313, 9, 70, "TutorialsSection",
 CellID->4605],
Cell[267915, 5301, 180, 4, 70, "Tutorials",
 CellID->10296]
}, Open  ]],
Cell[CellGroupData[{
Cell[268132, 5310, 305, 8, 70, "RelatedLinksSection"],
Cell[268440, 5320, 367, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[268844, 5337, 319, 9, 70, "MoreAboutSection",
 CellID->129763704],
Cell[269166, 5348, 154, 3, 70, "MoreAbout",
 CellID->73800185],
Cell[269323, 5353, 175, 3, 70, "MoreAbout",
 CellID->512749238],
Cell[269501, 5358, 147, 3, 70, "MoreAbout",
 CellID->94356430]
}, Open  ]],
Cell[269663, 5364, 27, 0, 70, "History"],
Cell[269693, 5366, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

