(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     57170,       1775]
NotebookOptionsPosition[     48490,       1469]
NotebookOutlinePosition[     49915,       1509]
CellTagsIndexPosition[     49829,       1504]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorial Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/CombinatorialFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Combinatorial Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"StirlingS1" :> 
          Documentation`HelpLookup["paclet:ref/StirlingS1"], "BellB" :> 
          Documentation`HelpLookup["paclet:ref/BellB"], "NorlundB" :> 
          Documentation`HelpLookup["paclet:ref/NorlundB"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"StirlingS1\"\>", 2->"\<\"BellB\"\>",
        3->"\<\"NorlundB\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorial Functions" :> 
          Documentation`HelpLookup["paclet:guide/CombinatorialFunctions"], 
          "Number Theoretic Functions" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheoreticFunctions"], 
          "Recurrence and Sum Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/RecurrenceAndSumFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Combinatorial Functions\"\>", 
       2->"\<\"Number Theoretic Functions\"\>", 
       3->"\<\"Recurrence and Sum Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["StirlingS2", "ObjectName",
 CellID->23597],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StirlingS2",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StirlingS2"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Stirling number of the second kind ",
     Cell[BoxData[
      FormBox[
       SubsuperscriptBox["\[ScriptCapitalS]", "n", 
        RowBox[{"(", "m", ")"}]], TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->18117]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Integer mathematical function, suitable for both symbolic and numerical \
manipulation.\
\>", "Notes",
 CellID->126685801],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   SubsuperscriptBox["\[ScriptCapitalS]", "n", 
    RowBox[{"(", "m", ")"}]], TraditionalForm]], "InlineMath"],
 " gives the number of ways of partitioning a set of ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " elements into ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " non\[Hyphen]empty subsets. "
}], "Notes",
 CellID->8524],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StirlingS2",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StirlingS2"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->555347927]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->570619738],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->764061240],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"StirlingS2", "[", 
    RowBox[{"10", ",", "m"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->326947413],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "511", ",", "9330", ",", "34105", ",", "42525", ",", "22827", ",",
    "5880", ",", "750", ",", "45", ",", "1"}], "}"}]], "Output",
 ImageSize->{357, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->164893222]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30198],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StirlingS2",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StirlingS2"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->217536723],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StirlingS2", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "4", ",", "6"}], "}"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->183743029],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "7", ",", "31"}], "}"}]], "Output",
 ImageSize->{69, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->194732846]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->784953606],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->451638674],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StirlingS2", "[", 
   RowBox[{"n", ",", " ", "m"}], "]"}], " ", "//", " ", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->737965701],

Cell[BoxData[
 FormBox[
  SubsuperscriptBox[
   TagBox["\[ScriptCapitalS]",
    StirlingS2], "n", 
   RowBox[{"(", "m", ")"}]], TraditionalForm]], "Output",
 ImageSize->{26, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->308715497]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->701],

Cell["\<\
Plot Stirling numbers of the second kind on a logarithmic scale:\
\>", "ExampleText",
 CellID->306855077],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{
      RowBox[{"Abs", "[", 
       RowBox[{"StirlingS2", "[", 
        RowBox[{"n", ",", "m"}], "]"}], "]"}], "+", "1"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "60"}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"m", ",", " ", "60"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->260105802],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9fAl8FFW2d01VdQB3XJ4+x/nGN+99b97oJICyiIgLiqDQJIGEkAVISGch
QJIme3pf09k39n0REPcNdVzHcXdGRuXpjPp8yjy3eSo4yiIk5/d955xb3anc
dEiQ+U1+p0/VvXXr3nv+53/PvbeqO9a8yuKCFXmVS/PzrpyxMq+8eGl+xZW3
l63ELO0niqI8hp+2yxQ8/394xp/HAAAvmPRK1Cpe0ozjFM61k07AJPCfOEGt
0kHry7/uH1Jai17VzXfpRo/Hx+xQLLHrooi4K36uqaVxnF9h1KcaR31Ai9fy
wXWa+Q6zBQNarUVNHWQHKOJPWFQVx/KCggI8mdivvyO4XrxiVDCBj+XG3Rbj
yObECoky1v49Nur7qelOZoYjcTNjKO42Whkfr4Y4Vl4i94OqcyRuQVFUUlqs
5kEQmoWamuAqzE1x3Wo/G6lCRJyrx8RW7lus32rMJ7NMLcUY0c+OCyUUFIsz
caszaStWSvXiX4IjcZu595rU+7Fc0WwTq/q3cEG0Zi1mF5fiVp1JWLcDFVmz
XbGQMrWlS22NGaKtcyVrVGeSqA+PfGqoHdzeDmpvx9DtxefP2ZLHVVfSDpWq
1rm9HUKwsZ1coyNxJwq5bqe5RYvUYhK3mGPUqRuc0F1JO9VoTc6ku1AUnZSo
+S4Uqvkuc80JUs2JXHOm7O+z3Ul3uVgwQSdjODlmlytpl3PMLmaAM2mXaClp
lyNxF6G2KzoS49kgWsqQWKu5qRY3VjxmN9dKR7ZnzG5n0m6yx0gn7XYk7qZW
dptb0Y16BEJpsh1YPVXrHrNH0UlpLlRoEWoLqbO4pbudY/aQTtrjTDI05Sfu
wdb2mFuT0fs1tzr3FFxWdE/S3Z4xJJRwj71bdY/dy3W4xu510alQY/ZyV/Yi
O8fsRatFGWfiXkfiXooVd6sOI8/w5AipL1dz48kSRzTPmL2qZ+w9ykg3KkRi
3D14EtMUQV14gdk55h4hyE4jJ+kekjH3qo4x9+KIHHuvaF4ZJbV9VWxEmH2r
evEGqscz9l7PuHtRq3jALo27j3tyH+JBysVp1Ci6a+x9hv/vRSE07sWPkTf2
fhTMG3u/6hz3gBmNkXF79CsDheis9s8mdEQ89l1zn5cEayVFmZ5r7kdBxxlp
9zX3uyntNtKucfej4Mged7/qwu7o7Mv7uXMPcL9057gHqbvjHkTRnNc8pDqv
fcjMI7m3v+Lecp8tsbgM8efri00oi9jsu/YBPKBmeVDRvKQwC48ePNU9Rtp9
7YNuOiWF5lAfXdc8iIK24AczLJz1kCHXPoxYo2IuXPuIENU5nj6Pmu0ZER3N
Et4/Zxuu7h8p49g0WvKL5p/wEN/hm/CwEM074WFh04SHPeOxS6Sot+7xDxtC
vXVfK+7DrgvRXOMfETnjHxWiuSY8Jtg0YR8KBv4J+1TnxH1me2R+m1dSg3vm
Cs7/tSk3XqnzQF4TBCY94id5VFFJ6T5UaPqkR30TH9W8Ex/l/uPRw6J5Jjwq
LJ/wqHvCI+7xj6BGyyeIcu4Jj7knouzTXGQTWT7xcRTk66THNdekJ0TepCfo
VHVOegI/T5ptPyue7af03vDsPgfk9Upw8r7A5H14hlr345nmm/w4WX7dPkVF
pXqvExZ4J+1DwcCBSvdMpFvw1D1pn+ae9DjS+bonyHDUuvs6tMWFCk2c/BuM
8ag01+SnOP0UhhpUmnPyU0bUOCeeraew4YpYVBnOGn4USLNRQmjKE0FDngxM
oV6qdLD4pzzpv57Ed/2T3C4dE3yTn/SSkHWovdc9oXroM/lJ9r9n8m9Irkd5
Cv2Pisf49U+jUPpphGPK0+4pz6BQ4y48sO+nPOOa8izCQso55dkzwuIq6L+D
Okv28sjwjYR+6MangihTUZ4OTH2aLZ/6tOq/gT5PibE+5SkhqncK2uK9nu6j
U0w/rXlueEYZSVbf8CzJVKGfc099jlrHA36eFyNg6vNCNBfmsMVTf4uC3kel
iV2EmZHDs/Q6MO0lYhc5J6HhlmfDhlB3Qjc/pwVvfk7RAzdREnXgpmd1/43P
cq2+qc/6pj6DPp76rOq98Tkxum98XojqvQn76EGFpt70AtIdFaZ/R4ahtrAS
CZYXXTe9iGP75heFpTe/yKeGekkYy5ZaTF4ScXkiSDOJHrntBTw03PYCiha+
9QWuM3TrC8FpLygqKT14C5UI3PJC4Jbf6v6bfyssuvkFH+Zrvlt+h9HrlhfJ
oGkvoujeaS+JOXXayyhoDSpTWnVPexk/rwi/TXtFiOaa9soI17RXzb46a0AU
+nc+XAvSjJ7QOOOlxhkvR2a8TJbMeLnh9pe18O2i1dD0l0PTsUPB21AFbqV+
klb9t76k6P5bX/bfRjf5b3tF9d32iuab/qqIPtNfQ1F0Uua0Z/rrYnUz/XU3
i+ae/oYYg9PfoFOLy0jjkU9dt71htuk8iWf/yhaNg/irSZHXPPv1plkkitqI
amTkztfJzjteRwnf8Vp45uvhma8Rh0MzXlMswRmvBm8nCcx4jZkdmPG65p/5
BvfbP/P3KL6Zv9d8M/8g/DjzD3Sqe420d+abKGgpKvbazDfdeGpxz9wvPDZz
v4tFc83YLyydsd81403kIyrNOeNNg38XSJb+gk1LknyntqSIWpqS9zfN2Y8W
orJEUKGFs99ECc/GusOzRO9Cd/4BBXk5C9sKztofmLWfIQrM/iN6c/Yf/bPf
QqF66aD7Zr/lm/02CsfX2W/rXjxlK2e/45n9jqKS0j2zKIGaqOTGA/tz1juu
O/Gi605xBx751EkKTXTeQZUq58e18nzDd5fLs8H57ekH2tIPtKYdaEk70Jx2
gAyfd6Bp7oFGlNR3IqnUh4aUtxuS3w7PeRvtTsbWQsmUG0o+gHanHMDPf3KL
gZR3UdC/Ke+qfjxh/6a8K0TzpbwnLE15DwXjacp7qjdZ5HmS3/PQKSs3KjR3
znvo4zniumvOey4r3oMKP++KlZP1XRRcPaDSnbPfJQhmvxvHz//CCJw3YOxe
OgjHxXqoI/sDPLRlva+orZnvK6NaFrzfnPFngmf+nxtR0v8USUN5jxndkPYn
JSGc9udwOsr7ofT3CZ70D/Rg+gfcZiD9QyFqIO1DXFiiQmhQW3ykCJW0Dw2Z
9yGyABWP6nkfClE9c/E+91y6zz33A4xZqHR36gcuFuowHXRXygfOqIhnWgb5
DWaQbb8YBI+L5Sh2XveSg11LDnbmfdKe+wmBsfiT1kUftyz8uCXn4+ac/yYs
sj5qzPyoMesjNZL131xbQ9bHKOGsj9Vw1ieKHsqmG0NZB1H0YNZBwZOsg4FM
PPVnirQv8yAKjofMg6p3wUExFy04KETzZHwiOJLxiWc+VumeL9Lu9I9d6R+j
yag0V9rHhpW0JFJGOOd95Jz7kcOQ/zJAGC0x48pBkLhQnpPOW7Psr3joXvpl
V/GXnUVfdhR+0V7wBea05n/euuSzlrzPmvM+bc79lLjQmPeZGsn7XNEa8j5v
yPuC+RHO+0IN536BIyeXMkirQVSW4OIvAizEh8VfYpTAU4t/0Rc+FgIHteZd
yOpzAiYHq/bkfK56sj8XOGR/hoKMyPpMdWV9hlhkfWrGYqQz43+cGX8xZP5f
HPMPYi5q1ZFOn0+YI/Vpn8RD6OeDIERc0o2hw1w5Z13Ft2tWfrvKfhgTXaXf
dq443LH8cPuyQ20lhwin4q9bir9Wm4u/VrSm4q8bi79hXCLFh3C+Lz7cwEL1
hYsO4wq16FCo8FCwkO4MFh4OFB5WAwWHkDAFlOO34anPdkj15X8jxs6Sb4R4
lnyNYyfva8GXvK/duXjqzv0K1eKvzJjozoV/deZ8KUR1Zn8hniFlf+HIQlBJ
6Y5MQrs+87P6BZ9p9Qs+FShlMLQXSij9n0FQOldeh16y3nVsnfP4mvqjq+uO
ddccxazOquMdFcfbVx5rW3m01X4Ec5rt3zXbv2+yf9dkP9KIUk7FIuXHG8qP
Y6QpO67o4bJjxKLSo6HSI1pwxRGcbpbTnYHlR5FBy44pI/zLjvpK6D7UvqUo
R7xLj2DMLT4iVu1F3wtxF32PzCn8biSj4so/7Fwi5JDqzDsk9ty53zhYNMfi
rzmnftFXJAu/0uoX/q+i1+fQ2EBdn/1XtS77S0aqLuvLwZGKzkbR55SxiHPO
5ibYGOnFszXBE6v9J1f5TnZ7errclNPuhDZnT6vjpNri+EE5q7n+OAWg+h8a
60401p2M1PVEagnzhprecE2vGqo+qVwQqj4RrPqBgKk8Eaj8AbW/AuUkkWhl
rw/FjtLjLT/pLT9BfPSUncDBVXrCU3qShw4rV8lx19JjTpRilKPOIoLaUfS9
6ijET8H3yJWC7wgB23f1tr+p9fl/Uyz1+d/WLyGh/LzDilqXd1iryz3EWNQt
/gYF8xYhnoTVwq9qF34VB62fMVqXm1DiaHT5tg2wZS1sXAXru2BtO1m9qrm3
uxE6G6EjAu0N0NpAmS0haA71NId6m4I9jUHCMBKABj80+CDsg5AXQh7eMQYR
34SAqyfg6vU7ewgcR6/PAaqvHvnsraMy3lrw1ILqqekdQXe4VgKD47T3OstZ
ylB6HAyb6lhxQnMs/0HR6peRj+pLkLeo1PqlxxVLXTHl1RUdY0G+1hUeVRLq
CgnUuoIjdbbva0m+U2vzv2Msapf8DUVRa/O+ZbRqcw/X5B6WYhXBIrh1qcyp
87ftocsbtsG6LbB2I6xeD91roXMNZbZ1Q2s3tHRBcyc0dYp9VyMCOiLSBg2t
EG6BUDPlBpsg2Iirg0AElLP9DK4/3OsLgS8IXpQA5Xj84PGB24e3U0UjXA5w
OuiCsx6cdeCsBQcyVHXU4KacGFQF9SiVKL31FSiEfN3KHkTE3qPWlfcoWl0Z
55VSXmmPWruiV7HULidH1i47WbvsRG3JCcSl5AdFr11KqNYUH0fRaoqOKZaa
wmM1hRQBagqO1hTg2Kc5UKuxfV+d/z117yKJa2J/OWANcM72J2HLY7DxYVh3
P6y5h8zp2gUdO6FtB7Ruh5atzKDGzciHyCZo2ADh9RBax5itgcBqCKwC1d8t
2OLrBG8HeNvBg9JGZdwtICKPMwyOEDiCXJvDD0pCvQ/qvSxM0jo3qHUu3ILV
OaHOQUIo1ENtHdTWovTW1hAuam11r1pbBWpNpbCuZiWgKGqNHfPKezn61ZT1
VKOUopxU1OoVJxW9ejmN/+plJ1C0aoRVr156oiD6p1YX/cDcqyo8XlV4LA56
P+0X16KryOhOV7li66uw8XfU5dXPQNeT0LEPWh+Bloeh6QGOWfdCwz0Q3guh
PRDczezaCb4d4NsO3m3gYYw9m8G9CdwbwbUBXOvBuQ6YZVp9J9R3QD2SVq1r
E32qa4FapK1a2wTIl0aojTBYDVATJiRCOKprGOmaANT4ERcf5XihmpGuRqSr
XfhxoheqGefqeqiugyoUjAFVNcKbVdVQVcVSidJbVcH4V63sVavs+DGwrirr
rSplWQGCgzQBVy7vrVzWQ1JykvCtXHpCfhI7EF2eX0eZ51dZi7Xa2t9D92vQ
/hI0vwANz9K1wG/A9zh494HnMXA/wkPyQXA+AKrjPrTRcQ/U72WO7YG63VC3
C6gRtH0jVG+A6vVQvQ6q1zIzq1bj4K5aBVXdUNUFVRwxqjqgitCvQvQTqlop
q7IZSJqgshHUyogICJVhIAlBZRAqAyLWVBLTK31Q4WVh/CsQ/wpkuqXCCRUO
EsrEUKxW1FFuLVTUkFBuNeUi2yuI7RUVnLdSvIpW9IpyqCjvrShjv1SU9qoV
K3r4UsVyCis81s0oX96HskVGmZGl5Uzs/XXrq9D5OqD2/Rbqn4a631Bm2cNQ
+hCWLnsQay5jbpffL+iinFW+G8p3QfldnLsTyndA+XYo3wblIoaUYwwZXb4J
yjdC+QYusx7s66B8LdjXQPlqyrGvgvJusHdBeSfYO6G8Q6BoR+R1eyvYW0g4
B5k/wt4I9ggLB2x7GOxIfdUepNIBsPs51weq3Yu9tXvA7jbqc1HaCXYHCabr
BSL2OrDXstQYGGv2KrBXkmCpCrprJVdq78U0jgI7jgIqaGcn9HujPfCt7QV9
+Md5rivebfd9x0Dd9BamN/wR1r4JnW8YGI9YvAeW3A35d4Ptbijgea8Q44la
tBvU4l3C20vvgqU7MW/pDrSqZDuVKdkKJFswdxl6wbJsE+Uu2wAk6zF3+Tox
8pavAZLVsHwVLO+mQiu6YAUOA3UF+kJf0Q4rOK6vaAV1BbpCL22G0ibKKcWR
UBqhnAYoDZOQDaVBzMWxoJX6ocwn7CpDbySUeaDMzeJiXjlB4F1WD2V1RjmM
RWXkiLJqKK/mPHnHKzNcG7BCl5+ynntKH4jvo8R8sOMdMUdeseUtQG+gIzDR
9XtofhUCL4LjeUhlHFM2w9xtkL4dMnZQMmsH5OyEhTth0U5YvJNycndA3g5Y
grId8tkh+dtAteGwGG3bAgVbKKdgExSibITCDVCEsp4yi9ZB0VooRlkDxTxC
ileRZ9Ez+tIuWMrxqaQD1BIMUHpJG5S0kpDdy5rhAgOsc8gGvZRXz6U1gKKW
VpNPqowvu/C3PMwoxf8uyPlDxA9dYnAC4qdo296mxFbU6qY/Ynr9fjC8x62M
srKlyZshdQvM2wrpHCwytkHmNrwjC1NaNmctRH0l31HUCsUtLLx2K26C4kZY
ihIhbBqMURBm42hGUksCIq/EDyU+GgNeUJd5BOOXuWGZi8UJy1E4Gi+naLy8
DtTlCJq2vKYfTvHf0A3YPfdfLfRDV8JpBOLEWIzc/jYgXASToqx7E9btp5Hf
+KpYY4y2dvdY1wDiZeXwmbwJUjbB3M0wbzMl0zfD/M2QsRkWbIJM5mUWajV7
IzaYsxFy+J6FG0BdhIDri9bBYl7F5a4FNXcNqHlIL0veKspa0g0o+V14d36n
sNfWAbZ2ljaa5VuFPQUtUEDrkMImMXoTiiJQ1ABFYZYQ87AYI0Ax4V/sh2Ij
AixF/Jd68OOmCMUBoMQJJBSNSxB8raQuOhPJYzz+t28E4vL+KkFC2mKMaGYm
2YWAb3+HAN/8lshQzrO20obSuhoI63Ug6DlnAyRvgJQNkLoB5m6knDREMh0x
1edvgAzGdsF6UDPxk7VO9CF7LeTgqkLNwZ2ItpBH7yLU6iJcMS/GEWxZ3MUO
6ITcDsjD8KrmtYs7l7TFuKvo+S2Qzzy3NWHMwE2KbotAAQpPemoBBlpLYQgK
gyzGuqMIV31FOPMVeQVOxR4odpOoxTT3FTvN6JqfkZ6Kz9GnZiPjRkmNR7tI
06keZTXRG3FGTSDjRm0/UAwQsdzKjEOoFdWKYI2yMilRz1kPyeshZT2kcs48
1GraOsTcQDdjLWQQugvwVj2TN3tZqwFFzcYq9WyevHK6YGEXqAs7mZ/q4nZC
vQ1yW0kI+xZCHdFNyGuCJSiNzP8I5EdAzW/AT1ggYQuBLUiiFgTw4ydW+aDQ
S4L8Ry4XusH8fnv0KWb5vrWAzFdCVuzj+nC0MJixtIHqiGjuds7CCUo81cbZ
yfDiuUz45LWQshZSeXU7l1CeR2xMWwPpawRT5iNiGYiYtoA9kdltrOK1rC7I
MnbM2UhOS04H5LTDQpQ2kbsI1wCLWpDLzWJxktsEuY0sEchDEfxcEgZ1CYaC
hCVByOdNSX4A8v1gQ4baMB5oNi9Pf9ikPAtd0o91Z0fHsoCCxzDvZPGoGmOa
3+8waDFYMIe0eKdqbT5hbaOVmrUTVCuaGuXfajolNWd1FD8yiZrjXVjCgk7I
7GBphyx+IqNm06o0uxVyUMSqdCEiYVnYBIuENAqcFuO0lLC4AXJRwiSYmRfC
iBsk3gVgCYqfRMAgo3BxXKbIaGhmXpjYI1hBZ32oRa9z79jUrW9HrUYsWnoQ
IysvvVVrV3+caGih4tGUjAlLCo+z1G6Yi0IzxrwuMbTTOiGdZT7WdCm3sigM
i1FCLEHIDRoW/5NkG++9+33bx/zu/1yT5VEL9Dixh9fhMhrm+E8nYnFiPDNG
m63MeLSaGkggywnUOd0wp4tETUbrtBSO26m0Kp5L8+O8TpjHcKV1QBrtFNPb
QZ1v7NUzWgEF4xRSRMtknmTSnJlFe/esRsgWEoEcWr3k0OolJwwLw33eMUUV
+amEQMr8XRq+yxS/BUbnxxk7MkvUOBjKTBk0xlv6MajxB27MwgzC2GvtEnfh
kU9JMa6dIERNRhz1FAYxtQNSEb+5tKKdxyMtrQ1QtHRadcxnBDMobmc0g7qg
iVDlDUgmPb/LorGW1QDZLEr0C90XSQhdPDhupvRoiWkJpkgjs0pVTDG5X6Rm
LmIlRgSKHOcxBlaMnlaDI9b2GAsJL5HXyWTUaCBqcxgZ0loylk1I4RtS2wBl
LgrWNc9Yk6W1QBqhk95Ma5NmmM/gZODaIQN3aAsihFckGnHlkTd6mHyKIRMt
Ed0pDRFpZI5F12N6FLnYE7noSFWjDMPYzYG7VUaOwCOUKF5brMYKak4bzKGV
ajLF6BSe61NbIRVnq7ktNGJbYB6vqdKaIa2J0KLRmN4I8xv7SDNgPhLojATT
qj7ODH9R/9XRcKKQkR+1VTMYc6o4bjE4h6b7Dhn85F5ZWwxkEChCYABS7QJp
kUbh5wqWOYwR6mQU4k8K4ZTKoy21GeaiEE7zmmhUmkCSMboghtGpfxMSG4UD
9ovDiziaaawJxkTXAYOhLaqP/llDx6yREwazeDQKzPQYXm2MnxY3LYrTn3hG
m9wMKSyKmtoUs5FcGF1fC+6MMnHHfJSRiM5fQ0SUOKPOMgwMY6PVYg3RCwRr
pNfaCNYm0ZRqbe1jUKthrCk9ksdflGUIHbFlTrPRE4g9QbxQ8rZAQP7uxiX9
R4vhQ7nHQ8cJ2evqKREU2TEuhE9Y+Z0k2o5x0tps/FooRgqkSH8MdMl+DE79
vC6PivPi2v5P8fjfr6+yd9VhRIYE8wiJM3L0Aa1YxCho6BFEMHDQ+nDgKEDa
YrabTCbVt1OMEw/OjVlOfr0sjsVR72lDeFOPi9Cga1495mGr/zv2eYI1AsRz
QXXMbwLy2wi+JNsR78mieRWqxfWobF90ZRDfh315g66/9L6RPPgqd7irX2O+
8NPrQWvohDHaG9HTRszCY9Srxoq4uS/SX2y2fJDvJdNPIn9Cx35ev1xeLSgD
Y1i8uTA2foeYB83xbrDR0LdCsQaPW0MnreEe8fxRE4wnrZtxaDKlTbF86Fkt
Pg7yexh5lx+PEaec+4bj71NgGx1Nhp8JkF5rGKwNEGWFQEIMFmKIYE/pxk8N
R4p1jpkHQyMhf3fxZ6jMLIgfrePtVk4n4g2GlxqNfRraT8aGe9Fy2oFZI9HZ
QTUoIr65jF3dlmjbkmirSrTFnuKYLY6iMBCX2De6jXqleBJ9o0xvQqmZaL/N
Tzbkcf7jouVw0BS/+LH6vo/11xoibIynYYgRScRYV21ItGGPNyfaMLE20bZN
YKNY2jE/8idbos3zPL+PHDUAmUHe1wzxa5B4o+5yg0mxZ+sma04nfsTbpQzG
o36rkmH6Jco7Ixb5jlj9x/t4Fgbm32hMrGFQ8QTR3Zho28S0wySiuz3RtoPP
a1mXbvhL/b4jfd9vhv5rS+1HInqpgehICVHLENYNj3X639EPmgnPo4inNSC+
bKCcZeXHKJ0M5aooP9cl2tYzpiKibWHGIqZifrTsTLQhlSOJttymt7gA3nvW
6WDYb6d8kYEi/+5Fjz1LMDHhdCLWcJnWb1Y9rQjApzxYrb5jVv8P1sBJK3+z
DLuO47kj0dYZRWrkakZ0HesNTNHNzFKB607OJ7NV0/xPpyN/JCNHG1heIK0n
flycGy7jLHHyhzXy+/VIzLMx/7cl2gTK3Yk2JGYMSSSmQJKL/51wO8/ALd5+
+8fEr+HhbVEG7uhPxfnYkx4j1kSiPEtoTbS1MSJIva5EG0KmD4qO+T2WvGY3
/w7gbAMTecUe70nWmcSm0x25w8DY0ldaPMUT+50Ghqgp0dYSHYEdsRFoiYuV
/Mug6NunK6KxKgblmTHhH4knv+/HftNTrRGDWs2rKoMBP48zKv5BnjxdjGil
LNl03rA8qxq2/qtkq3YmvTlDj0XHe/z3m2Sr7L9zh7Q1+tb8l/Ko/rF+G0Y8
k3E65Y4Du3Q2nNqDI/pbZRhxVbw57wzXS8Nn7OC5ZNH5Q/hJWCSXugoG7oIH
w/5M+Hg6qESZd5HU13PiWnSBlHt1NC2CZtxnr2eA/RBcjEaIy6ReyXwTfR99
ir6f6YjXTpF/yn0RNv/TYfX+wiF6P/z1b9S2H80uaQah07Pi9vkig++/HiZL
Ys9q4yAVP2bGfauLDf2b1J9Rcft3SZzx+fdkxFCz9n8M0Uv+Lle/Z+ZyL6Nu
PJ0RI/vdYvTm6mH15tLBegN9887pjoKBvo0iNFZqbWTcPl1m8OxqqS9nGjOj
vRgfjz0DenG5lPsrqTeD+UmO9PK3EKK9mDSsXsjRRO7FkP6J64cb4rU1oO0r
hmh7uP6ItnqzVJ+8phet/szw/gAmDhEjbpNqk3dXonY50vGY7bdTiL6FNc+m
M4boufii8ZVx6pbXB2Y8Zg/RY1Hrv8Tzgh6Laqb6UqSS8kpb1PcLGd9oFMfT
NOkO+bmHqEGOxr+U0vOHVcv/lXL/XUpncNFYGsTaWER6uaxc1wKTV8WN4r5f
GrbHLT+gLcGYX0llfyGlMwe0Je67Sion+zHLlO5rTY7aMqeyDQtE6V9LV2V2
9y+daKTkUjlSWjzmHyPlytGAMNNjyMqRXY5baUZpXg2J/9louirH2lQQuz3x
rd1rjH7LpaxGnbyWUuSoLs9sdxilef4V/9vSdFWelacbpcUvjiZKV+WVxi1G
afH7zklGf+VSNxpWif9uMFm6Kq8IrzfqZK5yynxVXv1ONEqL/5A2Rboqr/Ov
MUqL/zV4g9FfuVSSUUr8h80bpavyHukqo7T4r6E3SVfl/ccvDSwYBUWeGeT1
578ZdfO8xWifamVzpVGaa1WmGdbJpa4wSvG8ocizhzwjXmaUnsmlp0tX5fng
EsM6jvDK7dJVOc6PNupO5tIzjP7Kpc41Ss3jUndAvIh1tlGGY6dyJ8iRaYRx
PZuvzzK1wNOUcXUxX6W+UwP5nFJ+8v8Bk0C7BQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->537762120]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->122305273],

Cell["Stirling numbers modulo 2:", "ExampleText",
 CellID->64831542],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Mod", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"StirlingS2", "[", 
       RowBox[{"n", ",", "m"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "0", ",", "100"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"m", ",", "0", ",", " ", "100"}], "}"}]}], "]"}], ",", "2"}], 
   "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->66237366],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzdl0FSBDEIRRtv4pU8wlS59v47a3Q6dgj5nwTohVNaOpV8XgIEkvfH18fj
7TiOz9evPH9E5Hj9Pb+3j/4++WD9c/Tnv+Nos7XagcD6449zztd6zy6w/tzn
OaZtUoZHH2T41hjyldfXgZj7c2Y7d1dyX8/VbLCLLqZQr/fcyMhX2kdMr2N3
0aFdDDGFep2DOqfNXVzGXXqmMXaBbNp6tvdhF8g3Mz2LobGeWYznepaLnTVj
3KVnZ2pia03PakOzhGqHVz+rcRc75rhDz2v1kKOr+gwbHkbYF9xXFzvnfEO/
mxO9pf3c5OOmrYl29YyOK9mrFUBvrWSn5gG9vZL12g30s5Ugm8yGh0F9s9SL
0UpQjL0xpTtBueq+G2FI7H3iYdDa4bqrcgitkUzvgQTfDg4G7ScZjBt8JfUx
bzPrcrefW3IGu9k1tcSYn10TB0V+bcealB5lqnJ7LdDJJAeM9SzFvClRP+lW
g8YxJO8OByC4n7SVoHEOwTVSxtzYgWS8DSgk/sZxQHA/iftKYExdOeGExN4n
TkjsfeKE4H6yX0s6CO4nuzVRQWLvEyck9j5xQrBv4r4SHuNozJtllKux3G1G
Yu8TJwTXjrivhNfADAat5RkM2k8yGDf4Supj3izV5W5vq+QMdtZqakkHqamJ
ClJR2wdIfo8yINm91oTk3hkmkMy7zxSSd4cDkKy7KITk3KkJJONtQCH1jBt8
JfUxb5brcrdB6s7gBVJVSzpITU1UkIraPkDqGTf4Supj/oJU5m6D1DNu8JXU
x/wX8k8Y8g2GgCRI
   "], {{0, 0}, {101, 101}}, {0, 1}],
  Frame->Automatic,
  FrameTicks->{None, None},
  ImageMargins->0.,
  ImageSize->{189., Automatic}]], "Output",
 ImageSize->{193, 189},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->168058657]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2221466],

Cell["\<\
Closed form of derivatives of compositions with exponential functions:\
\>", "ExampleText",
 CellID->11999322],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"Exp", "[", "z", "]"}], "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"z", ",", " ", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->41138391],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWdtu1DAQdePspdvtbvfW8tCV9ge4fQBCIFR4QYjHwtOqQmofEKj0/0Oc
jHeTkxPbabKUSq0z9njO8Xg8vvTz9uH2x8/tw93NdvPxfvv79u7mz+bq131a
pY+UilZKqekzlX4n6Vf2a38u0l+l1unfKK0+k/ITyF8D5ZmUb0GOdyhK79Cz
3kX5ytP+peP2GchvPO1RNgql88L8mMZRKvbScki0Tf0x1A9A7qd/tJg1+j0p
Z1KePNJuT+zasg92ly35xh3btePWYHcu5aLG7ojwY3ab2rGzndeY2Z6ARjai
QXE17XXHAaNVPeibr5OCVlE27StoH7dgMKQMNPOCg8Gqcx9EXs90zQPlMAbn
0GvpYHAKuhijXdruNm7t6sHVGyXuEbSJ1BJmvK8/bHRaVB6VOGOHQGaZ1oXZ
JkpiwTxs5JlP3L+yWe1XLcYkytAjTaPQfM5BZ9wCvy96YRmCoa9aoD8uMrtm
0TRKzSfuuUsHvm8/Z15uY78atRhV6BFX/sS+Pu8ZObJZxzFKtItnW1d+bcqp
zb7s44njpHKH44jV/qRaxPrfuKJsT8E+znhH8XGOG3DGG41vJT4lt+rdzKwq
s/fU3c1YLmB3AxZR9i7B7mbM7jQJX1GIgWcejBS8Mzg5OLxv97aucTEK0K7F
XQTisjNgTOZiciC7eaQNpRW9iFZQPpZ+WM8jBH1ssryW+lr00okZNZrh8wg1
LOyeFeKDKOF7XKhvMC+jVybJ/gUldE40wQnl44tovG9ZXpg/ffiu206RH/pj
BfPjw62bn1C8fEUUT0lKUDXJ3FrQTkDfspgn+xg3MnoTd8QSTiX2Q5FMiRlS
u5A8mbDJiBdJOX5Z/PwLHnOImzHooecHNTzwBsB4MR6W38UT4eav1ENoxVvu
BNpfembrtBKXZw0t4HuBL09Mof+LpJrHmN2I6DF7rzx+Z28NrrhEj65BxnMm
fXdwzDvaH+3mORa0WLzEsvZGSpyluvOBb7RT6fecsK49bzhGV7RXt3qtHZbl
7TnpsmX/LP+rb8D2GmTXexLG3XtBZP9RiIj+O5CzVw56vi5q4byG9brM6r9D
7TXIS2oLeX8Amd5CShnE9DAK+FrHsuJr8dZ52YrUovY6Bzj6C2oOO24=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{533, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->53101363]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{"k", " ", "z"}], "]"}], " ", 
    RowBox[{"StirlingS2", "[", 
     RowBox[{"6", ",", "k"}], "]"}], 
    RowBox[{
     RowBox[{
      RowBox[{"Derivative", "[", "k", "]"}], "[", "f", "]"}], "[", 
     RowBox[{"Exp", "[", "z", "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->96437301],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWdtu1DAQdePspdvtbvfW8tCV9ge4fQBCIFR4QYjHwtOqQmofEKj0/0Oc
jHeTkxPbabKUSq0z9njO8Xg8vvTz9uH2x8/tw93NdvPxfvv79u7mz+bq131a
pY+UilZKqekzlX4n6Vf2a38u0l+l1unfKK0+k/ITyF8D5ZmUb0GOdyhK79Cz
3kX5ytP+peP2GchvPO1RNgql88L8mMZRKvbScki0Tf0x1A9A7qd/tJg1+j0p
Z1KePNJuT+zasg92ly35xh3btePWYHcu5aLG7ojwY3ab2rGzndeY2Z6ARjai
QXE17XXHAaNVPeibr5OCVlE27StoH7dgMKQMNPOCg8Gqcx9EXs90zQPlMAbn
0GvpYHAKuhijXdruNm7t6sHVGyXuEbSJ1BJmvK8/bHRaVB6VOGOHQGaZ1oXZ
JkpiwTxs5JlP3L+yWe1XLcYkytAjTaPQfM5BZ9wCvy96YRmCoa9aoD8uMrtm
0TRKzSfuuUsHvm8/Z15uY78atRhV6BFX/sS+Pu8ZObJZxzFKtItnW1d+bcqp
zb7s44njpHKH44jV/qRaxPrfuKJsT8E+znhH8XGOG3DGG41vJT4lt+rdzKwq
s/fU3c1YLmB3AxZR9i7B7mbM7jQJX1GIgWcejBS8Mzg5OLxv97aucTEK0K7F
XQTisjNgTOZiciC7eaQNpRW9iFZQPpZ+WM8jBH1ssryW+lr00okZNZrh8wg1
LOyeFeKDKOF7XKhvMC+jVybJ/gUldE40wQnl44tovG9ZXpg/ffiu206RH/pj
BfPjw62bn1C8fEUUT0lKUDXJ3FrQTkDfspgn+xg3MnoTd8QSTiX2Q5FMiRlS
u5A8mbDJiBdJOX5Z/PwLHnOImzHooecHNTzwBsB4MR6W38UT4eav1ENoxVvu
BNpfembrtBKXZw0t4HuBL09Mof+LpJrHmN2I6DF7rzx+Z28NrrhEj65BxnMm
fXdwzDvaH+3mORa0WLzEsvZGSpyluvOBb7RT6fecsK49bzhGV7RXt3qtHZbl
7TnpsmX/LP+rb8D2GmTXexLG3XtBZP9RiIj+O5CzVw56vi5q4byG9brM6r9D
7TXIS2oLeX8Amd5CShnE9DAK+FrHsuJr8dZ52YrUovY6Bzj6C2oOO24=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{533, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->158993605]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15984],

Cell["Generate values from the generating function:", "ExampleText",
 CellID->646921792],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"12", "!"}], "/", 
     RowBox[{"m", "!"}]}], 
    RowBox[{"SeriesCoefficient", "[", 
     RowBox[{
      RowBox[{"Series", "[", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["\[ExponentialE]", "t"], "-", "1"}], ")"}], "m"], 
        ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", "12"}], "}"}]}], "]"}], ",", "12"}], 
     "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->130043431],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2047", ",", "86526", ",", "611501", ",", "1379400"}], 
  "}"}]], "Output",
 ImageSize->{233, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->323748852]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"StirlingS2", "[", 
    RowBox[{"12", ",", "m"}], "]"}], " ", ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->348355788],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2047", ",", "86526", ",", "611501", ",", "1379400"}], 
  "}"}]], "Output",
 ImageSize->{233, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->730529530]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->125168018],

Cell["\<\
Stirling numbers of the second kind are effectively inverses of Stirling \
numbers of the first kind:\
\>", "ExampleText",
 CellID->595933829],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"StirlingS2", "[", 
       RowBox[{"l", ",", "n"}], "]"}], " ", 
      RowBox[{"StirlingS1", "[", 
       RowBox[{"m", ",", "l"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"l", ",", "0", ",", 
       RowBox[{
        RowBox[{"Max", "[", 
         RowBox[{"m", ",", "n"}], "]"}], "+", "1"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "0", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8250704],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWcFOwzAMzdqNDdCgcOI4PgNxhxMfUU1I44BAY/8BfPFI1nVUxqnj1G4R
ZNLSOm3t5/g1bV8eys3q8bncPC3Lxf26fF09Ld8Wdy9r25WPjMlujDHXV8bu
b+3e7l//bu3/26ysU9fmh7PMMbDPhe0C2GNgnwjjgfGo87vi4cbj4vl0zQ9U
zs6sWQRuL8H1+b6f6/cCsWP8Qj9YnLZR+UBHxUV35gT0T4X6j2wzsSZE4zt/
5umH1896zsOHi5ufdB4+XNr1C2NX5ppJc341e1+OsVO1o3AGCrtq5j2K+YIx
hsrVjzpuJLRzbcfbLydoRsOrcjTGvHMvfKbhZ52hvfCenfeEGUcTlokkZhyH
fE2oufx9Gz4HDssYiBz60sLchTGSmPtijORTMzGGm0liTGIML5PEmMQYXiZ/
lzFQ9XKZ5Htvvm2tR+SNLfQOdQrKb+Hxz/VbEHFq/9RbXqUu1eOL6YUyFlWl
pEJ2w6OtQlJ4pONT9dp9UVUtgfo/qaSUX8ofNQ7joFF3cxVHRdTul1ZhuSqp
ttqpoSYPUb/YPLjjqF0/7H6g7xqfWqmnIerotFgOPMU1Tu8eQqftnmt7ZDiP
D1n17rl2qUG/nMAiVW8cGXK0aaNKsMJXkL6iHvbFqPXtJ6mow3dJrdGPw8wZ
K/maYM80/rPqN7A8TrsYluWSektfLI/DPCzLUbUhsTyxPLE8sTyxPLFcbEQT
yxPL9VhOsdpl0lxValsdyk3c6hPm3xcvZlUrBH+oX8xPG3501eNQGO6alxl9
Ac7wgEI=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{569, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->452733823]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->96138652],

Cell["\<\
Calculate large Stirling numbers of the second kind using Cauchy's theorem:\
\>", "ExampleText",
 CellID->161257989],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"n", "=", "120"}], ",", 
     RowBox[{"m", "=", "10"}], ",", 
     RowBox[{"\[Rho]", "=", "10"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{"Re", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        RowBox[{"n", "!"}]}], "/", 
       RowBox[{"m", "!"}]}], " ", 
      RowBox[{"NIntegrate", "[", 
       RowBox[{
        RowBox[{"Evaluate", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"Exp", "[", "x", "]"}], "-", "1"}], ")"}], "^", "m"}], 
            "/", 
            RowBox[{"(", 
             RowBox[{"x", "^", 
              RowBox[{"(", 
               RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}], "  ", "\[Rho]", " ",
            
           RowBox[{"Exp", "[", 
            RowBox[{"I", " ", "\[CurlyPhi]"}], "]"}]}], "/.", 
          RowBox[{"x", "\[Rule]", " ", 
           RowBox[{"\[Rho]", " ", 
            RowBox[{"Exp", "[", 
             RowBox[{"I", " ", "\[CurlyPhi]"}], "]"}]}]}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"\[CurlyPhi]", ",", "0", ",", 
          RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]}], "]"}], "/", 
    RowBox[{"(", 
     RowBox[{"I", " ", "2", "Pi"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->253397620],

Cell[BoxData[
 RowBox[{"2.755642934640312`*^113", " ", "\[ImaginaryI]"}]], "Output",
 ImageSize->{105, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->115347630]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StirlingS2", "[", 
   RowBox[{"120", ",", "10"}], "]"}], "//", "N"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->36143856],

Cell[BoxData["2.7556429333264562`*^113"], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->571588787]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4682480],

Cell[TextData[{
 "Generate Stirling numbers of the second kind from the commutation relation \
",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", 
      SuperscriptBox["a", "\[Dagger]"]}], "-", 
     RowBox[{
      SuperscriptBox["a", "\[Dagger]"], "a"}]}], "\[Equal]", "1"}], 
   TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->11018680],

Cell[BoxData[
 RowBox[{
  RowBox[{"s___", "\[CircleTimes]", "a", "\[CircleTimes]", 
   SuperscriptBox["a", "\[Dagger]"], "\[CircleTimes]", "t___"}], ":=", 
  RowBox[{
   RowBox[{"s", "\[CircleTimes]", 
    SuperscriptBox["a", "\[Dagger]"], "\[CircleTimes]", "a", "\[CircleTimes]",
     "t"}], "+", 
   RowBox[{"s", "\[CircleTimes]", "t"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->223807024],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SuperscriptBox["a", "\[Dagger]"], "\[CircleTimes]", "a", "\[CircleTimes]", 
  SuperscriptBox["a", "\[Dagger]"], "\[CircleTimes]", "a", "\[CircleTimes]", 
  SuperscriptBox["a", "\[Dagger]"], "\[CircleTimes]", "a", "\[CircleTimes]", 
  SuperscriptBox["a", "\[Dagger]"], "\[CircleTimes]", "a", "\[CircleTimes]", 
  SuperscriptBox["a", "\[Dagger]"], "\[CircleTimes]", "a", "\[CircleTimes]", 
  SuperscriptBox["a", "\[Dagger]"], "\[CircleTimes]", "a", " "}]], "Input",
 CellLabel->"In[2]:=",
 CellID->471026008],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztGctu2zBMieQkzh7tgBZod0q+Yaf+wHoodt5OBYJiQHsY+lh/d/sVz1Kk
xmEoUbIs28JSoJEpkRQpSqREftu83v/8tXl9uNusrl82T/cPd79XXx9f6i4+
YWzyhzG2vmD1d1V/qX/597f+337avxb1b1ET8LrldTvXcKnhmYaXBFwS9AKM
C8u4DZYt40azipTDV26KvgiUE8KQfqJWfQm0mcqf4g1WOFvaw94S7RVo7zIR
Li5DvLx4L843hEOqXrmbm3bEJY1f2X6tm0re8doxXl51gg/ONfRaHKWVPpjN
t73g10JR9kDhkgpfg3A9ePAcLorwObqikDvFePvUaz/cjuhDDzFK+4ZThOvh
50EkX2FWVuz6NT24UwhjtY4x6dl5sJzcmyeN6c8zHBPG/FmC1UtpuxRyikEt
4o/pLyd+Gs0rSZ3KTLz2MY77U/jd54/x/BjPaQq7B2nCcsdJEH9zmezBu4hR
nPPMa158/8+co25av9FPEZp1sWYx8+KxoYtVcY+651X7jtyNHwFsslkfQH8R
2G/42Pif6PYUwKZdB84TKy/F3yYn1OO9WnXpZ6faFgLhegbg80D4mRiP5f+o
tIA2yEPqlbbEmW7PLe0zgCn8p4zXJE+p5adPRWP3JSMwltPHagnGRxasfW2g
AHybflu2cwtfqpbSpjbCG3htazoQjq3ZqPUxoUhdnuDrS92/O829Cy+sMWS8
4WotUCwYsfG75xjqPsPWXHKrqIXgjqEXtYLzbKv93SqrXgJOkPNwr/TwV6Fo
6rSXifI72UO/8ofL5rhrLDlX2sIpxpkj2bNQiywy9CnUuU+ZeffPFGO3r7cM
MrpPh6/K9FEX8Tun46hn+WOOq/aUIurCOSRsshe5Rl30JRJ/Z/wv4zC2B43H
NK+/Y+Qd3ibb/Sw73flqmJ3BPIgE0+XET9BRe/ykpYmpiMTk4E8xOwBfSq9W
uspFuuqD0vzgxmZ8wiVKC3MzbbPwFyh3fP+kqgB8RvD6qKw0zxDWXqJ2WVe7
DOHUnEBHBvZLA1+2UBsqg3td7TKsXVRAvqNaXRFUN4Gz3HYi5ULrflXtVxBu
AGza28pdgfiRke55SMkm/wCxWN+Q\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{477, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->807401579]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"StirlingS2", "[", 
     RowBox[{"6", ",", " ", "k"}], "]"}], " ", 
    RowBox[{"CircleTimes", "@@", 
     RowBox[{"Flatten", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Array", "[", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "\[Dagger]"], "&"}], ",", "k"}], "]"}], ",", 
        RowBox[{"Array", "[", 
         RowBox[{
          RowBox[{"a", "&"}], ",", "k"}], "]"}]}], "}"}], "]"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->817066127],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztGctu2zBMieQkzh7tgBZod0q+Yaf+wHoodt5OBYJiQHsY+lh/d/sVz1Kk
xmEoUbIs28JSoJEpkRQpSqREftu83v/8tXl9uNusrl82T/cPd79XXx9f6i4+
YWzyhzG2vmD1d1V/qX/597f+337avxb1b1ET8LrldTvXcKnhmYaXBFwS9AKM
C8u4DZYt40azipTDV26KvgiUE8KQfqJWfQm0mcqf4g1WOFvaw94S7RVo7zIR
Li5DvLx4L843hEOqXrmbm3bEJY1f2X6tm0re8doxXl51gg/ONfRaHKWVPpjN
t73g10JR9kDhkgpfg3A9ePAcLorwObqikDvFePvUaz/cjuhDDzFK+4ZThOvh
50EkX2FWVuz6NT24UwhjtY4x6dl5sJzcmyeN6c8zHBPG/FmC1UtpuxRyikEt
4o/pLyd+Gs0rSZ3KTLz2MY77U/jd54/x/BjPaQq7B2nCcsdJEH9zmezBu4hR
nPPMa158/8+co25av9FPEZp1sWYx8+KxoYtVcY+651X7jtyNHwFsslkfQH8R
2G/42Pif6PYUwKZdB84TKy/F3yYn1OO9WnXpZ6faFgLhegbg80D4mRiP5f+o
tIA2yEPqlbbEmW7PLe0zgCn8p4zXJE+p5adPRWP3JSMwltPHagnGRxasfW2g
AHybflu2cwtfqpbSpjbCG3htazoQjq3ZqPUxoUhdnuDrS92/O829Cy+sMWS8
4WotUCwYsfG75xjqPsPWXHKrqIXgjqEXtYLzbKv93SqrXgJOkPNwr/TwV6Fo
6rSXifI72UO/8ofL5rhrLDlX2sIpxpkj2bNQiywy9CnUuU+ZeffPFGO3r7cM
MrpPh6/K9FEX8Tun46hn+WOOq/aUIurCOSRsshe5Rl30JRJ/Z/wv4zC2B43H
NK+/Y+Qd3ibb/Sw73flqmJ3BPIgE0+XET9BRe/ykpYmpiMTk4E8xOwBfSq9W
uspFuuqD0vzgxmZ8wiVKC3MzbbPwFyh3fP+kqgB8RvD6qKw0zxDWXqJ2WVe7
DOHUnEBHBvZLA1+2UBsqg3td7TKsXVRAvqNaXRFUN4Gz3HYi5ULrflXtVxBu
AGza28pdgfiRke55SMkm/wCxWN+Q\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{477, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->274682919]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->108268273],

Cell["\<\
The limit of finite differences of powers are Stirling numbers of the second \
kind:\
\>", "ExampleText",
 CellID->3935054],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Nest", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"#", "/.", 
        RowBox[{"x", "\[Rule]", 
         RowBox[{"x", "+", "1"}]}]}], ")"}], "-", "#"}], "&"}], ",", 
    RowBox[{"x", "^", "10"}], ",", "4"}], "]"}], "/", 
  RowBox[{"4", "!"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16163583],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "24"], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["x", "10"], "-", 
    RowBox[{"4", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", "x"}], ")"}], "10"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"2", "+", "x"}], ")"}], "10"]}], "-", 
    RowBox[{"4", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"3", "+", "x"}], ")"}], "10"]}], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"4", "+", "x"}], ")"}], "10"]}], ")"}]}]], "Output",
 ImageSize->{342, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13774624]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"x", "\[Rule]", "0"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->352292746],

Cell[BoxData["34105"], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->221356924]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StirlingS2", "[", 
  RowBox[{"10", ",", "4"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->87197858],

Cell[BoxData["34105"], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->516946132]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8083],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StirlingS2",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StirlingS2"]], "InlineFormula"],
 " can take large values for moderate\[Hyphen]size arguments:"
}], "ExampleText",
 CellID->43357686],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StirlingS2", "[", 
   RowBox[{"1000", ",", " ", "500"}], "]"}], "//", "Short"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->90598338],

Cell[BoxData[
 TagBox[
  RowBox[{"11897164077580438091910055658742826", 
   RowBox[{"\[LeftSkeleton]", "1457", "\[RightSkeleton]"}], 
   "01973994337325444453475652966305056"}],
  Short]], "Output",
 ImageSize->{339, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->78814661]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->327483602],

Cell[BoxData["1.189716407758043809191005565874282`15.954589770191005*^1526"], \
"Output",
 ImageSize->{169, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->175522149]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->133573127],

Cell[TextData[{
 "The value at ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"n", "=", "0"}], ",", 
    RowBox[{"m", "=", "0"}]}], TraditionalForm]], "InlineMath"],
 " is defined to be 1:"
}], "ExampleText",
 CellID->104356178],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StirlingS2", "[", 
  RowBox[{"0", ",", "0"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->176437310],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->34666332]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32392],

Cell["Plot sums of digits:", "ExampleText",
 CellID->36326898],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Total", "[", 
     RowBox[{"IntegerDigits", "[", 
      RowBox[{"StirlingS2", "[", 
       RowBox[{"n", ",", "m"}], "]"}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "36"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"m", ",", "36"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16161155],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJyN0F1P2lAYwHGyr7HdmHi/LCZzZpvMJY2ICRmT2a2ZsZPYeOa2urOwVeoI
lW5KodJQONJIqHa8VEEEZZpzPt0KvivILs7dL+d5/s/AHP967p7L5Ro8ezgK
3n4afzny7M39Fy5myO8bc3vYAO2mafBDjyu6mW9iHFl8NUeP+AYnhicn3Q/G
HlJumgn5AQvAl6iEjD8VTPDP0DvKw7gHJqjx58OBJxTLuOEaEAGQo2p6u1bH
hGBpIeSh/fRT7+jQI7eXogEDgxAgCPlk3CxXHUJwUhCCH6anqanHY955lqLp
oB/4YFDh5aS1V2kTglF86WNg1udfnPK/97E0zQZpjmGQIqvZXOcXx6TV9dBU
kKFGA16WZWnIzfAgJCumaRbqp4Rg7fePuLPP5LyX9bEengOCLCiSikyzcUYI
zkXmRS7A0V42EGJEDkBekSXZRLZ9TgjWnaVFHsxyPBuEPASqoCrItM3mBSG4
oMPI54VZOMPO8AEVQlWSFK1ablySdte37/oChAIPBNEhUEDp2sHJFeJ0oUQk
BkVZgAJEsiiuOqfbrV4lBFupWJiGoihIIUWIJpblmFFsXCME72hhWYZQ5sRf
X+NaxtRzxdZ1QnA+i2QoqrHVFTWV31AUe+fkBml3GdpyMqwuSZmNTTNvWo2b
hGB7a31VCqvKSkLfQJplNW8RgvfNlUhK0eVNLaFpttGFOF25VEpUVC2TKeWt
3duDOl1GCq1pBkqoW+XDW+uemlLFMJCBsoW0XbsZfW4qet7azFbsglXpOqjT
VSxvlwrIKjaqPUi7q2YVDcver/ciBLf2ikVk2PVeg9rmqLpvl0r1bne5MPVG
qWTfSQhulJqt2h2D2qZ5fPi3++kuzXHzoMfpLk3rCPchTle/XxzTZ5eO6U/I
fxDyD+R2JxY=
   "], {{0, 0}, {36, 36}}, {0, 186}],
  Frame->Automatic,
  FrameTicks->{None, None},
  ImageSize->{154., Automatic}]], "Output",
 ImageSize->{158, 154},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->127651720]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->212396469],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Det", " ", "@", " ", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       FractionBox[
        RowBox[{"i", "!"}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"i", " ", "+", " ", "j"}], ")"}], "!"}]], " ", 
       RowBox[{"StirlingS2", "[", 
        RowBox[{
         RowBox[{"i", "+", "j"}], ",", "i"}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "0", ",", "n"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "0", ",", "n"}], "}"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->234017444],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", "2"], ",", 
   FractionBox["1", "8"], ",", 
   FractionBox["1", "64"], ",", 
   FractionBox["1", "1024"], ",", 
   FractionBox["1", "32768"], ",", 
   FractionBox["1", "2097152"]}], "}"}]], "Output",
 ImageSize->{246, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->40997559]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   SuperscriptBox["2", 
    RowBox[{
     RowBox[{"-", "n"}], " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"n", "+", "1"}], ")"}], "/", "2"}]}]], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4536608],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", "2"], ",", 
   FractionBox["1", "8"], ",", 
   FractionBox["1", "64"], ",", 
   FractionBox["1", "1024"], ",", 
   FractionBox["1", "32768"], ",", 
   FractionBox["1", "2097152"]}], "}"}]], "Output",
 ImageSize->{246, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->133800121]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19086],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["StirlingS1",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StirlingS1"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BellB",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BellB"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NorlundB",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NorlundB"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->4270]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17301],

Cell[TextData[ButtonBox["Combinatorial Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/CombinatorialFunctions"]], "Tutorials",
 CellID->17100]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->10591],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/StirlingNumberoftheSecondKind.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/IntegerFunctions/StirlingS2/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
StirlingS2"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->598287934],

Cell[TextData[ButtonBox["Combinatorial Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CombinatorialFunctions"]], "MoreAbout",
 CellID->236731853],

Cell[TextData[ButtonBox["Number Theoretic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheoreticFunctions"]], "MoreAbout",
 CellID->98533452],

Cell[TextData[ButtonBox["Recurrence and Sum Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RecurrenceAndSumFunctions"]], "MoreAbout",
 CellID->582981301]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"StirlingS2 - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 24, 18.9225270}", "context" -> "System`", 
    "keywords" -> {
     "number of partitions", "Stirling2", "Stirling number of the 2nd kind", 
      "Stirling number of the second kind", "Stirling numbers S2", 
      "Stirling s2"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "StirlingS2[n, m] gives the Stirling number of the second kind \
SubsuperscriptBox[\\[ScriptCapitalS], n, (m)]. ", 
    "synonyms" -> {"stirling s2"}, "title" -> "StirlingS2", "type" -> 
    "Symbol", "uri" -> "ref/StirlingS2"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5004, 162, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->570619738]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 49686, 1497}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2304, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2927, 82, 48, 1, 70, "ObjectName",
 CellID->23597],
Cell[2978, 85, 710, 22, 70, "Usage",
 CellID->18117]
}, Open  ]],
Cell[CellGroupData[{
Cell[3725, 112, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4203, 129, 132, 4, 70, "Notes",
 CellID->126685801],
Cell[4338, 135, 417, 13, 70, "Notes",
 CellID->8524],
Cell[4758, 150, 209, 7, 70, "Notes",
 CellID->555347927]
}, Closed]],
Cell[CellGroupData[{
Cell[5004, 162, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->570619738],
Cell[CellGroupData[{
Cell[5389, 176, 148, 5, 70, "ExampleSection",
 CellID->764061240],
Cell[CellGroupData[{
Cell[5562, 185, 238, 8, 28, "Input",
 CellID->326947413],
Cell[5803, 195, 314, 9, 36, "Output",
 CellID->164893222]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6166, 210, 216, 7, 70, "ExampleSection",
 CellID->30198],
Cell[6385, 219, 214, 7, 70, "ExampleText",
 CellID->217536723],
Cell[CellGroupData[{
Cell[6624, 230, 188, 6, 70, "Input",
 CellID->183743029],
Cell[6815, 238, 214, 7, 36, "Output",
 CellID->194732846]
}, Open  ]],
Cell[7044, 248, 125, 3, 70, "ExampleDelimiter",
 CellID->784953606],
Cell[7172, 253, 203, 7, 70, "ExampleText",
 CellID->451638674],
Cell[CellGroupData[{
Cell[7400, 264, 186, 6, 70, "Input",
 CellID->737965701],
Cell[7589, 272, 303, 10, 54, "Output",
 CellID->308715497]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[7941, 288, 221, 7, 70, "ExampleSection",
 CellID->701],
Cell[8165, 297, 115, 3, 70, "ExampleText",
 CellID->306855077],
Cell[CellGroupData[{
Cell[8305, 304, 449, 14, 70, "Input",
 CellID->260105802],
Cell[8757, 320, 11477, 192, 70, "Output",
 Evaluatable->False,
 CellID->537762120]
}, Open  ]],
Cell[20249, 515, 125, 3, 70, "ExampleDelimiter",
 CellID->122305273],
Cell[20377, 520, 68, 1, 70, "ExampleText",
 CellID->64831542],
Cell[CellGroupData[{
Cell[20470, 525, 440, 14, 70, "Input",
 CellID->66237366],
Cell[20913, 541, 1147, 25, 210, "Output",
 CellID->168058657]
}, Open  ]],
Cell[22075, 569, 123, 3, 70, "ExampleDelimiter",
 CellID->2221466],
Cell[22201, 574, 120, 3, 70, "ExampleText",
 CellID->11999322],
Cell[CellGroupData[{
Cell[22346, 581, 239, 8, 70, "Input",
 CellID->41138391],
Cell[22588, 591, 1365, 26, 70, "Output",
 Evaluatable->False,
 CellID->53101363]
}, Open  ]],
Cell[CellGroupData[{
Cell[23990, 622, 457, 15, 70, "Input",
 CellID->96437301],
Cell[24450, 639, 1366, 26, 70, "Output",
 Evaluatable->False,
 CellID->158993605]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[25865, 671, 233, 7, 70, "ExampleSection",
 CellID->15984],
Cell[26101, 680, 88, 1, 70, "ExampleText",
 CellID->646921792],
Cell[CellGroupData[{
Cell[26214, 685, 621, 22, 70, "Input",
 CellID->130043431],
Cell[26838, 709, 255, 8, 36, "Output",
 CellID->323748852]
}, Open  ]],
Cell[CellGroupData[{
Cell[27130, 722, 242, 8, 70, "Input",
 CellID->348355788],
Cell[27375, 732, 255, 8, 36, "Output",
 CellID->730529530]
}, Open  ]],
Cell[27645, 743, 125, 3, 70, "ExampleDelimiter",
 CellID->125168018],
Cell[27773, 748, 152, 4, 70, "ExampleText",
 CellID->595933829],
Cell[CellGroupData[{
Cell[27950, 756, 627, 20, 70, "Input",
 CellID->8250704],
Cell[28580, 778, 1013, 21, 70, "Output",
 Evaluatable->False,
 CellID->452733823]
}, Open  ]],
Cell[29608, 802, 124, 3, 70, "ExampleDelimiter",
 CellID->96138652],
Cell[29735, 807, 126, 3, 70, "ExampleText",
 CellID->161257989],
Cell[CellGroupData[{
Cell[29886, 814, 1383, 43, 70, "Input",
 CellID->253397620],
Cell[31272, 859, 215, 6, 36, "Output",
 CellID->115347630]
}, Open  ]],
Cell[CellGroupData[{
Cell[31524, 870, 156, 5, 70, "Input",
 CellID->36143856],
Cell[31683, 877, 181, 5, 36, "Output",
 CellID->571588787]
}, Open  ]],
Cell[31879, 885, 123, 3, 70, "ExampleDelimiter",
 CellID->4682480],
Cell[32005, 890, 383, 14, 70, "ExampleText",
 CellID->11018680],
Cell[32391, 906, 396, 10, 70, "Input",
 CellID->223807024],
Cell[CellGroupData[{
Cell[32812, 920, 532, 9, 70, "Input",
 CellID->471026008],
Cell[33347, 931, 1338, 26, 70, "Output",
 Evaluatable->False,
 CellID->807401579]
}, Open  ]],
Cell[CellGroupData[{
Cell[34722, 962, 622, 20, 70, "Input",
 CellID->817066127],
Cell[35347, 984, 1338, 26, 70, "Output",
 Evaluatable->False,
 CellID->274682919]
}, Open  ]],
Cell[36700, 1013, 125, 3, 70, "ExampleDelimiter",
 CellID->108268273],
Cell[36828, 1018, 133, 4, 70, "ExampleText",
 CellID->3935054],
Cell[CellGroupData[{
Cell[36986, 1026, 367, 13, 70, "Input",
 CellID->16163583],
Cell[37356, 1041, 710, 25, 51, "Output",
 CellID->13774624]
}, Open  ]],
Cell[CellGroupData[{
Cell[38103, 1071, 122, 4, 70, "Input",
 CellID->352292746],
Cell[38228, 1077, 162, 5, 36, "Output",
 CellID->221356924]
}, Open  ]],
Cell[CellGroupData[{
Cell[38427, 1087, 129, 4, 70, "Input",
 CellID->87197858],
Cell[38559, 1093, 162, 5, 36, "Output",
 CellID->516946132]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[38770, 1104, 225, 7, 70, "ExampleSection",
 CellID->8083],
Cell[38998, 1113, 239, 7, 70, "ExampleText",
 CellID->43357686],
Cell[CellGroupData[{
Cell[39262, 1124, 167, 5, 70, "Input",
 CellID->90598338],
Cell[39432, 1131, 335, 10, 54, "Output",
 CellID->78814661]
}, Open  ]],
Cell[CellGroupData[{
Cell[39804, 1146, 97, 3, 70, "Input",
 CellID->327483602],
Cell[39904, 1151, 220, 6, 36, "Output",
 CellID->175522149]
}, Open  ]],
Cell[40139, 1160, 125, 3, 70, "ExampleDelimiter",
 CellID->133573127],
Cell[40267, 1165, 234, 9, 70, "ExampleText",
 CellID->104356178],
Cell[CellGroupData[{
Cell[40526, 1178, 129, 4, 70, "Input",
 CellID->176437310],
Cell[40658, 1184, 157, 5, 36, "Output",
 CellID->34666332]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[40864, 1195, 224, 7, 70, "ExampleSection",
 CellID->32392],
Cell[41091, 1204, 62, 1, 70, "ExampleText",
 CellID->36326898],
Cell[CellGroupData[{
Cell[41178, 1209, 420, 13, 70, "Input",
 CellID->16161155],
Cell[41601, 1224, 1245, 26, 175, "Output",
 CellID->127651720]
}, Open  ]],
Cell[42861, 1253, 125, 3, 70, "ExampleDelimiter",
 CellID->212396469],
Cell[CellGroupData[{
Cell[43011, 1260, 682, 22, 70, "Input",
 CellID->234017444],
Cell[43696, 1284, 389, 13, 51, "Output",
 CellID->40997559]
}, Open  ]],
Cell[CellGroupData[{
Cell[44122, 1302, 323, 12, 70, "Input",
 CellID->4536608],
Cell[44448, 1316, 390, 13, 51, "Output",
 CellID->133800121]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[44899, 1336, 311, 9, 70, "SeeAlsoSection",
 CellID->19086],
Cell[45213, 1347, 693, 26, 70, "SeeAlso",
 CellID->4270]
}, Open  ]],
Cell[CellGroupData[{
Cell[45943, 1378, 314, 9, 70, "TutorialsSection",
 CellID->17301],
Cell[46260, 1389, 156, 3, 70, "Tutorials",
 CellID->17100]
}, Open  ]],
Cell[CellGroupData[{
Cell[46453, 1397, 321, 9, 70, "RelatedLinksSection",
 CellID->10591],
Cell[46777, 1408, 200, 4, 70, "RelatedLinks"],
Cell[46980, 1414, 199, 4, 70, "RelatedLinks"],
Cell[47182, 1420, 388, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[47607, 1438, 319, 9, 70, "MoreAboutSection",
 CellID->598287934],
Cell[47929, 1449, 157, 3, 70, "MoreAbout",
 CellID->236731853],
Cell[48089, 1454, 161, 3, 70, "MoreAbout",
 CellID->98533452],
Cell[48253, 1459, 165, 3, 70, "MoreAbout",
 CellID->582981301]
}, Open  ]],
Cell[48433, 1465, 27, 0, 70, "History"],
Cell[48463, 1467, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

