(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14993,        511]
NotebookOptionsPosition[     11871,        407]
NotebookOutlinePosition[     13208,        446]
CellTagsIndexPosition[     13123,        441]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Streams and Low\[Hyphen]Level Input and Output" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StreamsAndLowLevelInputAndOutput"], 
          "The Main Loop" :> 
          Documentation`HelpLookup["paclet:tutorial/TheMainLoop"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Streams and Low\[Hyphen]Level Input and Output\"\>", 
       2->"\<\"The Main Loop\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Links" :> Documentation`HelpLookup["paclet:ref/Links"], 
          "OpenRead" :> Documentation`HelpLookup["paclet:ref/OpenRead"], 
          "OpenWrite" :> Documentation`HelpLookup["paclet:ref/OpenWrite"], 
          "$Input" :> Documentation`HelpLookup["paclet:ref/$Input"], 
          "Options" :> Documentation`HelpLookup["paclet:ref/Options"], 
          "SetOptions" :> Documentation`HelpLookup["paclet:ref/SetOptions"], 
          "InputStream" :> Documentation`HelpLookup["paclet:ref/InputStream"],
           "OpenAppend" :> Documentation`HelpLookup["paclet:ref/OpenAppend"], 
          "OutputStream" :> 
          Documentation`HelpLookup["paclet:ref/OutputStream"], "$Output" :> 
          Documentation`HelpLookup["paclet:ref/$Output"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Links\"\>", 2->"\<\"OpenRead\"\>", 
       3->"\<\"OpenWrite\"\>", 4->"\<\"$Input\"\>", 5->"\<\"Options\"\>", 
       6->"\<\"SetOptions\"\>", 7->"\<\"InputStream\"\>", 
       8->"\<\"OpenAppend\"\>", 9->"\<\"OutputStream\"\>", 
       10->"\<\"$Output\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"File Operations" :> 
          Documentation`HelpLookup["paclet:guide/FileOperations"], 
          "Low-Level File Operations" :> 
          Documentation`HelpLookup["paclet:guide/LowLevelFileOperations"], 
          "Mathematica Session Information" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicaSessionInformation"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"File Operations\"\>", 
       2->"\<\"Low-Level File Operations\"\>", 
       3->"\<\"Mathematica Session Information\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Streams", "ObjectName",
 CellID->13855],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Streams",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Streams"], "[", "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of all streams that are currently open. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Streams",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Streams"], "[", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]lists only streams with the specified name. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->20244]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The list returned by ",
 Cell[BoxData[
  ButtonBox["Streams",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Streams"]], "InlineFormula"],
 " can contain ",
 Cell[BoxData[
  ButtonBox["InputStream",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputStream"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["OutputStream",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputStream"]], "InlineFormula"],
 " objects. "
}], "Notes",
 CellID->5491]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->13863412],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->117024702],

Cell["List of all open streams:", "ExampleText",
 CellID->1555070438],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Streams", "[", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1192867476],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"OutputStream", "[", 
    RowBox[{"\<\"stdout\"\>", ",", "1"}], "]"}], ",", 
   RowBox[{"OutputStream", "[", 
    RowBox[{"\<\"stderr\"\>", ",", "2"}], "]"}]}], "}"}]], "Output",
 ImageSize->{346, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1763824387]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->732209121],

Cell[TextData[{
 "Streams with name ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"stdout\", \"TI\"]\)\>\""], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1157399337],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Streams", "[", "\"\<stdout\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->503782433],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"OutputStream", "[", 
   RowBox[{"\<\"stdout\"\>", ",", "1"}], "]"}], "}"}]], "Output",
 ImageSize->{177, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1690814957]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->7418],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Links",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Links"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OpenRead",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OpenRead"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OpenWrite",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OpenWrite"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$Input",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Input"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Options",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Options"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SetOptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetOptions"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InputStream",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InputStream"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OpenAppend",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OpenAppend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OutputStream",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OutputStream"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$Output",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Output"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->27722]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->6352],

Cell[TextData[ButtonBox["Streams and Low\[Hyphen]Level Input and Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StreamsAndLowLevelInputAndOutput"]], "Tutorials",\

 CellID->11451],

Cell[TextData[ButtonBox["The Main Loop",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheMainLoop"]], "Tutorials",
 CellID->29345]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->274719347],

Cell[TextData[ButtonBox["File Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FileOperations"]], "MoreAbout",
 CellID->421244719],

Cell[TextData[ButtonBox["Low-Level File Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelFileOperations"]], "MoreAbout",
 CellID->773235942],

Cell[TextData[ButtonBox["Mathematica Session Information",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicaSessionInformation"]], "MoreAbout",
 CellID->131533567]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Streams - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 24, 23.0788834}", "context" -> "System`", 
    "keywords" -> {
     "list of open files", "list of open streams", "stdout", "stdin", 
      "stderr"}, "index" -> True, "label" -> "Built-in Mathematica Symbol", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Streams[] gives a list of all streams that are currently open. \
Streams[\"name\"] lists only streams with the specified name. ", 
    "synonyms" -> {}, "title" -> "Streams", "type" -> "Symbol", "uri" -> 
    "ref/Streams"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5683, 166, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->13863412]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12981, 434}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3198, 68, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3821, 95, 45, 1, 70, "ObjectName",
 CellID->13855],
Cell[3869, 98, 782, 23, 70, "Usage",
 CellID->20244]
}, Open  ]],
Cell[CellGroupData[{
Cell[4688, 126, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5166, 143, 480, 18, 70, "Notes",
 CellID->5491]
}, Closed]],
Cell[CellGroupData[{
Cell[5683, 166, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->13863412],
Cell[CellGroupData[{
Cell[6067, 180, 148, 5, 70, "ExampleSection",
 CellID->117024702],
Cell[6218, 187, 69, 1, 70, "ExampleText",
 CellID->1555070438],
Cell[CellGroupData[{
Cell[6312, 192, 99, 3, 28, "Input",
 CellID->1192867476],
Cell[6414, 197, 361, 11, 36, "Output",
 CellID->1763824387]
}, Open  ]],
Cell[6790, 211, 125, 3, 70, "ExampleDelimiter",
 CellID->732209121],
Cell[6918, 216, 165, 6, 70, "ExampleText",
 CellID->1157399337],
Cell[CellGroupData[{
Cell[7108, 226, 116, 3, 70, "Input",
 CellID->503782433],
Cell[7227, 231, 258, 8, 36, "Output",
 CellID->1690814957]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7546, 246, 310, 9, 70, "SeeAlsoSection",
 CellID->7418],
Cell[7859, 257, 2421, 89, 70, "SeeAlso",
 CellID->27722]
}, Open  ]],
Cell[CellGroupData[{
Cell[10317, 351, 313, 9, 70, "TutorialsSection",
 CellID->6352],
Cell[10633, 362, 191, 4, 70, "Tutorials",
 CellID->11451],
Cell[10827, 368, 135, 3, 70, "Tutorials",
 CellID->29345]
}, Open  ]],
Cell[CellGroupData[{
Cell[10999, 376, 319, 9, 70, "MoreAboutSection",
 CellID->274719347],
Cell[11321, 387, 141, 3, 70, "MoreAbout",
 CellID->421244719],
Cell[11465, 392, 159, 3, 70, "MoreAbout",
 CellID->773235942],
Cell[11627, 397, 172, 3, 70, "MoreAbout",
 CellID->131533567]
}, Open  ]],
Cell[11814, 403, 27, 0, 70, "History"],
Cell[11844, 405, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

