(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     47940,       1848]
NotebookOptionsPosition[     36403,       1426]
NotebookOutlinePosition[     37626,       1461]
CellTagsIndexPosition[     37540,       1456]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Properties of Strings" :> 
          Documentation`HelpLookup["paclet:tutorial/PropertiesOfStrings"], 
          "Newlines and Tabs in Strings" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NewlinesAndTabsInStrings"], "Special Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SpecialCharacters-StringsAndCharacters"], 
          "String\[Hyphen]Oriented Output Formats" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StringOrientedOutputFormats"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Properties of Strings\"\>", 
       2->"\<\"Newlines and Tabs in Strings\"\>", 
       3->"\<\"Special Characters\"\>", 
       4->"\<\"String\[Hyphen]Oriented Output Formats\"\>"}, "\<\"tutorials\"\
\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ToExpression" :> 
          Documentation`HelpLookup["paclet:ref/ToExpression"], "ToString" :> 
          Documentation`HelpLookup["paclet:ref/ToString"], "Characters" :> 
          Documentation`HelpLookup["paclet:ref/Characters"], 
          "StringExpression" :> 
          Documentation`HelpLookup["paclet:ref/StringExpression"], 
          "RegularExpression" :> 
          Documentation`HelpLookup["paclet:ref/RegularExpression"], "StringQ" :> 
          Documentation`HelpLookup["paclet:ref/StringQ"], "SyntaxQ" :> 
          Documentation`HelpLookup["paclet:ref/SyntaxQ"], "Import" :> 
          Documentation`HelpLookup["paclet:ref/Import"], "Export" :> 
          Documentation`HelpLookup["paclet:ref/Export"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"ToExpression\"\>", 2->"\<\"ToString\"\>", 
       3->"\<\"Characters\"\>", 4->"\<\"StringExpression\"\>", 
       5->"\<\"RegularExpression\"\>", 6->"\<\"StringQ\"\>", 
       7->"\<\"SyntaxQ\"\>", 8->"\<\"Import\"\>", 
       9->"\<\"Export\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Core Language" :> 
          Documentation`HelpLookup["paclet:guide/CoreLanguageOverview"], 
          "Expressions" :> 
          Documentation`HelpLookup["paclet:guide/Expressions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Core Language\"\>", 
       2->"\<\"Expressions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "String ",
 StyleBox["(\"...\")", "OperatorCharacter"]
}], "ObjectName",
 CellID->26112],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["String",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/String"]], "InlineFormula"],
     "\[LineSeparator]is the head of a character string ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"text\", \"TI\"]\)\>\""], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->1055]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Strings can contain any sequence of ordinary or special characters. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->27015,
  ButtonNote->"27015"]
}], "Notes",
 CellID->13944],

Cell[TextData[{
 Cell[BoxData["_String"], "InlineFormula"],
 " can be used as a pattern that represents a string. "
}], "Notes",
 CellID->2750],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 ", special characters in strings are given as ",
 Cell[BoxData[
  RowBox[{"\\[", 
   StyleBox["Name", "TI"], "]"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"\\:", 
    StyleBox["code", "TI"]}]]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->4307,
  ButtonNote->"4307"]
}], "Notes",
 CellID->22446],

Cell[TextData[{
 "If an explicit newline in the string is preceded by a single backslash ",
 Cell[BoxData["\\"], "InlineFormula"],
 ", the backslash and newline are ignored."
}], "Notes",
 CellID->149386798]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->183198034],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->187465358],

Cell["Enter a string:", "ExampleText",
 CellID->27854],

Cell[CellGroupData[{

Cell[BoxData["\"\<This is a string.\>\""], "Input",
 CellLabel->"In[1]:=",
 CellID->26540],

Cell[BoxData["\<\"This is a string.\"\>"], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->174134124]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " shows quotes:"
}], "ExampleText",
 CellID->13478],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->771],

Cell["\"This is a string.\"", "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//InputForm=",
 CellID->844428039]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2890],

Cell[TextData[{
 "Enter explicit newlines using ",
 Cell[BoxData["\\n"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->7495],

Cell[CellGroupData[{

Cell[BoxData["\"\<one\\ntwo\\nthree\>\""], "Input",
 CellLabel->"In[1]:=",
 CellID->1869],

Cell[BoxData["\<\"one\\ntwo\\nthree\"\>"], "Output",
 ImageSize->{39, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->89124653]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->948],

Cell[TextData[{
 Cell[BoxData["\"\<\>\""], "InlineFormula"],
 " is the empty string, which normally does not print:"
}], "ExampleText",
 CellID->10998],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\"\<\>\"", ",", "x", ",", "\"\<\>\"", ",", "\"\<\>\""}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27328],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"\"\>", ",", "x", ",", "\<\"\"\>", ",", "\<\"\"\>"}], 
  "}"}]], "Output",
 ImageSize->{59, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21165308]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " explicitly shows the empty strings:"
}], "ExampleText",
 CellID->21851],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3958],

Cell["{\"\", x, \"\", \"\"}", "Output",
 ImageSize->{105, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//InputForm=",
 CellID->978001]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19733],

Cell["\<\
Strings can contain any sequence of ordinary and special characters:\
\>", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->27015],

Cell[CellGroupData[{

Cell[BoxData["\"\<\[FilledDiamond] String \[Alpha]\[Beta]\[Gamma] \
\[LongLeftRightArrow] \[ScriptCapitalA]\[ScriptCapitalB]\[ScriptCapitalC] \
\[ReturnIndicator]\>\""], "Input",
 CellLabel->"In[1]:=",
 CellID->10687],

Cell[BoxData["\<\"\[FilledDiamond] String \[Alpha]\[Beta]\[Gamma] \
\[LongLeftRightArrow] \[ScriptCapitalA]\[ScriptCapitalB]\[ScriptCapitalC] \
\[ReturnIndicator]\"\>"], "Output",
 ImageSize->{155, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->472129352]
}, Open  ]],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 ", full character names are used:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->4307],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16485],

Cell[BoxData[
 TagBox[
  StyleBox[
   "\"\<\\[FilledDiamond] String \\[Alpha]\\[Beta]\\[Gamma] \
\\[LongLeftRightArrow] \\[ScriptCapitalA]\\[ScriptCapitalB]\\[ScriptCapitalC] \
\\[ReturnIndicator]\>\"",
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{515, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm=",
 CellID->186403044]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14188],

Cell["Strings preserve internal formatting:", "ExampleText",
 CellID->3865],

Cell[CellGroupData[{

Cell[BoxData["\"\<\!\(\*
StyleBox[\"red\",
FontColor->RGBColor[1, 0, 0]]\) \!\(\*
StyleBox[\"blue\",
FontColor->RGBColor[0, 0, 1]]\) \!\(\*
StyleBox[\"green\",
FontColor->RGBColor[0, 1, 0]]\)\!\(\*
StyleBox[\" \",
FontColor->RGBColor[0, 1, 0]]\)\!\(\*
StyleBox[\"italic\",
FontSlant->\"Italic\"]\)\>\""], "Input",
 CellLabel->"In[1]:=",
 CellID->26500],

Cell[BoxData["\<\"\\!\\(\\*\\nStyleBox[\\\"red\\\",\\nFontColor->RGBColor[1, \
0, 0]]\\) \\!\\(\\*\\nStyleBox[\\\"blue\\\",\\nFontColor->RGBColor[0, 0, \
1]]\\) \\!\\(\\*\\nStyleBox[\\\"green\\\",\\nFontColor->RGBColor[0, 1, 0]]\\)\
\\!\\(\\*\\nStyleBox[\\\" \\\",\\nFontColor->RGBColor[0, 1, \
0]]\\)\\!\\(\\*\\nStyleBox[\\\"italic\\\",\\nFontSlant->\\\"Italic\\\"]\\)\"\>\
"], "Output",
 ImageSize->{151, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27532679]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16562],

Cell[TextData[{
 "All strings have head ",
 Cell[BoxData[
  ButtonBox["String",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/String"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->4399],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Head", "[", "\"\<a string\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22425],

Cell[BoxData["String"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1736670]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28878],

Cell[TextData[{
 Cell[BoxData["_String"], "InlineFormula"],
 " matches any string, but not a symbol:"
}], "ExampleText",
 CellID->14551],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "\"\<ab\>\"", ",", "\"\<cd\>\"", ",", "x", ",", "y"}],
     "}"}], ",", "_String"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18417],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"ab\"\>", ",", "\<\"cd\"\>"}], "}"}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->151744814]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17212],

Cell["Strings can have any expression embedded:", "ExampleText",
 CellID->21736],

Cell[CellGroupData[{

Cell[BoxData["\"\<ab \[Integral]\!\(\*FractionBox[\(1\), \(x\)]\)\
\[DifferentialD]x cd\>\""], "Input",
 CellLabel->"In[1]:=",
 CellID->8773],

Cell[BoxData["\<\"ab \[Integral]\\!\\(\\*FractionBox[\\(1\\), \\(x\\)]\\)\
\[DifferentialD]x cd\"\>"], "Output",
 ImageSize->{80, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->214693281]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24891],

Cell[BoxData[
 TagBox[
  StyleBox[
   "\"\<ab \\[Integral]\\!\\(\\*FractionBox[\\(1\\), \
\\(x\\)]\\)\\[DifferentialD]x cd\>\"",
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{487, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm=",
 CellID->97428034]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26314],

Cell["Strings can contain graphics:", "ExampleText",
 CellID->23206],

Cell[CellGroupData[{

Cell[BoxData["\"\<ab \!\(\*
GraphicsBox[DiskBox[{0, 0}],
ImageSize->{34., Automatic}]\) cd\>\""], "Input",
 CellLabel->"In[1]:=",
 CellID->29123],

Cell[BoxData["\<\"ab \\!\\(\\*\\nGraphicsBox[DiskBox[{0, \
0}],\\nImageSize->{34., Automatic}]\\) cd\"\>"], "Output",
 ImageSize->{80, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->51785095]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6993],

Cell[BoxData[
 TagBox[
  StyleBox[
   "\"\<ab \\!\\(\\*\\nGraphicsBox[DiskBox[{0, 0}],\\nImageSize->{34., \
Automatic}]\\) cd\>\"",
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{536, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm=",
 CellID->102541173]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6904],

Cell["Print text (the quotes do not appear by default):", "ExampleText",
 CellID->26587],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Print", "[", 
  RowBox[{"\"\<The answer is \>\"", ",", 
   RowBox[{"2", "^", "45"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21632],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"The answer is \"\>", "\[InvisibleSpace]", "35184372088832"}],
  SequenceForm["The answer is ", 35184372088832],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->249312590]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6775],

Cell["Create formatted text:", "ExampleText",
 CellID->987],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{"\"\<This is a string.\>\"", ",", 
   RowBox[{"FontSize", "->", "25"}], ",", 
   RowBox[{"FontFamily", "->", "\"\<Helvetica\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11845],

Cell[BoxData[
 StyleBox["\<\"This is a string.\"\>",
  StripOnInput->False,
  FontFamily->"Helvetica",
  FontSize->25]], "Output",
 ImageSize->{174, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->96726981]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12286],

Cell["Define a function which applies only to strings:", "ExampleText",
 CellID->20029],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "s_String", "]"}], ":=", 
  RowBox[{"StringJoin", "[", 
   RowBox[{"RotateLeft", "[", 
    RowBox[{"Characters", "[", "s", "]"}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20346],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "\"\<X\>\"", "]"}], ",", 
   RowBox[{"f", "[", "\"\<ABCDEF\>\"", "]"}], ",", 
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2762],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"X\"\>", ",", "\<\"BCDEFA\"\>", ",", 
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}]}], "}"}]], "Output",
 ImageSize->{207, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1064111265]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9894],

Cell["Use strings as plot markers:", "ExampleText",
 CellID->30652],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "1", ",", "4"}], "}"}]}], "}"}], ",", 
   RowBox[{"PlotMarkers", "->", 
    RowBox[{"{", 
     RowBox[{"\"\<A\>\"", ",", "\"\<B\>\""}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28103],

Cell[BoxData[
 GraphicsBox[{
   {Hue[0.67, 0.6, 0.6], InsetBox[
     TagBox["A",
      "InsetString"], {1., 1.}], InsetBox[
     TagBox["A",
      "InsetString"], {2., 2.}], InsetBox[
     TagBox["A",
      "InsetString"], {3., 3.}]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], InsetBox[
     TagBox["B",
      "InsetString"], {1., 3.}], InsetBox[
     TagBox["B",
      "InsetString"], {2., 1.}], InsetBox[
     TagBox["B",
      "InsetString"], {3., 4.}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 1.},
  ImageMargins->0.,
  PlotRange->{{0, 3.}, {1., 4.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{229, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->438286810]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27646],

Cell["Give text in graphics:", "ExampleText",
 CellID->30186],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Text", "[", 
     RowBox[{"\"\<abcde\>\"", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"-", "2"}]}], "}"}]}], "]"}], ",", 
    RowBox[{"Disk", "[", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], "]"}], ",", 
    RowBox[{"Text", "[", 
     RowBox[{"\"\<ABCDE\>\"", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "2"}], "}"}]}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3297],

Cell[BoxData[
 GraphicsBox[{InsetBox["\<\"abcde\"\>", {0, -2}], DiskBox[{0, 0}], 
   InsetBox["\<\"ABCDE\"\>", {0, 2}]},
  ImageMargins->0.]], "Output",
 ImageSize->{51, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{47., Automatic}},
 CellLabel->"Out[1]=",
 CellID->231338744]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18920],

Cell["Break a string into characters:", "ExampleText",
 CellID->26021],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Characters", "[", "\"\<This is a string.\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4384],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"T\"\>", ",", "\<\"h\"\>", ",", "\<\"i\"\>", ",", "\<\"s\"\>", 
   ",", "\<\" \"\>", ",", "\<\"i\"\>", ",", "\<\"s\"\>", ",", "\<\" \"\>", 
   ",", "\<\"a\"\>", ",", "\<\" \"\>", ",", "\<\"s\"\>", ",", "\<\"t\"\>", 
   ",", "\<\"r\"\>", ",", "\<\"i\"\>", ",", "\<\"n\"\>", ",", "\<\"g\"\>", 
   ",", "\<\".\"\>"}], "}"}]], "Output",
 ImageSize->{316, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->348023081]
}, Open  ]],

Cell["Reconstruct the string:", "ExampleText",
 CellID->5357],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringJoin", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15316],

Cell[BoxData["\<\"This is a string.\"\>"], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->178809890]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29208],

Cell["Find character codes for characters in a string:", "ExampleText",
 CellID->1191],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCharacterCode", "[", "\"\<This is a string.\>\"", "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->25714],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "84", ",", "104", ",", "105", ",", "115", ",", "32", ",", "105", ",", "115",
    ",", "32", ",", "97", ",", "32", ",", "115", ",", "116", ",", "114", ",", 
   "105", ",", "110", ",", "103", ",", "46"}], "}"}]], "Output",
 ImageSize->{512, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->306587053]
}, Open  ]],

Cell["Reconstruct the string:", "ExampleText",
 CellID->30646],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromCharacterCode", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19990],

Cell[BoxData["\<\"This is a string.\"\>"], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->92496029]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26824],

Cell["Turn a string into an expression:", "ExampleText",
 CellID->22489],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToExpression", "[", "\"\<1+x^4\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24421],

Cell[BoxData[
 RowBox[{"1", "+", 
  SuperscriptBox["x", "4"]}]], "Output",
 ImageSize->{37, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->691263777]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16982],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ToString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToString"]], "InlineFormula"],
 " creates strings, by default with ",
 Cell[BoxData[
  ButtonBox["OutputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputForm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->20594],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToString", "[", 
  RowBox[{"1", "+", 
   RowBox[{"x", "^", "4"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8725],

Cell[BoxData["\<\"     4\\n1 + x\"\>"], "Output",
 ImageSize->{46, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->112809364]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5588],

Cell[BoxData[
 TagBox[
  StyleBox["\"\<     4\\n1 + x\>\"",
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm=",
 CellID->37418368]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10328],

Cell[TextData[{
 "Create a string containing ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->31311],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToString", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"x", "^", "4"}]}], ",", "InputForm"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25778],

Cell[BoxData["\<\"1 + x^4\"\>"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6519302]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18875],

Cell[BoxData[
 TagBox[
  StyleBox["\"\<1 + x^4\>\"",
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm=",
 CellID->108257864]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25218],

Cell[TextData[{
 "Use ",
 Cell[BoxData["\\\""], "InlineFormula"],
 " to enter a ",
 Cell[BoxData["\"\<\>"], "InlineFormula"],
 " inside a string:"
}], "ExampleText",
 CellID->17618],

Cell[CellGroupData[{

Cell[BoxData["\"\<a string with \\\"quotes\\\"\>\""], "Input",
 CellLabel->"In[1]:=",
 CellID->29448],

Cell[BoxData["\<\"a string with \\\"quotes\\\"\"\>"], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->484655060]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25599],

Cell["Strings are treated as \"atoms\" with no parts:", "ExampleText",
 CellID->9616],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "\"\<a string\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11627],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->147811068]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["StringLength",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringLength"]], "InlineFormula"],
 " to find the character length of a string:"
}], "ExampleText",
 CellID->16207],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringLength", "[", "\"\<a string\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28349],

Cell[BoxData["8"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->483147114]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25502],

Cell["\<\
Strings do not automatically insert spacing around operator characters:\
\>", "ExampleText",
 CellID->389],

Cell[CellGroupData[{

Cell[BoxData["\"\<x\[Rule]a+b+c+d\>\""], "Input",
 CellLabel->"In[1]:=",
 CellID->24746],

Cell[BoxData["\<\"x\[Rule]a+b+c+d\"\>"], "Output",
 ImageSize->{69, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->533258832]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "\[Rule]", 
  RowBox[{"a", "+", "b", "+", "c", "+", "d"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18646],

Cell[BoxData[
 RowBox[{"x", "\[Rule]", 
  RowBox[{"a", "+", "b", "+", "c", "+", "d"}]}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->44487712]
}, Open  ]],

Cell[TextData[{
 "An ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " string contains explicit space characters:"
}], "ExampleText",
 CellID->26512],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToString", "[", 
  RowBox[{"%", ",", "InputForm"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->14698],

Cell[BoxData["\<\"x -> a + b + c + d\"\>"], "Output",
 ImageSize->{130, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->554233649]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30589],

Cell["\<\
The actual sequences of characters in a formatted string can be fairly \
complicated:\
\>", "ExampleText",
 CellID->1922],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "\"\<\!\(\*
StyleBox[\"red\",
FontColor->RGBColor[1, 0, 0]]\) \!\(\*
StyleBox[\"italic\",
FontSlant->\"Italic\"]\)\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15724],

Cell[BoxData[
 TagBox[
  StyleBox[
   "\"\<\\!\\(\\*\\nStyleBox[\\\"red\\\",\\nFontColor->RGBColor[1, 0, 0]]\\) \
\\!\\(\\*\\nStyleBox[\\\"italic\\\",\\nFontSlant->\\\"Italic\\\"]\\)\>\"",
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{445, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//FullForm=",
 CellID->17363436]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "\"\<ab \!\(\*
GraphicsBox[DiskBox[{0, 0}],
ImageSize->{34., Automatic}]\) cd\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29496],

Cell[BoxData[
 TagBox[
  StyleBox[
   "\"\<ab \\!\\(\\*\\nGraphicsBox[DiskBox[{0, 0}],\\nImageSize->{34., \
Automatic}]\\) cd\>\"",
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{536, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm=",
 CellID->50624304]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9507],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToExpression"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToString"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Characters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Characters"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringExpression"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RegularExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RegularExpression"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SyntaxQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SyntaxQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19730]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->20530],

Cell[TextData[ButtonBox["Properties of Strings",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PropertiesOfStrings"]], "Tutorials",
 CellID->30461],

Cell[TextData[ButtonBox["Newlines and Tabs in Strings",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NewlinesAndTabsInStrings"]], "Tutorials",
 CellID->398647730],

Cell[TextData[ButtonBox["Special Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SpecialCharacters-StringsAndCharacters"]], "Tutorials",
 CellID->336637905],

Cell[TextData[ButtonBox["String\[Hyphen]Oriented Output Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StringOrientedOutputFormats"]], "Tutorials",
 CellID->140352686]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->28755424],

Cell[TextData[ButtonBox["Core Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CoreLanguageOverview"]], "MoreAbout",
 CellID->70904540],

Cell[TextData[ButtonBox["Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Expressions"]], "MoreAbout",
 CellID->612367936]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"String (\"...\") - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 24, 32.4072472}", "context" -> "System`", 
    "keywords" -> {"double quotes", "\\:", "\\r", "\\n", "\\t"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "String is the head of a character string \" text\". ", "synonyms" -> {}, 
    "title" -> "String", "type" -> "Symbol", "uri" -> "ref/String"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6175, 191, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->183198034]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 37397, 1449}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3282, 72, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3905, 99, 105, 4, 70, "ObjectName",
 CellID->26112],
Cell[4013, 105, 507, 16, 70, "Usage",
 CellID->1055]
}, Open  ]],
Cell[CellGroupData[{
Cell[4557, 126, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5035, 143, 222, 7, 70, "Notes",
 CellID->13944],
Cell[5260, 152, 143, 4, 70, "Notes",
 CellID->2750],
Cell[5406, 158, 522, 21, 70, "Notes",
 CellID->22446],
Cell[5931, 181, 207, 5, 70, "Notes",
 CellID->149386798]
}, Closed]],
Cell[CellGroupData[{
Cell[6175, 191, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->183198034],
Cell[CellGroupData[{
Cell[6560, 205, 148, 5, 70, "ExampleSection",
 CellID->187465358],
Cell[6711, 212, 54, 1, 70, "ExampleText",
 CellID->27854],
Cell[CellGroupData[{
Cell[6790, 217, 90, 2, 28, "Input",
 CellID->26540],
Cell[6883, 221, 183, 5, 36, "Output",
 CellID->174134124]
}, Open  ]],
Cell[7081, 229, 189, 7, 70, "ExampleText",
 CellID->13478],
Cell[CellGroupData[{
Cell[7295, 240, 99, 3, 28, "Input",
 CellID->771],
Cell[7397, 245, 181, 5, 50, "Output",
 CellID->844428039]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7627, 256, 215, 7, 70, "ExampleSection",
 CellID->2890],
Cell[7845, 265, 129, 5, 70, "ExampleText",
 CellID->7495],
Cell[CellGroupData[{
Cell[7999, 274, 89, 2, 70, "Input",
 CellID->1869],
Cell[8091, 278, 181, 5, 71, "Output",
 CellID->89124653]
}, Open  ]],
Cell[8287, 286, 119, 3, 70, "ExampleDelimiter",
 CellID->948],
Cell[8409, 291, 151, 4, 70, "ExampleText",
 CellID->10998],
Cell[CellGroupData[{
Cell[8585, 299, 155, 5, 70, "Input",
 CellID->27328],
Cell[8743, 306, 246, 8, 36, "Output",
 CellID->21165308]
}, Open  ]],
Cell[9004, 317, 211, 7, 70, "ExampleText",
 CellID->21851],
Cell[CellGroupData[{
Cell[9240, 328, 100, 3, 70, "Input",
 CellID->3958],
Cell[9343, 333, 178, 5, 50, "Output",
 CellID->978001]
}, Open  ]],
Cell[9536, 341, 121, 3, 70, "ExampleDelimiter",
 CellID->19733],
Cell[9660, 346, 163, 4, 70, "ExampleText",
 CellID->27015],
Cell[CellGroupData[{
Cell[9848, 354, 217, 4, 70, "Input",
 CellID->10687],
Cell[10068, 360, 310, 7, 36, "Output",
 CellID->472129352]
}, Open  ]],
Cell[10393, 370, 260, 9, 70, "ExampleText",
 CellID->4307],
Cell[CellGroupData[{
Cell[10678, 383, 100, 3, 70, "Input",
 CellID->16485],
Cell[10781, 388, 454, 14, 68, "Output",
 CellID->186403044]
}, Open  ]],
Cell[11250, 405, 121, 3, 70, "ExampleDelimiter",
 CellID->14188],
Cell[11374, 410, 75, 1, 70, "ExampleText",
 CellID->3865],
Cell[CellGroupData[{
Cell[11474, 415, 352, 12, 70, "Input",
 CellID->26500],
Cell[11829, 429, 518, 10, 36, "Output",
 CellID->27532679]
}, Open  ]],
Cell[12362, 442, 121, 3, 70, "ExampleDelimiter",
 CellID->16562],
Cell[12486, 447, 196, 8, 70, "ExampleText",
 CellID->4399],
Cell[CellGroupData[{
Cell[12707, 459, 111, 3, 70, "Input",
 CellID->22425],
Cell[12821, 464, 161, 5, 36, "Output",
 CellID->1736670]
}, Open  ]],
Cell[12997, 472, 121, 3, 70, "ExampleDelimiter",
 CellID->28878],
Cell[13121, 477, 136, 4, 70, "ExampleText",
 CellID->14551],
Cell[CellGroupData[{
Cell[13282, 485, 243, 8, 70, "Input",
 CellID->18417],
Cell[13528, 495, 221, 7, 36, "Output",
 CellID->151744814]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13798, 508, 239, 7, 70, "ExampleSection",
 CellID->17212],
Cell[14040, 517, 80, 1, 70, "ExampleText",
 CellID->21736],
Cell[CellGroupData[{
Cell[14145, 522, 141, 3, 70, "Input",
 CellID->8773],
Cell[14289, 527, 242, 6, 51, "Output",
 CellID->214693281]
}, Open  ]],
Cell[CellGroupData[{
Cell[14568, 538, 100, 3, 70, "Input",
 CellID->24891],
Cell[14671, 543, 379, 13, 50, "Output",
 CellID->97428034]
}, Open  ]],
Cell[15065, 559, 121, 3, 70, "ExampleDelimiter",
 CellID->26314],
Cell[15189, 564, 68, 1, 70, "ExampleText",
 CellID->23206],
Cell[CellGroupData[{
Cell[15282, 569, 145, 4, 70, "Input",
 CellID->29123],
Cell[15430, 575, 246, 6, 57, "Output",
 CellID->51785095]
}, Open  ]],
Cell[CellGroupData[{
Cell[15713, 586, 99, 3, 70, "Input",
 CellID->6993],
Cell[15815, 591, 383, 13, 50, "Output",
 CellID->102541173]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16247, 610, 222, 7, 70, "ExampleSection",
 CellID->6904],
Cell[16472, 619, 88, 1, 70, "ExampleText",
 CellID->26587],
Cell[CellGroupData[{
Cell[16585, 624, 166, 5, 70, "Input",
 CellID->21632],
Cell[16754, 631, 254, 6, 70, "Print",
 CellID->249312590]
}, Open  ]],
Cell[17023, 640, 120, 3, 70, "ExampleDelimiter",
 CellID->6775],
Cell[17146, 645, 59, 1, 70, "ExampleText",
 CellID->987],
Cell[CellGroupData[{
Cell[17230, 650, 237, 6, 70, "Input",
 CellID->11845],
Cell[17470, 658, 260, 9, 49, "Output",
 CellID->96726981]
}, Open  ]],
Cell[17745, 670, 121, 3, 70, "ExampleDelimiter",
 CellID->12286],
Cell[17869, 675, 87, 1, 70, "ExampleText",
 CellID->20029],
Cell[17959, 678, 238, 7, 70, "Input",
 CellID->20346],
Cell[CellGroupData[{
Cell[18222, 689, 328, 10, 70, "Input",
 CellID->2762],
Cell[18553, 701, 365, 11, 36, "Output",
 CellID->1064111265]
}, Open  ]],
Cell[18933, 715, 120, 3, 70, "ExampleDelimiter",
 CellID->9894],
Cell[19056, 720, 67, 1, 70, "ExampleText",
 CellID->30652],
Cell[CellGroupData[{
Cell[19148, 725, 400, 13, 70, "Input",
 CellID->28103],
Cell[19551, 740, 895, 30, 168, "Output",
 CellID->438286810]
}, Open  ]],
Cell[20461, 773, 121, 3, 70, "ExampleDelimiter",
 CellID->27646],
Cell[20585, 778, 61, 1, 70, "ExampleText",
 CellID->30186],
Cell[CellGroupData[{
Cell[20671, 783, 518, 17, 70, "Input",
 CellID->3297],
Cell[21192, 802, 335, 9, 122, "Output",
 CellID->231338744]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21576, 817, 233, 7, 70, "ExampleSection",
 CellID->18920],
Cell[21812, 826, 70, 1, 70, "ExampleText",
 CellID->26021],
Cell[CellGroupData[{
Cell[21907, 831, 125, 3, 70, "Input",
 CellID->4384],
Cell[22035, 836, 506, 11, 36, "Output",
 CellID->348023081]
}, Open  ]],
Cell[22556, 850, 61, 1, 70, "ExampleText",
 CellID->5357],
Cell[CellGroupData[{
Cell[22642, 855, 102, 3, 70, "Input",
 CellID->15316],
Cell[22747, 860, 183, 5, 36, "Output",
 CellID->178809890]
}, Open  ]],
Cell[22945, 868, 121, 3, 70, "ExampleDelimiter",
 CellID->29208],
Cell[23069, 873, 86, 1, 70, "ExampleText",
 CellID->1191],
Cell[CellGroupData[{
Cell[23180, 878, 133, 4, 70, "Input",
 CellID->25714],
Cell[23316, 884, 393, 10, 36, "Output",
 CellID->306587053]
}, Open  ]],
Cell[23724, 897, 62, 1, 70, "ExampleText",
 CellID->30646],
Cell[CellGroupData[{
Cell[23811, 902, 109, 3, 70, "Input",
 CellID->19990],
Cell[23923, 907, 182, 5, 36, "Output",
 CellID->92496029]
}, Open  ]],
Cell[24120, 915, 121, 3, 70, "ExampleDelimiter",
 CellID->26824],
Cell[24244, 920, 72, 1, 70, "ExampleText",
 CellID->22489],
Cell[CellGroupData[{
Cell[24341, 925, 116, 3, 70, "Input",
 CellID->24421],
Cell[24460, 930, 204, 7, 36, "Output",
 CellID->691263777]
}, Open  ]],
Cell[24679, 940, 121, 3, 70, "ExampleDelimiter",
 CellID->16982],
Cell[24803, 945, 336, 12, 70, "ExampleText",
 CellID->20594],
Cell[CellGroupData[{
Cell[25164, 961, 146, 5, 70, "Input",
 CellID->8725],
Cell[25313, 968, 179, 5, 54, "Output",
 CellID->112809364]
}, Open  ]],
Cell[CellGroupData[{
Cell[25529, 978, 99, 3, 70, "Input",
 CellID->5588],
Cell[25631, 983, 310, 11, 50, "Output",
 CellID->37418368]
}, Open  ]],
Cell[25956, 997, 121, 3, 70, "ExampleDelimiter",
 CellID->10328],
Cell[26080, 1002, 208, 8, 70, "ExampleText",
 CellID->31311],
Cell[CellGroupData[{
Cell[26313, 1014, 180, 6, 70, "Input",
 CellID->25778],
Cell[26496, 1022, 170, 5, 36, "Output",
 CellID->6519302]
}, Open  ]],
Cell[CellGroupData[{
Cell[26703, 1032, 100, 3, 70, "Input",
 CellID->18875],
Cell[26806, 1037, 303, 11, 50, "Output",
 CellID->108257864]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[27158, 1054, 226, 7, 70, "ExampleSection",
 CellID->25218],
Cell[27387, 1063, 181, 7, 70, "ExampleText",
 CellID->17618],
Cell[CellGroupData[{
Cell[27593, 1074, 101, 2, 70, "Input",
 CellID->29448],
Cell[27697, 1078, 194, 5, 36, "Output",
 CellID->484655060]
}, Open  ]],
Cell[27906, 1086, 121, 3, 70, "ExampleDelimiter",
 CellID->25599],
Cell[28030, 1091, 85, 1, 70, "ExampleText",
 CellID->9616],
Cell[CellGroupData[{
Cell[28140, 1096, 113, 3, 70, "Input",
 CellID->11627],
Cell[28256, 1101, 158, 5, 36, "Output",
 CellID->147811068]
}, Open  ]],
Cell[28429, 1109, 232, 8, 70, "ExampleText",
 CellID->16207],
Cell[CellGroupData[{
Cell[28686, 1121, 119, 3, 70, "Input",
 CellID->28349],
Cell[28808, 1126, 158, 5, 36, "Output",
 CellID->483147114]
}, Open  ]],
Cell[28981, 1134, 121, 3, 70, "ExampleDelimiter",
 CellID->25502],
Cell[29105, 1139, 116, 3, 70, "ExampleText",
 CellID->389],
Cell[CellGroupData[{
Cell[29246, 1146, 88, 2, 70, "Input",
 CellID->24746],
Cell[29337, 1150, 180, 5, 36, "Output",
 CellID->533258832]
}, Open  ]],
Cell[CellGroupData[{
Cell[29554, 1160, 137, 4, 70, "Input",
 CellID->18646],
Cell[29694, 1166, 228, 7, 36, "Output",
 CellID->44487712]
}, Open  ]],
Cell[29937, 1176, 226, 8, 70, "ExampleText",
 CellID->26512],
Cell[CellGroupData[{
Cell[30188, 1188, 131, 4, 70, "Input",
 CellID->14698],
Cell[30322, 1194, 184, 5, 36, "Output",
 CellID->554233649]
}, Open  ]],
Cell[30521, 1202, 121, 3, 70, "ExampleDelimiter",
 CellID->30589],
Cell[30645, 1207, 131, 4, 70, "ExampleText",
 CellID->1922],
Cell[CellGroupData[{
Cell[30801, 1215, 216, 7, 70, "Input",
 CellID->15724],
Cell[31020, 1224, 439, 13, 68, "Output",
 CellID->17363436]
}, Open  ]],
Cell[CellGroupData[{
Cell[31496, 1242, 179, 5, 70, "Input",
 CellID->29496],
Cell[31678, 1249, 382, 13, 50, "Output",
 CellID->50624304]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[32121, 1269, 310, 9, 70, "SeeAlsoSection",
 CellID->9507],
Cell[32434, 1280, 2200, 80, 70, "SeeAlso",
 CellID->19730]
}, Open  ]],
Cell[CellGroupData[{
Cell[34671, 1365, 314, 9, 70, "TutorialsSection",
 CellID->20530],
Cell[34988, 1376, 151, 3, 70, "Tutorials",
 CellID->30461],
Cell[35142, 1381, 167, 3, 70, "Tutorials",
 CellID->398647730],
Cell[35312, 1386, 174, 4, 70, "Tutorials",
 CellID->336637905],
Cell[35489, 1392, 180, 3, 70, "Tutorials",
 CellID->140352686]
}, Open  ]],
Cell[CellGroupData[{
Cell[35706, 1400, 318, 9, 70, "MoreAboutSection",
 CellID->28755424],
Cell[36027, 1411, 144, 3, 70, "MoreAbout",
 CellID->70904540],
Cell[36174, 1416, 134, 3, 70, "MoreAbout",
 CellID->612367936]
}, Open  ]],
Cell[36323, 1422, 50, 0, 70, "History"],
Cell[36376, 1424, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

