(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     56396,       2029]
NotebookOptionsPosition[     44503,       1613]
NotebookOutlinePosition[     46165,       1655]
CellTagsIndexPosition[     46079,       1650]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"String Patterns" :> 
          Documentation`HelpLookup["paclet:tutorial/StringPatterns"], 
          "Special Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SpecialCharacters-StringsAndCharacters"], 
          "Working with String Patterns" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/WorkingWithStringPatternsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"String Patterns\"\>", 
       2->"\<\"Special Characters\"\>", 
       3->"\<\"Working with String Patterns\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Cases" :> Documentation`HelpLookup["paclet:ref/Cases"], 
          "StringPosition" :> 
          Documentation`HelpLookup["paclet:ref/StringPosition"], 
          "StringCount" :> Documentation`HelpLookup["paclet:ref/StringCount"],
           "StringReplace" :> 
          Documentation`HelpLookup["paclet:ref/StringReplace"], "StringFreeQ" :> 
          Documentation`HelpLookup["paclet:ref/StringFreeQ"], 
          "StringReplaceList" :> 
          Documentation`HelpLookup["paclet:ref/StringReplaceList"], 
          "Characters" :> Documentation`HelpLookup["paclet:ref/Characters"], 
          "StringExpression" :> 
          Documentation`HelpLookup["paclet:ref/StringExpression"], 
          "RegularExpression" :> 
          Documentation`HelpLookup["paclet:ref/RegularExpression"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Cases\"\>", 
       2->"\<\"StringPosition\"\>", 3->"\<\"StringCount\"\>", 
       4->"\<\"StringReplace\"\>", 5->"\<\"StringFreeQ\"\>", 
       6->"\<\"StringReplaceList\"\>", 7->"\<\"Characters\"\>", 
       8->"\<\"StringExpression\"\>", 
       9->"\<\"RegularExpression\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Language Overview" :> 
          Documentation`HelpLookup["paclet:guide/LanguageOverview"], 
          "Processing Textual Data" :> 
          Documentation`HelpLookup["paclet:guide/ProcessingTextualData"], 
          "String Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/StringManipulation"], 
          "String Operations" :> 
          Documentation`HelpLookup["paclet:guide/StringOperations"], 
          "String Patterns" :> 
          Documentation`HelpLookup["paclet:guide/StringPatterns"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Language Overview\"\>", 
       2->"\<\"Processing Textual Data\"\>", 3->"\<\"String Manipulation\"\>",
        4->"\<\"String Operations\"\>", 
       5->"\<\"String Patterns\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["StringCases", "ObjectName",
 CellID->2122],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringCases",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringCases"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", 
        StyleBox["patt", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of the substrings in ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\""], "InlineFormula"],
     " that match the string expression ",
     Cell[BoxData[
      StyleBox["patt", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringCases",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringCases"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", 
        RowBox[{
         StyleBox["lhs", "TI"], "->", 
         StyleBox["rhs", "TI"]}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of the values of ",
     Cell[BoxData[
      StyleBox["rhs", "TI"]], "InlineFormula"],
     " corresponding to the substrings that match the string expression ",
     Cell[BoxData[
      StyleBox["lhs", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringCases",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringCases"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", 
        StyleBox["p", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]includes only the first ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " substrings that match. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringCases",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringCases"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["p", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["p", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives substrings that match any of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["p", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringCases",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringCases"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["s", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["s", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["p", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the list of results for each of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->15019]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "String expressions can contain any of the objects specified in the notes \
for ",
 Cell[BoxData[
  ButtonBox["StringExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringExpression"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->23224],

Cell[TextData[{
 "With the default option setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Overlaps",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Overlaps"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["StringCases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringCases"]], "InlineFormula"],
 " includes only substrings that do not overlap. With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Overlaps",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Overlaps"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " it includes substrings that overlap. "
}], "Notes",
 CellID->26098],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Overlaps",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Overlaps"], "->", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"]}]], "InlineFormula"],
 ", multiple substrings that match the same string expression are all \
included. With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Overlaps",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Overlaps"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", only the first such matching substring at a given position is included. "
}], "Notes",
 CellID->3921],

Cell[TextData[{
 "Setting the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["IgnoreCase",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IgnoreCase"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " makes ",
 Cell[BoxData[
  ButtonBox["StringCases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringCases"]], "InlineFormula"],
 " treat lowercase and uppercase letters as equivalent. "
}], "Notes",
 CellID->19072],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["StringCases",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringCases"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", 
    RowBox[{
     ButtonBox["RegularExpression",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RegularExpression"], "[", "\"\<\!\(\*
StyleBox[\"regex\", \"TI\"]\)\>\"", "]"}]}], "]"}]], "InlineFormula"],
 " gives substrings matching the specified regular expression. "
}], "Notes",
 CellID->27066],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["StringCases",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringCases"], "[", 
   RowBox[{
    StyleBox["s", "TI"], ",", 
    RowBox[{
     StyleBox["lhs", "TI"], ":>", 
     StyleBox["rhs", "TI"]}]}], "]"}]], "InlineFormula"],
 " evaluates ",
 Cell[BoxData[
  StyleBox["rhs", "TI"]], "InlineFormula"],
 " only when the pattern is found. "
}], "Notes",
 CellID->30121]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->89788778],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->22165477],

Cell["Find the substrings matching a pattern:", "ExampleText",
 CellID->9580],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"StringCases", "[", 
   RowBox[{"\"\<abcadcacb\>\"", ",", 
    RowBox[{"\"\<a\>\"", "~~", "_", "~~", "\"\<c\>\""}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7096],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"abc\"\>", ",", "\<\"adc\"\>"}], "}"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->325756827]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19957],

Cell["Return only the named wild-card character in each substring:", \
"ExampleText",
 CellID->248376533],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"StringCases", "[", 
   RowBox[{"\"\<abcadcacb\>\"", ",", 
    RowBox[{
     RowBox[{"\"\<a\>\"", "~~", "x_", "~~", "\"\<c\>\""}], "->", "x"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20376],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"b\"\>", ",", "\<\"d\"\>"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->495833888]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17331],

Cell["Use string patterns: ", "ExampleText",
 CellID->374228497],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<the cat in the hat\>\"", ",", 
   RowBox[{"\"\<a\>\"", "~~", "__", "~~", "\"\<e\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1826230663],

Cell[BoxData[
 RowBox[{"{", "\<\"at in the\"\>", "}"}]], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->137019013]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<11a22b3\>\"", ",", 
   RowBox[{"DigitCharacter", ".."}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->390705797],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"11\"\>", ",", "\<\"22\"\>", ",", "\<\"3\"\>"}], 
  "}"}]], "Output",
 ImageSize->{76, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->496337162]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<11a22b\>\"", ",", 
   RowBox[{"_", "?", "LetterQ"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->15469716],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->103191927]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1113608023],

Cell["Use a regular expression: ", "ExampleText",
 CellID->1090058956],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<a1b22c333\>\"", ",", 
   RowBox[{"RegularExpression", "[", "\"\<..2\>\"", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1298182474],

Cell[BoxData[
 RowBox[{"{", "\<\"1b2\"\>", "}"}]], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->465320546]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->67055197],

Cell["Use pattern matching for dates:", "ExampleText",
 CellID->1715264951],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{
  "\"\<On 31/12/2003 we left, and on 5/3/2004 we came back\>\"", ",", 
   RowBox[{"DatePattern", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<Day\>\"", ",", "\"\<Month\>\"", ",", "\"\<Year\>\""}], 
     "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->637554129],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"31/12/2003\"\>", ",", "\<\"5/3/2004\"\>"}], "}"}]], "Output",
 ImageSize->{156, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->372759410]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1770421952],

Cell["Mixed regular expressions and string patterns:", "ExampleText",
 CellID->2095818079],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<the cat in the hat\>\"", ",", 
   RowBox[{
    RowBox[{"RegularExpression", "[", "\"\<(?<=the )\>\"", "]"}], "~~", 
    RowBox[{"WordCharacter", ".."}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1387675659],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"cat\"\>", ",", "\<\"hat\"\>"}], "}"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->485749452]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1393009774],

Cell["\<\
Rules to extract values corresponding to matching substrings:\
\>", "ExampleText",
 CellID->448552024],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<item13, task15, item11, var4, item2\>\"", ",", 
   RowBox[{
    RowBox[{"\"\<item\>\"", "~~", 
     RowBox[{"(", 
      RowBox[{"x", ":", 
       RowBox[{"DigitCharacter", ".."}]}], ")"}]}], "\[Rule]", " ", "x"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1146266398],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"13\"\>", ",", "\<\"11\"\>", ",", "\<\"2\"\>"}], 
  "}"}]], "Output",
 ImageSize->{76, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->144427458]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1763751877],

Cell["Include only the two first strings that match:", "ExampleText",
 CellID->1661017198],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<abcddbbbacbbaa\>\"", ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"\"\<a\>\"", "|", "\"\<bb\>\""}], ")"}], ".."}], ",", "2"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1576119433],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a\"\>", ",", "\<\"bb\"\>"}], "}"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->369479979]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->319981946],

Cell["Occurrences in either substring:", "ExampleText",
 CellID->637514334],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<abcdabcdcd\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<abc\>\"", ",", "\"\<cd\>\""}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->72950628],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"abc\"\>", ",", "\<\"abc\"\>", ",", "\<\"cd\"\>"}], 
  "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->117155717]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<abcdabcdcd\>\"", ",", 
   RowBox[{"\"\<abc\>\"", "|", "\"\<cd\>\""}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->84798849],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"abc\"\>", ",", "\<\"abc\"\>", ",", "\<\"cd\"\>"}], 
  "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->76223140]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->91998220],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringCases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringCases"]], "InlineFormula"],
 " automatically threads over lists of strings:"
}], "ExampleText",
 CellID->25857700],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "\"\<ability\>\"", ",", "\"\<argument\>\"", ",", "\"\<listable\>\""}], 
    "}"}], ",", 
   RowBox[{"\"\<a\>\"", " ", "~~", "___", "~~", "\"\<l\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1610019191],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "\<\"abil\"\>", "}"}], ",", 
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", "\<\"abl\"\>", "}"}]}], "}"}]], "Output",
 ImageSize->{132, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7081403]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->561059814],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "IgnoreCase",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->665],

Cell["\<\
Find all substrings \"cat\", including use of uppercase letters:\
\>", "ExampleText",
 CellID->73736195],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<cat Cat hat CAT\>\"", ",", "\"\<cat\>\"", ",", 
   RowBox[{"IgnoreCase", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->401476256],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"cat\"\>", ",", "\<\"Cat\"\>", ",", "\<\"CAT\"\>"}], 
  "}"}]], "Output",
 ImageSize->{104, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->196229249]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Overlaps",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->8216],

Cell["\<\
Find all runs of two or more letters starting with the letter a:\
\>", "ExampleText",
 CellID->175559872],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<ab bac adaf\>\"", ",", 
   RowBox[{"\"\<a\>\"", "~~", 
    RowBox[{"LetterCharacter", ".."}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27785177],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"ab\"\>", ",", "\<\"ac\"\>", ",", "\<\"adaf\"\>"}], 
  "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29252301]
}, Open  ]],

Cell["Allow overlaps between the substrings:", "ExampleText",
 CellID->232282624],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<ab bac adaf\>\"", ",", 
   RowBox[{"\"\<a\>\"", "~~", 
    RowBox[{"LetterCharacter", ".."}]}], ",", 
   RowBox[{"Overlaps", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24074871],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"ab\"\>", ",", "\<\"ac\"\>", ",", "\<\"adaf\"\>", 
   ",", "\<\"af\"\>"}], "}"}]], "Output",
 ImageSize->{122, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->122197327]
}, Open  ]],

Cell["\<\
Allow multiple substrings to start at the same character as well:\
\>", "ExampleText",
 CellID->135218702],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<ab bac adaf\>\"", ",", 
   RowBox[{"\"\<a\>\"", "~~", 
    RowBox[{"LetterCharacter", ".."}]}], ",", 
   RowBox[{"Overlaps", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->151367795],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"ab\"\>", ",", "\<\"ac\"\>", ",", "\<\"adaf\"\>", 
   ",", "\<\"ada\"\>", ",", "\<\"ad\"\>", ",", "\<\"af\"\>"}], 
  "}"}]], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->417458176]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4257],

Cell["Extract phone numbers from a text: ", "ExampleText",
 CellID->2143984798],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "message", " ", "=", " ", 
   "\"\<This is a text with 3 phones numbers: (800)965-3726, (217)398-6500 \
and (217)398-5151.\>\""}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1324386973],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"message", ",", 
   RowBox[{"\"\<(\>\"", "~~", 
    RowBox[{"DigitCharacter", ".."}], "~~", "\"\<)\>\"", "~~", 
    RowBox[{"DigitCharacter", ".."}], "~~", "\"\<-\>\"", "~~", 
    RowBox[{"DigitCharacter", ".."}]}]}], " ", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1963754110],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"(800)965-3726\"\>", ",", "\<\"(217)398-6500\"\>", 
   ",", "\<\"(217)398-5151\"\>"}], "}"}]], "Output",
 ImageSize->{314, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->442683618]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2037187501],

Cell["\<\
Find the sequence of section numbers in the U.S. Constitution:\
\>", "ExampleText",
 CellID->16232],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{
   RowBox[{"Import", "[", "\"\<ExampleData/USConstitution.txt\>\"", "]"}], 
   ",", 
   RowBox[{
    RowBox[{"\"\<Section \>\"", "~~", 
     RowBox[{"x", ":", 
      RowBox[{"DigitCharacter", ".."}]}]}], "\[Rule]", "x"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2082],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"1\"\>", ",", "\<\"2\"\>", ",", "\<\"3\"\>", ",", "\<\"4\"\>", 
   ",", "\<\"5\"\>", ",", "\<\"6\"\>", ",", "\<\"7\"\>", ",", "\<\"8\"\>", 
   ",", "\<\"9\"\>", ",", "\<\"10\"\>", ",", "\<\"1\"\>", ",", "\<\"2\"\>", 
   ",", "\<\"3\"\>", ",", "\<\"4\"\>", ",", "\<\"1\"\>", ",", "\<\"2\"\>", 
   ",", "\<\"3\"\>", ",", "\<\"1\"\>", ",", "\<\"2\"\>", ",", "\<\"3\"\>", 
   ",", "\<\"4\"\>"}], "}"}]], "Output",
 ImageSize->{396, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->118751484]
}, Open  ]],

Cell["Find the numbers of amendments to the Constitution:", "ExampleText",
 CellID->3321],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{
   RowBox[{"Import", "[", "\"\<ExampleData/USConstitution.txt\>\"", "]"}], 
   ",", 
   RowBox[{
    RowBox[{"StartOfLine", "~~", "\"\<Amendment \>\"", "~~", 
     RowBox[{"x", ":", 
      RowBox[{"LetterCharacter", ".."}]}]}], "\[Rule]", "x"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->27827],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"I\"\>", ",", "\<\"II\"\>", ",", "\<\"III\"\>", 
   ",", "\<\"IV\"\>", ",", "\<\"V\"\>", ",", "\<\"VI\"\>", ",", "\<\"VII\"\>",
    ",", "\<\"VIII\"\>", ",", "\<\"IX\"\>", ",", "\<\"X\"\>", 
   ",", "\<\"XI\"\>", ",", "\<\"XII\"\>", ",", "\<\"XIII\"\>", 
   ",", "\<\"XIV\"\>", ",", "\<\"XV\"\>", ",", "\<\"XVI\"\>", 
   ",", "\<\"XVII\"\>", ",", "\<\"XVIII\"\>", ",", "\<\"XIX\"\>", 
   ",", "\<\"XX\"\>", ",", "\<\"XXI\"\>", ",", "\<\"XXII\"\>", 
   ",", "\<\"XXIII\"\>", ",", "\<\"XXIV\"\>", ",", "\<\"XXV\"\>", 
   ",", "\<\"XXVI\"\>", ",", "\<\"XXVII\"\>"}], "}"}]], "Output",
 ImageSize->{457, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->51205865]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1873812819],

Cell["Primes whose digits are all consecutive:", "ExampleText",
 CellID->324365678],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Union", "[", 
  RowBox[{"ToExpression", "[", 
   RowBox[{"StringCases", "[", 
    RowBox[{"\"\<123456789012345678901234567890\>\"", ",", 
     RowBox[{"x__", "/;", 
      RowBox[{"PrimeQ", "[", 
       RowBox[{"ToExpression", "[", "x", "]"}], "]"}]}], ",", 
     RowBox[{"Overlaps", "\[Rule]", "All"}]}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1300454060],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2", ",", "3", ",", "5", ",", "7", ",", "23", ",", "67", ",", "89", ",", 
   "4567", ",", "78901", ",", "678901", ",", "23456789", ",", "45678901", ",",
    "9012345678901", ",", "789012345678901"}], "}"}]], "Output",
 ImageSize->{386, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->88213922]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2091],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringCount",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringCount"]], "InlineFormula"],
 " gives the number of matching substrings:"
}], "ExampleText",
 CellID->920527687],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCount", "[", 
  RowBox[{"\"\<abaababba\>\"", ",", 
   RowBox[{"\"\<a\>\"", "~~", 
    RowBox[{"___", "~~", "\"\<b\>\""}]}], ",", 
   RowBox[{"Overlaps", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->836642421],

Cell[BoxData["12"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->617315079]
}, Open  ]],

Cell["The length of matching substrings:", "ExampleText",
 CellID->1641545086],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", " ", "@", " ", 
  RowBox[{"StringCases", "[", 
   RowBox[{"\"\<abaababba\>\"", ",", 
    RowBox[{"\"\<a\>\"", "~~", "___", "~~", "\"\<b\>\""}], ",", 
    RowBox[{"Overlaps", "\[Rule]", "All"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1873732838],

Cell[BoxData["12"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->305549301]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->337735426],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["StringPosition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringPosition"]], "InlineFormula"],
 " to get the position of matching substrings:"
}], "ExampleText",
 CellID->1903190437],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pos", "=", " ", 
  RowBox[{"StringPosition", "[", 
   RowBox[{"\"\<abcadcacb\>\"", ",", 
    RowBox[{"\"\<a\>\"", "~~", "x_", "~~", "\"\<c\>\""}]}], "]"}]}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->814769903],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "6"}], "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14218096]
}, Open  ]],

Cell["Check:", "ExampleText",
 CellID->1069889193],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"StringTake", "[", 
    RowBox[{"\"\<abcadcacb\>\"", ",", "#"}], "]"}], "&"}], "/@", " ", 
  "pos"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->344665147],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"abc\"\>", ",", "\<\"adc\"\>"}], "}"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->94347533]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"StringCases", "[", 
   RowBox[{"\"\<abcadcacb\>\"", ",", 
    RowBox[{"\"\<a\>\"", "~~", "x_", "~~", "\"\<c\>\""}]}], "]"}]}]], "Input",\

 CellLabel->"In[3]:=",
 CellID->520025761],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"abc\"\>", ",", "\<\"adc\"\>"}], "}"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->726045681]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6573],

Cell[TextData[{
 "Use ",
 Cell[BoxData[":>"], "InlineFormula"],
 " rather than ",
 Cell[BoxData["->"], "InlineFormula"],
 " if the right-hand side of a rule contains string operations:"
}], "ExampleText",
 CellID->39028206],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<cat in the hat\>\"", ",", 
   RowBox[{
    RowBox[{"x", ":", 
     RowBox[{"LetterCharacter", ".."}]}], "\[RuleDelayed]", 
    RowBox[{"StringReverse", "[", "x", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->514709573],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"tac\"\>", ",", "\<\"ni\"\>", ",", "\<\"eht\"\>", 
   ",", "\<\"tah\"\>"}], "}"}]], "Output",
 ImageSize->{129, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->440841337]
}, Open  ]],

Cell[TextData[{
 "Using ",
 Cell[BoxData["->"], "InlineFormula"],
 " in such cases leads to immediate evaluation and possible error messages:"
}], "ExampleText",
 CellID->443900400],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<cat in the hat\>\"", ",", 
   RowBox[{
    RowBox[{"x", ":", 
     RowBox[{"LetterCharacter", ".."}]}], "\[Rule]", 
    RowBox[{"StringReverse", "[", "x", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->140116149],

Cell[BoxData[
 RowBox[{
  RowBox[{"StringReverse", "::", "\<\"string\"\>"}], ":", 
  " ", "\<\"String expected at position \\!\\(1\\) in \
\\!\\(StringReverse[x]\\).\"\>"}]], "Message", "MSG",
 CellID->12307622],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"tac\"\>", ",", "\<\"ni\"\>", ",", "\<\"eht\"\>", 
   ",", "\<\"tah\"\>"}], "}"}]], "Output",
 ImageSize->{129, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->41516355]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32332],

Cell["Find the sequence of words in the U.S. Constitution:", "ExampleText",
 CellID->14612],

Cell[BoxData[
 RowBox[{
  RowBox[{"words", "=", 
   RowBox[{"ToLowerCase", "[", 
    RowBox[{"StringCases", "[", 
     RowBox[{
      RowBox[{"Import", "[", "\"\<ExampleData/USConstitution.txt\>\"", "]"}], 
      ",", 
      RowBox[{"WordCharacter", ".."}]}], "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9701],

Cell["Total number of words:", "ExampleText",
 CellID->8097],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "words", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1362],

Cell[BoxData["7632"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->351036215]
}, Open  ]],

Cell["Number of distinct words:", "ExampleText",
 CellID->21868],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"Union", "[", "words", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->5178],

Cell[BoxData["1188"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->187289926]
}, Open  ]],

Cell["Logarithmic frequency distribution of words:", "ExampleText",
 CellID->13217],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{"Sort", "[", 
   RowBox[{"Length", "/@", 
    RowBox[{"Split", "[", 
     RowBox[{"Sort", "[", "words", "]"}], "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->2331],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWd1vFUUUn97d7YdR4FKKKAr1g1B4UF/VSNvb9lJpK35EUZCQG9BAooXU
+gf4oBKjTzxx2xJuUxsVo0j5EBDE+KIPRHzzFf+R9XzMzs4OM3N3uVVrYnM7
25nzO2fm/OacM7O3E7Xpw2+9W5s+crDWu3OqduzwkYPv9VaPTsFQ0CaEuA2/
JzYI+DuGv+j3dhzDU2+3QhuCqATPEjwD+VyPUhTEyY8p1fvJs8cx3g3PwDJL
8ixLOQ0I/ik58EL0YRvx2lRLWBHY+/hnd9ajHBprsWnXNfLplVvRy71Cm4XV
2HTpu5aHJQyWNnzS2LbCPJVlDIkONZVzzv8wr1q/lMtiltftBecs2+RNvG+F
XdQrFZhn+VkNcui3xmlRHxEfFMCvnAgtzuXWfyhuqA5Hqp/Tv3+Z2cIWstz2
xfZzz3/K3q8xm/eUtY3rp6xPzqerfju4z+Did8/ovTT6/vRFEPQ/d1LUsAkG
dtQlapJQXdDeAkSnpjPfuEk6ddGOTcAdWz9q0m+GX257ATc76mOjcyLxSmMm
MvrtTeR/N76ZvNO6v5uM/uZllttn9cXa/6PFR3GvsdSEVqkeGcKCOkD94coM
ZDUm9iOU3eO7GlI+RnodhhZWFOyi9hbQmCCUmSVmxeW59u5ZlFnWm2TZ5Dvf
oWg8l5XU62z1dvuPNdDMiJWzf+boB9R/c+8XckfKtCMH9p+R8qedWj2AfNZj
86MPrw8y82uIeajhnxy/gaJnVoDf9tET1N890ZBs3GOw8YRTaxUgn/LYnDq2
NMBsdDEb/QkbTy6TLxhzgTP2msX5KcPzyMjMPqcV7KI2+HVye4G5UkZCIzPp
3bFJLplnkD0fO6QNu9TkcSHO5kJo3D0ec2p1AnKLx2aaC/pZj6LHC+zzV9hE
qnrCZ7B/RjzqxOIeuqUiUrURlvPy7obDkn0tX1P/84XfJFcl4uqzT3+W8oc9
WnteXcxojQzNNtdq//WXP6tDs7zgykD90sU/NhdY77cUJKPVOUXcJoXDCDkL
T9xvHuWASX6Sm7MZiWzzUO2MopC1/e/1sSUjztJ+KDbhA0yKhwpYC6QPIlLs
wgeYLWTlzjUp1pnyu7Z2Lss/lNSNLVjCnWJ9/bu+5A3E3Kdz2j5x3d1ojZEl
wqkaCFvwoBMXGJG7wW0xSipdkrEPWLHnpV9uqYhkrJElqEuOWS+QH3oc+HBy
h6ki2XGXqA/vZLxx9EbpQlUGkrudBxXuHEnzcL0TFxpnULdnXuBYqyk9VuT3
ib9DtEhYqh13We4vS/Xvtc3Iukx9qO6VwRk4vARr8OGUXILjXFF9xeB4XVws
968Y7LO+7/sb9yr2vYEn4Njzp1uxEkJ8qlzvlrzonhTgJbUFH2krR96z7nzj
Ju/3/n1f2iPoKvWHBpm7uiPOrsZJ1qf3wTVueyFEhVrzWivuB+oDz5QIdeFD
QdQenVzCCuxBheruArWr7MQFxr1mtcei7kVqEdm+TvjpqQtMrbDPd436XIvw
NPKh3j70DaBeeWnBhwpVjENhsPN/Ldl3tXI7jj0YrszKffehXnxhHlAQIz5U
ePzjG4p/O6uMU7UZNsGHg11XPthxPxKuOpyeq6s8OPaCPz4czPv6a4vVkTk4
KxkXePKMb1xFq0R+Leze3Rz0giVvqXijYl8y/x8kf/W6ZL4rsI00grM21Kw5
bKQ5zDaSU8V1uthvsnafkqz8iaTju07LuwZLb9HoaPUUhhxUGh698/+4eiva
/gIG5wm2\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[4]=",
 CellID->196687635]
}, Open  ]],

Cell["Ten most common words:", "ExampleText",
 CellID->1853],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Take", "[", 
  RowBox[{
   RowBox[{"Sort", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Length", "[", "#", "]"}], ",", 
        RowBox[{"#", "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], "}"}], "&"}], "/@", 
     RowBox[{"Split", "[", 
      RowBox[{"Sort", "[", "words", "]"}], "]"}]}], "]"}], ",", 
   RowBox[{"-", "10"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->2488],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"121", ",", "\<\"president\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"129", ",", "\<\"states\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"145", ",", "\<\"in\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"160", ",", "\<\"or\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"179", ",", "\<\"be\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"202", ",", "\<\"to\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"264", ",", "\<\"and\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"306", ",", "\<\"shall\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"494", ",", "\<\"of\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"726", ",", "\<\"the\"\>"}], "}"}]}], "}"}]], "Output",
 ImageSize->{471, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->509467353]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27405],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cases",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cases"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringPosition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringPosition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringCount",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringCount"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringReplace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringReplace"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringFreeQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringFreeQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringReplaceList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringReplaceList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Characters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Characters"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringExpression"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RegularExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RegularExpression"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->22939]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->16694],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StringPatterns"]], "Tutorials",
 CellID->19446],

Cell[TextData[ButtonBox["Special Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SpecialCharacters-StringsAndCharacters"]], "Tutorials",
 CellID->336637905],

Cell[TextData[ButtonBox["Working with String Patterns",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/WorkingWithStringPatternsOverview"]], "Tutorials",
 CellID->22514736]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->380590608],

Cell[TextData[ButtonBox["Language Overview",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LanguageOverview"]], "MoreAbout",
 CellID->333373540],

Cell[TextData[ButtonBox["Processing Textual Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ProcessingTextualData"]], "MoreAbout",
 CellID->380974353],

Cell[TextData[ButtonBox["String Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringManipulation"]], "MoreAbout",
 CellID->83095053],

Cell[TextData[ButtonBox["String Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringOperations"]], "MoreAbout",
 CellID->114911722],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringPatterns"]], "MoreAbout",
 CellID->6740866]
}, Open  ]],

Cell["New in 5.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"StringCases - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 24, 23.5788962}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "StringCases[\"string\", patt] gives a list of the substrings in \" \
string\" that match the string expression patt. StringCases[\"string\", lhs \
-> rhs] gives a list of the values of rhs corresponding to the substrings \
that match the string expression lhs. StringCases[\"string\", p, n] includes \
only the first n substrings that match. StringCases[\"string\", {p_1, p_2, \
...}] gives substrings that match any of the p_i. StringCases[{s_1, s_2, \
...}, p] gives the list of results for each of the s_i. ", 
    "synonyms" -> {"string cases"}, "title" -> "StringCases", "type" -> 
    "Symbol", "uri" -> "ref/StringCases"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11407, 356, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->89788778]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 45936, 1643}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3638, 79, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4261, 106, 48, 1, 70, "ObjectName",
 CellID->2122],
Cell[4312, 109, 3404, 105, 70, "Usage",
 CellID->15019]
}, Open  ]],
Cell[CellGroupData[{
Cell[7753, 219, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8231, 236, 269, 9, 70, "Notes",
 CellID->23224],
Cell[8503, 247, 758, 26, 70, "Notes",
 CellID->26098],
Cell[9264, 275, 663, 22, 70, "Notes",
 CellID->3921],
Cell[9930, 299, 489, 17, 70, "Notes",
 CellID->19072],
Cell[10422, 318, 514, 15, 70, "Notes",
 CellID->27066],
Cell[10939, 335, 431, 16, 70, "Notes",
 CellID->30121]
}, Closed]],
Cell[CellGroupData[{
Cell[11407, 356, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->89788778],
Cell[CellGroupData[{
Cell[11791, 370, 147, 5, 70, "ExampleSection",
 CellID->22165477],
Cell[11941, 377, 77, 1, 70, "ExampleText",
 CellID->9580],
Cell[CellGroupData[{
Cell[12043, 382, 213, 6, 28, "Input",
 CellID->7096],
Cell[12259, 390, 223, 7, 36, "Output",
 CellID->325756827]
}, Open  ]],
Cell[12497, 400, 121, 3, 70, "ExampleDelimiter",
 CellID->19957],
Cell[12621, 405, 105, 2, 70, "ExampleText",
 CellID->248376533],
Cell[CellGroupData[{
Cell[12751, 411, 246, 8, 70, "Input",
 CellID->20376],
Cell[13000, 421, 219, 7, 36, "Output",
 CellID->495833888]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13268, 434, 216, 7, 70, "ExampleSection",
 CellID->17331],
Cell[13487, 443, 64, 1, 70, "ExampleText",
 CellID->374228497],
Cell[CellGroupData[{
Cell[13576, 448, 209, 5, 70, "Input",
 CellID->1826230663],
Cell[13788, 455, 196, 6, 36, "Output",
 CellID->137019013]
}, Open  ]],
Cell[CellGroupData[{
Cell[14021, 466, 177, 5, 70, "Input",
 CellID->390705797],
Cell[14201, 473, 242, 8, 36, "Output",
 CellID->496337162]
}, Open  ]],
Cell[CellGroupData[{
Cell[14480, 486, 172, 5, 70, "Input",
 CellID->15469716],
Cell[14655, 493, 219, 7, 36, "Output",
 CellID->103191927]
}, Open  ]],
Cell[14889, 503, 126, 3, 70, "ExampleDelimiter",
 CellID->1113608023],
Cell[15018, 508, 70, 1, 70, "ExampleText",
 CellID->1090058956],
Cell[CellGroupData[{
Cell[15113, 513, 202, 5, 70, "Input",
 CellID->1298182474],
Cell[15318, 520, 190, 6, 36, "Output",
 CellID->465320546]
}, Open  ]],
Cell[15523, 529, 124, 3, 70, "ExampleDelimiter",
 CellID->67055197],
Cell[15650, 534, 75, 1, 70, "ExampleText",
 CellID->1715264951],
Cell[CellGroupData[{
Cell[15750, 539, 330, 9, 70, "Input",
 CellID->637554129],
Cell[16083, 550, 236, 7, 36, "Output",
 CellID->372759410]
}, Open  ]],
Cell[16334, 560, 126, 3, 70, "ExampleDelimiter",
 CellID->1770421952],
Cell[16463, 565, 90, 1, 70, "ExampleText",
 CellID->2095818079],
Cell[CellGroupData[{
Cell[16578, 570, 276, 7, 70, "Input",
 CellID->1387675659],
Cell[16857, 579, 223, 7, 36, "Output",
 CellID->485749452]
}, Open  ]],
Cell[17095, 589, 126, 3, 70, "ExampleDelimiter",
 CellID->1393009774],
Cell[17224, 594, 112, 3, 70, "ExampleText",
 CellID->448552024],
Cell[CellGroupData[{
Cell[17361, 601, 338, 10, 70, "Input",
 CellID->1146266398],
Cell[17702, 613, 242, 8, 36, "Output",
 CellID->144427458]
}, Open  ]],
Cell[17959, 624, 126, 3, 70, "ExampleDelimiter",
 CellID->1763751877],
Cell[18088, 629, 90, 1, 70, "ExampleText",
 CellID->1661017198],
Cell[CellGroupData[{
Cell[18203, 634, 253, 8, 70, "Input",
 CellID->1576119433],
Cell[18459, 644, 220, 7, 36, "Output",
 CellID->369479979]
}, Open  ]],
Cell[18694, 654, 125, 3, 70, "ExampleDelimiter",
 CellID->319981946],
Cell[18822, 659, 75, 1, 70, "ExampleText",
 CellID->637514334],
Cell[CellGroupData[{
Cell[18922, 664, 214, 6, 70, "Input",
 CellID->72950628],
Cell[19139, 672, 245, 8, 36, "Output",
 CellID->117155717]
}, Open  ]],
Cell[CellGroupData[{
Cell[19421, 685, 189, 5, 70, "Input",
 CellID->84798849],
Cell[19613, 692, 244, 8, 36, "Output",
 CellID->76223140]
}, Open  ]],
Cell[19872, 703, 124, 3, 70, "ExampleDelimiter",
 CellID->91998220],
Cell[19999, 708, 227, 7, 70, "ExampleText",
 CellID->25857700],
Cell[CellGroupData[{
Cell[20251, 719, 306, 10, 70, "Input",
 CellID->1610019191],
Cell[20560, 731, 300, 10, 36, "Output",
 CellID->7081403]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20909, 747, 222, 7, 70, "ExampleSection",
 CellID->561059814],
Cell[CellGroupData[{
Cell[21156, 758, 225, 7, 70, "ExampleSubsection",
 CellID->665],
Cell[21384, 767, 114, 3, 70, "ExampleText",
 CellID->73736195],
Cell[CellGroupData[{
Cell[21523, 774, 214, 5, 70, "Input",
 CellID->401476256],
Cell[21740, 781, 247, 8, 36, "Output",
 CellID->196229249]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22036, 795, 224, 7, 70, "ExampleSubsection",
 CellID->8216],
Cell[22263, 804, 115, 3, 70, "ExampleText",
 CellID->175559872],
Cell[CellGroupData[{
Cell[22403, 811, 215, 6, 70, "Input",
 CellID->27785177],
Cell[22621, 819, 244, 8, 36, "Output",
 CellID->29252301]
}, Open  ]],
Cell[22880, 830, 81, 1, 70, "ExampleText",
 CellID->232282624],
Cell[CellGroupData[{
Cell[22986, 835, 265, 7, 70, "Input",
 CellID->24074871],
Cell[23254, 844, 266, 8, 36, "Output",
 CellID->122197327]
}, Open  ]],
Cell[23535, 855, 116, 3, 70, "ExampleText",
 CellID->135218702],
Cell[CellGroupData[{
Cell[23676, 862, 265, 7, 70, "Input",
 CellID->151367795],
Cell[23944, 871, 308, 9, 36, "Output",
 CellID->417458176]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[24313, 887, 222, 7, 70, "ExampleSection",
 CellID->4257],
Cell[24538, 896, 79, 1, 70, "ExampleText",
 CellID->2143984798],
Cell[24620, 899, 228, 7, 70, "Input",
 CellID->1324386973],
Cell[CellGroupData[{
Cell[24873, 910, 337, 8, 70, "Input",
 CellID->1963754110],
Cell[25213, 920, 278, 8, 36, "Output",
 CellID->442683618]
}, Open  ]],
Cell[25506, 931, 126, 3, 70, "ExampleDelimiter",
 CellID->2037187501],
Cell[25635, 936, 109, 3, 70, "ExampleText",
 CellID->16232],
Cell[CellGroupData[{
Cell[25769, 943, 336, 11, 70, "Input",
 CellID->2082],
Cell[26108, 956, 583, 12, 36, "Output",
 CellID->118751484]
}, Open  ]],
Cell[26706, 971, 89, 1, 70, "ExampleText",
 CellID->3321],
Cell[CellGroupData[{
Cell[26820, 976, 361, 11, 70, "Input",
 CellID->27827],
Cell[27184, 989, 754, 15, 54, "Output",
 CellID->51205865]
}, Open  ]],
Cell[27953, 1007, 126, 3, 70, "ExampleDelimiter",
 CellID->1873812819],
Cell[28082, 1012, 83, 1, 70, "ExampleText",
 CellID->324365678],
Cell[CellGroupData[{
Cell[28190, 1017, 403, 10, 70, "Input",
 CellID->1300454060],
Cell[28596, 1029, 389, 10, 54, "Output",
 CellID->88213922]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[29034, 1045, 232, 7, 70, "ExampleSection",
 CellID->2091],
Cell[29269, 1054, 224, 7, 70, "ExampleText",
 CellID->920527687],
Cell[CellGroupData[{
Cell[29518, 1065, 264, 7, 70, "Input",
 CellID->836642421],
Cell[29785, 1074, 159, 5, 36, "Output",
 CellID->617315079]
}, Open  ]],
Cell[29959, 1082, 78, 1, 70, "ExampleText",
 CellID->1641545086],
Cell[CellGroupData[{
Cell[30062, 1087, 291, 7, 70, "Input",
 CellID->1873732838],
Cell[30356, 1096, 159, 5, 36, "Output",
 CellID->305549301]
}, Open  ]],
Cell[30530, 1104, 125, 3, 70, "ExampleDelimiter",
 CellID->337735426],
Cell[30658, 1109, 243, 8, 70, "ExampleText",
 CellID->1903190437],
Cell[CellGroupData[{
Cell[30926, 1121, 236, 7, 70, "Input",
 CellID->814769903],
Cell[31165, 1130, 301, 11, 36, "Output",
 CellID->14218096]
}, Open  ]],
Cell[31481, 1144, 50, 1, 70, "ExampleText",
 CellID->1069889193],
Cell[CellGroupData[{
Cell[31556, 1149, 200, 7, 70, "Input",
 CellID->344665147],
Cell[31759, 1158, 222, 7, 36, "Output",
 CellID->94347533]
}, Open  ]],
Cell[CellGroupData[{
Cell[32018, 1170, 221, 7, 70, "Input",
 CellID->520025761],
Cell[32242, 1179, 223, 7, 36, "Output",
 CellID->726045681]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[32514, 1192, 225, 7, 70, "ExampleSection",
 CellID->6573],
Cell[32742, 1201, 223, 7, 70, "ExampleText",
 CellID->39028206],
Cell[CellGroupData[{
Cell[32990, 1212, 291, 8, 70, "Input",
 CellID->514709573],
Cell[33284, 1222, 267, 8, 36, "Output",
 CellID->440841337]
}, Open  ]],
Cell[33566, 1233, 181, 5, 70, "ExampleText",
 CellID->443900400],
Cell[CellGroupData[{
Cell[33772, 1242, 284, 8, 70, "Input",
 CellID->140116149],
Cell[34059, 1252, 211, 5, 70, "Message",
 CellID->12307622],
Cell[34273, 1259, 266, 8, 36, "Output",
 CellID->41516355]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[34588, 1273, 224, 7, 70, "ExampleSection",
 CellID->32332],
Cell[34815, 1282, 91, 1, 70, "ExampleText",
 CellID->14612],
Cell[34909, 1285, 330, 10, 70, "Input",
 CellID->9701],
Cell[35242, 1297, 60, 1, 70, "ExampleText",
 CellID->8097],
Cell[CellGroupData[{
Cell[35327, 1302, 101, 3, 70, "Input",
 CellID->1362],
Cell[35431, 1307, 161, 5, 36, "Output",
 CellID->351036215]
}, Open  ]],
Cell[35607, 1315, 64, 1, 70, "ExampleText",
 CellID->21868],
Cell[CellGroupData[{
Cell[35696, 1320, 133, 4, 70, "Input",
 CellID->5178],
Cell[35832, 1326, 161, 5, 36, "Output",
 CellID->187289926]
}, Open  ]],
Cell[36008, 1334, 83, 1, 70, "ExampleText",
 CellID->13217],
Cell[CellGroupData[{
Cell[36116, 1339, 235, 7, 70, "Input",
 CellID->2331],
Cell[36354, 1348, 2042, 38, 70, "Output",
 Evaluatable->False,
 CellID->196687635]
}, Open  ]],
Cell[38411, 1389, 60, 1, 70, "ExampleText",
 CellID->1853],
Cell[CellGroupData[{
Cell[38496, 1394, 449, 15, 70, "Input",
 CellID->2488],
Cell[38948, 1411, 900, 27, 54, "Output",
 CellID->509467353]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[39909, 1445, 311, 9, 70, "SeeAlsoSection",
 CellID->27405],
Cell[40223, 1456, 2250, 80, 70, "SeeAlso",
 CellID->22939]
}, Open  ]],
Cell[CellGroupData[{
Cell[42510, 1541, 314, 9, 70, "TutorialsSection",
 CellID->16694],
Cell[42827, 1552, 140, 3, 70, "Tutorials",
 CellID->19446],
Cell[42970, 1557, 174, 4, 70, "Tutorials",
 CellID->336637905],
Cell[43147, 1563, 178, 4, 70, "Tutorials",
 CellID->22514736]
}, Open  ]],
Cell[CellGroupData[{
Cell[43362, 1572, 319, 9, 70, "MoreAboutSection",
 CellID->380590608],
Cell[43684, 1583, 145, 3, 70, "MoreAbout",
 CellID->333373540],
Cell[43832, 1588, 156, 3, 70, "MoreAbout",
 CellID->380974353],
Cell[43991, 1593, 148, 3, 70, "MoreAbout",
 CellID->83095053],
Cell[44142, 1598, 145, 3, 70, "MoreAbout",
 CellID->114911722],
Cell[44290, 1603, 139, 3, 70, "MoreAbout",
 CellID->6740866]
}, Open  ]],
Cell[44444, 1609, 29, 0, 70, "History"],
Cell[44476, 1611, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

