(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     47396,       1566]
NotebookOptionsPosition[     40316,       1321]
NotebookOutlinePosition[     41660,       1358]
CellTagsIndexPosition[     41574,       1353]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"String Patterns" :> 
          Documentation`HelpLookup["paclet:tutorial/StringPatterns"], 
          "Working with String Patterns" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/WorkingWithStringPatternsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"String Patterns\"\>", 
       2->"\<\"Working with String Patterns\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"RegularExpression" :> 
          Documentation`HelpLookup["paclet:ref/RegularExpression"], "String" :> 
          Documentation`HelpLookup["paclet:ref/String"], "StringJoin" :> 
          Documentation`HelpLookup["paclet:ref/StringJoin"], "StringReplace" :> 
          Documentation`HelpLookup["paclet:ref/StringReplace"], "StringCases" :> 
          Documentation`HelpLookup["paclet:ref/StringCases"], "Characters" :> 
          Documentation`HelpLookup["paclet:ref/Characters"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"RegularExpression\"\>", 
       2->"\<\"String\"\>", 3->"\<\"StringJoin\"\>", 
       4->"\<\"StringReplace\"\>", 5->"\<\"StringCases\"\>", 
       6->"\<\"Characters\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Core Language" :> 
          Documentation`HelpLookup["paclet:guide/CoreLanguageOverview"], 
          "Patterns" :> Documentation`HelpLookup["paclet:guide/Patterns"], 
          "Processing Textual Data" :> 
          Documentation`HelpLookup["paclet:guide/ProcessingTextualData"], 
          "String Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/StringManipulation"], 
          "String Patterns" :> 
          Documentation`HelpLookup["paclet:guide/StringPatterns"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Core Language\"\>", 
       2->"\<\"Patterns\"\>", 3->"\<\"Processing Textual Data\"\>", 
       4->"\<\"String Manipulation\"\>", 
       5->"\<\"String Patterns\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     "StringExpression ",
     StyleBox["(~~)", "OperatorCharacter"]
    }], "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["s", "TI"], 
        StyleBox["1", "TR"]], "~~", 
       RowBox[{
        SubscriptBox[
         StyleBox["s", "TI"], 
         StyleBox["2", "TR"]], "~~", 
        StyleBox["\[Ellipsis]", "TR"]}]}]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringExpression",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringExpression"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["s", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["s", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a sequence of strings and symbolic string \
objects ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->18355]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"str\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", "~~", 
   RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"str\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", "~~", 
    StyleBox["\[Ellipsis]", "TR"]}]}]], "InlineFormula"],
 " yields an ordinary string obtained by concatenating the characters in the \
",
 Cell[BoxData["\"\<\!\(\*SubscriptBox[
StyleBox[\"str\", \"TI\"], 
StyleBox[\"i\", \"TI\"]]\)\>\""], "InlineFormula"],
 ". "
}], "Notes",
 CellID->13190],

Cell[TextData[{
 "The following objects can appear in ",
 Cell[BoxData[
  ButtonBox["StringExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringExpression"]], "InlineFormula"],
 ": "
}], "Notes",
 CellID->17623],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", Cell[
    "a literal string of characters ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "_", Cell[
    "any single character ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "__", Cell[
    "any substring of one or more characters ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "___", Cell[
    "any substring of zero or more characters ", "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     Cell[BoxData[
      StyleBox[
       RowBox[{
        StyleBox["x", "TI"], "_"}]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox[
       RowBox[{
        StyleBox["x", "TI"], "__"}]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], "___"}]], "InlineFormula"],
     " "
    }], "TableText"], Cell[TextData[{
     "substrings given the name ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     StyleBox["x", "TI"], ":", 
     StyleBox["pattern", "TI"]}], Cell[TextData[{
     "pattern given the name ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     StyleBox["pattern", "TI"], ".."}], Cell[
    "pattern repeated one or more times ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     StyleBox["pattern", "TI"], "..."}], Cell[
    "pattern repeated zero or more times ", "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["patt", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["patt", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["patt", "TI"], 
        StyleBox["1", "TR"]], "|", 
       SubscriptBox[
        StyleBox["patt", "TI"], 
        StyleBox["2", "TR"]], "|", 
       StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"]
    }], "TableText"], Cell[TextData[{
     "a pattern matching at least one of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["patt", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     StyleBox["patt", "TI"], "/;", 
     StyleBox["cond", "TI"]}], Cell[TextData[{
     "a pattern for which ",
     Cell[BoxData[
      StyleBox["cond", "TI"]], "InlineFormula"],
     " evaluates to ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     StyleBox["pattern", "TI"], "?", 
     StyleBox["test", "TI"]}], Cell[TextData[{
     "a pattern for which ",
     Cell[BoxData[
      StyleBox["test", "TI"]], "InlineFormula"],
     " yields ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " for each character "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Whitespace",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Whitespace"], Cell[
    "a sequence of whitespace characters ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["NumberString",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NumberString"], Cell[
    "the characters of a number ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{
     ButtonBox["DatePattern",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DatePattern"], "[", 
     StyleBox["spec", "TI"], "]"}], Cell[
    "the characters of a date", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["charobj", "TI"], Cell[
    "an object representing a character class (see below) ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["RegularExpression",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RegularExpression"], "[", "\"\<\!\(\*
StyleBox[\"regexp\", \"TI\"]\)\>\"", "]"}], Cell[
    "substring matching a regular expression ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"StringExpression", "[", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell[
    "an arbitrary string expression ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, None, 
     None, 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True, True, True, True}}}},
 CellID->31675],

Cell["The following represent classes of characters: ", "Notes",
 CellID->6907],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[TextData[{
     "any of the ",
     Cell[BoxData["\"\<\!\(\*SubscriptBox[
StyleBox[\"c\", \"TI\"], 
StyleBox[\"i\", \"TI\"]]\)\>\""], "InlineFormula"],
     StyleBox[" ", "TR"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["Characters",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Characters"], "[", "\"\<\!\(\*SubscriptBox[
StyleBox[\"c\", \"TI\"], \"1\"]\)\!\(\*SubscriptBox[
StyleBox[\"c\", \"TI\"], \"2\"]\)\!\(\*
StyleBox[\"\[Ellipsis]\", \"TR\"]\)\>\"", "]"}], Cell[TextData[{
     "any of the ",
     Cell[BoxData["\"\<\!\(\*SubscriptBox[
StyleBox[\"c\", \"TI\"], 
StyleBox[\"i\", \"TI\"]]\)\>\""], "InlineFormula"],
     StyleBox[" ", "TR"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["CharacterRange",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CharacterRange"], "[", 
     RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"c\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"c\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\""}], "]"}], Cell[TextData[{
     "any character in the range ",
     Cell[BoxData["\"\<\!\(\*SubscriptBox[
StyleBox[\"c\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\""], "InlineFormula"],
     StyleBox[" to ", "TR"],
     Cell[BoxData["\"\<\!\(\*SubscriptBox[
StyleBox[\"c\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\""], "InlineFormula"],
     " "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["DigitCharacter",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DigitCharacter"], Cell[
    "digit 0\[Dash]9 ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["LetterCharacter",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/LetterCharacter"], Cell[
    "letter ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["WhitespaceCharacter",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WhitespaceCharacter"], Cell[
    "space, newline, tab or other whitespace character ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["WordCharacter",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WordCharacter"], Cell[
    "letter or digit ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["Except",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Except"], "[", 
     StyleBox["p", "TI"], "]"}], Cell[TextData[{
     "any character except ones matching ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"]
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True}}}},
 CellID->9253],

Cell["The following represent positions in strings: ", "Notes",
 CellID->31707],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["StartOfString",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/StartOfString"], Cell[
    "start of the whole string ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["EndOfString",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/EndOfString"], Cell[
    "end of the whole string ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["StartOfLine",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/StartOfLine"], Cell[
    "start of a line ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["EndOfLine",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/EndOfLine"], Cell[
    "end of a line ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["WordBoundary",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WordBoundary"], Cell[
    "boundary between word characters and others ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["Except",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Except"], "[", 
     ButtonBox["WordBoundary",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/WordBoundary"], "]"}], Cell[
    "anywhere except a word boundary ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True, True}}}},
 CellID->25418],

Cell[TextData[{
 "When constructs like ",
 Cell[BoxData["__"], "InlineFormula"],
 " or ",
 Cell[BoxData[".."], "InlineFormula"],
 " are present, there may be several different ways in which a given ",
 Cell[BoxData[
  ButtonBox["StringExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringExpression"]], "InlineFormula"],
 " can match a particular string. "
}], "Notes",
 CellID->18614],

Cell[TextData[{
 "By default, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will use the one that makes pattern elements that appear earlier in the ",
 Cell[BoxData[
  ButtonBox["StringExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringExpression"]], "InlineFormula"],
 " match the longest possible substrings. "
}], "Notes",
 CellID->20222],

Cell["\<\
The following determine which match will be used if there are several \
possibilities: \
\>", "Notes",
 CellID->15217],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["Shortest",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Shortest"], "[", 
     StyleBox["p", "TI"], "]"}], Cell[TextData[{
     "the shortest consistent match for ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["Longest",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Longest"], "[", 
     StyleBox["p", "TI"], "]"}], Cell[TextData[{
     "the longest consistent match for ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     " (default) "
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->20324],

Cell["\<\
In matching ordinary expressions instead of strings, the shortest instead of \
the longest consistent match is used. \
\>", "Notes",
 CellID->16918],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringExpression"]], "InlineFormula"],
 " objects can be used in many string manipulation functions, including ",
 Cell[BoxData[
  ButtonBox["StringReplace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringReplace"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["StringCases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringCases"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["StringSplit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringSplit"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["StringMatchQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringMatchQ"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->28427],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringExpression"]], "InlineFormula"],
 " has attributes ",
 Cell[BoxData[
  ButtonBox["Flat",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Flat"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["OneIdentity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OneIdentity"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->26364]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->556157470],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->125244838],

Cell["\<\
A string expression representing the string \"ab\" followed by any single \
character:\
\>", "ExampleText",
 CellID->734829202],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\"\<ab\>\"", " ", "~~", " ", "_"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->95944117],

Cell[BoxData[
 RowBox[{"\<\"ab\"\>", "~~", "_"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->25973009]
}, Open  ]],

Cell["\<\
This makes a replacement for each occurrence of the string pattern \
\"ab\"~~__:\
\>", "ExampleText",
 CellID->941677946],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<abc abcb abdc\>\"", ",", 
   RowBox[{
    RowBox[{"\"\<ab\>\"", "~~", "_"}], "->", "\"\<X\>\""}]}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->2009033561],

Cell[BoxData["\<\"X Xb Xc\"\>"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->48056580]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->554244521],

Cell["Give all pairs of identical characters in the string:", "ExampleText",
 CellID->348542510],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<abbcbccaabbabccaa\>\"", ",", 
   RowBox[{"x_", "~~", "x_"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1766060201],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"bb\"\>", ",", "\<\"cc\"\>", ",", "\<\"aa\"\>", 
   ",", "\<\"bb\"\>", ",", "\<\"cc\"\>", ",", "\<\"aa\"\>"}], "}"}]], "Output",\

 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12020593]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->204521817],

Cell["A single blank (_) stands for any single character:", "ExampleText",
 CellID->1218086205],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<ab\>\"", ",", "\"\<abc\>\"", ",", "\"\<abcd\>\""}], "}"}], 
   ",", 
   RowBox[{
    RowBox[{"\"\<b\>\"", "~~", "_"}], "->", "\"\<X\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->413240584],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"ab\"\>", ",", "\<\"aX\"\>", ",", "\<\"aXd\"\>"}], 
  "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->155050344]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->450637223],

Cell[TextData[{
 "Double blank (",
 StyleBox["__", "MR"],
 ") stands for any sequence of one or more characters:"
}], "ExampleText",
 CellID->1325821384],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<ab\>\"", ",", "\"\<abc\>\"", ",", "\"\<abcd\>\""}], "}"}], 
   ",", 
   RowBox[{
    RowBox[{"\"\<b\>\"", "~~", "__"}], "->", "\"\<X\>\""}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->789679616],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"ab\"\>", ",", "\<\"aX\"\>", ",", "\<\"aX\"\>"}], 
  "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->332890706]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->353964848],

Cell[TextData[{
 "Triple blank (",
 StyleBox["___", "MR"],
 ") stands for any sequence of zero or more characters:"
}], "ExampleText",
 CellID->1457132328],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<ab\>\"", ",", "\"\<abc\>\"", ",", "\"\<abcd\>\""}], "}"}], 
   ",", 
   RowBox[{
    RowBox[{"\"\<b\>\"", "~~", "___"}], "->", "\"\<X\>\""}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->119526308],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"aX\"\>", ",", "\<\"aX\"\>", ",", "\<\"aX\"\>"}], 
  "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->73156083]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->519636960],

Cell["Find the primes with four identical digits: ", "ExampleText",
 CellID->264433199],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FromDigits", "/@", 
   RowBox[{"Select", "[", 
    RowBox[{
     RowBox[{"IntegerDigits", "/@", 
      RowBox[{"Array", "[", 
       RowBox[{"Prime", ",", "1000", ",", "1000000"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"MatchQ", "[", 
       RowBox[{"#", ",", 
        RowBox[{"{", 
         RowBox[{
         "___", ",", "x_", ",", "___", ",", "x_", ",", "___", ",", "x_", ",", 
          "___", ",", "x_", ",", "___"}], "}"}]}], "]"}], "&"}]}], "]"}]}], "//",
   "Timing"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->161532897],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.14000000000000026`", ",", 
   RowBox[{"{", 
    RowBox[{
    "15488881", ",", "15491117", ",", "15491171", ",", "15491711", ",", 
     "15493333", ",", "15493999", ",", "15496111", ",", "15499111", ",", 
     "15499199", ",", "15499399", ",", "15499499", ",", "15499919", ",", 
     "15499997", ",", "15500557", ",", "15501119", ",", "15501121", ",", 
     "15501151", ",", "15501553", ",", "15501559", ",", "15501911", ",", 
     "15502111"}], "}"}]}], "}"}]], "Output",
 ImageSize->{554, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14245123]
}, Open  ]],

Cell[TextData[{
 "By converting to strings, you can use ",
 Cell[BoxData[
  ButtonBox["StringMatchQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringMatchQ"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->6818901],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FromDigits", "/@", 
   RowBox[{"Select", "[", 
    RowBox[{
     RowBox[{"IntegerDigits", "/@", 
      RowBox[{"Array", "[", 
       RowBox[{"Prime", ",", "1000", ",", "1000000"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"StringMatchQ", "[", 
       RowBox[{
        RowBox[{"FromCharacterCode", "[", 
         RowBox[{"48", "+", "#"}], "]"}], ",", 
        RowBox[{"StringExpression", "[", 
         RowBox[{
         "___", ",", "x_", ",", "___", ",", "x_", ",", "___", ",", "x_", ",", 
          "___", ",", "x_", ",", "___"}], "]"}]}], "]"}], "&"}]}], "]"}]}], "//",
   "Timing"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->310269975],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.030999999999999986`", ",", 
   RowBox[{"{", 
    RowBox[{
    "15488881", ",", "15491117", ",", "15491171", ",", "15491711", ",", 
     "15493333", ",", "15493999", ",", "15496111", ",", "15499111", ",", 
     "15499199", ",", "15499399", ",", "15499499", ",", "15499919", ",", 
     "15499997", ",", "15500557", ",", "15501119", ",", "15501121", ",", 
     "15501151", ",", "15501553", ",", "15501559", ",", "15501911", ",", 
     "15502111"}], "}"}]}], "}"}]], "Output",
 ImageSize->{561, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->184122181]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->299195734],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringExpression"]], "InlineFormula"],
 " objects can be used in many string manipulation functions:"
}], "ExampleText",
 CellID->929200731],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringMatchQ", "[", 
  RowBox[{"\"\<apppbb\>\"", ",", 
   RowBox[{"\"\<a\>\"", "~~", "___", "~~", "\"\<b\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->188037090],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->109942281]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringFreeQ", "[", 
  RowBox[{"\"\<bcde\>\"", ",", 
   RowBox[{"\"\<c\>\"", "~~", "__", "~~", "\"\<t\>\""}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->234913564],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->114468614]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCount", "[", 
  RowBox[{"\"\<abcadcadcbaac\>\"", ",", 
   RowBox[{"\"\<a\>\"", "~~", "_", "~~", "\"\<c\>\""}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->544071479],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->348601844]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<a10b6a77a3a#\>\"", ",", 
   RowBox[{"\"\<a\>\"", "~~", 
    RowBox[{"DigitCharacter", ".."}]}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->575604933],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a10\"\>", ",", "\<\"a77\"\>", ",", "\<\"a3\"\>"}], 
  "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->71630714]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<aa abcd\>\"", ",", 
   RowBox[{
    RowBox[{"WordBoundary", "~~", "\"\<aa\>\"", "~~", "WordBoundary"}], "->", 
    "\"\<XX\>\""}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->979764048],

Cell[BoxData["\<\"XX abcd\"\>"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->49591474]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplaceList", "[", 
  RowBox[{"\"\<abxxabxxabxxabxxab\>\"", ",", 
   RowBox[{
    RowBox[{"_", "~~", "\"\<ab\>\"", "~~", "_"}], "->", "\"\<X\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->265572534],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"abxXxabxxabxxab\"\>", ",", "\<\"abxxabxXxabxxab\"\>", 
   ",", "\<\"abxxabxxabxXxab\"\>"}], "}"}]], "Output",
 ImageSize->{356, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->588180656]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringPosition", "[", 
  RowBox[{"\"\<abxxabxxabxxabxxab\>\"", ",", 
   RowBox[{"_", "~~", "\"\<ab\>\"", "~~", "_"}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->1570058364],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "15"}], "}"}]}], "}"}]], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->264932062]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplacePart", "[", 
  RowBox[{"\"\<abxxabxxabxxabxxab\>\"", ",", "\"\<X\>\"", ",", "%"}], 
  "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->697581032],

Cell[BoxData["\<\"abxXXXxab\"\>"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->160465900]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->16079],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["RegularExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RegularExpression"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["String",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/String"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringJoin",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringJoin"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringReplace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringReplace"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringCases",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringCases"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Characters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Characters"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30547]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->6378],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StringPatterns"]], "Tutorials",
 CellID->13134],

Cell[TextData[ButtonBox["Working with String Patterns",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/WorkingWithStringPatternsOverview"]], "Tutorials",
 CellID->22514736]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->1037253],

Cell[TextData[ButtonBox["Core Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CoreLanguageOverview"]], "MoreAbout",
 CellID->956421689],

Cell[TextData[ButtonBox["Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Patterns"]], "MoreAbout",
 CellID->518121155],

Cell[TextData[ButtonBox["Processing Textual Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ProcessingTextualData"]], "MoreAbout",
 CellID->232060626],

Cell[TextData[ButtonBox["String Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringManipulation"]], "MoreAbout",
 CellID->467014794],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringPatterns"]], "MoreAbout",
 CellID->230462414]
}, Open  ]],

Cell["New in 5.1  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"StringExpression (~~) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 24, 24.7976774}", "context" -> "System`", 
    "keywords" -> {"patterns for string", "string pattern"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "s_1 ~~ s_2 ~~ ... or StringExpression[s_1, s_2, ...] represents a \
sequence of strings and symbolic string objects s_i. ", 
    "synonyms" -> {"string expression", "~~"}, "title" -> "StringExpression", 
    "type" -> "Symbol", "uri" -> "ref/StringExpression"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[24180, 691, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->556157470]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 41430, 1346}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2994, 65, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3617, 92, 4268, 86, 70, "ObjectNameGrid"],
Cell[7888, 180, 1161, 39, 70, "Usage",
 CellID->18355]
}, Open  ]],
Cell[CellGroupData[{
Cell[9086, 224, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[9564, 241, 531, 16, 70, "Notes",
 CellID->13190],
Cell[10098, 259, 226, 8, 70, "Notes",
 CellID->17623],
Cell[10327, 269, 5285, 151, 70, "2ColumnTableMod",
 CellID->31675],
Cell[15615, 422, 79, 1, 70, "Notes",
 CellID->6907],
Cell[15697, 425, 3291, 92, 70, "2ColumnTableMod",
 CellID->9253],
Cell[18991, 519, 79, 1, 70, "Notes",
 CellID->31707],
Cell[19073, 522, 1692, 44, 70, "2ColumnTableMod",
 CellID->25418],
Cell[20768, 568, 400, 12, 70, "Notes",
 CellID->18614],
Cell[21171, 582, 367, 11, 70, "Notes",
 CellID->20222],
Cell[21541, 595, 128, 4, 70, "Notes",
 CellID->15217],
Cell[21672, 601, 1062, 31, 70, "2ColumnTableMod",
 CellID->20324],
Cell[22737, 634, 158, 4, 70, "Notes",
 CellID->16918],
Cell[22898, 640, 790, 27, 70, "Notes",
 CellID->28427],
Cell[23691, 669, 452, 17, 70, "Notes",
 CellID->26364]
}, Closed]],
Cell[CellGroupData[{
Cell[24180, 691, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->556157470],
Cell[CellGroupData[{
Cell[24565, 705, 148, 5, 70, "ExampleSection",
 CellID->125244838],
Cell[24716, 712, 137, 4, 70, "ExampleText",
 CellID->734829202],
Cell[CellGroupData[{
Cell[24878, 720, 111, 3, 28, "Input",
 CellID->95944117],
Cell[24992, 725, 189, 6, 36, "Output",
 CellID->25973009]
}, Open  ]],
Cell[25196, 734, 131, 4, 70, "ExampleText",
 CellID->941677946],
Cell[CellGroupData[{
Cell[25352, 742, 223, 7, 28, "Input",
 CellID->2009033561],
Cell[25578, 751, 171, 5, 36, "Output",
 CellID->48056580]
}, Open  ]],
Cell[25764, 759, 125, 3, 70, "ExampleDelimiter",
 CellID->554244521],
Cell[25892, 764, 96, 1, 70, "ExampleText",
 CellID->348542510],
Cell[CellGroupData[{
Cell[26013, 769, 182, 5, 70, "Input",
 CellID->1766060201],
Cell[26198, 776, 303, 9, 36, "Output",
 CellID->12020593]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[26550, 791, 220, 7, 70, "ExampleSection",
 CellID->204521817],
Cell[26773, 800, 95, 1, 70, "ExampleText",
 CellID->1218086205],
Cell[CellGroupData[{
Cell[26893, 805, 292, 9, 70, "Input",
 CellID->413240584],
Cell[27188, 816, 244, 8, 36, "Output",
 CellID->155050344]
}, Open  ]],
Cell[27447, 827, 125, 3, 70, "ExampleDelimiter",
 CellID->450637223],
Cell[27575, 832, 153, 5, 70, "ExampleText",
 CellID->1325821384],
Cell[CellGroupData[{
Cell[27753, 841, 295, 10, 70, "Input",
 CellID->789679616],
Cell[28051, 853, 243, 8, 36, "Output",
 CellID->332890706]
}, Open  ]],
Cell[28309, 864, 125, 3, 70, "ExampleDelimiter",
 CellID->353964848],
Cell[28437, 869, 155, 5, 70, "ExampleText",
 CellID->1457132328],
Cell[CellGroupData[{
Cell[28617, 878, 296, 10, 70, "Input",
 CellID->119526308],
Cell[28916, 890, 242, 8, 36, "Output",
 CellID->73156083]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[29207, 904, 227, 7, 70, "ExampleSection",
 CellID->519636960],
Cell[29437, 913, 87, 1, 70, "ExampleText",
 CellID->264433199],
Cell[CellGroupData[{
Cell[29549, 918, 569, 17, 70, "Input",
 CellID->161532897],
Cell[30121, 937, 643, 15, 71, "Output",
 CellID->14245123]
}, Open  ]],
Cell[30779, 955, 227, 8, 70, "ExampleText",
 CellID->6818901],
Cell[CellGroupData[{
Cell[31031, 967, 676, 19, 70, "Input",
 CellID->310269975],
Cell[31710, 988, 645, 15, 71, "Output",
 CellID->184122181]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[32404, 1009, 237, 7, 70, "ExampleSection",
 CellID->299195734],
Cell[32644, 1018, 252, 7, 70, "ExampleText",
 CellID->929200731],
Cell[CellGroupData[{
Cell[32921, 1029, 198, 5, 70, "Input",
 CellID->188037090],
Cell[33122, 1036, 161, 5, 36, "Output",
 CellID->109942281]
}, Open  ]],
Cell[CellGroupData[{
Cell[33320, 1046, 194, 5, 70, "Input",
 CellID->234913564],
Cell[33517, 1053, 161, 5, 36, "Output",
 CellID->114468614]
}, Open  ]],
Cell[CellGroupData[{
Cell[33715, 1063, 202, 5, 70, "Input",
 CellID->544071479],
Cell[33920, 1070, 158, 5, 36, "Output",
 CellID->348601844]
}, Open  ]],
Cell[CellGroupData[{
Cell[34115, 1080, 216, 6, 70, "Input",
 CellID->575604933],
Cell[34334, 1088, 244, 8, 36, "Output",
 CellID->71630714]
}, Open  ]],
Cell[CellGroupData[{
Cell[34615, 1101, 253, 7, 70, "Input",
 CellID->979764048],
Cell[34871, 1110, 171, 5, 36, "Output",
 CellID->49591474]
}, Open  ]],
Cell[CellGroupData[{
Cell[35079, 1120, 243, 7, 70, "Input",
 CellID->265572534],
Cell[35325, 1129, 284, 8, 36, "Output",
 CellID->588180656]
}, Open  ]],
Cell[CellGroupData[{
Cell[35646, 1142, 204, 5, 70, "Input",
 CellID->1570058364],
Cell[35853, 1149, 364, 13, 36, "Output",
 CellID->264932062]
}, Open  ]],
Cell[CellGroupData[{
Cell[36254, 1167, 182, 5, 70, "Input",
 CellID->697581032],
Cell[36439, 1174, 174, 5, 36, "Output",
 CellID->160465900]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[36674, 1186, 311, 9, 70, "SeeAlsoSection",
 CellID->16079],
Cell[36988, 1197, 1469, 53, 70, "SeeAlso",
 CellID->30547]
}, Open  ]],
Cell[CellGroupData[{
Cell[38494, 1255, 313, 9, 70, "TutorialsSection",
 CellID->6378],
Cell[38810, 1266, 140, 3, 70, "Tutorials",
 CellID->13134],
Cell[38953, 1271, 178, 4, 70, "Tutorials",
 CellID->22514736]
}, Open  ]],
Cell[CellGroupData[{
Cell[39168, 1280, 317, 9, 70, "MoreAboutSection",
 CellID->1037253],
Cell[39488, 1291, 145, 3, 70, "MoreAbout",
 CellID->956421689],
Cell[39636, 1296, 128, 3, 70, "MoreAbout",
 CellID->518121155],
Cell[39767, 1301, 156, 3, 70, "MoreAbout",
 CellID->232060626],
Cell[39926, 1306, 149, 3, 70, "MoreAbout",
 CellID->467014794],
Cell[40078, 1311, 141, 3, 70, "MoreAbout",
 CellID->230462414]
}, Open  ]],
Cell[40234, 1317, 52, 0, 70, "History"],
Cell[40289, 1319, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

