(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14532,        520]
NotebookOptionsPosition[     10987,        402]
NotebookOutlinePosition[     12394,        441]
CellTagsIndexPosition[     12309,        436]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"String\[Hyphen]Oriented Output Formats" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StringOrientedOutputFormats"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"String\[Hyphen]Oriented Output Formats\"\>"}, "\<\"tutorials\"\
\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Row" :> Documentation`HelpLookup["paclet:ref/Row"], 
          "StringJoin" :> Documentation`HelpLookup["paclet:ref/StringJoin"], 
          "ToString" :> Documentation`HelpLookup["paclet:ref/ToString"], 
          "Message" :> Documentation`HelpLookup["paclet:ref/Message"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Row\"\>", 
       2->"\<\"StringJoin\"\>", 3->"\<\"ToString\"\>", 
       4->"\<\"Message\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Textual Elements in Notebooks" :> 
          Documentation`HelpLookup[
           "paclet:guide/TextualElementsInNotebooks"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Textual Elements in Notebooks\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["StringForm", "ObjectName",
 CellID->1944],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringForm",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringForm"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"controlstring\", \"TI\"]\)\>\"", ",", 
        SubscriptBox[
         StyleBox["expr", "TI"], 
         StyleBox["1", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]prints as the text of the ",
     Cell[BoxData[
      StyleBox["controlstring", "TI"]], "InlineFormula"],
     ", with the printed forms of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " embedded. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->21031]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   RowBox[{"`", 
    StyleBox["i", "TI"], "`"}]]], "InlineFormula"],
 " in the control string indicates a point at which to print ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->26982],

Cell[TextData[{
 Cell[BoxData["``"], "InlineFormula"],
 " includes the next ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " not yet printed. "
}], "Notes",
 CellID->14998],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"`", ".", "`"}]], "InlineFormula"],
 " prints a raw ",
 Cell[BoxData["`"], "InlineFormula"],
 " in the output string. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->978959184]
}], "Notes",
 CellID->20267],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringForm"]], "InlineFormula"],
 " acts as a \[OpenCurlyDoubleQuote]wrapper\[CloseCurlyDoubleQuote], which \
affects printing, but not evaluation. "
}], "Notes",
 CellID->21038],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["StringForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringForm"]], "InlineFormula"],
 " to set up \[OpenCurlyDoubleQuote]formatted output\[CloseCurlyDoubleQuote]. \
"
}], "Notes",
 CellID->15183],

Cell[TextData[{
 "Messages given as values for objects of the form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["s", "TI"], "::", 
   StyleBox["t", "TI"]}]], "InlineFormula"],
 " are used as control strings for ",
 Cell[BoxData[
  ButtonBox["StringForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringForm"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->19490]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->19809055],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->89831487],

Cell["Insert a single value into a string:", "ExampleText",
 CellID->903363],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringForm", "[", 
  RowBox[{"\"\<The value of x is ``.\>\"", ",", "5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27081346],

Cell[BoxData[
 InterpretationBox["\<\"The value of x is \\!\\(5\\).\"\>",
  StringForm["The value of x is ``.", 5],
  Editable->False]], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->303797776]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->231843122],

Cell["Insert a sequence of values into a string:", "ExampleText",
 CellID->549321966],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringForm", "[", 
  RowBox[{"\"\<The values are x=`` and y=``.\>\"", ",", "5", ",", "10"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->349016665],

Cell[BoxData[
 InterpretationBox["\<\"The values are x=\\!\\(5\\) and y=\\!\\(10\\).\"\>",
  StringForm["The values are x=`` and y=``.", 5, 10],
  Editable->False]], "Output",
 ImageSize->{200, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22062893]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->487290148],

Cell["Insert indexed values:", "ExampleText",
 CellID->26971401],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringForm", "[", 
  RowBox[{"\"\<The values are x=`2` and y=`1`.\>\"", ",", "10", ",", "5"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->486853411],

Cell[BoxData[
 InterpretationBox["\<\"The values are x=\\!\\(5\\) and y=\\!\\(10\\).\"\>",
  StringForm["The values are x=`2` and y=`1`.", 10, 5],
  Editable->False]], "Output",
 ImageSize->{200, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->146875069]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3141],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Row",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Row"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringJoin",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringJoin"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToString"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Message",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Message"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->25081]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->3321],

Cell[TextData[ButtonBox["String\[Hyphen]Oriented Output Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StringOrientedOutputFormats"]], "Tutorials",
 CellID->10419]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->117848522],

Cell[TextData[ButtonBox["Textual Elements in Notebooks",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TextualElementsInNotebooks"]], "MoreAbout",
 CellID->97791275]
}, Open  ]],

Cell["New in 1  |  Last modified in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"StringForm - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 24, 30.3134436}", "context" -> "System`", 
    "keywords" -> {
     "embedding in strings", "format statement", "splicing", 
      "string formatting", "string insertion", "string templates"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "StringForm[\"controlstring\", expr_1, ...] prints as the text of the \
controlstring, with the printed forms of the expr_i embedded. ", 
    "synonyms" -> {"string form"}, "title" -> "StringForm", "type" -> 
    "Symbol", "uri" -> "ref/StringForm"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5996, 208, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->19809055]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12167, 429}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2106, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2729, 79, 47, 1, 70, "ObjectName",
 CellID->1944],
Cell[2779, 82, 912, 28, 70, "Usage",
 CellID->21031]
}, Open  ]],
Cell[CellGroupData[{
Cell[3728, 115, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4206, 132, 313, 12, 70, "Notes",
 CellID->26982],
Cell[4522, 146, 232, 9, 70, "Notes",
 CellID->14998],
Cell[4757, 157, 276, 10, 70, "Notes",
 CellID->20267],
Cell[5036, 169, 284, 8, 70, "Notes",
 CellID->21038],
Cell[5323, 179, 266, 9, 70, "Notes",
 CellID->15183],
Cell[5592, 190, 367, 13, 70, "Notes",
 CellID->19490]
}, Closed]],
Cell[CellGroupData[{
Cell[5996, 208, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->19809055],
Cell[CellGroupData[{
Cell[6380, 222, 147, 5, 70, "ExampleSection",
 CellID->89831487],
Cell[6530, 229, 76, 1, 70, "ExampleText",
 CellID->903363],
Cell[CellGroupData[{
Cell[6631, 234, 156, 4, 28, "Input",
 CellID->27081346],
Cell[6790, 240, 277, 8, 36, "Output",
 CellID->303797776]
}, Open  ]],
Cell[7082, 251, 125, 3, 70, "ExampleDelimiter",
 CellID->231843122],
Cell[7210, 256, 85, 1, 70, "ExampleText",
 CellID->549321966],
Cell[CellGroupData[{
Cell[7320, 261, 179, 5, 70, "Input",
 CellID->349016665],
Cell[7502, 268, 305, 8, 36, "Output",
 CellID->22062893]
}, Open  ]],
Cell[7822, 279, 125, 3, 70, "ExampleDelimiter",
 CellID->487290148],
Cell[7950, 284, 64, 1, 70, "ExampleText",
 CellID->26971401],
Cell[CellGroupData[{
Cell[8039, 289, 181, 5, 70, "Input",
 CellID->486853411],
Cell[8223, 296, 308, 8, 36, "Output",
 CellID->146875069]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8592, 311, 310, 9, 70, "SeeAlsoSection",
 CellID->3141],
Cell[8905, 322, 933, 35, 70, "SeeAlso",
 CellID->25081]
}, Open  ]],
Cell[CellGroupData[{
Cell[9875, 362, 313, 9, 70, "TutorialsSection",
 CellID->3321],
Cell[10191, 373, 176, 3, 70, "Tutorials",
 CellID->10419]
}, Open  ]],
Cell[CellGroupData[{
Cell[10404, 381, 319, 9, 70, "MoreAboutSection",
 CellID->117848522],
Cell[10726, 392, 166, 3, 70, "MoreAbout",
 CellID->97791275]
}, Open  ]],
Cell[10907, 398, 50, 0, 70, "History"],
Cell[10960, 400, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

