(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     34083,       1248]
NotebookOptionsPosition[     26278,        980]
NotebookOutlinePosition[     27805,       1019]
CellTagsIndexPosition[     27719,       1014]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Operations on Strings" :> 
          Documentation`HelpLookup["paclet:tutorial/OperationsOnStrings"], 
          "String Patterns" :> 
          Documentation`HelpLookup["paclet:tutorial/StringPatterns"], 
          "Working with String Patterns" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/WorkingWithStringPatternsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Operations on Strings\"\>", 
       2->"\<\"String Patterns\"\>", 
       3->"\<\"Working with String Patterns\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"StringCases" :> 
          Documentation`HelpLookup["paclet:ref/StringCases"], "StringMatchQ" :> 
          Documentation`HelpLookup["paclet:ref/StringMatchQ"], "FreeQ" :> 
          Documentation`HelpLookup["paclet:ref/FreeQ"], "StringExpression" :> 
          Documentation`HelpLookup["paclet:ref/StringExpression"], 
          "RegularExpression" :> 
          Documentation`HelpLookup["paclet:ref/RegularExpression"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"StringCases\"\>", 
       2->"\<\"StringMatchQ\"\>", 3->"\<\"FreeQ\"\>", 
       4->"\<\"StringExpression\"\>", 
       5->"\<\"RegularExpression\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{
         "String Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/StringManipulation"], 
          "String Operations" :> 
          Documentation`HelpLookup["paclet:guide/StringOperations"], 
          "String Patterns" :> 
          Documentation`HelpLookup["paclet:guide/StringPatterns"], 
          "Testing Expressions" :> 
          Documentation`HelpLookup["paclet:guide/TestingExpressions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"String Manipulation\"\>", 
       2->"\<\"String Operations\"\>", 3->"\<\"String Patterns\"\>", 
       4->"\<\"Testing Expressions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["StringFreeQ", "ObjectName",
 CellID->22997],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringFreeQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringFreeQ"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", 
        StyleBox["patt", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]yields ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if no substring in ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\""], "InlineFormula"],
     " matches the string expression ",
     Cell[BoxData[
      StyleBox["patt", "TI"]], "InlineFormula"],
     ", and yields ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringFreeQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringFreeQ"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["patt", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["patt", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]yields ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if no substring matches any of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["patt", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringFreeQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringFreeQ"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["s", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["s", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["p", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the list of results for each of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->342]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The string expression ",
 Cell[BoxData[
  StyleBox["patt", "TI"]], "InlineFormula"],
 " can contain any of the objects specified in the notes for ",
 Cell[BoxData[
  ButtonBox["StringExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringExpression"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->564],

Cell[TextData[{
 "Setting the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["IgnoreCase",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IgnoreCase"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " makes ",
 Cell[BoxData[
  ButtonBox["StringFreeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringFreeQ"]], "InlineFormula"],
 " treat lowercase and uppercase letters as equivalent. "
}], "Notes",
 CellID->29930]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->12581644],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->7706135],

Cell["\<\
Test whether a string pattern contains a substring matching the pattern:\
\>", "ExampleText",
 CellID->106767873],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringFreeQ", "[", 
  RowBox[{"\"\<bcde\>\"", ",", 
   RowBox[{"\"\<c\>\"", "~~", "__", "~~", "\"\<t\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->116578822],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->584283618]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->84325201],

Cell["Check that a string is free of \"a\":", "ExampleText",
 CellID->669591414],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringFreeQ", "[", 
  RowBox[{"\"\<abcd\>\"", ",", "\"\<a\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->64977182],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->49086226]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->650790119],

Cell["Use string patterns: ", "ExampleText",
 CellID->27548012],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringFreeQ", "[", 
  RowBox[{"\"\<abcade\>\"", ",", 
   RowBox[{"x_", "~~", "x_"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->49521929],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->39246743]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringFreeQ", "[", 
  RowBox[{"\"\<a1 and a2\>\"", ",", 
   RowBox[{"DigitCharacter", ".."}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->59481413],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->374766656]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->362905145],

Cell["Use a regular expression: ", "ExampleText",
 CellID->1538411368],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringFreeQ", "[", 
  RowBox[{"\"\<abcde\>\"", ",", 
   RowBox[{"RegularExpression", "[", "\"\<b.*d\>\"", "]"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->390912855],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1822468]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->78178072],

Cell["Pattern matching for dates:", "ExampleText",
 CellID->1902099472],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringFreeQ", "[", 
  RowBox[{"\"\<31/12/2003\>\"", ",", 
   RowBox[{"DatePattern", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<Day\>\"", ",", "\"\<Month\>\"", ",", "\"\<Year\>\""}], 
     "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->251565656],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->534185506]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14431676],

Cell["Mixed regular expressions and string patterns:", "ExampleText",
 CellID->18071924],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringFreeQ", "[", 
  RowBox[{"\"\<bac 123\>\"", ",", 
   RowBox[{
    RowBox[{"RegularExpression", "[", "\"\<a.*\>\"", "]"}], "~~", 
    RowBox[{"DigitCharacter", ".."}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->44076838],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->72951355]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->183619726],

Cell["Occurrences of either pattern:", "ExampleText",
 CellID->666879779],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringFreeQ", "[", 
  RowBox[{"\"\<abcdabcdcd\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<abc\>\"", ",", " ", "\"\<cd\>\""}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->139838655],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->167792866]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringFreeQ", "[", 
  RowBox[{"\"\<abcdabcdcd\>\"", ",", 
   RowBox[{"\"\<abc\>\"", "|", "\"\<cd\>\""}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->724952594],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->429389704]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->367354650],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringFreeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringFreeQ"]], "InlineFormula"],
 " automatically threads over lists of strings:"
}], "ExampleText",
 CellID->20655349],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringFreeQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "\"\<ability\>\"", ",", "\"\<listable\>\"", ",", "\"\<argument\>\""}], 
    "}"}], ",", 
   RowBox[{"\"\<a\>\"", " ", "~~", "__", "~~", "\"\<t\>\"", "~~", "___"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->366693576],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"False", ",", "True", ",", "False"}], "}"}]], "Output",
 ImageSize->{139, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->299171218]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->550506631],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "IgnoreCase",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->334822842],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["IgnoreCase",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IgnoreCase"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " to check for the presence of substrings regardless of case:"
}], "ExampleText",
 CellID->73736195],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringFreeQ", "[", 
  RowBox[{"\"\<BACCD\>\"", ",", "\"\<ac\>\"", ",", 
   RowBox[{"IgnoreCase", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->401476256],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->496517558]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->297409720],

Cell["\<\
Pick all the lines that contain a substring that matches the pattern:\
\>", "ExampleText",
 CellID->94161477],

Cell[BoxData[
 RowBox[{
  RowBox[{"grep", "[", 
   RowBox[{"file_", ",", "patt_"}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"data", "=", 
      RowBox[{"Import", "[", 
       RowBox[{"file", ",", "\"\<Lines\>\""}], "]"}]}], "}"}], ",", 
    RowBox[{"Pick", "[", 
     RowBox[{
      RowBox[{"Transpose", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Range", "[", 
          RowBox[{"Length", "[", "data", "]"}], "]"}], ",", "data"}], "}"}], 
       "]"}], ",", 
      RowBox[{"StringFreeQ", "[", 
       RowBox[{"data", ",", " ", "patt"}], "]"}], ",", "False"}], "]"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1049168330],

Cell["\<\
Line numbers with corresponding texts that contain \"noon\" or \"day of\":\
\>", "ExampleText",
 CellID->383896793],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"grep", "[", 
   RowBox[{"\"\<ExampleData/USConstitution.txt\>\"", ",", " ", 
    RowBox[{"{", 
     RowBox[{"\"\<noon\>\"", " ", ",", "\"\<day of\>\""}], "}"}]}], "]"}], "//",
   "TableForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->628476173],

Cell[BoxData[
 TagBox[GridBox[{
    {"615", "\<\"shall devolve upon them, before the fourth day of March next \
following, then\"\>"},
    {"727", "\<\"1. The terms of the President and Vice President shall end \
at noon on the 20th\"\>"},
    {"728", "\<\"day of January, and the terms of Senators and \
Representatives at noon on the 3d\"\>"},
    {"729", "\<\"day of January, of the years in which such terms would have \
ended if this\"\>"},
    {"734", "\<\"shall begin at noon on the 3d day of January, unless they \
shall by law appoint\"\>"},
    {"754", "\<\"5. Sections 1 and 2 shall take effect on the 15th day of \
October following the\"\>"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.7]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{586, 87},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TableForm=",
 CellID->84508823]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->667951682],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringMatchQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringMatchQ"]], "InlineFormula"],
 " checks whether a whole string matches a pattern:"
}], "ExampleText",
 CellID->1592501233],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringMatchQ", "[", 
  RowBox[{"\"\<commit\>\"", ",", " ", 
   RowBox[{"\"\<om\>\"", "~~", "__"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1079530470],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->283141067]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringFreeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringFreeQ"]], "InlineFormula"],
 " checks whether a substring matches a pattern:"
}], "ExampleText",
 CellID->551801680],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringFreeQ", "[", 
  RowBox[{"\"\<commit\>\"", ",", " ", 
   RowBox[{"\"\<om\>\"", "~~", "__"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1296448014],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->468112771]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->82563067],

Cell[TextData[{
 "Get the starting and ending positions where a substring occurs by using ",
 Cell[BoxData[
  ButtonBox["StringPosition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringPosition"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->482849400],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringFreeQ", "[", 
  RowBox[{"\"\<agaatcgagttgacacgaccgaaaacgacc\>\"", ",", 
   RowBox[{"x_", "~~", "x_"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->703474729],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->305811205]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringPosition", "[", 
  RowBox[{"\"\<agaatcgagttgacacgaccgaaaacgacc\>\"", ",", 
   RowBox[{"x_", "~~", "x_"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1560366778],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"19", ",", "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"22", ",", "23"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"23", ",", "24"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"24", ",", "25"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"29", ",", "30"}], "}"}]}], "}"}]], "Output",
 ImageSize->{444, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->126108139]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->50707733],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["StringCases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringCases"]], "InlineFormula"],
 " to extract substrings matching a given pattern:"
}], "ExampleText",
 CellID->1595594583],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"StringFreeQ", "[", 
   RowBox[{"\"\<abcadcacb\>\"", ",", 
    RowBox[{"\"\<a\>\"", "~~", "x_", "~~", "\"\<c\>\""}]}], "]"}]}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->474674813],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->469833903]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"StringCases", "[", 
   RowBox[{"\"\<abcadcacb\>\"", ",", 
    RowBox[{"\"\<a\>\"", "~~", "x_", "~~", "\"\<c\>\""}]}], "]"}]}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->1529856392],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"abc\"\>", ",", "\<\"adc\"\>"}], "}"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->264527005]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1584],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringCases",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringCases"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringMatchQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringMatchQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FreeQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FreeQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringExpression"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RegularExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RegularExpression"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5842]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27273],

Cell[TextData[ButtonBox["Operations on Strings",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OperationsOnStrings"]], "Tutorials",
 CellID->22362],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StringPatterns"]], "Tutorials",
 CellID->8153],

Cell[TextData[ButtonBox["Working with String Patterns",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/WorkingWithStringPatternsOverview"]], "Tutorials",
 CellID->22514736]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->507996897],

Cell[TextData[ButtonBox["String Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringManipulation"]], "MoreAbout",
 CellID->359737215],

Cell[TextData[ButtonBox["String Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringOperations"]], "MoreAbout",
 CellID->534943001],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringPatterns"]], "MoreAbout",
 CellID->229840012],

Cell[TextData[ButtonBox["Testing Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TestingExpressions"]], "MoreAbout",
 CellID->377575536]
}, Open  ]],

Cell["New in 5.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"StringFreeQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 24, 30.6415770}", "context" -> "System`", 
    "keywords" -> {"contain substring", "grep", "matching strings", "sed"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "StringFreeQ[\"string\", patt] yields True if no substring in \" string\" \
matches the string expression patt, and yields False otherwise. \
StringFreeQ[\"string\", {patt_1, patt_2, ...}] yields True if no substring \
matches any of the patt_i. StringFreeQ[{s_1, s_2, ...}, p] gives the list of \
results for each of the s_i. ", "synonyms" -> {"string free q"}, "title" -> 
    "StringFreeQ", "type" -> "Symbol", "uri" -> "ref/StringFreeQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7718, 240, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->12581644]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 27577, 1007}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2969, 67, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3592, 94, 49, 1, 70, "ObjectName",
 CellID->22997],
Cell[3644, 97, 2696, 86, 70, "Usage",
 CellID->342]
}, Open  ]],
Cell[CellGroupData[{
Cell[6377, 188, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6855, 205, 334, 11, 70, "Notes",
 CellID->564],
Cell[7192, 218, 489, 17, 70, "Notes",
 CellID->29930]
}, Closed]],
Cell[CellGroupData[{
Cell[7718, 240, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->12581644],
Cell[CellGroupData[{
Cell[8102, 254, 146, 5, 70, "ExampleSection",
 CellID->7706135],
Cell[8251, 261, 123, 3, 70, "ExampleText",
 CellID->106767873],
Cell[CellGroupData[{
Cell[8399, 268, 194, 5, 28, "Input",
 CellID->116578822],
Cell[8596, 275, 161, 5, 36, "Output",
 CellID->584283618]
}, Open  ]],
Cell[8772, 283, 124, 3, 70, "ExampleDelimiter",
 CellID->84325201],
Cell[8899, 288, 80, 1, 70, "ExampleText",
 CellID->669591414],
Cell[CellGroupData[{
Cell[9004, 293, 148, 4, 70, "Input",
 CellID->64977182],
Cell[9155, 299, 161, 5, 36, "Output",
 CellID->49086226]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9365, 310, 220, 7, 70, "ExampleSection",
 CellID->650790119],
Cell[9588, 319, 63, 1, 70, "ExampleText",
 CellID->27548012],
Cell[CellGroupData[{
Cell[9676, 324, 169, 5, 70, "Input",
 CellID->49521929],
Cell[9848, 331, 160, 5, 36, "Output",
 CellID->39246743]
}, Open  ]],
Cell[CellGroupData[{
Cell[10045, 341, 178, 5, 70, "Input",
 CellID->59481413],
Cell[10226, 348, 162, 5, 36, "Output",
 CellID->374766656]
}, Open  ]],
Cell[10403, 356, 125, 3, 70, "ExampleDelimiter",
 CellID->362905145],
Cell[10531, 361, 70, 1, 70, "ExampleText",
 CellID->1538411368],
Cell[CellGroupData[{
Cell[10626, 366, 200, 6, 70, "Input",
 CellID->390912855],
Cell[10829, 374, 160, 5, 36, "Output",
 CellID->1822468]
}, Open  ]],
Cell[11004, 382, 124, 3, 70, "ExampleDelimiter",
 CellID->78178072],
Cell[11131, 387, 71, 1, 70, "ExampleText",
 CellID->1902099472],
Cell[CellGroupData[{
Cell[11227, 392, 286, 8, 70, "Input",
 CellID->251565656],
Cell[11516, 402, 162, 5, 36, "Output",
 CellID->534185506]
}, Open  ]],
Cell[11693, 410, 124, 3, 70, "ExampleDelimiter",
 CellID->14431676],
Cell[11820, 415, 88, 1, 70, "ExampleText",
 CellID->18071924],
Cell[CellGroupData[{
Cell[11933, 420, 258, 7, 70, "Input",
 CellID->44076838],
Cell[12194, 429, 161, 5, 36, "Output",
 CellID->72951355]
}, Open  ]],
Cell[12370, 437, 125, 3, 70, "ExampleDelimiter",
 CellID->183619726],
Cell[12498, 442, 73, 1, 70, "ExampleText",
 CellID->666879779],
Cell[CellGroupData[{
Cell[12596, 447, 222, 7, 70, "Input",
 CellID->139838655],
Cell[12821, 456, 162, 5, 36, "Output",
 CellID->167792866]
}, Open  ]],
Cell[CellGroupData[{
Cell[13020, 466, 190, 5, 70, "Input",
 CellID->724952594],
Cell[13213, 473, 162, 5, 36, "Output",
 CellID->429389704]
}, Open  ]],
Cell[13390, 481, 125, 3, 70, "ExampleDelimiter",
 CellID->367354650],
Cell[13518, 486, 227, 7, 70, "ExampleText",
 CellID->20655349],
Cell[CellGroupData[{
Cell[13770, 497, 317, 10, 70, "Input",
 CellID->366693576],
Cell[14090, 509, 225, 7, 36, "Output",
 CellID->299171218]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14364, 522, 222, 7, 70, "ExampleSection",
 CellID->550506631],
Cell[CellGroupData[{
Cell[14611, 533, 231, 7, 70, "ExampleSubsection",
 CellID->334822842],
Cell[14845, 542, 352, 12, 70, "ExampleText",
 CellID->73736195],
Cell[CellGroupData[{
Cell[15222, 558, 203, 5, 70, "Input",
 CellID->401476256],
Cell[15428, 565, 162, 5, 36, "Output",
 CellID->496517558]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[15651, 577, 227, 7, 70, "ExampleSection",
 CellID->297409720],
Cell[15881, 586, 119, 3, 70, "ExampleText",
 CellID->94161477],
Cell[16003, 591, 695, 22, 70, "Input",
 CellID->1049168330],
Cell[16701, 615, 125, 3, 70, "ExampleText",
 CellID->383896793],
Cell[CellGroupData[{
Cell[16851, 622, 281, 8, 70, "Input",
 CellID->628476173],
Cell[17135, 632, 1252, 31, 122, "Output",
 CellID->84508823]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18436, 669, 237, 7, 70, "ExampleSection",
 CellID->667951682],
Cell[18676, 678, 235, 7, 70, "ExampleText",
 CellID->1592501233],
Cell[CellGroupData[{
Cell[18936, 689, 185, 5, 70, "Input",
 CellID->1079530470],
Cell[19124, 696, 162, 5, 36, "Output",
 CellID->283141067]
}, Open  ]],
Cell[19301, 704, 229, 7, 70, "ExampleText",
 CellID->551801680],
Cell[CellGroupData[{
Cell[19555, 715, 184, 5, 70, "Input",
 CellID->1296448014],
Cell[19742, 722, 162, 5, 36, "Output",
 CellID->468112771]
}, Open  ]],
Cell[19919, 730, 124, 3, 70, "ExampleDelimiter",
 CellID->82563067],
Cell[20046, 735, 267, 8, 70, "ExampleText",
 CellID->482849400],
Cell[CellGroupData[{
Cell[20338, 747, 194, 5, 70, "Input",
 CellID->703474729],
Cell[20535, 754, 162, 5, 36, "Output",
 CellID->305811205]
}, Open  ]],
Cell[CellGroupData[{
Cell[20734, 764, 198, 5, 70, "Input",
 CellID->1560366778],
Cell[20935, 771, 609, 21, 36, "Output",
 CellID->126108139]
}, Open  ]],
Cell[21559, 795, 124, 3, 70, "ExampleDelimiter",
 CellID->50707733],
Cell[21686, 800, 241, 8, 70, "ExampleText",
 CellID->1595594583],
Cell[CellGroupData[{
Cell[21952, 812, 221, 7, 70, "Input",
 CellID->474674813],
Cell[22176, 821, 162, 5, 36, "Output",
 CellID->469833903]
}, Open  ]],
Cell[CellGroupData[{
Cell[22375, 831, 222, 7, 70, "Input",
 CellID->1529856392],
Cell[22600, 840, 223, 7, 36, "Output",
 CellID->264527005]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22884, 854, 310, 9, 70, "SeeAlsoSection",
 CellID->1584],
Cell[23197, 865, 1227, 44, 70, "SeeAlso",
 CellID->5842]
}, Open  ]],
Cell[CellGroupData[{
Cell[24461, 914, 314, 9, 70, "TutorialsSection",
 CellID->27273],
Cell[24778, 925, 151, 3, 70, "Tutorials",
 CellID->22362],
Cell[24932, 930, 139, 3, 70, "Tutorials",
 CellID->8153],
Cell[25074, 935, 178, 4, 70, "Tutorials",
 CellID->22514736]
}, Open  ]],
Cell[CellGroupData[{
Cell[25289, 944, 319, 9, 70, "MoreAboutSection",
 CellID->507996897],
Cell[25611, 955, 149, 3, 70, "MoreAbout",
 CellID->359737215],
Cell[25763, 960, 145, 3, 70, "MoreAbout",
 CellID->534943001],
Cell[25911, 965, 141, 3, 70, "MoreAbout",
 CellID->229840012],
Cell[26055, 970, 149, 3, 70, "MoreAbout",
 CellID->377575536]
}, Open  ]],
Cell[26219, 976, 29, 0, 70, "History"],
Cell[26251, 978, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

