(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25490,        938]
NotebookOptionsPosition[     19635,        734]
NotebookOutlinePosition[     21320,        777]
CellTagsIndexPosition[     21235,        772]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Operations on Strings" :> 
          Documentation`HelpLookup["paclet:tutorial/OperationsOnStrings"], 
          "Special Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SpecialCharacters-StringsAndCharacters"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Operations on Strings\"\>", 
       2->"\<\"Special Characters\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"StringReplacePart" :> 
          Documentation`HelpLookup["paclet:ref/StringReplacePart"], "Insert" :> 
          Documentation`HelpLookup["paclet:ref/Insert"], "StringPosition" :> 
          Documentation`HelpLookup["paclet:ref/StringPosition"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"StringReplacePart\"\>", 
       2->"\<\"Insert\"\>", 3->"\<\"StringPosition\"\>"}, "\<\"see also\"\>", 
       
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"String Operations" :> 
          Documentation`HelpLookup["paclet:guide/StringOperations"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"String Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["StringInsert", "ObjectName",
 CellID->1770],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringInsert",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringInsert"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"snew\", \"TI\"]\)\>\"", ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]yields a string with ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"snew\", \"TI\"]\)\>\""], "InlineFormula"],
     " inserted starting at position ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " in ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\""], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringInsert",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringInsert"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"snew\", \"TI\"]\)\>\"", ",", 
        RowBox[{"-", 
         StyleBox["n", "TI"]}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]inserts at position ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " from the end of ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\""], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringInsert",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringInsert"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"snew\", \"TI\"]\)\>\"", ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["n", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["n", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]inserts a copy of ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"snew\", \"TI\"]\)\>\""], "InlineFormula"],
     " at each of the positions ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["n", "i"], TraditionalForm]], "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringInsert",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringInsert"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["s", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["s", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", "\"\<\!\(\*
StyleBox[\"snew\", \"TI\"]\)\>\"", ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the list of results for each of the ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["s", "i"], TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->12782]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["StringInsert",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringInsert"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"snew\", \"TI\"]\)\>\"", ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 " makes the first character of ",
 Cell[BoxData[
  StyleBox["snew", "TI"]], "InlineFormula"],
 " the ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " character in the new string. "
}], "Notes",
 CellID->1079],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["StringInsert",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringInsert"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"snew\", \"TI\"]\)\>\"", ",", 
    RowBox[{"-", 
     StyleBox["n", "TI"]}]}], "]"}]], "InlineFormula"],
 " makes the last character of ",
 Cell[BoxData[
  StyleBox["snew", "TI"]], "InlineFormula"],
 " the ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " character from the end of the new string. "
}], "Notes",
 CellID->16780],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["StringInsert",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringInsert"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"snew\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["n", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are taken to refer to positions in ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\""], "InlineFormula"],
 " before any insertion is done. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->6312,
  ButtonNote->"6312"]
}], "Notes",
 CellID->8818]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->843706381],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->825986105],

Cell["Insert XYZ after character position 4:", "ExampleText",
 CellID->8439],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringInsert", "[", 
  RowBox[{"\"\<abcdefghijklm\>\"", ",", "\"\<XYZ\>\"", ",", "4"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18953],

Cell[BoxData["\<\"abcXYZdefghijklm\"\>"], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7043]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7487],

Cell["\<\
Insert XYZ starting 4 character positions from the end of the string:\
\>", "ExampleText",
 CellID->32373],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringInsert", "[", 
  RowBox[{"\"\<abcdefghijklm\>\"", ",", "\"\<XYZ\>\"", ",", 
   RowBox[{"-", "4"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9396],

Cell[BoxData["\<\"abcdefghijXYZklm\"\>"], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12287]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16634],

Cell["Insert XYZ at several positions:", "ExampleText",
 CellID->11939],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringInsert", "[", 
  RowBox[{"\"\<abcdefghijklm\>\"", ",", "\"\<XYZ\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "7"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6218],

Cell[BoxData["\<\"aXYZbXYZcdefXYZghijklm\"\>"], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17953]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18361],

Cell["Insert a dot at every third character position: ", "ExampleText",
 CellID->30032],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringInsert", "[", 
  RowBox[{"\"\<1234567890123456\>\"", ",", "\"\<.\>\"", ",", 
   RowBox[{"Range", "[", 
    RowBox[{"4", ",", "16", ",", "3"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2667],

Cell[BoxData["\<\"123.456.789.012.345.6\"\>"], "Output",
 ImageSize->{151, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6313]
}, Open  ]],

Cell["Count from the end:", "ExampleText",
 CellID->20398],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringInsert", "[", 
  RowBox[{"\"\<1234567890123456\>\"", ",", "\"\<.\>\"", ",", 
   RowBox[{"Range", "[", 
    RowBox[{
     RowBox[{"-", "16"}], ",", 
     RowBox[{"-", "4"}], ",", "3"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26128],

Cell[BoxData["\<\"1.234.567.890.123.456\"\>"], "Output",
 ImageSize->{151, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->3725]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24215],

Cell["Insertion positions always refer to the original string:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->6312],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringInsert", "[", 
  RowBox[{"\"\<abc\>\"", ",", "\"\<XYZ\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23815],

Cell[BoxData["\<\"XYZaXYZbXYZc\"\>"], "Output",
 ImageSize->{88, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3424]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17509],

Cell["\<\
Insert XYZ to start one character position after the end of the existing \
string:\
\>", "ExampleText",
 CellID->17879],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringInsert", "[", 
  RowBox[{"\"\<abcd\>\"", ",", "\"\<XYZ\>\"", ",", "5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4593],

Cell[BoxData["\<\"abcdXYZ\"\>"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12422]
}, Open  ]],

Cell["An equivalent form:", "ExampleText",
 CellID->12176],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringInsert", "[", 
  RowBox[{"\"\<abcd\>\"", ",", "\"\<XYZ\>\"", ",", 
   RowBox[{"-", "1"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14275],

Cell[BoxData["\<\"abcdXYZ\"\>"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->3619]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->334],

Cell["\<\
The positions refer to the original string, not the final one:\
\>", "ExampleText",
 CellID->15196],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringInsert", "[", 
  RowBox[{"\"\<abcdefghijklm\>\"", ",", "\"\<XYZ\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "7"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12082],

Cell[BoxData["\<\"aXYZbXYZcdefXYZghijklm\"\>"], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6044]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringPosition", "[", 
  RowBox[{"%", ",", "\"\<XYZ\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21709],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "15"}], "}"}]}], "}"}]], "Output",
 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->13148]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10492],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringInsert",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringInsert"]], "InlineFormula"],
 " operates on the raw characters in a string:"
}], "ExampleText",
 CellID->22821],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringInsert", "[", 
  RowBox[{"\"\<\!\(\*
StyleBox[\"red\",
FontColor->RGBColor[1, 0, 0]]\)\>\"", ",", "\"\<XYZ\>\"", ",", "10"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18467],

Cell[BoxData["\<\"\\!\\(\\* StyleXYZBox[\\\"red\\\",\\nFontColor->RGBColor[1, \
0, 0]]\\)\"\>"], "Output",
 ImageSize->{34, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12340]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "\"\<\!\(\*
StyleBox[\"red\",
FontColor->RGBColor[1, 0, 0]]\)\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6334],

Cell[BoxData[
 TagBox[
  StyleBox[
   "\"\<\\!\\(\\* StyleBox[\\\"red\\\",\\nFontColor->RGBColor[1, 0, \
0]]\\)\>\"",
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{417, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm=",
 CellID->1329]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->15186],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringReplacePart",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringReplacePart"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Insert",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Insert"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringPosition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringPosition"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->4021]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->21699],

Cell[TextData[ButtonBox["Operations on Strings",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OperationsOnStrings"]], "Tutorials",
 CellID->8117],

Cell[TextData[ButtonBox["Special Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SpecialCharacters-StringsAndCharacters"]], "Tutorials",
 CellID->336637905]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->42739101],

Cell[TextData[ButtonBox["String Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringOperations"]], "MoreAbout",
 CellID->8875530]
}, Open  ]],

Cell["New in 2  |  Last modified in 5.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"StringInsert - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 24, 31.1884660}", "context" -> "System`", 
    "keywords" -> {
     "appending to strings", "insertion of strings", "prepending to strings", 
      "splicing into strings"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "StringInsert[\"string\", \" snew\", n] yields a string with \" snew\" \
inserted starting at position n in \" string\". StringInsert[\"string\", \" \
snew\", -n] inserts at position n from the end of \" string\". \
StringInsert[\"string\", \" snew\", {n_1, n_2, ...}] inserts a copy of \" \
snew\" at each of the positions n_i. StringInsert[{s_1, s_2, ...}, \" snew\", \
n] gives the list of results for each of the s_i. ", 
    "synonyms" -> {"string insert"}, "title" -> "StringInsert", "type" -> 
    "Symbol", "uri" -> "ref/StringInsert"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8809, 286, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->843706381]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21092, 765}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2144, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2767, 79, 49, 1, 70, "ObjectName",
 CellID->1770],
Cell[2819, 82, 3201, 97, 70, "Usage",
 CellID->12782]
}, Open  ]],
Cell[CellGroupData[{
Cell[6057, 184, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6535, 201, 627, 21, 70, "Notes",
 CellID->1079],
Cell[7165, 224, 661, 22, 70, "Notes",
 CellID->16780],
Cell[7829, 248, 943, 33, 70, "Notes",
 CellID->8818]
}, Closed]],
Cell[CellGroupData[{
Cell[8809, 286, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->843706381],
Cell[CellGroupData[{
Cell[9194, 300, 148, 5, 70, "ExampleSection",
 CellID->825986105],
Cell[9345, 307, 76, 1, 70, "ExampleText",
 CellID->8439],
Cell[CellGroupData[{
Cell[9446, 312, 170, 5, 28, "Input",
 CellID->18953],
Cell[9619, 319, 177, 5, 36, "Output",
 CellID->7043]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9845, 330, 215, 7, 70, "ExampleSection",
 CellID->7487],
Cell[10063, 339, 116, 3, 70, "ExampleText",
 CellID->32373],
Cell[CellGroupData[{
Cell[10204, 346, 185, 5, 70, "Input",
 CellID->9396],
Cell[10392, 353, 178, 5, 36, "Output",
 CellID->12287]
}, Open  ]],
Cell[10585, 361, 121, 3, 70, "ExampleDelimiter",
 CellID->16634],
Cell[10709, 366, 71, 1, 70, "ExampleText",
 CellID->11939],
Cell[CellGroupData[{
Cell[10805, 371, 225, 6, 70, "Input",
 CellID->6218],
Cell[11033, 379, 184, 5, 36, "Output",
 CellID->17953]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11266, 390, 223, 7, 70, "ExampleSection",
 CellID->18361],
Cell[11492, 399, 87, 1, 70, "ExampleText",
 CellID->30032],
Cell[CellGroupData[{
Cell[11604, 404, 236, 6, 70, "Input",
 CellID->2667],
Cell[11843, 412, 182, 5, 36, "Output",
 CellID->6313]
}, Open  ]],
Cell[12040, 420, 58, 1, 70, "ExampleText",
 CellID->20398],
Cell[CellGroupData[{
Cell[12123, 425, 279, 8, 70, "Input",
 CellID->26128],
Cell[12405, 435, 182, 5, 36, "Output",
 CellID->3725]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12636, 446, 233, 7, 70, "ExampleSection",
 CellID->24215],
Cell[12872, 455, 142, 2, 70, "ExampleText",
 CellID->6312],
Cell[CellGroupData[{
Cell[13039, 461, 216, 6, 70, "Input",
 CellID->23815],
Cell[13258, 469, 172, 5, 36, "Output",
 CellID->3424]
}, Open  ]],
Cell[13445, 477, 121, 3, 70, "ExampleDelimiter",
 CellID->17509],
Cell[13569, 482, 129, 4, 70, "ExampleText",
 CellID->17879],
Cell[CellGroupData[{
Cell[13723, 490, 157, 4, 70, "Input",
 CellID->4593],
Cell[13883, 496, 168, 5, 36, "Output",
 CellID->12422]
}, Open  ]],
Cell[14066, 504, 58, 1, 70, "ExampleText",
 CellID->12176],
Cell[CellGroupData[{
Cell[14149, 509, 177, 5, 70, "Input",
 CellID->14275],
Cell[14329, 516, 167, 5, 36, "Output",
 CellID->3619]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14545, 527, 224, 7, 70, "ExampleSection",
 CellID->334],
Cell[14772, 536, 109, 3, 70, "ExampleText",
 CellID->15196],
Cell[CellGroupData[{
Cell[14906, 543, 226, 6, 70, "Input",
 CellID->12082],
Cell[15135, 551, 183, 5, 36, "Output",
 CellID->6044]
}, Open  ]],
Cell[CellGroupData[{
Cell[15355, 561, 139, 4, 70, "Input",
 CellID->21709],
Cell[15497, 567, 359, 13, 36, "Output",
 CellID->13148]
}, Open  ]],
Cell[15871, 583, 121, 3, 70, "ExampleDelimiter",
 CellID->10492],
Cell[15995, 588, 225, 7, 70, "ExampleText",
 CellID->22821],
Cell[CellGroupData[{
Cell[16245, 599, 214, 7, 70, "Input",
 CellID->18467],
Cell[16462, 608, 232, 6, 36, "Output",
 CellID->12340]
}, Open  ]],
Cell[CellGroupData[{
Cell[16731, 619, 162, 5, 70, "Input",
 CellID->6334],
Cell[16896, 626, 364, 13, 50, "Output",
 CellID->1329]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17321, 646, 311, 9, 70, "SeeAlsoSection",
 CellID->15186],
Cell[17635, 657, 721, 26, 70, "SeeAlso",
 CellID->4021]
}, Open  ]],
Cell[CellGroupData[{
Cell[18393, 688, 314, 9, 70, "TutorialsSection",
 CellID->21699],
Cell[18710, 699, 150, 3, 70, "Tutorials",
 CellID->8117],
Cell[18863, 704, 174, 4, 70, "Tutorials",
 CellID->336637905]
}, Open  ]],
Cell[CellGroupData[{
Cell[19074, 713, 318, 9, 70, "MoreAboutSection",
 CellID->42739101],
Cell[19395, 724, 143, 3, 70, "MoreAbout",
 CellID->8875530]
}, Open  ]],
Cell[19553, 730, 52, 0, 70, "History"],
Cell[19608, 732, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

