(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     32578,       1186]
NotebookOptionsPosition[     25653,        949]
NotebookOutlinePosition[     27170,        989]
CellTagsIndexPosition[     27085,        984]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"String Patterns" :> 
          Documentation`HelpLookup["paclet:tutorial/StringPatterns"], 
          "Working with String Patterns" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/WorkingWithStringPatternsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"String Patterns\"\>", 
       2->"\<\"Working with String Patterns\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"StringFreeQ" :> 
          Documentation`HelpLookup["paclet:ref/StringFreeQ"], 
          "StringPosition" :> 
          Documentation`HelpLookup["paclet:ref/StringPosition"], 
          "StringCases" :> Documentation`HelpLookup["paclet:ref/StringCases"],
           "Equal" :> Documentation`HelpLookup["paclet:ref/Equal"], "Names" :> 
          Documentation`HelpLookup["paclet:ref/Names"], "MatchQ" :> 
          Documentation`HelpLookup["paclet:ref/MatchQ"], "StringExpression" :> 
          Documentation`HelpLookup["paclet:ref/StringExpression"], 
          "RegularExpression" :> 
          Documentation`HelpLookup["paclet:ref/RegularExpression"], 
          "EditDistance" :> 
          Documentation`HelpLookup["paclet:ref/EditDistance"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"StringFreeQ\"\>", 
       2->"\<\"StringPosition\"\>", 3->"\<\"StringCases\"\>", 
       4->"\<\"Equal\"\>", 5->"\<\"Names\"\>", 6->"\<\"MatchQ\"\>", 
       7->"\<\"StringExpression\"\>", 8->"\<\"RegularExpression\"\>", 
       9->"\<\"EditDistance\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"String Operations" :> 
          Documentation`HelpLookup["paclet:guide/StringOperations"], 
          "String Patterns" :> 
          Documentation`HelpLookup["paclet:guide/StringPatterns"], 
          "Testing Expressions" :> 
          Documentation`HelpLookup["paclet:guide/TestingExpressions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"String Operations\"\>", 
       2->"\<\"String Patterns\"\>", 
       3->"\<\"Testing Expressions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["StringMatchQ", "ObjectName",
 CellID->2247],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringMatchQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringMatchQ"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", 
        StyleBox["patt", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]tests whether ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\""], "InlineFormula"],
     " matches the string pattern ",
     Cell[BoxData[
      StyleBox["patt", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringMatchQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringMatchQ"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", 
        RowBox[{
         ButtonBox["RegularExpression",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/RegularExpression"], "[", "\"\<\!\(\*
StyleBox[\"regex\", \"TI\"]\)\>\"", "]"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]tests whether ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\""], "InlineFormula"],
     " matches the specified regular expression. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringMatchQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringMatchQ"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["s", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["s", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["p", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the list of results for each of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->6800]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringMatchQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringMatchQ"]], "InlineFormula"],
 " allows both ordinary ",
 Cell[BoxData[
  ButtonBox["StringExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringExpression"]], "InlineFormula"],
 " string patterns, as well as abbreviated string patterns containing the \
following metacharacters:"
}], "Notes",
 CellID->23859],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "*", Cell[
    "zero or more characters", "TableText"]},
   {Cell["      ", "TableRowIcon"], "@", Cell[
    "one or more characters, excluding upper-case letters", "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell["\\\\*, etc.", "TableText"], Cell[
    "literal *, etc.", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->439942953],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Verbatim",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Verbatim"], "[", "\"\<\!\(\*
StyleBox[\"p\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
 " specifies the verbatim string ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"p\", \"TI\"]\)\>\""], "InlineFormula"],
 ", with ",
 Cell[BoxData["*"], "InlineFormula"],
 " and ",
 Cell[BoxData["@"], "InlineFormula"],
 " treated literally. "
}], "Notes",
 CellID->30038],

Cell[TextData[{
 "Setting the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["IgnoreCase",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IgnoreCase"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " makes ",
 Cell[BoxData[
  ButtonBox["StringMatchQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringMatchQ"]], "InlineFormula"],
 " treat lower\[Hyphen] and upper\[Hyphen]case letters as equivalent. "
}], "Notes",
 CellID->17340],

Cell[TextData[{
 "Setting the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SpellingCorrection",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SpellingCorrection"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " makes ",
 Cell[BoxData[
  ButtonBox["StringMatchQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringMatchQ"]], "InlineFormula"],
 " allow strings to match even if a small fraction of their characters are \
different. "
}], "Notes",
 CellID->13931]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->3078680],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->609647933],

Cell["Test whether a string pattern matches a particular string:", \
"ExampleText",
 CellID->106767873],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringMatchQ", "[", 
  RowBox[{"\"\<apppbb\>\"", ",", 
   RowBox[{"\"\<a\>\"", "~~", "___", "~~", "\"\<b\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->116578822],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->53333877]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->359517155],

Cell["Use abbreviated string patterns:", "ExampleText",
 CellID->669591414],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringMatchQ", "[", 
  RowBox[{"\"\<apppbb\>\"", ",", "\"\<a*b\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->64977182],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->718566654]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->191740137],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "IgnoreCase",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->88894338],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["IgnoreCase",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IgnoreCase"], " ", "->", " ", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", uppercase and lowercase are treated the same:"
}], "ExampleText",
 CellID->73736195],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringMatchQ", "[", 
  RowBox[{"\"\<acggtATTCaagc\>\"", ",", 
   RowBox[{"__", "~~", "\"\<aT\>\"", "~~", "__"}], ",", 
   RowBox[{"IgnoreCase", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->401476256],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->863171942]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "SpellingCorrection",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->133972054],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SpellingCorrection",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SpellingCorrection"], " ", "->", " ", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " allows automatic spelling correction:"
}], "ExampleText",
 CellID->1820744160],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringMatchQ", "[", 
  RowBox[{"\"\<commit\>\"", ",", "\"\<comit\>\"", ",", 
   RowBox[{"SpellingCorrection", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1752611017],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->69645963]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->480149],

Cell[TextData[{
 "For literal strings, ",
 Cell[BoxData[
  ButtonBox["SameQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SameQ"]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  ButtonBox["StringMatchQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringMatchQ"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->92308476],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\"\<abbaab\>\"", "===", "\"\<abbab\>\""}]], "Input",
 CellLabel->"In[1]:=",
 CellID->457314056],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1008811746]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringMatchQ", "[", 
  RowBox[{"\"\<abbaab\>\"", ",", "\"\<abbab\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->567909585],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->202768132]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->876097397],

Cell[TextData[{
 "For fast extraction of elements in a list, use ",
 Cell[BoxData[
  ButtonBox["Pick",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Pick"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->2015597914],

Cell[BoxData[
 RowBox[{
  RowBox[{"dna", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"StringJoin", "[", 
      RowBox[{"RandomChoice", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
         "\"\<a\>\"", ",", "\"\<c\>\"", ",", "\"\<g\>\"", ",", "\"\<t\>\""}], 
         "}"}], ",", "10"}], "]"}], "]"}], ",", 
     RowBox[{"{", "50000", "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1747092820],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Pick", "[", 
    RowBox[{"dna", ",", 
     RowBox[{"StringMatchQ", "[", 
      RowBox[{"dna", ",", 
       RowBox[{"\"\<a\>\"", "~~", "___", "~~", "\"\<ggg\>\"", "~~", "___"}]}],
       "]"}]}], "]"}], "//", "Timing"}], "//", "First"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->845120309],

Cell[BoxData["0.030999999999999972`"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->371273797]
}, Open  ]],

Cell[TextData[{
 "Compare to ",
 Cell[BoxData[
  ButtonBox["Select",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Select"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->160576598],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Select", "[", 
    RowBox[{"dna", ",", 
     RowBox[{
      RowBox[{"StringMatchQ", "[", 
       RowBox[{"#", ",", 
        RowBox[{
        "\"\<a\>\"", "~~", "___", "~~", "\"\<ggg\>\"", "~~", "___"}]}], "]"}],
       "&"}]}], "]"}], "//", "Timing"}], "//", "First"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->806403816],

Cell[BoxData["0.32799999999999996`"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->6754561]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->561723361],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["StringFreeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringFreeQ"]], "InlineFormula"],
 " to check no substring matches a pattern:"
}], "ExampleText",
 CellID->518430169],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringFreeQ", "[", 
  RowBox[{"\"\<commit\>\"", ",", " ", 
   RowBox[{"\"\<om\>\"", "~~", "__"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1571421954],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->267162427]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringMatchQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringMatchQ"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " whenever ",
 Cell[BoxData[
  ButtonBox["StringFreeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringFreeQ"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->869615147],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringFreeQ", "[", 
  RowBox[{"\"\<commit\>\"", ",", " ", 
   RowBox[{"\"\<am\>\"", "~~", "__"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->12246409],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->478265855]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringMatchQ", "[", 
  RowBox[{"\"\<commit\>\"", ",", " ", 
   RowBox[{"\"\<am\>\"", "~~", "__"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1839359865],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->24078410]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->216731682],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringMatchQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringMatchQ"]], "InlineFormula"],
 " does not work on strings with embedded formatting information:"
}], "ExampleText",
 CellID->1881508352],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringMatchQ", "[", 
  RowBox[{"\"\<\!\(\*
StyleBox[\(te\*
StyleBox[\"ste\",
FontColor->RGBColor[1, 0, 0]]r\)]\)\>\"", ",", 
   RowBox[{"\"\<t\>\"", "~~", "__"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->441334730],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->450534096]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringMatchQ", "[", 
  RowBox[{"\"\<tester\>\"", ",", " ", 
   RowBox[{"\"\<t\>\"", "~~", "__"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1841484400],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->652571738]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->315656513],

Cell["Spelling correction only works for letter string patterns:", \
"ExampleText",
 CellID->1129485662],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringMatchQ", "[", 
  RowBox[{"\"\<abcde\>\"", ",", "\"\<A@\>\"", ",", 
   RowBox[{"SpellingCorrection", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1842492486],

Cell[BoxData[
 RowBox[{
  RowBox[{"StringMatchQ", "::", "\<\"nospell\"\>"}], ":", 
  " ", "\<\" Warning: The SpellingCorrection option is ignored for patterns \
that are not a plain string.\"\>"}]], "Message", "MSG",
 CellID->55694295],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->463922826]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31740],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringFreeQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringFreeQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringPosition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringPosition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringCases",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringCases"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Equal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Equal"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Names",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Names"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MatchQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MatchQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringExpression"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RegularExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RegularExpression"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EditDistance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EditDistance"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->9104]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->14253],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StringPatterns"]], "Tutorials",
 CellID->3877],

Cell[TextData[ButtonBox["Working with String Patterns",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/WorkingWithStringPatternsOverview"]], "Tutorials",
 CellID->22514736]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with StringMatchQ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=StringMatchQ"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->31139220],

Cell[TextData[ButtonBox["String Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringOperations"]], "MoreAbout",
 CellID->681103865],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringPatterns"]], "MoreAbout",
 CellID->456695174],

Cell[TextData[ButtonBox["Testing Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TestingExpressions"]], "MoreAbout",
 CellID->423307225]
}, Open  ]],

Cell["New in 1  |  Last modified in 5.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"StringMatchQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 24, 32.0478630}", "context" -> "System`", 
    "keywords" -> {
     "compare strings", "matching of strings", "string comparison"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "StringMatchQ[\"string\", patt] tests whether \" string\" matches the \
string pattern patt. StringMatchQ[\"string\", RegularExpression[\"regex\"]] \
tests whether \" string\" matches the specified regular expression. \
StringMatchQ[{s_1, s_2, ...}, p] gives the list of results for each of the \
s_i. ", "synonyms" -> {"string match q"}, "title" -> "StringMatchQ", "type" -> 
    "Symbol", "uri" -> "ref/StringMatchQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9025, 275, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->3078680]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 26944, 977}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3089, 68, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3712, 95, 49, 1, 70, "ObjectName",
 CellID->2247],
Cell[3764, 98, 2146, 65, 70, "Usage",
 CellID->6800]
}, Open  ]],
Cell[CellGroupData[{
Cell[5947, 168, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6425, 185, 436, 13, 70, "Notes",
 CellID->23859],
Cell[6864, 200, 603, 13, 70, "2ColumnTableMod",
 CellID->439942953],
Cell[7470, 215, 468, 16, 70, "Notes",
 CellID->30038],
Cell[7941, 233, 505, 17, 70, "Notes",
 CellID->17340],
Cell[8449, 252, 539, 18, 70, "Notes",
 CellID->13931]
}, Closed]],
Cell[CellGroupData[{
Cell[9025, 275, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->3078680],
Cell[CellGroupData[{
Cell[9408, 289, 148, 5, 70, "ExampleSection",
 CellID->609647933],
Cell[9559, 296, 103, 2, 70, "ExampleText",
 CellID->106767873],
Cell[CellGroupData[{
Cell[9687, 302, 198, 5, 28, "Input",
 CellID->116578822],
Cell[9888, 309, 160, 5, 36, "Output",
 CellID->53333877]
}, Open  ]],
Cell[10063, 317, 125, 3, 70, "ExampleDelimiter",
 CellID->359517155],
Cell[10191, 322, 75, 1, 70, "ExampleText",
 CellID->669591414],
Cell[CellGroupData[{
Cell[10291, 327, 153, 4, 70, "Input",
 CellID->64977182],
Cell[10447, 333, 161, 5, 36, "Output",
 CellID->718566654]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10657, 344, 222, 7, 70, "ExampleSection",
 CellID->191740137],
Cell[CellGroupData[{
Cell[10904, 355, 230, 7, 70, "ExampleSubsection",
 CellID->88894338],
Cell[11137, 364, 350, 12, 70, "ExampleText",
 CellID->73736195],
Cell[CellGroupData[{
Cell[11512, 380, 250, 6, 70, "Input",
 CellID->401476256],
Cell[11765, 388, 161, 5, 36, "Output",
 CellID->863171942]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11975, 399, 239, 7, 70, "ExampleSubsection",
 CellID->133972054],
Cell[12217, 408, 365, 12, 70, "ExampleText",
 CellID->1820744160],
Cell[CellGroupData[{
Cell[12607, 424, 217, 5, 70, "Input",
 CellID->1752611017],
Cell[12827, 431, 160, 5, 36, "Output",
 CellID->69645963]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[13048, 443, 234, 7, 70, "ExampleSection",
 CellID->480149],
Cell[13285, 452, 347, 13, 70, "ExampleText",
 CellID->92308476],
Cell[CellGroupData[{
Cell[13657, 469, 119, 3, 70, "Input",
 CellID->457314056],
Cell[13779, 474, 163, 5, 36, "Output",
 CellID->1008811746]
}, Open  ]],
Cell[CellGroupData[{
Cell[13979, 484, 156, 4, 70, "Input",
 CellID->567909585],
Cell[14138, 490, 162, 5, 36, "Output",
 CellID->202768132]
}, Open  ]],
Cell[14315, 498, 125, 3, 70, "ExampleDelimiter",
 CellID->876097397],
Cell[14443, 503, 223, 8, 70, "ExampleText",
 CellID->2015597914],
Cell[14669, 513, 454, 14, 70, "Input",
 CellID->1747092820],
Cell[CellGroupData[{
Cell[15148, 531, 336, 10, 70, "Input",
 CellID->845120309],
Cell[15487, 543, 178, 5, 36, "Output",
 CellID->371273797]
}, Open  ]],
Cell[15680, 551, 190, 8, 70, "ExampleText",
 CellID->160576598],
Cell[CellGroupData[{
Cell[15895, 563, 369, 12, 70, "Input",
 CellID->806403816],
Cell[16267, 577, 175, 5, 36, "Output",
 CellID->6754561]
}, Open  ]],
Cell[16457, 585, 125, 3, 70, "ExampleDelimiter",
 CellID->561723361],
Cell[16585, 590, 233, 8, 70, "ExampleText",
 CellID->518430169],
Cell[CellGroupData[{
Cell[16843, 602, 184, 5, 70, "Input",
 CellID->1571421954],
Cell[17030, 609, 162, 5, 36, "Output",
 CellID->267162427]
}, Open  ]],
Cell[17207, 617, 573, 22, 70, "ExampleText",
 CellID->869615147],
Cell[CellGroupData[{
Cell[17805, 643, 182, 5, 70, "Input",
 CellID->12246409],
Cell[17990, 650, 161, 5, 36, "Output",
 CellID->478265855]
}, Open  ]],
Cell[CellGroupData[{
Cell[18188, 660, 185, 5, 70, "Input",
 CellID->1839359865],
Cell[18376, 667, 161, 5, 36, "Output",
 CellID->24078410]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18586, 678, 230, 7, 70, "ExampleSection",
 CellID->216731682],
Cell[18819, 687, 249, 7, 70, "ExampleText",
 CellID->1881508352],
Cell[CellGroupData[{
Cell[19093, 698, 248, 8, 70, "Input",
 CellID->441334730],
Cell[19344, 708, 162, 5, 36, "Output",
 CellID->450534096]
}, Open  ]],
Cell[CellGroupData[{
Cell[19543, 718, 184, 5, 70, "Input",
 CellID->1841484400],
Cell[19730, 725, 161, 5, 36, "Output",
 CellID->652571738]
}, Open  ]],
Cell[19906, 733, 125, 3, 70, "ExampleDelimiter",
 CellID->315656513],
Cell[20034, 738, 104, 2, 70, "ExampleText",
 CellID->1129485662],
Cell[CellGroupData[{
Cell[20163, 744, 213, 5, 70, "Input",
 CellID->1842492486],
Cell[20379, 751, 235, 5, 70, "Message",
 CellID->55694295],
Cell[20617, 758, 162, 5, 36, "Output",
 CellID->463922826]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20840, 770, 311, 9, 70, "SeeAlsoSection",
 CellID->31740],
Cell[21154, 781, 2215, 80, 70, "SeeAlso",
 CellID->9104]
}, Open  ]],
Cell[CellGroupData[{
Cell[23406, 866, 314, 9, 70, "TutorialsSection",
 CellID->14253],
Cell[23723, 877, 139, 3, 70, "Tutorials",
 CellID->3877],
Cell[23865, 882, 178, 4, 70, "Tutorials",
 CellID->22514736]
}, Open  ]],
Cell[CellGroupData[{
Cell[24080, 891, 305, 8, 70, "RelatedLinksSection"],
Cell[24388, 901, 369, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24794, 918, 318, 9, 70, "MoreAboutSection",
 CellID->31139220],
Cell[25115, 929, 145, 3, 70, "MoreAbout",
 CellID->681103865],
Cell[25263, 934, 141, 3, 70, "MoreAbout",
 CellID->456695174],
Cell[25407, 939, 149, 3, 70, "MoreAbout",
 CellID->423307225]
}, Open  ]],
Cell[25571, 945, 52, 0, 70, "History"],
Cell[25626, 947, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

