(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     61199,       2203]
NotebookOptionsPosition[     50469,       1818]
NotebookOutlinePosition[     52298,       1862]
CellTagsIndexPosition[     52212,       1857]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Operations on Strings" :> 
          Documentation`HelpLookup["paclet:tutorial/OperationsOnStrings"], 
          "Special Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SpecialCharacters-StringsAndCharacters"], 
          "String Patterns" :> 
          Documentation`HelpLookup["paclet:tutorial/StringPatterns"], 
          "Working with String Patterns" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/WorkingWithStringPatternsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Operations on Strings\"\>", 
       2->"\<\"Special Characters\"\>", 3->"\<\"String Patterns\"\>", 
       4->"\<\"Working with String Patterns\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Position" :> Documentation`HelpLookup["paclet:ref/Position"], 
          "StringCases" :> Documentation`HelpLookup["paclet:ref/StringCases"],
           "StringCount" :> 
          Documentation`HelpLookup["paclet:ref/StringCount"], "Characters" :> 
          Documentation`HelpLookup["paclet:ref/Characters"], "FindList" :> 
          Documentation`HelpLookup["paclet:ref/FindList"], "ReplaceList" :> 
          Documentation`HelpLookup["paclet:ref/ReplaceList"], 
          "StringExpression" :> 
          Documentation`HelpLookup["paclet:ref/StringExpression"], 
          "RegularExpression" :> 
          Documentation`HelpLookup["paclet:ref/RegularExpression"], 
          "StringDrop" :> Documentation`HelpLookup["paclet:ref/StringDrop"], 
          "StringInsert" :> 
          Documentation`HelpLookup["paclet:ref/StringInsert"], "StringTake" :> 
          Documentation`HelpLookup["paclet:ref/StringTake"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Position\"\>", 
       2->"\<\"StringCases\"\>", 3->"\<\"StringCount\"\>", 
       4->"\<\"Characters\"\>", 5->"\<\"FindList\"\>", 
       6->"\<\"ReplaceList\"\>", 7->"\<\"StringExpression\"\>", 
       8->"\<\"RegularExpression\"\>", 9->"\<\"StringDrop\"\>", 
       10->"\<\"StringInsert\"\>", 
       11->"\<\"StringTake\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"String Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/StringManipulation"], 
          "String Operations" :> 
          Documentation`HelpLookup["paclet:guide/StringOperations"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"String Manipulation\"\>", 
       2->"\<\"String Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["StringPosition", "ObjectName",
 CellID->26469],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringPosition",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringPosition"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"sub\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of the starting and ending character \
positions at which ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"sub\", \"TI\"]\)\>\""], "InlineFormula"],
     " appears as a substring of ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\""], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringPosition",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringPosition"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", 
        StyleBox["patt", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives all positions at which substrings matching the \
general string expression ",
     Cell[BoxData[
      StyleBox["patt", "TI"]], "InlineFormula"],
     " appear in ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\""], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringPosition",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringPosition"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", 
        StyleBox["patt", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]includes only the first ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " occurrences of ",
     Cell[BoxData[
      StyleBox["patt", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringPosition",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringPosition"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["patt", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["patt", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives positions of all the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["patt", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringPosition",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringPosition"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["s", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["s", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["p", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the list of results for each of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->11644]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The string expression ",
 Cell[BoxData[
  StyleBox["patt", "TI"]], "InlineFormula"],
 " can contain any of the objects specified in the notes for ",
 Cell[BoxData[
  ButtonBox["StringExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringExpression"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->2244],

Cell[TextData[{
 "With the default option setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Overlaps",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Overlaps"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["StringPosition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringPosition"]], "InlineFormula"],
 " includes substrings that overlap. With the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Overlaps",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Overlaps"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " such substrings are excluded. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->2967,
  ButtonNote->"2967"]
}], "Notes",
 CellID->9136],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Overlaps",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Overlaps"], "->", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"]}]], "InlineFormula"],
 ", multiple substrings that match the same string expression are all \
included. With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Overlaps",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Overlaps"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", only the first such matching substring at a given position is included. \
",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->10615,
  ButtonNote->"10615"]
}], "Notes",
 CellID->27728],

Cell[TextData[{
 "Setting the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["IgnoreCase",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IgnoreCase"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " makes ",
 Cell[BoxData[
  ButtonBox["StringPosition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringPosition"]], "InlineFormula"],
 " treat lowercase and uppercase letters as equivalent. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->27717,
  ButtonNote->"27717"]
}], "Notes",
 CellID->10037],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringPosition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringPosition"]], "InlineFormula"],
 " returns sequence specifications in the form used by ",
 Cell[BoxData[
  ButtonBox["StringTake",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringTake"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["StringDrop",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringDrop"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["StringReplacePart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringReplacePart"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->11232,
  ButtonNote->"11232"]
}], "Notes",
 CellID->21864],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["StringPosition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringPosition"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", 
    RowBox[{
     ButtonBox["RegularExpression",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RegularExpression"], "[", "\"\<\!\(\*
StyleBox[\"regex\", \"TI\"]\)\>\"", "]"}]}], "]"}]], "InlineFormula"],
 " gives positions of substrings matching the specified regular expression. "
}], "Notes",
 CellID->5792]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->322419329],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->215748048],

Cell["\<\
Find the starting and ending positions at which XYZ occurs in a string:\
\>", "ExampleText",
 CellID->474],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringPosition", "[", 
  RowBox[{"\"\<abXYZaaabXYZaaaaXYZXYZ\>\"", ",", "\"\<XYZ\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3499],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", "19"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"20", ",", "22"}], "}"}]}], "}"}]], "Output",
 ImageSize->{251, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24573]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25453],

Cell["Find where any pairs of identical characters occur:", "ExampleText",
 CellID->5849],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringPosition", "[", 
  RowBox[{"\"\<AABBBAABABBCCCBAAA\>\"", ",", 
   RowBox[{"x_", "~~", "x_"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31888],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "13"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "14"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "17"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", "18"}], "}"}]}], "}"}]], "Output",
 ImageSize->{531, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24555]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4632],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringPosition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringPosition"]], "InlineFormula"],
 " gives substring positions in the form used by functions like ",
 Cell[BoxData[
  ButtonBox["StringTake",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringTake"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->11232],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringPosition", "[", 
  RowBox[{"\"\<XYZabc\>\"", ",", "\"\<XYZ\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14611],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"1", ",", "3"}], "}"}], "}"}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23434]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringTake", "[", 
  RowBox[{"\"\<XYZabc\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18660],

Cell[BoxData["\<\"XYZ\"\>"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->10693]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22211],

Cell["Find the position of the first occurrence of XYZ:", "ExampleText",
 CellID->16791],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringPosition", "[", 
  RowBox[{"\"\<abXYZaaabXYZaaaaXYZXYZ\>\"", ",", "\"\<XYZ\>\"", ",", "1"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18847],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"3", ",", "5"}], "}"}], "}"}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15915]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->18442],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringPosition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringPosition"]], "InlineFormula"],
 " by default includes overlaps:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->2967],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringPosition", "[", 
  RowBox[{"\"\<AAAAA\>\"", ",", "\"\<AA\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5732],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5"}], "}"}]}], "}"}]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19154]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Overlaps",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Overlaps"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " to exclude overlaps:"
}], "ExampleText",
 CellID->28536],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringPosition", "[", 
  RowBox[{"\"\<AAAAA\>\"", ",", "\"\<AA\>\"", ",", 
   RowBox[{"Overlaps", "->", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14950],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->29418]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29089],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringPosition", "[", 
  RowBox[{"\"\<ABAABBAABABB\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<ABA\>\"", ",", "\"\<AA\>\""}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24613],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "10"}], "}"}]}], "}"}]], "Output",
 ImageSize->{216, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27213]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringPosition", "[", 
  RowBox[{"\"\<ABAABBAABABB\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<ABA\>\"", ",", "\"\<AA\>\""}], "}"}], ",", 
   RowBox[{"Overlaps", "->", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18859],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "8"}], "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->30014]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22578],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "IgnoreCase",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->27717],

Cell["Treat a and A as the same:", "ExampleText",
 CellID->2011],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringPosition", "[", 
  RowBox[{"\"\<abAB\>\"", ",", "\"\<a\>\"", ",", 
   RowBox[{"IgnoreCase", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10009],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18187]
}, Open  ]],

Cell["Treat a and A as different:", "ExampleText",
 CellID->13088],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringPosition", "[", 
  RowBox[{"\"\<abAB\>\"", ",", "\"\<a\>\"", ",", 
   RowBox[{"IgnoreCase", "->", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->31827],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"1", ",", "1"}], "}"}], "}"}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->25817]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22937],

Cell["Find successive identical characters independent of case:", \
"ExampleText",
 CellID->16465],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringPosition", "[", 
  RowBox[{"\"\<aAbaBabBBaABAaBa\>\"", ",", 
   RowBox[{"x_", "~~", "x_"}], ",", 
   RowBox[{"IgnoreCase", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3445],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "14"}], "}"}]}], "}"}]], "Output",
 ImageSize->{287, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29073]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringPosition", "[", 
  RowBox[{"\"\<aAbaBabBBaABAaBa\>\"", ",", 
   RowBox[{"x_", "~~", "x_"}], ",", 
   RowBox[{"IgnoreCase", "->", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13394],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"8", ",", "9"}], "}"}], "}"}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->27070]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Overlaps",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->19962],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringPosition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringPosition"]], "InlineFormula"],
 " by default includes overlaps:"
}], "ExampleText",
 CellID->31647],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringPosition", "[", 
  RowBox[{"\"\<AABBBAABABBCCCBAAA\>\"", ",", 
   RowBox[{"x_", "~~", "x_"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3715],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "13"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "14"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "17"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", "18"}], "}"}]}], "}"}]], "Output",
 ImageSize->{531, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8336]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringPosition", "[", 
  RowBox[{"\"\<AABBBAABABBCCCBAAA\>\"", ",", 
   RowBox[{"x_", "~~", "x_"}], ",", 
   RowBox[{"Overlaps", "->", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28587],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "13"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "17"}], "}"}]}], "}"}]], "Output",
 ImageSize->{352, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->583]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23445],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["StringPosition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringPosition"]], "InlineFormula"],
 " only includes one substring starting at any given position:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->10615],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringPosition", "[", 
  RowBox[{"\"\<AAAA\>\"", ",", "x__"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19168],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4"}], "}"}]}], "}"}]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15403]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Overlaps",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Overlaps"], "->", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"]}]], "InlineFormula"],
 " it includes all substrings:"
}], "ExampleText",
 CellID->17317],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringPosition", "[", 
  RowBox[{"\"\<AAAA\>\"", ",", "x__", ",", 
   RowBox[{"Overlaps", "->", "All"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18255],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4"}], "}"}]}], "}"}]], "Output",
 ImageSize->{511, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->10617]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringPosition", "[", 
  RowBox[{"\"\<AAAA\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"x__", ",", "\"\<A\>\""}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->18741],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4"}], "}"}]}], "}"}]], "Output",
 ImageSize->{410, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->11848]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11631],

Cell["\<\
Find positions of pairs of identical letters in a concatenation sequence:\
\>", "ExampleText",
 CellID->29510],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringJoin", "[", 
  RowBox[{"Tuples", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<A\>\"", ",", "\"\<B\>\""}], "}"}], ",", "4"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11403],

Cell[BoxData["\<\"\
AAAAAAABAABAAABBABAAABABABBAABBBBAAABAABBABABABBBBAABBABBBBABBBB\"\>"], \
"Output",
 ImageSize->{452, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8788]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"First", "/@", 
  RowBox[{"StringPosition", "[", 
   RowBox[{"%", ",", 
    RowBox[{"x_", "~~", "x_"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->22109],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "9", ",", "12", 
   ",", "13", ",", "15", ",", "19", ",", "20", ",", "26", ",", "28", ",", 
   "30", ",", "31", ",", "32", ",", "34", ",", "35", ",", "38", ",", "40", 
   ",", "47", ",", "48", ",", "49", ",", "51", ",", "53", ",", "56", ",", 
   "57", ",", "58", ",", "61", ",", "62", ",", "63"}], "}"}]], "Output",
 ImageSize->{410, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->19329]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1032],

Cell[BoxData[
 GraphicsBox[
  {GrayLevel[0], PointBox[{22., 47.}], PointBox[{21., 40.}], 
   PointBox[{24., 49.}], PointBox[{23., 48.}], PointBox[{18., 34.}], 
   PointBox[{17., 32.}], PointBox[{20., 38.}], PointBox[{19., 35.}], 
   PointBox[{30., 61.}], PointBox[{29., 58.}], PointBox[{32., 63.}], 
   PointBox[{31., 62.}], PointBox[{26., 53.}], PointBox[{25., 51.}], 
   PointBox[{28., 57.}], PointBox[{27., 56.}], PointBox[{6., 6.}], 
   PointBox[{5., 5.}], PointBox[{8., 12.}], PointBox[{7., 9.}], 
   PointBox[{2., 2.}], PointBox[{1., 1.}], PointBox[{4., 4.}], 
   PointBox[{3., 3.}], PointBox[{14., 28.}], PointBox[{13., 26.}], 
   PointBox[{16., 31.}], PointBox[{15., 30.}], PointBox[{10., 15.}], 
   PointBox[{9., 13.}], PointBox[{12., 20.}], PointBox[{11., 19.}]},
  AspectRatio->GoldenRatio^(-1),
  Axes->True,
  ImageMargins->0.,
  PlotRange->{Automatic, Automatic},
  PlotRangeClipping->True]], "Output",
 ImageSize->{229, 145},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[3]=",
 CellID->28557]
}, Open  ]],

Cell["Find an analogous curve for triples:", "ExampleText",
 CellID->5860],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"First", "/@", 
   RowBox[{"StringPosition", "[", 
    RowBox[{
     RowBox[{"StringJoin", "[", 
      RowBox[{"Tuples", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\"\<A\>\"", ",", "\"\<B\>\""}], "}"}], ",", "7"}], "]"}], 
      "]"}], ",", 
     RowBox[{"x_", "~~", "x_", "~~", "x_"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->10140],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[4]=",
 CellID->107728854]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7041],

Cell["\<\
Find the positions of the word \"president\" in the U.S. Constitution:\
\>", "ExampleText",
 CellID->26470],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Import", "[", "\"\<System/USConstitution.txt\>\"", "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17214],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"First", "/@", 
   RowBox[{"StringPosition", "[", 
    RowBox[{"data", ",", "\"\<president\>\"", ",", 
     RowBox[{"IgnoreCase", "->", "True"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15058],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdWctrE0EYn2Q36ab1RZvW1heheIiirfggraL0IFUPImLxIIKmpZAixRKr
CF70IFEqFIoinqIHUfCiFm1Pogf/kP4l68x8u/Pab3fzbjDQ2Z3Zb37fY77v
N7Pbq8Xl0vxicXlhrpi7VC4ulRbmHuSm75fpkJUghGzRv+fDhN679I7/bbku
vartBG1t+ihJr0l6HWGjbMD1f2x02LtaIf1BerUUFH88643zAQK/pCFHyCRr
U6BTtFyGWMISMqRbhkgwbSStSjQnNxCpEbOxnzUZNXqYV2xxEuzKx87W5BcT
ICkB5aENdYfHSj+JIugen4vBzGLPNcxa/WZ5mUQRBpv21ELk6/Mz3Drmn9WU
582vZLx/E02vwl5XVr4Y7HT2xs7QvZ50dY7DGXNE8TmMMdW+ypjYODAlcPYh
w4vfLRrdR9u/fgwCMqmYvl2nfLfN7zZ7zPlpdFUONNm/iKLG5Q7LyD9xM1ld
VyoVwn+lUon80p/lcjl4Zts2PxUQu1AoCPFNXXpjY2NsbCyfz2ezWU86kUiA
tOM4m5ptPIN7xJRyuQw31WqVbDbkcWui08P7EBQWkZ8RUhAe6lqUlE19HB0d
BbgfqJzDIwhoLNKgeV2zNsNlKNbU1BSLL+hdR/F6eR9kWTxxKYgGJLH/87nQ
dnGOS6MY+Imidp7HeN/qqCbW/V982U5N6luEnzP15VLN3BU7usPVK/lbuJQt
iI4Kfo2QozXFyo4Xn5Rj9u5yZc3NzMwA/1kUzpv/BUXdrWunxW/O+xwxTyVc
Pi8N7EF/QNMU5iM6vx+fbwFfC7ZX7HiP4vAzelplcaCnpOeNLaJa1aK1H9dv
q/aDBcIR8ha14CCO5IidR7rEYd6gKDnWZIK7kXCImNasoTh5Px6QJaCb3uPS
R1jjcTpoYmy9pkXqOJeBLJbaV1G8Y1wWskmo9mTVLwi1ViTHc4R9sIsJI15x
XO/QQ9S29ewyjnoGFnSC3cbRlQL92FtYK3ek9uAj3B32/ta1+0Q7d4/t1HKS
9+XOtaJpPcWfyrPnSgSGPAPiUp303Wp4rdtfAadZE2DZSie1W5LdYC8Xb1rC
oGeuWTshtsR8iYniHG5LWjCd2MeM9zlkf37CkTvBxgXWZISNYquWmy5+mpG2
PurQyp5njRO0VD0lRcV0qeHK4V8NtPdrIzqOqlfNsnsuVsOXWdMXFXM18tKD
kkBjT66xXq+6jxoQ9L6E6r/BK9TcgXHZmy5WzfPhsmbtKfbPhs9yglUCHsxq
Pt9CLcdxt3OHuo1G7U6ErHkei5DFT5F+xtsq15krcF3z6G5As1g1Wz3zA4cG
c9xEv4LazD0ZMPI0+G4QXQWmdqpuGtW2yJqdYdqM5CKAYXCVWx87PERzEkVu
Cy8+5n2ZazxeKYOIyAWOhv9frdl9Diww697MqGBeyjfiM6Ahfv9o0MpAvBD2
NenHyDvx1uvb6qlrq61PWYPszsa34cBqn+igjS84jvGeLlgjePI66jZfcy9d
jQdrPF/JfDvsqjy4GhJl8wwEKSBqTPt+f0ggqna+1u2Uy4bZ6X+x0nCHUdx3
teWFmb3BPYJq2INq+OBrQLDRfQL53taHIn+qzXZLfr2XOOwJ/1aIfG+TNWDa
YaF2fI/KW4sORs5exzJQ/Nslhc6p/+xBEv8Akw4Lbw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 133},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[2]=",
 CellID->651926626]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22387],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["StringTake",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringTake"]], "InlineFormula"],
 " to extract substrings found by ",
 Cell[BoxData[
  ButtonBox["StringPosition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringPosition"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->5512],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringPosition", "[", 
  RowBox[{"\"\<AABBBAABABBCCCBAAA\>\"", ",", 
   RowBox[{"x_", "~~", "x_"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8675],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "13"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "14"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "17"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", "18"}], "}"}]}], "}"}]], "Output",
 ImageSize->{531, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30448]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"StringTake", "[", 
    RowBox[{"\"\<AABBBAABABBCCCBAAA\>\"", ",", "#"}], "]"}], "&"}], "/@", 
  "%"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24473],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"AA\"\>", ",", "\<\"BB\"\>", ",", "\<\"BB\"\>", 
   ",", "\<\"AA\"\>", ",", "\<\"BB\"\>", ",", "\<\"CC\"\>", ",", "\<\"CC\"\>",
    ",", "\<\"AA\"\>", ",", "\<\"AA\"\>"}], "}"}]], "Output",
 ImageSize->{234, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->11164]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringCases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringCases"]], "InlineFormula"],
 " by default excludes overlaps:"
}], "ExampleText",
 CellID->15690],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<AABBBAABABBCCCBAAA\>\"", ",", 
   RowBox[{"x_", "~~", "x_"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->20496],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"AA\"\>", ",", "\<\"BB\"\>", ",", "\<\"AA\"\>", 
   ",", "\<\"BB\"\>", ",", "\<\"CC\"\>", ",", "\<\"AA\"\>"}], "}"}]], "Output",\

 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1406]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<AABBBAABABBCCCBAAA\>\"", ",", 
   RowBox[{"x_", "~~", "x_"}], ",", 
   RowBox[{"Overlaps", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->3168],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"AA\"\>", ",", "\<\"BB\"\>", ",", "\<\"BB\"\>", 
   ",", "\<\"AA\"\>", ",", "\<\"BB\"\>", ",", "\<\"CC\"\>", ",", "\<\"CC\"\>",
    ",", "\<\"AA\"\>", ",", "\<\"AA\"\>"}], "}"}]], "Output",
 ImageSize->{234, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->28903]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19388],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["StringReplacePart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringReplacePart"]], "InlineFormula"],
 " to replace at positions found by ",
 Cell[BoxData[
  ButtonBox["StringPosition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringPosition"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1581],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringPosition", "[", 
  RowBox[{"\"\<abXYZaaabXYZaaaaXYZXYZ\>\"", ",", "\"\<XYZ\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2431],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", "19"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"20", ",", "22"}], "}"}]}], "}"}]], "Output",
 ImageSize->{251, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27976]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplacePart", "[", 
  RowBox[{"\"\<abXYZaaabXYZaaaaXYZXYZ\>\"", ",", "\"\<--\>\"", ",", "%"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10144],

Cell[BoxData["\<\"ab--aaab--aaaa----\"\>"], "Output",
 ImageSize->{130, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->31406]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8625],

Cell[TextData[{
 "Lists of string patterns in ",
 Cell[BoxData[
  ButtonBox["StringPosition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringPosition"]], "InlineFormula"],
 " are sometimes not the same as pattern alternatives:"
}], "ExampleText",
 CellID->6357],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringPosition", "[", 
  RowBox[{"\"\<AAAA\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"x__", ",", "\"\<A\>\""}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18641],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4"}], "}"}]}], "}"}]], "Output",
 ImageSize->{410, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10969]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringPosition", "[", 
  RowBox[{"\"\<AAAA\>\"", ",", 
   RowBox[{"StringExpression", "[", 
    RowBox[{"{", 
     RowBox[{"x__", ",", "\"\<A\>\""}], "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->22589],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4"}], "}"}]}], "}"}]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->6474]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringPosition", "[", 
  RowBox[{"\"\<AAAA\>\"", ",", 
   RowBox[{"x__", "|", "\"\<A\>\""}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->28520],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4"}], "}"}]}], "}"}]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->619]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->10922],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Position",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Position"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringCases",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringCases"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringCount",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringCount"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Characters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Characters"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReplaceList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReplaceList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringExpression"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RegularExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RegularExpression"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringDrop",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringDrop"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringInsert",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringInsert"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringTake",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringTake"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19330]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->30256],

Cell[TextData[ButtonBox["Operations on Strings",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OperationsOnStrings"]], "Tutorials",
 CellID->6593],

Cell[TextData[ButtonBox["Special Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SpecialCharacters-StringsAndCharacters"]], "Tutorials",
 CellID->336637905],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StringPatterns"]], "Tutorials",
 CellID->8153],

Cell[TextData[ButtonBox["Working with String Patterns",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/WorkingWithStringPatternsOverview"]], "Tutorials",
 CellID->22514736]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->59765173],

Cell[TextData[ButtonBox["String Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringManipulation"]], "MoreAbout",
 CellID->684026271],

Cell[TextData[ButtonBox["String Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringOperations"]], "MoreAbout",
 CellID->92020505]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
StringPosition"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 2  |  Last modified in 5.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"StringPosition - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 24, 32.8916346}", "context" -> "System`", 
    "keywords" -> {
     "index of substring", "position of substring", "search for substrings", 
      "searching for characters"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "StringPosition[\"string\", \" sub\"] gives a list of the starting and \
ending character positions at which \" sub\" appears as a substring of \" \
string\". StringPosition[\"string\", patt] gives all positions at which \
substrings matching the general string expression patt appear in \" string\". \
StringPosition[\"string\", patt, n] includes only the first n occurrences of \
patt. StringPosition[\"string\", {patt_1, patt_2, ...}] gives positions of \
all the patt_i. StringPosition[{s_1, s_2, ...}, p] gives the list of results \
for each of the s_i. ", "synonyms" -> {"string position"}, "title" -> 
    "StringPosition", "type" -> "Symbol", "uri" -> "ref/StringPosition"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[12139, 380, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->322419329]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 52068, 1850}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3528, 75, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4151, 102, 52, 1, 70, "ObjectName",
 CellID->26469],
Cell[4206, 105, 3521, 108, 70, "Usage",
 CellID->11644]
}, Open  ]],
Cell[CellGroupData[{
Cell[7764, 218, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8242, 235, 335, 11, 70, "Notes",
 CellID->2244],
Cell[8580, 248, 860, 30, 70, "Notes",
 CellID->9136],
Cell[9443, 280, 772, 27, 70, "Notes",
 CellID->27728],
Cell[10218, 309, 601, 21, 70, "Notes",
 CellID->10037],
Cell[10822, 332, 745, 26, 70, "Notes",
 CellID->21864],
Cell[11570, 360, 532, 15, 70, "Notes",
 CellID->5792]
}, Closed]],
Cell[CellGroupData[{
Cell[12139, 380, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->322419329],
Cell[CellGroupData[{
Cell[12524, 394, 148, 5, 70, "ExampleSection",
 CellID->215748048],
Cell[12675, 401, 116, 3, 70, "ExampleText",
 CellID->474],
Cell[CellGroupData[{
Cell[12816, 408, 170, 5, 28, "Input",
 CellID->3499],
Cell[12989, 415, 422, 15, 36, "Output",
 CellID->24573]
}, Open  ]],
Cell[13426, 433, 121, 3, 70, "ExampleDelimiter",
 CellID->25453],
Cell[13550, 438, 89, 1, 70, "ExampleText",
 CellID->5849],
Cell[CellGroupData[{
Cell[13664, 443, 181, 5, 70, "Input",
 CellID->31888],
Cell[13848, 450, 721, 25, 36, "Output",
 CellID->24555]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14618, 481, 215, 7, 70, "ExampleSection",
 CellID->4632],
Cell[14836, 490, 424, 13, 70, "ExampleText",
 CellID->11232],
Cell[CellGroupData[{
Cell[15285, 507, 152, 4, 70, "Input",
 CellID->14611],
Cell[15440, 513, 223, 8, 36, "Output",
 CellID->23434]
}, Open  ]],
Cell[CellGroupData[{
Cell[15700, 526, 187, 6, 70, "Input",
 CellID->18660],
Cell[15890, 534, 164, 5, 36, "Output",
 CellID->10693]
}, Open  ]],
Cell[16069, 542, 121, 3, 70, "ExampleDelimiter",
 CellID->22211],
Cell[16193, 547, 88, 1, 70, "ExampleText",
 CellID->16791],
Cell[CellGroupData[{
Cell[16306, 552, 181, 5, 70, "Input",
 CellID->18847],
Cell[16490, 559, 223, 8, 36, "Output",
 CellID->15915]
}, Open  ]],
Cell[16728, 570, 121, 3, 70, "ExampleDelimiter",
 CellID->18442],
Cell[16852, 575, 262, 8, 70, "ExampleText",
 CellID->2967],
Cell[CellGroupData[{
Cell[17139, 587, 149, 4, 70, "Input",
 CellID->5732],
Cell[17291, 593, 416, 15, 36, "Output",
 CellID->19154]
}, Open  ]],
Cell[17722, 611, 308, 12, 70, "ExampleText",
 CellID->28536],
Cell[CellGroupData[{
Cell[18055, 627, 196, 5, 70, "Input",
 CellID->14950],
Cell[18254, 634, 298, 11, 36, "Output",
 CellID->29418]
}, Open  ]],
Cell[18567, 648, 121, 3, 70, "ExampleDelimiter",
 CellID->29089],
Cell[CellGroupData[{
Cell[18713, 655, 216, 6, 70, "Input",
 CellID->24613],
Cell[18932, 663, 417, 15, 36, "Output",
 CellID->27213]
}, Open  ]],
Cell[CellGroupData[{
Cell[19386, 683, 262, 7, 70, "Input",
 CellID->18859],
Cell[19651, 692, 298, 11, 36, "Output",
 CellID->30014]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19998, 709, 218, 7, 70, "ExampleSection",
 CellID->22578],
Cell[CellGroupData[{
Cell[20241, 720, 275, 8, 70, "ExampleSubsection",
 CellID->27717],
Cell[20519, 730, 64, 1, 70, "ExampleText",
 CellID->2011],
Cell[CellGroupData[{
Cell[20608, 735, 195, 5, 70, "Input",
 CellID->10009],
Cell[20806, 742, 298, 11, 36, "Output",
 CellID->18187]
}, Open  ]],
Cell[21119, 756, 66, 1, 70, "ExampleText",
 CellID->13088],
Cell[CellGroupData[{
Cell[21210, 761, 196, 5, 70, "Input",
 CellID->31827],
Cell[21409, 768, 223, 8, 36, "Output",
 CellID->25817]
}, Open  ]],
Cell[21647, 779, 121, 3, 70, "ExampleDelimiter",
 CellID->22937],
Cell[21771, 784, 98, 2, 70, "ExampleText",
 CellID->16465],
Cell[CellGroupData[{
Cell[21894, 790, 225, 6, 70, "Input",
 CellID->3445],
Cell[22122, 798, 479, 17, 36, "Output",
 CellID->29073]
}, Open  ]],
Cell[CellGroupData[{
Cell[22638, 820, 227, 6, 70, "Input",
 CellID->13394],
Cell[22868, 828, 223, 8, 36, "Output",
 CellID->27070]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23140, 842, 225, 7, 70, "ExampleSubsection",
 CellID->19962],
Cell[23368, 851, 215, 7, 70, "ExampleText",
 CellID->31647],
Cell[CellGroupData[{
Cell[23608, 862, 180, 5, 70, "Input",
 CellID->3715],
Cell[23791, 869, 720, 25, 36, "Output",
 CellID->8336]
}, Open  ]],
Cell[CellGroupData[{
Cell[24548, 899, 227, 6, 70, "Input",
 CellID->28587],
Cell[24778, 907, 538, 19, 36, "Output",
 CellID->583]
}, Open  ]],
Cell[25331, 929, 121, 3, 70, "ExampleDelimiter",
 CellID->23445],
Cell[25455, 934, 310, 9, 70, "ExampleText",
 CellID->10615],
Cell[CellGroupData[{
Cell[25790, 947, 142, 4, 70, "Input",
 CellID->19168],
Cell[25935, 953, 416, 15, 36, "Output",
 CellID->15403]
}, Open  ]],
Cell[26366, 971, 312, 12, 70, "ExampleText",
 CellID->17317],
Cell[CellGroupData[{
Cell[26703, 987, 186, 5, 70, "Input",
 CellID->18255],
Cell[26892, 994, 770, 27, 36, "Output",
 CellID->10617]
}, Open  ]],
Cell[CellGroupData[{
Cell[27699, 1026, 199, 6, 70, "Input",
 CellID->18741],
Cell[27901, 1034, 652, 23, 36, "Output",
 CellID->11848]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[28614, 1064, 223, 7, 70, "ExampleSection",
 CellID->11631],
Cell[28840, 1073, 120, 3, 70, "ExampleText",
 CellID->29510],
Cell[CellGroupData[{
Cell[28985, 1080, 229, 8, 70, "Input",
 CellID->11403],
Cell[29217, 1090, 229, 7, 36, "Output",
 CellID->8788]
}, Open  ]],
Cell[CellGroupData[{
Cell[29483, 1102, 186, 6, 70, "Input",
 CellID->22109],
Cell[29672, 1110, 544, 12, 54, "Output",
 CellID->19329]
}, Open  ]],
Cell[CellGroupData[{
Cell[30253, 1127, 99, 3, 70, "Input",
 CellID->1032],
Cell[30355, 1132, 1096, 23, 166, "Output",
 CellID->28557]
}, Open  ]],
Cell[31466, 1158, 74, 1, 70, "ExampleText",
 CellID->5860],
Cell[CellGroupData[{
Cell[31565, 1163, 423, 13, 70, "Input",
 CellID->10140],
Cell[31991, 1178, 2400, 44, 70, "Output",
 Evaluatable->False,
 CellID->107728854]
}, Open  ]],
Cell[34406, 1225, 120, 3, 70, "ExampleDelimiter",
 CellID->7041],
Cell[34529, 1230, 117, 3, 70, "ExampleText",
 CellID->26470],
Cell[34649, 1235, 178, 6, 70, "Input",
 CellID->17214],
Cell[CellGroupData[{
Cell[34852, 1245, 263, 7, 70, "Input",
 CellID->15058],
Cell[35118, 1254, 1956, 36, 70, "Output",
 Evaluatable->False,
 CellID->651926626]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[37123, 1296, 233, 7, 70, "ExampleSection",
 CellID->22387],
Cell[37359, 1305, 354, 13, 70, "ExampleText",
 CellID->5512],
Cell[CellGroupData[{
Cell[37738, 1322, 180, 5, 70, "Input",
 CellID->8675],
Cell[37921, 1329, 721, 25, 36, "Output",
 CellID->30448]
}, Open  ]],
Cell[CellGroupData[{
Cell[38679, 1359, 198, 7, 70, "Input",
 CellID->24473],
Cell[38880, 1368, 359, 9, 36, "Output",
 CellID->11164]
}, Open  ]],
Cell[39254, 1380, 209, 7, 70, "ExampleText",
 CellID->15690],
Cell[CellGroupData[{
Cell[39488, 1391, 178, 5, 70, "Input",
 CellID->20496],
Cell[39669, 1398, 299, 9, 36, "Output",
 CellID->1406]
}, Open  ]],
Cell[CellGroupData[{
Cell[40005, 1412, 222, 6, 70, "Input",
 CellID->3168],
Cell[40230, 1420, 359, 9, 36, "Output",
 CellID->28903]
}, Open  ]],
Cell[40604, 1432, 121, 3, 70, "ExampleDelimiter",
 CellID->19388],
Cell[40728, 1437, 370, 13, 70, "ExampleText",
 CellID->1581],
Cell[CellGroupData[{
Cell[41123, 1454, 170, 5, 70, "Input",
 CellID->2431],
Cell[41296, 1461, 422, 15, 36, "Output",
 CellID->27976]
}, Open  ]],
Cell[CellGroupData[{
Cell[41755, 1481, 183, 5, 70, "Input",
 CellID->10144],
Cell[41941, 1488, 180, 5, 36, "Output",
 CellID->31406]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[42170, 1499, 225, 7, 70, "ExampleSection",
 CellID->8625],
Cell[42398, 1508, 269, 8, 70, "ExampleText",
 CellID->6357],
Cell[CellGroupData[{
Cell[42692, 1520, 199, 6, 70, "Input",
 CellID->18641],
Cell[42894, 1528, 652, 23, 36, "Output",
 CellID->10969]
}, Open  ]],
Cell[CellGroupData[{
Cell[43583, 1556, 245, 7, 70, "Input",
 CellID->22589],
Cell[43831, 1565, 415, 15, 36, "Output",
 CellID->6474]
}, Open  ]],
Cell[CellGroupData[{
Cell[44283, 1585, 174, 5, 70, "Input",
 CellID->28520],
Cell[44460, 1592, 414, 15, 36, "Output",
 CellID->619]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[44935, 1614, 311, 9, 70, "SeeAlsoSection",
 CellID->10922],
Cell[45249, 1625, 2728, 98, 70, "SeeAlso",
 CellID->19330]
}, Open  ]],
Cell[CellGroupData[{
Cell[48014, 1728, 314, 9, 70, "TutorialsSection",
 CellID->30256],
Cell[48331, 1739, 150, 3, 70, "Tutorials",
 CellID->6593],
Cell[48484, 1744, 174, 4, 70, "Tutorials",
 CellID->336637905],
Cell[48661, 1750, 139, 3, 70, "Tutorials",
 CellID->8153],
Cell[48803, 1755, 178, 4, 70, "Tutorials",
 CellID->22514736]
}, Open  ]],
Cell[CellGroupData[{
Cell[49018, 1764, 318, 9, 70, "MoreAboutSection",
 CellID->59765173],
Cell[49339, 1775, 149, 3, 70, "MoreAbout",
 CellID->684026271],
Cell[49491, 1780, 144, 3, 70, "MoreAbout",
 CellID->92020505]
}, Open  ]],
Cell[CellGroupData[{
Cell[49672, 1788, 305, 8, 70, "RelatedLinksSection"],
Cell[49980, 1798, 392, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[50387, 1814, 52, 0, 70, "History"],
Cell[50442, 1816, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

