(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     50022,       1784]
NotebookOptionsPosition[     38887,       1406]
NotebookOutlinePosition[     40690,       1451]
CellTagsIndexPosition[     40604,       1446]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Operations on Strings" :> 
          Documentation`HelpLookup["paclet:tutorial/OperationsOnStrings"], 
          "Special Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SpecialCharacters-StringsAndCharacters"], 
          "String Patterns" :> 
          Documentation`HelpLookup["paclet:tutorial/StringPatterns"], 
          "Working with String Patterns" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/WorkingWithStringPatternsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Operations on Strings\"\>", 
       2->"\<\"Special Characters\"\>", 3->"\<\"String Patterns\"\>", 
       4->"\<\"Working with String Patterns\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Replace" :> Documentation`HelpLookup["paclet:ref/Replace"], 
          "StringReplaceList" :> 
          Documentation`HelpLookup["paclet:ref/StringReplaceList"], 
          "StringReplacePart" :> 
          Documentation`HelpLookup["paclet:ref/StringReplacePart"], 
          "StringPosition" :> 
          Documentation`HelpLookup["paclet:ref/StringPosition"], 
          "StringSplit" :> Documentation`HelpLookup["paclet:ref/StringSplit"],
           "ToLowerCase" :> 
          Documentation`HelpLookup["paclet:ref/ToLowerCase"], "ToUpperCase" :> 
          Documentation`HelpLookup["paclet:ref/ToUpperCase"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Replace\"\>", 
       2->"\<\"StringReplaceList\"\>", 3->"\<\"StringReplacePart\"\>", 
       4->"\<\"StringPosition\"\>", 5->"\<\"StringSplit\"\>", 
       6->"\<\"ToLowerCase\"\>", 
       7->"\<\"ToUpperCase\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Computational Systems" :> 
          Documentation`HelpLookup[
           "paclet:guide/ComputationalSystemsAndDiscovery"], 
          "Language Overview" :> 
          Documentation`HelpLookup["paclet:guide/LanguageOverview"], 
          "String Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/StringManipulation"], 
          "String Operations" :> 
          Documentation`HelpLookup["paclet:guide/StringOperations"], 
          "String Patterns" :> 
          Documentation`HelpLookup["paclet:guide/StringPatterns"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Computational Systems\"\>", 
       2->"\<\"Language Overview\"\>", 3->"\<\"String Manipulation\"\>", 
       4->"\<\"String Operations\"\>", 
       5->"\<\"String Patterns\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["StringReplace", "ObjectName",
 CellID->18694],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringReplace",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringReplace"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", 
        RowBox[{
         StyleBox["s", "TI"], "->", 
         StyleBox["sp", "TI"]}]}], "]"}]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringReplace",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringReplace"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SubscriptBox[
            StyleBox["s", "TI"], 
            StyleBox["1", "TR"]], "->", 
           SubscriptBox[
            StyleBox["sp", "TI"], 
            StyleBox["1", "TR"]]}], ",", 
          RowBox[{
           SubscriptBox[
            StyleBox["s", "TI"], 
            StyleBox["2", "TR"]], "->", 
           SubscriptBox[
            StyleBox["sp", "TI"], 
            StyleBox["2", "TR"]]}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]",
     "replaces the string expressions ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " by ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["sp", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " whenever they appear as substrings of ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\""], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringReplace",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringReplace"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", 
        StyleBox["srules", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]does only the first ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " replacements. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringReplace",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringReplace"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["s", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["s", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["srules", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the list of results for each of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->17800]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The string expressions ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["s", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " can contain any of the objects specified in the notes for ",
 Cell[BoxData[
  ButtonBox["StringExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringExpression"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->8866],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringReplace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringReplace"]], "InlineFormula"],
 " goes through a string, testing substrings that start at each successive \
character position. On each substring, it tries in turn each of the \
transformation rules you have specified. If any of the rules apply, it \
replaces the substring, then continues to go through the string, starting at \
the character position after the end of the substring. "
}], "Notes",
 CellID->9640],

Cell[TextData[{
 "If the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["sp", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " in the replacements ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["s", "TI"], 
    StyleBox["i", "TI"]], "->", 
   SubscriptBox[
    StyleBox["sp", "TI"], 
    StyleBox["i", "TI"]]}]], "InlineFormula"],
 " do not evaluate to strings, ",
 Cell[BoxData[
  ButtonBox["StringReplace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringReplace"]], "InlineFormula"],
 " will yield a ",
 Cell[BoxData[
  ButtonBox["StringExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringExpression"]], "InlineFormula"],
 " rather than an ordinary string. "
}], "Notes",
 CellID->22283],

Cell[TextData[{
 "In replacements of the form ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["s", "TI"], 
    StyleBox["i", "TI"]], ":>", 
   SubscriptBox[
    StyleBox["sp", "TI"], 
    StyleBox["i", "TI"]]}]], "InlineFormula"],
 ", the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["sp", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are not evaluated until each time they are used. "
}], "Notes",
 CellID->14129],

Cell[TextData[{
 "Setting the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["IgnoreCase",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IgnoreCase"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " makes ",
 Cell[BoxData[
  ButtonBox["StringReplace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringReplace"]], "InlineFormula"],
 " treat lower\[Hyphen] and uppercase letters as equivalent. "
}], "Notes",
 CellID->3774]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->459621257],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->400124020],

Cell["Replace every occurrence of ab with X:", "ExampleText",
 CellID->19697],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<abbaabbaa\>\"", ",", 
   RowBox[{"\"\<ab\>\"", "->", "\"\<X\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17158],

Cell[BoxData["\<\"XbaXbaa\"\>"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22381]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->145194517],

Cell["\<\
Replace every substring that has one or more occurrences of ab with X:\
\>", "ExampleText",
 CellID->245396748],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<ababbabbaaababa\>\"", ",", 
   RowBox[{
    RowBox[{"\"\<ab\>\"", ".."}], "\[Rule]", "\"\<X\>\""}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->262865778],

Cell[BoxData["\<\"XbXbaaXa\"\>"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->364941273]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(9)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5133],

Cell["Use string patterns: ", "ExampleText",
 CellID->374228497],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<abc abcb abdc\>\"", ",", 
   RowBox[{
    RowBox[{"\"\<ab\>\"", "~~", "_"}], "->", "\"\<X\>\""}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->1826230663],

Cell[BoxData["\<\"X Xb Xc\"\>"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1775445147]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<abc abcd abcd\>\"", ",", 
   RowBox[{
    RowBox[{"WordBoundary", "~~", "\"\<abc\>\"", "~~", "WordBoundary"}], 
    "->", "\"\<XX\>\""}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->390705797],

Cell[BoxData["\<\"XX abcd abcd\"\>"], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{88, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->281169239]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1113608023],

Cell["Use a regular expression: ", "ExampleText",
 CellID->1090058956],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<abcd acbd\>\"", ",", 
   RowBox[{
    RowBox[{"RegularExpression", "[", "\"\<[ab]\>\"", "]"}], "->", 
    "\"\<XX\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1298182474],

Cell[BoxData["\<\"XXXXcd XXcXXd\"\>"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1920704676]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->67055197],

Cell["Use pattern matching for dates:", "ExampleText",
 CellID->1715264951],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<abc 31/12/2003 abcd 5/3/2004 abc\>\"", ",", 
   RowBox[{
    RowBox[{"DatePattern", "[", 
     RowBox[{"{", 
      RowBox[{"\"\<Day\>\"", ",", "\"\<Month\>\"", ",", "\"\<Year\>\""}], 
      "}"}], "]"}], "\[Rule]", "\"\<XX\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->253314834],

Cell[BoxData["\<\"abc XX abcd XX abc\"\>"], "Output",
 ImageSize->{130, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->311061730]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1770421952],

Cell["Mixed regular expressions and string patterns:", "ExampleText",
 CellID->2095818079],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<abcd acbd\>\"", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"RegularExpression", "[", "\"\<[ab]\>\"", "]"}], "~~", "_"}], 
    "->", "\"\<YY\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1387675659],

Cell[BoxData["\<\"YYcd YYYY\"\>"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->309307828]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->165073553],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["RuleDelayed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RuleDelayed"]], "InlineFormula"],
 " (",
 Cell[BoxData[":>"], "InlineFormula"],
 ") in order to evaluate the right-hand side of a rule:"
}], "ExampleText",
 CellID->122202055],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<101abcd102abcd\>\"", ",", 
   RowBox[{
    RowBox[{"a", ":", 
     RowBox[{"DigitCharacter", ".."}]}], "\[RuleDelayed]", 
    RowBox[{"ToString", "[", 
     RowBox[{
      RowBox[{"ToExpression", "[", "a", "]"}], "^", "2"}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->140043252],

Cell[BoxData["\<\"10201abcd10404abcd\"\>"], "Output",
 ImageSize->{130, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->66620806]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1763751877],

Cell["\<\
Replace only the two first occurrences that match the given pattern:\
\>", "ExampleText",
 CellID->1661017198],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<abcddbbcbbbacbbaa\>\"", ",", 
   RowBox[{"\"\<bb\>\"", " ", "\[Rule]", " ", "\"\<X\>\""}], ",", "2"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1576119433],

Cell[BoxData["\<\"abcddXcXbacbbaa\"\>"], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1182161623]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->319981946],

Cell["Replace occurrences of either string:", "ExampleText",
 CellID->637514334],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<abcdabcdaabcabcd\>\"", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<abc\>\"", "->", "\"\<Y\>\""}], ",", 
     RowBox[{"\"\<d\>\"", "->", "\"\<XXX\>\""}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->72950628],

Cell[BoxData["\<\"YXXXYXXXaYYXXX\"\>"], "Output",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1485123921]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->77647193],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringReplace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringReplace"]], "InlineFormula"],
 " works on special characters:"
}], "ExampleText",
 CellID->1493799022],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<product: A \[CirclePlus] B\>\"", " ", ",", 
   RowBox[{"\"\<\[CirclePlus]\>\"", "->", "\"\<x\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->48845677],

Cell[BoxData["\<\"product: A x B\"\>"], "Output",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->847863338]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->91998220],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringReplace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringReplace"]], "InlineFormula"],
 " automatically threads over lists of strings:"
}], "ExampleText",
 CellID->25857700],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "\"\<aaabbbbaaaa\>\"", ",", "\"\<bbbaaaab\>\"", ",", "\"\<aaabab\>\""}], 
    "}"}], ",", 
   RowBox[{"\"\<ab\>\"", "->", "\"\<X\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->466931959],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"aaXbbbaaaa\"\>", ",", "\<\"bbbaaaX\"\>", ",", "\<\"aaXX\"\>"}],
   "}"}]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->820188775]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3291],

Cell["Replacements can be nonstrings:", "ExampleText",
 CellID->1752981053],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{
  "\"\<Expand %1 variables %13 to nonstring %a expressions %27\>\"", ",", 
   RowBox[{
    RowBox[{"\"\<%\>\"", "~~", 
     RowBox[{"x", ":", 
      RowBox[{"DigitCharacter", ".."}]}]}], "\[RuleDelayed]", 
    RowBox[{"Var", "[", 
     RowBox[{"ToExpression", "[", "x", "]"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->791344447],

Cell[BoxData[
 RowBox[{"\<\"Expand \"\>", "~~", 
  RowBox[{"Var", "[", "1", "]"}], "~~", "\<\" variables \"\>", "~~", 
  RowBox[{"Var", "[", "13", "]"}], 
  "~~", "\<\" to nonstring %a expressions \"\>", "~~", 
  RowBox[{"Var", "[", "27", "]"}]}]], "Output",
 ImageSize->{578, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20619101]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->575837583],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "IgnoreCase",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->24938],

Cell["This replaces all occurrences regardless of case:", "ExampleText",
 CellID->129700036],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<The cat in the hat.\>\"", ",", 
   RowBox[{"\"\<the\>\"", "->", "\"\<a\>\""}], ",", 
   RowBox[{"IgnoreCase", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->172603347],

Cell[BoxData["\<\"a cat in a hat.\"\>"], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->215275605]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23037],

Cell["Remove leading and trailing spaces:", "ExampleText",
 CellID->1344027195],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StringReplace", "[", 
   RowBox[{"\"\<  Have a nice day.  \>\"", ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"StartOfString", " ", "~~", "Whitespace"}], ")"}], " ", "|", 
      " ", 
      RowBox[{"(", 
       RowBox[{"Whitespace", " ", "~~", " ", "EndOfString"}], ")"}]}], " ", 
     "\[Rule]", " ", "\"\<\>\""}]}], "]"}], "//", "FullForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->213711451],

Cell[BoxData[
 TagBox[
  StyleBox["\"\<Have a nice day.\>\"",
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{130, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//FullForm=",
 CellID->8847605]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1114433110],

Cell["Remove comments in a text:", "ExampleText",
 CellID->2072394283],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<this (*comment1*) is a test (*comment2*)\>\"", ",", 
   RowBox[{
    RowBox[{"\"\<(*\>\"", "~~", 
     RowBox[{"ShortestMatch", "[", "___", "]"}], "~~", "\"\<*)\>\""}], 
    "\[Rule]", "\"\<\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->419941087],

Cell[BoxData["\<\"this  is a test \"\>"], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->369575898]
}, Open  ]],

Cell["Extract comments from a text: ", "ExampleText",
 CellID->123672173],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<this (*comment1*) is a test (*comment2*)\>\"", ",", 
   RowBox[{"\"\<(*\>\"", "~~", 
    RowBox[{"ShortestMatch", "[", "___", "]"}], "~~", "\"\<*)\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->633009461],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"(*comment1*)\"\>", ",", "\<\"(*comment2*)\"\>"}], 
  "}"}]], "Output",
 ImageSize->{198, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->398675438]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->549729183],

Cell["Strip off all tags \"<...>\" from an HTML document:", "ExampleText",
 CellID->1449975572],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", "\n", "  ", 
  RowBox[{
  "\"\<<title>The Title</title>\n<h1>The <a href='link'>head</a></h1>\n\
<p>Some text follows here...</p>\>\"", ",", 
   RowBox[{
    RowBox[{"\"\<<\>\"", "~~", 
     RowBox[{
      RowBox[{"Except", "[", "\"\<>\>\"", "]"}], ".."}], "~~", "\"\<>\>\""}], 
    "\[Rule]", "\"\<\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->95012448],

Cell[BoxData["\<\"The Title\\nThe head\\nSome text follows here...\"\>"], \
"Output",
 ImageSize->{179, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->80010044]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1970553648],

Cell["Capitalize all words in a sentence:", "ExampleText",
 CellID->602357902],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<this is a test\>\"", ",", 
   RowBox[{
    RowBox[{"WordBoundary", "~~", "x_"}], "\[RuleDelayed]", 
    RowBox[{"ToUpperCase", "[", "x", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->215211332],

Cell[BoxData["\<\"This Is A Test\"\>"], "Output",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1924992106]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->757243602],

Cell["Change the date convention in a text:", "ExampleText",
 CellID->601375449],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<abc 31/12/2003 abcd 5/3/2004 abc\>\"", ",", 
   RowBox[{
    RowBox[{"a", ":", 
     RowBox[{"DatePattern", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<Day\>\"", ",", "\"\<Month\>\"", ",", "\"\<Year\>\""}], 
       "}"}], "]"}]}], "\[RuleDelayed]", 
    RowBox[{"DateString", "[", 
     RowBox[{
      RowBox[{"DateList", "[", 
       RowBox[{"{", 
        RowBox[{"a", ",", 
         RowBox[{"{", 
          RowBox[{"\"\<Day\>\"", ",", "\"\<Month\>\"", ",", "\"\<Year\>\""}], 
          "}"}]}], "}"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "\"\<Year\>\"", ",", "\"\</\>\"", ",", "\"\<Month\>\"", ",", 
        "\"\</\>\"", ",", "\"\<Day\>\""}], "}"}]}], "]"}]}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->192342579],

Cell[BoxData["\<\"abc 2003/12/31 abcd 2004/03/05 abc\"\>"], "Output",
 ImageSize->{242, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->591719983]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1276946634],

Cell["Identify prime numbers in a text:", "ExampleText",
 CellID->1746379321],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{
  "\"\<I have 13 licenses: 6 front end licenses and 7 kernel licenses\>\"", 
   ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"WordBoundary", "~~", 
      RowBox[{
       RowBox[{"x", ":", 
        RowBox[{"DigitCharacter", ".."}]}], "~~", "WordBoundary"}]}], "/;", 
     RowBox[{"PrimeQ", "[", 
      RowBox[{"ToExpression", "[", "x", "]"}], "]"}]}], "\[RuleDelayed]", 
    "\[IndentingNewLine]", 
    RowBox[{"\"\<*\>\"", "<>", "x", "<>", "\"\<*\>\""}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1837993167],

Cell[BoxData["\<\"I have *13* licenses: 6 front end licenses and *7* kernel \
licenses\"\>"], "Output",
 ImageSize->{466, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->59305242]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->43004693],

Cell["A neighbor-independent substitution system:", "ExampleText",
 CellID->1042320813],

Cell[BoxData[
 RowBox[{
  RowBox[{"ssevolveList", "[", 
   RowBox[{"rule_", ",", "init_String", ",", "t_Integer"}], "]"}], ":=", 
  RowBox[{"NestList", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"StringReplace", "[", 
      RowBox[{"#", ",", "rule"}], "]"}], "&"}], ",", "init", ",", "t"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->423045483],

Cell["Five steps in the evolution:", "ExampleText",
 CellID->1833394156],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ssevolveList", "[", " ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<B\>\"", "\[Rule]", "\"\<BA\>\""}], ",", 
     RowBox[{"\"\<A\>\"", "\[Rule]", "\"\<AB\>\""}]}], "}"}], ",", 
   "\"\<B\>\"", ",", "5"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1954561211],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"B\"\>", ",", "\<\"BA\"\>", ",", "\<\"BAAB\"\>", 
   ",", "\<\"BAABABBA\"\>", ",", "\<\"BAABABBAABBABAAB\"\>", 
   ",", "\<\"BAABABBAABBABAABABBABAABBAABABBA\"\>"}], "}"}]], "Output",
 ImageSize->{515, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->518926880]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30809],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringPosition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringPosition"]], "InlineFormula"],
 " gives the starting and ending positions at which a pattern occurs:"
}], "ExampleText",
 CellID->1738538047],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringPosition", "[", 
  RowBox[{"\"\<abbaabbaa\>\"", ",", "\"\<ab\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->946454847],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6"}], "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6069877]
}, Open  ]],

Cell[TextData[{
 "The output can be used with ",
 Cell[BoxData[
  ButtonBox["StringReplacePart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringReplacePart"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->368395012],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplacePart", "[", 
  RowBox[{"\"\<abbaabbaa\>\"", ",", "\"\<X\>\"", ",", "%"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->325899584],

Cell[BoxData["\<\"XbaXbaa\"\>"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->288595016]
}, Open  ]],

Cell["Same result:", "ExampleText",
 CellID->160732880],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<abbaabbaa\>\"", ",", 
   RowBox[{"\"\<ab\>\"", "->", "\"\<X\>\""}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->936599246],

Cell[BoxData["\<\"XbaXbaa\"\>"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->545030632]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3917],

Cell[TextData[{
 "Highlight words of a given length in a text excerpt from the book ",
 StyleBox["A New Kind of Science",
  FontSlant->"Italic"],
 ":"
}], "ExampleText",
 CellID->1950956836],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "text", "=", 
   "\"\<Just over twenty years ago I made what at first seemed like a small \
discovery: a computer experiment of mine showed something I did not expect. \
But the more I investigated, the more I realized that what I had seen was the \
beginning of a crack in the very foundations of existing science, and a first \
clue towards a whole new kind of science. This book is the culmination of \
nearly twenty years of work that I have done to develop that new kind of \
science. I had never expected it would take anything like as long, but I have \
discovered vastly more than I ever thought possible, and in fact what I have \
done now touches almost every existing area of science, and quite a bit \
besides.\>\""}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->634263797],

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"StringReplace", "[", 
    RowBox[{"text", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"RegularExpression", "[", 
        RowBox[{"\"\<\\\\b\\\\w{\>\"", "<>", 
         RowBox[{"ToString", "[", 
          RowBox[{"Round", "[", "u", "]"}], "]"}], "<>", "\"\<}\\\\b\>\""}], 
        "]"}], "\[RuleDelayed]", 
       "\"\<\\!\\(\\*StyleBox[\\\"$0\\\",FontSize->18,FontWeight->\\\"Bold\\\"\
]\\)\>\""}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "1", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2054425021]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->32623],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Replace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Replace"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringReplaceList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringReplaceList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringReplacePart",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringReplacePart"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringPosition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringPosition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringSplit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringSplit"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToLowerCase",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToLowerCase"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToUpperCase",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToUpperCase"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23130]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->24908],

Cell[TextData[ButtonBox["Operations on Strings",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OperationsOnStrings"]], "Tutorials",
 CellID->23156],

Cell[TextData[ButtonBox["Special Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SpecialCharacters-StringsAndCharacters"]], "Tutorials",
 CellID->336637905],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StringPatterns"]], "Tutorials",
 CellID->8153],

Cell[TextData[ButtonBox["Working with String Patterns",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/WorkingWithStringPatternsOverview"]], "Tutorials",
 CellID->22514736]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->383890938],

Cell[TextData[ButtonBox["Computational Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ComputationalSystemsAndDiscovery"]], "MoreAbout",
 CellID->547907474],

Cell[TextData[ButtonBox["Language Overview",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LanguageOverview"]], "MoreAbout",
 CellID->223061442],

Cell[TextData[ButtonBox["String Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringManipulation"]], "MoreAbout",
 CellID->555487145],

Cell[TextData[ButtonBox["String Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringOperations"]], "MoreAbout",
 CellID->147278460],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringPatterns"]], "MoreAbout",
 CellID->517130493]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
StringReplace"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 2  |  Last modified in 5.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"StringReplace - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 24, 38.6417818}", "context" -> "System`", 
    "keywords" -> {
     "editing of strings", "production rules", "replace substring", 
      "replacement of characters", "replacements of substrings", 
      "ReplaceString", "rewriting of strings", 
      "sequential substitution systems", "substitution in strings", 
      "translation of strings"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "StringReplace[\"string\", s -> sp] or StringReplace[\"string\", {s_1 -> \
sp_1, s_2 -> sp_2, ...}] replaces the string expressions s_i by sp_i whenever \
they appear as substrings of \" string\". StringReplace[\"string\", srules, \
n] does only the first n replacements. StringReplace[{s_1, s_2, ...}, srules] \
gives the list of results for each of the s_i. ", 
    "synonyms" -> {"string replace"}, "title" -> "StringReplace", "type" -> 
    "Symbol", "uri" -> "ref/StringReplace"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10419, 325, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->459621257]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 40460, 1439}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3564, 78, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4187, 105, 51, 1, 70, "ObjectName",
 CellID->18694],
Cell[4241, 108, 3047, 97, 70, "Usage",
 CellID->17800]
}, Open  ]],
Cell[CellGroupData[{
Cell[7325, 210, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7803, 227, 376, 13, 70, "Notes",
 CellID->8866],
Cell[8182, 242, 528, 11, 70, "Notes",
 CellID->9640],
Cell[8713, 255, 730, 27, 70, "Notes",
 CellID->22283],
Cell[9446, 284, 436, 17, 70, "Notes",
 CellID->14129],
Cell[9885, 303, 497, 17, 70, "Notes",
 CellID->3774]
}, Closed]],
Cell[CellGroupData[{
Cell[10419, 325, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->459621257],
Cell[CellGroupData[{
Cell[10804, 339, 148, 5, 70, "ExampleSection",
 CellID->400124020],
Cell[10955, 346, 77, 1, 70, "ExampleText",
 CellID->19697],
Cell[CellGroupData[{
Cell[11057, 351, 186, 5, 28, "Input",
 CellID->17158],
Cell[11246, 358, 168, 5, 36, "Output",
 CellID->22381]
}, Open  ]],
Cell[11429, 366, 125, 3, 70, "ExampleDelimiter",
 CellID->145194517],
Cell[11557, 371, 121, 3, 70, "ExampleText",
 CellID->245396748],
Cell[CellGroupData[{
Cell[11703, 378, 224, 7, 70, "Input",
 CellID->262865778],
Cell[11930, 387, 173, 5, 36, "Output",
 CellID->364941273]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12152, 398, 215, 7, 70, "ExampleSection",
 CellID->5133],
Cell[12370, 407, 64, 1, 70, "ExampleText",
 CellID->374228497],
Cell[CellGroupData[{
Cell[12459, 412, 223, 7, 70, "Input",
 CellID->1826230663],
Cell[12685, 421, 173, 5, 36, "Output",
 CellID->1775445147]
}, Open  ]],
Cell[CellGroupData[{
Cell[12895, 431, 260, 7, 70, "Input",
 CellID->390705797],
Cell[13158, 440, 227, 7, 36, "Output",
 CellID->281169239]
}, Open  ]],
Cell[13400, 450, 126, 3, 70, "ExampleDelimiter",
 CellID->1113608023],
Cell[13529, 455, 70, 1, 70, "ExampleText",
 CellID->1090058956],
Cell[CellGroupData[{
Cell[13624, 460, 245, 7, 70, "Input",
 CellID->1298182474],
Cell[13872, 469, 179, 5, 36, "Output",
 CellID->1920704676]
}, Open  ]],
Cell[14066, 477, 124, 3, 70, "ExampleDelimiter",
 CellID->67055197],
Cell[14193, 482, 75, 1, 70, "ExampleText",
 CellID->1715264951],
Cell[CellGroupData[{
Cell[14293, 487, 353, 9, 70, "Input",
 CellID->253314834],
Cell[14649, 498, 184, 5, 36, "Output",
 CellID->311061730]
}, Open  ]],
Cell[14848, 506, 126, 3, 70, "ExampleDelimiter",
 CellID->1770421952],
Cell[14977, 511, 90, 1, 70, "ExampleText",
 CellID->2095818079],
Cell[CellGroupData[{
Cell[15092, 516, 272, 8, 70, "Input",
 CellID->1387675659],
Cell[15367, 526, 174, 5, 36, "Output",
 CellID->309307828]
}, Open  ]],
Cell[15556, 534, 125, 3, 70, "ExampleDelimiter",
 CellID->165073553],
Cell[15684, 539, 291, 10, 70, "ExampleText",
 CellID->122202055],
Cell[CellGroupData[{
Cell[16000, 553, 359, 11, 70, "Input",
 CellID->140043252],
Cell[16362, 566, 183, 5, 36, "Output",
 CellID->66620806]
}, Open  ]],
Cell[16560, 574, 126, 3, 70, "ExampleDelimiter",
 CellID->1763751877],
Cell[16689, 579, 120, 3, 70, "ExampleText",
 CellID->1661017198],
Cell[CellGroupData[{
Cell[16834, 586, 227, 6, 70, "Input",
 CellID->1576119433],
Cell[17064, 594, 182, 5, 36, "Output",
 CellID->1182161623]
}, Open  ]],
Cell[17261, 602, 125, 3, 70, "ExampleDelimiter",
 CellID->319981946],
Cell[17389, 607, 80, 1, 70, "ExampleText",
 CellID->637514334],
Cell[CellGroupData[{
Cell[17494, 612, 293, 8, 70, "Input",
 CellID->72950628],
Cell[17790, 622, 181, 5, 36, "Output",
 CellID->1485123921]
}, Open  ]],
Cell[17986, 630, 124, 3, 70, "ExampleDelimiter",
 CellID->77647193],
Cell[18113, 635, 217, 7, 70, "ExampleText",
 CellID->1493799022],
Cell[CellGroupData[{
Cell[18355, 646, 222, 5, 70, "Input",
 CellID->48845677],
Cell[18580, 653, 180, 5, 36, "Output",
 CellID->847863338]
}, Open  ]],
Cell[18775, 661, 124, 3, 70, "ExampleDelimiter",
 CellID->91998220],
Cell[18902, 666, 231, 7, 70, "ExampleText",
 CellID->25857700],
Cell[CellGroupData[{
Cell[19158, 677, 289, 9, 70, "Input",
 CellID->466931959],
Cell[19450, 688, 259, 8, 36, "Output",
 CellID->820188775]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19758, 702, 238, 7, 70, "ExampleSection",
 CellID->3291],
Cell[19999, 711, 75, 1, 70, "ExampleText",
 CellID->1752981053],
Cell[CellGroupData[{
Cell[20099, 716, 404, 11, 70, "Input",
 CellID->791344447],
Cell[20506, 729, 388, 10, 36, "Output",
 CellID->20619101]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20943, 745, 222, 7, 70, "ExampleSection",
 CellID->575837583],
Cell[CellGroupData[{
Cell[21190, 756, 227, 7, 70, "ExampleSubsection",
 CellID->24938],
Cell[21420, 765, 92, 1, 70, "ExampleText",
 CellID->129700036],
Cell[CellGroupData[{
Cell[21537, 770, 248, 6, 70, "Input",
 CellID->172603347],
Cell[21788, 778, 181, 5, 36, "Output",
 CellID->215275605]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[22030, 790, 223, 7, 70, "ExampleSection",
 CellID->23037],
Cell[22256, 799, 79, 1, 70, "ExampleText",
 CellID->1344027195],
Cell[CellGroupData[{
Cell[22360, 804, 460, 13, 70, "Input",
 CellID->213711451],
Cell[22823, 819, 311, 11, 50, "Output",
 CellID->8847605]
}, Open  ]],
Cell[23149, 833, 126, 3, 70, "ExampleDelimiter",
 CellID->1114433110],
Cell[23278, 838, 70, 1, 70, "ExampleText",
 CellID->2072394283],
Cell[CellGroupData[{
Cell[23373, 843, 321, 8, 70, "Input",
 CellID->419941087],
Cell[23697, 853, 182, 5, 36, "Output",
 CellID->369575898]
}, Open  ]],
Cell[23894, 861, 73, 1, 70, "ExampleText",
 CellID->123672173],
Cell[CellGroupData[{
Cell[23992, 866, 278, 7, 70, "Input",
 CellID->633009461],
Cell[24273, 875, 245, 8, 36, "Output",
 CellID->398675438]
}, Open  ]],
Cell[24533, 886, 125, 3, 70, "ExampleDelimiter",
 CellID->549729183],
Cell[24661, 891, 95, 1, 70, "ExampleText",
 CellID->1449975572],
Cell[CellGroupData[{
Cell[24781, 896, 413, 11, 70, "Input",
 CellID->95012448],
Cell[25197, 909, 215, 6, 71, "Output",
 CellID->80010044]
}, Open  ]],
Cell[25427, 918, 126, 3, 70, "ExampleDelimiter",
 CellID->1970553648],
Cell[25556, 923, 78, 1, 70, "ExampleText",
 CellID->602357902],
Cell[CellGroupData[{
Cell[25659, 928, 268, 7, 70, "Input",
 CellID->215211332],
Cell[25930, 937, 181, 5, 36, "Output",
 CellID->1924992106]
}, Open  ]],
Cell[26126, 945, 125, 3, 70, "ExampleDelimiter",
 CellID->757243602],
Cell[26254, 950, 80, 1, 70, "ExampleText",
 CellID->601375449],
Cell[CellGroupData[{
Cell[26359, 955, 809, 23, 70, "Input",
 CellID->192342579],
Cell[27171, 980, 200, 5, 36, "Output",
 CellID->591719983]
}, Open  ]],
Cell[27386, 988, 126, 3, 70, "ExampleDelimiter",
 CellID->1276946634],
Cell[27515, 993, 77, 1, 70, "ExampleText",
 CellID->1746379321],
Cell[CellGroupData[{
Cell[27617, 998, 598, 16, 70, "Input",
 CellID->1837993167],
Cell[28218, 1016, 233, 6, 36, "Output",
 CellID->59305242]
}, Open  ]],
Cell[28466, 1025, 124, 3, 70, "ExampleDelimiter",
 CellID->43004693],
Cell[28593, 1030, 87, 1, 70, "ExampleText",
 CellID->1042320813],
Cell[28683, 1033, 357, 11, 70, "Input",
 CellID->423045483],
Cell[29043, 1046, 72, 1, 70, "ExampleText",
 CellID->1833394156],
Cell[CellGroupData[{
Cell[29140, 1051, 306, 9, 70, "Input",
 CellID->1954561211],
Cell[29449, 1062, 357, 9, 36, "Output",
 CellID->518926880]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[29855, 1077, 233, 7, 70, "ExampleSection",
 CellID->30809],
Cell[30091, 1086, 257, 7, 70, "ExampleText",
 CellID->1738538047],
Cell[CellGroupData[{
Cell[30373, 1097, 158, 4, 70, "Input",
 CellID->946454847],
Cell[30534, 1103, 300, 11, 36, "Output",
 CellID->6069877]
}, Open  ]],
Cell[30849, 1117, 229, 8, 70, "ExampleText",
 CellID->368395012],
Cell[CellGroupData[{
Cell[31103, 1129, 170, 4, 70, "Input",
 CellID->325899584],
Cell[31276, 1135, 172, 5, 36, "Output",
 CellID->288595016]
}, Open  ]],
Cell[31463, 1143, 55, 1, 70, "ExampleText",
 CellID->160732880],
Cell[CellGroupData[{
Cell[31543, 1148, 190, 5, 70, "Input",
 CellID->936599246],
Cell[31736, 1155, 172, 5, 36, "Output",
 CellID->545030632]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[31957, 1166, 223, 7, 70, "ExampleSection",
 CellID->3917],
Cell[32183, 1175, 190, 6, 70, "ExampleText",
 CellID->1950956836],
Cell[32376, 1183, 827, 15, 70, "Input",
 CellID->634263797],
Cell[33206, 1200, 624, 17, 70, "Input",
 CellID->2054425021]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[33879, 1223, 311, 9, 70, "SeeAlsoSection",
 CellID->32623],
Cell[34193, 1234, 1740, 62, 70, "SeeAlso",
 CellID->23130]
}, Open  ]],
Cell[CellGroupData[{
Cell[35970, 1301, 314, 9, 70, "TutorialsSection",
 CellID->24908],
Cell[36287, 1312, 151, 3, 70, "Tutorials",
 CellID->23156],
Cell[36441, 1317, 174, 4, 70, "Tutorials",
 CellID->336637905],
Cell[36618, 1323, 139, 3, 70, "Tutorials",
 CellID->8153],
Cell[36760, 1328, 178, 4, 70, "Tutorials",
 CellID->22514736]
}, Open  ]],
Cell[CellGroupData[{
Cell[36975, 1337, 319, 9, 70, "MoreAboutSection",
 CellID->383890938],
Cell[37297, 1348, 165, 3, 70, "MoreAbout",
 CellID->547907474],
Cell[37465, 1353, 145, 3, 70, "MoreAbout",
 CellID->223061442],
Cell[37613, 1358, 149, 3, 70, "MoreAbout",
 CellID->555487145],
Cell[37765, 1363, 145, 3, 70, "MoreAbout",
 CellID->147278460],
Cell[37913, 1368, 141, 3, 70, "MoreAbout",
 CellID->517130493]
}, Open  ]],
Cell[CellGroupData[{
Cell[38091, 1376, 305, 8, 70, "RelatedLinksSection"],
Cell[38399, 1386, 391, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[38805, 1402, 52, 0, 70, "History"],
Cell[38860, 1404, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

