(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     40267,       1430]
NotebookOptionsPosition[     31255,       1125]
NotebookOutlinePosition[     33467,       1183]
CellTagsIndexPosition[     33344,       1177]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Operations on Strings" :> 
          Documentation`HelpLookup["paclet:tutorial/OperationsOnStrings"], 
          "Special Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SpecialCharacters-StringsAndCharacters"], 
          "String Patterns" :> 
          Documentation`HelpLookup["paclet:tutorial/StringPatterns"], 
          "Working with String Patterns" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/WorkingWithStringPatternsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Operations on Strings\"\>", 
       2->"\<\"Special Characters\"\>", 3->"\<\"String Patterns\"\>", 
       4->"\<\"Working with String Patterns\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"StringReplace" :> 
          Documentation`HelpLookup["paclet:ref/StringReplace"], "ReplaceList" :> 
          Documentation`HelpLookup["paclet:ref/ReplaceList"], "StringCases" :> 
          Documentation`HelpLookup["paclet:ref/StringCases"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"StringReplace\"\>", 
       2->"\<\"ReplaceList\"\>", 
       3->"\<\"StringCases\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Computational Systems" :> 
          Documentation`HelpLookup[
           "paclet:guide/ComputationalSystemsAndDiscovery"], 
          "Discrete Mathematics" :> 
          Documentation`HelpLookup["paclet:guide/DiscreteMathematics"], 
          "String Operations" :> 
          Documentation`HelpLookup["paclet:guide/StringOperations"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Computational Systems\"\>", 
       2->"\<\"Discrete Mathematics\"\>", 
       3->"\<\"String Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["StringReplaceList", "ObjectName",
 CellID->7548],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringReplaceList",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringReplaceList"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", 
        RowBox[{
         StyleBox["s", "TI"], "->", 
         StyleBox["sp", "TI"]}]}], "]"}]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringReplaceList",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringReplaceList"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SubscriptBox[
            StyleBox["s", "TI"], 
            StyleBox["1", "TR"]], "->", 
           SubscriptBox[
            StyleBox["sp", "TI"], 
            StyleBox["1", "TR"]]}], ",", 
          RowBox[{
           SubscriptBox[
            StyleBox["s", "TI"], 
            StyleBox["2", "TR"]], "->", 
           SubscriptBox[
            StyleBox["sp", "TI"], 
            StyleBox["2", "TR"]]}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of the strings obtained by replacing each \
individual occurrence of substrings in ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\""], "InlineFormula"],
     " matching the string expressions ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringReplaceList",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringReplaceList"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", 
        StyleBox["srules", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of the first ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " results obtained. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringReplaceList",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringReplaceList"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["s", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["s", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["srules", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the list of results for each of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->21477]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The string expressions ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["s", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " can contain any of the objects specified in the notes for ",
 Cell[BoxData[
  ButtonBox["StringExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringExpression"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->4858],

Cell[TextData[{
 "In each of the results returned by ",
 Cell[BoxData[
  ButtonBox["StringReplaceList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringReplaceList"]], "InlineFormula"],
 " only one substring has been replaced. "
}], "Notes",
 CellID->1598],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringReplaceList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringReplaceList"]], "InlineFormula"],
 " goes through a string, testing substrings that start at each successive \
character position. On each substring, it tries in turn each of the \
transformation rules you have specified, returning a result for each one that \
applies. "
}], "Notes",
 CellID->21659],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringReplaceList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringReplaceList"]], "InlineFormula"],
 " in effect carries out a single step in the evolution of a multiway system. \
"
}], "Notes",
 CellID->1019],

Cell[TextData[{
 "If the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["sp", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " in the replacements ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["s", "TI"], 
    StyleBox["i", "TI"]], "->", 
   SubscriptBox[
    StyleBox["sp", "TI"], 
    StyleBox["i", "TI"]]}]], "InlineFormula"],
 " do not evaluate to strings, ",
 Cell[BoxData[
  ButtonBox["StringReplaceList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringReplaceList"]], "InlineFormula"],
 " will yield a ",
 Cell[BoxData[
  ButtonBox["StringExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringExpression"]], "InlineFormula"],
 " rather than an ordinary string. "
}], "Notes",
 CellID->11682],

Cell[TextData[{
 "In replacements of the form ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["s", "TI"], 
    StyleBox["i", "TI"]], ":>", 
   SubscriptBox[
    StyleBox["sp", "TI"], 
    StyleBox["i", "TI"]]}]], "InlineFormula"],
 ", the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["sp", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are not evaluated until each time they are used. "
}], "Notes",
 CellID->13253],

Cell[TextData[{
 "Setting the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["IgnoreCase",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IgnoreCase"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " makes ",
 Cell[BoxData[
  ButtonBox["StringReplaceList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringReplaceList"]], "InlineFormula"],
 " treat lowercase and uppercase letters as equivalent. "
}], "Notes",
 CellID->22723]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->17742710],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->418551822],

Cell[TextData[{
 "Make replacements for ",
 Cell[BoxData["c"], "InlineFormula"],
 " in all possible ways:"
}], "ExampleText",
 CellID->22039],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplaceList", "[", 
  RowBox[{"\"\<ccccc\>\"", ",", 
   RowBox[{"\"\<c\>\"", "->", "\"\<XYX\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18878],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"XYXcccc\"\>", ",", "\<\"cXYXccc\"\>", ",", "\<\"ccXYXcc\"\>", 
   ",", "\<\"cccXYXc\"\>", ",", "\<\"ccccXYX\"\>"}], "}"}]], "Output",
 ImageSize->{308, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20627]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30117],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplaceList", "[", 
  RowBox[{"\"\<abcdeabacde\>\"", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<abc\>\"", "->", "\"\<X\>\""}], ",", 
     RowBox[{"\"\<cde\>\"", "->", "\"\<Y\>\""}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31984],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Xdeabacde\"\>", ",", "\<\"abYabacde\"\>", 
   ",", "\<\"abcdeabaY\"\>"}], "}"}]], "Output",
 ImageSize->{230, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23031]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(9)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->271380759],

Cell["Use string patterns: ", "ExampleText",
 CellID->374228497],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplaceList", "[", 
  RowBox[{"\"\<ababababab\>\"", ",", 
   RowBox[{
    RowBox[{"_", "~~", "\"\<ab\>\"", "~~", "_"}], "->", "\"\<X\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->512462380],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"aXbabab\"\>", ",", "\<\"abaXbab\"\>", ",", "\<\"ababaXb\"\>"}],
   "}"}]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->95259741]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->208875988],

Cell["Use a regular expression: ", "ExampleText",
 CellID->1090058956],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplaceList", "[", 
  RowBox[{"\"\<abcd acbd\>\"", ",", 
   RowBox[{
    RowBox[{"RegularExpression", "[", "\"\<[ab]\>\"", "]"}], "->", 
    "\"\<XX\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1298182474],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"XXbcd acbd\"\>", ",", "\<\"aXXcd acbd\"\>", 
   ",", "\<\"abcd XXcbd\"\>", ",", "\<\"abcd acXXd\"\>"}], "}"}]], "Output",
 ImageSize->{332, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->754457149]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->186115057],

Cell["Use pattern matching for dates:", "ExampleText",
 CellID->1715264951],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplaceList", "[", 
  RowBox[{"\"\<date:31/12/2003\>\"", ",", 
   RowBox[{
    RowBox[{"DatePattern", "[", 
     RowBox[{"{", 
      RowBox[{"\"\<Day\>\"", ",", "\"\<Month\>\"", ",", "\"\<Year\>\""}], 
      "}"}], "]"}], "\[Rule]", "\"\<XX\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->253314834],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"date:XX\"\>", ",", "\<\"date:XX03\"\>", 
   ",", "\<\"date:3XX\"\>", ",", "\<\"date:3XX03\"\>"}], "}"}]], "Output",
 ImageSize->{290, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1624723799]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->76846693],

Cell["Mixed regular expressions and string patterns:", "ExampleText",
 CellID->2095818079],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplaceList", "[", 
  RowBox[{"\"\<abcd acbd\>\"", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"RegularExpression", "[", "\"\<[ab]\>\"", "]"}], "~~", "_"}], 
    "->", "\"\<YY\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1387675659],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"YYcd acbd\"\>", ",", "\<\"aYYd acbd\"\>", 
   ",", "\<\"abcd YYbd\"\>", ",", "\<\"abcd acYY\"\>"}], "}"}]], "Output",
 ImageSize->{304, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1974481152]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->770522486],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["RuleDelayed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RuleDelayed"]], "InlineFormula"],
 " (:>) in order to evaluate the right-hand side of a rule:"
}], "ExampleText",
 CellID->122202055],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplaceList", "[", 
  RowBox[{"\"\<101abcd102abcd\>\"", ",", 
   RowBox[{
    RowBox[{"a", ":", 
     RowBox[{"DigitCharacter", ".."}]}], "\[RuleDelayed]", 
    RowBox[{"ToString", "[", 
     RowBox[{
      RowBox[{"ToExpression", "[", "a", "]"}], "^", "2"}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->140043252],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"10201abcd102abcd\"\>", ",", "\<\"1001abcd102abcd\"\>", 
   ",", "\<\"101abcd102abcd\"\>", ",", "\<\"11abcd102abcd\"\>", 
   ",", "\<\"101abcd102abcd\"\>", ",", "\<\"101abcd102abcd\"\>", 
   ",", "\<\"101abcd10404abcd\"\>", ",", "\<\"101abcd1002abcd\"\>", 
   ",", "\<\"101abcd102abcd\"\>", ",", "\<\"101abcd14abcd\"\>", 
   ",", "\<\"101abcd102abcd\"\>", ",", "\<\"101abcd104abcd\"\>"}], 
  "}"}]], "Output",
 ImageSize->{465, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->39924573]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17040659],

Cell["Generate at most two possible results:", "ExampleText",
 CellID->386692200],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplaceList", "[", 
  RowBox[{"\"\<abcddbbcbbbacbbaa\>\"", ",", 
   RowBox[{"\"\<bb\>\"", " ", "\[Rule]", " ", "\"\<X\>\""}], ",", "2"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1576119433],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"abcddXcbbbacbbaa\"\>", ",", "\<\"abcddbbcXbacbbaa\"\>"}], 
  "}"}]], "Output",
 ImageSize->{254, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1814976136]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6487447],

Cell["Replace occurrences of either string:", "ExampleText",
 CellID->637514334],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplaceList", "[", 
  RowBox[{"\"\<abcdabcdaabcabcd\>\"", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<abc\>\"", "->", "\"\<Y\>\""}], ",", 
     RowBox[{"\"\<d\>\"", "->", "\"\<XXX\>\""}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->72950628],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Ydabcdaabcabcd\"\>", ",", "\<\"abcXXXabcdaabcabcd\"\>", 
   ",", "\<\"abcdYdaabcabcd\"\>", ",", "\<\"abcdabcXXXaabcabcd\"\>", 
   ",", "\<\"abcdabcdaYabcd\"\>", ",", "\<\"abcdabcdaabcYd\"\>", 
   ",", "\<\"abcdabcdaabcabcXXX\"\>"}], "}"}]], "Output",
 ImageSize->{500, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1446195764]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->50425971],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringReplaceList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringReplaceList"]], "InlineFormula"],
 " works on special characters:"
}], "ExampleText",
 CellID->1493799022],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplaceList", "[", 
  RowBox[{"\"\<product: A \[CirclePlus] (B \[CirclePlus] C)\>\"", " ", ",", 
   RowBox[{"\"\<\[CirclePlus]\>\"", "->", "\"\<x\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->48845677],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"product: A x (B \[CirclePlus] C)\"\>", 
   ",", "\<\"product: A \[CirclePlus] (B x C)\"\>"}], "}"}]], "Output",
 ImageSize->{310, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2030947293]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->162734278],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringReplaceList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringReplaceList"]], "InlineFormula"],
 " automatically threads over lists of strings:"
}], "ExampleText",
 CellID->25857700],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplaceList", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "\"\<aaabbbbaaaa\>\"", ",", "\"\<bbbaaaab\>\"", ",", "\"\<aaabab\>\""}], 
    "}"}], ",", 
   RowBox[{"\"\<ab\>\"", "->", "\"\<X\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->466931959],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "\<\"aaXbbbaaaa\"\>", "}"}], ",", 
   RowBox[{"{", "\<\"bbbaaaX\"\>", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"aaXab\"\>", ",", "\<\"aaabX\"\>"}], "}"}]}], "}"}]], "Output",\

 ImageSize->{283, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2026068033]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->513359362],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "IgnoreCase",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->69636850],

Cell[TextData[{
 "Make replacements for ",
 Cell[BoxData["c"], "InlineFormula"],
 " in all possible ways, including uppercase letters:"
}], "ExampleText",
 CellID->47174695],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplaceList", "[", 
  RowBox[{"\"\<ccbbCbcc\>\"", ",", 
   RowBox[{"\"\<c\>\"", "\[Rule]", " ", "\"\<X\>\""}], ",", 
   RowBox[{"IgnoreCase", "\[Rule]", " ", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16081783],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"XcbbCbcc\"\>", ",", "\<\"cXbbCbcc\"\>", 
   ",", "\<\"ccbbXbcc\"\>", ",", "\<\"ccbbCbXc\"\>", 
   ",", "\<\"ccbbCbcX\"\>"}], "}"}]], "Output",
 ImageSize->{343, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11418646]
}, Open  ]],

Cell["\<\
There are fewer results when taking case sensitivity into account:\
\>", "ExampleText",
 CellID->539794927],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplaceList", "[", 
  RowBox[{"\"\<ccbCbcc\>\"", ",", " ", 
   RowBox[{"\"\<c\>\"", "\[Rule]", " ", "\"\<X\>\""}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->354803753],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"XcbCbcc\"\>", ",", "\<\"cXbCbcc\"\>", ",", "\<\"ccbCbXc\"\>", 
   ",", "\<\"ccbCbcX\"\>"}], "}"}]], "Output",
 ImageSize->{248, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->219302113]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7045],

Cell[TextData[{
 "Five steps in the evolution of the Fibonacci multiway system ",
 ButtonBox["[more info]:",
  BaseStyle->"NKSLink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/page-205"], None}]
}], "ExampleText",
 CellID->30255],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Union", "[", 
     RowBox[{"Flatten", "[", 
      RowBox[{"StringReplaceList", "[", 
       RowBox[{"#", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<A\>\"", "->", "\"\<AB\>\""}], ",", 
          RowBox[{"\"\<B\>\"", "->", "\"\<A\>\""}]}], "}"}]}], "]"}], "]"}], 
     "]"}], "&"}], ",", 
   RowBox[{"{", "\"\<A\>\"", "}"}], ",", "5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15676],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "\<\"A\"\>", "}"}], ",", 
   RowBox[{"{", "\<\"AB\"\>", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"AA\"\>", ",", "\<\"ABB\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"AAB\"\>", ",", "\<\"ABA\"\>", ",", "\<\"ABBB\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"AAA\"\>", ",", "\<\"AABB\"\>", ",", "\<\"ABAB\"\>", 
     ",", "\<\"ABBA\"\>", ",", "\<\"ABBBB\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"AAAB\"\>", ",", "\<\"AABA\"\>", ",", "\<\"AABBB\"\>", 
     ",", "\<\"ABAA\"\>", ",", "\<\"ABABB\"\>", ",", "\<\"ABBAB\"\>", 
     ",", "\<\"ABBBA\"\>", ",", "\<\"ABBBBB\"\>"}], "}"}]}], "}"}]], "Output",\

 ImageSize->{478, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->505459546]
}, Open  ]],

Cell["Two steps in the evolution of another multiway system:", "ExampleText",
 CellID->20378],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Union", "[", 
     RowBox[{"Flatten", "[", 
      RowBox[{"StringReplaceList", "[", 
       RowBox[{"#", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<AB\>\"", "\[Rule]", "\"\<ABBA\>\""}], ",", 
          RowBox[{"\"\<ABB\>\"", "\[Rule]", "\"\<\>\""}]}], "}"}]}], "]"}], 
      "]"}], "]"}], "&"}], ",", 
   RowBox[{"{", "\"\<ABBAAB\>\"", "}"}], ",", "2"}], "]"}]], "Input",
 CellTags->"StringReplaceList",
 CellLabel->"In[2]:=",
 CellID->25934],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "\<\"ABBAAB\"\>", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"AAB\"\>", ",", "\<\"ABBAABBA\"\>", ",", "\<\"ABBABAAB\"\>"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"AABBA\"\>", ",", "\<\"ABAAB\"\>", ",", "\<\"ABBAA\"\>", 
     ",", "\<\"ABBAABBABA\"\>", ",", "\<\"ABBABAABBA\"\>", 
     ",", "\<\"ABBABABAAB\"\>", ",", "\<\"ABBABBAAAB\"\>"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{485, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"StringReplaceList",
 CellLabel->"Out[2]=",
 CellID->55361635]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20340],

Cell[TextData[{
 "All possible replacements of the form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["axy\[Ellipsis]za", "TI"], " ", "\[LongRightArrow]", " ", 
   StyleBox["aXY\[Ellipsis]Za", "TI"]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->9410],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplaceList", "[", 
  RowBox[{"\"\<abcaaba\>\"", ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"\"\<a\>\"", "~~", "x___", "~~", "\"\<a\>\""}], ")"}], 
    "\[RuleDelayed]", 
    RowBox[{"ToUpperCase", "[", "x", "]"}]}]}], "]"}]], "Input",
 CellTags->"StringReplaceList",
 CellLabel->"In[1]:=",
 CellID->13046],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"BCAAB\"\>", ",", "\<\"BCAba\"\>", ",", "\<\"BCaba\"\>", 
   ",", "\<\"abcAB\"\>", ",", "\<\"abcba\"\>", ",", "\<\"abcaB\"\>"}], 
  "}"}]], "Output",
 ImageSize->{284, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"StringReplaceList",
 CellLabel->"Out[1]= ",
 CellID->6640]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->561098012],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringReplaceList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringReplaceList"]], "InlineFormula"],
 " yields a ",
 Cell[BoxData[
  ButtonBox["StringExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringExpression"]], "InlineFormula"],
 " if the rule does not have a string result:"
}], "ExampleText",
 CellID->64021917],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplaceList", "[", 
  RowBox[{"\"\<abc\>\"", ",", 
   RowBox[{"\"\<c\>\"", "\[Rule]", " ", "a"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->135361789],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"ab\"\>", "~~", "a"}], "}"}]], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->630415046]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1043365066],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"List", "[", 
    RowBox[{"StringExpression", "[", 
     RowBox[{"\"\<ab\>\"", ",", "a"}], "]"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{219, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm=",
 CellID->559760099]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->4100],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringReplace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringReplace"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReplaceList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReplaceList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringCases",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringCases"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23125]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->16772],

Cell[TextData[ButtonBox["Operations on Strings",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OperationsOnStrings"]], "Tutorials",
 CellID->17982],

Cell[TextData[ButtonBox["Special Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SpecialCharacters-StringsAndCharacters"]], "Tutorials",
 CellID->336637905],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StringPatterns"]], "Tutorials",
 CellID->8153],

Cell[TextData[ButtonBox["Working with String Patterns",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/WorkingWithStringPatternsOverview"]], "Tutorials",
 CellID->22514736]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->37378976],

Cell[TextData[ButtonBox["Computational Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ComputationalSystemsAndDiscovery"]], "MoreAbout",
 CellID->85682334],

Cell[TextData[ButtonBox["Discrete Mathematics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteMathematics"]], "MoreAbout",
 CellID->18402009],

Cell[TextData[ButtonBox["String Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringOperations"]], "MoreAbout",
 CellID->109981942]
}, Open  ]],

Cell["New in 5.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"StringReplaceList - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 24, 38.2355214}", "context" -> "System`", 
    "keywords" -> {
     "multiple string replacements", "multiway systems", 
      "replace part of string", "replace substring", "string replace", 
      "string substitution"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "StringReplaceList[\"string\", s -> sp] or StringReplaceList[\"string\", \
{s_1 -> sp_1, s_2 -> sp_2, ...}] gives a list of the strings obtained by \
replacing each individual occurrence of substrings in \" string\" matching \
the string expressions s_i. StringReplaceList[\"string\", srules, n] gives a \
list of the first n results obtained. StringReplaceList[{s_1, s_2, ...}, \
srules] gives the list of results for each of the s_i. ", 
    "synonyms" -> {"string replace list"}, "title" -> "StringReplaceList", 
    "type" -> "Symbol", "uri" -> "ref/StringReplaceList"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10046, 325, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->17742710]},
 "StringReplaceList"->{
  Cell[24349, 863, 545, 16, 70, "Input",
   CellTags->"StringReplaceList",
   CellID->25934],
  Cell[24897, 881, 604, 17, 54, "Output",
   CellTags->"StringReplaceList",
   CellID->55361635],
  Cell[25919, 918, 342, 10, 70, "Input",
   CellTags->"StringReplaceList",
   CellID->13046],
  Cell[26264, 930, 351, 10, 36, "Output",
   CellTags->"StringReplaceList",
   CellID->6640]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 32796, 1157},
 {"StringReplaceList", 32940, 1161}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2793, 64, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3416, 91, 54, 1, 70, "ObjectName",
 CellID->7548],
Cell[3473, 94, 3008, 92, 70, "Usage",
 CellID->21477]
}, Open  ]],
Cell[CellGroupData[{
Cell[6518, 191, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6996, 208, 376, 13, 70, "Notes",
 CellID->4858],
Cell[7375, 223, 263, 8, 70, "Notes",
 CellID->1598],
Cell[7641, 233, 419, 10, 70, "Notes",
 CellID->21659],
Cell[8063, 245, 262, 8, 70, "Notes",
 CellID->1019],
Cell[8328, 255, 738, 27, 70, "Notes",
 CellID->11682],
Cell[9069, 284, 436, 17, 70, "Notes",
 CellID->13253],
Cell[9508, 303, 501, 17, 70, "Notes",
 CellID->22723]
}, Closed]],
Cell[CellGroupData[{
Cell[10046, 325, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->17742710],
Cell[CellGroupData[{
Cell[10430, 339, 148, 5, 70, "ExampleSection",
 CellID->418551822],
Cell[10581, 346, 141, 5, 70, "ExampleText",
 CellID->22039],
Cell[CellGroupData[{
Cell[10747, 355, 187, 5, 28, "Input",
 CellID->18878],
Cell[10937, 362, 304, 8, 36, "Output",
 CellID->20627]
}, Open  ]],
Cell[11256, 373, 121, 3, 70, "ExampleDelimiter",
 CellID->30117],
Cell[CellGroupData[{
Cell[11402, 380, 289, 8, 28, "Input",
 CellID->31984],
Cell[11694, 390, 262, 8, 36, "Output",
 CellID->23031]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12005, 404, 220, 7, 70, "ExampleSection",
 CellID->271380759],
Cell[12228, 413, 64, 1, 70, "ExampleText",
 CellID->374228497],
Cell[CellGroupData[{
Cell[12317, 418, 235, 7, 70, "Input",
 CellID->512462380],
Cell[12555, 427, 258, 8, 36, "Output",
 CellID->95259741]
}, Open  ]],
Cell[12828, 438, 125, 3, 70, "ExampleDelimiter",
 CellID->208875988],
Cell[12956, 443, 70, 1, 70, "ExampleText",
 CellID->1090058956],
Cell[CellGroupData[{
Cell[13051, 448, 249, 7, 70, "Input",
 CellID->1298182474],
Cell[13303, 457, 296, 8, 36, "Output",
 CellID->754457149]
}, Open  ]],
Cell[13614, 468, 125, 3, 70, "ExampleDelimiter",
 CellID->186115057],
Cell[13742, 473, 75, 1, 70, "ExampleText",
 CellID->1715264951],
Cell[CellGroupData[{
Cell[13842, 478, 340, 9, 70, "Input",
 CellID->253314834],
Cell[14185, 489, 291, 8, 36, "Output",
 CellID->1624723799]
}, Open  ]],
Cell[14491, 500, 124, 3, 70, "ExampleDelimiter",
 CellID->76846693],
Cell[14618, 505, 90, 1, 70, "ExampleText",
 CellID->2095818079],
Cell[CellGroupData[{
Cell[14733, 510, 276, 8, 70, "Input",
 CellID->1387675659],
Cell[15012, 520, 293, 8, 36, "Output",
 CellID->1974481152]
}, Open  ]],
Cell[15320, 531, 125, 3, 70, "ExampleDelimiter",
 CellID->770522486],
Cell[15448, 536, 249, 8, 70, "ExampleText",
 CellID->122202055],
Cell[CellGroupData[{
Cell[15722, 548, 363, 11, 70, "Input",
 CellID->140043252],
Cell[16088, 561, 582, 13, 71, "Output",
 CellID->39924573]
}, Open  ]],
Cell[16685, 577, 124, 3, 70, "ExampleDelimiter",
 CellID->17040659],
Cell[16812, 582, 81, 1, 70, "ExampleText",
 CellID->386692200],
Cell[CellGroupData[{
Cell[16918, 587, 231, 6, 70, "Input",
 CellID->1576119433],
Cell[17152, 595, 254, 8, 36, "Output",
 CellID->1814976136]
}, Open  ]],
Cell[17421, 606, 123, 3, 70, "ExampleDelimiter",
 CellID->6487447],
Cell[17547, 611, 80, 1, 70, "ExampleText",
 CellID->637514334],
Cell[CellGroupData[{
Cell[17652, 616, 297, 8, 70, "Input",
 CellID->72950628],
Cell[17952, 626, 426, 10, 54, "Output",
 CellID->1446195764]
}, Open  ]],
Cell[18393, 639, 124, 3, 70, "ExampleDelimiter",
 CellID->50425971],
Cell[18520, 644, 225, 7, 70, "ExampleText",
 CellID->1493799022],
Cell[CellGroupData[{
Cell[18770, 655, 244, 5, 70, "Input",
 CellID->48845677],
Cell[19017, 662, 287, 8, 36, "Output",
 CellID->2030947293]
}, Open  ]],
Cell[19319, 673, 125, 3, 70, "ExampleDelimiter",
 CellID->162734278],
Cell[19447, 678, 239, 7, 70, "ExampleText",
 CellID->25857700],
Cell[CellGroupData[{
Cell[19711, 689, 293, 9, 70, "Input",
 CellID->466931959],
Cell[20007, 700, 369, 12, 36, "Output",
 CellID->2026068033]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20425, 718, 222, 7, 70, "ExampleSection",
 CellID->513359362],
Cell[CellGroupData[{
Cell[20672, 729, 230, 7, 70, "ExampleSubsection",
 CellID->69636850],
Cell[20905, 738, 173, 5, 70, "ExampleText",
 CellID->47174695],
Cell[CellGroupData[{
Cell[21103, 747, 258, 6, 70, "Input",
 CellID->16081783],
Cell[21364, 755, 316, 9, 36, "Output",
 CellID->11418646]
}, Open  ]],
Cell[21695, 767, 117, 3, 70, "ExampleText",
 CellID->539794927],
Cell[CellGroupData[{
Cell[21837, 774, 206, 5, 70, "Input",
 CellID->354803753],
Cell[22046, 781, 284, 8, 36, "Output",
 CellID->219302113]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[22391, 796, 222, 7, 70, "ExampleSection",
 CellID->7045],
Cell[22616, 805, 251, 7, 70, "ExampleText",
 CellID->30255],
Cell[CellGroupData[{
Cell[22892, 816, 493, 15, 70, "Input",
 CellID->15676],
Cell[23388, 833, 828, 22, 54, "Output",
 CellID->505459546]
}, Open  ]],
Cell[24231, 858, 93, 1, 70, "ExampleText",
 CellID->20378],
Cell[CellGroupData[{
Cell[24349, 863, 545, 16, 70, "Input",
 CellTags->"StringReplaceList",
 CellID->25934],
Cell[24897, 881, 604, 17, 54, "Output",
 CellTags->"StringReplaceList",
 CellID->55361635]
}, Open  ]],
Cell[25516, 901, 121, 3, 70, "ExampleDelimiter",
 CellID->20340],
Cell[25640, 906, 254, 8, 70, "ExampleText",
 CellID->9410],
Cell[CellGroupData[{
Cell[25919, 918, 342, 10, 70, "Input",
 CellTags->"StringReplaceList",
 CellID->13046],
Cell[26264, 930, 351, 10, 36, "Output",
 CellTags->"StringReplaceList",
 CellID->6640]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[26664, 946, 230, 7, 70, "ExampleSection",
 CellID->561098012],
Cell[26897, 955, 387, 12, 70, "ExampleText",
 CellID->64021917],
Cell[CellGroupData[{
Cell[27309, 971, 189, 5, 70, "Input",
 CellID->135361789],
Cell[27501, 978, 213, 7, 36, "Output",
 CellID->630415046]
}, Open  ]],
Cell[CellGroupData[{
Cell[27751, 990, 105, 3, 70, "Input",
 CellID->1043365066],
Cell[27859, 995, 402, 14, 50, "Output",
 CellID->559760099]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[28322, 1016, 310, 9, 70, "SeeAlsoSection",
 CellID->4100],
Cell[28635, 1027, 718, 26, 70, "SeeAlso",
 CellID->23125]
}, Open  ]],
Cell[CellGroupData[{
Cell[29390, 1058, 314, 9, 70, "TutorialsSection",
 CellID->16772],
Cell[29707, 1069, 151, 3, 70, "Tutorials",
 CellID->17982],
Cell[29861, 1074, 174, 4, 70, "Tutorials",
 CellID->336637905],
Cell[30038, 1080, 139, 3, 70, "Tutorials",
 CellID->8153],
Cell[30180, 1085, 178, 4, 70, "Tutorials",
 CellID->22514736]
}, Open  ]],
Cell[CellGroupData[{
Cell[30395, 1094, 318, 9, 70, "MoreAboutSection",
 CellID->37378976],
Cell[30716, 1105, 164, 3, 70, "MoreAbout",
 CellID->85682334],
Cell[30883, 1110, 150, 3, 70, "MoreAbout",
 CellID->18402009],
Cell[31036, 1115, 145, 3, 70, "MoreAbout",
 CellID->109981942]
}, Open  ]],
Cell[31196, 1121, 29, 0, 70, "History"],
Cell[31228, 1123, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

