(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20748,        765]
NotebookOptionsPosition[     15657,        584]
NotebookOutlinePosition[     16945,        620]
CellTagsIndexPosition[     16860,        615]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Operations on Strings" :> 
          Documentation`HelpLookup["paclet:tutorial/OperationsOnStrings"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Operations on Strings\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Reverse" :> Documentation`HelpLookup["paclet:ref/Reverse"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Reverse\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"String Operations" :> 
          Documentation`HelpLookup["paclet:guide/StringOperations"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"String Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["StringReverse", "ObjectName",
 CellID->4394],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringReverse",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringReverse"], "[", "\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]reverses the order of the characters in ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\""], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->988]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["StringReverse",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringReverse"], "[", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["s", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["s", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " gives the list of results for each of the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["s", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->1728]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->404904722],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->539438019],

Cell["Reverse the characters in a string:", "ExampleText",
 CellID->10310],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReverse", "[", "\"\<abcdef\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19162],

Cell[BoxData["\<\"fedcba\"\>"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->169082533]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14624],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringReverse",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringReverse"]], "InlineFormula"],
 " works on special characters:"
}], "ExampleText",
 CellID->24047],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReverse", "[", 
  "\"\<\[FilledDiamond]\[Alpha]\[Beta]\[Gamma]\[LongLeftRightArrow]\
\[ScriptCapitalA]\[ScriptCapitalB]\[ScriptCapitalC]\[ReturnIndicator]\>\"", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32493],

Cell[BoxData["\<\"\[ReturnIndicator]\[ScriptCapitalC]\[ScriptCapitalB]\
\[ScriptCapitalA]\[LongLeftRightArrow]\[Gamma]\[Beta]\[Alpha]\[FilledDiamond]\
\"\>"], "Output",
 ImageSize->{77, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23652]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1032537849],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringReverse",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringReverse"]], "InlineFormula"],
 " threads automatically over lists:"
}], "ExampleText",
 CellID->5240],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReverse", "[", 
  RowBox[{"{", 
   RowBox[{
   "\"\<cat\>\"", ",", "\"\<dog\>\"", ",", "\"\<fish\>\"", ",", 
    "\"\<coelenterate\>\""}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31864],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"tac\"\>", ",", "\<\"god\"\>", ",", "\<\"hsif\"\>", 
   ",", "\<\"etaretneleoc\"\>"}], "}"}]], "Output",
 ImageSize->{206, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22287]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20346],

Cell["Find all palindromes in the dictionary:", "ExampleText",
 CellID->2123025303],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DictionaryLookup", "[", 
  RowBox[{"x__", "/;", 
   RowBox[{"x", "===", 
    RowBox[{"StringReverse", "[", "x", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->399438762],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a\"\>", ",", "\<\"aha\"\>", ",", "\<\"aka\"\>", 
   ",", "\<\"bib\"\>", ",", "\<\"bob\"\>", ",", "\<\"boob\"\>", 
   ",", "\<\"bub\"\>", ",", "\<\"CFC\"\>", ",", "\<\"civic\"\>", 
   ",", "\<\"dad\"\>", ",", "\<\"dd\"\>", ",", "\<\"deed\"\>", 
   ",", "\<\"deified\"\>", ",", "\<\"did\"\>", ",", "\<\"dud\"\>", 
   ",", "\<\"DVD\"\>", ",", "\<\"eke\"\>", ",", "\<\"ere\"\>", 
   ",", "\<\"eve\"\>", ",", "\<\"ewe\"\>", ",", "\<\"eye\"\>", 
   ",", "\<\"gag\"\>", ",", "\<\"gig\"\>", ",", "\<\"huh\"\>", 
   ",", "\<\"I\"\>", ",", "\<\"kayak\"\>", ",", "\<\"kook\"\>", 
   ",", "\<\"level\"\>", ",", "\<\"ma'am\"\>", ",", "\<\"madam\"\>", 
   ",", "\<\"mam\"\>", ",", "\<\"MGM\"\>", ",", "\<\"minim\"\>", 
   ",", "\<\"mom\"\>", ",", "\<\"mum\"\>", ",", "\<\"nan\"\>", 
   ",", "\<\"non\"\>", ",", "\<\"noon\"\>", ",", "\<\"nun\"\>", 
   ",", "\<\"oho\"\>", ",", "\<\"pap\"\>", ",", "\<\"peep\"\>", 
   ",", "\<\"pep\"\>", ",", "\<\"pip\"\>", ",", "\<\"poop\"\>", 
   ",", "\<\"pop\"\>", ",", "\<\"pup\"\>", ",", "\<\"radar\"\>", 
   ",", "\<\"redder\"\>", ",", "\<\"refer\"\>", ",", "\<\"repaper\"\>", 
   ",", "\<\"reviver\"\>", ",", "\<\"rotor\"\>", ",", "\<\"sagas\"\>", 
   ",", "\<\"sees\"\>", ",", "\<\"seres\"\>", ",", "\<\"sexes\"\>", 
   ",", "\<\"shahs\"\>", ",", "\<\"sis\"\>", ",", "\<\"solos\"\>", 
   ",", "\<\"SOS\"\>", ",", "\<\"stats\"\>", ",", "\<\"stets\"\>", 
   ",", "\<\"tat\"\>", ",", "\<\"tenet\"\>", ",", "\<\"TNT\"\>", 
   ",", "\<\"toot\"\>", ",", "\<\"tot\"\>", ",", "\<\"tut\"\>", 
   ",", "\<\"wow\"\>", ",", "\<\"WWW\"\>"}], "}"}]], "Output",
 ImageSize->{557, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->274278]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9397],

Cell[TextData[{
 "Newline (",
 Cell[BoxData["\\n"], "InlineFormula"],
 ") counts as a single character:"
}], "ExampleText",
 CellID->27902],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReverse", "[", "\"\<abc\\ndef\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20589],

Cell[BoxData["\<\"fed\\ncba\"\>"], "Output",
 ImageSize->{25, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->115165959]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->20960],

Cell[BoxData[
 TagBox[
  StyleBox["\"\<fed\\ncba\>\"",
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm=",
 CellID->5874406]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->886873176],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringReverse",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringReverse"]], "InlineFormula"],
 " is the string equivalent of ",
 Cell[BoxData[
  ButtonBox["Reverse",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reverse"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->231862319],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReverse", "[", "\"\<abcdef\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5354934],

Cell[BoxData["\<\"fedcba\"\>"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->26520677]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringJoin", "[", 
  RowBox[{"Reverse", "[", 
   RowBox[{"Characters", "[", "\"\<abcdef\>\"", "]"}], "]"}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->35695342],

Cell[BoxData["\<\"fedcba\"\>"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->281395070]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1135149803],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringReverse",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringReverse"]], "InlineFormula"],
 " is its own inverse:"
}], "ExampleText",
 CellID->1364604515],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReverse", "[", 
  RowBox[{"StringReverse", "[", "\"\<abcdef\>\"", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->218019073],

Cell[BoxData["\<\"abcdef\"\>"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24906540]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7984],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringReverse",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringReverse"]], "InlineFormula"],
 " operates on the raw characters in a string:"
}], "ExampleText",
 CellID->26987],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReverse", "[", "\"\<\!\(\*
StyleBox[\"red\",
FontColor->RGBColor[1, 0, 0]]\)\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3902],

Cell[BoxData["\<\"\\)]]0 ,0 ,1[roloCBGR>-roloCtnoF\\n,\\\"der\\\"[xoBelytS\\n\
\\*\\(\\!\"\>"], "Output",
 ImageSize->{221, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->304044449]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "\"\<\!\(\*
StyleBox[\"red\",
FontColor->RGBColor[1, 0, 0]]\)\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->153],

Cell[BoxData[
 TagBox[
  StyleBox[
   "\"\<\\!\\(\\*\\nStyleBox[\\\"red\\\",\\nFontColor->RGBColor[1, 0, \
0]]\\)\>\"",
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{424, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm=",
 CellID->263002043]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17530],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["Reverse",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reverse"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->12752]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->29143],

Cell[TextData[ButtonBox["Operations on Strings",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OperationsOnStrings"]], "Tutorials",
 CellID->1847]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->33642836],

Cell[TextData[ButtonBox["String Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringOperations"]], "MoreAbout",
 CellID->244867935]
}, Open  ]],

Cell["New in 2  |  Last modified in 5.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"StringReverse - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 24, 39.3918010}", "context" -> "System`", 
    "keywords" -> {"palindrome", "reverse characters", "reverse strings"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "StringReverse[\"string\"] reverses the order of the characters in \" \
string\". ", "synonyms" -> {"string reverse"}, "title" -> "StringReverse", 
    "type" -> "Symbol", "uri" -> "ref/StringReverse"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4164, 143, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->404904722]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16717, 608}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1715, 45, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2338, 72, 50, 1, 70, "ObjectName",
 CellID->4394],
Cell[2391, 75, 607, 18, 70, "Usage",
 CellID->988]
}, Open  ]],
Cell[CellGroupData[{
Cell[3035, 98, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3513, 115, 614, 23, 70, "Notes",
 CellID->1728]
}, Closed]],
Cell[CellGroupData[{
Cell[4164, 143, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->404904722],
Cell[CellGroupData[{
Cell[4549, 157, 148, 5, 70, "ExampleSection",
 CellID->539438019],
Cell[4700, 164, 74, 1, 70, "ExampleText",
 CellID->10310],
Cell[CellGroupData[{
Cell[4799, 169, 118, 3, 28, "Input",
 CellID->19162],
Cell[4920, 174, 171, 5, 36, "Output",
 CellID->169082533]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5140, 185, 216, 7, 70, "ExampleSection",
 CellID->14624],
Cell[5359, 194, 212, 7, 70, "ExampleText",
 CellID->24047],
Cell[CellGroupData[{
Cell[5596, 205, 249, 6, 70, "Input",
 CellID->32493],
Cell[5848, 213, 294, 7, 36, "Output",
 CellID->23652]
}, Open  ]],
Cell[6157, 223, 126, 3, 70, "ExampleDelimiter",
 CellID->1032537849],
Cell[6286, 228, 216, 7, 70, "ExampleText",
 CellID->5240],
Cell[CellGroupData[{
Cell[6527, 239, 231, 7, 70, "Input",
 CellID->31864],
Cell[6761, 248, 274, 8, 36, "Output",
 CellID->22287]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[7084, 262, 223, 7, 70, "ExampleSection",
 CellID->20346],
Cell[7310, 271, 83, 1, 70, "ExampleText",
 CellID->2123025303],
Cell[CellGroupData[{
Cell[7418, 276, 206, 6, 70, "Input",
 CellID->399438762],
Cell[7627, 284, 1745, 30, 105, "Output",
 CellID->274278]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[9421, 320, 232, 7, 70, "ExampleSection",
 CellID->9397],
Cell[9656, 329, 139, 5, 70, "ExampleText",
 CellID->27902],
Cell[CellGroupData[{
Cell[9820, 338, 121, 3, 70, "Input",
 CellID->20589],
Cell[9944, 343, 174, 5, 54, "Output",
 CellID->115165959]
}, Open  ]],
Cell[CellGroupData[{
Cell[10155, 353, 100, 3, 70, "Input",
 CellID->20960],
Cell[10258, 358, 303, 11, 50, "Output",
 CellID->5874406]
}, Open  ]],
Cell[10576, 372, 125, 3, 70, "ExampleDelimiter",
 CellID->886873176],
Cell[10704, 377, 340, 12, 70, "ExampleText",
 CellID->231862319],
Cell[CellGroupData[{
Cell[11069, 393, 120, 3, 70, "Input",
 CellID->5354934],
Cell[11192, 398, 170, 5, 36, "Output",
 CellID->26520677]
}, Open  ]],
Cell[CellGroupData[{
Cell[11399, 408, 192, 6, 70, "Input",
 CellID->35695342],
Cell[11594, 416, 171, 5, 36, "Output",
 CellID->281395070]
}, Open  ]],
Cell[11780, 424, 126, 3, 70, "ExampleDelimiter",
 CellID->1135149803],
Cell[11909, 429, 208, 7, 70, "ExampleText",
 CellID->1364604515],
Cell[CellGroupData[{
Cell[12142, 440, 162, 4, 70, "Input",
 CellID->218019073],
Cell[12307, 446, 170, 5, 36, "Output",
 CellID->24906540]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12526, 457, 225, 7, 70, "ExampleSection",
 CellID->7984],
Cell[12754, 466, 227, 7, 70, "ExampleText",
 CellID->26987],
Cell[CellGroupData[{
Cell[13006, 477, 167, 5, 70, "Input",
 CellID->3902],
Cell[13176, 484, 236, 6, 71, "Output",
 CellID->304044449]
}, Open  ]],
Cell[CellGroupData[{
Cell[13449, 495, 161, 5, 70, "Input",
 CellID->153],
Cell[13613, 502, 371, 13, 50, "Output",
 CellID->263002043]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14045, 522, 311, 9, 70, "SeeAlsoSection",
 CellID->17530],
Cell[14359, 533, 194, 6, 70, "SeeAlso",
 CellID->12752]
}, Open  ]],
Cell[CellGroupData[{
Cell[14590, 544, 314, 9, 70, "TutorialsSection",
 CellID->29143],
Cell[14907, 555, 150, 3, 70, "Tutorials",
 CellID->1847]
}, Open  ]],
Cell[CellGroupData[{
Cell[15094, 563, 318, 9, 70, "MoreAboutSection",
 CellID->33642836],
Cell[15415, 574, 145, 3, 70, "MoreAbout",
 CellID->244867935]
}, Open  ]],
Cell[15575, 580, 52, 0, 70, "History"],
Cell[15630, 582, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

