(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     62880,       2185]
NotebookOptionsPosition[     50005,       1736]
NotebookOutlinePosition[     52597,       1807]
CellTagsIndexPosition[     52485,       1801]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Operations on Strings" :> 
          Documentation`HelpLookup["paclet:tutorial/OperationsOnStrings"], 
          "Special Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SpecialCharacters-StringsAndCharacters"], 
          "String Patterns" :> 
          Documentation`HelpLookup["paclet:tutorial/StringPatterns"], 
          "Working with String Patterns" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/WorkingWithStringPatternsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Operations on Strings\"\>", 
       2->"\<\"Special Characters\"\>", 3->"\<\"String Patterns\"\>", 
       4->"\<\"Working with String Patterns\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Split" :> Documentation`HelpLookup["paclet:ref/Split"], 
          "StringCases" :> 
          Documentation`HelpLookup["paclet:ref/StringCases"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Split\"\>", 
       2->"\<\"StringCases\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Processing Textual Data" :> 
          Documentation`HelpLookup["paclet:guide/ProcessingTextualData"], 
          "String Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/StringManipulation"], 
          "String Operations" :> 
          Documentation`HelpLookup["paclet:guide/StringOperations"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Processing Textual Data\"\>", 
       2->"\<\"String Manipulation\"\>", 
       3->"\<\"String Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["StringSplit", "ObjectName",
 CellID->1792],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringSplit",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringSplit"], "[", "\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]splits ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\""], "InlineFormula"],
     " into a list of substrings separated by whitespace. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringSplit",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringSplit"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", 
        StyleBox["patt", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]splits into substrings separated by delimiters matching \
the string expression ",
     Cell[BoxData[
      StyleBox["patt", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringSplit",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringSplit"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["p", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["p", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]splits at any of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["p", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringSplit",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringSplit"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", 
        RowBox[{
         StyleBox["patt", "TI"], "->", 
         StyleBox["val", "TI"]}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]inserts ",
     Cell[BoxData[
      StyleBox["val", "TI"]], "InlineFormula"],
     " at the position of each delimiter. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringSplit",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringSplit"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SubscriptBox[
            StyleBox["p", "TI"], 
            StyleBox["1", "TR"]], "->", 
           SubscriptBox[
            StyleBox["v", "TI"], 
            StyleBox["1", "TR"]]}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]inserts ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " at the position of each delimiter ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["p", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringSplit",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringSplit"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", 
        StyleBox["patt", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]splits into at most ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " substrings. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StringSplit",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringSplit"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["s", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["s", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["p", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the list of results for each of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->16702]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["StringSplit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringSplit"], "[", 
   StyleBox["s", "TI"], "]"}]], "InlineFormula"],
 " does not return the whitespace characters that delimit the substrings it \
returns. "
}], "Notes",
 CellID->22559],

Cell["\<\
Whitespace includes any number of spaces, tabs and newlines. \
\>", "Notes",
 CellID->28318],

Cell[TextData[{
 "The string expression ",
 Cell[BoxData[
  StyleBox["patt", "TI"]], "InlineFormula"],
 " can contain any of the objects specified in the notes for ",
 Cell[BoxData[
  ButtonBox["StringExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringExpression"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->21998],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["StringSplit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringSplit"], "[", 
   StyleBox["s", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["StringSplit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringSplit"], "[", 
   RowBox[{
    StyleBox["s", "TI"], ",", 
    ButtonBox["Whitespace",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Whitespace"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->11017],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 " contains two adjacent delimiters, ",
 Cell[BoxData[
  ButtonBox["StringSplit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringSplit"]], "InlineFormula"],
 " considers there to be a zero\[Hyphen]length substring ",
 Cell[BoxData["\"\<\>\""], "InlineFormula"],
 " between them. "
}], "Notes",
 CellID->10308],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["StringSplit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringSplit"], "[", 
   RowBox[{
    StyleBox["s", "TI"], ",", 
    StyleBox["patt", "TI"]}], "]"}]], "InlineFormula"],
 " by default gives the list of substrings of ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 " that occur between delimiters defined by ",
 Cell[BoxData[
  StyleBox["patt", "TI"]], "InlineFormula"],
 "; it does not include the delimiters themselves. "
}], "Notes",
 CellID->8669],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["StringSplit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringSplit"], "[", 
   RowBox[{
    StyleBox["s", "TI"], ",", 
    RowBox[{
     StyleBox["patt", "TI"], "->", 
     StyleBox["val", "TI"]}]}], "]"}]], "InlineFormula"],
 " includes ",
 Cell[BoxData[
  StyleBox["val", "TI"]], "InlineFormula"],
 " at the position of each delimiter. "
}], "Notes",
 CellID->27751],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["StringSplit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringSplit"], "[", 
   RowBox[{
    StyleBox["s", "TI"], ",", 
    RowBox[{
     StyleBox["patt", "TI"], ":>", 
     StyleBox["val", "TI"]}]}], "]"}]], "InlineFormula"],
 " evaluates ",
 Cell[BoxData[
  StyleBox["val", "TI"]], "InlineFormula"],
 " only when the pattern is found."
}], "Notes",
 CellID->1337],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["StringSplit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringSplit"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["p", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["v", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      SubscriptBox[
       StyleBox["p", "TI"], 
       StyleBox["a", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " includes ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["v", "TI"], 
   StyleBox["1", "TR"]]], "InlineFormula"],
 " at the position of delimiters matching ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["p", "TI"], 
   StyleBox["1", "TR"]]], "InlineFormula"],
 ", but omits delimiters matching ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["p", "TI"], 
   StyleBox["a", "TI"]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->13857],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["StringSplit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringSplit"], "[", 
   RowBox[{
    StyleBox["s", "TI"], ",", 
    StyleBox["patt", "TI"]}], "]"}]], "InlineFormula"],
 " drops zero\[Hyphen]length substrings associated with delimiters that \
appear at the beginning or end of ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->17222],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["StringSplit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringSplit"], "[", 
   RowBox[{
    StyleBox["s", "TI"], ",", 
    StyleBox["patt", "TI"], ",", 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"]}], "]"}]], "InlineFormula"],
 " returns all substrings, including zero\[Hyphen]length ones at the \
beginning or end. "
}], "Notes",
 CellID->18032],

Cell[TextData[{
 "Setting the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["IgnoreCase",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IgnoreCase"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " makes ",
 Cell[BoxData[
  ButtonBox["StringSplit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringSplit"]], "InlineFormula"],
 " treat lowercase and uppercase letters as equivalent. "
}], "Notes",
 CellID->24213],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["StringSplit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringSplit"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", 
    RowBox[{
     ButtonBox["RegularExpression",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RegularExpression"], "[", "\"\<\!\(\*
StyleBox[\"regex\", \"TI\"]\)\>\"", "]"}]}], "]"}]], "InlineFormula"],
 " splits at delimiters matching the specified regular expression. "
}], "Notes",
 CellID->3307]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->342851609],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->91754618],

Cell["Pick out substrings delimited by whitespace:", "ExampleText",
 CellID->2928],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringSplit", "[", "\"\<a bbb  cccc aa   d\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11305],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a\"\>", ",", "\<\"bbb\"\>", ",", "\<\"cccc\"\>", 
   ",", "\<\"aa\"\>", ",", "\<\"d\"\>"}], "}"}]], "Output",
 ImageSize->{140, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->133952509]
}, Open  ]],

Cell["Show the substrings with quotes:", "ExampleText",
 CellID->17794],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16781],

Cell["{\"a\", \"bbb\", \"cccc\", \"aa\", \"d\"}", "Output",
 ImageSize->{217, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//InputForm=",
 CellID->6691190]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26773],

Cell["Split a string at every --:", "ExampleText",
 CellID->20881],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringSplit", "[", 
  RowBox[{"\"\<a--bbb---ccc--dddd\>\"", ",", "\"\<--\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17108],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a\"\>", ",", "\<\"bbb\"\>", ",", "\<\"-ccc\"\>", 
   ",", "\<\"dddd\"\>"}], "}"}]], "Output",
 ImageSize->{136, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10971]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26291],

Cell["Split at every run of spaces:", "ExampleText",
 CellID->764486551],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringSplit", "[", "\"\<the cat in the hat\>\"", "]"}]], "Input",
 CellTags->"S2.8.2",
 CellLabel->"In[1]:=",
 CellID->330802656],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"the\"\>", ",", "\<\"cat\"\>", ",", "\<\"in\"\>", 
   ",", "\<\"the\"\>", ",", "\<\"hat\"\>"}], "}"}]], "Output",
 ImageSize->{161, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"S2.8.2",
 CellLabel->"Out[1]=",
 CellID->154672154]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1009001079],

Cell["Use string patterns:", "ExampleText",
 CellID->1602070101],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringSplit", "[", 
  RowBox[{"\"\<192.168.0.1\>\"", ",", "\"\<.\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->102093965],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"192\"\>", ",", "\<\"168\"\>", ",", "\<\"0\"\>", 
   ",", "\<\"1\"\>"}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->112792284]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringSplit", "[", 
  RowBox[{"\"\<123  2.3  4  6\>\"", ",", 
   RowBox[{"WhitespaceCharacter", ".."}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1826230663],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"123\"\>", ",", "\<\"2.3\"\>", ",", "\<\"4\"\>", 
   ",", "\<\"6\"\>"}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->281059706]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringSplit", "[", 
  RowBox[{"\"\<11a22b3\>\"", ",", 
   RowBox[{"_", "?", "LetterQ"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->180469199],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"11\"\>", ",", "\<\"22\"\>", ",", "\<\"3\"\>"}], 
  "}"}]], "Output",
 ImageSize->{76, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->843813272]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1113608023],

Cell["Regular expressions:", "ExampleText",
 CellID->1090058956],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringSplit", "[", 
  RowBox[{"\"\<A tree, an apple, four pears. And more: two sacks\>\"", ",", 
   RowBox[{"RegularExpression", "[", "\"\<\\\\W+\>\"", "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1298182474],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"A\"\>", ",", "\<\"tree\"\>", ",", "\<\"an\"\>", 
   ",", "\<\"apple\"\>", ",", "\<\"four\"\>", ",", "\<\"pears\"\>", 
   ",", "\<\"And\"\>", ",", "\<\"more\"\>", ",", "\<\"two\"\>", 
   ",", "\<\"sacks\"\>"}], "}"}]], "Output",
 ImageSize->{371, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->562651903]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1770421952],

Cell["Mixed regular expressions and string patterns:", "ExampleText",
 CellID->2095818079],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringSplit", "[", 
  RowBox[{"\"\<primes: 2 two 3 three 5 five ...\>\"", ",", 
   RowBox[{"Whitespace", "~~", 
    RowBox[{"RegularExpression", "[", "\"\<\\\\d\>\"", "]"}], "~~", 
    "Whitespace"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1387675659],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"primes:\"\>", ",", "\<\"two\"\>", ",", "\<\"three\"\>", 
   ",", "\<\"five ...\"\>"}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7304345]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1716907022],

Cell["Split into substrings separated by either delimiter:", "ExampleText",
 CellID->318554015],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringSplit", "[", 
  RowBox[{"\"\<a-b:c-d:e-f-g\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<:\>\"", ",", "\"\<-\>\""}], "}"}]}], "]"}]], "Input",
 CellTags->"S2.8.2",
 CellLabel->"In[1]:=",
 CellID->260598134],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>", ",", "\<\"c\"\>", ",", "\<\"d\"\>", 
   ",", "\<\"e\"\>", ",", "\<\"f\"\>", ",", "\<\"g\"\>"}], "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"S2.8.2",
 CellLabel->"Out[1]=",
 CellID->229253646]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringSplit", "[", 
  RowBox[{"\"\<a-b:c-d:e-f-g\>\"", ",", " ", 
   RowBox[{"\"\<:\>\"", "|", "\"\<-\>\""}]}], "]"}]], "Input",
 CellTags->"S2.8.2",
 CellLabel->"In[2]:=",
 CellID->301928572],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>", ",", "\<\"c\"\>", ",", "\<\"d\"\>", 
   ",", "\<\"e\"\>", ",", "\<\"f\"\>", ",", "\<\"g\"\>"}], "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"S2.8.2",
 CellLabel->"Out[2]=",
 CellID->140515637]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26045],

Cell["Insert a value at the position of a delimiter:", "ExampleText",
 CellID->3193],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringSplit", "[", 
  RowBox[{"\"\<a b::c d::e f g\>\"", ",", 
   RowBox[{"\"\<::\>\"", "\[Rule]", "\"\<--\>\""}]}], "]"}]], "Input",
 CellTags->"S2.8.2",
 CellLabel->"In[1]:=",
 CellID->26151],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a b\"\>", ",", "\<\"--\"\>", ",", "\<\"c d\"\>", 
   ",", "\<\"--\"\>", ",", "\<\"e f g\"\>"}], "}"}]], "Output",
 ImageSize->{168, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"S2.8.2",
 CellLabel->"Out[1]=",
 CellID->2039487660]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->91998220],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringSplit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringSplit"]], "InlineFormula"],
 " automatically threads over lists of strings:"
}], "ExampleText",
 CellID->25857700],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringSplit", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<a:b:c:d\>\"", ",", "\"\<listable:element\>\""}], "}"}], ",", 
   "\"\<:\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1610019191],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>", ",", "\<\"c\"\>", 
     ",", "\<\"d\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"listable\"\>", ",", "\<\"element\"\>"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{235, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22768021]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16505],

Cell["\<\
All substrings, including zero\[Hyphen]length ones at the beginning or end:\
\>", "ExampleText",
 CellID->761088518],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringSplit", "[", 
  RowBox[{"\"\<:a:b:c:\>\"", ",", "\"\<:\>\"", ",", "All"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1202120494],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"\"\>", ",", "\<\"a\"\>", ",", "\<\"b\"\>", ",", "\<\"c\"\>", 
   ",", "\<\"\"\>"}], "}"}]], "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->162069670]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1732328451],

Cell["{\"\", \"a\", \"b\", \"c\", \"\"}", "Output",
 ImageSize->{161, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//InputForm=",
 CellID->366358050]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->448821406],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "IgnoreCase",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->7888],

Cell["Split a string at every \"c\", including uppercase letters:", \
"ExampleText",
 CellID->73736195],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringSplit", "[", 
  RowBox[{"\"\<cat Cat hat CAT\>\"", ",", "\"\<c\>\"", ",", 
   RowBox[{"IgnoreCase", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->401476256],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"at \"\>", ",", "\<\"at hat \"\>", ",", "\<\"AT\"\>"}], 
  "}"}]], "Output",
 ImageSize->{125, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13787674]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19269],

Cell["A base random DNA string:", "ExampleText",
 CellID->245279094],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SeedRandom", "[", "1234", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"dna", " ", "=", " ", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "\"\<a\>\"", ",", "\"\<c\>\"", ",", "\"\<g\>\"", ",", "\"\<t\>\""}], 
       "}"}], ",", "500"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->1079152963],

Cell["Sequences with adenine symmetrically placed:", "ExampleText",
 CellID->655712165],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StringSplit", "[", 
   RowBox[{"dna", ",", 
    RowBox[{
     RowBox[{"x", ":", 
      RowBox[{"(", 
       RowBox[{"\"\<a\>\"", "~~", 
        RowBox[{"y_", "~~", 
         RowBox[{"_", "~~", 
          RowBox[{"y_", "~~", "\"\<a\>\""}]}]}]}], ")"}]}], "\[RuleDelayed]", 
     
     RowBox[{"Style", "[", 
      RowBox[{"x", ",", 
       RowBox[{"FontColor", "\[Rule]", "Red"}]}], "]"}]}]}], "]"}], " ", "//",
   "Row"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->792786743],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"tgaacggccgggaactaaaag\"\>", "\[InvisibleSpace]", 
   TagBox[
    StyleBox["\<\"acaca\"\>",
     FontColor->RGBColor[1, 0, 0]],
    StyleForm[#, FontColor -> RGBColor[1, 0, 0]]& ], 
   "\[InvisibleSpace]", \
"\<\"gaccgcttctagttgacataccgacgaccgacaggttcaatgtgggtaatcgcgaagttgtgctcaatctgcc\
gcgttaaagttgtagatgacaaccaagtacatgtccg\"\>", "\[InvisibleSpace]", 
   TagBox[
    StyleBox["\<\"accca\"\>",
     FontColor->RGBColor[1, 0, 0]],
    StyleForm[#, FontColor -> RGBColor[1, 0, 0]]& ], 
   "\[InvisibleSpace]", \
"\<\"agtcgattcttagcggagtatatggcagtgtaagagcccgactgggtccctggttgagctcgtgcgcattgta\
ttatcatttccggggtttcctaagg\"\>", "\[InvisibleSpace]", 
   TagBox[
    StyleBox["\<\"agaga\"\>",
     FontColor->RGBColor[1, 0, 0]],
    StyleForm[#, FontColor -> RGBColor[1, 0, 0]]& ], 
   "\[InvisibleSpace]", \
"\<\"gtccgtacacctcagctttaaggagaaacactattctgcgccatctgca\"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    StyleBox["\<\"acaca\"\>",
     FontColor->RGBColor[1, 0, 0]],
    StyleForm[#, FontColor -> RGBColor[1, 0, 0]]& ], 
   "\[InvisibleSpace]", "\<\"tgagtctgttagcactccgaagagcgcttgagcc\"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    StyleBox["\<\"aggga\"\>",
     FontColor->RGBColor[1, 0, 0]],
    StyleForm[#, FontColor -> RGBColor[1, 0, 0]]& ], 
   "\[InvisibleSpace]", \
"\<\"atgagcttcgctacctccgctgtaagtgcccctctctgcctctttccaacctccaatgcatgttgtcgccgtt\
agccagtggtcggacagtctgaaatgttagcacgtagaaactct\"\>", "\[InvisibleSpace]", 
   TagBox[
    StyleBox["\<\"accca\"\>",
     FontColor->RGBColor[1, 0, 0]],
    StyleForm[#, FontColor -> RGBColor[1, 0, 0]]& ], 
   "\[InvisibleSpace]", "\<\"ttacggcc\"\>", "\[InvisibleSpace]", 
   TagBox[
    StyleBox["\<\"attta\"\>",
     FontColor->RGBColor[1, 0, 0]],
    StyleForm[#, FontColor -> RGBColor[1, 0, 0]]& ], 
   "\[InvisibleSpace]", "\<\"gtttaatgtc\"\>", "\[InvisibleSpace]", 
   TagBox[
    StyleBox["\<\"aacaa\"\>",
     FontColor->RGBColor[1, 0, 0]],
    StyleForm[#, FontColor -> RGBColor[1, 0, 0]]& ], 
   "\[InvisibleSpace]", "\<\"tgtagctgccgga\"\>"}],
  Row[{"tgaacggccgggaactaaaag", 
    StyleForm["acaca", FontColor -> RGBColor[1, 0, 0]], 
    "gaccgcttctagttgacataccgacgaccgacaggttcaatgtgggtaatcgcgaagttgtgctcaatctgcc\
gcgttaaagttgtagatgacaaccaagtacatgtccg", 
    StyleForm["accca", FontColor -> RGBColor[1, 0, 0]], 
    "agtcgattcttagcggagtatatggcagtgtaagagcccgactgggtccctggttgagctcgtgcgcattgta\
ttatcatttccggggtttcctaagg", 
    StyleForm["agaga", FontColor -> RGBColor[1, 0, 0]], 
    "gtccgtacacctcagctttaaggagaaacactattctgcgccatctgca", 
    StyleForm["acaca", FontColor -> RGBColor[1, 0, 0]], 
    "tgagtctgttagcactccgaagagcgcttgagcc", 
    StyleForm["aggga", FontColor -> RGBColor[1, 0, 0]], 
    "atgagcttcgctacctccgctgtaagtgcccctctctgcctctttccaacctccaatgcatgttgtcgccgtt\
agccagtggtcggacagtctgaaatgttagcacgtagaaactct", 
    StyleForm["accca", FontColor -> RGBColor[1, 0, 0]], "ttacggcc", 
    StyleForm["attta", FontColor -> RGBColor[1, 0, 0]], "gtttaatgtc", 
    StyleForm["aacaa", FontColor -> RGBColor[1, 0, 0]], 
    "tgtagctgccgga"}]]], "Output",
 ImageSize->{585, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->589211400]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7889441],

Cell["Text analysis with some right and left context:", "ExampleText",
 CellID->1601332420],

Cell[BoxData[
 RowBox[{
  RowBox[{"text", " ", "=", " ", 
   RowBox[{"Import", "[", "\"\<ExampleData/USConstitution.txt\>\"", "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1249714097],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["StringSplit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringSplit"]], "InlineFormula"],
 " to find all occurrences of the word \"power\":"
}], "ExampleText",
 CellID->875264038],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", "=", " ", 
   RowBox[{"StringSplit", "[", 
    RowBox[{"text", ",", " ", "\"\<power\>\"", ",", "10"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->152896728],

Cell["\<\
Compute part of the left and right contexts in which each word occurs:\
\>", "ExampleText",
 CellID->66805373],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Apply", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Row", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<\[Ellipsis]\>\"", ",", 
        RowBox[{"StringTake", "[", 
         RowBox[{"#1", ",", 
          RowBox[{"-", 
           RowBox[{"Min", "[", 
            RowBox[{"15", ",", 
             RowBox[{"StringLength", "[", "#1", "]"}]}], "]"}]}]}], "]"}], 
        ",", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<power\>\"", ",", "Blue"}], "]"}], ",", 
        RowBox[{"StringTake", "[", 
         RowBox[{"#2", ",", 
          RowBox[{"Min", "[", 
           RowBox[{"15", ",", 
            RowBox[{"StringLength", "[", "#2", "]"}]}], "]"}]}], "]"}], ",", 
        "\"\<\[Ellipsis]\>\""}], "}"}], "]"}], "&"}], ",", 
    RowBox[{"Partition", "[", 
     RowBox[{"a", ",", "2", ",", "1"}], "]"}], ",", 
    RowBox[{"{", "1", "}"}]}], "]"}], "//", "Column"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->650792904],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{259, 221},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->219324530]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->217338313],

Cell["\<\
List extensions of files in a directory and its subdirectories:\
\>", "ExampleText",
 CellID->2082826691],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetDirectory", "[", "$InstallationDirectory", "]"}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->42283907],

Cell[BoxData[
 RowBox[{
  RowBox[{"files", " ", "=", 
   RowBox[{"FileNames", "[", 
    RowBox[{"\"\<@.*\>\"", ",", 
     RowBox[{"{", "\"\<*\>\"", "}"}], ",", "Infinity"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2084749537],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Union", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Last", "[", 
     RowBox[{"StringSplit", "[", 
      RowBox[{"#", ",", "\"\<.\>\""}], "]"}], "]"}], " ", "&"}], " ", "/@", 
   " ", "files"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1290275486],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"3ds\"\>", ",", "\<\"access\"\>", ",", "\<\"afm\"\>", 
   ",", "\<\"aif\"\>", ",", "\<\"alias\"\>", ",", "\<\"bas\"\>", 
   ",", "\<\"bfc\"\>", ",", "\<\"bmp\"\>", ",", "\<\"byu\"\>", 
   ",", "\<\"c\"\>", ",", "\<\"cfg\"\>", ",", "\<\"cfs\"\>", 
   ",", "\<\"cpl\"\>", ",", "\<\"css\"\>", ",", "\<\"cua\"\>", 
   ",", "\<\"dat\"\>", ",", "\<\"data\"\>", ",", "\<\"dem\"\>", 
   ",", "\<\"dif\"\>", ",", "\<\"dir\"\>", ",", "\<\"dll\"\>", 
   ",", "\<\"DLL\"\>", ",", "\<\"dtd\"\>", ",", "\<\"ent\"\>", 
   ",", "\<\"eps\"\>", ",", "\<\"exe\"\>", ",", "\<\"fd\"\>", 
   ",", "\<\"frm\"\>", ",", "\<\"gif\"\>", ",", "\<\"gm\"\>", 
   ",", "\<\"h\"\>", ",", "\<\"html\"\>", ",", "\<\"ja\"\>", 
   ",", "\<\"jar\"\>", ",", "\<\"jp2\"\>", ",", "\<\"jpg\"\>", 
   ",", "\<\"jsa\"\>", ",", "\<\"jvx\"\>", ",", "\<\"lib\"\>", 
   ",", "\<\"m\"\>", ",", "\<\"map\"\>", ",", "\<\"mdb\"\>", 
   ",", "\<\"mlp\"\>", ",", "\<\"mml\"\>", ",", "\<\"mod\"\>", 
   ",", "\<\"mps\"\>", ",", "\<\"msi\"\>", ",", "\<\"mtx\"\>", 
   ",", "\<\"mx\"\>", ",", "\<\"nb\"\>", ",", "\<\"off\"\>", 
   ",", "\<\"pdf\"\>", ",", "\<\"pfa\"\>", ",", "\<\"ply\"\>", 
   ",", "\<\"png\"\>", ",", "\<\"policy\"\>", ",", "\<\"properties\"\>", 
   ",", "\<\"ps\"\>", ",", "\<\"psa\"\>", ",", "\<\"py\"\>", 
   ",", "\<\"rib\"\>", ",", "\<\"rra\"\>", ",", "\<\"rsa\"\>", 
   ",", "\<\"rua\"\>", ",", "\<\"scale\"\>", ",", "\<\"script\"\>", 
   ",", "\<\"security\"\>", ",", "\<\"src\"\>", ",", "\<\"sty\"\>", 
   ",", "\<\"template\"\>", ",", "\<\"tex\"\>", ",", "\<\"tfm\"\>", 
   ",", "\<\"tm\"\>", ",", "\<\"tnb\"\>", ",", "\<\"tnc\"\>", 
   ",", "\<\"tns\"\>", ",", "\<\"txt\"\>", ",", "\<\"vbp\"\>", 
   ",", "\<\"vf\"\>", ",", "\<\"wav\"\>", ",", "\<\"xsl\"\>"}], 
  "}"}]], "Output",
 ImageSize->{582, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->885567326]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19348],

Cell["\<\
Splitting at whitespace is equivalent to cases of non-whitespace sequences:\
\>", "ExampleText",
 CellID->22661],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringSplit", "[", "\"\<a bbb  cccc aa   d\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24775],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a\"\>", ",", "\<\"bbb\"\>", ",", "\<\"cccc\"\>", 
   ",", "\<\"aa\"\>", ",", "\<\"d\"\>"}], "}"}]], "Output",
 ImageSize->{140, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->111422749]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<a bbb  cccc aa   d\>\"", ",", 
   RowBox[{
    RowBox[{"Except", "[", "WhitespaceCharacter", "]"}], ".."}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->25866],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a\"\>", ",", "\<\"bbb\"\>", ",", "\<\"cccc\"\>", 
   ",", "\<\"aa\"\>", ",", "\<\"d\"\>"}], "}"}]], "Output",
 ImageSize->{140, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->611293774]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20775],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringSplit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringSplit"]], "InlineFormula"],
 " with a rule is equivalent to ",
 Cell[BoxData[
  ButtonBox["StringReplace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringReplace"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1311],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringJoin", "[", 
  RowBox[{"StringSplit", "[", 
   RowBox[{"\"\<ab::c::d::ef\>\"", ",", 
    RowBox[{"\"\<::\>\"", "->", "\"\<X\>\""}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2658],

Cell[BoxData["\<\"abXcXdXef\"\>"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->89761039]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<ab::c::d::ef\>\"", ",", 
   RowBox[{"\"\<::\>\"", "->", "\"\<X\>\""}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4532],

Cell[BoxData["\<\"abXcXdXef\"\>"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->24612190]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30544],

Cell["A null delimiter splits at every character:", "ExampleText",
 CellID->31517],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringSplit", "[", 
  RowBox[{"\"\<abcdefg\>\"", ",", "\"\<\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24952],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>", ",", "\<\"c\"\>", ",", "\<\"d\"\>", 
   ",", "\<\"e\"\>", ",", "\<\"f\"\>", ",", "\<\"g\"\>"}], "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->276842640]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Characters", "[", "\"\<abcdefg\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15980],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>", ",", "\<\"c\"\>", ",", "\<\"d\"\>", 
   ",", "\<\"e\"\>", ",", "\<\"f\"\>", ",", "\<\"g\"\>"}], "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->524236921]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2722614],

Cell[TextData[{
 "Using ",
 Cell[BoxData[
  ButtonBox["StringSplit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringSplit"]], "InlineFormula"],
 " on a comma-separated values string: "
}], "ExampleText",
 CellID->370359632],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StringSplit", "[", 
   RowBox[{
    RowBox[{"StringSplit", "[", 
     RowBox[{"\"\<123,  2.3, 45.\\n345, 1.4, 450\>\"", ",", "\"\<\\n\>\""}], 
     "]"}], ",", "\"\<,\>\""}], "]"}], "//", "ToExpression"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5415832],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"123", ",", "2.3`", ",", "45.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"345", ",", "1.4`", ",", "450"}], "}"}]}], "}"}]], "Output",
 ImageSize->{228, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->237296642]
}, Open  ]],

Cell[TextData[{
 "In many cases ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " provide direct functionality:"
}], "ExampleText",
 CellID->77271244],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{"\"\<123,  2.3, 45.\\n345, 1.4, 450\>\"", ",", "\"\<CSV\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->725881025],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"123", ",", "2.3`", ",", "45.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"345", ",", "1.4`", ",", "450"}], "}"}]}], "}"}]], "Output",
 ImageSize->{228, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->72110332]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8532],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringSplit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringSplit"]], "InlineFormula"],
 " by default splits only at whitespace:"
}], "ExampleText",
 CellID->23428],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringSplit", "[", "\"\<This is a sentence--which goes on.\>\"", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8520],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"This\"\>", ",", "\<\"is\"\>", ",", "\<\"a\"\>", 
   ",", "\<\"sentence--which\"\>", ",", "\<\"goes\"\>", ",", "\<\"on.\"\>"}], 
  "}"}]], "Output",
 ImageSize->{277, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->141292336]
}, Open  ]],

Cell["This splits into words:", "ExampleText",
 CellID->27955],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringSplit", "[", 
  RowBox[{"\"\<This is a sentence, which goes on.\>\"", ",", 
   RowBox[{
    RowBox[{"Except", "[", "WordCharacter", "]"}], ".."}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24087],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"This\"\>", ",", "\<\"is\"\>", ",", "\<\"a\"\>", 
   ",", "\<\"sentence\"\>", ",", "\<\"which\"\>", ",", "\<\"goes\"\>", 
   ",", "\<\"on\"\>"}], "}"}]], "Output",
 ImageSize->{268, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->240632482]
}, Open  ]],

Cell["Another way to split into words:", "ExampleText",
 CellID->28446],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<This is a sentence, which goes on.\>\"", ",", 
   RowBox[{"WordCharacter", ".."}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->16023],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"This\"\>", ",", "\<\"is\"\>", ",", "\<\"a\"\>", 
   ",", "\<\"sentence\"\>", ",", "\<\"which\"\>", ",", "\<\"goes\"\>", 
   ",", "\<\"on\"\>"}], "}"}]], "Output",
 ImageSize->{268, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->436501228]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->7899],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Split",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Split"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringCases",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringCases"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->28575]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19079],

Cell[TextData[ButtonBox["Operations on Strings",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OperationsOnStrings"]], "Tutorials",
 CellID->28941],

Cell[TextData[ButtonBox["Special Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SpecialCharacters-StringsAndCharacters"]], "Tutorials",
 CellID->336637905],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StringPatterns"]], "Tutorials",
 CellID->8153],

Cell[TextData[ButtonBox["Working with String Patterns",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/WorkingWithStringPatternsOverview"]], "Tutorials",
 CellID->22514736]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->96097995],

Cell[TextData[ButtonBox["Processing Textual Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ProcessingTextualData"]], "MoreAbout",
 CellID->132060033],

Cell[TextData[ButtonBox["String Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringManipulation"]], "MoreAbout",
 CellID->106054650],

Cell[TextData[ButtonBox["String Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringOperations"]], "MoreAbout",
 CellID->317577808]
}, Open  ]],

Cell["New in 5.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"StringSplit - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 24, 39.9699408}", "context" -> "System`", 
    "keywords" -> {
     "breaking strings", "delimiters", "dividing strings", 
      "splitting strings", "whitespace"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "StringSplit[\"string\"] splits \" string\" into a list of substrings \
separated by whitespace. StringSplit[\"string\", patt] splits into substrings \
separated by delimiters matching the string expression patt. \
StringSplit[\"string\", {p_1, p_2, ...}] splits at any of the p_i. \
StringSplit[\"string\", patt -> val] inserts val at the position of each \
delimiter. StringSplit[\"string\", {p_1 -> v_1, ...}] inserts v_i at the \
position of each delimiter p_i. StringSplit[\"string\", patt, n] splits into \
at most n substrings. StringSplit[{s_1, s_2, ...}, p] gives the list of \
results for each of the s_i. ", "synonyms" -> {"string split"}, "title" -> 
    "StringSplit", "type" -> "Symbol", "uri" -> "ref/StringSplit"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[14473, 493, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->342851609]},
 "S2.8.2"->{
  Cell[16966, 597, 153, 4, 70, "Input",
   CellTags->"S2.8.2",
   CellID->330802656],
  Cell[17122, 603, 308, 9, 36, "Output",
   CellTags->"S2.8.2",
   CellID->154672154],
  Cell[21012, 753, 236, 7, 70, "Input",
   CellTags->"S2.8.2",
   CellID->260598134],
  Cell[21251, 762, 335, 9, 36, "Output",
   CellTags->"S2.8.2",
   CellID->229253646],
  Cell[21623, 776, 216, 6, 70, "Input",
   CellTags->"S2.8.2",
   CellID->301928572],
  Cell[21842, 784, 335, 9, 36, "Output",
   CellTags->"S2.8.2",
   CellID->140515637],
  Cell[22425, 806, 217, 6, 70, "Input",
   CellTags->"S2.8.2",
   CellID->26151],
  Cell[22645, 814, 310, 9, 36, "Output",
   CellTags->"S2.8.2",
   CellID->2039487660]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 51638, 1769},
 {"S2.8.2", 51772, 1773}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2633, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3256, 88, 48, 1, 70, "ObjectName",
 CellID->1792],
Cell[3307, 91, 4517, 143, 70, "Usage",
 CellID->16702]
}, Open  ]],
Cell[CellGroupData[{
Cell[7861, 239, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8339, 256, 309, 10, 70, "Notes",
 CellID->22559],
Cell[8651, 268, 102, 3, 70, "Notes",
 CellID->28318],
Cell[8756, 273, 336, 11, 70, "Notes",
 CellID->21998],
Cell[9095, 286, 541, 20, 70, "Notes",
 CellID->11017],
Cell[9639, 308, 398, 13, 70, "Notes",
 CellID->10308],
Cell[10040, 323, 534, 17, 70, "Notes",
 CellID->8669],
Cell[10577, 342, 434, 16, 70, "Notes",
 CellID->27751],
Cell[11014, 360, 430, 16, 70, "Notes",
 CellID->1337],
Cell[11447, 378, 1064, 39, 70, "Notes",
 CellID->13857],
Cell[12514, 419, 460, 16, 70, "Notes",
 CellID->17222],
Cell[12977, 437, 447, 15, 70, "Notes",
 CellID->18032],
Cell[13427, 454, 489, 17, 70, "Notes",
 CellID->24213],
Cell[13919, 473, 517, 15, 70, "Notes",
 CellID->3307]
}, Closed]],
Cell[CellGroupData[{
Cell[14473, 493, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->342851609],
Cell[CellGroupData[{
Cell[14858, 507, 147, 5, 70, "ExampleSection",
 CellID->91754618],
Cell[15008, 514, 82, 1, 70, "ExampleText",
 CellID->2928],
Cell[CellGroupData[{
Cell[15115, 519, 128, 3, 28, "Input",
 CellID->11305],
Cell[15246, 524, 284, 8, 36, "Output",
 CellID->133952509]
}, Open  ]],
Cell[15545, 535, 71, 1, 70, "ExampleText",
 CellID->17794],
Cell[CellGroupData[{
Cell[15641, 540, 101, 3, 28, "Input",
 CellID->16781],
Cell[15745, 545, 199, 5, 50, "Output",
 CellID->6691190]
}, Open  ]],
Cell[15959, 553, 121, 3, 70, "ExampleDelimiter",
 CellID->26773],
Cell[16083, 558, 66, 1, 70, "ExampleText",
 CellID->20881],
Cell[CellGroupData[{
Cell[16174, 563, 160, 4, 70, "Input",
 CellID->17108],
Cell[16337, 569, 264, 8, 36, "Output",
 CellID->10971]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16650, 583, 216, 7, 70, "ExampleSection",
 CellID->26291],
Cell[16869, 592, 72, 1, 70, "ExampleText",
 CellID->764486551],
Cell[CellGroupData[{
Cell[16966, 597, 153, 4, 70, "Input",
 CellTags->"S2.8.2",
 CellID->330802656],
Cell[17122, 603, 308, 9, 36, "Output",
 CellTags->"S2.8.2",
 CellID->154672154]
}, Open  ]],
Cell[17445, 615, 126, 3, 70, "ExampleDelimiter",
 CellID->1009001079],
Cell[17574, 620, 64, 1, 70, "ExampleText",
 CellID->1602070101],
Cell[CellGroupData[{
Cell[17663, 625, 156, 4, 70, "Input",
 CellID->102093965],
Cell[17822, 631, 264, 8, 36, "Output",
 CellID->112792284]
}, Open  ]],
Cell[CellGroupData[{
Cell[18123, 644, 190, 5, 70, "Input",
 CellID->1826230663],
Cell[18316, 651, 264, 8, 36, "Output",
 CellID->281059706]
}, Open  ]],
Cell[CellGroupData[{
Cell[18617, 664, 174, 5, 70, "Input",
 CellID->180469199],
Cell[18794, 671, 242, 8, 36, "Output",
 CellID->843813272]
}, Open  ]],
Cell[19051, 682, 126, 3, 70, "ExampleDelimiter",
 CellID->1113608023],
Cell[19180, 687, 64, 1, 70, "ExampleText",
 CellID->1090058956],
Cell[CellGroupData[{
Cell[19269, 692, 248, 6, 70, "Input",
 CellID->1298182474],
Cell[19520, 700, 402, 10, 36, "Output",
 CellID->562651903]
}, Open  ]],
Cell[19937, 713, 126, 3, 70, "ExampleDelimiter",
 CellID->1770421952],
Cell[20066, 718, 90, 1, 70, "ExampleText",
 CellID->2095818079],
Cell[CellGroupData[{
Cell[20181, 723, 287, 7, 70, "Input",
 CellID->1387675659],
Cell[20471, 732, 277, 8, 36, "Output",
 CellID->7304345]
}, Open  ]],
Cell[20763, 743, 126, 3, 70, "ExampleDelimiter",
 CellID->1716907022],
Cell[20892, 748, 95, 1, 70, "ExampleText",
 CellID->318554015],
Cell[CellGroupData[{
Cell[21012, 753, 236, 7, 70, "Input",
 CellTags->"S2.8.2",
 CellID->260598134],
Cell[21251, 762, 335, 9, 36, "Output",
 CellTags->"S2.8.2",
 CellID->229253646]
}, Open  ]],
Cell[CellGroupData[{
Cell[21623, 776, 216, 6, 70, "Input",
 CellTags->"S2.8.2",
 CellID->301928572],
Cell[21842, 784, 335, 9, 36, "Output",
 CellTags->"S2.8.2",
 CellID->140515637]
}, Open  ]],
Cell[22192, 796, 121, 3, 70, "ExampleDelimiter",
 CellID->26045],
Cell[22316, 801, 84, 1, 70, "ExampleText",
 CellID->3193],
Cell[CellGroupData[{
Cell[22425, 806, 217, 6, 70, "Input",
 CellTags->"S2.8.2",
 CellID->26151],
Cell[22645, 814, 310, 9, 36, "Output",
 CellTags->"S2.8.2",
 CellID->2039487660]
}, Open  ]],
Cell[22970, 826, 124, 3, 70, "ExampleDelimiter",
 CellID->91998220],
Cell[23097, 831, 227, 7, 70, "ExampleText",
 CellID->25857700],
Cell[CellGroupData[{
Cell[23349, 842, 229, 7, 70, "Input",
 CellID->1610019191],
Cell[23581, 851, 391, 13, 36, "Output",
 CellID->22768021]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[24021, 870, 239, 7, 70, "ExampleSection",
 CellID->16505],
Cell[24263, 879, 126, 3, 70, "ExampleText",
 CellID->761088518],
Cell[CellGroupData[{
Cell[24414, 886, 165, 4, 70, "Input",
 CellID->1202120494],
Cell[24582, 892, 275, 8, 36, "Output",
 CellID->162069670]
}, Open  ]],
Cell[CellGroupData[{
Cell[24894, 905, 106, 3, 70, "Input",
 CellID->1732328451],
Cell[25003, 910, 193, 5, 50, "Output",
 CellID->366358050]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[25245, 921, 222, 7, 70, "ExampleSection",
 CellID->448821406],
Cell[CellGroupData[{
Cell[25492, 932, 226, 7, 70, "ExampleSubsection",
 CellID->7888],
Cell[25721, 941, 103, 2, 70, "ExampleText",
 CellID->73736195],
Cell[CellGroupData[{
Cell[25849, 947, 212, 5, 70, "Input",
 CellID->401476256],
Cell[26064, 954, 249, 8, 36, "Output",
 CellID->13787674]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[26374, 969, 223, 7, 70, "ExampleSection",
 CellID->19269],
Cell[26600, 978, 68, 1, 70, "ExampleText",
 CellID->245279094],
Cell[26671, 981, 423, 13, 70, "Input",
 CellID->1079152963],
Cell[27097, 996, 87, 1, 70, "ExampleText",
 CellID->655712165],
Cell[CellGroupData[{
Cell[27209, 1001, 510, 17, 70, "Input",
 CellID->792786743],
Cell[27722, 1020, 3192, 74, 173, "Output",
 CellID->589211400]
}, Open  ]],
Cell[30929, 1097, 123, 3, 70, "ExampleDelimiter",
 CellID->7889441],
Cell[31055, 1102, 91, 1, 70, "ExampleText",
 CellID->1601332420],
Cell[31149, 1105, 198, 6, 70, "Input",
 CellID->1249714097],
Cell[31350, 1113, 239, 8, 70, "ExampleText",
 CellID->875264038],
Cell[31592, 1123, 218, 7, 70, "Input",
 CellID->152896728],
Cell[31813, 1132, 120, 3, 70, "ExampleText",
 CellID->66805373],
Cell[CellGroupData[{
Cell[31958, 1139, 957, 27, 70, "Input",
 CellID->650792904],
Cell[32918, 1168, 3328, 59, 70, "Output",
 Evaluatable->False,
 CellID->219324530]
}, Open  ]],
Cell[36261, 1230, 125, 3, 70, "ExampleDelimiter",
 CellID->217338313],
Cell[36389, 1235, 115, 3, 70, "ExampleText",
 CellID->2082826691],
Cell[36507, 1240, 149, 5, 70, "Input",
 CellID->42283907],
Cell[36659, 1247, 246, 8, 70, "Input",
 CellID->2084749537],
Cell[CellGroupData[{
Cell[36930, 1259, 277, 9, 70, "Input",
 CellID->1290275486],
Cell[37210, 1270, 1928, 34, 105, "Output",
 CellID->885567326]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[39187, 1310, 233, 7, 70, "ExampleSection",
 CellID->19348],
Cell[39423, 1319, 122, 3, 70, "ExampleText",
 CellID->22661],
Cell[CellGroupData[{
Cell[39570, 1326, 128, 3, 70, "Input",
 CellID->24775],
Cell[39701, 1331, 284, 8, 36, "Output",
 CellID->111422749]
}, Open  ]],
Cell[CellGroupData[{
Cell[40022, 1344, 227, 7, 70, "Input",
 CellID->25866],
Cell[40252, 1353, 284, 8, 36, "Output",
 CellID->611293774]
}, Open  ]],
Cell[40551, 1364, 121, 3, 70, "ExampleDelimiter",
 CellID->20775],
Cell[40675, 1369, 343, 12, 70, "ExampleText",
 CellID->1311],
Cell[CellGroupData[{
Cell[41043, 1385, 225, 6, 70, "Input",
 CellID->2658],
Cell[41271, 1393, 173, 5, 36, "Output",
 CellID->89761039]
}, Open  ]],
Cell[CellGroupData[{
Cell[41481, 1403, 188, 5, 70, "Input",
 CellID->4532],
Cell[41672, 1410, 173, 5, 36, "Output",
 CellID->24612190]
}, Open  ]],
Cell[41860, 1418, 121, 3, 70, "ExampleDelimiter",
 CellID->30544],
Cell[41984, 1423, 82, 1, 70, "ExampleText",
 CellID->31517],
Cell[CellGroupData[{
Cell[42091, 1428, 147, 4, 70, "Input",
 CellID->24952],
Cell[42241, 1434, 314, 8, 36, "Output",
 CellID->276842640]
}, Open  ]],
Cell[CellGroupData[{
Cell[42592, 1447, 116, 3, 70, "Input",
 CellID->15980],
Cell[42711, 1452, 314, 8, 36, "Output",
 CellID->524236921]
}, Open  ]],
Cell[43040, 1463, 123, 3, 70, "ExampleDelimiter",
 CellID->2722614],
Cell[43166, 1468, 231, 8, 70, "ExampleText",
 CellID->370359632],
Cell[CellGroupData[{
Cell[43422, 1480, 291, 8, 70, "Input",
 CellID->5415832],
Cell[43716, 1490, 337, 11, 36, "Output",
 CellID->237296642]
}, Open  ]],
Cell[44068, 1504, 358, 13, 70, "ExampleText",
 CellID->77271244],
Cell[CellGroupData[{
Cell[44451, 1521, 181, 5, 70, "Input",
 CellID->725881025],
Cell[44635, 1528, 336, 11, 36, "Output",
 CellID->72110332]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[45020, 1545, 225, 7, 70, "ExampleSection",
 CellID->8532],
Cell[45248, 1554, 217, 7, 70, "ExampleText",
 CellID->23428],
Cell[CellGroupData[{
Cell[45490, 1565, 146, 4, 70, "Input",
 CellID->8520],
Cell[45639, 1571, 322, 9, 36, "Output",
 CellID->141292336]
}, Open  ]],
Cell[45976, 1583, 62, 1, 70, "ExampleText",
 CellID->27955],
Cell[CellGroupData[{
Cell[46063, 1588, 234, 6, 70, "Input",
 CellID->24087],
Cell[46300, 1596, 337, 9, 36, "Output",
 CellID->240632482]
}, Open  ]],
Cell[46652, 1608, 71, 1, 70, "ExampleText",
 CellID->28446],
Cell[CellGroupData[{
Cell[46748, 1613, 199, 5, 70, "Input",
 CellID->16023],
Cell[46950, 1620, 337, 9, 36, "Output",
 CellID->436501228]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[47348, 1636, 310, 9, 70, "SeeAlsoSection",
 CellID->7899],
Cell[47661, 1647, 451, 17, 70, "SeeAlso",
 CellID->28575]
}, Open  ]],
Cell[CellGroupData[{
Cell[48149, 1669, 314, 9, 70, "TutorialsSection",
 CellID->19079],
Cell[48466, 1680, 151, 3, 70, "Tutorials",
 CellID->28941],
Cell[48620, 1685, 174, 4, 70, "Tutorials",
 CellID->336637905],
Cell[48797, 1691, 139, 3, 70, "Tutorials",
 CellID->8153],
Cell[48939, 1696, 178, 4, 70, "Tutorials",
 CellID->22514736]
}, Open  ]],
Cell[CellGroupData[{
Cell[49154, 1705, 318, 9, 70, "MoreAboutSection",
 CellID->96097995],
Cell[49475, 1716, 156, 3, 70, "MoreAbout",
 CellID->132060033],
Cell[49634, 1721, 149, 3, 70, "MoreAbout",
 CellID->106054650],
Cell[49786, 1726, 145, 3, 70, "MoreAbout",
 CellID->317577808]
}, Open  ]],
Cell[49946, 1732, 29, 0, 70, "History"],
Cell[49978, 1734, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

