(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     39565,       1417]
NotebookOptionsPosition[     32318,       1165]
NotebookOutlinePosition[     33569,       1201]
CellTagsIndexPosition[     33483,       1196]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/SpecialFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Special Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"StruveH" :> Documentation`HelpLookup["paclet:ref/StruveH"], 
          "BesselJ" :> Documentation`HelpLookup["paclet:ref/BesselJ"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"StruveH\"\>", 
       2->"\<\"BesselJ\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Bessel-Related Functions" :> 
          Documentation`HelpLookup["paclet:guide/BesselRelatedFunctions"], 
          "Functions Used in Optics" :> 
          Documentation`HelpLookup["paclet:guide/FunctionsUsedInOptics"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Bessel-Related Functions\"\>", 
       2->"\<\"Functions Used in Optics\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["StruveL", "ObjectName",
 CellID->28785],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StruveL",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StruveL"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the modified Struve function ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox[
         StyleBox["L",
          SingleLetterItalics->False,
          FontWeight->"Bold"], "n"], "(", "z", ")"}], TraditionalForm]], 
      "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->10593]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     StyleBox["L",
      SingleLetterItalics->False,
      FontWeight->"Bold"], "n"], "(", "z", ")"}], TraditionalForm]], 
  "InlineMath"],
 " for integer ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " is related to the ordinary Struve function by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox[
      StyleBox["L",
       SingleLetterItalics->False,
       FontWeight->"Bold"], "n"], "(", 
     RowBox[{"i", "\[InvisibleSpace]", "z"}], ")"}], "=", 
    RowBox[{
     RowBox[{"-", "i"}], 
     SuperscriptBox["e", 
      RowBox[{
       RowBox[{"-", "i"}], "\[InvisibleSpace]", "n", "\[InvisibleSpace]", 
       RowBox[{"\[Pi]", "/", "2"}]}]], 
     RowBox[{
      SubscriptBox[
       StyleBox["H",
        SingleLetterItalics->False,
        FontWeight->"Bold"], "n"], "(", "z", ")"}]}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->19508],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["StruveL",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StruveL"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " has a branch cut discontinuity in the complex ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " plane running from ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "\[Infinity]"}], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->30811],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["StruveL",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StruveL"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->11362464],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StruveL",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StruveL"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StruveL",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StruveL"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->181411085],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->85059955],

Cell["Evaluate numerically:", "ExampleText",
 CellID->84309926],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StruveL", "[", 
  RowBox[{"0", ",", "2.5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->630411116],

Cell[BoxData["3.0112116937373057`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->552459084]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->61119163],

Cell[TextData[{
 "Plot ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     StyleBox[
      InterpretationBox["L",
       StruveL,
       Editable->False,
       Selectable->False],
      SingleLetterItalics->False,
      FontWeight->"Bold",
      FontSlant->"Plain"], "0"], "(", "x", ")"}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->114350614],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"StruveL", "[", 
    RowBox[{"0", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->70556718],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVx3tU0mccgHERr6jFJTNjBZVmkpF6VtL5Ld/vxDXNcqVZy5Ymls4yFVPn
LXWVK9gYZm5eOsVxqWknNTZrxzQyMSJF0uzidVh4WZQbZZhdyL374znP+SwT
JIcdsLSwsAjF/f9zeQIbn/05/i5OGpFritC/o4+9ZRd7N9J3cm8+M3+F5lSK
42x2Ajqx9diFanM0OtcmYVmzs1Cpx6qdInMyStyYfvgNS4RUsdE+xeZ81Pf+
2xIjqxwpzG9qXpmlyHboqccUqw6NBGopZ+ZkqLJTJnzOakaU1jyCTr6CGhpF
Q4ncTiSPmt+hVLSheNRb/iK1D4XVBj+rsbqLksY99U0NA+hySnnaTFUPoiw7
4aHjjaKD6ihwh4foZ2oXp3KfHnlF1ZLXyQeQYGjHTbJmAvW1HiHzf/8LCW+f
ECR7GFCh3YIywfMnSJ7iGL4oeArZJ+0bdEkZQ5U5hwzeu4yo4fSDG6rtk+iY
7MP21y9eoorshCuNqw3Iom8UWrOnkYlRNaNfPoVWpsVl7uCYkN5ScqQtyIjG
TKU7HW7MIIU22/nw3Eu0efzg0WLhLMoLEM5Om6dR6FjR6qVL3yHFac1gyeIZ
ZFAKCtT171FVC5syuGEWcWmPlvCjzYid0S8JufYOUZApZnj6I7I0sSRogxl9
ORX5ZnmEBZhyXQOTF1pAf/t+UqQXCUqlwUHBl0hw9VRHFNtEgow/vc9k8skQ
Z50+qtVawrTp2iHnldYQm5pz1bGCDL3hXYEGqi2sjV+t3RJjBfeq1ytFTHu4
R/dySN9gDQ3Of3elFDpAS8Oxs15kG7iSmPy96J0T5JA42zQjNnB+RZZ1rZAK
lOHsoKQmW/CvdW8MsqTDeM2yElmuHcxe6onZW8GAklWuVs0R9vB4YGKzV54z
FFXE3YlhUyDsiNQqLNEFIkv2ah0nKZC/MMo3LdcVZgOr38oUDrDZLmFw479M
0I8HZLafdITIRwU/hCcvhd82+jC7Y5xA3jQvvv0PNtQXptPi18yDyjqVv463
HE5GxIaQTfPgH6r0snhgBawbrqw72T0f8sTkwFa1O5R5nq3vDqFC1qjEKlXp
AfltkrKQZir06njD5iUc2MqMqO50o0H+Y4WYXucFnyfd2UMT0UCceSrIELAW
ZJ8I3DQmGrjx4wvFa3zATXnx19A9dHjrGactVPpC0Zp2zn0FHV5E/JKqzvgU
4qateu9yGOBf7tvyIHc9COSv2CIpA3oMrptSpTxQd9odb/3AAJ3S2Mi3JSCR
/6ToLnb0uoezxdjU1ubzj7A5zIsBT7G/rj943YhtCGUMFNgRMCnVvHQzM8Cx
xommsCfAJqJonwTb58ef6nmOBPB1Lv5RHxkAr1VlXBoBE7uMIYew/eKj545i
i3vUuzOxB2rH47qx79/KSi/G/uZCCy+RToCgauiyCvtoh2SyjkFAQYKMuXaO
AV94dwvdFxLg9vQ7z8+wVaP8yTRsdeQ2v2BsD0nt3g5s6hZSeCx2/xixNdaF
ABk3VlyK7a4T+1UuIiDgIlFWhd1zQ9hkxJ5gLaiRY5MaN/mCKwFc2u1bXdh+
D65767Dvi87d68fWO0XKuYsJyLDMGBnHjjkw6ZuHvTgn9Pkr7MIRwdVubMX0
yrdz2CuyNLwlTAL+A23tNgQ=
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  ImageMargins->0.,
  ImageSize->{225, Automatic},
  Method->{},
  PlotRange->{{0, 5}, {0., 27.105914640350544`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{229, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23744747]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->605478359],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"StruveL", "[", 
    RowBox[{"0", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->232918324],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    RowBox[{"2", " ", "x"}], "\[Pi]"], "+", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["x", "3"]}], 
    RowBox[{"9", " ", "\[Pi]"}]], "+", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["x", "5"]}], 
    RowBox[{"225", " ", "\[Pi]"}]], "+", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["x", "7"]}], 
    RowBox[{"11025", " ", "\[Pi]"}]], "+", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["x", "9"]}], 
    RowBox[{"893025", " ", "\[Pi]"}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "11"],
    SeriesData[$CellContext`x, 0, {}, 1, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
   2/Pi, 0, Rational[2, 9]/Pi, 0, Rational[2, 225]/Pi, 0, Rational[2, 11025]/
    Pi, 0, Rational[2, 893025]/Pi}, 1, 11, 1],
  Editable->False]], "Output",
 ImageSize->{301, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->403822170]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2692],

Cell["Evaluate for complex arguments and parameters:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->337704487],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StruveL", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"7", "/", "3"}], "+", "I"}], ",", 
   RowBox[{"4.5", "-", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->100710779],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.9772947884978261`"}], "-", 
  RowBox[{"10.825882606764095`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{141, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->32428760]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->84931005],

Cell["Evaluate to high precision:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->257377927],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"StruveL", "[", 
    RowBox[{"0", ",", "4"}], "]"}], ",", " ", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->80681587],

Cell[BoxData["11.\
1310502032485834309710004052035737903632192359957569210867168546238`50."], \
"Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->432627233]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->416893329],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->594100288],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StruveL", "[", 
  RowBox[{"0", ",", "4.000000000000000000000000"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->176846073],

Cell[BoxData["11.13105020324858343097100038714420547325`23.701441685457155"], \
"Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->277091748]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->262493211],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StruveL",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StruveL"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->843712961],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StruveL", "[", 
  RowBox[{"1", ",", " ", 
   RowBox[{"{", 
    RowBox[{"0.5", ",", "1.0", ",", "1.5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->540765259],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.05394218262352266`", ",", "0.22676438105580865`", ",", 
   "0.553856908446991`"}], "}"}]], "Output",
 ImageSize->{216, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->866336787]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1457207232],

Cell[TextData[{
 "For half-integer indices, ",
 Cell[BoxData[
  ButtonBox["StruveL",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StruveL"]], "InlineFormula"],
 " evaluates to elementary functions:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->514919149],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StruveL", "[", 
  RowBox[{
   RowBox[{"1", "/", "2"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->43578819],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    SqrtBox[
     FractionBox["2", "\[Pi]"]], 
    SqrtBox["x"]]}], "+", 
  FractionBox[
   RowBox[{
    SqrtBox[
     FractionBox["2", "\[Pi]"]], " ", 
    RowBox[{"Cosh", "[", "x", "]"}]}], 
   SqrtBox["x"]]}]], "Output",
 ImageSize->{145, 59},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->546164828]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->109584694],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->292360],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StruveL", "[", 
   RowBox[{"\[Nu]", ",", "x"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->188102376],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox[
    StyleBox[
     InterpretationBox["L",
      StruveL,
      Editable->False,
      Selectable->False],
     FontWeight->"Bold",
     FontSlant->"Plain"], "\[Nu]"], "(", "x", ")"}], 
  TraditionalForm]], "Output",
 ImageSize->{30, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->118980631]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16346],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StruveL",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StruveL"]], "InlineFormula"],
 " can be applied to a power series:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->128267551],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StruveL", "[", 
  RowBox[{
   RowBox[{"1", "/", "3"}], ",", " ", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", "x"}], "]"}], "+", 
    RowBox[{
     RowBox[{"O", "[", "x", "]"}], "^", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->113762563],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    SuperscriptBox["x", 
     RowBox[{"4", "/", "3"}]], 
    RowBox[{
     SuperscriptBox["2", 
      RowBox[{"1", "/", "3"}]], " ", 
     SqrtBox["\[Pi]"], " ", 
     RowBox[{"Gamma", "[", 
      FractionBox["11", "6"], "]"}]}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], 
     RowBox[{"7", "/", "3"}]],
    SeriesData[$CellContext`x, 0, {}, 4, 7, 3],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {2^Rational[-1, 3] Pi^Rational[-1, 2]/Gamma[
     Rational[11, 6]]}, 4, 7, 3],
  Editable->False]], "Output",
 ImageSize->{181, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->131545298]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6628],

Cell["Solve the inhomogeneous Bessel differential equation:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->234677171],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", " ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], 
      RowBox[{
       RowBox[{"y", "''"}], "[", "x", "]"}]}], "+", 
     RowBox[{"x", " ", 
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}]}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", "1"}], ")"}], 
      RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", 
    RowBox[{
     FractionBox["2", "\[Pi]"], 
     RowBox[{"x", "^", "2"}]}]}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->580259273],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       RowBox[{"BesselJ", "[", 
        RowBox[{"1", ",", 
         RowBox[{"\[ImaginaryI]", " ", "x"}]}], "]"}]}], " ", 
      RowBox[{"C", "[", "1", "]"}]}], "+", 
     RowBox[{
      RowBox[{"BesselY", "[", 
       RowBox[{"1", ",", 
        RowBox[{
         RowBox[{"-", "\[ImaginaryI]"}], " ", "x"}]}], "]"}], " ", 
      RowBox[{"C", "[", "2", "]"}]}], "+", 
     RowBox[{"StruveL", "[", 
      RowBox[{"1", ",", "x"}], "]"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{466, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->717009958]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->241590735],

Cell["\<\
3D relativistic, non-Markovian transition PDF that has the Gaussian \
non-relativistic limit:\
\>", "ExampleText",
 CellID->144658663],

Cell[BoxData[
 RowBox[{
  RowBox[{"p", "[", 
   RowBox[{"t_", ",", "x_", ",", "y_", ",", "z_"}], "]"}], ":=", 
  RowBox[{"\[ScriptCapitalN]", " ", 
   RowBox[{"HeavisideTheta", "[", 
    RowBox[{"t", "-", 
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}], "+", 
       RowBox[{"z", "^", "2"}]}], "]"}]}], "]"}], " ", 
   RowBox[{"Exp", "[", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"t", "^", "2"}], "-", 
       RowBox[{"x", "^", "2"}], "-", 
       RowBox[{"y", "^", "2"}], "-", 
       RowBox[{"z", "^", "2"}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"2", " ", "\[Sigma]"}], ")"}]}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->642518099],

Cell[TextData[{
 "Its normalization ",
 Cell[BoxData[
  FormBox["\[ScriptCapitalN]", TraditionalForm]], "InlineMath"],
 " is computed after a change of variables ",
 Cell[BoxData[
  FormBox[
   RowBox[{"r", "=", 
    RowBox[{"t", " ", 
     RowBox[{"sin", "(", "\[Phi]", ")"}]}]}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->316489212],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"4", " ", "\[Pi]", " ", "\[ScriptCapitalN]", " ", 
    SuperscriptBox["t", "3"], " ", 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Cos", "[", "\[Phi]", "]"}], 
       SuperscriptBox[
        RowBox[{"Sin", "[", "\[Phi]", "]"}], "2"], 
       RowBox[{"Exp", "[", 
        RowBox[{
         FractionBox["t", 
          RowBox[{"2", "\[Sigma]"}]], 
         RowBox[{"Cos", "[", "\[Phi]", "]"}]}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Phi]", ",", "0", ",", 
        RowBox[{"\[Pi]", "/", "2"}]}], "}"}]}], "]"}]}], "//", 
   "FunctionExpand"}], "//", "Simplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->269649126],

Cell[BoxData[
 RowBox[{
  FractionBox["4", "3"], " ", "\[Pi]", " ", 
  SuperscriptBox["t", "2"], " ", "\[ScriptCapitalN]", " ", 
  RowBox[{"(", 
   RowBox[{"t", "+", 
    RowBox[{"3", " ", "\[Pi]", " ", "\[Sigma]", " ", 
     RowBox[{"BesselI", "[", 
      RowBox[{"2", ",", 
       FractionBox["t", 
        RowBox[{"2", " ", "\[Sigma]"}]]}], "]"}]}], "+", 
    RowBox[{"3", " ", "\[Pi]", " ", "\[Sigma]", " ", 
     RowBox[{"StruveL", "[", 
      RowBox[{"2", ",", 
       FractionBox["t", 
        RowBox[{"2", " ", "\[Sigma]"}]]}], "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{369, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->373354198]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->846717865],

Cell[TextData[{
 "The mean saddle order in the mean-field ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 "-trigonometric model as a function of temperature:"
}], "ExampleText",
 CellID->653743685],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{
       RowBox[{"StruveL", "[", 
        RowBox[{"0", ",", 
         RowBox[{"5", "/", "t"}]}], "]"}], "/", 
       RowBox[{"BesselI", "[", 
        RowBox[{"0", ",", 
         RowBox[{"5", "/", "t"}]}], "]"}]}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->328463743],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->57712175]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9147],

Cell["Derivative:", "ExampleText",
 CellID->328955054],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"StruveL", "[", 
    RowBox[{"\[Nu]", ",", "z"}], "]"}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->702917535],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["2", 
       RowBox[{"-", "\[Nu]"}]], " ", 
      SuperscriptBox["z", "\[Nu]"]}], 
     RowBox[{
      SqrtBox["\[Pi]"], " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{
        FractionBox["3", "2"], "+", "\[Nu]"}], "]"}]}]], "+", 
    RowBox[{"StruveL", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Nu]"}], ",", "z"}], "]"}], "+", 
    RowBox[{"StruveL", "[", 
     RowBox[{
      RowBox[{"1", "+", "\[Nu]"}], ",", "z"}], "]"}]}], ")"}]}]], "Output",
 ImageSize->{392, 48},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4069650]
}, Open  ]],

Cell["Anti-derivative:", "ExampleText",
 CellID->222817477],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"StruveL", "[", 
    RowBox[{"\[Nu]", ",", "z"}], "]"}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17719462],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["2", 
   RowBox[{
    RowBox[{"-", "2"}], "-", "\[Nu]"}]], " ", 
  SuperscriptBox["z", 
   RowBox[{"2", "+", "\[Nu]"}]], " ", 
  RowBox[{"Gamma", "[", 
   RowBox[{"1", "+", 
    FractionBox["\[Nu]", "2"]}], "]"}], " ", 
  RowBox[{"HypergeometricPFQRegularized", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"1", "+", 
       FractionBox["\[Nu]", "2"]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       FractionBox["3", "2"], "+", "\[Nu]"}], ",", 
      FractionBox["3", "2"], ",", 
      RowBox[{"2", "+", 
       FractionBox["\[Nu]", "2"]}]}], "}"}], ",", 
    FractionBox[
     SuperscriptBox["z", "2"], "4"]}], "]"}]}]], "Output",
 ImageSize->{564, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->26029559]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9407],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["StruveH",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StruveH"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BesselJ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BesselJ"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23679]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->32442],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "Tutorials",
 CellID->30353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->11234],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/ModifiedStruveFunction.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/BesselAiryStruveFunctions/StruveL/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->310520066],

Cell[TextData[ButtonBox["Bessel-Related Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BesselRelatedFunctions"]], "MoreAbout",
 CellID->441677600],

Cell[TextData[ButtonBox["Functions Used in Optics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsUsedInOptics"]], "MoreAbout",
 CellID->85243650]
}, Open  ]],

Cell["New in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"StruveL - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 24, 46.7982406}", "context" -> "System`", 
    "keywords" -> {"Bessel equation", "Struve function", "Struve function L"},
     "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "StruveL[n, z] gives the modified Struve function L n (z). ", 
    "synonyms" -> {"Struve L"}, "title" -> "StruveL", "type" -> "Symbol", 
    "uri" -> "ref/StruveL"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6322, 225, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->181411085]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 33340, 1189}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1982, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2605, 76, 45, 1, 70, "ObjectName",
 CellID->28785],
Cell[2653, 79, 768, 26, 70, "Usage",
 CellID->10593]
}, Open  ]],
Cell[CellGroupData[{
Cell[3458, 110, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3936, 127, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4059, 133, 983, 36, 70, "Notes",
 CellID->19508],
Cell[5045, 171, 571, 21, 70, "Notes",
 CellID->30811],
Cell[5619, 194, 245, 8, 70, "Notes",
 CellID->11362464],
Cell[5867, 204, 216, 7, 70, "Notes",
 CellID->31226],
Cell[6086, 213, 199, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[6322, 225, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->181411085],
Cell[CellGroupData[{
Cell[6707, 239, 147, 5, 70, "ExampleSection",
 CellID->85059955],
Cell[6857, 246, 63, 1, 70, "ExampleText",
 CellID->84309926],
Cell[CellGroupData[{
Cell[6945, 251, 128, 4, 28, "Input",
 CellID->630411116],
Cell[7076, 257, 176, 5, 36, "Output",
 CellID->552459084]
}, Open  ]],
Cell[7267, 265, 124, 3, 70, "ExampleDelimiter",
 CellID->61119163],
Cell[7394, 270, 520, 21, 70, "ExampleText",
 CellID->114350614],
Cell[CellGroupData[{
Cell[7939, 295, 241, 8, 70, "Input",
 CellID->70556718],
Cell[8183, 305, 2192, 46, 167, "Output",
 CellID->23744747]
}, Open  ]],
Cell[10390, 354, 125, 3, 70, "ExampleDelimiter",
 CellID->605478359],
Cell[CellGroupData[{
Cell[10540, 361, 245, 8, 70, "Input",
 CellID->232918324],
Cell[10788, 371, 1046, 34, 55, "Output",
 CellID->403822170]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11883, 411, 215, 7, 70, "ExampleSection",
 CellID->2692],
Cell[12101, 420, 226, 5, 70, "ExampleText",
 CellID->337704487],
Cell[CellGroupData[{
Cell[12352, 429, 201, 7, 70, "Input",
 CellID->100710779],
Cell[12556, 438, 269, 8, 36, "Output",
 CellID->32428760]
}, Open  ]],
Cell[12840, 449, 124, 3, 70, "ExampleDelimiter",
 CellID->84931005],
Cell[12967, 454, 207, 5, 70, "ExampleText",
 CellID->257377927],
Cell[CellGroupData[{
Cell[13199, 463, 185, 6, 70, "Input",
 CellID->80681587],
Cell[13387, 471, 236, 7, 36, "Output",
 CellID->432627233]
}, Open  ]],
Cell[13638, 481, 125, 3, 70, "ExampleDelimiter",
 CellID->416893329],
Cell[13766, 486, 250, 7, 70, "ExampleText",
 CellID->594100288],
Cell[CellGroupData[{
Cell[14041, 497, 151, 4, 70, "Input",
 CellID->176846073],
Cell[14195, 503, 220, 6, 36, "Output",
 CellID->277091748]
}, Open  ]],
Cell[14430, 512, 125, 3, 70, "ExampleDelimiter",
 CellID->262493211],
Cell[14558, 517, 345, 11, 70, "ExampleText",
 CellID->843712961],
Cell[CellGroupData[{
Cell[14928, 532, 196, 6, 70, "Input",
 CellID->540765259],
Cell[15127, 540, 276, 9, 36, "Output",
 CellID->866336787]
}, Open  ]],
Cell[15418, 552, 126, 3, 70, "ExampleDelimiter",
 CellID->1457207232],
Cell[15547, 557, 378, 12, 70, "ExampleText",
 CellID->514919149],
Cell[CellGroupData[{
Cell[15950, 573, 149, 5, 70, "Input",
 CellID->43578819],
Cell[16102, 580, 410, 17, 80, "Output",
 CellID->546164828]
}, Open  ]],
Cell[16527, 600, 125, 3, 70, "ExampleDelimiter",
 CellID->109584694],
Cell[16655, 605, 200, 7, 70, "ExampleText",
 CellID->292360],
Cell[CellGroupData[{
Cell[16880, 616, 169, 5, 70, "Input",
 CellID->188102376],
Cell[17052, 623, 414, 16, 50, "Output",
 CellID->118980631]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17515, 645, 239, 7, 70, "ExampleSection",
 CellID->16346],
Cell[17757, 654, 346, 11, 70, "ExampleText",
 CellID->128267551],
Cell[CellGroupData[{
Cell[18128, 669, 293, 10, 70, "Input",
 CellID->113762563],
Cell[18424, 681, 751, 25, 65, "Output",
 CellID->131545298]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19224, 712, 222, 7, 70, "ExampleSection",
 CellID->6628],
Cell[19449, 721, 233, 5, 70, "ExampleText",
 CellID->234677171],
Cell[CellGroupData[{
Cell[19707, 730, 632, 22, 70, "Input",
 CellID->580259273],
Cell[20342, 754, 743, 24, 36, "Output",
 CellID->717009958]
}, Open  ]],
Cell[21100, 781, 125, 3, 70, "ExampleDelimiter",
 CellID->241590735],
Cell[21228, 786, 144, 4, 70, "ExampleText",
 CellID->144658663],
Cell[21375, 792, 749, 23, 70, "Input",
 CellID->642518099],
Cell[22127, 817, 362, 13, 70, "ExampleText",
 CellID->316489212],
Cell[CellGroupData[{
Cell[22514, 834, 707, 21, 70, "Input",
 CellID->269649126],
Cell[23224, 857, 697, 20, 52, "Output",
 CellID->373354198]
}, Open  ]],
Cell[23936, 880, 125, 3, 70, "ExampleDelimiter",
 CellID->846717865],
Cell[24064, 885, 217, 6, 70, "ExampleText",
 CellID->653743685],
Cell[CellGroupData[{
Cell[24306, 895, 499, 17, 70, "Input",
 CellID->328463743],
Cell[24808, 914, 2241, 41, 70, "Output",
 Evaluatable->False,
 CellID->57712175]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[27098, 961, 232, 7, 70, "ExampleSection",
 CellID->9147],
Cell[27333, 970, 54, 1, 70, "ExampleText",
 CellID->328955054],
Cell[CellGroupData[{
Cell[27412, 975, 184, 6, 70, "Input",
 CellID->702917535],
Cell[27599, 983, 743, 26, 69, "Output",
 CellID->4069650]
}, Open  ]],
Cell[28357, 1012, 59, 1, 70, "ExampleText",
 CellID->222817477],
Cell[CellGroupData[{
Cell[28441, 1017, 191, 6, 70, "Input",
 CellID->17719462],
Cell[28635, 1025, 854, 29, 54, "Output",
 CellID->26029559]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[29550, 1061, 310, 9, 70, "SeeAlsoSection",
 CellID->9407],
Cell[29863, 1072, 447, 17, 70, "SeeAlso",
 CellID->23679]
}, Open  ]],
Cell[CellGroupData[{
Cell[30347, 1094, 314, 9, 70, "TutorialsSection",
 CellID->32442],
Cell[30664, 1105, 144, 3, 70, "Tutorials",
 CellID->30353]
}, Open  ]],
Cell[CellGroupData[{
Cell[30845, 1113, 321, 9, 70, "RelatedLinksSection",
 CellID->11234],
Cell[31169, 1124, 193, 4, 70, "RelatedLinks"],
Cell[31365, 1130, 205, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[31607, 1139, 319, 9, 70, "MoreAboutSection",
 CellID->310520066],
Cell[31929, 1150, 158, 3, 70, "MoreAbout",
 CellID->441677600],
Cell[32090, 1155, 156, 3, 70, "MoreAbout",
 CellID->85243650]
}, Open  ]],
Cell[32261, 1161, 27, 0, 70, "History"],
Cell[32291, 1163, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

