(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15017,        532]
NotebookOptionsPosition[     11783,        424]
NotebookOutlinePosition[     12977,        459]
CellTagsIndexPosition[     12892,        454]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Operators without Built\[Hyphen]in Meanings" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OperatorsWithoutBuiltInMeanings"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Operators without Built\[Hyphen]in Meanings\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SuperStar" :> Documentation`HelpLookup["paclet:ref/SuperStar"],
           "Subscript" :> Documentation`HelpLookup["paclet:ref/Subscript"], 
          "SubPlus" :> Documentation`HelpLookup["paclet:ref/SubPlus"], 
          "SubMinus" :> Documentation`HelpLookup["paclet:ref/SubMinus"], 
          "Style" :> Documentation`HelpLookup["paclet:ref/Style"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"SuperStar\"\>", 
       2->"\<\"Subscript\"\>", 3->"\<\"SubPlus\"\>", 4->"\<\"SubMinus\"\>", 
       5->"\<\"Style\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Symbolic Notational Forms" :> 
          Documentation`HelpLookup[
           "paclet:guide/SymbolicNotationalForms"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Symbolic Notational Forms\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["SubStar", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SubStar",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SubStar"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]displays as ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["expr", "TI"], "*"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SubStar",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SubStar"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " can be entered using ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["_", "KeyEvent"],
 " and ",
 StyleBox["*", "KeyEvent"],
 "."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SubStar",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SubStar"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " remains unchanged by evaluation."
}], "Notes",
 CellID->10989299]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->213818467],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->22051622],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SubStar",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SubStar"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " is formatted as ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with a subscript asterisk:"
}], "ExampleText",
 CellID->261631018],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SubStar", "[", "x", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->490094056],

Cell[BoxData[
 SubscriptBox["x", "*"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->87355407]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->277103029],

Cell[TextData[{
 "Define a meaning for ",
 Cell[BoxData[
  ButtonBox["SubStar",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SubStar"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->604913348],

Cell[BoxData[
 RowBox[{
  RowBox[{"SubStar", "[", "f_", "]"}], ":=", 
  RowBox[{"First", "@", 
   RowBox[{"FindMinimum", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"f", "[", "x", "]"}], ",", 
       RowBox[{"0", "\[LessEqual]", "x", "\[LessEqual]", "1"}]}], "}"}], ",", 
     
     RowBox[{"{", "x", "}"}]}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->318052525],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", "x"}], "]"}], "+", 
   RowBox[{"x", "^", "2"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->426604553],

Cell[CellGroupData[{

Cell[BoxData[
 SubscriptBox["f", "*"]], "Input",
 CellLabel->"In[3]:=",
 CellID->158693607],

Cell[BoxData["0.827184026127528`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->169371094]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 SubscriptBox["Exp", "*"]], "Input",
 CellLabel->"In[4]:=",
 CellID->500183840],

Cell[BoxData["1.0000022995152198`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->233618994]
}, Open  ]],

Cell["Clear definitions:", "ExampleText",
 CellID->265418708],

Cell[BoxData[
 RowBox[{"Clear", "[", "SubStar", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->187175017]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SuperStar",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SuperStar"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Subscript",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Subscript"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SubPlus",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SubPlus"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SubMinus",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SubMinus"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Operators without Built\[Hyphen]in Meanings",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OperatorsWithoutBuiltInMeanings"]], "Tutorials",\

 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Symbolic Notational Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicNotationalForms"]], "MoreAbout",
 CellID->139406141]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SubStar - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 25, 11.4551218}", "context" -> "System`", 
    "keywords" -> {"subscript star", "subscript *"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "SubStar[expr] displays as expr_*.", "synonyms" -> {"sub star"}, "title" -> 
    "SubStar", "type" -> "Symbol", "uri" -> "ref/SubStar"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6170, 191, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->213818467]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12749, 447}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2211, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2834, 80, 1572, 37, 70, "ObjectNameGrid"],
Cell[4409, 119, 565, 19, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5011, 143, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5489, 160, 386, 15, 70, "Notes",
 CellID->1067943069],
Cell[5878, 177, 255, 9, 70, "Notes",
 CellID->10989299]
}, Closed]],
Cell[CellGroupData[{
Cell[6170, 191, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->213818467],
Cell[CellGroupData[{
Cell[6555, 205, 147, 5, 70, "ExampleSection",
 CellID->22051622],
Cell[6705, 212, 338, 12, 70, "ExampleText",
 CellID->261631018],
Cell[CellGroupData[{
Cell[7068, 228, 103, 3, 28, "Input",
 CellID->490094056],
Cell[7174, 233, 178, 6, 36, "Output",
 CellID->87355407]
}, Open  ]],
Cell[7367, 242, 125, 3, 70, "ExampleDelimiter",
 CellID->277103029],
Cell[7495, 247, 202, 8, 70, "ExampleText",
 CellID->604913348],
Cell[7700, 257, 397, 13, 70, "Input",
 CellID->318052525],
Cell[8100, 272, 220, 8, 70, "Input",
 CellID->426604553],
Cell[CellGroupData[{
Cell[8345, 284, 91, 3, 70, "Input",
 CellID->158693607],
Cell[8439, 289, 175, 5, 36, "Output",
 CellID->169371094]
}, Open  ]],
Cell[CellGroupData[{
Cell[8651, 299, 93, 3, 70, "Input",
 CellID->500183840],
Cell[8747, 304, 176, 5, 36, "Output",
 CellID->233618994]
}, Open  ]],
Cell[8938, 312, 61, 1, 70, "ExampleText",
 CellID->265418708],
Cell[9002, 315, 107, 3, 70, "Input",
 CellID->187175017]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9158, 324, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[9477, 335, 1186, 44, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[10700, 384, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[11021, 395, 191, 4, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[11249, 404, 299, 8, 70, "MoreAboutSection"],
Cell[11551, 414, 160, 3, 70, "MoreAbout",
 CellID->139406141]
}, Open  ]],
Cell[11726, 420, 27, 0, 70, "History"],
Cell[11756, 422, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

