(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18665,        650]
NotebookOptionsPosition[     15047,        530]
NotebookOutlinePosition[     16335,        566]
CellTagsIndexPosition[     16250,        561]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Operators without Built\[Hyphen]in Meanings" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OperatorsWithoutBuiltInMeanings"], 
          "Names of Symbols and Mathematical Objects" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NamesOfSymbolsAndMathematicalObjects"], 
          "Formatted Output" :> 
          Documentation`HelpLookup["paclet:tutorial/FormattedOutput"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Operators without Built\[Hyphen]in Meanings\"\>", 
       2->"\<\"Names of Symbols and Mathematical Objects\"\>", 
       3->"\<\"Formatted Output\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Superscript" :> 
          Documentation`HelpLookup["paclet:ref/Superscript"], 
          "Subsuperscript" :> 
          Documentation`HelpLookup["paclet:ref/Subsuperscript"], 
          "Underscript" :> Documentation`HelpLookup["paclet:ref/Underscript"],
           "ScriptSizeMultipliers" :> 
          Documentation`HelpLookup["paclet:ref/ScriptSizeMultipliers"], 
          "SubscriptBox" :> 
          Documentation`HelpLookup["paclet:ref/SubscriptBox"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Superscript\"\>", 
       2->"\<\"Subsuperscript\"\>", 3->"\<\"Underscript\"\>", 
       4->"\<\"ScriptSizeMultipliers\"\>", 
       5->"\<\"SubscriptBox\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Defining Custom Notation" :> 
          Documentation`HelpLookup["paclet:guide/DefiningCustomNotation"], 
          "Mathematical Typesetting" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalTypesetting"], 
          "Symbolic Notational Forms" :> 
          Documentation`HelpLookup[
           "paclet:guide/SymbolicNotationalForms"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Defining Custom Notation\"\>", 
       2->"\<\"Mathematical Typesetting\"\>", 
       3->"\<\"Symbolic Notational Forms\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Subscript", "ObjectName",
 CellID->3788],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Subscript",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Subscript"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is an object that formats as ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["x", "y"], TraditionalForm]], "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Subscript",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Subscript"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        SubscriptBox[
         StyleBox["y", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["y", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]formats as ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["x", 
        RowBox[{
         SubscriptBox["y", "1"], ",", 
         SubscriptBox["y", "2"], ",", "\[Ellipsis]"}]], TraditionalForm]], 
      "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->18127]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "In a notebook, a subscript can be created using ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["_", "KeyEvent"],
 " or ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["-", "KeyEvent"],
 ". ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 " moves out of the subscript position. "
}], "Notes",
 CellID->467],

Cell[TextData[{
 "Input of the form ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "y"], TraditionalForm]], "InlineMath"],
 " in a notebook is interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Subscript",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Subscript"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->3728],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Subscript",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Subscript"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 " formats as ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "y"], TraditionalForm]], "InlineMath"],
 " in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->14893],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Subscript",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Subscript"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 " formats literally as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Subscript",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Subscript"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->24648],

Cell[TextData[{
 "The baseline of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Subscript",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Subscript"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 " is taken to be the baseline of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->22483],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Subscript",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Subscript"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 " is normally output with ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " in a smaller font than ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->17807]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->306493533],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->451592929],

Cell["Generate a subscript:", "ExampleText",
 CellID->560080177],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Subscript", "[", 
  RowBox[{"a", ",", "n"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8127159],

Cell[BoxData[
 SubscriptBox["a", "n"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->32884567]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->114262366],

Cell[TextData[{
 "To enter directly enter ",
 StyleBox["a", "InlineCode"],
 " ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["n", "KeyEvent"],
 ":"
}], "ExampleText",
 CellID->82618625],

Cell[BoxData[
 SubscriptBox["a", "n"]], "Input",
 CellLabel->"In[1]:=",
 CellID->265648660],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->153763390],

Cell["A matrix of subscripted elements:", "ExampleText",
 CellID->117174971],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Array", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Subscript", "[", 
      RowBox[{"a", ",", "#1", ",", "#2"}], "]"}], "&"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3"}], "}"}]}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->212570835],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztVztPAkEQXu6Qh6gRn2gs/AP+Da38BRaEEBOuMBqloKOkpKTkJ1BSUlJS
UlJSUlKeM/vglmEOFgE1xktub2dnZuexs9/tPpaqleeXUjUol24f3ktvlaD8
cXv/+g5DfkIIEcB7VxDQD6En3yAM4XuJrY+0fMTNCjovtbD1YDBJuHuC8JIz
HjwoeBLLxdEjOfuenLXdbutZc8SKZ0zNdKEvzjmpyAJ0LjiJJbTyo16va9qX
06iYh8Nht9uVJqBBZ6h2mtC5LculTJYGgwH1rtVq2T4v5IquW4rQ+zvUonGo
LE+n01qtFsXhm1EVipplYW47R0hnnDyiWmlC576kpWw3Gg1wOjTVJOPw+v0+
5gqL0WdyiJV/GMPnqsNFTtFQolCo897I6hiPx/FZvV5jVOFHtBtsO9HOwTVG
527It2BWWW32GO2i8VrTiSVSEf0XpST6roHWh06zYk35TE0ZNJ/xWDTnuVjT
+87Wbat8TZ5yUnPofsZJLEH3tJN3WLk/ge4ZJ+/4XK3CBh4Vt6NFEdgty78f
3bNOcWC1fCfKb1Il66B8wTl6DuWvnLSL/1J6dDcoj7uFQx4cO7Z5Cyifj+VG
KN9sNpdaPyBW+XMpxXDyXxGLp3y6Q3hcje4StndwophMJmH4cyiv6NFo1Ol0
Zt5r7+BApU/2vx/l1U2g1+sxp01IsY5ul3HYd5F4lF+lpeKCWp47w9M7FdJJ
vbqe1rLR3YxnibXcCj79V0bWPaiEzVEc778erIWcSd+75m+KHHpfMnJGW10j
sPtEaCUVWK1IfAJlIkc1\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{105, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->17073241]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14309],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Superscript",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Superscript"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Subsuperscript",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Subsuperscript"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Underscript",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Underscript"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ScriptSizeMultipliers",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ScriptSizeMultipliers"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SubscriptBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SubscriptBox"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->7616]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->2421],

Cell[TextData[ButtonBox["Operators without Built\[Hyphen]in Meanings",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OperatorsWithoutBuiltInMeanings"]], "Tutorials",\

 CellID->14310],

Cell[TextData[ButtonBox["Names of Symbols and Mathematical Objects",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NamesOfSymbolsAndMathematicalObjects"]], "Tutorials",
 CellID->6617],

Cell[TextData[ButtonBox["Formatted Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FormattedOutput"]], "Tutorials",
 CellID->444657240]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->211831955],

Cell[TextData[ButtonBox["Defining Custom Notation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DefiningCustomNotation"]], "MoreAbout",
 CellID->624489574],

Cell[TextData[ButtonBox["Mathematical Typesetting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalTypesetting"]], "MoreAbout",
 CellID->827543974],

Cell[TextData[ButtonBox["Symbolic Notational Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicNotationalForms"]], "MoreAbout",
 CellID->112362885]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Subscript - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 25, 5.8456032}", "context" -> "System`", 
    "keywords" -> {"sub in HTML", "subscript index"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Subscript[x, y] is an object that formats as x_y. Subscript[x, y_1, y_2, \
...] formats as x Subscript[y, 1], Subscript[y, 2], ....", "synonyms" -> {}, 
    "title" -> "Subscript", "type" -> "Symbol", "uri" -> "ref/Subscript"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8667, 296, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->306493533]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16107, 554}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3047, 69, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3670, 96, 46, 1, 70, "ObjectName",
 CellID->3788],
Cell[3719, 99, 1376, 46, 70, "Usage",
 CellID->18127]
}, Open  ]],
Cell[CellGroupData[{
Cell[5132, 150, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5610, 167, 445, 15, 70, "Notes",
 CellID->467],
Cell[6058, 184, 415, 16, 70, "Notes",
 CellID->3728],
Cell[6476, 202, 651, 25, 70, "Notes",
 CellID->14893],
Cell[7130, 229, 649, 26, 70, "Notes",
 CellID->24648],
Cell[7782, 257, 390, 15, 70, "Notes",
 CellID->22483],
Cell[8175, 274, 455, 17, 70, "Notes",
 CellID->17807]
}, Closed]],
Cell[CellGroupData[{
Cell[8667, 296, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->306493533],
Cell[CellGroupData[{
Cell[9052, 310, 148, 5, 70, "ExampleSection",
 CellID->451592929],
Cell[9203, 317, 64, 1, 70, "ExampleText",
 CellID->560080177],
Cell[CellGroupData[{
Cell[9292, 322, 126, 4, 28, "Input",
 CellID->8127159],
Cell[9421, 328, 178, 6, 36, "Output",
 CellID->32884567]
}, Open  ]],
Cell[9614, 337, 125, 3, 70, "ExampleDelimiter",
 CellID->114262366],
Cell[9742, 342, 219, 9, 70, "ExampleText",
 CellID->82618625],
Cell[9964, 353, 91, 3, 70, "Input",
 CellID->265648660],
Cell[10058, 358, 125, 3, 70, "ExampleDelimiter",
 CellID->153763390],
Cell[10186, 363, 76, 1, 70, "ExampleText",
 CellID->117174971],
Cell[CellGroupData[{
Cell[10287, 368, 307, 10, 28, "Input",
 CellID->212570835],
Cell[10597, 380, 1036, 21, 80, "Output",
 Evaluatable->False,
 CellID->17073241]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11694, 408, 311, 9, 70, "SeeAlsoSection",
 CellID->14309],
Cell[12008, 419, 1243, 44, 70, "SeeAlso",
 CellID->7616]
}, Open  ]],
Cell[CellGroupData[{
Cell[13288, 468, 313, 9, 70, "TutorialsSection",
 CellID->2421],
Cell[13604, 479, 187, 4, 70, "Tutorials",
 CellID->14310],
Cell[13794, 485, 190, 4, 70, "Tutorials",
 CellID->6617],
Cell[13987, 491, 146, 3, 70, "Tutorials",
 CellID->444657240]
}, Open  ]],
Cell[CellGroupData[{
Cell[14170, 499, 319, 9, 70, "MoreAboutSection",
 CellID->211831955],
Cell[14492, 510, 158, 3, 70, "MoreAbout",
 CellID->624489574],
Cell[14653, 515, 159, 3, 70, "MoreAbout",
 CellID->827543974],
Cell[14815, 520, 160, 3, 70, "MoreAbout",
 CellID->112362885]
}, Open  ]],
Cell[14990, 526, 27, 0, 70, "History"],
Cell[15020, 528, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

