(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    144013,       3332]
NotebookOptionsPosition[    135220,       3021]
NotebookOutlinePosition[    136790,       3062]
CellTagsIndexPosition[    136703,       3057]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Lists as Sets" :> 
          Documentation`HelpLookup["paclet:tutorial/ListsAsSets"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Lists as Sets\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Tuples" :> Documentation`HelpLookup["paclet:ref/Tuples"], 
          "IntegerDigits" :> 
          Documentation`HelpLookup["paclet:ref/IntegerDigits"], "Binomial" :> 
          Documentation`HelpLookup["paclet:ref/Binomial"], 
          "IntegerPartitions" :> 
          Documentation`HelpLookup["paclet:ref/IntegerPartitions"], 
          "SymmetricPolynomial" :> 
          Documentation`HelpLookup["paclet:ref/SymmetricPolynomial"], "BellB" :> 
          Documentation`HelpLookup["paclet:ref/BellB"], "RandomSample" :> 
          Documentation`HelpLookup["paclet:ref/RandomSample"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Tuples\"\>", 
       2->"\<\"IntegerDigits\"\>", 3->"\<\"Binomial\"\>", 
       4->"\<\"IntegerPartitions\"\>", 5->"\<\"SymmetricPolynomial\"\>", 
       6->"\<\"BellB\"\>", 7->"\<\"RandomSample\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Constructing Lists" :> 
          Documentation`HelpLookup["paclet:guide/ConstructingLists"], 
          "Discrete Mathematics" :> 
          Documentation`HelpLookup["paclet:guide/DiscreteMathematics"], 
          "Math & Counting Operations on Lists" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicalAndCountingOperationsOnLists"], 
          "Rearranging & Restructuring Lists" :> 
          Documentation`HelpLookup[
           "paclet:guide/RearrangingAndRestructuringLists"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Constructing Lists\"\>", 
       2->"\<\"Discrete Mathematics\"\>", 
       3->"\<\"Math & Counting Operations on Lists\"\>", 
       4->"\<\"Rearranging & Restructuring Lists\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Subsets", "ObjectName",
 CellID->10808],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Subsets",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Subsets"], "[", 
       StyleBox["list", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of all possible subsets of ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Subsets",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Subsets"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives all subsets containing at most ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " elements. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Subsets",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Subsets"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        RowBox[{"{", 
         StyleBox["n", "TI"], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives all subsets containing exactly ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " elements. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Subsets",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Subsets"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["n", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["n", "TI"], 
           StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives all subsets containing between ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     " elements. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Subsets",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Subsets"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["nspec", "TI"], ",", 
        StyleBox["s", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the first ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     " subsets. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Subsets",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Subsets"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["nspec", "TI"], ",", 
        RowBox[{"{", 
         StyleBox["s", "TI"], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the ",
     Cell[BoxData[
      StyleBox[
       RowBox[{
        StyleBox["s", "TI"], "\[Null]"}]]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " subset. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->1832]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Subsets",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Subsets"], "[", 
   StyleBox["list", "TI"], "]"}]], "InlineFormula"],
 " gives the power set of ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->20945],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Subsets",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Subsets"], "[", 
   StyleBox["list", "TI"], "]"}]], "InlineFormula"],
 " orders subsets with shortest first, and later elements in ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " omitted first. "
}], "Notes",
 CellID->27756],

Cell[TextData[{
 "If the elements of ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " are in the order returned by ",
 Cell[BoxData[
  ButtonBox["Sort",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sort"]], "InlineFormula"],
 ", then the complete result from ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Subsets",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Subsets"], "[", 
   StyleBox["list", "TI"], "]"}]], "InlineFormula"],
 " will also be in this order. "
}], "Notes",
 CellID->28321],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Subsets",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Subsets"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Subsets",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Subsets"], "[", 
   StyleBox["list", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->19558],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Subsets",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Subsets"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["min", "TI"]], ",", 
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["max", "TI"]], ",", 
      StyleBox["dn", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
 " gives subsets containing ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["n", "TI"], 
   StyleBox["min", "TI"]]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["n", "TI"], 
    StyleBox["min", "TI"]], "+", 
   StyleBox["dn", "TI"]}]], "InlineFormula"],
 ", \[Ellipsis]",
 " ",
 " elements. "
}], "Notes",
 CellID->23646],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Subsets",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Subsets"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    StyleBox["nspec", "TI"], ",", 
    StyleBox["spec", "TI"]}], "]"}]], "InlineFormula"],
 " gives the same result as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Take",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Take"], "[", 
   RowBox[{
    RowBox[{"Subsets", "[", 
     RowBox[{
      StyleBox["list", "TI"], ",", 
      StyleBox["nspec", "TI"]}], "]"}], ",", 
    StyleBox["spec", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->27982]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->191537667],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->220817592],

Cell["All possible subsets (power set):", "ExampleText",
 CellID->10466],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Subsets", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12044],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", "a", "}"}], ",", 
   RowBox[{"{", "b", "}"}], ",", 
   RowBox[{"{", "c", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "}"}]], "Output",
 ImageSize->{349, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21659]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26292],

Cell["All possible subsets containing up to 2 elements:", "ExampleText",
 CellID->26439],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Subsets", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "2"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17253],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", "a", "}"}], ",", 
   RowBox[{"{", "b", "}"}], ",", 
   RowBox[{"{", "c", "}"}], ",", 
   RowBox[{"{", "d", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d"}], "}"}]}], "}"}]], "Output",
 ImageSize->{463, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20024]
}, Open  ]],

Cell["Subsets containing exactly 2 elements:", "ExampleText",
 CellID->26154],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Subsets", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29510],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d"}], "}"}]}], "}"}]], "Output",
 ImageSize->{310, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->4745]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13186],

Cell["The first 5 subsets containing 3 elements:", "ExampleText",
 CellID->8313],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Subsets", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
   RowBox[{"{", "3", "}"}], ",", "5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4474],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "e"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "c", ",", "e"}], "}"}]}], "}"}]], "Output",
 ImageSize->{350, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->28022]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2168],

Cell["Use any head:", "ExampleText",
 CellID->14018],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Subsets", "[", 
  RowBox[{"f", "[", 
   RowBox[{"a", ",", "b", ",", "c"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18787],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "]"}], ",", 
   RowBox[{"f", "[", "a", "]"}], ",", 
   RowBox[{"f", "[", "b", "]"}], ",", 
   RowBox[{"f", "[", "c", "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "b"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "c"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"b", ",", "c"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}]}], "}"}]], "Output",
 ImageSize->{405, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9905]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Subsets", "[", 
  RowBox[{"a", "+", "b", "+", "c"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17958],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "a", ",", "b", ",", "c", ",", 
   RowBox[{"a", "+", "b"}], ",", 
   RowBox[{"a", "+", "c"}], ",", 
   RowBox[{"b", "+", "c"}], ",", 
   RowBox[{"a", "+", "b", "+", "c"}]}], "}"}]], "Output",
 ImageSize->{251, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->7391]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3625],

Cell["Find all ways to pick 3 elements from 4:", "ExampleText",
 CellID->26477],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Subsets", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", "3", "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4414],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "4"}], "}"}]}], "}"}]], "Output",
 ImageSize->{282, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9314]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Binomial", "[", 
  RowBox[{"4", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->25824],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->29334]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25874],

Cell["Draw lines between all pairs of points in an octagon:", "ExampleText",
 CellID->24372],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Line", "[", 
   RowBox[{"Subsets", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{"2", "Pi", " ", 
           RowBox[{"i", "/", "8"}]}], "]"}], ",", 
         RowBox[{"Sin", "[", 
          RowBox[{"2", " ", "Pi", " ", 
           RowBox[{"i", "/", "8"}]}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "8"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", "2", "}"}]}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20159],

Cell[BoxData[
 GraphicsBox[
  LineBox[{{{2^Rational[-1, 2], 2^Rational[-1, 2]}, {0, 1}}, {{
     2^Rational[-1, 2], 2^Rational[-1, 2]}, {-2^Rational[-1, 2], 2^
      Rational[-1, 2]}}, {{2^Rational[-1, 2], 2^Rational[-1, 2]}, {-1, 0}}, {{
     2^Rational[-1, 2], 2^
      Rational[-1, 2]}, {-2^Rational[-1, 2], -2^Rational[-1, 2]}}, {{
     2^Rational[-1, 2], 2^Rational[-1, 2]}, {0, -1}}, {{
     2^Rational[-1, 2], 2^Rational[-1, 2]}, {
     2^Rational[-1, 2], -2^Rational[-1, 2]}}, {{
     2^Rational[-1, 2], 2^Rational[-1, 2]}, {1, 0}}, {{0, 
     1}, {-2^Rational[-1, 2], 2^Rational[-1, 2]}}, {{0, 1}, {-1, 
    0}}, {{0, 1}, {-2^Rational[-1, 2], -2^Rational[-1, 2]}}, {{0, 1}, {
    0, -1}}, {{0, 1}, {2^Rational[-1, 2], -2^Rational[-1, 2]}}, {{0, 1}, {1, 
    0}}, {{-2^Rational[-1, 2], 2^Rational[-1, 2]}, {-1, 
     0}}, {{-2^Rational[-1, 2], 2^
      Rational[-1, 2]}, {-2^Rational[-1, 2], -2^Rational[-1, 2]}}, {{-2^
       Rational[-1, 2], 2^Rational[-1, 2]}, {
     0, -1}}, {{-2^Rational[-1, 2], 2^Rational[-1, 2]}, {
     2^Rational[-1, 2], -2^Rational[-1, 2]}}, {{-2^Rational[-1, 2], 2^
      Rational[-1, 2]}, {1, 0}}, {{-1, 
     0}, {-2^Rational[-1, 2], -2^Rational[-1, 2]}}, {{-1, 0}, {
    0, -1}}, {{-1, 0}, {2^Rational[-1, 2], -2^Rational[-1, 2]}}, {{-1, 0}, {1,
     0}}, {{-2^Rational[-1, 2], -2^Rational[-1, 2]}, {
     0, -1}}, {{-2^Rational[-1, 2], -2^Rational[-1, 2]}, {
     2^Rational[-1, 2], -2^Rational[-1, 2]}}, {{-2^Rational[-1, 2], -2^
       Rational[-1, 2]}, {1, 0}}, {{0, -1}, {
     2^Rational[-1, 2], -2^Rational[-1, 2]}}, {{0, -1}, {1, 
    0}}, {{2^Rational[-1, 2], -2^Rational[-1, 2]}, {1, 0}}}]]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11833]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28070],

Cell["Construct an elementary symmetric polynomial:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->7487],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", 
  RowBox[{"Subsets", "[", 
   RowBox[{
    RowBox[{"Times", "[", 
     RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "]"}], ",", 
    RowBox[{"{", "3", "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28297],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", "b", " ", "c"}], "+", 
  RowBox[{"a", " ", "b", " ", "d"}], "+", 
  RowBox[{"a", " ", "c", " ", "d"}], "+", 
  RowBox[{"b", " ", "c", " ", "d"}], "+", 
  RowBox[{"a", " ", "b", " ", "e"}], "+", 
  RowBox[{"a", " ", "c", " ", "e"}], "+", 
  RowBox[{"b", " ", "c", " ", "e"}], "+", 
  RowBox[{"a", " ", "d", " ", "e"}], "+", 
  RowBox[{"b", " ", "d", " ", "e"}], "+", 
  RowBox[{"c", " ", "d", " ", "e"}]}]], "Output",
 ImageSize->{388, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7518]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8177],

Cell["All possible subsets of the divisors of 10:", "ExampleText",
 CellID->17773],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Subsets", "[", 
  RowBox[{"Divisors", "[", "10", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32270],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", "2", "}"}], ",", 
   RowBox[{"{", "5", "}"}], ",", 
   RowBox[{"{", "10", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "5", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "5", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "5", ",", "10"}], "}"}]}], "}"}]], "Output",
 ImageSize->{454, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1763]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2668],

Cell["Find integers that have exactly 3 nonzero binary digits:", "ExampleText",
 CellID->17192],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Subsets", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4", ",", "8", ",", "16"}], "}"}], ",", 
   RowBox[{"{", "3", "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13985],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "4", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "4", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "8", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "8", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "8", ",", "16"}], "}"}]}], "}"}]], "Output",
 ImageSize->{378, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3102]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "/@", "%"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8480],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "7", ",", "11", ",", "19", ",", "13", ",", "21", ",", "25", ",", "14", ",", 
   "22", ",", "26", ",", "28"}], "}"}]], "Output",
 ImageSize->{252, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->29213]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7627],

Cell["Join all possible pairs of 20 random points in 3D:", "ExampleText",
 CellID->4802],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Line", "/@", 
   RowBox[{"Subsets", "[", 
    RowBox[{
     RowBox[{"RandomReal", "[", 
      RowBox[{"100", ",", 
       RowBox[{"{", 
        RowBox[{"20", ",", "3"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", "2", "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4099],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 185},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->122142436]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2625],

Cell["Draw lines between all pairs of points in a cube:", "ExampleText",
 CellID->1543],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Line", "[", 
   RowBox[{"Subsets", "[", 
    RowBox[{
     RowBox[{"Tuples", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], ",", "3"}], "]"}], ",", 
     RowBox[{"{", "2", "}"}]}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1924],

Cell[BoxData[
 Graphics3DBox[
  Line3DBox[{{{1, 1, 1}, {1, 1, 0}}, {{1, 1, 1}, {1, 0, 1}}, {{1, 1, 1}, {1, 
   0, 0}}, {{1, 1, 1}, {0, 1, 1}}, {{1, 1, 1}, {0, 1, 0}}, {{1, 1, 1}, {0, 0, 
   1}}, {{1, 1, 1}, {0, 0, 0}}, {{1, 1, 0}, {1, 0, 1}}, {{1, 1, 0}, {1, 0, 
   0}}, {{1, 1, 0}, {0, 1, 1}}, {{1, 1, 0}, {0, 1, 0}}, {{1, 1, 0}, {0, 0, 
   1}}, {{1, 1, 0}, {0, 0, 0}}, {{1, 0, 1}, {1, 0, 0}}, {{1, 0, 1}, {0, 1, 
   1}}, {{1, 0, 1}, {0, 1, 0}}, {{1, 0, 1}, {0, 0, 1}}, {{1, 0, 1}, {0, 0, 
   0}}, {{1, 0, 0}, {0, 1, 1}}, {{1, 0, 0}, {0, 1, 0}}, {{1, 0, 0}, {0, 0, 
   1}}, {{1, 0, 0}, {0, 0, 0}}, {{0, 1, 1}, {0, 1, 0}}, {{0, 1, 1}, {0, 0, 
   1}}, {{0, 1, 1}, {0, 0, 0}}, {{0, 1, 0}, {0, 0, 1}}, {{0, 1, 0}, {0, 0, 
   0}}, {{0, 0, 1}, {0, 0, 0}}}]]], "Output",
 ImageSize->{245, 262},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{241., Automatic}},
 CellLabel->"Out[1]=",
 CellID->11023,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29972],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Subsets",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Subsets"]], "InlineFormula"],
 " picks out first the elements that appear first in the input:"
}], "ExampleText",
 CellID->13061],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Subsets", "[", 
  RowBox[{"{", 
   RowBox[{"c", ",", "b", ",", "a"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14181],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", "c", "}"}], ",", 
   RowBox[{"{", "b", "}"}], ",", 
   RowBox[{"{", "a", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "b", ",", "a"}], "}"}]}], "}"}]], "Output",
 ImageSize->{349, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->31003]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27432],

Cell["\<\
Different occurrences of the same element are treated as distinct:\
\>", "ExampleText",
 CellID->17505],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Subsets", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "b", ",", "b"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27593],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", "a", "}"}], ",", 
   RowBox[{"{", "b", "}"}], ",", 
   RowBox[{"{", "b", "}"}], ",", 
   RowBox[{"{", "b", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "b", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "b", ",", "b"}], "}"}]}], "}"}]], "Output",
 ImageSize->{419, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22725]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13031],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Tuples",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tuples"]], "InlineFormula"],
 " gives all possible combinations and reorderings of elements:"
}], "ExampleText",
 CellID->8492],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tuples", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->142],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "c"}], "}"}]}], "}"}]], "Output",
 ImageSize->{461, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17222]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Subsets", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->31286],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c"}], "}"}]}], "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->13064]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8360],

Cell["Polygons formed from all possible triples of random points:", \
"ExampleText",
 CellID->30974],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Opacity", "[", "0.01", "]"}], ",", 
    RowBox[{"Polygon", "/@", 
     RowBox[{"Subsets", "[", 
      RowBox[{
       RowBox[{"RandomInteger", "[", 
        RowBox[{"100", ",", 
         RowBox[{"{", 
          RowBox[{"20", ",", "2"}], "}"}]}], "]"}], ",", 
       RowBox[{"{", "3", "}"}]}], "]"}]}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14270],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 188},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->325416330]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Opacity", "[", ".1", "]"}], ",", 
    RowBox[{"Polygon", "/@", 
     RowBox[{"Subsets", "[", 
      RowBox[{
       RowBox[{"RandomInteger", "[", 
        RowBox[{"100", ",", 
         RowBox[{"{", 
          RowBox[{"10", ",", "3"}], "}"}]}], "]"}], ",", 
       RowBox[{"{", "3", "}"}]}], "]"}]}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->235],

Cell[BoxData[
 Graphics3DBox[
  {Opacity[0.1], Polygon3DBox[{{85, 90, 73}, {0, 8, 97}, {54, 89, 28}}], 
   Polygon3DBox[{{85, 90, 73}, {0, 8, 97}, {47, 40, 53}}], 
   Polygon3DBox[{{85, 90, 73}, {0, 8, 97}, {96, 3, 14}}], 
   Polygon3DBox[{{85, 90, 73}, {0, 8, 97}, {17, 19, 58}}], 
   Polygon3DBox[{{85, 90, 73}, {0, 8, 97}, {20, 28, 42}}], 
   Polygon3DBox[{{85, 90, 73}, {0, 8, 97}, {66, 11, 63}}], 
   Polygon3DBox[{{85, 90, 73}, {0, 8, 97}, {19, 46, 56}}], 
   Polygon3DBox[{{85, 90, 73}, {0, 8, 97}, {76, 68, 79}}], 
   Polygon3DBox[{{85, 90, 73}, {54, 89, 28}, {47, 40, 53}}], 
   Polygon3DBox[{{85, 90, 73}, {54, 89, 28}, {96, 3, 14}}], 
   Polygon3DBox[{{85, 90, 73}, {54, 89, 28}, {17, 19, 58}}], 
   Polygon3DBox[{{85, 90, 73}, {54, 89, 28}, {20, 28, 42}}], 
   Polygon3DBox[{{85, 90, 73}, {54, 89, 28}, {66, 11, 63}}], 
   Polygon3DBox[{{85, 90, 73}, {54, 89, 28}, {19, 46, 56}}], 
   Polygon3DBox[{{85, 90, 73}, {54, 89, 28}, {76, 68, 79}}], 
   Polygon3DBox[{{85, 90, 73}, {47, 40, 53}, {96, 3, 14}}], 
   Polygon3DBox[{{85, 90, 73}, {47, 40, 53}, {17, 19, 58}}], 
   Polygon3DBox[{{85, 90, 73}, {47, 40, 53}, {20, 28, 42}}], 
   Polygon3DBox[{{85, 90, 73}, {47, 40, 53}, {66, 11, 63}}], 
   Polygon3DBox[{{85, 90, 73}, {47, 40, 53}, {19, 46, 56}}], 
   Polygon3DBox[{{85, 90, 73}, {47, 40, 53}, {76, 68, 79}}], 
   Polygon3DBox[{{85, 90, 73}, {96, 3, 14}, {17, 19, 58}}], 
   Polygon3DBox[{{85, 90, 73}, {96, 3, 14}, {20, 28, 42}}], 
   Polygon3DBox[{{85, 90, 73}, {96, 3, 14}, {66, 11, 63}}], 
   Polygon3DBox[{{85, 90, 73}, {96, 3, 14}, {19, 46, 56}}], 
   Polygon3DBox[{{85, 90, 73}, {96, 3, 14}, {76, 68, 79}}], 
   Polygon3DBox[{{85, 90, 73}, {17, 19, 58}, {20, 28, 42}}], 
   Polygon3DBox[{{85, 90, 73}, {17, 19, 58}, {66, 11, 63}}], 
   Polygon3DBox[{{85, 90, 73}, {17, 19, 58}, {19, 46, 56}}], 
   Polygon3DBox[{{85, 90, 73}, {17, 19, 58}, {76, 68, 79}}], 
   Polygon3DBox[{{85, 90, 73}, {20, 28, 42}, {66, 11, 63}}], 
   Polygon3DBox[{{85, 90, 73}, {20, 28, 42}, {19, 46, 56}}], 
   Polygon3DBox[{{85, 90, 73}, {20, 28, 42}, {76, 68, 79}}], 
   Polygon3DBox[{{85, 90, 73}, {66, 11, 63}, {19, 46, 56}}], 
   Polygon3DBox[{{85, 90, 73}, {66, 11, 63}, {76, 68, 79}}], 
   Polygon3DBox[{{85, 90, 73}, {19, 46, 56}, {76, 68, 79}}], 
   Polygon3DBox[{{0, 8, 97}, {54, 89, 28}, {47, 40, 53}}], 
   Polygon3DBox[{{0, 8, 97}, {54, 89, 28}, {96, 3, 14}}], 
   Polygon3DBox[{{0, 8, 97}, {54, 89, 28}, {17, 19, 58}}], 
   Polygon3DBox[{{0, 8, 97}, {54, 89, 28}, {20, 28, 42}}], 
   Polygon3DBox[{{0, 8, 97}, {54, 89, 28}, {66, 11, 63}}], 
   Polygon3DBox[{{0, 8, 97}, {54, 89, 28}, {19, 46, 56}}], 
   Polygon3DBox[{{0, 8, 97}, {54, 89, 28}, {76, 68, 79}}], 
   Polygon3DBox[{{0, 8, 97}, {47, 40, 53}, {96, 3, 14}}], 
   Polygon3DBox[{{0, 8, 97}, {47, 40, 53}, {17, 19, 58}}], 
   Polygon3DBox[{{0, 8, 97}, {47, 40, 53}, {20, 28, 42}}], 
   Polygon3DBox[{{0, 8, 97}, {47, 40, 53}, {66, 11, 63}}], 
   Polygon3DBox[{{0, 8, 97}, {47, 40, 53}, {19, 46, 56}}], 
   Polygon3DBox[{{0, 8, 97}, {47, 40, 53}, {76, 68, 79}}], 
   Polygon3DBox[{{0, 8, 97}, {96, 3, 14}, {17, 19, 58}}], 
   Polygon3DBox[{{0, 8, 97}, {96, 3, 14}, {20, 28, 42}}], 
   Polygon3DBox[{{0, 8, 97}, {96, 3, 14}, {66, 11, 63}}], 
   Polygon3DBox[{{0, 8, 97}, {96, 3, 14}, {19, 46, 56}}], 
   Polygon3DBox[{{0, 8, 97}, {96, 3, 14}, {76, 68, 79}}], 
   Polygon3DBox[{{0, 8, 97}, {17, 19, 58}, {20, 28, 42}}], 
   Polygon3DBox[{{0, 8, 97}, {17, 19, 58}, {66, 11, 63}}], 
   Polygon3DBox[{{0, 8, 97}, {17, 19, 58}, {19, 46, 56}}], 
   Polygon3DBox[{{0, 8, 97}, {17, 19, 58}, {76, 68, 79}}], 
   Polygon3DBox[{{0, 8, 97}, {20, 28, 42}, {66, 11, 63}}], 
   Polygon3DBox[{{0, 8, 97}, {20, 28, 42}, {19, 46, 56}}], 
   Polygon3DBox[{{0, 8, 97}, {20, 28, 42}, {76, 68, 79}}], 
   Polygon3DBox[{{0, 8, 97}, {66, 11, 63}, {19, 46, 56}}], 
   Polygon3DBox[{{0, 8, 97}, {66, 11, 63}, {76, 68, 79}}], 
   Polygon3DBox[{{0, 8, 97}, {19, 46, 56}, {76, 68, 79}}], 
   Polygon3DBox[{{54, 89, 28}, {47, 40, 53}, {96, 3, 14}}], 
   Polygon3DBox[{{54, 89, 28}, {47, 40, 53}, {17, 19, 58}}], 
   Polygon3DBox[{{54, 89, 28}, {47, 40, 53}, {20, 28, 42}}], 
   Polygon3DBox[{{54, 89, 28}, {47, 40, 53}, {66, 11, 63}}], 
   Polygon3DBox[{{54, 89, 28}, {47, 40, 53}, {19, 46, 56}}], 
   Polygon3DBox[{{54, 89, 28}, {47, 40, 53}, {76, 68, 79}}], 
   Polygon3DBox[{{54, 89, 28}, {96, 3, 14}, {17, 19, 58}}], 
   Polygon3DBox[{{54, 89, 28}, {96, 3, 14}, {20, 28, 42}}], 
   Polygon3DBox[{{54, 89, 28}, {96, 3, 14}, {66, 11, 63}}], 
   Polygon3DBox[{{54, 89, 28}, {96, 3, 14}, {19, 46, 56}}], 
   Polygon3DBox[{{54, 89, 28}, {96, 3, 14}, {76, 68, 79}}], 
   Polygon3DBox[{{54, 89, 28}, {17, 19, 58}, {20, 28, 42}}], 
   Polygon3DBox[{{54, 89, 28}, {17, 19, 58}, {66, 11, 63}}], 
   Polygon3DBox[{{54, 89, 28}, {17, 19, 58}, {19, 46, 56}}], 
   Polygon3DBox[{{54, 89, 28}, {17, 19, 58}, {76, 68, 79}}], 
   Polygon3DBox[{{54, 89, 28}, {20, 28, 42}, {66, 11, 63}}], 
   Polygon3DBox[{{54, 89, 28}, {20, 28, 42}, {19, 46, 56}}], 
   Polygon3DBox[{{54, 89, 28}, {20, 28, 42}, {76, 68, 79}}], 
   Polygon3DBox[{{54, 89, 28}, {66, 11, 63}, {19, 46, 56}}], 
   Polygon3DBox[{{54, 89, 28}, {66, 11, 63}, {76, 68, 79}}], 
   Polygon3DBox[{{54, 89, 28}, {19, 46, 56}, {76, 68, 79}}], 
   Polygon3DBox[{{47, 40, 53}, {96, 3, 14}, {17, 19, 58}}], 
   Polygon3DBox[{{47, 40, 53}, {96, 3, 14}, {20, 28, 42}}], 
   Polygon3DBox[{{47, 40, 53}, {96, 3, 14}, {66, 11, 63}}], 
   Polygon3DBox[{{47, 40, 53}, {96, 3, 14}, {19, 46, 56}}], 
   Polygon3DBox[{{47, 40, 53}, {96, 3, 14}, {76, 68, 79}}], 
   Polygon3DBox[{{47, 40, 53}, {17, 19, 58}, {20, 28, 42}}], 
   Polygon3DBox[{{47, 40, 53}, {17, 19, 58}, {66, 11, 63}}], 
   Polygon3DBox[{{47, 40, 53}, {17, 19, 58}, {19, 46, 56}}], 
   Polygon3DBox[{{47, 40, 53}, {17, 19, 58}, {76, 68, 79}}], 
   Polygon3DBox[{{47, 40, 53}, {20, 28, 42}, {66, 11, 63}}], 
   Polygon3DBox[{{47, 40, 53}, {20, 28, 42}, {19, 46, 56}}], 
   Polygon3DBox[{{47, 40, 53}, {20, 28, 42}, {76, 68, 79}}], 
   Polygon3DBox[{{47, 40, 53}, {66, 11, 63}, {19, 46, 56}}], 
   Polygon3DBox[{{47, 40, 53}, {66, 11, 63}, {76, 68, 79}}], 
   Polygon3DBox[{{47, 40, 53}, {19, 46, 56}, {76, 68, 79}}], 
   Polygon3DBox[{{96, 3, 14}, {17, 19, 58}, {20, 28, 42}}], 
   Polygon3DBox[{{96, 3, 14}, {17, 19, 58}, {66, 11, 63}}], 
   Polygon3DBox[{{96, 3, 14}, {17, 19, 58}, {19, 46, 56}}], 
   Polygon3DBox[{{96, 3, 14}, {17, 19, 58}, {76, 68, 79}}], 
   Polygon3DBox[{{96, 3, 14}, {20, 28, 42}, {66, 11, 63}}], 
   Polygon3DBox[{{96, 3, 14}, {20, 28, 42}, {19, 46, 56}}], 
   Polygon3DBox[{{96, 3, 14}, {20, 28, 42}, {76, 68, 79}}], 
   Polygon3DBox[{{96, 3, 14}, {66, 11, 63}, {19, 46, 56}}], 
   Polygon3DBox[{{96, 3, 14}, {66, 11, 63}, {76, 68, 79}}], 
   Polygon3DBox[{{96, 3, 14}, {19, 46, 56}, {76, 68, 79}}], 
   Polygon3DBox[{{17, 19, 58}, {20, 28, 42}, {66, 11, 63}}], 
   Polygon3DBox[{{17, 19, 58}, {20, 28, 42}, {19, 46, 56}}], 
   Polygon3DBox[{{17, 19, 58}, {20, 28, 42}, {76, 68, 79}}], 
   Polygon3DBox[{{17, 19, 58}, {66, 11, 63}, {19, 46, 56}}], 
   Polygon3DBox[{{17, 19, 58}, {66, 11, 63}, {76, 68, 79}}], 
   Polygon3DBox[{{17, 19, 58}, {19, 46, 56}, {76, 68, 79}}], 
   Polygon3DBox[{{20, 28, 42}, {66, 11, 63}, {19, 46, 56}}], 
   Polygon3DBox[{{20, 28, 42}, {66, 11, 63}, {76, 68, 79}}], 
   Polygon3DBox[{{20, 28, 42}, {19, 46, 56}, {76, 68, 79}}], 
   Polygon3DBox[{{66, 11, 63}, {19, 46, 56}, {76, 68, 79}}]},
  ImageMargins->0.,
  ViewAngle->Automatic,
  ViewCenter->Automatic,
  ViewPoint->{1.3, -2.4, 2.},
  ViewVertical->{0., 0., 1.}]], "Output",
 ImageSize->{304, 308},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{300, Automatic}},
 CellLabel->"Out[2]=",
 CellID->30833,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19711],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Polygon", "[", 
   RowBox[{"Subsets", "[", 
    RowBox[{
     RowBox[{"Tuples", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", 
         RowBox[{"-", "1"}]}], "}"}], ",", "3"}], "]"}], ",", 
     RowBox[{"{", "3", "}"}]}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25760],

Cell[BoxData[
 Graphics3DBox[Polygon3DBox[CompressedData["
1:eJydmFGOLVlSBE+LT1bBllgC/8D+vwpGIiXHX7hZ9aSEXmZeu2ERHudWj/i3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   "]],
  ImageMargins->0.,
  ViewAngle->Automatic,
  ViewCenter->Automatic,
  ViewPoint->{1.3, -2.4, 2.},
  ViewVertical->{0., 0., 1.}]], "Output",
 ImageSize->{304, 326},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{300, Automatic}},
 CellLabel->"Out[1]=",
 CellID->18896,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->7129],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Tuples",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tuples"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntegerDigits",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerDigits"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Binomial",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Binomial"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntegerPartitions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerPartitions"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SymmetricPolynomial",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SymmetricPolynomial"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BellB",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BellB"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RandomSample",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RandomSample"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2161]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->481],

Cell[TextData[ButtonBox["Lists as Sets",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ListsAsSets"]], "Tutorials",
 CellID->4144]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Subsets",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Subsets"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->125422003],

Cell[TextData[ButtonBox["Constructing Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ConstructingLists"]], "MoreAbout",
 CellID->221720728],

Cell[TextData[ButtonBox["Discrete Mathematics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteMathematics"]], "MoreAbout",
 CellID->787481431],

Cell[TextData[ButtonBox["Math & Counting Operations on Lists",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/MathematicalAndCountingOperationsOnLists"]], "MoreAbout",
 CellID->169229703],

Cell[TextData[ButtonBox["Rearranging & Restructuring Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RearrangingAndRestructuringLists"]], "MoreAbout",
 CellID->914078790]
}, Open  ]],

Cell["New in 5.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Subsets - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 25, 10.1113374}", "context" -> "System`", 
    "keywords" -> {"powerset", "set exponential"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Subsets[list] gives a list of all possible subsets of list. \
Subsets[list, n] gives all subsets containing at most n elements. \
Subsets[list, {n}] gives all subsets containing exactly n elements. \
Subsets[list, {n_min, n_max}] gives all subsets containing between n_min and \
n_max elements. Subsets[list, nspec, s] gives the first s subsets. \
Subsets[list, nspec, {s}] gives the s\\[Null]\\[Null]^th subset. ", 
    "synonyms" -> {}, "title" -> "Subsets", "type" -> "Symbol", "uri" -> 
    "ref/Subsets"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10716, 364, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->191537667]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 136559, 3050}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2971, 67, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3594, 94, 45, 1, 70, "ObjectName",
 CellID->10808],
Cell[3642, 97, 3360, 111, 70, "Usage",
 CellID->1832]
}, Open  ]],
Cell[CellGroupData[{
Cell[7039, 213, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7517, 230, 310, 12, 70, "Notes",
 CellID->20945],
Cell[7830, 244, 359, 12, 70, "Notes",
 CellID->27756],
Cell[8192, 258, 515, 18, 70, "Notes",
 CellID->28321],
Cell[8710, 278, 517, 20, 70, "Notes",
 CellID->19558],
Cell[9230, 300, 805, 33, 70, "Notes",
 CellID->23646],
Cell[10038, 335, 641, 24, 70, "Notes",
 CellID->27982]
}, Closed]],
Cell[CellGroupData[{
Cell[10716, 364, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->191537667],
Cell[CellGroupData[{
Cell[11101, 378, 148, 5, 70, "ExampleSection",
 CellID->220817592],
Cell[11252, 385, 72, 1, 70, "ExampleText",
 CellID->10466],
Cell[CellGroupData[{
Cell[11349, 390, 156, 5, 28, "Input",
 CellID->12044],
Cell[11508, 397, 557, 19, 36, "Output",
 CellID->21659]
}, Open  ]],
Cell[12080, 419, 121, 3, 70, "ExampleDelimiter",
 CellID->26292],
Cell[12204, 424, 88, 1, 70, "ExampleText",
 CellID->26439],
Cell[CellGroupData[{
Cell[12317, 429, 194, 7, 70, "Input",
 CellID->17253],
Cell[12514, 438, 699, 24, 36, "Output",
 CellID->20024]
}, Open  ]],
Cell[13228, 465, 77, 1, 70, "ExampleText",
 CellID->26154],
Cell[CellGroupData[{
Cell[13330, 470, 215, 7, 70, "Input",
 CellID->29510],
Cell[13548, 479, 533, 19, 36, "Output",
 CellID->4745]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14130, 504, 216, 7, 70, "ExampleSection",
 CellID->13186],
Cell[14349, 513, 80, 1, 70, "ExampleText",
 CellID->8313],
Cell[CellGroupData[{
Cell[14454, 518, 234, 7, 70, "Input",
 CellID->4474],
Cell[14691, 527, 525, 17, 36, "Output",
 CellID->28022]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15265, 550, 238, 7, 70, "ExampleSection",
 CellID->2168],
Cell[15506, 559, 52, 1, 70, "ExampleText",
 CellID->14018],
Cell[CellGroupData[{
Cell[15583, 564, 161, 5, 70, "Input",
 CellID->18787],
Cell[15747, 571, 596, 19, 36, "Output",
 CellID->9905]
}, Open  ]],
Cell[CellGroupData[{
Cell[16380, 595, 132, 4, 70, "Input",
 CellID->17958],
Cell[16515, 601, 365, 11, 36, "Output",
 CellID->7391]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16929, 618, 222, 7, 70, "ExampleSection",
 CellID->3625],
Cell[17154, 627, 79, 1, 70, "ExampleText",
 CellID->26477],
Cell[CellGroupData[{
Cell[17258, 632, 214, 7, 70, "Input",
 CellID->4414],
Cell[17475, 641, 455, 15, 36, "Output",
 CellID->9314]
}, Open  ]],
Cell[CellGroupData[{
Cell[17967, 661, 123, 4, 70, "Input",
 CellID->25824],
Cell[18093, 667, 154, 5, 36, "Output",
 CellID->29334]
}, Open  ]],
Cell[18262, 675, 121, 3, 70, "ExampleDelimiter",
 CellID->25874],
Cell[18386, 680, 92, 1, 70, "ExampleText",
 CellID->24372],
Cell[CellGroupData[{
Cell[18503, 685, 610, 19, 70, "Input",
 CellID->20159],
Cell[19116, 706, 1780, 33, 201, "Output",
 CellID->11833]
}, Open  ]],
Cell[20911, 742, 121, 3, 70, "ExampleDelimiter",
 CellID->28070],
Cell[21035, 747, 220, 5, 70, "ExampleText",
 CellID->7487],
Cell[CellGroupData[{
Cell[21280, 756, 270, 8, 70, "Input",
 CellID->28297],
Cell[21553, 766, 586, 16, 36, "Output",
 CellID->7518]
}, Open  ]],
Cell[22154, 785, 120, 3, 70, "ExampleDelimiter",
 CellID->8177],
Cell[22277, 790, 82, 1, 70, "ExampleText",
 CellID->17773],
Cell[CellGroupData[{
Cell[22384, 795, 135, 4, 70, "Input",
 CellID->32270],
Cell[22522, 801, 1061, 34, 54, "Output",
 CellID->1763]
}, Open  ]],
Cell[23598, 838, 120, 3, 70, "ExampleDelimiter",
 CellID->2668],
Cell[23721, 843, 95, 1, 70, "ExampleText",
 CellID->17192],
Cell[CellGroupData[{
Cell[23841, 848, 226, 7, 70, "Input",
 CellID->13985],
Cell[24070, 857, 875, 27, 54, "Output",
 CellID->3102]
}, Open  ]],
Cell[CellGroupData[{
Cell[24982, 889, 92, 3, 70, "Input",
 CellID->8480],
Cell[25077, 894, 296, 9, 36, "Output",
 CellID->29213]
}, Open  ]],
Cell[25388, 906, 120, 3, 70, "ExampleDelimiter",
 CellID->7627],
Cell[25511, 911, 88, 1, 70, "ExampleText",
 CellID->4802],
Cell[CellGroupData[{
Cell[25624, 916, 341, 11, 70, "Input",
 CellID->4099],
Cell[25968, 929, 7439, 126, 70, "Output",
 Evaluatable->False,
 CellID->122142436]
}, Open  ]],
Cell[33422, 1058, 120, 3, 70, "ExampleDelimiter",
 CellID->2625],
Cell[33545, 1063, 87, 1, 70, "ExampleText",
 CellID->1543],
Cell[CellGroupData[{
Cell[33657, 1068, 338, 11, 70, "Input",
 CellID->1924],
Cell[33998, 1081, 9399, 157, 283, 764, 11, "CachedBoxData", "BoxData", \
"Output",
 CellID->11023]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[43446, 1244, 233, 7, 70, "ExampleSection",
 CellID->29972],
Cell[43682, 1253, 232, 7, 70, "ExampleText",
 CellID->13061],
Cell[CellGroupData[{
Cell[43939, 1264, 156, 5, 70, "Input",
 CellID->14181],
Cell[44098, 1271, 557, 19, 36, "Output",
 CellID->31003]
}, Open  ]],
Cell[44670, 1293, 121, 3, 70, "ExampleDelimiter",
 CellID->27432],
Cell[44794, 1298, 113, 3, 70, "ExampleText",
 CellID->17505],
Cell[CellGroupData[{
Cell[44932, 1305, 166, 5, 70, "Input",
 CellID->27593],
Cell[45101, 1312, 1054, 34, 54, "Output",
 CellID->22725]
}, Open  ]],
Cell[46170, 1349, 121, 3, 70, "ExampleDelimiter",
 CellID->13031],
Cell[46294, 1354, 229, 7, 70, "ExampleText",
 CellID->8492],
Cell[CellGroupData[{
Cell[46548, 1365, 178, 6, 70, "Input",
 CellID->142],
Cell[46729, 1373, 711, 25, 36, "Output",
 CellID->17222]
}, Open  ]],
Cell[CellGroupData[{
Cell[47477, 1403, 205, 7, 70, "Input",
 CellID->31286],
Cell[47685, 1412, 357, 13, 36, "Output",
 CellID->13064]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[48091, 1431, 223, 7, 70, "ExampleSection",
 CellID->8360],
Cell[48317, 1440, 100, 2, 70, "ExampleText",
 CellID->30974],
Cell[CellGroupData[{
Cell[48442, 1446, 448, 14, 70, "Input",
 CellID->14270],
Cell[48893, 1462, 14620, 244, 70, "Output",
 Evaluatable->False,
 CellID->325416330]
}, Open  ]],
Cell[CellGroupData[{
Cell[63550, 1711, 446, 14, 70, "Input",
 CellID->235],
Cell[63999, 1727, 41693, 691, 329, 7516, 126, "CachedBoxData", "BoxData", \
"Output",
 CellID->30833]
}, Open  ]],
Cell[105707, 2421, 121, 3, 70, "ExampleDelimiter",
 CellID->19711],
Cell[CellGroupData[{
Cell[105853, 2428, 377, 12, 70, "Input",
 CellID->25760],
Cell[106233, 2442, 24593, 411, 347, 9843, 165, "CachedBoxData", "BoxData", \
"Output",
 CellID->18896]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[130887, 2860, 310, 9, 70, "SeeAlsoSection",
 CellID->7129],
Cell[131200, 2871, 1723, 62, 70, "SeeAlso",
 CellID->2161]
}, Open  ]],
Cell[CellGroupData[{
Cell[132960, 2938, 312, 9, 70, "TutorialsSection",
 CellID->481],
Cell[133275, 2949, 134, 3, 70, "Tutorials",
 CellID->4144]
}, Open  ]],
Cell[CellGroupData[{
Cell[133446, 2957, 305, 8, 70, "RelatedLinksSection"],
Cell[133754, 2967, 359, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[134150, 2984, 319, 9, 70, "MoreAboutSection",
 CellID->125422003],
Cell[134472, 2995, 147, 3, 70, "MoreAbout",
 CellID->221720728],
Cell[134622, 3000, 151, 3, 70, "MoreAbout",
 CellID->787481431],
Cell[134776, 3005, 190, 4, 70, "MoreAbout",
 CellID->169229703],
Cell[134969, 3011, 177, 3, 70, "MoreAbout",
 CellID->914078790]
}, Open  ]],
Cell[135161, 3017, 29, 0, 70, "History"],
Cell[135193, 3019, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

