(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14235,        504]
NotebookOptionsPosition[     11442,        410]
NotebookOutlinePosition[     12666,        446]
CellTagsIndexPosition[     12581,        441]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Operators without Built\[Hyphen]in Meanings" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OperatorsWithoutBuiltInMeanings"], 
          "Names of Symbols and Mathematical Objects" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NamesOfSymbolsAndMathematicalObjects"], 
          "Formatted Output" :> 
          Documentation`HelpLookup["paclet:tutorial/FormattedOutput"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Operators without Built\[Hyphen]in Meanings\"\>", 
       2->"\<\"Names of Symbols and Mathematical Objects\"\>", 
       3->"\<\"Formatted Output\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Subscript" :> Documentation`HelpLookup["paclet:ref/Subscript"],
           "Superscript" :> 
          Documentation`HelpLookup["paclet:ref/Superscript"], 
          "Underoverscript" :> 
          Documentation`HelpLookup["paclet:ref/Underoverscript"], 
          "SubsuperscriptBox" :> 
          Documentation`HelpLookup["paclet:ref/SubsuperscriptBox"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Subscript\"\>", 
       2->"\<\"Superscript\"\>", 3->"\<\"Underoverscript\"\>", 
       4->"\<\"SubsuperscriptBox\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{
         "Symbolic Notational Forms" :> 
          Documentation`HelpLookup[
           "paclet:guide/SymbolicNotationalForms"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Symbolic Notational Forms\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Subsuperscript", "ObjectName",
 CellID->29734],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Subsuperscript",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Subsuperscript"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["y", "TI"], ",", 
        StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is an object that formats as ",
     Cell[BoxData[
      SubsuperscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["y", "TI"], 
       StyleBox["z", "TI"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->6654]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "In a notebook, a subsuperscript can be created by using ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["_", "KeyEvent"],
 " or ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["-", "KeyEvent"],
 " to move to the subscript, then ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["%", "KeyEvent"],
 " to move to the superscript. ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 " moves out of the subscript or superscript position. "
}], "Notes",
 CellID->16972],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Subsuperscript",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Subsuperscript"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " formats as ",
 Cell[BoxData[
  SubsuperscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["y", "TI"], 
   StyleBox["z", "TI"]]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->21457],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Subsuperscript",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Subsuperscript"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " formats literally as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Subsuperscript",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Subsuperscript"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->14369],

Cell[TextData[{
 "The baseline of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Subsuperscript",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Subsuperscript"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " is taken to be the baseline of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->22532],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Subsuperscript",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Subsuperscript"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " is usually output with ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " in a smaller font than ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->2963]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->145374336],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->54265446],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Subsuperscript", "[", 
  RowBox[{"a", ",", "x", ",", "y"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->276498003],

Cell[BoxData[
 InterpretationBox[
  SubsuperscriptBox["a", "x", "y"],
  Subsuperscript[$CellContext`a, $CellContext`x, $CellContext`y],
  Editable->False]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->143103486]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->10067],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Subscript",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Subscript"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Superscript",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Superscript"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Underoverscript",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Underoverscript"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SubsuperscriptBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SubsuperscriptBox"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->22848]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->2607],

Cell[TextData[ButtonBox["Operators without Built\[Hyphen]in Meanings",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OperatorsWithoutBuiltInMeanings"]], "Tutorials",\

 CellID->14310],

Cell[TextData[ButtonBox["Names of Symbols and Mathematical Objects",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NamesOfSymbolsAndMathematicalObjects"]], "Tutorials",
 CellID->6617],

Cell[TextData[ButtonBox["Formatted Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FormattedOutput"]], "Tutorials",
 CellID->444657240]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Symbolic Notational Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicNotationalForms"]], "MoreAbout",
 CellID->699358924]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Subsuperscript - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 25, 16.5646276}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Subsuperscript[x, y, z] is an object that formats as \
SubsuperscriptBox[x, y, z]. ", "synonyms" -> {}, "title" -> "Subsuperscript", 
    "type" -> "Symbol", "uri" -> "ref/Subsuperscript"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7634, 263, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->145374336]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12438, 434}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2593, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3216, 89, 52, 1, 70, "ObjectName",
 CellID->29734],
Cell[3271, 92, 732, 24, 70, "Usage",
 CellID->6654]
}, Open  ]],
Cell[CellGroupData[{
Cell[4040, 121, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4518, 138, 630, 19, 70, "Notes",
 CellID->16972],
Cell[5151, 159, 735, 28, 70, "Notes",
 CellID->21457],
Cell[5889, 189, 731, 28, 70, "Notes",
 CellID->14369],
Cell[6623, 219, 424, 16, 70, "Notes",
 CellID->22532],
Cell[7050, 237, 547, 21, 70, "Notes",
 CellID->2963]
}, Closed]],
Cell[CellGroupData[{
Cell[7634, 263, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->145374336],
Cell[CellGroupData[{
Cell[8019, 277, 147, 5, 70, "ExampleSection",
 CellID->54265446],
Cell[CellGroupData[{
Cell[8191, 286, 143, 4, 28, "Input",
 CellID->276498003],
Cell[8337, 292, 296, 9, 36, "Output",
 CellID->143103486]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8694, 308, 311, 9, 70, "SeeAlsoSection",
 CellID->10067],
Cell[9008, 319, 981, 35, 70, "SeeAlso",
 CellID->22848]
}, Open  ]],
Cell[CellGroupData[{
Cell[10026, 359, 313, 9, 70, "TutorialsSection",
 CellID->2607],
Cell[10342, 370, 187, 4, 70, "Tutorials",
 CellID->14310],
Cell[10532, 376, 190, 4, 70, "Tutorials",
 CellID->6617],
Cell[10725, 382, 146, 3, 70, "Tutorials",
 CellID->444657240]
}, Open  ]],
Cell[CellGroupData[{
Cell[10908, 390, 299, 8, 70, "MoreAboutSection"],
Cell[11210, 400, 160, 3, 70, "MoreAbout",
 CellID->699358924]
}, Open  ]],
Cell[11385, 406, 27, 0, 70, "History"],
Cell[11415, 408, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

