(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     27905,        949]
NotebookOptionsPosition[     23281,        793]
NotebookOutlinePosition[     24616,        830]
CellTagsIndexPosition[     24531,        825]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Representing Textual Forms by Boxes" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/RepresentingTextualFormsByBoxes"], 
          "String Representation of Boxes" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StringRepresentationOfBoxes"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Representing Textual Forms by Boxes\"\>", 
       2->"\<\"String Representation of Boxes\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Subsuperscript" :> 
          Documentation`HelpLookup["paclet:ref/Subsuperscript"], 
          "SubscriptBox" :> 
          Documentation`HelpLookup["paclet:ref/SubscriptBox"], 
          "SuperscriptBox" :> 
          Documentation`HelpLookup["paclet:ref/SuperscriptBox"], 
          "UnderoverscriptBox" :> 
          Documentation`HelpLookup["paclet:ref/UnderoverscriptBox"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Subsuperscript\"\>", 
       2->"\<\"SubscriptBox\"\>", 3->"\<\"SuperscriptBox\"\>", 
       4->"\<\"UnderoverscriptBox\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Low-Level Notebook Structure" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelNotebookStructure"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Low-Level Notebook Structure\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["SubsuperscriptBox", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SubsuperscriptBox",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SubsuperscriptBox"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["y", "TI"], ",", 
        StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is the low\[Hyphen]level box representation for ",
     Cell[BoxData[
      SubsuperscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["y", "TI"], 
       StyleBox["z", "TI"]]], "InlineFormula"],
     " in notebook expressions. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->20315]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SubsuperscriptBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SubsuperscriptBox"]], "InlineFormula"],
 " is the low-level representation of ",
 Cell[BoxData[
  ButtonBox["Subsuperscript",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Subsuperscript"]], "InlineFormula"],
 ". Except for low-level notebook expression manipulation, ",
 Cell[BoxData[
  ButtonBox["SubsuperscriptBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SubsuperscriptBox"]], "InlineFormula"],
 " should not need to be used directly."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->9576],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SubsuperscriptBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SubsuperscriptBox"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " can be input as ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["x", "TI"], "\[Backslash]", "_"}], 
   RowBox[{
    StyleBox["y", "TI"], "\[Backslash]", "%"}], 
   StyleBox["z", "TI"]}]], "InlineFormula"],
 " when inside ",
 Cell[BoxData[
  RowBox[{"\[Backslash]", 
   RowBox[{"(", 
    RowBox[{
     StyleBox["\[Ellipsis]", "TR"], "\[Backslash]"}], ")"}]}]], 
  "InlineFormula"],
 ". "
}], "Notes",
 CellID->30227],

Cell[TextData[{
 "In a notebook a ",
 Cell[BoxData[
  ButtonBox["SubsuperscriptBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SubsuperscriptBox"]], "InlineFormula"],
 " can be created by using ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["- ", "KeyEvent"],
 "or ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["_", "KeyEvent"],
 " to move to the subscript, then ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["%", "KeyEvent"],
 " to move to the superscript. ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 " moves out of the subscript or superscript position. "
}], "Notes",
 CellID->12043],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SubsuperscriptBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SubsuperscriptBox"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " is interpreted on input as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Power",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Power"], "[", 
   RowBox[{
    RowBox[{
     ButtonBox["Subscript",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Subscript"], "[", 
     RowBox[{
      StyleBox["x", "TI"], ",", 
      StyleBox["y", "TI"]}], "]"}], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->22758],

Cell[TextData[{
 "The baseline of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SubsuperscriptBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SubsuperscriptBox"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " is taken to be the baseline of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->7164],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SubsuperscriptBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SubsuperscriptBox"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " is usually output with ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " in a smaller font than ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->5109],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ", explicit ",
 Cell[BoxData[
  ButtonBox["SubsuperscriptBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SubsuperscriptBox"]], "InlineFormula"],
 " objects are output literally. You can use ",
 Cell[BoxData[
  ButtonBox["DisplayForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DisplayForm"]], "InlineFormula"],
 " to see the display form of such objects. "
}], "Notes",
 CellID->7882]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->94140549],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->80240221],

Cell["Display a letter with a subscript and a superscript:", "ExampleText",
 CellID->110280404],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SubsuperscriptBox", "[", 
   RowBox[{"\"\<x\>\"", ",", "\"\<0\>\"", ",", "\"\<n\>\""}], "]"}], "//", 
  "DisplayForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->177567825],

Cell[BoxData[
 TagBox[
  SubsuperscriptBox["x", "0", "n"],
  DisplayForm]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//DisplayForm=",
 CellID->133391272]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->292428007],

Cell[TextData[{
 "A ",
 Cell[BoxData[
  ButtonBox["SubsuperscriptBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SubsuperscriptBox"]], "InlineFormula"],
 " form is typically interpreted as a power of a ",
 Cell[BoxData[
  ButtonBox["Subscript",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Subscript"]], "InlineFormula"],
 " expression:"
}], "ExampleText",
 CellID->449017820],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToExpression", "[", 
  RowBox[{
   RowBox[{"SubsuperscriptBox", "[", 
    RowBox[{"\"\<x\>\"", ",", "\"\<0\>\"", ",", "\"\<n\>\""}], "]"}], ",", 
   "StandardForm"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27669645],

Cell[BoxData[
 SubsuperscriptBox["x", "0", "n"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->112009651]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "FullForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->25362379],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Power", "[", 
    RowBox[{
     RowBox[{"Subscript", "[", 
      RowBox[{"x", ",", "0"}], "]"}], ",", "n"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm=",
 CellID->428197259]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->243599250],

Cell[TextData[{
 "The standard formatting for a power of a ",
 Cell[BoxData[
  ButtonBox["Subscript",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Subscript"]], "InlineFormula"],
 " expression uses ",
 Cell[BoxData[
  ButtonBox["SubsuperscriptBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SubsuperscriptBox"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->85956211],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ToBoxes", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Subscript", "[", 
      RowBox[{"x", ",", "0"}], "]"}], "^", "n"}], ",", "StandardForm"}], 
   "]"}], "//", "FullForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->35539747],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"SubsuperscriptBox", "[", 
    RowBox[{"\"\<x\>\"", ",", "\"\<0\>\"", ",", "\"\<n\>\""}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{223, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//FullForm=",
 CellID->23444532]
}, Open  ]],

Cell["The formatted result looks like this:", "ExampleText",
 CellID->108907752],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Subscript", "[", 
   RowBox[{"x", ",", "0"}], "]"}], "^", "n"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14089127],

Cell[BoxData[
 SubsuperscriptBox["x", "0", "n"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->216159801]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28520],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Subsuperscript",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Subsuperscript"]], "InlineFormula"],
 " formatting uses ",
 Cell[BoxData[
  ButtonBox["SubsuperscriptBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SubsuperscriptBox"]], "InlineFormula"],
 ", with interpretation information:"
}], "ExampleText",
 CellID->364994930],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ToBoxes", "[", 
   RowBox[{
    RowBox[{"Subsuperscript", "[", 
     RowBox[{"x", ",", "0", ",", "n"}], "]"}], ",", "StandardForm"}], "]"}], "//",
   "FullForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->274477830],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"InterpretationBox", "[", 
    RowBox[{
     RowBox[{"SubsuperscriptBox", "[", 
      RowBox[{"\"\<x\>\"", ",", "\"\<0\>\"", ",", "\"\<n\>\""}], "]"}], ",", 
     RowBox[{"Subsuperscript", "[", 
      RowBox[{"x", ",", "0", ",", "n"}], "]"}], ",", 
     RowBox[{"Rule", "[", 
      RowBox[{"Editable", ",", "False"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{356, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//FullForm=",
 CellID->438698566]
}, Open  ]],

Cell["The interpretation is not obvious in the formatted result:", \
"ExampleText",
 CellID->131604343],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Subsuperscript", "[", 
    RowBox[{"x", ",", "0", ",", "n"}], "]"}], ",", 
   RowBox[{
    RowBox[{"Subscript", "[", 
     RowBox[{"x", ",", "0"}], "]"}], "^", "n"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->686418274],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    SubsuperscriptBox["x", "0", "n"],
    Subsuperscript[$CellContext`x, 0, $CellContext`n],
    Editable->False], ",", 
   SubsuperscriptBox["x", "0", "n"]}], "}"}]], "Output",
 ImageSize->{55, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->217971900]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14474],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Subsuperscript",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Subsuperscript"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SubscriptBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SubscriptBox"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SuperscriptBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SuperscriptBox"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["UnderoverscriptBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/UnderoverscriptBox"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2625]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17086],

Cell[TextData[ButtonBox["Representing Textual Forms by Boxes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RepresentingTextualFormsByBoxes"]], "Tutorials",\

 CellID->29565],

Cell[TextData[ButtonBox["String Representation of Boxes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StringRepresentationOfBoxes"]], "Tutorials",
 CellID->187054374]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
SubsuperscriptBox"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Low-Level Notebook Structure",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelNotebookStructure"]], "MoreAbout",
 CellID->88318356]
}, Open  ]],

Cell["New in 3  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SubsuperscriptBox - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 25, 11.8770076}", "context" -> "System`", 
    "keywords" -> {"subsuperscript box", "multiscript box"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "SubsuperscriptBox[x, y, z] is the low-level box representation for \
SubsuperscriptBox[x, y, z] in notebook expressions. ", 
    "synonyms" -> {"subsuperscript box"}, "title" -> "SubsuperscriptBox", 
    "type" -> "Symbol", "uri" -> "ref/SubsuperscriptBox"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[13196, 393, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->94140549]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 24388, 818}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2428, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3051, 86, 4201, 83, 70, "ObjectNameGrid"],
Cell[7255, 171, 782, 24, 70, "Usage",
 CellID->20315]
}, Open  ]],
Cell[CellGroupData[{
Cell[8074, 200, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8552, 217, 722, 20, 70, "Notes",
 CellID->9576],
Cell[9277, 239, 705, 27, 70, "Notes",
 CellID->30227],
Cell[9985, 268, 757, 24, 70, "Notes",
 CellID->12043],
Cell[10745, 294, 873, 33, 70, "Notes",
 CellID->22758],
Cell[11621, 329, 429, 16, 70, "Notes",
 CellID->7164],
Cell[12053, 347, 553, 21, 70, "Notes",
 CellID->5109],
Cell[12609, 370, 550, 18, 70, "Notes",
 CellID->7882]
}, Closed]],
Cell[CellGroupData[{
Cell[13196, 393, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->94140549],
Cell[CellGroupData[{
Cell[13580, 407, 147, 5, 70, "ExampleSection",
 CellID->80240221],
Cell[13730, 414, 95, 1, 70, "ExampleText",
 CellID->110280404],
Cell[CellGroupData[{
Cell[13850, 419, 208, 6, 28, "Input",
 CellID->177567825],
Cell[14061, 427, 228, 8, 50, "Output",
 CellID->133391272]
}, Open  ]],
Cell[14304, 438, 125, 3, 70, "ExampleDelimiter",
 CellID->292428007],
Cell[14432, 443, 387, 13, 70, "ExampleText",
 CellID->449017820],
Cell[CellGroupData[{
Cell[14844, 460, 249, 7, 70, "Input",
 CellID->27669645],
Cell[15096, 469, 189, 6, 36, "Output",
 CellID->112009651]
}, Open  ]],
Cell[CellGroupData[{
Cell[15322, 480, 99, 3, 70, "Input",
 CellID->25362379],
Cell[15424, 485, 414, 15, 50, "Output",
 CellID->428197259]
}, Open  ]],
Cell[15853, 503, 125, 3, 70, "ExampleDelimiter",
 CellID->243599250],
Cell[15981, 508, 385, 13, 70, "ExampleText",
 CellID->85956211],
Cell[CellGroupData[{
Cell[16391, 525, 263, 9, 70, "Input",
 CellID->35539747],
Cell[16657, 536, 393, 13, 50, "Output",
 CellID->23444532]
}, Open  ]],
Cell[17065, 552, 80, 1, 70, "ExampleText",
 CellID->108907752],
Cell[CellGroupData[{
Cell[17170, 557, 151, 5, 70, "Input",
 CellID->14089127],
Cell[17324, 564, 189, 6, 36, "Output",
 CellID->216159801]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17562, 576, 216, 7, 70, "ExampleSection",
 CellID->28520],
Cell[17781, 585, 382, 12, 70, "ExampleText",
 CellID->364994930],
Cell[CellGroupData[{
Cell[18188, 601, 251, 8, 70, "Input",
 CellID->274477830],
Cell[18442, 611, 631, 19, 68, "Output",
 CellID->438698566]
}, Open  ]],
Cell[19088, 633, 103, 2, 70, "ExampleText",
 CellID->131604343],
Cell[CellGroupData[{
Cell[19216, 639, 280, 9, 70, "Input",
 CellID->686418274],
Cell[19499, 650, 369, 12, 36, "Output",
 CellID->217971900]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19929, 669, 311, 9, 70, "SeeAlsoSection",
 CellID->14474],
Cell[20243, 680, 992, 35, 70, "SeeAlso",
 CellID->2625]
}, Open  ]],
Cell[CellGroupData[{
Cell[21272, 720, 314, 9, 70, "TutorialsSection",
 CellID->17086],
Cell[21589, 731, 179, 4, 70, "Tutorials",
 CellID->29565],
Cell[21771, 737, 172, 3, 70, "Tutorials",
 CellID->187054374]
}, Open  ]],
Cell[CellGroupData[{
Cell[21980, 745, 305, 8, 70, "RelatedLinksSection"],
Cell[22288, 755, 395, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22720, 773, 299, 8, 70, "MoreAboutSection"],
Cell[23022, 783, 164, 3, 70, "MoreAbout",
 CellID->88318356]
}, Open  ]],
Cell[23201, 789, 50, 0, 70, "History"],
Cell[23254, 791, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

