(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17292,        653]
NotebookOptionsPosition[     13446,        519]
NotebookOutlinePosition[     14620,        554]
CellTagsIndexPosition[     14535,        549]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Arithmetic" :> 
          Documentation`HelpLookup["paclet:tutorial/Arithmetic"], 
          "Special Forms of Assignment" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SpecialFormsOfAssignment"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Arithmetic\"\>", 
       2->"\<\"Special Forms of Assignment\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Minus" :> Documentation`HelpLookup["paclet:ref/Minus"], 
          "Decrement" :> Documentation`HelpLookup["paclet:ref/Decrement"], 
          "Plus" :> Documentation`HelpLookup["paclet:ref/Plus"], 
          "Differences" :> Documentation`HelpLookup["paclet:ref/Differences"],
           "SubtractFrom" :> 
          Documentation`HelpLookup["paclet:ref/SubtractFrom"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Minus\"\>", 2->"\<\"Decrement\"\>", 
       3->"\<\"Plus\"\>", 4->"\<\"Differences\"\>", 
       5->"\<\"SubtractFrom\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Arithmetic Functions" :> 
          Documentation`HelpLookup["paclet:guide/ArithmeticFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Arithmetic Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Subtract ",
 StyleBox["(-)", "OperatorCharacter"]
}], "ObjectName",
 CellID->20601],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], "-", 
       StyleBox["y", "TI"]}]], "InlineFormula"],
     "\[LineSeparator]is equivalent to ",
     Cell[BoxData[
      FormBox[
       RowBox[{"x", "+", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "*", "y"}], ")"}]}], TraditionalForm]], 
      "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->6077]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "-", 
   StyleBox["y", "TI"]}]], "InlineFormula"],
 " is converted to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "+", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "*", "y"}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 " on input. "
}], "Notes",
 CellID->20215]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->40897882],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->104852594],

Cell["Subtract numbers:", "ExampleText",
 CellID->237507447],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Subtract", "[", 
  RowBox[{"10", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->300495967],

Cell[BoxData["7"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->392952378]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->426823699],

Cell["Subtract expressions:", "ExampleText",
 CellID->24660472],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Subtract", "[", 
  RowBox[{
   RowBox[{"a", "+", "b"}], ",", 
   RowBox[{"c", "+", "d"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->208898800],

Cell[BoxData[
 RowBox[{"a", "+", "b", "-", "c", "-", "d"}]], "Output",
 ImageSize->{70, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->79810057]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->585241576],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Subtract",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Subtract"]], "InlineFormula"],
 " evaluates to ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->199814873],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Subtract", "[", 
   RowBox[{"a", ",", "b"}], "]"}], "//", "FullForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->504831345],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Plus", "[", 
    RowBox[{"a", ",", 
     RowBox[{"Times", "[", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "b"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{147, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//FullForm=",
 CellID->325828290]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15498],

Cell["Find pairs of numbers that differ by an integer:", "ExampleText",
 CellID->75478262],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SeedRandom", "[", "1", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{
    RowBox[{"RandomInteger", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "25"}], ",", "25"}], "}"}], ",", 
      RowBox[{"{", "3", "}"}]}], "]"}], "/", "5"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{
    RowBox[{"RandomInteger", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "25"}], ",", "25"}], "}"}], ",", 
      RowBox[{"{", "7", "}"}]}], "]"}], "/", "5"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->539727580],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Position", "[", 
  RowBox[{
   RowBox[{"Outer", "[", 
    RowBox[{"Subtract", ",", "a", ",", "b"}], "]"}], ",", "_Integer", ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->399736491],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "6"}], "}"}]}], "}"}]], "Output",
 ImageSize->{310, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->287682315]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Extract", "[", 
  RowBox[{
   RowBox[{"Outer", "[", 
    RowBox[{"List", ",", "a", ",", "b"}], "]"}], ",", "%"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->68690479],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["24", "5"]}], ",", 
     RowBox[{"-", 
      FractionBox["19", "5"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["24", "5"]}], ",", 
     RowBox[{"-", 
      FractionBox["9", "5"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["24", "5"]}], ",", 
     FractionBox["6", "5"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["23", "5"], ",", 
     RowBox[{"-", 
      FractionBox["22", "5"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["23", "5"], ",", 
     FractionBox["3", "5"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["23", "5"], ",", 
     FractionBox["8", "5"]}], "}"}]}], "}"}]], "Output",
 ImageSize->{461, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->10539054]
}, Open  ]],

Cell["Verify that their differences are integers:", "ExampleText",
 CellID->875600621],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Subtract", "@@@", "%"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->386274581],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", 
   RowBox[{"-", "3"}], ",", 
   RowBox[{"-", "6"}], ",", "9", ",", "4", ",", "3"}], "}"}]], "Output",
 ImageSize->{139, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->450626104]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5601],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Minus",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Minus"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Decrement",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Decrement"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Plus",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Plus"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Differences",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Differences"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SubtractFrom",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SubtractFrom"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23392]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->8683],

Cell[TextData[ButtonBox["Arithmetic",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Arithmetic"]], "Tutorials",
 CellID->8213],

Cell[TextData[ButtonBox["Special Forms of Assignment",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFormsOfAssignment"]], "Tutorials",
 CellID->19150]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->275671780],

Cell[TextData[ButtonBox["Arithmetic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ArithmeticFunctions"]], "MoreAbout",
 CellID->864188363]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Subtract (-) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 25, 17.7365326}", "context" -> "System`", 
    "keywords" -> {"subtract"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "x - y is equivalent to x + (-1*y). ", "synonyms" -> {"-"}, "title" -> 
    "Subtract", "type" -> "Symbol", "uri" -> "ref/Subtract"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4493, 150, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->40897882]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14393, 542}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2284, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2907, 81, 101, 4, 70, "ObjectName",
 CellID->20601],
Cell[3011, 87, 584, 21, 70, "Usage",
 CellID->6077]
}, Open  ]],
Cell[CellGroupData[{
Cell[3632, 113, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4110, 130, 346, 15, 70, "Notes",
 CellID->20215]
}, Closed]],
Cell[CellGroupData[{
Cell[4493, 150, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->40897882],
Cell[CellGroupData[{
Cell[4877, 164, 148, 5, 70, "ExampleSection",
 CellID->104852594],
Cell[5028, 171, 60, 1, 70, "ExampleText",
 CellID->237507447],
Cell[CellGroupData[{
Cell[5113, 176, 128, 4, 28, "Input",
 CellID->300495967],
Cell[5244, 182, 158, 5, 36, "Output",
 CellID->392952378]
}, Open  ]],
Cell[5417, 190, 125, 3, 70, "ExampleDelimiter",
 CellID->426823699],
Cell[5545, 195, 63, 1, 70, "ExampleText",
 CellID->24660472],
Cell[CellGroupData[{
Cell[5633, 200, 175, 6, 70, "Input",
 CellID->208898800],
Cell[5811, 208, 199, 6, 36, "Output",
 CellID->79810057]
}, Open  ]],
Cell[6025, 217, 125, 3, 70, "ExampleDelimiter",
 CellID->585241576],
Cell[6153, 222, 308, 12, 70, "ExampleText",
 CellID->199814873],
Cell[CellGroupData[{
Cell[6486, 238, 159, 5, 70, "Input",
 CellID->504831345],
Cell[6648, 245, 432, 16, 50, "Output",
 CellID->325828290]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7129, 267, 223, 7, 70, "ExampleSection",
 CellID->15498],
Cell[7355, 276, 90, 1, 70, "ExampleText",
 CellID->75478262],
Cell[7448, 279, 665, 23, 70, "Input",
 CellID->539727580],
Cell[CellGroupData[{
Cell[8138, 306, 243, 7, 70, "Input",
 CellID->399736491],
Cell[8384, 315, 538, 19, 36, "Output",
 CellID->287682315]
}, Open  ]],
Cell[CellGroupData[{
Cell[8959, 339, 196, 6, 70, "Input",
 CellID->68690479],
Cell[9158, 347, 965, 37, 51, "Output",
 CellID->10539054]
}, Open  ]],
Cell[10138, 387, 86, 1, 70, "ExampleText",
 CellID->875600621],
Cell[CellGroupData[{
Cell[10249, 392, 101, 3, 70, "Input",
 CellID->386274581],
Cell[10353, 397, 301, 10, 36, "Output",
 CellID->450626104]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10715, 414, 310, 9, 70, "SeeAlsoSection",
 CellID->5601],
Cell[11028, 425, 1188, 44, 70, "SeeAlso",
 CellID->23392]
}, Open  ]],
Cell[CellGroupData[{
Cell[12253, 474, 313, 9, 70, "TutorialsSection",
 CellID->8683],
Cell[12569, 485, 130, 3, 70, "Tutorials",
 CellID->8213],
Cell[12702, 490, 162, 3, 70, "Tutorials",
 CellID->19150]
}, Open  ]],
Cell[CellGroupData[{
Cell[12901, 498, 319, 9, 70, "MoreAboutSection",
 CellID->275671780],
Cell[13223, 509, 151, 3, 70, "MoreAbout",
 CellID->864188363]
}, Open  ]],
Cell[13389, 515, 27, 0, 70, "History"],
Cell[13419, 517, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

