(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11654,        400]
NotebookOptionsPosition[      9197,        318]
NotebookOutlinePosition[     10393,        354]
CellTagsIndexPosition[     10308,        349]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Operators without Built\[Hyphen]in Meanings" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OperatorsWithoutBuiltInMeanings"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Operators without Built\[Hyphen]in Meanings\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Exists" :> Documentation`HelpLookup["paclet:ref/Exists"], 
          "ForAll" :> Documentation`HelpLookup["paclet:ref/ForAll"], "Colon" :> 
          Documentation`HelpLookup["paclet:ref/Colon"], "VerticalBar" :> 
          Documentation`HelpLookup["paclet:ref/VerticalBar"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Exists\"\>", 2->"\<\"ForAll\"\>", 
       3->"\<\"Colon\"\>", 4->"\<\"VerticalBar\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     "SuchThat ",
     StyleBox["(\[SuchThat])", "OperatorCharacter"]
    }], "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SuchThat",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SuchThat"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]displays as ",
     Cell[BoxData[
      FormBox[
       RowBox[{"x", "\[SuchThat]", "y"}], TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SuchThat",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SuchThat"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 " has no built-in meaning."
}], "Notes",
 CellID->432672996],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "\[SuchThat]", "y"}], TraditionalForm]], "InlineMath"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SuchThat",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SuchThat"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->555415030],

Cell[TextData[{
 Cell[BoxData[
  FormBox["\[SuchThat]", TraditionalForm]], "InlineMath"],
 " can be entered as ",
 Cell[TextData[ButtonBox["\\[SuchThat]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/SuchThat"]], "InlineCharacterName"],
 " or ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]st\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->1896479348],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "\[SuchThat]", 
    RowBox[{"y", "\[SuchThat]", "z"}]}], TraditionalForm]], "InlineMath"],
 " groups as ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "\[SuchThat]", 
    RowBox[{"(", 
     RowBox[{"y", "\[SuchThat]", "z"}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->32134]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->72569954],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->377561858],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SuchThat", "[", 
  RowBox[{"x", ",", "y"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24290124],

Cell[BoxData[
 RowBox[{"x", "\[SuchThat]", "y"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->373677217]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->30630],

Cell[TextData[{
 Cell[TextData[StyleBox[ButtonBox["Exists",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Exists"],
  FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["ForAll",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ForAll"],
  FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["Colon",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Colon"],
  FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["VerticalBar",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/VerticalBar"],
  FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1021]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Operators without Built\[Hyphen]in Meanings",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OperatorsWithoutBuiltInMeanings"]], "Tutorials",\

 CellID->341631938]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SuchThat (\[SuchThat]) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 25, 19.4865774}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "SuchThat[x, y] displays as x \\[SuchThat] y.", 
    "synonyms" -> {"such that"}, "title" -> "SuchThat", "type" -> "Symbol", 
    "uri" -> "ref/SuchThat"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6437, 211, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->72569954]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10166, 342}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1500, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2123, 62, 1650, 40, 70, "ObjectNameGrid"],
Cell[3776, 104, 633, 21, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4446, 130, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4924, 147, 293, 11, 70, "Notes",
 CellID->432672996],
Cell[5220, 160, 402, 15, 70, "Notes",
 CellID->555415030],
Cell[5625, 177, 411, 13, 70, "Notes",
 CellID->1896479348],
Cell[6039, 192, 361, 14, 70, "Notes",
 CellID->32134]
}, Closed]],
Cell[CellGroupData[{
Cell[6437, 211, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->72569954],
Cell[CellGroupData[{
Cell[6821, 225, 148, 5, 70, "ExampleSection",
 CellID->377561858],
Cell[CellGroupData[{
Cell[6994, 234, 126, 4, 28, "Input",
 CellID->24290124],
Cell[7123, 240, 190, 6, 36, "Output",
 CellID->373677217]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7374, 253, 311, 9, 70, "SeeAlsoSection",
 CellID->30630],
Cell[7688, 264, 888, 27, 70, "SeeAlso",
 CellID->1021]
}, Open  ]],
Cell[CellGroupData[{
Cell[8613, 296, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[8934, 307, 191, 4, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[9140, 314, 27, 0, 70, "History"],
Cell[9170, 316, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

