(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     91044,       3396]
NotebookOptionsPosition[     74658,       2826]
NotebookOutlinePosition[     76586,       2872]
CellTagsIndexPosition[     76500,       2867]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Symbolic Mathematics: Basic Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SymbolicMathematics-BasicOperations"], 
          "Sums and Products" :> 
          Documentation`HelpLookup["paclet:tutorial/SumsAndProducts"], 
          "Summation of Series" :> 
          Documentation`HelpLookup["paclet:tutorial/SummationOfSeries"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Symbolic Mathematics: Basic Operations\"\>", 
       2->"\<\"Sums and Products\"\>", 
       3->"\<\"Summation of Series\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Do" :> Documentation`HelpLookup["paclet:ref/Do"], "Product" :> 
          Documentation`HelpLookup["paclet:ref/Product"], "Table" :> 
          Documentation`HelpLookup["paclet:ref/Table"], "NSum" :> 
          Documentation`HelpLookup["paclet:ref/NSum"], "ZTransform" :> 
          Documentation`HelpLookup["paclet:ref/ZTransform"], "Total" :> 
          Documentation`HelpLookup["paclet:ref/Total"], "RSolve" :> 
          Documentation`HelpLookup["paclet:ref/RSolve"], "Plus" :> 
          Documentation`HelpLookup["paclet:ref/Plus"], "Integrate" :> 
          Documentation`HelpLookup["paclet:ref/Integrate"], "CDF" :> 
          Documentation`HelpLookup["paclet:ref/CDF"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Do\"\>", 2->"\<\"Product\"\>", 
       3->"\<\"Table\"\>", 4->"\<\"NSum\"\>", 5->"\<\"ZTransform\"\>", 
       6->"\<\"Total\"\>", 7->"\<\"RSolve\"\>", 8->"\<\"Plus\"\>", 
       9->"\<\"Integrate\"\>", 10->"\<\"CDF\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Calculus" :> Documentation`HelpLookup["paclet:guide/Calculus"],
           "Core Language: New in 6.0" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60CoreLanguage"], 
          "Discrete Mathematics" :> 
          Documentation`HelpLookup["paclet:guide/DiscreteMathematics"], 
          "Integer Functions" :> 
          Documentation`HelpLookup["paclet:guide/IntegerFunctions"], 
          "Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheory"], 
          "Rational Functions" :> 
          Documentation`HelpLookup["paclet:guide/RationalFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Calculus\"\>", 
       2->"\<\"Core Language: New in 6.0\"\>", 
       3->"\<\"Discrete Mathematics\"\>", 4->"\<\"Integer Functions\"\>", 
       5->"\<\"Number Theory\"\>", 
       6->"\<\"Rational Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     "Sum ",
     StyleBox["(\[Sum])", "OperatorCharacter"]
    }], "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Sum",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Sum"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["i", "TI"], ",", 
          SubscriptBox[
           StyleBox["i", "TI"], 
           StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]evaluates the sum ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        UnderoverscriptBox["\[Sum]", 
         RowBox[{"i", "=", "1"}], 
         SubscriptBox["i", 
          StyleBox["max",
           FontSlant->"Italic"]],
         LimitsPositioning->True], "f"}], TraditionalForm]], "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Sum",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Sum"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["i", "TI"], ",", 
          SubscriptBox[
           StyleBox["i", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["i", "TI"], 
           StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]starts with ",
     Cell[BoxData[
      FormBox[
       RowBox[{"i", "=", 
        SubscriptBox["i", 
         StyleBox["min",
          FontSlant->"Italic"]]}], TraditionalForm]], "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Sum",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Sum"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["i", "TI"], ",", 
          SubscriptBox[
           StyleBox["i", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["i", "TI"], 
           StyleBox["max", "TI"]], ",", 
          StyleBox["di", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]uses steps ",
     Cell[BoxData[
      FormBox[
       RowBox[{"d", "\[InvisibleSpace]", "i"}], TraditionalForm]], 
      "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Sum",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Sum"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["i", "TI"], ",", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["i", "TI"], 
             StyleBox["1", "TR"]], ",", 
            SubscriptBox[
             StyleBox["i", "TI"], 
             StyleBox["2", "TR"]], ",", 
            StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "}"}]}], "]"}]], 
      "InlineFormula"],
     " \[LineSeparator]uses successive values ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["i", "1"], ",", 
        SubscriptBox["i", "2"], ",", "\[Ellipsis]"}], TraditionalForm]], 
      "InlineMath"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Sum",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Sum"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["i", "TI"], ",", 
          SubscriptBox[
           StyleBox["i", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["i", "TI"], 
           StyleBox["max", "TI"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["j", "TI"], ",", 
          SubscriptBox[
           StyleBox["j", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["j", "TI"], 
           StyleBox["max", "TI"]]}], "}"}], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]evaluates the multiple sum ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        UnderoverscriptBox["\[Sum]", 
         RowBox[{"i", "=", 
          SubscriptBox["i", 
           StyleBox["min",
            FontSlant->"Italic"]]}], 
         SubscriptBox["i", 
          StyleBox["max",
           FontSlant->"Italic"]],
         LimitsPositioning->True], 
        RowBox[{
         UnderoverscriptBox["\[Sum]", 
          RowBox[{"j", "=", 
           SubscriptBox["j", 
            StyleBox["min",
             FontSlant->"Italic"]]}], 
          SubscriptBox["j", 
           StyleBox["max",
            FontSlant->"Italic"]],
          LimitsPositioning->True], 
         RowBox[{"\[Ellipsis]", "f"}]}]}], TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->18397]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sum",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sum"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["i", "TI"], ",", 
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
 " can be entered as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", "i", 
     SubscriptBox["i", 
      StyleBox["max",
       FontSlant->"Italic"]]], "f"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->31418],

Cell[TextData[{
 Cell[BoxData[
  FormBox["\[Sum]", TraditionalForm]], "InlineMath"],
 " can be entered as ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]sum\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " or ",
 Cell[TextData[ButtonBox["\\[Sum]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Sum"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->19897],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sum",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sum"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["i", "TI"], ",", 
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["min", "TI"]], ",", 
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
 " can be entered as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"i", "=", 
      SubscriptBox["i", 
       StyleBox["min",
        FontSlant->"Italic"]]}], 
     SubscriptBox["i", 
      StyleBox["max",
       FontSlant->"Italic"]]], "f"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->25828],

Cell[TextData[{
 "The limits should be underscripts and overscripts of ",
 Cell[BoxData[
  FormBox["\[Sum]", TraditionalForm]], "InlineMath"],
 " in normal input, and subscripts and superscripts when embedded in other \
text. "
}], "Notes",
 CellID->13851],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sum"]], "InlineFormula"],
 " uses the standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " iteration specification. "
}], "Notes",
 CellID->26816],

Cell[TextData[{
 "The iteration variable ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 " is treated as local, effectively using ",
 Cell[BoxData[
  ButtonBox["Block",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Block"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->24230],

Cell[TextData[{
 "If the range of a sum is finite, ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]], "InlineMath"],
 " is typically assigned a sequence of values, with ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 " being evaluated for each one."
}], "Notes",
 CellID->4449],

Cell["\<\
In multiple sums, the range of the outermost variable is given first. \
\>", "Notes",
 CellID->16925],

Cell[TextData[{
 "The limits of summation need not be numbers. They can be ",
 Cell[BoxData[
  ButtonBox["Infinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Infinity"]], "InlineFormula"],
 " or symbolic expressions. "
}], "Notes",
 CellID->658],

Cell[TextData[{
 "If a sum cannot be carried out explicitly by adding up a finite number of \
terms, ",
 Cell[BoxData[
  ButtonBox["Sum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sum"]], "InlineFormula"],
 " will attempt to find a symbolic result. In this case, ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 " is first evaluated symbolically. "
}], "Notes",
 CellID->229],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sum"]], "InlineFormula"],
 " can do essentially all sums that are given in standard books of tables. "
}], "Notes",
 CellID->24520],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sum"]], "InlineFormula"],
 " is output in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " using ",
 Cell[BoxData[
  FormBox["\[Sum]", TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->10940]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->318328284],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(5)", "ExampleCount"]
}], "ExampleSection",
 CellID->302561345],

Cell["Numeric sum:", "ExampleText",
 CellID->288929090],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"i", "^", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3342781],

Cell[BoxData["385"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->167138867]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9824551],

Cell["Symbolic sum:", "ExampleText",
 CellID->310681702],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"i", "^", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31476411],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "6"], " ", "n", " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", "n"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", 
    RowBox[{"2", " ", "n"}]}], ")"}]}]], "Output",
 ImageSize->{123, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->615333958]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->478319747],

Cell[TextData[{
 "Use ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]sum\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " to enter ",
 Cell[BoxData[
  FormBox["\[Sum]", TraditionalForm]], "InlineMath"],
 " and ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["_", "KeyEvent"],
 " to enter the lower limit, then ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["%", "KeyEvent"],
 " for the upper limit: "
}], "ExampleText",
 CellID->359717208],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Sum]", 
   RowBox[{"i", "=", "1"}], "n"], 
  SuperscriptBox["i", "2"]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->521244181],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "6"], " ", "n", " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", "n"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", 
    RowBox[{"2", " ", "n"}]}], ")"}]}]], "Output",
 ImageSize->{123, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->257073614]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->254301955],

Cell["Infinite sum:", "ExampleText",
 CellID->165481249],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"i", "^", "6"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->274298987],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[Pi]", "6"], "945"]], "Output",
 ImageSize->{30, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5196291]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->365475630],

Cell[TextData[{
 "Multiple sum with summation over ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " performed first:"
}], "ExampleText",
 CellID->406788888],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"j", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"i", "+", "1"}], ")"}], "^", "2"}]}], ")"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"i", ",", "0", ",", "Infinity"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "1", ",", "i"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11356984],

Cell[BoxData[
 RowBox[{"Zeta", "[", "3", "]"}]], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->68490544]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(11)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26946],

Cell["Polynomials can be summed in terms of polynomials:", "ExampleText",
 CellID->25655792],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"i", "^", "3"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"i", "+", "3"}], ")"}], "^", "5"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->532930820],

Cell[BoxData[
 RowBox[{
  RowBox[{"243", " ", "n"}], "+", 
  RowBox[{
   FractionBox["405", "2"], " ", "n", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "n"}], ")"}]}], "+", 
  RowBox[{
   FractionBox["91", "4"], " ", 
   SuperscriptBox["n", "2"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "n"}], ")"}], "2"]}], "+", 
  RowBox[{"45", " ", "n", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "n"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"2", " ", "n"}]}], ")"}]}], "+", 
  RowBox[{
   FractionBox["1", "12"], " ", 
   SuperscriptBox["n", "2"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "n"}], ")"}], "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"2", " ", "n"}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["n", "2"]}]}], ")"}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", "n", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "n"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"2", " ", "n"}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"3", " ", "n"}], "+", 
     RowBox[{"3", " ", 
      SuperscriptBox["n", "2"]}]}], ")"}]}]}]], "Output",
 ImageSize->{418, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->350962910]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->253926142],

Cell["\<\
Exponential polynomials can be summed in terms of exponential polynomials:\
\>", "ExampleText",
 CellID->59210203],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"i", "^", "2"}], " ", 
    RowBox[{"a", "^", "i"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "0", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->45488151],

Cell[BoxData[
 FractionBox[
  RowBox[{"a", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "-", "a", "+", 
     SuperscriptBox["a", "n"], "+", 
     SuperscriptBox["a", 
      RowBox[{"1", "+", "n"}]], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "n"], " ", "n"}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["a", 
       RowBox[{"1", "+", "n"}]], " ", "n"}], "+", 
     RowBox[{
      SuperscriptBox["a", "n"], " ", 
      SuperscriptBox["n", "2"]}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["a", 
       RowBox[{"1", "+", "n"}]], " ", 
      SuperscriptBox["n", "2"]}], "+", 
     RowBox[{
      SuperscriptBox["a", 
       RowBox[{"2", "+", "n"}]], " ", 
      SuperscriptBox["n", "2"]}]}], ")"}]}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "a"}], ")"}], "3"]]], "Output",
 ImageSize->{379, 38},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->197939254]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2669765],

Cell["Rational functions can always be summed:", "ExampleText",
 CellID->320353482],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"i", "^", "2"}], "+", "1"}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->210488813],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"Csch", "[", "\[Pi]", "]"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"\[Pi]", " ", 
     RowBox[{"Cosh", "[", "\[Pi]", "]"}]}], "-", 
    RowBox[{"Sinh", "[", "\[Pi]", "]"}]}], ")"}]}]], "Output",
 ImageSize->{209, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->138880427]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->285295623],

Cell["\<\
Some rational exponential sums can be summed in terms of elementary \
functions:\
\>", "ExampleText",
 CellID->210209824],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "^", 
     RowBox[{"(", 
      RowBox[{"-", "i"}], ")"}]}], "/", 
    RowBox[{"(", 
     RowBox[{"i", 
      RowBox[{"(", 
       RowBox[{"i", "+", "1"}], ")"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->385486248],

Cell[BoxData[
 RowBox[{"1", "-", 
  RowBox[{"Log", "[", "2", "]"}]}]], "Output",
 ImageSize->{66, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->412522831]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->373334319],

Cell["\<\
Trigonometric polynomials can be summed in terms of trigonometric functions:\
\>", "ExampleText",
 CellID->114206307],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"3", " ", "i"}], "+", "b"}], "]"}], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"2", "i"}], "]"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->522799085],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{
        FractionBox["1", "2"], "-", "b"}], "]"}], "+", 
      RowBox[{"Cos", "[", 
       RowBox[{
        FractionBox["3", "2"], "-", "b"}], "]"}], "+", 
      RowBox[{"Cos", "[", 
       RowBox[{
        FractionBox["1", "2"], "+", "b"}], "]"}], "+", 
      RowBox[{"Cos", "[", 
       RowBox[{
        FractionBox["3", "2"], "+", "b"}], "]"}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{
         FractionBox["5", "2"], "+", "b"}], "]"}]}], "-", 
      RowBox[{"Cos", "[", 
       RowBox[{
        FractionBox["1", "2"], "-", "b", "-", "n"}], "]"}], "-", 
      RowBox[{"Cos", "[", 
       RowBox[{
        FractionBox["3", "2"], "-", "b", "-", "n"}], "]"}], "-", 
      RowBox[{"Cos", "[", 
       RowBox[{
        FractionBox["1", "2"], "+", "b", "+", "n"}], "]"}], "-", 
      RowBox[{"Cos", "[", 
       RowBox[{
        FractionBox["3", "2"], "+", "b", "+", "n"}], "]"}], "-", 
      RowBox[{"Cos", "[", 
       RowBox[{
        FractionBox["5", "2"], "+", "b", "+", "n"}], "]"}], "-", 
      RowBox[{"Cos", "[", 
       RowBox[{
        FractionBox["5", "2"], "+", "b", "+", 
        RowBox[{"5", " ", "n"}]}], "]"}]}], ")"}], " ", 
    RowBox[{"Csc", "[", 
     FractionBox["1", "2"], "]"}]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"2", " ", 
       RowBox[{"Cos", "[", "1", "]"}]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"Cos", "[", "2", "]"}]}]}], ")"}]}], ")"}]}]], "Output",
 ImageSize->{537, 90},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12809627]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->257216942],

Cell["\<\
Some binomial sums can be summed in terms of elementary functions:\
\>", "ExampleText",
 CellID->77879388],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"Binomial", "[", 
    RowBox[{"n", ",", "i"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "0", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->347724753],

Cell[BoxData[
 SuperscriptBox["2", "n"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->28110266]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->52706912],

Cell["Most binomial sums require special functions:", "ExampleText",
 CellID->726573026],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Binomial", "[", 
     RowBox[{"n", ",", "i"}], "]"}], "^", "2"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"i", ",", "0", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->623672660],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["4", "n"], " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{
     FractionBox["1", "2"], "+", "n"}], "]"}]}], 
  RowBox[{
   SqrtBox["\[Pi]"], " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{"1", "+", "n"}], "]"}]}]]], "Output",
 ImageSize->{112, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3859511]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Binomial", "[", 
     RowBox[{"n", ",", "i"}], "]"}], "^", "3"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"i", ",", "0", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->116059115],

Cell[BoxData[
 RowBox[{"HypergeometricPFQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "n"}], ",", 
     RowBox[{"-", "n"}], ",", 
     RowBox[{"-", "n"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"-", "1"}]}], "]"}]], "Output",
 ImageSize->{294, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->28605970]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->88899898],

Cell["Results in terms of special functions:", "ExampleText",
 CellID->381946007],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"i", "!"}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"i", "+", "1"}], ")"}], "!"}]}], ")"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"i", ",", "0", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->397068497],

Cell[BoxData[
 RowBox[{"BesselI", "[", 
  RowBox[{"1", ",", "2"}], "]"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->34398806]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "^", 
     RowBox[{"(", 
      RowBox[{"-", "i"}], ")"}]}], "/", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "i"}], "+", "1"}], ")"}], "^", "4"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10402288],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "32"], " ", 
  RowBox[{"LerchPhi", "[", 
   RowBox[{
    FractionBox["1", "2"], ",", "4", ",", 
    FractionBox["3", "2"]}], "]"}]}]], "Output",
 ImageSize->{147, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->320496457]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", "i", "]"}], "/", 
    RowBox[{"i", "^", "3"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->67414118],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"PolyLog", "[", 
     RowBox[{"3", ",", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", "\[ImaginaryI]"}]]}], "]"}], "+", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"3", ",", 
      SuperscriptBox["\[ExponentialE]", "\[ImaginaryI]"]}], "]"}]}], 
   ")"}]}]], "Output",
 ImageSize->{238, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->231912660]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], "^", "i"}], "/", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "i"}], "+", "1"}], ")"}], "!!"}], "^", "2"}]}], ")"}], 
    "*", 
    RowBox[{"z", "^", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "i"}], "+", "1"}], ")"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "0", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->573787703],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", "\[Pi]", " ", 
  RowBox[{"StruveH", "[", 
   RowBox[{"0", ",", "z"}], "]"}]}]], "Output",
 ImageSize->{118, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->263145159]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->348078905],

Cell["Logarithmic sums:", "ExampleText",
 CellID->59302393],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{"i", "^", "2"}], "+", "1"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->130427646],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"Log", "[", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "-", "\[ImaginaryI]"}], "]"}], "]"}]}], "-", 
  RowBox[{"Log", "[", 
   RowBox[{"Gamma", "[", 
    RowBox[{"1", "+", "\[ImaginaryI]"}], "]"}], "]"}], "+", 
  RowBox[{"Log", "[", 
   RowBox[{"Gamma", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "\[ImaginaryI]"}], ")"}], "+", "n"}], "]"}], "]"}], 
  "+", 
  RowBox[{"Log", "[", 
   RowBox[{"Gamma", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "\[ImaginaryI]"}], ")"}], "+", "n"}], "]"}], 
   "]"}]}]], "Output",
 ImageSize->{564, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->313045046]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Log", "[", "i", "]"}], "/", 
    RowBox[{"i", "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->599733402],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "6"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "EulerGamma"}], " ", 
     SuperscriptBox["\[Pi]", "2"]}], "-", 
    RowBox[{
     SuperscriptBox["\[Pi]", "2"], " ", 
     RowBox[{"Log", "[", "2", "]"}]}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["\[Pi]", "2"], " ", 
     RowBox[{"Log", "[", "Glaisher", "]"}]}], "-", 
    RowBox[{
     SuperscriptBox["\[Pi]", "2"], " ", 
     RowBox[{"Log", "[", "\[Pi]", "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{407, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->449956848]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->175420849],

Cell["Special function input yields special function output:", "ExampleText",
 CellID->951439627],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"Zeta", "[", 
      RowBox[{"2", "i"}], "]"}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", "i"}], "+", "1"}], ")"}], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", "i"}], "+", "2"}], ")"}], "*", 
      RowBox[{"2", "^", 
       RowBox[{"(", 
        RowBox[{"2", "i"}], ")"}]}]}], ")"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->38938423],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"72", " ", 
    SuperscriptBox["\[Pi]", "2"]}], "-", 
   SuperscriptBox["\[Pi]", "4"], "-", 
   RowBox[{"504", " ", 
    RowBox[{"Zeta", "[", "3", "]"}]}]}], 
  RowBox[{"288", " ", 
   SuperscriptBox["\[Pi]", "2"]}]]], "Output",
 ImageSize->{151, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19989753]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"i", "+", "3"}], ")"}], "^", "2"}]}], " ", 
    RowBox[{"PolyGamma", "[", "i", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5418256],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "108"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "395"}], "+", 
    RowBox[{"147", " ", "EulerGamma"}], "+", 
    RowBox[{"33", " ", 
     SuperscriptBox["\[Pi]", "2"]}], "-", 
    RowBox[{"18", " ", "EulerGamma", " ", 
     SuperscriptBox["\[Pi]", "2"]}], "+", 
    RowBox[{"108", " ", 
     RowBox[{"Zeta", "[", "3", "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{427, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->99944940]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"i", "^", "2"}], " ", 
    RowBox[{"HarmonicNumber", "[", "i", "]"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->13875857],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "36"], " ", "n", " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", 
    RowBox[{"3", " ", "n"}], "-", 
    RowBox[{"4", " ", 
     SuperscriptBox["n", "2"]}], "+", 
    RowBox[{"6", " ", 
     RowBox[{"HarmonicNumber", "[", "n", "]"}]}], "+", 
    RowBox[{"18", " ", "n", " ", 
     RowBox[{"HarmonicNumber", "[", "n", "]"}]}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["n", "2"], " ", 
     RowBox[{"HarmonicNumber", "[", "n", "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{586, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->294684202]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->363751725],

Cell["Multiple sums:", "ExampleText",
 CellID->642392195],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"j", "^", "2"}], "+", 
      RowBox[{"j", "^", "3"}]}], ")"}], 
    RowBox[{"2", "^", 
     RowBox[{"(", 
      RowBox[{"i", "+", "j"}], ")"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "k"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "0", ",", "i"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->183787805],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["8", "9"]}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "-", 
    RowBox[{"45", " ", 
     SuperscriptBox["2", "k"]}], "+", 
    RowBox[{"11", " ", 
     SuperscriptBox["2", 
      RowBox[{"2", "+", 
       RowBox[{"2", " ", "k"}]}]]}], "-", 
    RowBox[{"15", " ", 
     SuperscriptBox["2", 
      RowBox[{"1", "+", 
       RowBox[{"2", " ", "k"}]}]], " ", "k"}], "+", 
    RowBox[{"9", " ", 
     SuperscriptBox["4", "k"], " ", 
     SuperscriptBox["k", "2"]}], "-", 
    RowBox[{"3", " ", 
     SuperscriptBox["4", "k"], " ", 
     SuperscriptBox["k", "3"]}]}], ")"}]}]], "Output",
 ImageSize->{324, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->32834293]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"i", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"j", "^", 
       RowBox[{"(", 
        RowBox[{"i", "+", "1"}], ")"}]}], 
      RowBox[{"(", 
       RowBox[{"i", "+", "3"}], ")"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "Infinity"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "2", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->123494400],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "9"}], "+", 
    RowBox[{"2", " ", "EulerGamma"}], "+", 
    RowBox[{"3", " ", 
     RowBox[{"Log", "[", "2", "]"}]}], "+", 
    RowBox[{"12", " ", 
     RowBox[{"Log", "[", "Glaisher", "]"}]}], "+", 
    RowBox[{"3", " ", 
     RowBox[{"Log", "[", "\[Pi]", "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{391, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->15956608]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24515],

Cell["Sum with step size 2:", "ExampleText",
 CellID->22358751],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"f", "[", "i", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "5", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->222644377],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "1", "]"}], "+", 
  RowBox[{"f", "[", "3", "]"}], "+", 
  RowBox[{"f", "[", "5", "]"}]}]], "Output",
 ImageSize->{114, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18404870]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"z", "^", "i"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"i", "/", "2"}], ")"}], "!"}], "*", 
      RowBox[{"2", "^", 
       RowBox[{"(", 
        RowBox[{"i", "/", "2"}], ")"}]}]}], ")"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"i", ",", "0", ",", "Infinity", ",", " ", "2"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->248877574],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", 
  FractionBox[
   SuperscriptBox["z", "2"], "2"]]], "Output",
 ImageSize->{25, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->82559046]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1024509474],

Cell["Doubly infinite sums:", "ExampleText",
 CellID->90230397],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "i"}], "+", "1"}], ")"}], "^", "2"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"i", ",", 
     RowBox[{"-", "Infinity"}], ",", " ", "Infinity"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->116768218],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[Pi]", "2"], "4"]], "Output",
 ImageSize->{22, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->401841257]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "i", "]"}], "/", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "i"}], "+", "1"}], ")"}], "^", "2"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"i", ",", 
     RowBox[{"-", "Infinity"}], ",", " ", "Infinity"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->69490704],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "8"], " ", "\[ImaginaryI]", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    SuperscriptBox["\[ExponentialE]", "\[ImaginaryI]"]}], ")"}], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", "\[ImaginaryI]"}]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"LerchPhi", "[", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", "\[ImaginaryI]"}]], ",", "2", ",", 
      FractionBox["1", "2"]}], "]"}], "+", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", "\[ImaginaryI]"], " ", 
     RowBox[{"LerchPhi", "[", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", "\[ImaginaryI]"], ",", "2", ",", 
       FractionBox["1", "2"]}], "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{400, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->31948741]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->475],

Cell["Compute the mean for a Poisson distribution:  ", "ExampleText",
 CellID->292419982],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pdf", "=", 
  RowBox[{"PDF", "[", 
   RowBox[{
    RowBox[{"PoissonDistribution", "[", "\[Lambda]", "]"}], ",", "i"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->437857888],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", "\[Lambda]"}]], " ", 
   SuperscriptBox["\[Lambda]", "i"]}], 
  RowBox[{"i", "!"}]]], "Output",
 ImageSize->{42, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->439189198]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"i", " ", "pdf"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "0", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->27334249],

Cell[BoxData["\[Lambda]"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->57954143]
}, Open  ]],

Cell["Higher moments of the Poisson distribution:", "ExampleText",
 CellID->358794277],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"i", "^", "n"}], " ", "pdf"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "0", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->72149671],

Cell[BoxData[
 RowBox[{"BellB", "[", 
  RowBox[{"n", ",", "\[Lambda]"}], "]"}]], "Output",
 ImageSize->{79, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->252399122]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->461255207],

Cell["Compute a Riemann sum approximation:", "ExampleText",
 CellID->179833511],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"i", "/", "n"}], "]"}], "^", "2"}], " ", 
    RowBox[{"1", "/", "n"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "0", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->387932622],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"Csc", "[", 
    FractionBox["1", "n"], "]"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Sin", "[", 
       RowBox[{"2", "+", 
        FractionBox["1", "n"]}], "]"}]}], "+", 
     RowBox[{"Sin", "[", 
      FractionBox["1", "n"], "]"}], "+", 
     RowBox[{"2", " ", "n", " ", 
      RowBox[{"Sin", "[", 
       FractionBox["1", "n"], "]"}]}]}], ")"}]}], 
  RowBox[{"4", " ", "n"}]]], "Output",
 ImageSize->{279, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->308847041]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"n", "\[Rule]", 
   RowBox[{"10.", "^", "8"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->114195756],

Cell[BoxData["0.2726756468339466`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->101457027]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], "^", "2"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}], "//", "N"}]], "Input",\

 CellLabel->"In[3]:=",
 CellID->9148185],

Cell[BoxData["0.2726756432935796`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->363624828]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15615],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NSum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NSum"]], "InlineFormula"],
 " will use numerical methods to compute sums:"
}], "ExampleText",
 CellID->22233457],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"PolyGamma", "[", "i", "]"}], "/", 
    RowBox[{"2", "^", "i"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->427111789],

Cell[BoxData["0.11593151565841246`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->58939721]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"PolyGamma", "[", "i", "]"}], "/", 
    RowBox[{"2", "^", "i"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->374839636],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "EulerGamma"}], "+", 
  RowBox[{"Log", "[", "2", "]"}]}]], "Output",
 ImageSize->{137, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->186709044]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->48629317],

Cell[BoxData["0.11593151565841242`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->892110408]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->38996962],

Cell[TextData[{
 "Applying ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " to an unevaluated sum effectively uses ",
 Cell[BoxData[
  ButtonBox["NSum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NSum"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->97398223],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", 
     RowBox[{"i", "^", "3"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->795712089],

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Sum]", 
   RowBox[{"i", "=", "1"}], "\[Infinity]"], 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    SuperscriptBox["i", "3"]}]]}]], "Output",
 ImageSize->{45, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->227454845]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->69124427],

Cell[BoxData["0.36821490380122435`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->210885640]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->84554593],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sum"]], "InlineFormula"],
 " effectively solves a special difference equation as solved by ",
 Cell[BoxData[
  ButtonBox["RSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RSolve"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->437284146],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"a", "[", 
       RowBox[{"n", "+", "1"}], "]"}], "-", 
      RowBox[{"a", "[", "n", "]"}]}], "\[Equal]", "n"}], "&&", 
    RowBox[{
     RowBox[{"a", "[", "0", "]"}], "\[Equal]", "0"}]}], ",", 
   RowBox[{"a", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->409091736],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "n"}], ")"}], " ", "n"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{149, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->775510206]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{"i", ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "0", ",", 
     RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->456211648],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "n"}], ")"}], " ", "n"}]], "Output",
 ImageSize->{77, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->205779002]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"a", "[", 
        RowBox[{"n", "+", "1"}], "]"}], "-", 
       RowBox[{"a", "[", "n", "]"}]}], "\[Equal]", 
      RowBox[{"n", "^", "2"}]}], "&&", 
     RowBox[{
      RowBox[{"a", "[", "0", "]"}], "\[Equal]", "0"}]}], ",", 
    RowBox[{"a", "[", "n", "]"}], ",", "n"}], "]"}], "//", 
  "Expand"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->43289501],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["n", "6"], "-", 
     FractionBox[
      SuperscriptBox["n", "2"], "2"], "+", 
     FractionBox[
      SuperscriptBox["n", "3"], "3"]}]}], "}"}], "}"}]], "Output",
 ImageSize->{146, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->124941486]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sum", "[", 
   RowBox[{
    RowBox[{"i", "^", "2"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", 
      RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}], "//", "Expand"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->48316074],

Cell[BoxData[
 RowBox[{
  FractionBox["n", "6"], "-", 
  FractionBox[
   SuperscriptBox["n", "2"], "2"], "+", 
  FractionBox[
   SuperscriptBox["n", "3"], "3"]}]], "Output",
 ImageSize->{74, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->665920301]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23464946],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Series",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Series"]], "InlineFormula"],
 " computes finite power series expansions:"
}], "ExampleText",
 CellID->127469623],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "i"}], "/", 
    RowBox[{"i", "!"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "0", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->286919099],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", "x"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->469122057]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->78400363],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", "x", "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "6"], "+", 
   FractionBox[
    SuperscriptBox["x", "4"], "24"], "+", 
   FractionBox[
    SuperscriptBox["x", "5"], "120"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "6"],
    SeriesData[$CellContext`x, 0, {}, 0, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 1, 
    Rational[1, 2], 
    Rational[1, 6], 
    Rational[1, 24], 
    Rational[1, 120]}, 0, 6, 1],
  Editable->False]], "Output",
 ImageSize->{204, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->541397692]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->349061037],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SeriesCoefficient",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeriesCoefficient"]], "InlineFormula"],
 " computes the ",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " power series coefficient:"
}], "ExampleText",
 CellID->421217222],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SeriesCoefficient", "[", 
  RowBox[{
   RowBox[{"Exp", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "k"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18188876],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"k", "!"}]]], "Output",
 ImageSize->{24, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->111671079]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->426611511],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ZTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ZTransform"]], "InlineFormula"],
 " is a summation transform:"
}], "ExampleText",
 CellID->224002804],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "i", "]"}], 
    RowBox[{"z", "^", 
     RowBox[{"-", "i"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "0", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->390975743],

Cell[BoxData[
 FractionBox[
  RowBox[{"\[ImaginaryI]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"2", " ", "\[ImaginaryI]"}]]}], ")"}], " ", "z"}], 
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["\[ExponentialE]", "\[ImaginaryI]"]}], "+", "z", "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", " ", "\[ImaginaryI]"}]], " ", "z"}], "-", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", "\[ImaginaryI]"], " ", 
      SuperscriptBox["z", "2"]}]}], ")"}]}]]], "Output",
 ImageSize->{155, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7440157]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ZTransform", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "n", "]"}], ",", "n", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->92676571],

Cell[BoxData[
 FractionBox[
  RowBox[{"\[ImaginaryI]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"2", " ", "\[ImaginaryI]"}]]}], ")"}], " ", "z"}], 
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{"z", "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", " ", "\[ImaginaryI]"}]], " ", "z"}], "-", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", "\[ImaginaryI]"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox["z", "2"]}], ")"}]}]}], ")"}]}]]], "Output",
 ImageSize->{156, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->73664678]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20528],

Cell["Sums may not be convergent:", "ExampleText",
 CellID->181690933],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"1", "/", "i"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->141667290],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sum", "::", "\<\"div\"\>"}], ":", 
  " ", "\<\"Sum does not converge. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Sum/div\\\", ButtonNote \
-> \\\"Sum::div\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->56594287],

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Sum]", 
   RowBox[{"i", "=", "1"}], "\[Infinity]"], 
  FractionBox["1", "i"]}]], "Output",
 ImageSize->{33, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->201390342]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12570],

Cell[TextData[{
 "Moments of Gaussian functions represented as ",
 Cell[BoxData[
  ButtonBox["EllipticTheta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticTheta"]], "InlineFormula"],
 " functions:"
}], "ExampleText",
 CellID->61294837],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"i", "^", "4"}], " ", 
    RowBox[{"E", "^", 
     RowBox[{"(", 
      RowBox[{"-", 
       RowBox[{"i", "^", "2"}]}], ")"}]}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"i", ",", 
     RowBox[{"-", "Infinity"}], ",", " ", "Infinity"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->160800218],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    SuperscriptBox["EllipticTheta", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "0", ",", "1"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"3", ",", "0", ",", 
     FractionBox["1", "\[ExponentialE]"]}], "]"}], "\[ExponentialE]"], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["EllipticTheta", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "0", ",", "2"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"3", ",", "0", ",", 
     FractionBox["1", "\[ExponentialE]"]}], "]"}], 
   SuperscriptBox["\[ExponentialE]", "2"]]}]], "Output",
 ImageSize->{399, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->237885434]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->335316355],

Cell["\<\
Using a symbolic closed-form sum can provide a fast summation method:\
\>", "ExampleText",
 CellID->374384940],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{"Sum", "[", 
   RowBox[{
    RowBox[{"i", "^", "3"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", 
      RowBox[{"2", "^", "n"}]}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19319490],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["2", 
   RowBox[{
    RowBox[{"-", "2"}], "+", 
    RowBox[{"2", " ", "n"}]}]], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SuperscriptBox["2", "n"]}], ")"}], "2"]}]], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->635855150]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", " ", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"Timing", "[", 
        RowBox[{"s", ";"}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
      RowBox[{
       RowBox[{"Timing", "[", 
        RowBox[{
         RowBox[{"Sum", "[", 
          RowBox[{
           RowBox[{"i", "^", "3"}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "0", ",", 
             RowBox[{"2", "^", "n"}]}], "}"}]}], "]"}], ";"}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"n", ",", "10", ",", "19"}], "}"}]}], "]"}], "//", 
  "Grid"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->9749511],

Cell[BoxData[
 TagBox[GridBox[{
    {"2.9837243786801082`*^-15", "2.9837243786801082`*^-15"},
    {"2.9837243786801082`*^-15", "0.010000000000002979`"},
    {"0.`", "0.019999999999997867`"},
    {"1.8457457784393227`*^-15", "0.04100000000000184`"},
    {"5.023759186428833`*^-15", "0.09000000000000502`"},
    {"1.6167622796103842`*^-15", "0.17000000000000162`"},
    {"0.`", "0.35999999999999993`"},
    {"4.787836793695988`*^-16", "0.7210000000000005`"},
    {"0.`", "1.4119999999999968`"},
    {"4.912736883966318`*^-15", "2.885000000000005`"}
   },
   ColumnsEqual->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   RowsEqual->False],
  "Grid"]], "Output",
 ImageSize->{192, 169},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->201096560]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->792],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Do",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Do"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Product",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Product"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Table",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Table"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NSum",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NSum"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ZTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ZTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Total",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Total"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RSolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RSolve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Plus",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Plus"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Integrate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Integrate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CDF",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CDF"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->22361]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->29560],

Cell[TextData[ButtonBox["Symbolic Mathematics: Basic Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SymbolicMathematics-BasicOperations"]], "Tutorials",
 CellID->82228336],

Cell[TextData[ButtonBox["Sums and Products",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SumsAndProducts"]], "Tutorials",
 CellID->15147],

Cell[TextData[ButtonBox["Summation of Series",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SummationOfSeries"]], "Tutorials",
 CellID->25162]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->1655],

Cell[TextData[ButtonBox["Implementation notes: Algebra and Calculus",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#10202"], None}]], "RelatedLinks",
 CellID->20675]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->138663831],

Cell[TextData[ButtonBox["Calculus",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Calculus"]], "MoreAbout",
 CellID->37148822],

Cell[TextData[ButtonBox["Core Language: New in 6.0",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60CoreLanguage"]], "MoreAbout",
 CellID->262790140],

Cell[TextData[ButtonBox["Discrete Mathematics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteMathematics"]], "MoreAbout",
 CellID->648061255],

Cell[TextData[ButtonBox["Integer Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntegerFunctions"]], "MoreAbout",
 CellID->606011153],

Cell[TextData[ButtonBox["Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheory"]], "MoreAbout",
 CellID->205450972],

Cell[TextData[ButtonBox["Rational Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RationalFunctions"]], "MoreAbout",
 CellID->2305940]
}, Open  ]],

Cell["New in 1  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Sum (\[Sum]) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 25, 19.9709648}", "context" -> "System`", 
    "keywords" -> {
     "Adamchik techniques", "d'Alembert test", "Dirichlet series", 
      "Gradshteyn-Ryzhik", "hypergeometric sums", "power series", 
      "Raabe test", "sequences", "series", "sums", "symbolic sums"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Sum[f, {i, i_max}] evaluates the sum UnderoverscriptBox[\"\\[Sum]\", \
RowBox[{\"i\", \"=\", \"1\"}], \"i_max\", LimitsPositioning->True]f. Sum[f, \
{i, i_min, i_max}] starts with i = i_min. Sum[f, {i, i_min, i_max, di}] uses \
steps di. Sum[expr, {i, {i_1, i_2, ...}}] uses successive values i_1, i_2, \
.... Sum[f, {i, i_min, i_max}, {j, j_min, j_max}, ...] evaluates the multiple \
sum UnderoverscriptBox[\"\\[Sum]\", RowBox[{\"i\", \"=\", \"i_min\"}], \
\"i_max\", LimitsPositioning->True] UnderoverscriptBox[\"\\[Sum]\", \
RowBox[{\"j\", \"=\", \"j_min\"}], \"j_max\", LimitsPositioning->True]... f. \
", "synonyms" -> {}, "title" -> "Sum", "type" -> "Symbol", "uri" -> 
    "ref/Sum"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[18278, 555, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->318328284]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 76356, 2860}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3579, 75, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4202, 102, 4259, 86, 70, "ObjectNameGrid"],
Cell[8464, 190, 4957, 166, 70, "Usage",
 CellID->18397]
}, Open  ]],
Cell[CellGroupData[{
Cell[13458, 361, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[13936, 378, 604, 24, 70, "Notes",
 CellID->31418],
Cell[14543, 404, 393, 13, 70, "Notes",
 CellID->19897],
Cell[14939, 419, 791, 31, 70, "Notes",
 CellID->25828],
Cell[15733, 452, 256, 7, 70, "Notes",
 CellID->13851],
Cell[15992, 461, 256, 10, 70, "Notes",
 CellID->26816],
Cell[16251, 473, 293, 11, 70, "Notes",
 CellID->24230],
Cell[16547, 486, 298, 9, 70, "Notes",
 CellID->4449],
Cell[16848, 497, 111, 3, 70, "Notes",
 CellID->16925],
Cell[16962, 502, 253, 8, 70, "Notes",
 CellID->658],
Cell[17218, 512, 401, 12, 70, "Notes",
 CellID->229],
Cell[17622, 526, 230, 7, 70, "Notes",
 CellID->24520],
Cell[17855, 535, 386, 15, 70, "Notes",
 CellID->10940]
}, Closed]],
Cell[CellGroupData[{
Cell[18278, 555, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->318328284],
Cell[CellGroupData[{
Cell[18663, 569, 148, 5, 70, "ExampleSection",
 CellID->302561345],
Cell[18814, 576, 55, 1, 70, "ExampleText",
 CellID->288929090],
Cell[CellGroupData[{
Cell[18894, 581, 194, 7, 28, "Input",
 CellID->3342781],
Cell[19091, 590, 160, 5, 36, "Output",
 CellID->167138867]
}, Open  ]],
Cell[19266, 598, 123, 3, 70, "ExampleDelimiter",
 CellID->9824551],
Cell[19392, 603, 56, 1, 70, "ExampleText",
 CellID->310681702],
Cell[CellGroupData[{
Cell[19473, 608, 204, 7, 70, "Input",
 CellID->31476411],
Cell[19680, 617, 341, 12, 51, "Output",
 CellID->615333958]
}, Open  ]],
Cell[20036, 632, 125, 3, 70, "ExampleDelimiter",
 CellID->478319747],
Cell[20164, 637, 528, 18, 70, "ExampleText",
 CellID->359717208],
Cell[CellGroupData[{
Cell[20717, 659, 172, 6, 70, "Input",
 CellID->521244181],
Cell[20892, 667, 341, 12, 51, "Output",
 CellID->257073614]
}, Open  ]],
Cell[21248, 682, 125, 3, 70, "ExampleDelimiter",
 CellID->254301955],
Cell[21376, 687, 56, 1, 70, "ExampleText",
 CellID->165481249],
Cell[CellGroupData[{
Cell[21457, 692, 237, 8, 70, "Input",
 CellID->274298987],
Cell[21697, 702, 206, 7, 54, "Output",
 CellID->5196291]
}, Open  ]],
Cell[21918, 712, 125, 3, 70, "ExampleDelimiter",
 CellID->365475630],
Cell[22046, 717, 170, 6, 70, "ExampleText",
 CellID->406788888],
Cell[CellGroupData[{
Cell[22241, 727, 415, 14, 70, "Input",
 CellID->11356984],
Cell[22659, 743, 187, 6, 36, "Output",
 CellID->68490544]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22895, 755, 217, 7, 70, "ExampleSection",
 CellID->26946],
Cell[23115, 764, 92, 1, 70, "ExampleText",
 CellID->25655792],
Cell[CellGroupData[{
Cell[23232, 769, 308, 11, 70, "Input",
 CellID->532930820],
Cell[23543, 782, 1363, 48, 81, "Output",
 CellID->350962910]
}, Open  ]],
Cell[24921, 833, 125, 3, 70, "ExampleDelimiter",
 CellID->253926142],
Cell[25049, 838, 124, 3, 70, "ExampleText",
 CellID->59210203],
Cell[CellGroupData[{
Cell[25198, 845, 254, 9, 70, "Input",
 CellID->45488151],
Cell[25455, 856, 985, 33, 59, "Output",
 CellID->197939254]
}, Open  ]],
Cell[26455, 892, 123, 3, 70, "ExampleDelimiter",
 CellID->2669765],
Cell[26581, 897, 83, 1, 70, "ExampleText",
 CellID->320353482],
Cell[CellGroupData[{
Cell[26689, 902, 290, 10, 70, "Input",
 CellID->210488813],
Cell[26982, 914, 398, 13, 51, "Output",
 CellID->138880427]
}, Open  ]],
Cell[27395, 930, 125, 3, 70, "ExampleDelimiter",
 CellID->285295623],
Cell[27523, 935, 131, 4, 70, "ExampleText",
 CellID->210209824],
Cell[CellGroupData[{
Cell[27679, 943, 386, 14, 70, "Input",
 CellID->385486248],
Cell[28068, 959, 210, 7, 36, "Output",
 CellID->412522831]
}, Open  ]],
Cell[28293, 969, 125, 3, 70, "ExampleDelimiter",
 CellID->373334319],
Cell[28421, 974, 127, 3, 70, "ExampleText",
 CellID->114206307],
Cell[CellGroupData[{
Cell[28573, 981, 348, 12, 70, "Input",
 CellID->522799085],
Cell[28924, 995, 1754, 55, 111, "Output",
 CellID->12809627]
}, Open  ]],
Cell[30693, 1053, 125, 3, 70, "ExampleDelimiter",
 CellID->257216942],
Cell[30821, 1058, 116, 3, 70, "ExampleText",
 CellID->77879388],
Cell[CellGroupData[{
Cell[30962, 1065, 242, 8, 70, "Input",
 CellID->347724753],
Cell[31207, 1075, 180, 6, 36, "Output",
 CellID->28110266]
}, Open  ]],
Cell[31402, 1084, 124, 3, 70, "ExampleDelimiter",
 CellID->52706912],
Cell[31529, 1089, 88, 1, 70, "ExampleText",
 CellID->726573026],
Cell[CellGroupData[{
Cell[31642, 1094, 273, 9, 70, "Input",
 CellID->623672660],
Cell[31918, 1105, 405, 15, 64, "Output",
 CellID->3859511]
}, Open  ]],
Cell[CellGroupData[{
Cell[32360, 1125, 273, 9, 70, "Input",
 CellID->116059115],
Cell[32636, 1136, 424, 15, 36, "Output",
 CellID->28605970]
}, Open  ]],
Cell[33075, 1154, 124, 3, 70, "ExampleDelimiter",
 CellID->88899898],
Cell[33202, 1159, 81, 1, 70, "ExampleText",
 CellID->381946007],
Cell[CellGroupData[{
Cell[33308, 1164, 364, 13, 70, "Input",
 CellID->397068497],
Cell[33675, 1179, 213, 7, 36, "Output",
 CellID->34398806]
}, Open  ]],
Cell[CellGroupData[{
Cell[33925, 1191, 385, 14, 70, "Input",
 CellID->10402288],
Cell[34313, 1207, 318, 11, 51, "Output",
 CellID->320496457]
}, Open  ]],
Cell[CellGroupData[{
Cell[34668, 1223, 273, 9, 70, "Input",
 CellID->67414118],
Cell[34944, 1234, 508, 17, 51, "Output",
 CellID->231912660]
}, Open  ]],
Cell[CellGroupData[{
Cell[35489, 1256, 584, 22, 70, "Input",
 CellID->573787703],
Cell[36076, 1280, 274, 9, 51, "Output",
 CellID->263145159]
}, Open  ]],
Cell[36365, 1292, 125, 3, 70, "ExampleDelimiter",
 CellID->348078905],
Cell[36493, 1297, 59, 1, 70, "ExampleText",
 CellID->59302393],
Cell[CellGroupData[{
Cell[36577, 1302, 263, 9, 70, "Input",
 CellID->130427646],
Cell[36843, 1313, 735, 25, 36, "Output",
 CellID->313045046]
}, Open  ]],
Cell[CellGroupData[{
Cell[37615, 1343, 269, 9, 70, "Input",
 CellID->599733402],
Cell[37887, 1354, 644, 21, 51, "Output",
 CellID->449956848]
}, Open  ]],
Cell[38546, 1378, 125, 3, 70, "ExampleDelimiter",
 CellID->175420849],
Cell[38674, 1383, 97, 1, 70, "ExampleText",
 CellID->951439627],
Cell[CellGroupData[{
Cell[38796, 1388, 590, 21, 70, "Input",
 CellID->38938423],
Cell[39389, 1411, 408, 14, 56, "Output",
 CellID->19989753]
}, Open  ]],
Cell[CellGroupData[{
Cell[39834, 1430, 354, 12, 70, "Input",
 CellID->5418256],
Cell[40191, 1444, 532, 17, 51, "Output",
 CellID->99944940]
}, Open  ]],
Cell[CellGroupData[{
Cell[40760, 1466, 277, 9, 70, "Input",
 CellID->13875857],
Cell[41040, 1477, 633, 19, 51, "Output",
 CellID->294684202]
}, Open  ]],
Cell[41688, 1499, 125, 3, 70, "ExampleDelimiter",
 CellID->363751725],
Cell[41816, 1504, 57, 1, 70, "ExampleText",
 CellID->642392195],
Cell[CellGroupData[{
Cell[41898, 1509, 452, 16, 70, "Input",
 CellID->183787805],
Cell[42353, 1527, 764, 26, 51, "Output",
 CellID->32834293]
}, Open  ]],
Cell[CellGroupData[{
Cell[43154, 1558, 473, 16, 70, "Input",
 CellID->123494400],
Cell[43630, 1576, 518, 17, 51, "Output",
 CellID->15956608]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[44197, 1599, 239, 7, 70, "ExampleSection",
 CellID->24515],
Cell[44439, 1608, 63, 1, 70, "ExampleText",
 CellID->22358751],
Cell[CellGroupData[{
Cell[44527, 1613, 220, 7, 70, "Input",
 CellID->222644377],
Cell[44750, 1622, 274, 9, 36, "Output",
 CellID->18404870]
}, Open  ]],
Cell[CellGroupData[{
Cell[45061, 1636, 474, 17, 70, "Input",
 CellID->248877574],
Cell[45538, 1655, 240, 8, 46, "Output",
 CellID->82559046]
}, Open  ]],
Cell[45793, 1666, 126, 3, 70, "ExampleDelimiter",
 CellID->1024509474],
Cell[45922, 1671, 63, 1, 70, "ExampleText",
 CellID->90230397],
Cell[CellGroupData[{
Cell[46010, 1676, 354, 13, 70, "Input",
 CellID->116768218],
Cell[46367, 1691, 206, 7, 54, "Output",
 CellID->401841257]
}, Open  ]],
Cell[CellGroupData[{
Cell[46610, 1703, 385, 14, 70, "Input",
 CellID->69490704],
Cell[46998, 1719, 887, 26, 51, "Output",
 CellID->31948741]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[47934, 1751, 221, 7, 70, "ExampleSection",
 CellID->475],
Cell[48158, 1760, 89, 1, 70, "ExampleText",
 CellID->292419982],
Cell[CellGroupData[{
Cell[48272, 1765, 208, 7, 70, "Input",
 CellID->437857888],
Cell[48483, 1774, 319, 11, 54, "Output",
 CellID->439189198]
}, Open  ]],
Cell[CellGroupData[{
Cell[48839, 1790, 250, 8, 70, "Input",
 CellID->27334249],
Cell[49092, 1800, 165, 5, 36, "Output",
 CellID->57954143]
}, Open  ]],
Cell[49272, 1808, 86, 1, 70, "ExampleText",
 CellID->358794277],
Cell[CellGroupData[{
Cell[49383, 1813, 276, 9, 70, "Input",
 CellID->72149671],
Cell[49662, 1824, 220, 7, 36, "Output",
 CellID->252399122]
}, Open  ]],
Cell[49897, 1834, 125, 3, 70, "ExampleDelimiter",
 CellID->461255207],
Cell[50025, 1839, 79, 1, 70, "ExampleText",
 CellID->179833511],
Cell[CellGroupData[{
Cell[50129, 1844, 315, 11, 70, "Input",
 CellID->387932622],
Cell[50447, 1857, 602, 21, 60, "Output",
 CellID->308847041]
}, Open  ]],
Cell[CellGroupData[{
Cell[51086, 1883, 148, 5, 70, "Input",
 CellID->114195756],
Cell[51237, 1890, 176, 5, 36, "Output",
 CellID->101457027]
}, Open  ]],
Cell[CellGroupData[{
Cell[51450, 1900, 272, 10, 70, "Input",
 CellID->9148185],
Cell[51725, 1912, 176, 5, 36, "Output",
 CellID->363624828]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[51950, 1923, 233, 7, 70, "ExampleSection",
 CellID->15615],
Cell[52186, 1932, 212, 7, 70, "ExampleText",
 CellID->22233457],
Cell[CellGroupData[{
Cell[52423, 1943, 276, 9, 70, "Input",
 CellID->427111789],
Cell[52702, 1954, 176, 5, 36, "Output",
 CellID->58939721]
}, Open  ]],
Cell[CellGroupData[{
Cell[52915, 1964, 275, 9, 70, "Input",
 CellID->374839636],
Cell[53193, 1975, 238, 8, 36, "Output",
 CellID->186709044]
}, Open  ]],
Cell[CellGroupData[{
Cell[53468, 1988, 96, 3, 70, "Input",
 CellID->48629317],
Cell[53567, 1993, 177, 5, 36, "Output",
 CellID->892110408]
}, Open  ]],
Cell[53759, 2001, 124, 3, 70, "ExampleDelimiter",
 CellID->38996962],
Cell[53886, 2006, 333, 13, 70, "ExampleText",
 CellID->97398223],
Cell[CellGroupData[{
Cell[54244, 2023, 265, 9, 70, "Input",
 CellID->795712089],
Cell[54512, 2034, 330, 11, 58, "Output",
 CellID->227454845]
}, Open  ]],
Cell[CellGroupData[{
Cell[54879, 2050, 96, 3, 70, "Input",
 CellID->69124427],
Cell[54978, 2055, 177, 5, 36, "Output",
 CellID->210885640]
}, Open  ]],
Cell[55170, 2063, 124, 3, 70, "ExampleDelimiter",
 CellID->84554593],
Cell[55297, 2068, 351, 12, 70, "ExampleText",
 CellID->437284146],
Cell[CellGroupData[{
Cell[55673, 2084, 402, 13, 70, "Input",
 CellID->409091736],
Cell[56078, 2099, 402, 15, 51, "Output",
 CellID->775510206]
}, Open  ]],
Cell[CellGroupData[{
Cell[56517, 2119, 207, 7, 70, "Input",
 CellID->456211648],
Cell[56727, 2128, 278, 10, 51, "Output",
 CellID->205779002]
}, Open  ]],
Cell[CellGroupData[{
Cell[57042, 2143, 470, 16, 70, "Input",
 CellID->43289501],
Cell[57515, 2161, 427, 15, 54, "Output",
 CellID->124941486]
}, Open  ]],
Cell[CellGroupData[{
Cell[57979, 2181, 264, 9, 70, "Input",
 CellID->48316074],
Cell[58246, 2192, 303, 11, 54, "Output",
 CellID->665920301]
}, Open  ]],
Cell[58564, 2206, 124, 3, 70, "ExampleDelimiter",
 CellID->23464946],
Cell[58691, 2211, 214, 7, 70, "ExampleText",
 CellID->127469623],
Cell[CellGroupData[{
Cell[58930, 2222, 257, 9, 70, "Input",
 CellID->286919099],
Cell[59190, 2233, 195, 6, 36, "Output",
 CellID->469122057]
}, Open  ]],
Cell[CellGroupData[{
Cell[59422, 2244, 183, 6, 70, "Input",
 CellID->78400363],
Cell[59608, 2252, 753, 26, 54, "Output",
 CellID->541397692]
}, Open  ]],
Cell[60376, 2281, 125, 3, 70, "ExampleDelimiter",
 CellID->349061037],
Cell[60504, 2286, 379, 13, 70, "ExampleText",
 CellID->421217222],
Cell[CellGroupData[{
Cell[60908, 2303, 225, 7, 70, "Input",
 CellID->18188876],
Cell[61136, 2312, 196, 7, 51, "Output",
 CellID->111671079]
}, Open  ]],
Cell[61347, 2322, 125, 3, 70, "ExampleDelimiter",
 CellID->426611511],
Cell[61475, 2327, 207, 7, 70, "ExampleText",
 CellID->224002804],
Cell[CellGroupData[{
Cell[61707, 2338, 285, 10, 70, "Input",
 CellID->390975743],
Cell[61995, 2350, 755, 23, 64, "Output",
 CellID->7440157]
}, Open  ]],
Cell[CellGroupData[{
Cell[62787, 2378, 169, 5, 70, "Input",
 CellID->92676571],
Cell[62959, 2385, 728, 23, 64, "Output",
 CellID->73664678]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[63736, 2414, 226, 7, 70, "ExampleSection",
 CellID->20528],
Cell[63965, 2423, 70, 1, 70, "ExampleText",
 CellID->181690933],
Cell[CellGroupData[{
Cell[64060, 2428, 212, 7, 70, "Input",
 CellID->141667290],
Cell[64275, 2437, 330, 7, 70, "Message",
 CellID->56594287],
Cell[64608, 2446, 268, 9, 58, "Output",
 CellID->201390342]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[64925, 2461, 224, 7, 70, "ExampleSection",
 CellID->12570],
Cell[65152, 2470, 247, 8, 70, "ExampleText",
 CellID->61294837],
Cell[CellGroupData[{
Cell[65424, 2482, 379, 14, 70, "Input",
 CellID->160800218],
Cell[65806, 2498, 810, 27, 60, "Output",
 CellID->237885434]
}, Open  ]],
Cell[66631, 2528, 125, 3, 70, "ExampleDelimiter",
 CellID->335316355],
Cell[66759, 2533, 120, 3, 70, "ExampleText",
 CellID->374384940],
Cell[CellGroupData[{
Cell[66904, 2540, 258, 9, 70, "Input",
 CellID->19319490],
Cell[67165, 2551, 373, 14, 36, "Output",
 CellID->635855150]
}, Open  ]],
Cell[CellGroupData[{
Cell[67575, 2570, 735, 24, 70, "Input",
 CellID->9749511],
Cell[68313, 2596, 827, 21, 190, "Output",
 CellID->201096560]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[69201, 2624, 309, 9, 70, "SeeAlsoSection",
 CellID->792],
Cell[69513, 2635, 2361, 89, 70, "SeeAlso",
 CellID->22361]
}, Open  ]],
Cell[CellGroupData[{
Cell[71911, 2729, 314, 9, 70, "TutorialsSection",
 CellID->29560],
Cell[72228, 2740, 190, 4, 70, "Tutorials",
 CellID->82228336],
Cell[72421, 2746, 143, 3, 70, "Tutorials",
 CellID->15147],
Cell[72567, 2751, 147, 3, 70, "Tutorials",
 CellID->25162]
}, Open  ]],
Cell[CellGroupData[{
Cell[72751, 2759, 320, 9, 70, "RelatedLinksSection",
 CellID->1655],
Cell[73074, 2770, 254, 5, 70, "RelatedLinks",
 CellID->20675]
}, Open  ]],
Cell[CellGroupData[{
Cell[73365, 2780, 319, 9, 70, "MoreAboutSection",
 CellID->138663831],
Cell[73687, 2791, 127, 3, 70, "MoreAbout",
 CellID->37148822],
Cell[73817, 2796, 156, 3, 70, "MoreAbout",
 CellID->262790140],
Cell[73976, 2801, 151, 3, 70, "MoreAbout",
 CellID->648061255],
Cell[74130, 2806, 145, 3, 70, "MoreAbout",
 CellID->606011153],
Cell[74278, 2811, 137, 3, 70, "MoreAbout",
 CellID->205450972],
Cell[74418, 2816, 145, 3, 70, "MoreAbout",
 CellID->2305940]
}, Open  ]],
Cell[74578, 2822, 50, 0, 70, "History"],
Cell[74631, 2824, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

