(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13490,        465]
NotebookOptionsPosition[     10705,        372]
NotebookOutlinePosition[     11902,        408]
CellTagsIndexPosition[     11817,        403]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Operators without Built\[Hyphen]in Meanings" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OperatorsWithoutBuiltInMeanings"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Operators without Built\[Hyphen]in Meanings\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Superscript" :> 
          Documentation`HelpLookup["paclet:ref/Superscript"], "SuperPlus" :> 
          Documentation`HelpLookup["paclet:ref/SuperPlus"], "SuperMinus" :> 
          Documentation`HelpLookup["paclet:ref/SuperMinus"], "SuperStar" :> 
          Documentation`HelpLookup["paclet:ref/SuperStar"], "Style" :> 
          Documentation`HelpLookup["paclet:ref/Style"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Superscript\"\>", 2->"\<\"SuperPlus\"\>", 
       3->"\<\"SuperMinus\"\>", 4->"\<\"SuperStar\"\>", 
       5->"\<\"Style\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Symbolic Notational Forms" :> 
          Documentation`HelpLookup[
           "paclet:guide/SymbolicNotationalForms"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Symbolic Notational Forms\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["SuperDagger", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SuperDagger",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SuperDagger"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]displays as ",
     Cell[BoxData[
      SuperscriptBox[
       StyleBox["expr", "TI"], "\[Dagger]"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SuperDagger",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SuperDagger"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " can be entered using ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["^", "KeyEvent"],
 " and ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]dg\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SuperDagger",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SuperDagger"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " remains unchanged by evaluation."
}], "Notes",
 CellID->10989299]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->333274369],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->23091999],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SuperDagger", "[", "v", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->373681325],

Cell[BoxData[
 SuperscriptBox["v", "\[Dagger]"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->157176141]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->339348277],

Cell[TextData[{
 "Type ",
 Cell[BoxData[
  StyleBox["v", "TI"]], "InlineFormula"],
 " ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["^", "KeyEvent"],
 " ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]dg\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " to enter directly:"
}], "ExampleText",
 CellID->77455463],

Cell[CellGroupData[{

Cell[BoxData[
 SuperscriptBox["v", "\[Dagger]"]], "Input",
 CellLabel->"In[1]:=",
 CellID->660530834],

Cell[BoxData[
 SuperscriptBox["v", "\[Dagger]"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->196671783]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Superscript",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Superscript"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SuperPlus",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SuperPlus"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SuperMinus",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SuperMinus"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SuperStar",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SuperStar"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Operators without Built\[Hyphen]in Meanings",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OperatorsWithoutBuiltInMeanings"]], "Tutorials",\

 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Symbolic Notational Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicNotationalForms"]], "MoreAbout",
 CellID->661062447]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SuperDagger - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 25, 20.8928634}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "SuperDagger[expr] displays as expr^\\[Dagger].", 
    "synonyms" -> {"super dagger"}, "title" -> "SuperDagger", "type" -> 
    "Symbol", "uri" -> "ref/SuperDagger"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6324, 194, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->333274369]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11674, 396}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2240, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2863, 81, 1576, 37, 70, "ObjectNameGrid"],
Cell[4442, 120, 583, 19, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5062, 144, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5540, 161, 481, 17, 70, "Notes",
 CellID->1067943069],
Cell[6024, 180, 263, 9, 70, "Notes",
 CellID->10989299]
}, Closed]],
Cell[CellGroupData[{
Cell[6324, 194, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->333274369],
Cell[CellGroupData[{
Cell[6709, 208, 147, 5, 70, "ExampleSection",
 CellID->23091999],
Cell[CellGroupData[{
Cell[6881, 217, 107, 3, 28, "Input",
 CellID->373681325],
Cell[6991, 222, 189, 6, 36, "Output",
 CellID->157176141]
}, Open  ]],
Cell[7195, 231, 125, 3, 70, "ExampleDelimiter",
 CellID->339348277],
Cell[7323, 236, 366, 14, 70, "ExampleText",
 CellID->77455463],
Cell[CellGroupData[{
Cell[7714, 254, 101, 3, 28, "Input",
 CellID->660530834],
Cell[7818, 259, 189, 6, 36, "Output",
 CellID->196671783]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8068, 272, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[8387, 283, 1198, 44, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[9622, 332, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[9943, 343, 191, 4, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[10171, 352, 299, 8, 70, "MoreAboutSection"],
Cell[10473, 362, 160, 3, 70, "MoreAbout",
 CellID->661062447]
}, Open  ]],
Cell[10648, 368, 27, 0, 70, "History"],
Cell[10678, 370, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

