(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24101,        809]
NotebookOptionsPosition[     19952,        672]
NotebookOutlinePosition[     21344,        710]
CellTagsIndexPosition[     21259,        705]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Representing Textual Forms by Boxes" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/RepresentingTextualFormsByBoxes"], 
          "String Representation of Boxes" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StringRepresentationOfBoxes"], "Formatted Output" :> 
          Documentation`HelpLookup["paclet:tutorial/FormattedOutput"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Representing Textual Forms by Boxes\"\>", 
       2->"\<\"String Representation of Boxes\"\>", 
       3->"\<\"Formatted Output\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Superscript" :> 
          Documentation`HelpLookup["paclet:ref/Superscript"], "SubscriptBox" :> 
          Documentation`HelpLookup["paclet:ref/SubscriptBox"], 
          "SubsuperscriptBox" :> 
          Documentation`HelpLookup["paclet:ref/SubsuperscriptBox"], 
          "OverscriptBox" :> 
          Documentation`HelpLookup["paclet:ref/OverscriptBox"], 
          "ScriptSizeMultipliers" :> 
          Documentation`HelpLookup["paclet:ref/ScriptSizeMultipliers"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Superscript\"\>", 
       2->"\<\"SubscriptBox\"\>", 3->"\<\"SubsuperscriptBox\"\>", 
       4->"\<\"OverscriptBox\"\>", 
       5->"\<\"ScriptSizeMultipliers\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Low-Level Notebook Structure" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelNotebookStructure"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Low-Level Notebook Structure\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["SuperscriptBox", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SuperscriptBox",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SuperscriptBox"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is the low\[Hyphen]level box representation for ",
     Cell[BoxData[
      SuperscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["y", "TI"]]], "InlineFormula"],
     " in ",
     "notebook expressions",
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->28664]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SuperscriptBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SuperscriptBox"]], "InlineFormula"],
 " is the low-level representation of ",
 Cell[BoxData[
  ButtonBox["Superscript",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Superscript"]], "InlineFormula"],
 ". Except for low-level notebook expression manipulation, ",
 Cell[BoxData[
  ButtonBox["SuperscriptBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SuperscriptBox"]], "InlineFormula"],
 " should not need to be used directly."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->9970],

Cell[TextData[{
 "Inside ",
 Cell["\\(\[Ellipsis]\\)", "InlineFormula"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SuperscriptBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SuperscriptBox"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 " can be input as ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "\[Backslash]", 
   RowBox[{"^", 
    StyleBox["y", "TI"]}]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->25608],

Cell[TextData[{
 "In a notebook a ",
 Cell[BoxData[
  ButtonBox["SuperscriptBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SuperscriptBox"]], "InlineFormula"],
 " can be created using ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["6", "KeyEvent"],
 " or ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["^", "KeyEvent"],
 ". ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 " moves out of the superscript. "
}], "Notes",
 CellID->30568],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SuperscriptBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SuperscriptBox"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 " is interpreted on input as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Power",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Power"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->19281],

Cell[TextData[{
 "The baseline of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SuperscriptBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SuperscriptBox"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 " is taken to be the baseline of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->7085],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SuperscriptBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SuperscriptBox"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 " is usually output with ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " in a smaller font than ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->9152],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ", explicit ",
 Cell[BoxData[
  ButtonBox["SuperscriptBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SuperscriptBox"]], "InlineFormula"],
 " objects are output literally. You can use ",
 Cell[BoxData[
  ButtonBox["DisplayForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DisplayForm"]], "InlineFormula"],
 " to see the display form of such objects. "
}], "Notes",
 CellID->18373]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->98344844],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->154036585],

Cell["Display a letter with a superscript:", "ExampleText",
 CellID->199545933],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SuperscriptBox", "[", 
   RowBox[{"\"\<x\>\"", ",", "\"\<3\>\""}], "]"}], "//", 
  "DisplayForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->588923719],

Cell[BoxData[
 TagBox[
  SuperscriptBox["x", "3"],
  DisplayForm]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//DisplayForm=",
 CellID->684675099]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->179292804],

Cell[TextData[{
 "A ",
 Cell[BoxData[
  ButtonBox["SuperscriptBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SuperscriptBox"]], "InlineFormula"],
 " form is typically interpreted as a power:"
}], "ExampleText",
 CellID->145883430],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToExpression", "[", 
  RowBox[{
   RowBox[{"SuperscriptBox", "[", 
    RowBox[{"\"\<x\>\"", ",", "\"\<3\>\""}], "]"}], ",", "StandardForm"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5935187],

Cell[BoxData[
 SuperscriptBox["x", "3"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->644179503]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "FullForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->159520666],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Power", "[", 
    RowBox[{"x", ",", "3"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{79, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm=",
 CellID->451406446]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->243599250],

Cell[TextData[{
 "The standard formatting for ",
 Cell[BoxData[
  ButtonBox["Power",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Power"]], "InlineFormula"],
 " expressions uses ",
 Cell[BoxData[
  ButtonBox["SuperscriptBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SuperscriptBox"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->85956211],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ToBoxes", "[", 
   RowBox[{
    RowBox[{"x", "^", "n"}], ",", "StandardForm"}], "]"}], "//", 
  "FullForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->35539747],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"SuperscriptBox", "[", 
    RowBox[{"\"\<x\>\"", ",", "\"\<n\>\""}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{170, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//FullForm=",
 CellID->224510881]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->112314192],

Cell["\<\
Display a typeset structure with a superscript on a superscript:\
\>", "ExampleText",
 CellID->51671807],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SuperscriptBox", "[", 
   RowBox[{"\"\<2\>\"", ",", 
    RowBox[{"SuperscriptBox", "[", 
     RowBox[{"\"\<2\>\"", ",", "\"\<m\>\""}], "]"}]}], "]"}], "//", 
  "DisplayForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8300476],

Cell[BoxData[
 TagBox[
  SuperscriptBox["2", 
   SuperscriptBox["2", "m"]],
  DisplayForm]], "Output",
 ImageSize->{23, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//DisplayForm=",
 CellID->32370141]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->28396],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Superscript",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Superscript"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SubscriptBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SubscriptBox"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SubsuperscriptBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SubsuperscriptBox"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OverscriptBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OverscriptBox"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ScriptSizeMultipliers",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ScriptSizeMultipliers"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->7572]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->28652],

Cell[TextData[ButtonBox["Representing Textual Forms by Boxes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RepresentingTextualFormsByBoxes"]], "Tutorials",\

 CellID->8194],

Cell[TextData[ButtonBox["String Representation of Boxes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StringRepresentationOfBoxes"]], "Tutorials",
 CellID->187054374],

Cell[TextData[ButtonBox["Formatted Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FormattedOutput"]], "Tutorials",
 CellID->444657240]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Low-Level Notebook Structure",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelNotebookStructure"]], "MoreAbout",
 CellID->851255970]
}, Open  ]],

Cell["New in 3  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SuperscriptBox - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 25, 26.8148900}", "context" -> "System`", 
    "keywords" -> {
     "\\sp (TeX)", "^", "superscript", "upper script", "exponent", "power", 
      "factorial power", "falling factorial", "rising factorial"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "SuperscriptBox[x, y] is the low-level box representation for x^y in \
notebook expressions. ", "synonyms" -> {"superscript box"}, "title" -> 
    "SuperscriptBox", "type" -> "Symbol", "uri" -> "ref/SuperscriptBox"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[12627, 374, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->98344844]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21116, 698}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2692, 63, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3315, 90, 4198, 83, 70, "ObjectNameGrid"],
Cell[7516, 175, 727, 24, 70, "Usage",
 CellID->28664]
}, Open  ]],
Cell[CellGroupData[{
Cell[8280, 204, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8758, 221, 704, 20, 70, "Notes",
 CellID->9970],
Cell[9465, 243, 495, 20, 70, "Notes",
 CellID->25608],
Cell[9963, 265, 566, 20, 70, "Notes",
 CellID->30568],
Cell[10532, 287, 663, 26, 70, "Notes",
 CellID->19281],
Cell[11198, 315, 392, 15, 70, "Notes",
 CellID->7085],
Cell[11593, 332, 449, 17, 70, "Notes",
 CellID->9152],
Cell[12045, 351, 545, 18, 70, "Notes",
 CellID->18373]
}, Closed]],
Cell[CellGroupData[{
Cell[12627, 374, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->98344844],
Cell[CellGroupData[{
Cell[13011, 388, 148, 5, 70, "ExampleSection",
 CellID->154036585],
Cell[13162, 395, 79, 1, 70, "ExampleText",
 CellID->199545933],
Cell[CellGroupData[{
Cell[13266, 400, 187, 6, 28, "Input",
 CellID->588923719],
Cell[13456, 408, 220, 8, 50, "Output",
 CellID->684675099]
}, Open  ]],
Cell[13691, 419, 125, 3, 70, "ExampleDelimiter",
 CellID->179292804],
Cell[13819, 424, 238, 8, 70, "ExampleText",
 CellID->145883430],
Cell[CellGroupData[{
Cell[14082, 436, 226, 7, 70, "Input",
 CellID->5935187],
Cell[14311, 445, 181, 6, 36, "Output",
 CellID->644179503]
}, Open  ]],
Cell[CellGroupData[{
Cell[14529, 456, 100, 3, 70, "Input",
 CellID->159520666],
Cell[14632, 461, 347, 13, 50, "Output",
 CellID->451406446]
}, Open  ]],
Cell[14994, 477, 125, 3, 70, "ExampleDelimiter",
 CellID->243599250],
Cell[15122, 482, 359, 13, 70, "ExampleText",
 CellID->85956211],
Cell[CellGroupData[{
Cell[15506, 499, 196, 7, 70, "Input",
 CellID->35539747],
Cell[15705, 508, 373, 13, 50, "Output",
 CellID->224510881]
}, Open  ]],
Cell[16093, 524, 125, 3, 70, "ExampleDelimiter",
 CellID->112314192],
Cell[16221, 529, 114, 3, 70, "ExampleText",
 CellID->51671807],
Cell[CellGroupData[{
Cell[16360, 536, 262, 8, 70, "Input",
 CellID->8300476],
Cell[16625, 546, 244, 9, 52, "Output",
 CellID->32370141]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16930, 562, 311, 9, 70, "SeeAlsoSection",
 CellID->28396],
Cell[17244, 573, 1253, 44, 70, "SeeAlso",
 CellID->7572]
}, Open  ]],
Cell[CellGroupData[{
Cell[18534, 622, 314, 9, 70, "TutorialsSection",
 CellID->28652],
Cell[18851, 633, 178, 4, 70, "Tutorials",
 CellID->8194],
Cell[19032, 639, 172, 3, 70, "Tutorials",
 CellID->187054374],
Cell[19207, 644, 146, 3, 70, "Tutorials",
 CellID->444657240]
}, Open  ]],
Cell[CellGroupData[{
Cell[19390, 652, 299, 8, 70, "MoreAboutSection"],
Cell[19692, 662, 165, 3, 70, "MoreAbout",
 CellID->851255970]
}, Open  ]],
Cell[19872, 668, 50, 0, 70, "History"],
Cell[19925, 670, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

